﻿
:setvar DatabaseName "Registry"
:setvar MajorReleaseNumber "2"
:setvar MinorReleaseNumber "0"

set noexec off;

set ansi_nulls, ansi_padding, ansi_warnings, arithabort, concat_null_yields_null, quoted_identifier on;

set numeric_roundabort off;

print 'Post Deployment Script for Registry.AHOBPR.Database.PostDeploy.2.0.32.sql
 ';
print 'Started ' + CAST(getdate() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO
  
use [$(DatabaseName)];

GO
PRINT 'Starting Load_STD_SERVICE_OCCUPATION....';
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 1...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('1A','JSTARS E8-C Systems Operator'),
('1B','Sexual Harassment/Assault Response & Prevention (SHARP) Level I'),
('1C','Satellite Systems/Network Coordinator'),
('1D','Digital Media Collector (DMC)'),
('1E','Knowledge Management Professional'),
('1F','Intelligence Master Analyst'),
('1H','Sexual Harassment/Assault Response & Prevention (SHARP) Level II'),
('1J','Operational Electronic Warfare Operations'),
('1K','Counter Radio Controlled Improvised Explosive Device EW (CREW) Master Gunner'),
('1M','Emergency Medical Ministry (EMM)'),
('1S','Suicide Intervention Trainer'),
('1X','Green Belt in Lean Six Sigma (LSS)'),
('1Y','Black Belt in Lean Six Sigma (LSS)'),
('1Z','Master Black Belt in Lean Six Sigma (LSS)'),
('2A','Non-Lethal Capabilities Planner'),
('2B','Air Assault'),
('2C','JAVELIN Gunnery'),
('2G','Information Systems Security Monitroring (ISSM)'),
('2S','Battle Staff Operations'),
('2T','TENCAP Data Analyst'),
('3C','Operational Contract Support (OCS)'),
('3Y','Space Enabler'),
('4A','Reclassification Training'),
('4B','Reclassification Training'),
('4D','Tactical Exploitation of National Capabilities (TENCAP) Data Analyst'),
('4N','Health Care Recruiter'),
('4R','Transition NCO'),
('4T','Tactical Exploitation Systems Integrator/Maintainer'),
('5A','Joint Air Tactical Operations'),
('5C','Mission Command Digital Master Gunner (MCDMG)'),
('5E','Battle Command Systems Integrator Course (BCSIC)'),
('5J','Technical Escorting'),
('5U','Tactical Air Operations'),
('5W','Jumpmaster'),
('5Y','Field Artillery Surveyor/Meteorological Crewmember'),
('6B','Reconnaissance and Surveillance Leaders Course'),
('6C','Battalion Level Command Sergeant Major (CSM) Experience'),
('6Q','Additional Duty Safety NCO'),
('6S','Initial Level Sergeant Major (SGM) Experience'),
('6T','Military Auditor'),
('7C','Brigade Level Command Sergeant Major (CSM) Experience'),
('7D','Assignment Oriented Training (AOT)'),
('7E','Assignment Oriented Training (AOT)'),
('7G','Red Team Leader'),
('7J','Red Team Member'),
('7S','Primary Level Sergeant Major (SGM) Experience'),
('7Y','Capabilities Development'),
('8A','Identification Friend or Foe (IFF) Repairer'),
('8A','Battalion Level Command Sergeant Major (CSM) Experience'),
('8B','Brigade Level Command Sergeant Major (CSM) Experience'),
('8C','General Officer Level 1 Command Sergeant Major (CSM) Experience'),
('8D','General Officer Level 2 Command Sergeant Major (CSM) Experience'),
('8E','General Officer Level 3 Command Sergeant Major (CSM) Experience'),
('8F','General Officer Level 4 Command Sergeant Major (CSM) Experience'),
('8J','Master Resilience Trainer-Facilitator'),
('8K','Master Resilience Trainer-Assistant Primary Instructor'),
('8L','Master Resilience Trainer-Primary Instructor'),
('8P','Competitive Parachutist'),
('8R','Master Resilience Trainer (MRT)'),
('8S','Senior Level 1 Sergeant Major (SGM) Experience'),
('8T','Senior Level 2 Sergeant Major (SGM) Experience'),
('8U','Senior Level 3 Sergeant Major (SGM) Experience'),
('8V','Senior Level 4 Sergeant Major (SGM) Experience'),
('9B','Coronet or Trumpet Player'),
('9C','Euphonium Player'),
('9D','French Horn Player'),
('9E','Trombone Player'),
('9F','Tuba Player'),
('9G','Flute Player'),
('9H','Oboe Player'),
('9J','Clarinet Player'),
('9K','Bassoon Player'),
('9L','Saxophone Player'),
('9M','Percussion Player'),
('9N','Keyboard Player'),
('9T','Guitar Player'),
('9U','Electric Bass Player'),
('9V','Vocalist'),
('9X','Music Support Technician'),
('A1','M270A1 Multiple Launch Rocket System (MLRS)/High Mobility Artillery Rocket System (HIMARS)'),
('A2','Aviation Safety'),
('A3','Force Development (TAADS)'),
('A4','Automotive Electrical Systems Repairer'),
('A6','BRADELY M6 LINEBACKER System Maintainer'),
('A7','Field Artillery Master Gunner (FAMG)'),
('A8','Master Gunnery M1/M1A1 Tank'),
('A9','UH-60M Helicopter Qualification'),
('B1','Infantry Mortar NCO Leader'),
('B2','Light Leaders Course'),
('B3','LUH-72 Helicopter Repairer'),
('B4','Sniper'),
('B5','Standard Army Maintenance System (SAMS)'),
('B6','Combat Engineer Heavy Track'),
('B7','BRADELY Transition Course'),
('B8','Heavy Weapons Leader Course'),
('B9','BRADELY M2A3/M3A3 Operator/System Maintainer'),
('C1','General Support Band Qualified'),
('C2','DRAGON Gunnery'),
('C3','Well Drilling'),
('C4','Crane Operator'),
('C5','Court Reporter'),
('C7','Unit Level Logistics System-Aviation (Enhanced) ULLS-A(E) Tech Supply'),
('C8','Transcribing/Gisting'),
('C9','MAST and Electric Power Plant Maintenance'),
('D1','Defense Message System (DMS)/Tactical Message System (TMS) Systems Administrator'),
('D2','Military Horseman'),
('D3','BRADELY Fighting Vehicle Operations and Maintenance'),
('D4','Aviation Generator/Aviation Ground Power Unit'),
('D5','Engineer BRADELY Operator'),
('D6','Basic Digital Network Analyst (BDNA)'),
('D7','Protective Services Specialist'),
('D8','Joint Assault Bridge (JAB)/Assault Breacher Vehicle (ABV)'),
('D9','Battlefield Spectrum Management'),
('E1','External Pilot HUNTER Unmanned Aerial Vehicle (UAV) Operator'),
('E2','Slew to Cue (STC)'),
('E3','Executive Administrative Assistant'),
('E4','Cyber Mission Force Service'),
('E4','Attache Administrative Support'),
('E5','Instrument Maintenance (Power Station)'),
('E6','Interactive On-Net Operator'),
('E7','PROPHET Ground Systems Operator'),
('E8','Explosive Ordnance Clearance Agent'),
('E9','M901 (ITV) Gunner/Crew Training'),
('F1','Biological Integrated Detection System (BIDS)/Joint Biological Point Detection System (JBPDS) Repairer'),
('F2','Nationally Registered Flight Paramedic'),
('F3','Aero-Medical Evacuation (Rotary Wing)'),
('F4','Postal Supervisor'),
('F5','Postal Operations'),
('F6','Nuclear, Biological, Chemical Reconnaissance Vehicle (NBC-RV) Sensor Suite Repairer'),
('F7','Pathfinder'),
('F8','Flight Simulator (UH1FS) Console Operations'),
('F9','Advanced Field Artillery Tactical Data System (AFATDS)'),
('G1','Contracting Agent'),
('G2','Standard Army Retail Supply System (SARSS 2AD/2AC/2B)'),
('G3','Standard Property Book System'),
('G5','Lithographer'),
('G7','C-23 Load Master/Flight Engineer'),
('G8','Future Cargo Aircraft'),
('G9','Technical Surveillance Countermeasures (TSCM)'),
('H1','Meteorological Equipment Maintenance'),
('H2','Laundry System Specialist'),
('H3','Physical Security Operations'),
('H5','Global Command and Control (GCCS) System Administrator'),
('H7','Petroleum Vehicle Operations'),
('H8','Recovery Operations'),
('H9','High Mobility Artillery Rocket System (HIMARS) Repairer'),
('I1','Reserve Component Combat Arms Specialized Training'),
('I2','Reserve Component Combat Support Specialized Training'),
('I3','Reserve Component Combat Service Support Specialized Training'),
('J1','Telemetry Collection Operations'),
('J2','Communications Cable and Antenna Systems Maintainer'),
('J3','BRADELY Infantry Fighting Vehicle (BIFV) System Master Gunner'),
('J4','Measurement and Signatures Intelligence (MASINT) Collection and Analyst Course'),
('J5','Technical Escorting'),
('J6','Reproduction Equipment Repairer'),
('J7','WHCA Console Control Operations'),
('J8','National OPELINT Analyst'),
('J9','TOW Field Test Set (TFTS), (TOW-Ground)'),
('K1','Special Operations Aviation Non-rated Crewmember'),
('K2','Advanced Communications Signals Analysis'),
('K3','PROPHET Analyst'),
('K4','M1A2 Tank Operations and Maintenance'),
('K6','Combat Engineer Special Search Dog Handler'),
('K7','AVENGER Master Gunner'),
('K8','Master Gunnery M1A2 Tank'),
('K9','Combat Engineer Mine Detection Dog Handler'),
('L1','Chemical, Biological, Radiological and Nuclear (CBRN) Reconnaissance and Surveillance (R&S)'),
('L1','Master Fox Scout'),
('L2','Chemical, Biological, Radiological and Nuclear (CBRN) Responder'),
('L3','Technical Escorting'),
('L4','Biological Integrated Detection System (BIDS)'),
('L5','M93 Series Chemical, Biological, Radiological and Nuclear (CBRN) Reconnaissance System Fox'),
('L6','Chemical, Biological, Radiological and Nuclear (CBRN) Reconnaissance for Brigade Combat Teams'),
('L7','Joint Fires Observer'),
('L8','Joint Operational Fires and Effects (JOFE)'),
('M1','Deployable, Computed Axial Tomography (CAT) Scan, Computed Tomography (CT) (imaging technique) Maintainer and Repairer'),
('M2','Cytology Specialty'),
('M3','Dialysis'),
('M7','Intermediate (Inter) Analysis'),
('M8','Drug and Alcohol Counseling'),
('N1','Aircraft Crewmember Standardization Instruction'),
('N2','Nondestructive Test Equipment'),
('N6','Cryptologic Cyber Analyst'),
('N7','Strategic Debriefer'),
('N8','Sustainment Automation Support Management Office (SASMO)'),
('P4','Tactical Information Operations'),
('P5','Master Fitness Trainer'),
('P7','Digital Forensic Examiner (DFE)'),
('P9','Biological Sciences Assistant'),
('Q1','PATRIOT Advanced Capabilities (PAC) III System'),
('Q2','Aviation Life Support Equipment (ALSE)'),
('Q3','Echelon Above Division (EAD) High-to-Medium Altitude Air Defense (HIMAD) System'),
('Q4','Joint Tactical Ground Station Operator'),
('Q5','Special Forces Combat Diving, Medical'),
('Q7','Intelligence, Surveillance, and Reconnaissance (ISR) Synchronization Manager'),
('Q8','Tactical Air Operations'),
('Q9','Traffic Management and Collision Investigator'),
('R1','Rough Terrain Cargo Handler (RTCH)'),
('R2','M981 Fire Support Team Vehicle (FIST\V)'),
('R4','STRYKER Armored Vehicle Operations/Maintenance'),
('R6','Special Reaction Team (SRT) Member'),
('R7','Army Reconnaissance'),
('R8','Mobile Gun System Master Gunner'),
('S1','Source Handler'),
('S2','Mechanical Equipment Maintenance (Power Station)'),
('S3','Electrical Equipment Maintenance (Power Station)'),
('S4','Sapper Leader'),
('S5','Community Imagery Analysis Course (CIAC)'),
('S6','Special Forces Combat Diving, Supervision'),
('S7','Foreign Counterintelligence (FCI)'),
('S9','Joint Spectrum Management'),
('T1','Counter Threat Finance Analyst'),
('T1','Enhanced Position Location and Reporting System (EPLRS) Net Control Station (NCS) and Enhanced Ground Reference Unit (EGRU) Operator-Maintainer'),
('T2','Enhanced Position Location and Reporting System (EPLRS) Network Management (ENM) Enhanced Grid Reference Unit (EGRU) Operator-Maintainer Net Control Station (NCS-A)'),
('T3','Ground-based Midcourse Defense (GMD) System'),
('T4','PATRIOT Master Gunner'),
('T5','Target Digital Network Analyst'),
('T6','Tactical Exploitation System (TES)'),
('T7','Ground Reconnaissance Specialist'),
('T8','Civil Operations Specialist'),
('T9','Criminal Analysis Specialist'),
('U1','M1A2 ABRAMS Tank and BRADELY M2A3/M3A3 DS/GS Maintenance'),
('U2','SHADOW Unmanned Aerial Vehicle (UAV) Repair'),
('U3','HUNTER Unmanned Aerial Vehicle (UAV) Repair'),
('U4','Power Line Distribution'),
('U5','Extended Range Multi-Purpose (ERMP) Unmanned Aerial Vehicle (UAV)'),
('U6','Field Artillery Weapons Maintenance'),
('U8','Asymmetric Warfare Operational Support'),
('U9','Asymmetric Warfare Operational Specialist'),
('V1','M1A1 ABRAMS Integrated Management (AIM) Tank System Maintainer'),
('V2','Heavy Assault Bridge (HAB) System Maintainer'),
('V3','Aerial Precision Geo-Location (APG)'),
('V4','Advanced Source Handler'),
('V5','Military Police Investigation'),
('V7','Guidance Counseling'),
('V8','Special Technical Operations (STO) Noncommissioned Officer (NCO) Planner'),
('V9','Special Technical Operations (STO) Noncommissioned Officer (NCO)'),
('W1','Special Operations Combat Medic (SOCOM)'),
('W2','Civil Affairs Medical Sergeant'),
('W3','Special Forces Sniper'),
('W4','Civil Affairs Trauma Medical Sergeant'),
('W5','OH-58D Qualification'),
('W6','Weapons Intelligence Specialist'),
('W7','Special Forces Underwater Operations'),
('W8','Special Forces Military Free Fall Operations'),
('X1','AH-64 Maintenance'),
('X3','Operations Support Specialist'),
('X8','THAAD Launcher Operator/Maintainer'),
('Y1','Transition'),
('Y2','Transition'),
('Y3','Transition'),
('Y6','Cardiovascular Specialist'),
('Y7','Sensor Manager Operations'),
('Y8','Immunology and Allergy Specialist'),
('Y9','Warrior Transition Unit/Community Based Warrior Transition Unit (WTU/CBWTU) Squad Leader/Platoon Sergeant (SL/PSG)'),
('Z2','Automatic Message Switching Center Operations'),
('Z4','Automatic Message Switching Center Operations and Maintenance'),
('Z5','Enlisted Aide'),
('Z6','Military Working Dog (MWD) Handler'),
('Z7','Specialized Search Dog (SSD) Handler'),
('Z8','Technical ELINT Collection and Analysis'),
('1B','Sexual Harassment/Assault Response & Prevention (SHARP) Level I'),
('1D','Imagery Intelligence Officer'),
('1E','Knowledge Management Professional'),
('1H','Sexual Harassment/Assault Response & Prevention (SHARP) Level II'),
('1J','Operational Electronic Warfare Operations'),
('1K','Tactical Electronic Warfare Operations'),
('1S','Suicide Intervention Trainer'),
('1X','Green Belt in Lean Six Sigma (LSS)'),
('1Y','Black Belt in Lean Six Sigma (LSS)'),
('1Z','Master Black Belt in Lean Six Sigma (LSS)'),
('2A','Non-Lethal Capabilities Planner'),
('2B','Air Assault'),
('3A','Joint Duty Assignment Qualified'),
('3C','Operational Contract Support (OCS)'),
('3D','Government Contract and Fiscal Law Specialist'),
('3E','Tactical Exploitation of National Capabilities (TENCAP)'),
('3F','National Systems Development Program'),
('3G','Claims/Litigation Specialist'),
('3H','Joint Planner'),
('3I','Basic Military Justice Practitioner'),
('3J','M1A2 ABRAMS Tank'),
('3K','Joint Command, Control and Communications (C3)'),
('3L','Joint Qualified Officer'),
('3M','Senior Military Justice Practitioner'),
('3N','International Law Specialist'),
('3P','Expert Military Justice Practitioner'),
('3Q','Strategic Debriefer and Interrogator'),
('3R','Force Management'),
('3S','Unit Air Movements Officer'),
('3T','Master Military Justice Practitioner'),
('3W','NSA Junior Officer Cryptologic Career Program'),
('3X','Bradley Leaders'),
('3Y','Space Enabler'),
('3Z','Mortar Unit Officer'),
('4B','Operations Research/Systems Analysis'),
('4D','Tactical Exploitation of National Capabilities (TENCAP)'),
('4H','Branch Automation Officer'),
('4J','Postal'),
('4K','Artificial Intelligence'),
('4M','Army Acquisition Corps Candidate Officer'),
('4N','Health Care Recruiter'),
('4P','Security Assistance'),
('4S','Attache'),
('4T','Recruiting Officer (RO)'),
('4V','Mortuary Affairs Officer'),
('4W','Underwater Special Operations'),
('4X','Military Free Fall Special Operations'),
('4Z','Certified Army Acquisition Corps Officer'),
('5A','Joint Air Tactical Operations Officer'),
('5B','Visual Information'),
('5C','Mission Command Digital Master Gunner (MCDMG)'),
('5D','Radio Frequency Manager'),
('5E','Battle Command Systems Integrator Course (BCSIC)'),
('5H','Nuclear Target Analyst'),
('5J','Technical Escort'),
('5K','Instructor'),
('5L','Nuclear/Chemical (N/C) Reconnaissance'),
('5N','Inspector General'),
('5P','Parachutist'),
('5Q','Pathfinder'),
('5R','Ranger'),
('5S','Ranger-Parachutist'),
('5T','Equal Opportunity Advisor'),
('5U','Air Operations Officer'),
('5V','Marine Engineer Diving Officer'),
('5W','Jumpmaster'),
('5X','Historian'),
('5Y','Civil Defense Officer'),
('6A','Defense Sensor Interpretation and Application Training Program (DSIATP)'),
('6B','Battalion S6 Officer'),
('6C','Economist'),
('6D','Public Education Officer'),
('6E','Civil Supply Officer'),
('6F','Public Transportation Officer'),
('6G','Public Facilities Officer'),
('6H','Public Safety Officer'),
('6J','Psychological Operations Staff Planner'),
('6K','Civil Military Operations Staff Planner'),
('6L','Nuclear/Biological/Chemical (NBC) Reconnaissance'),
('6M','Mobilization and Demobilization Operation'),
('6N','Brigade S6 Officer'),
('6P','Master Fitness Trainer'),
('6Q','Additional Duty Safety Officer'),
('6R','Public Communications Officer'),
('6S','Advanced Military Studies Programs'),
('6T','Military Auditor'),
('6U','Agricultural Officer'),
('6V','Cultural Affairs Officer'),
('6W','Archivist'),
('6X','Army Research Associates Program'),
('6Y','Installation Management (IM)'),
('6Z','Strategic Studies Graduate'),
('7B','Terminal High Altitude Area Defense (THAAD) Follow-On'),
('7E','Chaplain Education and Training'),
('7F','Pastoral Coordinator'),
('7G','Red Team Leader'),
('7H','Upper Extremity Musculoskeletal Evaluation'),
('7J','Red Team Member'),
('7K','Marriage and Family Ministries'),
('7L','Family Ministry Pastoral Skills Specialist'),
('7M','Chaplain Resource Manager'),
('7Q','Training Development'),
('7R','Hospital Ministries'),
('7S','Combat Medical Pastoral Care Specialist'),
('7Y','Capabilities Development'),
('8B','Behavioral Science Consultation to Interrogation and Detention Operations'),
('8H','Clinical Investigation and Research Regulatory Oversight'),
('8J','Infection Control'),
('8J','Master Resilience Trainer-Facilitator'),
('8K','Master Resilience Trainer-Assistant Primary Instructor (API)'),
('8L','Master Resilience Trainer-Primary Instructor'),
('8R','Master Resilience Trainer (MRT)'),
('8T','Blood Banking'),
('8X','Army Medical Department Acquisition Officer'),
('8Z','Medical Research, Development, Test and Evaluation'),
('9A','Medical Proficiency (All AMEDD Corps)'),
('9B','Medical Proficiency (MC, DC, VC, and AMSC only)'),
('9C','Medical Proficiency (MC, DC, and VC only)'),
('9D','Medical Proficiency (MC, DC, and VC only)'),
('9E','Medical Proficiency (MC and DC only)'),
('9F','Medical Proficiency (MC and DC only)'),
('9I','Health Facilities Planner'),
('A2','OH-58A/C Scout Pilot'),
('A3','OH-58D Scout Pilot'),
('A4','OH-58D Warrior Pilot'),
('A6','RAH-66 Comanche Pilot'),
('A6','ARH-70A Pilot'),
('B1','UH-1 Pilot'),
('B2','UH-60 Pilot'),
('B3','UH-60M Pilot'),
('B4','UH-72A Pilot'),
('B5','EH-60 Pilot'),
('C1','Cyber Leader Development Program (CLDP)'),
('C2','CH-47D Pilot'),
('C3','CH-47F Pilot'),
('D2','Military Horseman'),
('D2','AH-1Q/S Pilot'),
('D5','AH-64A Pilot'),
('D7','AH-64D Pilot'),
('D9','AH-64E Pilot'),
('E3','C-20 Pilot'),
('E4','Cyber Mission Force Service'),
('E5','C-12 Pilot'),
('E8','C-26 Pilot'),
('E9','FCA-XX Pilot'),
('F3','RC-12 Pilot'),
('F4','RC-12K/N Pilot (GUARDRAIL Common Sensor)'),
('F5','O-5A/EO-5B/RC-7 Pilot'),
('G5','Engineering Test Pilot'),
('G6','Maintenance Test Pilot'),
('G6','Aviation Maintenance Officer'),
('G7','Aviation Related'),
('G8','Aviation Safety Officer'),
('G9','Multi-Aircraft Aviation Officer'),
('I1','Reserve Component Combat Arms Specialized Training'),
('I2','Reserve Component Combat Support Specialized Training'),
('I3','Reserve Component Combat Service Support Specialized Training'),
('K4','Special Operations Aviation (SOA)'),
('K5','MH-60 Pilot'),
('K6','MH-47E/G Pilot'),
('K9','Special Operations Support'),
('L1','Chemical, Biological, Radiological, and Nuclear (CBRN) Reconnaissance and Surveillance (R&S)'),
('L3','Technical Escort'),
('L5','M93 Series Chemical, Biological, Radiological and Nuclear (CBRN) Reconnaissance System Fox'),
('L5','Nuclear/Chemical (N/C) Reconnaissance'),
('L6','Chemical, Biological, Radiological and Nuclear (CBRN) Reconnaissance for Brigade Combat Teams'),
('L7','Joint Fires Observer (JFO)'),
('L8','Joint Operational Fires and Effects (JOFE)'),
('M1','Orthopedic Physician Assistant'),
('M2','Emergency Medicine Physician Assistant'),
('M3','Aviation Medicine Physician Assistant'),
('M6','Survival, Evasion, Resistance and Escape (SERE) Psychologist'),
('M7','Diving Medical Officer'),
('M9','Case Management Nurse'),
('N2','Clinical Informatics Officer'),
('N3','Registered Nurse First Assistant'),
('N4','Environmental Engineer'),
('N5','Forensic Behavioral Science Officer'),
('N6','Pain Medicine'),
('N7','Aeromedical Psychologist'),
('N9','Cyberspace Operations Planner'),
('P1','Theater Logistics (TLOG) Planners Program'),
('P4','Tactical Information Operations'),
('Q4','Joint Tactical Ground Station Operator'),
('Q7','Intelligence, Surveillance, and Reconnaissance (ISR) Synchronization Manager'),
('R1','Chemical, Biological, Radiological and Nuclear (CBRN) Responder'),
('R4','Stryker Armor Vehicle Operations/Maintenance'),
('R7','Army Reconnaissance'),
('R8','Petroleum and Water Officer'),
('R9','Aerial Delivery and Materiel Officer (ADMO)'),
('S1','AMEDD Special Operations Officer'),
('S4','Sapper Leader'),
('S7','Simulation Operations'),
('T1','Counter Threat Finance Analyst'),
('T3','Ground-based Midcourse Defense (GMD) System'),
('T4','Air Defense Artillery Fire Coordination Officer (ADAFCO)'),
('T5','PATRIOT Top Gun'),
('T6','Tactical Exploitation Systems (TES)'),
('T7','Ground Reconnaissance Specialist'),
('T8','Civil Operations Specialist'),
('T9','Criminal Analysis Specialist'),
('U8','Asymmetric Warfare Operational Support'),
('U9','Asymmetric Warfare Operational Specialist'),
('V3','Aerial Precision Geo-Location (APG)'),
('V8','Special Technical Operations (STO) Planner'),
('V9','Special Technical Operations (STO) Chief'),
('W1','Facilities Planner'),
('W2','Geospatial Engineer Officer'),
('W3','Professional Engineer (PE)'),
('W4','Degreed Engineer'),
('W5','Project Management Professional (PMP)'),
('W6','Project Engineer'),
('W7','Environmental Officer'),
('X3','Operations Support Specialist'),
('Y7','Sensor Manager Operations'),
('Z3','Sleep Medicine'),
('1B','Sexual Harassment/Assault Response & Prevention (SHARP) Level I'),
('1D','Digital Media Collector (DMC)'),
('1E','Knowledge Management Professional'),
('1H','Sexual Harassment/Assault Response & Prevention (SHARP) Level II'),
('1J','Operational Electronic Warfare Operations'),
('1K','Tactical Electronic Warfare Operations'),
('1S','Suicide Intervention Trainer'),
('1X','Green Belt in Lean Six Sigma (LSS)'),
('1Y','Black Belt in Lean Six Sigma (LSS)'),
('1Z','Master Black Belt in Lean Six Sigma (LSS)'),
('2B','Air Assault'),
('3C','Operational Contract Support Course (OCSC)'),
('3E','Satellite Communications System Repair Technician'),
('3R','Force Management'),
('3Y','Space Enabler'),
('4D','Tactical Exploitation of National Capabilities Operations Technician'),
('4J','Postal'),
('4W','Underwater Special Forces'),
('4X','Military Free Fall Special Forces'),
('5A','Joint Air Tactical Operations Officer'),
('5C','Mission Command Digital Master Gunner (MCDMG)'),
('5E','Battle Command Systems Integrator Course (BCSIC)'),
('5H','Nuclear Target Analyst'),
('5U','Air Operations Officer'),
('5W','Jumpmaster'),
('6B','General Safety Technician'),
('6D','PATRIOT Direct Support/General Support Maintenance Technician'),
('6M','Mobilization and Demobilization Operations'),
('6N','THAAD Launching Control Station (LCS)'),
('6P','Master Fitness Trainer'),
('6Q','Additional Duty Safety Officer'),
('6T','Military Auditor'),
('7A','THAAD Fire Control and Communications (TFCC)/Radar Operator/Maintainer'),
('7G','Red Team Leader'),
('7J','Red Team Member'),
('7Q','Training Development'),
('7Y','Capabilities Development'),
('8J','Master Resilience Trainer-Facilitator'),
('8K','Master Resilience Trainer-Assistant Primary Instructor'),
('8L','Master Resilience Trainer-Primary Instructor'),
('8R','Master Resilience Trainer (MRT)'),
('9A','Defense Sensor Interpretation and Application Training Program (DSIATP) Technician'),
('9C','Tactical Exploitation of National Capabilities Operations Technician'),
('9E','Senior Economic Crime Investigator'),
('9N','Strategic Debriefer/Interrogator'),
('A2','OH-58A/C Scout Pilot'),
('A3','OH-58D Scout Pilot'),
('A4','OH-58D Warrior Pilot'),
('A6','ARH-70A Pilot'),
('A6','RAH-66 Comanche Pilot'),
('B1','UH-1 Pilot'),
('B2','UH-60 Pilot'),
('B3','UH-60M Pilot'),
('B4','UH-72A Pilot'),
('B5','EH-60 Pilot'),
('C2','CH-47D Pilot'),
('C3','CH-47F Pilot'),
('D2','AH-1 Pilot'),
('D2','Military Horseman'),
('D5','AH-64A Pilot'),
('D7','AH-64D Pilot'),
('D9','AH-64E Pilot'),
('E1','UC-35 Pilot'),
('E3','C-20 Pilot'),
('E4','Cyber Mission Force Service'),
('E5','C-12 Pilot'),
('E7','C-23 Pilot'),
('E8','C-26 Pilot'),
('E9','FCA-XX Pilot'),
('F3','RC-12D/G/H Pilot'),
('F4','RC-12K/N Pilot (Guardrail Common Sensor)'),
('F5','O-5A/EO-5B/RC-7 Pilot'),
('G2','Instructor Pilot'),
('G7','Aviation Related'),
('G8','Aviation Safety Officer'),
('G9','Multi-Aircraft Aviation Officer'),
('H1','Aircraft Armament Maintenance Officer'),
('H2','Aviation Life Support Equipment Officer'),
('H3','Aircrew Survivability Equipment and Electronic Warfare Officer'),
('H4','Aeromedical Evacuation Pilot'),
('H8','Aviation Master Gunner'),
('I1','Reserve Component Combat Arms Specialized Training'),
('I2','Reserve Component Combat Support Specialized Training'),
('I3','Reserve Component Combat Service Support Specialized Training'),
('J4','Measurement and Signatures Intelligence (MASINT) Collection and Analyst Course'),
('K4','Special Operations Aviation'),
('K5','MH-60 Pilot'),
('K6','MH-47E/G Pilot'),
('K9','Special Operations Support'),
('L3','Technical Escorting'),
('N7','Strategic Debriefer'),
('N8','Sustainment Automation Support Management Office (SASMO)'),
('N9','Cyberspace Operations Planner'),
('P4','Tactical Information Operations'),
('P7','Digital Forensic Examiner (DFE)'),
('Q1','Interactive On-Net Operator'),
('Q2','Target Digital Network Analyst'),
('Q3','Cryptologic Cyber Analyst'),
('Q4','Joint Tactical Ground Station Operator'),
('Q7','Intelligence, Surveillance and Reconnaissance (ISR) Synchronization Manager'),
('R1','Rough Terrain Cargo Handler (RTCH)'),
('R4','STRYKER Armored Vehicle Operations/Maintenance'),
('T1','Counter Threat Finance Analyst'),
('T2','Joint Interface Control Officer'),
('T3','Ground-based Midcourse Defense (GMD) System'),
('T4','Air Defense Artillery Fire Control Officer'),
('T5','PATRIOT Top Gun'),
('T6','Tactical Exploitation Systems (TES)'),
('T7','Ground Reconnaissance Specialist'),
('T8','Civil Operations Specialist'),
('T9','Criminal Analysis Specialist'),
('U1','M1A2 Abrams Tank and Bradley M2A3/M3A3 DS/GS Maintenance'),
('U8','Asymmetric Warfare Operational Support'),
('U9','Asymmetric Warfare Operational Specialist'),
('V3','Aerial Precision Geo-Location (APG)'),
('V8','Special Technical Operations (STO) Planner'),
('V9','Special Technical Operations (STO) Chief'),
('X3','Operations Support Specialist'),
('Y7','Sensor Manager Operations'),
('2','Training Development'),
('4','Non-Career Recruiter'),
('6','Mobilization and Demobilization Operations'),
('7','Attache'),
('A','Manual Morse Operator'),
('B','Inspector General Noncommissioned Officer'),
('C','Regimental Reconnaissance Course-Unit Operator'),
('D','Civil Affairs Operations'),
('E','Military Mountaineer'),
('F','Flying Status'),
('G','Ranger'),
('I','Installer'),
('L','Linguist'),
('M','First Sergeant'),
('N','Joint Planner'),
('O','No Special Qualifications'),
('P','Parachutist'),
('Q','Equal Opportunity Advisor (EOA)'),
('R','Chemical, Biological, Radiological and Nuclear (CBRN) Responder'),
('T','1st SFOD-D Unit Operator'),
('U','75th Ranger Regiment Leader'),
('V','Ranger Parachutist'),
('W','Special Forces Advanced Reconnaissance, Target Analysis and Exploitation Techniques (SFARTAET)'),
('X','Drill Sergeant (DS)'),
('Y','Advanced Individual Training Platoon Sergeant (AITPSG)'),
('0','No Special Qualifications'),
('1','Marine Deck Officer'),
('2','Marine Engineering Officer'),
('5','Power Systems Technician'),
('7','Parachutist'),
('8','Instructor'),
('B','Aviation Safety Officer'),
('C','Instructor Pilot'),
('D','Aeromedical Evacuation Pilot'),
('E','Aircraft Armament Maintenance Technician'),
('F','Senior Instructor Pilot and Instrument Flight Examiner'),
('G','Aviation Maintenance Officer'),
('H','Standardization Instructor Pilot'),
('I','Tactical Operations Officer'),
('J','Engineering Test Pilot'),
('K','Polygraph Examiner'),
('L','Maintenance Test Flight Evaluator'),
('P','Parachutist'),
('R','Chemical, Biological, Radiological and Nuclear (CBRN) Responder'),
('T','Transition'),
('W','Technical Surveillance Countermeasure Technician'),
('Z','Research, Development, Test and Evaluation Technician'),
('111','Professional Development (General), Sailing, Inshore skipper'),
('112','Professional Development (General), Sailing, Racing Inshore'),
('113','Professional Development (General), Sailing, Offshore skipper'),
('114','Professional Development (General), Sailing, Master skipper'),
('115','Professional Development (General), Sailing, Instructor'),
('211','Professional Development (General), Scholarship, Burke Scholar'),
('212','Professional Development (General), Scholarship, CNO Scholar'),
('213','Professional Development (General), Scholarship, Daedalian Scholar'),
('214','Professional Development (General), Scholarship, Fulbright Scholar'),
('215','Professional Development (General), Scholarship, Guggenheim Scholar'),
('216','Professional Development (General), Scholarship, Hertz Scholar'),
('217','Professional Development (General), Scholarship, Morrison Scholar'),
('218','Professional Development (General), Scholarship, National Science Foundation Program'),
('219','Professional Development (General), Scholarship, Olmsted Scholar'),
('221','Professional Development (General), Scholarship, Rhodes Scholar'),
('222','Professional Development (General), Scholarship, Winston Churchill Foundation'),
('223','Professional Development (General), Scholarship, Other Scholarship'),
('224','Professional Development (General), Scholarship, Faculty'),
('225','Professional Development (General), Scholarship, Physical Education Staff'),
('226','Professional Development (General), Scholarship, Conrad Scholar'),
('227','Professional Development (General), Scholarship, Executive Analysis for the Warfare Commander Certificate'),
('229','Professional Development (General), Scholarship, Operational Law Graduate'),
('231','Professional Development (General), Scholarship, JCS Intern'),
('233','Professional Development (General), Scholarship, White House Fellowship'),
('234','Professional Development (General), Scholarship, Legislative Fellowship'),
('235','Professional Development (General), Scholarship, Legislative Fellow Utilization Assignment'),
('240','Professional Development (General), Scholarship, Politico-Military Affairs'),
('241','Professional Development (General), Scholarship, Asia �Pacific Graduate'),
('242','Professional Development (General), Scholarship, Western Hemisphere'),
('243','Professional Development (General), Scholarship, Graduate of Africa Studies Concentration Program'),
('244','Professional Development (General), Scholarship, Graduate of Middle East Studies Concentration Program'),
('245','Professional Development (General), Scholarship, Graduate of Corporate Strategic Planning elective cluster'),
('246','Professional Development (General), Scholarship, Graduate of EURASIA Studies Concentration Program'),
('247','Professional Development (General), Scholarship, Theater/National Strategic Planner'),
('248','Professional Development (General), Scholarship, Graduate of Insurgency and Terrorism Elective Cluster'),
('249','Professional Development (General), Scholarship, Graduate of Information Operations, Command and Control and battle space Awareness elective cluster'),
('24A','Professional Development (General), Scholarship, Politico-Military Masters Scholar'),
('24B','Professional Development (General), Scholarship, Arthur S Moreau Scholar'),
('24C','Professional Development (General), Scholarship, Federal Executive Fellow'),
('24D','Professional Development (General), Scholarship, Hudson Fellow'),
('24E','Professional Development (General), Scholarship, CFR Navy Fellow'),
('24F','Professional Development (General), Scholarship, SECDEF Corporate Fellow'),
('251','Professional Development (General), Strategic Studies Group, Fellow'),
('252','Professional Development (General), Strategic Studies Group, Associate Fellow'),
('261','Professional Development (General), Leadership Training Courses, Instructor'),
('271','Professional Development (General), Scholarship, Halsey Group Alfa'),
('272','Professional Development (General), Scholarship, Halsey Group Bravo'),
('273','Professional Development (General), Scholarship, Gravely Naval Warfare Research Group'),
('274','Professional Development (General), Scholarship, Halsey Group X-Ray'),
('275','Professional Development (General), Scholarship, Mahan Scholars'),
('276','Professional Development (General), Scholarship, Homeland Security/Homeland Defense (HS/HD)'),
('2A1','Professional Development (General), Permanent Military Professor, Permanent Military Professor (Select)'),
('2A2','Professional Development (General), Permanent Military Professor, Permanent Military Professor (Qualified)'),
('2A3','Professional Development (General), Permanent Military Professor, JPMP Select'),
('2A4','Professional Development (General), Permanent Military Professor, JPMP Qualified'),
('2B1','Professional Development (General), Industrial College of the Armed Forces, Supply Chain Management Concentration Program'),
('2C1','Professional Development (General), Continuous Process Improvement (CPI), Green Belt Certified'),
('2C2','Professional Development (General), Continuous Process Improvement (CPI), Black Belt Certified'),
('2D1','Professional Development (General), Command Qualification Program, Eligible'),
('2D2','Professional Development (General), Command Qualification Program, Command Qualified'),
('2D3','Professional Development (General), Command Qualification Program, Major Command Qualified'),
('3A1','Intelligence, Targeting, USN Targeting Officer'),
('3A2','Intelligence, Targeting, Joint Targeting School Graduate'),
('3CS','Intelligence, Intelligence Officer, Paygrade O-5, Sea Duty Eligible'),
('3H1','Intelligence, Intelligence Officer, qualified in HUMINT, Navy HUMINT'),
('3H2','Intelligence, Intelligence Officer, qualified in HUMINT, Naval Attache'),
('3H3','Intelligence, Intelligence Officer, qualified in HUMINT, Defense HUMINT'),
('3H9','Intelligence, Intelligence Officer, qualified in HUMINT, Strategic Debriefing Course Graduate'),
('3I1','Intelligence, Intelligence, Basic Qualification'),
('3I2','Intelligence, Intelligence, Intermediate Qualification'),
('3I3','Intelligence, Intelligence, Advanced Qualification'),
('3M1','Intelligence, Intelligence Officer, Force Management, Intelligence MPTE Planning'),
('3M2','Intelligence, Intelligence Officer, Force Management, Intelligence Resource Management'),
('3M3','Intelligence, Intelligence Officer, Force Management, Intelligence Adaptive/ Campaign Planning'),
('3M4','Intelligence, Intelligence Officer, Force Management, Intelligence Integrated Component Operations'),
('3M5','Intelligence, Intelligence Officer, Force Management, Senior Intelligence Program Manager'),
('3Q1','Intelligence, Intelligence Officer, qualified in support to special warfare, NSW Intelligence'),
('3Q2','Intelligence, Intelligence Officer, qualified in support to special warfare, NSW Intelligence Resources'),
('3Q3','Intelligence, Intelligence Officer, qualified in support to special warfare, Special Operations Forces Intelligence'),
('3R1','Intelligence, Intelligence Officer, qualified in ISR Management, Collection Manager'),
('3R2','Intelligence, Intelligence Officer, qualified in ISR Management, Collection / ISR Requirements Management'),
('3R3','Intelligence, Intelligence Officer, qualified in ISR Management, ISR Architecture Management'),
('3R4','Intelligence, Intelligence Officer, qualified in ISR Management, ISR Architecture Resource Management'),
('3R8','Intelligence, Intelligence Officer, qualified in ISR Management, ISRT Architecture Management Graduate'),
('3R9','Intelligence, Intelligence Officer, qualified in ISR Management, Navy Collection Management Course Graduate'),
('4AJ','Legal Services, Appelate Judge'),
('4AK','Legal Services, Lawyer, Alaska Bar'),
('4AL','Legal Services, Lawyer, Alabama Bar'),
('4AR','Legal Services, Lawyer, Arkansas Bar'),
('4AZ','Legal Services, Lawyer, Arizona Bar'),
('4CA','Legal Services, Lawyer, California Bar'),
('4CO','Legal Services, Lawyer, Colorado Bar'),
('4CT','Legal Services, Lawyer, Connecticut Bar'),
('4DC','Legal Services, Lawyer, District of Columbia Bar'),
('4DE','Legal Services, Lawyer, Delaware Bar'),
('4FL','Legal Services, Lawyer, Florida Bar'),
('4GA','Legal Services, Lawyer, Georgia Bar'),
('4GU','Legal Services, Lawyer, Guam Bar'),
('4HI','Legal Services, Lawyer, Hawaii Bar'),
('4IA','Legal Services, Lawyer, Iowa Bar'),
('4ID','Legal Services, Lawyer, Idaho Bar'),
('4IL','Legal Services, Lawyer, Illinois Bar'),
('4IN','Legal Services, Lawyer, Indiana Bar'),
('4KS','Legal Services, Lawyer, Kansas Bar'),
('4KY','Legal Services, Lawyer, Kentucky Bar'),
('4LA','Legal Services, Lawyer, Louisiana Bar'),
('4LE','Legal Services, Military Justice Litigation Expert (LIT EXP)'),
('4LS','Legal Services, Military Justice Litigation Specialist (LIT SPEC)'),
('4MA','Legal Services, Lawyer, Massachusetts Bar'),
('4MD','Legal Services, Lawyer, Maryland Bar'),
('4ME','Legal Services, Lawyer, Maine Bar'),
('4MI','Legal Services, Lawyer, Michigan Bar'),
('4MJ','Legal Services, Military Judge'),
('4MN','Legal Services, Lawyer, Minnesota Bar'),
('4MO','Legal Services, Lawyer, Missouri Bar'),
('4MS','Legal Services, Lawyer, Mississippi Bar'),
('4MT','Legal Services, Lawyer, Montana Bar'),
('4NC','Legal Services, Lawyer, North Carolina Bar'),
('4ND','Legal Services, Lawyer, North Dakota Bar'),
('4NE','Legal Services, Lawyer, Nebraska Bar'),
('4NH','Legal Services, Lawyer, New Hampshire Bar'),
('4NI','Legal Services, National Security - Intelligence Law (INTEL LAW)'),
('4NJ','Legal Services, Lawyer, New Jersey Bar'),
('4NM','Legal Services, Lawyer, New Mexico Bar'),
('4NS','Legal Services, National Security - Cyber Law (CYBER LAW)'),
('4NV','Legal Services, Lawyer, Nevada Bar'),
('4NY','Legal Services, Lawyer, New York Bar'),
('4OH','Legal Services, Lawyer, Ohio Bar'),
('4OK','Legal Services, Lawyer, Oklahoma Bar'),
('4OR','Legal Services, Lawyer, Oregon Bar'),
('4PA','Legal Services, Lawyer, Pennsylvania Bar'),
('4PR','Legal Services, Lawyer, Puerto Rico Bar'),
('4RI','Legal Services, Lawyer, Rhode Island Bar'),
('4SC','Legal Services, Lawyer, South Carolina Bar'),
('4SD','Legal Services, Lawyer, South Dakota Bar'),
('4TN','Legal Services, Lawyer, Tennessee Bar'),
('4TX','Legal Services, Lawyer, Texas Bar'),
('4UT','Legal Services, Lawyer, Utah Bar'),
('4VA','Legal Services, Lawyer, Virginia Bar'),
('4VI','Legal Services, Lawyer, Virgin Islands Bar'),
('4VT','Legal Services, Lawyer, Vermont Bar'),
('4WA','Legal Services, Lawyer, Washington Bar'),
('4WI','Legal Services, Lawyer, Wisconsin Bar'),
('4WV','Legal Services, Lawyer, West Virginia Bar'),
('4WY','Legal Services, Lawyer, Wyoming Bar')
               )
       AS MasterRecord(CODE, TITLE)
       )
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 2...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('500','Chaplain Corps Denominations, Roman Catholic'),
('501','Chaplain Corps Denominations, Jewish'),
('502','Chaplain Corps Denominations, The Episcopal Church'),
('503','Chaplain Corps Denominations, Orthodox'),
('504','Chaplain Corps Denominations, Associated Gospel Churches'),
('505','Chaplain Corps Denominations, American Council of Christian Churches'),
('506','Chaplain Corps Denominations, Assemblies of God'),
('507','Chaplain Corps Denominations, Christian Church (Disciples of Christ)'),
('508','Chaplain Corps Denominations, Christian Science'),
('509','Chaplain Corps Denominations, Churches of Christ'),
('510','Chaplain Corps Denominations, Church of Jesus Christ of Latter-Day Saints'),
('511','Chaplain Corps Denominations, Church of the Nazarene'),
('512','Chaplain Corps Denominations, Independent Fundamental Church of America'),
('513','Chaplain Corps Denominations, National Fellowship of Brethren Churches'),
('514','Chaplain Corps Denominations, Plymouth Brethren'),
('516','Chaplain Corps Denominations, Reorganized Church of Jesus Christ of Latter-Day Saints'),
('517','Chaplain Corps Denominations, Church of God General Conference'),
('518','Chaplain Corps Denominations, Brethren Church'),
('519','Chaplain Corps Denominations, United Church of Christ'),
('520','Chaplain Corps Denominations, Church of God of Prophecy'),
('521','Chaplain Corps Denominations, Church of God in Christ'),
('522','Chaplain Corps Denominations, Pentecostal Church of God in North America'),
('523','Chaplain Corps Denominations, Baptist Bible Fellowship'),
('524','Chaplain Corps Denominations, American Baptist Association'),
('525','Chaplain Corps Denominations, American Baptist Churches'),
('526','Chaplain Corps Denominations, General Association of Regular Baptists'),
('527','Chaplain Corps Denominations, Southern Baptist'),
('528','Chaplain Corps Denominations, General Associaton of General Baptists'),
('529','Chaplain Corps Denominations, Baptist Missionary Association of America'),
('530','Chaplain Corps Denominations, African Methodist Episcopal'),
('531','Chaplain Corps Denominations, Christian Methodist Episcopal Church'),
('532','Chaplain Corps Denominations, African Methodist Episcopal Zion'),
('533','Chaplain Corps Denominations, Baptist General Conference'),
('534','Chaplain Corps Denominations, Christian Reformed Church'),
('535','Chaplain Corps Denominations, Church of God (Anderson, Indiana)'),
('536','Chaplain Corps Denominations, Church of God in North America'),
('537','Chaplain Corps Denominations, Evangelical Convenant Church in America'),
('538','Chaplain Corps Denominations, Free Will Baptist'),
('539','Chaplain Corps Denominations, Moravian'),
('540','Chaplain Corps Denominations, National Association of Congregational Christian Churches'),
('541','Chaplain Corps, CHC Milestone Assignment, Commander'),
('541','Chaplain Corps Denominations, National Baptist Convention of America'),
('542','Chaplain Corps, CHC Milestone Assignment, Captain'),
('542','Chaplain Corps Denominations, National Baptist Convention in the U.S.A.'),
('543','Chaplain Corps, CHC Milestone Assignment, Captain'),
('543','Chaplain Corps Denominations, Reformed Church in America'),
('544','Chaplain Corps, CHC Milestone Assignment, Captain'),
('544','Chaplain Corps Denominations, Progressive National Baptist Convention, Inc.'),
('545','Chaplain Corps, CHC Milestone Assignment, Captain'),
('545','Chaplain Corps Denominations, Seventh-Day Adventist'),
('546','Chaplain Corps, CHC Milestone Assignment, Captain'),
('546','Chaplain Corps Denominations, Unitarian Universalist Association'),
('547','Chaplain Corps Denominations, Salvation Army'),
('547','Chaplain Corps, CHC Milestone Assignment, Commander'),
('548','Chaplain Corps, CHC Milestone Assignment, Commander'),
('548','Chaplain Corps Denominations, Liberal Catholic Church'),
('549','Chaplain Corps, CHC Milestone Assignment, Commander'),
('549','Chaplain Corps Denominations, Evangelical Congregation Church'),
('550','Chaplain Corps Denominations, National Association of Baptist Churches'),
('551','Chaplain Corps Denominations, Pentecostal Assemblies of the World'),
('552','Chaplain Corps Denominations, United Pentecostal Church International'),
('554','Chaplain Corps Denominations, Elim Fellowship'),
('555','Chaplain Corps Denominations, North American Baptist Conference'),
('556','Chaplain Corps Denominations, Bible Presbyterian Church'),
('557','Chaplain Corps Denominations, Church of the Living God'),
('558','Chaplain Corps Denominations, International Council of Community Churches'),
('559','Chaplain Corps Denominations, Evangelical Methodist Church'),
('55F','Chaplain Corps, Fleet Marine Force (FMF), Qualified'),
('560','Chaplain Corps Denominations, Christian and Missionary Alliance'),
('561','Chaplain Corps Denominations, Christian Churches and Churches of Christ'),
('562','Chaplain Corps Denominations, Church of United Brethren in Christ'),
('563','Chaplain Corps Denominations, Central Bible Church'),
('564','Chaplain Corps Denominations, Conservative Baptist Association in America'),
('565','Chaplain Corps Denominations, Conservative Congregational Christian Conference'),
('566','Chaplain Corps Denominations, Evangelical Free Church of America'),
('567','Chaplain Corps Denominations, Kansas Yearly Meeting of Friends'),
('568','Chaplain Corps Denominations, International Church of Foursquare Gospel'),
('569','Chaplain Corps Denominations, Open Bible Standard Church'),
('570','Chaplain Corps Denominations, Pentecostal Church of God in America'),
('571','Chaplain Corps Denominations, Pentecostal Holiness Church'),
('572','Chaplain Corps Denominations, Missionary Church Association'),
('573','Chaplain Corps Denominations, Church of God (Cleveland, Tennessee)'),
('574','Chaplain Corps Denominations, Presbyterian Church in America'),
('575','Chaplain Corps Denominations, The Missionary Church'),
('576','Chaplain Corps Denominations, Churches of Christ in Christian Union'),
('577','Chaplain Corps Denominations, Full Gospel Fellowship of Church and Ministry International'),
('578','Chaplain Corps Denominations, Pentecostal Free Will Baptist Church, Inc.'),
('579','Chaplain Corps Denominations, Chapaincy Full Gospel Churches'),
('580','Chaplain Corps Denominations, Presbyterian Church, USA'),
('581','Chaplain Corps Denominations, Associated Reformed Presbyterian'),
('582','Chaplain Corps Denominations, Westgate Chapel'),
('583','Chaplain Corps Denominations, Cumberland Presbyterian'),
('584','Chaplain Corps Denominations, Orthodox Presbyterian'),
('585','Chaplain Corps Denominations, Reformed Presbyterian Church of North America'),
('588','Chaplain Corps Denominations, Reformed Episcopal Church'),
('589','Chaplain Corps Denominations, Liberty Baptist Fellowship'),
('590','Chaplain Corps Denominations, United Methodist'),
('591','Chaplain Corps Denominations, Free Methodist of North America'),
('592','Chaplain Corps Denominations, Primitive Methodist'),
('593','Chaplain Corps Denominations, Wesleyan'),
('595','Chaplain Corps Denominations, Conservative Lutheran Association'),
('596','Chaplain Corps Denominations, Evangelical Lutheran Church in America'),
('597','Chaplain Corps Denominations, United Episcopal Church of North America'),
('598','Chaplain Corps Denominations, Anglican Catholic Church'),
('599','Chaplain Corps Denominations, Lutheran Church, Missouri Synod'),
('5AC','Chaplain Corps, Adventist, Advent Christian Church'),
('5AG','Chaplain Corps, Adventist, Advent Christian General Conference'),
('5AJ','Chaplain Corps, Adventist, Jehovah�s Witness'),
('5AM','Chaplain Corps, Adventist, Church of God, General Conference (Morrow, GA)'),
('5AS','Chaplain Corps, Adventist, General Conference of Seventh-Day Adventists United States'),
('5AV','Chaplain Corps, Adventist, Adventist Churches'),
('5BA','Chaplain Corps, Baptist, American Baptist Churches in the USA'),
('5BB','Chaplain Corps, Baptist, Baptist Churches'),
('5BC','Chaplain Corps, Baptist, Southern Baptist Convention'),
('5BD','Chaplain Corps, Baptist, New Testament Association of Independent Baptist Churches'),
('5BE','Chaplain Corps, Baptist, Conservative Baptist Association of America'),
('5BF','Chaplain Corps, Baptist, National Association of Free Will Baptists'),
('5BG','Chaplain Corps, Baptist, General Association of General Baptists'),
('5BH','Chaplain Corps, Baptist, Alliance of Baptists in the USA, Inc.'),
('5BI','Chaplain Corps, Baptist, Baptist General Convention of Texas'),
('5BJ','Chaplain Corps, Baptist, Baptist General Conference'),
('5BK','Chaplain Corps, Baptist, Cooperative Baptist Fellowship, Inc.'),
('5BL','Chaplain Corps, Baptist, Liberty Baptist Fellowship for Church Planting, Inc.'),
('5BM','Chaplain Corps, Baptist, Baptist Missionary Association of America'),
('5BN','Chaplain Corps, Baptist, National Baptist Convention of America, Inc.'),
('5BO','Chaplain Corps, Baptist, Original Free Will Baptists Convention'),
('5BP','Chaplain Corps, Baptist, Progressive National Baptist Convention, Inc.'),
('5BQ','Chaplain Corps, Baptist, National Missionary Baptist Convention of America'),
('5BR','Chaplain Corps, Baptist, General Association of Regular Baptist Churches'),
('5BS','Chaplain Corps, Baptist, Seventh-Day Baptists General Conference USA and Canada'),
('5BT','Chaplain Corps, Baptist, North American Baptist Conference'),
('5BU','Chaplain Corps, Baptist, National Baptist Convention, USA, Inc.'),
('5BV','Chaplain Corps, Baptist, The Sovereign Grace Baptist Association of Churches'),
('5BW','Chaplain Corps, Baptist, World Baptist Fellowship, Inc.'),
('5BX','Chaplain Corps, Baptist, American Baptist Association'),
('5BY','Chaplain Corps, Baptist, National Association of Baptist Churches'),
('5CA','Chaplain Corps, Catholic, Apostolic Catholic Orthodox Church'),
('5CC','Chaplain Corps, Catholic, Catholic Churches'),
('5CH','Chaplain Corps, Catholic, Old Holy Catholic Church, Archdiocese of Christ the King'),
('5CI','Chaplain Corps, Catholic, The Independent Catholic Church International'),
('5CL','Chaplain Corps, Catholic, Liberal Catholic Church'),
('5CN','Chaplain Corps, Catholic, National Catholic Apostolic Church in the USA'),
('5CO','Chaplain Corps, Catholic, The Old Holy Catholic Church'),
('5CP','Chaplain Corps, Catholic, Polish National Catholic Church of America'),
('5CR','Chaplain Corps, Catholic, The Roman Catholic Church'),
('5CU','Chaplain Corps, Catholic, United Catholic Church of America'),
('5DL','Chaplain Corps, Latter-Day Saints, The Church of Jesus Christ of Latter-Day Saints'),
('5DR','Chaplain Corps, Latter-Day Saints, Community of Christ (Reorganized Church of Jesus Christ of Latter-Day Saints)'),
('5EA','Chaplain Corps, Episcopalian, The Anglican Catholic Church'),
('5EC','Chaplain Corps, Episcopalian, The Episcopal Church'),
('5ED','Chaplain Corps, Episcopalian, The Communion of Evangelical Episcopal Churches'),
('5EE','Chaplain Corps, Episcopalian, Episcopal Churches'),
('5EH','Chaplain Corps, Episcopalian, The Holy Catholic Church (Anglican Rite)'),
('5EI','Chaplain Corps, Episcopalian, Anglican Mission in America Chaplaincy'),
('5EK','Chaplain Corps, Episcopalian, The Anglican Church in America'),
('5EM','Chaplain Corps, Episcopalian, The Episcopal Missionary Church'),
('5EO','Chaplain Corps, Episcopalian, Orthodox Anglican Church'),
('5EP','Chaplain Corps, Episcopalian, Philippine Independent Catholic Church'),
('5EQ','Chaplain Corps, Episcopalian, Philippine Independent Catholic Church, Military Diocese'),
('5ER','Chaplain Corps, Episcopalian, The Reformed Episcopal Church'),
('5ET','Chaplain Corps, Episcopalian, Anglican Church'),
('5EU','Chaplain Corps, Episcopalian, United Episcopal Church of North America'),
('5EV','Chaplain Corps, Episcopalian, The Evangelical Episcopal Church'),
('5EX','Chaplain Corps, Episcopalian, Charismatic Episcopal Church'),
('5FA','Chaplain Corps, Fundamentalist, Independent Churches Affiliated'),
('5FB','Chaplain Corps, Fundamentalist, Independent Fundamental Bible'),
('5FC','Chaplain Corps, Fundamentalist, IFCA International'),
('5FD','Chaplain Corps, Fundamentalist, Berean Fundamental Church Council, Inc.'),
('5FE','Chaplain Corps, Fundamentalist, Evangelical Church Alliance'),
('5FF','Chaplain Corps, Fundamentalist, Fundamental Churches'),
('5FG','Chaplain Corps, Fundamentalist, Associated Gospel Churches'),
('5FH','Chaplain Corps, Fundamentalist, Fundamental Baptist Fellowship International'),
('5FI','Chaplain Corps, Fundamentalist, American Council of Christian Churches'),
('5FK','Chaplain Corps, Fundamentalist, Bible Fellowship Church'),
('5FM','Chaplain Corps, Fundamentalist, Union of Messianic Jewish Congregations'),
('5FO','Chaplain Corps, Fundamentalist, Calvary Baptist Church (All Points Baptist Mission)'),
('5FT','Chaplain Corps, Fundamentalist, Baptist Bible Fellowship International'),
('5FX','Chaplain Corps, Fundamentalist, Grace Gospel Fellowship'),
('5GC','Chaplain Corps, Restorationist, Christian Churches and Churches of Christ'),
('5GE','Chaplain Corps, Restorationist, Christian Church (Disciples of Christ)'),
('5GG','Chaplain Corps, Restorationist, Restorationist Churches'),
('5GT','Chaplain Corps, Restorationist, Tioga River Christian Conference'),
('5GX','Chaplain Corps, Restorationist, Church of Christ'),
('5HA','Chaplain Corps, Holiness, Church of God Ministries (Anderson, IN)'),
('5HC','Chaplain Corps, Holiness, Churches of Christ in Christian Union'),
('5HF','Chaplain Corps, Holiness, Free Methodist Church of North America'),
('5HG','Chaplain Corps, Holiness, Church of God (Holiness)'),
('5HH','Chaplain Corps, Holiness, Holiness Churches'),
('5HK','Chaplain Corps, Holiness, Missionary Church, Inc.'),
('5HM','Chaplain Corps, Holiness, The Wesleyan Church'),
('5HN','Chaplain Corps, Holiness, Church of the Nazarene'),
('5HS','Chaplain Corps, Holiness, Salvation Army, The'),
('5HU','Chaplain Corps, Holiness, The Church of Christ (Holiness) USA'),
('5IL','Chaplain Corps, Islamic, Islam'),
('5IM','Chaplain Corps, Islamic, American Muslim Armed Forces And Veterans Affairs Council'),
('5IN','Chaplain Corps, Islamic, Islamic Society of North America'),
('5JA','Chaplain Corps, Jewish, The Rabbinical Assembly (Conservative)'),
('5JJ','Chaplain Corps, Jewish, Judaism'),
('5JO','Chaplain Corps, Jewish, Rabbinical Council of America (Orthodox)'),
('5JP','Chaplain Corps, Jewish, Congregation Pirchei Shoshanim'),
('5JR','Chaplain Corps, Jewish, Central Conference of American Rabbis'),
('5JS','Chaplain Corps, Jewish, The Shul'),
('5JW','Chaplain Corps, Jewish, Jewish Chaplains Council (Jewish Welfare Board)'),
('5KB','Chaplain Corps, Eastern Religions, Buddhism'),
('5KC','Chaplain Corps, Eastern Religions, Buddhist Churches of America'),
('5KD','Chaplain Corps, Eastern Religions, Chinmaya Mission West'),
('5KF','Chaplain Corps, Eastern Religions, Baha�I Faith'),
('5KH','Chaplain Corps, Eastern Religions, Hinduism'),
('5KK','Chaplain Corps, Eastern Religions, Eastern Religions'),
('5LA','Chaplain Corps, Lutheran, The American Association of Lutheran Churches'),
('5LB','Chaplain Corps, Lutheran, Church of the Lutheran Brethren'),
('5LC','Chaplain Corps, Lutheran, Conservative Lutheran Association'),
('5LD','Chaplain Corps, Lutheran, Evangelical Lutheran Conference and Ministerium'),
('5LE','Chaplain Corps, Lutheran, Evangelical Lutheran Church in America'),
('5LF','Chaplain Corps, Lutheran, Association of Free Lutheran Congregations'),
('5LI','Chaplain Corps, Lutheran, Lutheran Congregations in Mission for Christ'),
('5LL','Chaplain Corps, Lutheran, Lutheran Churches'),
('5LM','Chaplain Corps, Lutheran, The Lutheran Church-Missouri Synod'),
('5MB','Chaplain Corps, Methodist, Church of the United Brethren in Christ'),
('5MC','Chaplain Corps, Methodist, Christian Methodist Episcopal Church'),
('5ME','Chaplain Corps, Methodist, African Methodist Episcopal Church'),
('5MG','Chaplain Corps, Methodist, Evangelical Congregational Church'),
('5MI','Chaplain Corps, Methodist, The Association of Independent Methodists'),
('5MM','Chaplain Corps, Methodist, Methodist Churches'),
('5MN','Chaplain Corps, Methodist, Free Methodist Church of North America'),
('5MP','Chaplain Corps, Methodist, Iglesia Metodista De Puerto Rico'),
('5MQ','Chaplain Corps, Methodist, Primitive Methodist'),
('5MR','Chaplain Corps, Methodist, Moravian Church In America'),
('5MS','Chaplain Corps, Methodist, The Southern Methodist Church'),
('5MT','Chaplain Corps, Methodist, The Congregational Methodist Church'),
('5MU','Chaplain Corps, Methodist, The United Methodist Church'),
('5MV','Chaplain Corps, Methodist, The Evangelical Methodist Church'),
('5MZ','Chaplain Corps, Methodist, African Methodist Episcopal Zion Church'),
('5NA','Chaplain Corps, Independent Denomination, American Missionary Fellowship'),
('5NB','Chaplain Corps, Independent Denomination, Communion of Convergence Churches, Inc'),
('5ND','Chaplain Corps, Independent Denomination, Churches of Christ'),
('5NE','Chaplain Corps, Independent Denomination, Christian Evangelical Churches of America, Inc.'),
('5NF','Chaplain Corps, Independent Denomination, Church of God in North America'),
('5NK','Chaplain Corps, Independent Denomination, Korean Evangelical Church of America'),
('5NM','Chaplain Corps, Independent Denomination, Messianic Jewish Congregations, Union of'),
('5NN','Chaplain Corps, Independent Denomination, Missionary Church, Inc'),
('5NU','Chaplain Corps, Independent Denomination, Unaffiliated Baptist Churches of America'),
('5NW','Chaplain Corps, Independent Denomination, The World Council of Independent Christian Churches'),
('5OA','Chaplain Corps, Orthodox, American Carpatho-Russian Orthodox Greek Catholic Church'),
('5OB','Chaplain Corps, Orthodox, Standing Conference of Canonical Orthodox Bishops'),
('5OC','Chaplain Corps, Orthodox, The Orthodox Church in America'),
('5OE','Chaplain Corps, Orthodox, Eastern Orthodox Churches'),
('5OF','Chaplain Corps, Orthodox, Federated Orthodox Catholic Churches United Sacramentally'),
('5OG','Chaplain Corps, Orthodox, Greek Orthodox Archdiocese of Vasiloupolis'),
('5OI','Chaplain Corps, Orthodox, Federated Orthodox Catholic Churches International'),
('5ON','Chaplain Corps, Orthodox, Antiochian Orthodox Christian Archdiocese of North America'),
('5OO','Chaplain Corps, Orthodox, Orthodox Churches'),
('5OR','Chaplain Corps, Orthodox, Syro-Russian Orthodox Catholic Church (Romano Byzantine Synod)'),
('5OS','Chaplain Corps, Orthodox, Serbian Orthodox Church in the USA and Canada'),
('5OU','Chaplain Corps, Orthodox, Ukrainian Orthodox Church of the USA'),
('5OX','Chaplain Corps, Orthodox, Syrian Eastern Orthodox Exarchate in America'),
('5PA','Chaplain Corps, Pentecostal/Charismatic I, General Council of Assemblies of God'),
('5PB','Chaplain Corps, Pentecostal/Charismatic I, Full Gospel Baptist Church Fellowship, Inc.'),
('5PC','Chaplain Corps, Pentecostal/Charismatic I, The Church of God in Christ, Inc.'),
('5PD','Chaplain Corps, Pentecostal/Charismatic I, Full Gospel'),
('5PE','Chaplain Corps, Pentecostal/Charismatic I, Elim Fellowship'),
('5PF','Chaplain Corps, Pentecostal/Charismatic I, International Church of the Foursquare Gospel'),
('5PG','Chaplain Corps, Pentecostal/Charismatic I, The Church of God of Prophecy'),
('5PH','Chaplain Corps, Pentecostal/Charismatic I, Pentecostal Holiness Church, International'),
('5PI','Chaplain Corps, Pentecostal/Charismatic I, Church of Our Lord Jesus Christ of the Apostolic Faith, Inc'),
('5PJ','Chaplain Corps, Pentecostal/Charismatic I, Pentecostal Church of God, Inc. (Joplin, MO)'),
('5PK','Chaplain Corps, Pentecostal/Charismatic I, Grace Churches International'),
('5PL','Chaplain Corps, Pentecostal/Charismatic I, Full Gospel Fellowship of Churches and Ministers International'),
('5PM','Chaplain Corps, Pentecostal/Charismatic I, Bethel Ministerial Association, Inc.'),
('5PO','Chaplain Corps, Pentecostal/Charismatic I, Global Network of Christian Ministries'),
('5PP','Chaplain Corps, Pentecostal/Charismatic I, Pentecostal Churches'),
('5PQ','Chaplain Corps, Pentecostal/Charismatic I, Pentecostal Churches of the Apostolic Faith Association'),
('5PR','Chaplain Corps, Pentecostal/Charismatic I, Church On The Rock International'),
('5PS','Chaplain Corps, Pentecostal/Charismatic I, Open Bible Standard Churches, Inc.'),
('5PT','Chaplain Corps, Pentecostal/Charismatic I, Church of God (Cleveland, TN)'),
('5PU','Chaplain Corps, Pentecostal/Charismatic I, United Pentecostal Church International'),
('5PV','Chaplain Corps, Pentecostal/Charismatic I, Vineyard Christian Fellowship Church of Cobb County, Inc'),
('5PW','Chaplain Corps, Pentecostal/Charismatic I, Pentecostal Assemblies of the World, Inc.'),
('5PX','Chaplain Corps, Pentecostal/Charismatic I, Calvary Chapel of Costa Mesa'),
('5PX','Chaplain Corps, Pentecostal/Charismatic I, Calvary Chapel of Mira Mesa'),
('5PY','Chaplain Corps, Pentecostal/Charismatic I, The United Pentecostal Churches of Christ'),
('5PZ','Chaplain Corps, Pentecostal/Charismatic I, Association of Evangelical Gospel Assemblies Ministries International, Inc.'),
('5QA','Chaplain Corps, Brethren/Quaker, The Brethren Church, (Ashland, OH)'),
('5QB','Chaplain Corps, Brethren/Quaker, Brethren Churches'),
('5QE','Chaplain Corps, Brethren/Quaker, Evangelical Friends Church International'),
('5QF','Chaplain Corps, Brethren/Quaker, Friends (Quakers)'),
('5QG','Chaplain Corps, Brethren/Quaker, National Fellowship of Grace Brethren Churches'),
('5QK','Chaplain Corps, Brethren/Quaker, Kansas Yearly Meeting of Friends'),
('5QQ','Chaplain Corps, Brethren/Quaker, European Free Churches'),
('5QS','Chaplain Corps, Brethren/Quaker, Schwenkfelder Churches'),
('5RA','Chaplain Corps, Ref/Pres/Cong, The Associate Reformed Presbyterian Church'),
('5RB','Chaplain Corps, Ref/Pres/Cong, The Cumberland Presbyterian Church'),
('5RC','Chaplain Corps, Ref/Pres/Cong, National Association of Congregational Christian Churches'),
('5RD','Chaplain Corps, Ref/Pres/Cong, Christian Reformed Church in North America'),
('5RF','Chaplain Corps, Ref/Pres/Cong, Reformed Church in America'),
('5RG','Chaplain Corps, Ref/Pres/Cong, Churches of God, General Conference'),
('5RI','Chaplain Corps, Ref/Pres/Cong, Presbyterian Church in America'),
('5RJ','Chaplain Corps, Ref/Pres/Cong, Bible Presbyterian Church (General Synod)'),
('5RK','Chaplain Corps, Ref/Pres/Cong, Korean Presbyterian Church of America'),
('5RM','Chaplain Corps, Ref/Pres/Cong, The Cumberland Presbyterian Church in America'),
('5RN','Chaplain Corps, Ref/Pres/Cong, Reformed Presbyterian Church of North America'),
('5RO','Chaplain Corps, Ref/Pres/Cong, The Orthodox Presbyterian Church'),
('5RP','Chaplain Corps, Ref/Pres/Cong, The Presbyterian Church (USA)'),
('5RQ','Chaplain Corps, Ref/Pres/Cong, Conservative Congregational Christian Conference'),
('5RR','Chaplain Corps, Ref/Pres/Cong, Reformed and Presbyterian Churches'),
('5RS','Chaplain Corps, Ref/Pres/Cong, The Congregational Christian Church in American Samoa'),
('5RU','Chaplain Corps, Ref/Pres/Cong, United Church of Christ'),
('5RV','Chaplain Corps, Ref/Pres/Cong, Evangelical Presbyterian Church'),
('5RW','Chaplain Corps, Ref/Pres/Cong, International Council of Community Churches'),
('5RX','Chaplain Corps, Ref/Pres/Cong, Korean-American Presbyterian Church'),
('5RY','Chaplain Corps, Ref/Pres/Cong, Presbyterian and Reformed Joint Commission on Chaplains'),
('5RZ','Chaplain Corps, Ref/Pres/Cong, Presbyterian Conference for Chaplains and Military'),
('5SC','Chaplain Corps, Scientist, The First Church of Christ, Scientist'),
('5SR','Chaplain Corps, Scientist, United Church of Religious Science'),
('5SU','Chaplain Corps, Scientist, Association of Unity Churches'),
('5TA','Chaplain Corps, Non-Denominational Independent, St Andrews Evangelical Church'),
('5TB','Chaplain Corps, Non-Denominational Independent, Cedar Mill Bible Churc'),
('5TC','Chaplain Corps, Non-Denominational Independent, Church of the Living God'),
('5TD','Chaplain Corps, Non-Denominational Independent, The Woodfield Church'),
('5TE','Chaplain Corps, Non-Denominational Independent, Evangel Fellowship International'),
('5TF','Chaplain Corps, Non-Denominational Independent, Central Bible Church'),
('5TG','Chaplain Corps, Non-Denominational Independent, Community Church of Greenwood, Inc.'),
('5TK','Chaplain Corps, Non-Denominational Independent, Columbia Bible Church'),
('5TM','Chaplain Corps, Non-Denominational Independent, Camelback Bible Church'),
('5TP','Chaplain Corps, Non-Denominational Independent, Grace Place'),
('5TR','Chaplain Corps, Non-Denominational Independent, Coral Ridge Christian Fellowship'),
('5TU','Chaplain Corps, Non-Denominational Independent, Westgate Chapel'),
('5TW','Chaplain Corps, Non-Denominational Independent, Westside Christian Family Chapel'),
('5TX','Chaplain Corps, Non-Denominational Independent, Christ Community Church'),
('5UU','Chaplain Corps, Unitarian, The Unitarian Universalist Association'),
('5VA','Chaplain Corps, Evangelical, Asbury Bible Churches'),
('5VB','Chaplain Corps, Evangelical, Plymouth Brethren'),
('5VE','Chaplain Corps, Evangelical, The Evangelical Covenant Church'),
('5VF','Chaplain Corps, Evangelical, Evangelical Free Church of America'),
('5VM','Chaplain Corps, Evangelical, Christian and Missionary Alliance'),
('5VN','Chaplain Corps, Evangelical, National Association of Evangelicals'),
('5VP','Chaplain Corps, Evangelical, Bible Protestant Church'),
('5VV','Chaplain Corps, Evangelical, Evangelical Churches'),
('5WA','Chaplain Corps, Pentecostal/ Charismatic II, Assemblies of God, International Fellowship'),
('5WB','Chaplain Corps, Pentecostal/ Charismatic I, Pentecostal Church of God, Inc'),
('5WC','Chaplain Corps, Pentecostal/ Charismatic II, Chaplaincy Full Gospel Churches, Inc.'),
('5WD','Chaplain Corps, Pentecostal/ Charismatic II, United Evangelical Churches'),
('5WE','Chaplain Corps, Pentecostal/ Charismatic II, Evangel Fellowship International'),
('5WF','Chaplain Corps, Pentecostal/ Charismatic II, Full Faith Church of Love'),
('5WG','Chaplain Corps, Pentecostal/ Charismatic II, Association of International Gospel Assemblies, Inc.'),
('5WH','Chaplain Corps, Pentecostal/ Charismatic II, Harvest Network International'),
('5WI','Chaplain Corps, Pentecostal/ Charismatic II, Christ-Immanuel Ministerial Association'),
('5WJ','Chaplain Corps, Pentecostal/ Charismatic II, Christ''s Church Fellowship'),
('5WK','Chaplain Corps, Pentecostal/ Charismatic II, Kingsway Fellowship International'),
('5WL','Chaplain Corps, Pentecostal/ Charismatic II, Liberty Fellowship of Churches And Ministers, Inc.'),
('5WM','Chaplain Corps, Pentecostal/ Charismatic II, Fellowship of Churches And Ministers International'),
('5WN','Chaplain Corps, Pentecostal/ Charismatic II, Faith Christian Fellowship International Church, Inc.'),
('5WO','Chaplain Corps, Pentecostal/ Charismatic II, Christian Church of North America'),
('5WP','Chaplain Corps, Pentecostal/ Charismatic II, International Ministerial Fellowship'),
('5WQ','Chaplain Corps, Pentecostal/ Charismatic II, Pentecostal Free Will Baptist Church, Inc'),
('5WR','Chaplain Corps, Pentecostal/ Charismatic II, Rhema Bible Church'),
('5WS','Chaplain Corps, Pentecostal/ Charismatic II, The Coalition of Spirit-Filled Churches'),
('5WT','Chaplain Corps, Pentecostal/ Charismatic II, Trinity Full Gospel Fellowship'),
('5WU','Chaplain Corps, Pentecostal/ Charismatic II, United Full Gospel Church'),
('5WV','Chaplain Corps, Pentecostal/ Charismatic II, Victory Christian Center'),
('5WW','Chaplain Corps, Pentecostal/ Charismatic II, International Convention of Faith Ministries, Inc.'),
('5WX','Chaplain Corps, Pentecostal/ Charismatic II, International Christian Church'),
('5WY','Chaplain Corps, Pentecostal/ Charismatic II, Maranatha Christian Fellowship, Inc.'),
('5WZ','Chaplain Corps, Pentecostal/ Charismatic II, New Generation Church'),
('5XC','Chaplain Corps, Unclassified, Iglesia Ni Christo'),
('5XG','Chaplain Corps, Unclassified, General Church of The New Jerusalem'),
('5XJ','Chaplain Corps, Unclassified, Churches of the New Jerusalem'),
('5YS','Chaplain Corps, Spiritualist, The Swedenborgian Church'),
('5YU','Chaplain Corps, Spiritualist, Holy Spirit Association for the Unification of World Christianity'),
('62G','Health Care Services, Any Medical Corps Specialty, Sports Medicine Specialist'),
('62H','Health Care Services, Interdepartmental, Health Promotion Coordinator'),
('62I','Health Care Services, Interdepartmental, Informatics Nursing'),
('62M','Health Care Services, Any Medical Corps Specialty, Sleep Medicine'),
('62O','Health Care Services, Interdepartmental, Ambulatory Care Nurse'),
('64A','Health Care Services, Dental, Advanced Education in General Dentistry'),
('64B','Health Care Services, Dental, General Practice Residency'),
('64C','Health Care Services, Dental, Advanced Clinical Program (ACP) in Exodontia'),
('64D','Health Care Services, Dental, Advance Clinical Program (APC) in General Dentistry'),
('64E','Health Care Services, Dental, Forensic Dentistry'),
('67A','Health Care Services, Executive Medicine Staff, Executive Medicine'),
('67B','Health Care Services, Executive Medicine Staff, Expeditionary Medicine'),
('67F','Health Care Services, Executive Medicine Staff, Reserve Liaison Officer'),
('67G','Health Care Services, Executive Medicine Staff, Managed Care Coordinator'),
('67H','Health Care Services, Executive Medicine Staff, Ambulatory Care Administration (ACA) Officer'),
('68H','Health Care Services, Any Medical Department Designator, Heath Promotion Coordinator'),
('68I','Health Care Services, Any Medical Department Designator, Health Care Management'),
('68J','Health Care Services, Any Medical Department Designator, Public Health Emergency Officer (PHEO)'),
('68K','Health Care Services, Any Medical Department Designator, Alternate Public Health Emergency Officer (APHEO)'),
('68L','Health Care Services, Any Medical Department Designator, Clinical Informatics'),
('69I','Health Care Services, Nurse Corps Related, Informatics Nursing'),
('69L','Health Care Services, Nursing, Labor, Delivery and Recovery (LDR) Experienced Nurse'),
('69O','Health Care Services, Nursing Health Care Services, Ambulatory Care Nursing'),
('69P','Health Care Services, Nursing Health Care Services, Primary Care Nurse Practitioner'),
('6AA','Health Care Services, Aviation Medicine, Aviation Medical Examiner'),
('6AB','Health Care Services, Aviation Medicine, General Flight Officer'),
('6AC','Health Care Services, Aviation Medicine, Naval Aviator (Naval Flight Officer (NFO))/Aeromedical Officer'),
('6AE','Health Care Services, Aviation Medicine, Naval Aviator (Pilot)/Aeromedical Officer'),
('6AG','Health Care Services, Aviation Medicine, Aerospace Medicine (Preventive Medicine)'),
('6AJ','Health Care Services, Aviation Medicine, Flight Nurse'),
('6AM','Health Care Services, Aviation Medicine, Aeromedical Safety Officer'),
('6AN','Health Care Services, Aviation Medicine, Aerospace Optometrist'),
('6BG','Health Care Services, Anesthesia, Cardiothoracic'),
('6BH','Health Care Services, Anesthesia, Neurosurgical'),
('6BI','Health Care Services, Anesthesia, Obstetrical'),
('6BJ','Health Care Services, Anesthesia, Pain Management'),
('6BK','Health Care Services, Anesthesia, Pediatric'),
('6BL','Health Care Services, Anesthesia, Regional Anesthesia'),
('6DD','Health Care Services, Neurological Surgery, Complex Spinal Neurological Surgery'),
('6DE','Health Care Services, Neurological Surgery, Skull Base Neurological Surgery'),
('6DF','Health Care Services, Neurological Surgery, Pediatric Neurosurgery'),
('6DG','Health Care Services, Neurological Surgery, Neurovascular Neurological Surgery'),
('6EF','Health Care Services, Obstetrics/Gynecology (OB/GYN), Obstetrics Critical Care Medicine'),
('6EG','Health Care Services, Obstetrics/Gynecology (OB/GYN), Gynecologic Oncology'),
('6EH','Health Care Services, Obstetrics/Gynecology (OB/GYN), Maternal Fetal Medicine'),
('6EI','Health Care Services, Obstetrics/Gynecology (OB/GYN), Reproductive Endocrinology'),
('6EJ','Health Care Services, Obstetrics/Gynecology (OB/GYN), Urogynecology and Pelvic Surgery'),
('6EK','Health Care Services, Obstetrics/Gynecology (OB/GYN), Gynecologic Pathology'),
('6FA','Health Care Services, Field Medicine, Marine Corps Medical Officer'),
('6FC','Health Care Services, Field Medicine, Fleet Marine Force Medical Logistics'),
('6FD','Health Care Services, Field Medicine, Surface Experienced Medical Officer'),
('6FE','Health Care Services, Field Medicine, Senior Marine Corps Staff Officer'),
('6GA','Health Care Services, Ophthalmology, Aviation Optometry'),
('6GD','Health Care Services, Ophthalmology, Comprehensive'),
('6GE','Health Care Services, Ophthalmology, Cornea and External Disease'),
('6GF','Health Care Services, Ophthalmology, Glaucoma'),
('6GG','Health Care Services, Ophthalmology, Neuro-ophthalmology/Surgical Neuro-ophthalmology'),
('6GH','Health Care Services, Ophthalmology, Oculoplastics'),
('6GI','Health Care Services, Ophthalmology, Ophthalmic Pathology Surgery'),
('6GJ','Health Care Services, Ophthalmology, Retina Vitreous Surgery'),
('6GK','Health Care Services, Ophthalmology, Strabismus'),
('6HD','Health Care Services, Orthopaedic Surgery, Foot and Ankle Surgery'),
('6HF','Health Care Services, Orthopaedic Surgery, Orthopaedic Oncology'),
('6HG','Health Care Services, Orthopaedic Surgery, Pediatric Orthopaedic Surgery'),
('6HH','Health Care Services, Orthopaedic Surgery, Spine Surgery'),
('6HI','Health Care Services, Orthopaedic Surgery, Sports Surgery'),
('6HJ','Health Care Services, Orthopaedic Surgery, Total Joint'),
('6HK','Health Care Services, Orthopaedic Surgery, Trauma Surgery'),
('6HL','Health Care Services, Orthopaedic Surgery, Oprthopaedic Physicians Assistant'),
('6ID','Health Care Services, Otolaryngology, Facial Plastics and Reconstructive Surgery'),
('6IE','Health Care Services, Otolaryngology, Head and Neck Surgery'),
('6IF','Health Care Services, Otolaryngology, Neurotology'),
('6IG','Health Care Services, Otolaryngology, Pediatric Otolaryngology'),
('6IH','Health Care Services, Otolaryngology, Laryngology'),
('6II','Health Care Services, Otolaryngology, Rhinology'),
('6JD','Health Care Services, Urologic, Endocrinologic Urologist'),
('6JE','Health Care Services, Urologic, Female Urology'),
('6JF','Health Care Services, Urologic, Infertility Urology'),
('6JG','Health Care Services, Urologic, Pediatric Urology'),
('6JH','Health Care Services, Urologic, Urinary Stone Disease'),
('6JI','Health Care Services, Urologic, Urologic Oncology'),
('6KE','Health Care Services, Preventive/Occupational Medicine, Medical Toxicology'),
('6KL','Health Care Services, Preventive/Occupational Medicine, Radiation Safety Officer`'),
('6LC','Health Care Services, Physical Medicine and Rehabilitation, Electroneuromyographic Specialist'),
('6LD','Health Care Services, Physical Medicine and Rehabilitation, Musculoskeletal Screener'),
('6LJ','Health Care Services, Physical Medicine and Rehabilitation, Upper Extremity Neuromusculoskeletal Evaluator (UENMSE)'),
('6LN','Health Care Services, Physical Medicine and Rehabilitation, Spinal Cord Rehabilitation Specialist'),
('6MA','Health Care Services, Pathology, Anatomic and Clinical'),
('6MB','Health Care Services, Pathology, Anatomic Pathologist'),
('6MC','Health Care Services, Pathology, Clinical Pathologist'),
('6MD','Health Care Services, Pathology, Blood Bank Pathologist'),
('6ME','Health Care Services, Pathology, Chemical Pathologist'),
('6MF','Health Care Services, Pathology, Cytopathologist'),
('6MG','Health Care Services, Pathology, Dermatopathologist'),
('6MH','Health Care Services, Pathology, Forensic Pathologist'),
('6MI','Health Care Services, Pathology, Hematopathologist'),
('6MJ','Health Care Services, Pathology, Immunopathologist'),
('6MK','Health Care Services, Pathology, Neuro-pathologist'),
('6ML','Health Care Services, Pathology, Surgical Pathologist'),
('6MM','Health Care Services, Pathology, Molecular Genetic Pathologist'),
('6ND','Health Care Services, Dermatology, Dermatological Immunology/Diagnostic and Laboratory Immunology'),
('6NE','Health Care Services, Dermatology, Dermatologic Surgery'),
('6NF','Health Care Services, Dermatology, Dermatopathology'),
('6NG','Health Care Services, Dermatology, Pediatric Dermatologist'),
('6NH','Health Care Services, Dermatology, Photobiologist'),
('6OB','Health Care Services, Contingency/Operational, Shipboard Assignment'),
('6OC','Health Care Services, Contingency/Operational, Hospital Ship Assignment'),
('6OE','Health Care Services, Contingency/Operational, En-route Care'),
('6OF','Health Care Services, Contingency/Operational, FDPMU (Forward Deployable preventive Medicine unit)'),
('6OH','Health Care Services, Contingency/Operational, Humanitarian Assistance/Disaster Response'),
('6ON','Health Care Services, Contingency/Operational, Medical Regulator'),
('6OR','Health Care Services, Contingency/Operational, CATF Surgeon'),
('6OS','Health Care Services, Contingency/Operational, SERE Certified Psychologist'),
('6OT','Health Care Services, Contingency/Operational, C4 Trained Plus Ortho Surg Enhancement Module'),
('6OU','Health Care Services, Contingency/Operational, Fleet Hospital Assignment'),
('6OV','Health Care Services, Contingency/Operational, Specialist in Blood Banking'),
('6OW','Health Care Services, Contingency/Operational, Trauma Team Trained Officer (TTTO)'),
('6PD','Health Care Services, Emergency Medicine, Emergency Medicine Services'),
('6PE','Health Care Services, Emergency Medicine, Medical Toxicology'),
('6PF','Health Care Services, Emergency Medicine, Pediatric Emergency Medicine'),
('6PG','Health Care Services, Emergency Medicine, Emergency Ultrasound'),
('6QF','Health Care Services, Family Practice, Obstetrics (Additional Training)'),
('6RF','Health Care Services, Internal Medicine, Allergy Immunologist DLI'),
('6RM','Health Care Services, Internal Medicine, Hepatology'),
('6RW','Health Care Services, Internal Medicine, Interventional Pulmonologist'),
('6SF','Health Care Services, Executive Medicine Staff, Reserve Administrative Officer'),
('6SG','Health Care Services, Executive Medicine Staff, Managed Care Officer'),
('6SH','Health Care Services, Executive Medicine Staff, Ambulatory Care Administration (ACA) Officer'),
('6SI','Health Care Services, Executive Medicine Staff, Credentialed Health Care Administrator (CHCA)'),
('6TD','Health Care Services, Neurology, Child Neurologist'),
('6TF','Health Care Services, Neurology, Medical Neuro-Ophthalmologist'),
('6TG','Health Care Services, Neurology, Neurophysiologist'),
('6UD','Health Care Services, Undersea Medicine, Diver'),
('6UE','Health Care Services, Undersea Medicine, Undersea Occupation Medicine'),
('6UF','Health Care Services, Undersea Medicine, Hyperbaric Medicine Researcher'),
('6UG','Health Care Services, Undersea Medicine, Hyperbaric Medicine Clinician'),
('6UM','Health Care Services, Undersea Medicine, Submarine'),
('6VF','Health Care Services, Pediatric, Allergy Immunologist DLI'),
('6VG','Health Care Services, Pediatric, Pediatric Cardiologist'),
('6VH','Health Care Services, Pediatric, Child/Sexual Abuse Specialist'),
('6VI','Health Care Services, Pediatric, Pediatric Intensivist/Critical Care'),
('6VJ','Health Care Services, Pediatric, Developmental Pediatrician'),
('6VK','Health Care Services, Pediatric, Pediatric Endocrinologist'),
('6VL','Health Care Services, Pediatric, Pediatric Gastroenterologist'),
('6VN','Health Care Services, Pediatric, Pediatric Hematologist-Oncologist'),
('6VO','Health Care Services, Pediatric, Genetic Dysmorphology'),
('6VP','Health Care Services, Pediatric, Pediatric Infectious Disease Specialist'),
('6VQ','Health Care Services, Pediatric, Pediatric Nephrology'),
('6VR','Health Care Services, Pediatric, Pediatric Pulmonologist'),
('6VS','Health Care Services, Pediatric, Pediatric Rheumtologist'),
('6VV','Health Care Services, Pediatric, Neonatologist'),
('6VW','Health Care Services, Pediatric, Toxicologist'),
('6XD','Health Care Services, Psychiatry, Addiction Psychiatry'),
('6XE','Health Care Services, Psychiatry, Administrative Psychiatry'),
('6XF','Health Care Services, Psychiatry, Adolescent Psychiatry'),
('6XG','Health Care Services, Psychiatry, Aviation Psychiatry'),
('6XH','Health Care Services, Psychiatry, Child/Adolescent Psychiatry'),
('6XI','Health Care Services, Psychiatry, Clinical Neurophysiology'),
('6XJ','Health Care Services, Psychiatry, Community/Preventive Psychiatry'),
('6XK','Health Care Services, Psychiatry, Consultation/Liaison Psychiatry'),
('6XL','Health Care Services, Psychiatry, Forensic Psychiatry'),
('6XM','Health Care Services, Psychiatry, Geriatric Psychiatry'),
('6XN','Health Care Services, Psychiatry, Research Psychiatry'),
('6YD','Health Care Services, Diagnostic Radiology, Imaging'),
('6YE','Health Care Services, Diagnostic Radiology, Interventional/Vascular Radiology'),
('6YF','Health Care Services, Diagnostic Radiology, Neuro-Radiology'),
('6YG','Health Care Services, Diagnostic Radiology, Nuclear Radiology'),
('6YI','Health Care Services, Diagnostic Radiology, Pediatric Radiologist'),
('6YK','Health Care Services, Diagnostic Radiology, Radiation Teletherapy Physicist'),
('6ZA','Health Care Services, Educational/Ethics, Instructor'),
('6ZB','Health Care Services, Educational/Ethics, Assistant Professor'),
('6ZC','Health Care Services, Educational/Ethics, Associate Professor'),
('6ZD','Health Care Services, Educational/Ethics, Full Professor'),
('6ZE','Health Care Services, Educational/Ethics, Medical Ethicist'),
('6ZF','Health Care Services, Educational/Ethics, Researcher'),
('6ZG','Health Care Services, Educational/Ethics, Residency Program Director'),
('800','Engineering Duty, Registered Professional Engineer (PROENG)'),
('900','Supply Corps, Financial Management (SC FINMGMT)'),
('901','Supply Corps, Accounting and Fiscal (SC ACTFISC)'),
('902','Supply Corps, Disbursing (SC DISBURS)'),
('903','Supply Corps, Auditing (SC AUDIT)'),
('905','Supply Corps, Systems Inventory Management (SC SYSINV)'),
('906','Supply Corps, Integrated Logistics Support (SC ILS)'),
('908','Supply Corps, Inventory Control Officer (SC INVCONT)'),
('909','Supply Corps, Allowances/Outfitting (SC ALLOW)'),
('910','Supply Corps, Food Service Operations'),
('911','Supply Corps, Food Service Officer (SC FOODSRV)'),
('913','Supply Corps, Petroleum Logistics Officer (SC PETROLOG)'),
('914','Supply Corps, Fuel Storage Officer (SC FUELSTR)'),
('916','Supply Corps, Procurement Management (SC PROCRMGT)'),
('917','Supply Corps, Contract Administration (SC CNTRADM)'),
('918','Supply Corps, Supply Corps Officer Contingency Operations Assignment'),
('919','Supply Corps, Supply Corps Officer Contingency Operations Assignment Level 2'),
('920','Supply Corps, Transportation Management (SC TRNMGT)'),
('921','Supply Corps, Traffic (SC TRAFFIC)'),
('922','Supply Corps, Terminal Operations (SC TERMOPS)'),
('923','Supply Corps, Warehousing (SC WAREHSG)'),
('924','Supply Corps, Property Disposal (SC PROPDSP)'),
('925','Supply Corps, Household Goods (SC HHG)'),
('926','Supply Corps, Computer System Management (SC CPSYSMT)'),
('927','Supply Corps, Data Processing Officer (SC DATAPRO)'),
('928','Supply Corps, Assignment to Non- Conventional Operational Tour (ASGN NCONV)'),
('929','Supply Corps, Completion of two or more Non-Conventional Operational Tours (COMP2 NCONV)'),
('92E','Supply Corps, ERP Certificate with SAP Program (ERP W SAP CERT)'),
('930','Supply Corps, OPS Research/Systems Analysis (SC OPSRSCH)'),
('933','Supply Corps, Merchandising Management (SC MRCHMGT)'),
('934','Supply Corps, Commissary Store Operations (SC COMMISS)'),
('935','Supply Corps, Commander Supply Corps Officer Sea Completed (SC CDRSEA)'),
('936','Supply Corps, Commander Supply Corps Officer Sea Assigned (SC CDRSEAASGN)'),
('937','Supply Corps, Commander Supply Corps Officer Sea Board Select (SC CDRSEABDSEL)'),
('939','Supply Corps, Ordnance Logistics Ammo (SC ORDLOG)'),
('93A','Supply Corps, Shore Command Complete (SC CMD COMP)'),
('93B','Supply Corps, Major Shore Command Complete (SC MAJCMD COMP)'),
('93E','Supply Corps, Navy Expeditionary Supply Corps Officer Warfare Qualification (NESCO)'),
('940','Supply Corps, Ship Outfitting (SC SHIPOUT)'),
('941','Supply Corps, Submarine Support (SC SUBSUPPT)'),
('942','Supply Corps, Aviation Support (SC AVSUPPT)'),
('943','Supply Corps, Joint, Interagency, International, or Multinational Operations'),
('944','Supply Corps, Cold Weather Support (SC COLDWEA)'),
('945','Supply Corps, Naval Reactors Experience'),
('946','Supply Corps, Duty in DSA (SC DSA)'),
('947','Supply Corps, Duty in Joint Activities (SC JNTACT)'),
('948','Supply Corps, Afloat "I" Duty as LCDR or Senior (SC SO AFLT)'),
('949','Supply Corps, Supply Corps School Instructor'),
('950','Civil Engineer Corps, Engineer in Training (CEC EIT)'),
('951','Civil Engineer Corps, Registered Professional Engineer (CEC PE)'),
('952','Civil Engineer Corps, Registered Architect (CEC RA)'),
('960','Civil Engineer Corps, Seabee Combat Warfare (SCW)'),
('970','Civil Engineer Corps, Business Credit Attainment (CEC BCA)'),
('A1A','Acquisition, Shore Command, Complete O-5 Shore Command'),
('A1B','Acquisition, Shore Command, Complete Non-Major O-6 Shore Command'),
('A1C','Acquisition, Shore Command, Complete Major Shore Command'),
('A2A','Acquisition, Major Program Manager, Complete Non-Major Program Manager'),
('A2B','Acquisition, Major Program Manager, Complete'),
('A2E','Acquisition, Major Program Manager, Eligible'),
('AA0','Acquisition, Program Management, Not Certified'),
('AA1','Acquisition, Program Management, Level 1 Career Field Certified'),
('AA2','Acquisition, Program Management, Level 2 Career Field Certified'),
('AA3','Acquisition, Program Management, Level 3 Career Field Certified'),
('AAC','Acquisition, Program Management, Critical Acquisition Billet'),
('AAD','Acquisition, Program Management, Developmental'),
('AAG','Acquisition, Program Management, Waiver Experience'),
('AAG','Acquisition, Program Management, Waiver Experience'),
('AAJ','Acquisition, Program Management, Waiver Education'),
('AAJ','Acquisition, Program Management, Waiver Education'),
('AAK','Acquisition, Program Management, Key Leadership Position'),
('AAM','Acquisition, Program Management, Fully Qualified'),
('AAN','Acquisition, Program Management, Non-Critical Acquisition Billet'),
('AB1','Acquisition, Business - Cost Estimating, Level 1 Career Field Certified'),
('AB2','Acquisition, Business - Cost Estimating, Level 2 Career Field Certified'),
('AB3','Acquisition, Business - Cost Estimating, Level 3 Career Field Certified'),
('ABC','Acquisition, Business - Cost Estimating, Critical Acquisition Billet'),
('ABK','Acquisition, Business - Cost Estimating, Key Leadership Position'),
('ABN','Acquisition, Business - Cost Estimating, Non-Critical Acquisition Billet'),
('AC0','Acquisition, Contracting, Not Certified'),
('AC1','Acquisition, Contracting, Level 1 Career Field Certified'),
('AC2','Acquisition, Contracting, Level 2 Career Field Certified'),
('AC3','Acquisition, Contracting, Level 3 Career Field Certified'),
('ACC','Acquisition, Contracting, Critical Acquisition Billet'),
('ACD','Acquisition, Contracting, Developmental'),
('ACG','Acquisition, Contracting, Waiver Experience'),
('ACG','Acquisition, Contracting, Waiver Experience'),
('ACJ','Acquisition, Contracting, Waiver Education'),
('ACJ','Acquisition, Contracting, Waiver Education'),
('ACK','Acquisition, Contracting, Key Leadership Position'),
('ACM','Acquisition, Contracting, Fully Qualified'),
('ACN','Acquisition, Contracting, Non-Critical Acquisition Billet'),
('AD0','Acquisition, Industrial Property Management, Not Certified'),
('AD1','Acquisition, Industrial Property Management, Level 1'),
('AD2','Acquisition, Industrial Property Management, Level 2'),
('AD3','Acquisition, Industrial Property Management, Level 3'),
('ADC','Acquisition, Industrial Property Management, Critical'),
('ADD','Acquisition, Industrial Property Management, Developmental'),
('ADG','Acquisition, Industrial Property Management, Waiver Experience'),
('ADG','Acquisition, Industrial Property Management, Waiver Experience'),
('ADJ','Acquisition, Industrial Property Management, Waiver Education'),
('ADJ','Acquisition, Industrial Property Management, Waiver Education'),
('ADK','Acquisition, Industrial Property Management, Waiver Training'),
('ADM','Acquisition, Industrial Property Management, Fully Qualified'),
('ADN','Acquisition, Industrial Property Management, Non-Critical'),
('AE0','Acquisition, Purchasing, Not Certified'),
('AE1','Acquisition, Purchasing, Level 1'),
('AE2','Acquisition, Purchasing, Level 2'),
('AE3','Acquisition, Purchasing, Level 3'),
('AEC','Acquisition, Purchasing, Critical'),
('AED','Acquisition, Purchasing, Developmental'),
('AEG','Acquisition, Purchasing, Waiver Experience'),
('AEG','Acquisition, Purchasing, Waiver Experience'),
('AEJ','Acquisition, Purchasing, Waiver Education'),
('AEJ','Acquisition, Purchasing, Waiver Education'),
('AEK','Acquisition, Purchasing, Waiver Training'),
('AEM','Acquisition, Purchasing, Fully Qualified'),
('AEN','Acquisition, Purchasing, Non-Critical'),
('AF0','Acquisition, Facilities Engineering, Not Certified'),
('AF1','Acquisition, Facilities Engineering, Level 1 Career Field Certified'),
('AF2','Acquisition, Facilities Engineering, Level 2 Career Field Certified'),
('AF3','Acquisition, Facilities Engineering, Level 3 Career Field Certified'),
('AFC','Acquisition, Facilities Engineering, Critical Acquisition Billet'),
('AFD','Acquisition, Facilities Engineering, Developmental'),
('AFG','Acquisition, Facilities Engineering, Waiver Experience'),
('AFG','Acquisition, Facilities Engineering, Waiver Experience'),
('AFJ','Acquisition, Facilities Engineering, Waiver Education'),
('AFJ','Acquisition, Facilities Engineering, Waiver Education'),
('AFK','Acquisition, Facilities Engineering, Key Leadership Position'),
('AFM','Acquisition, Facilities Engineering, Fully Qualified'),
('AFN','Acquisition, Facilities Engineering, Non-Critical Acquisition Billet'),
('AG0','Acquisition, Manufacturing & Production, Not Certified'),
('AG1','Acquisition, Production, Quality, and Manufacturing, Level 1 Career Field Certified'),
('AG2','Acquisition, Production, Quality, and Manufacturing, Level 2 Career Field Certified'),
('AG3','Acquisition, Production, Quality, and Manufacturing, Level 3 Career Field Certified'),
('AGC','Acquisition, Production, Quality, and Manufacturing, Critical Acquisition Billet'),
('AGD','Acquisition, Production, Quality, and Manufacturing, Developmental'),
('AGG','Acquisition, Production, Quality, and Manufacturing, Waiver Experience'),
('AGG','Acquisition, Manufacturing & Production, Waiver Experience'),
('AGJ','Acquisition, Production, Quality, and Manufacturing, Waiver Education'),
('AGJ','Acquisition, Manufacturing & Production, Waiver Education'),
('AGK','Acquisition, Production, Quality, and Manufacturing, Key Leadership Position'),
('AGM','Acquisition, Production, Quality, and Manufacturing, Fully Qualified'),
('AGN','Acquisition, Production, Quality, and Manufacturing, Non-Critical Acquisition Billet'),
('AH0','Acquisition, Quality Assurance, Not Certified'),
('AH1','Acquisition, Quality Assurance, Level 1'),
('AH2','Acquisition, Quality Assurance, Level 2'),
('AH3','Acquisition, Quality Assurance, Level 3'),
('AHC','Acquisition, Quality Assurance, Critical'),
('AHD','Acquisition, Quality Assurance, Developmental'),
('AHG','Acquisition, Quality Assurance, Waiver Experience'),
('AHG','Acquisition, Quality Assurance, Waiver Experience'),
('AHJ','Acquisition, Quality Assurance, Waiver Education'),
('AHJ','Acquisition, Quality Assurance, Waiver Education'),
('AHK','Acquisition, Quality Assurance, Waiver Training'),
('AHM','Acquisition, Quality Assurance, Fully Qualified'),
('AHN','Acquisition, Quality Assurance, Non-Critical'),
('AI0','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Not Certified'),
('AI1','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 1 Career Field Certified'),
('AI2','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 2 Career Field Certified'),
('AI3','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 3 Career Field Certified'),
('AIC','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Critical Acquisition Billet'),
('AID','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Developmental'),
('AIG','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Experience'),
('AIG','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Experience'),
('AIJ','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Education'),
('AIJ','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Education'),
('AIK','Acquisition, Systems Planning, RD&E � Science & Technology Manager, Key Leadership Position'),
('AIM','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Fully Qualified'),
('AIN','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Non-Critical Acquisition Billet'),
('AJ3','Acquisition, Program Management � International Acquisition, Level 3 Career Field Certified'),
('AJC','Acquisition, Program Management � International Acquisition, Critical Acquisition Billet'),
('AJK','Acquisition, Program Management � International Acquisition, Key Leadership Position'),
('AJN','Acquisition, Program Management � International Acquisition, Non-Critical Acquisition Billet'),
('AK0','Acquisition, Business, Cost Estimating, & Financial Management, Not Certified'),
('AK1','Acquisition, Business - Financial Management, Level 1 Career Field Certified'),
('AK2','Acquisition, Business - Financial Management, Level 2 Career Field Certified'),
('AK3','Acquisition, Business - Financial Management, Level 3 Career Field Certified'),
('AKC','Acquisition, Business - Financial Management, Critical Acquisition Billet'),
('AKD','Acquisition, Business, Cost Estimating, & Financial Management, Developmental'),
('AKG','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Experience'),
('AKG','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Experience'),
('AKJ','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Education'),
('AKJ','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Education'),
('AKK','Acquisition, Business -Financial Management, Key Leadership Position'),
('AKM','Acquisition, Business, Cost Estimating, & Financial Management, Fully Qualified'),
('AKN','Acquisition, Business - Financial Management, Non-Critical Acquisition Billet'),
('AL0','Acquisition, Acquisition Logistics, Not Certified'),
('AL1','Acquisition, Life Cycle Logistics, Level 1 Career Field Certified'),
('AL2','Acquisition, Life Cycle Logistics, Level 2 Career Field Certified'),
('AL3','Acquisition, Life Cycle Logistics, Level 3 Career Field Certified'),
('ALC','Acquisition, Life Cycle Logistics, Critical Acquisition Billet'),
('ALD','Acquisition, Acquisition Logistics, Developmental'),
('ALG','Acquisition, Acquisition Logistics, Waiver Experience'),
('ALG','Acquisition, Acquisition Logistics, Waiver Experience'),
('ALJ','Acquisition, Acquisition Logistics, Waiver Education'),
('ALJ','Acquisition, Acquisition Logistics, Waiver Education'),
('ALK','Acquisition, Life Cycle Logistics, Key Leadership Position'),
('ALM','Acquisition, Acquisition Logistics, Fully Qualified'),
('ALN','Acquisition, Life Cycle Logistics, Non-Critical Acquisition Billet'),
('AM0','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Not Certified'),
('AM1','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Level 1'),
('AM2','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Level 2'),
('AM3','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Level 3'),
('AMC','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Critical'),
('AMD','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Developmental'),
('AMG','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Waiver Experience'),
('AMJ','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Waiver Education'),
('AMK','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Waiver Training'),
('AMM','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Fully Qualified'),
('AMN','Acquisition, Life Cycle Logistics, Systems Sustainment Management, Non-Critical'),
('AP0','Acquisition, Acquisition Professional Community (APC), Not Certified'),
('AP1','Acquisition, Acquisition Professional Community (APC), Level 1'),
('AP2','Acquisition, Acquisition Professional Community (APC), Level 2'),
('AP3','Acquisition, Acquisition Professional Community (APC), Level 3'),
('APC','Acquisition, Acquisition Professional Community (APC), Critical'),
('APD','Acquisition, Acquisition Professional Community (APC), Developmental'),
('APG','Acquisition, Defense Acquisition Corps Member Eligible, Waiver Experience'),
('APG','Acquisition, Acquisition Professional Community (APC), Waiver Experience'),
('APJ','Acquisition, Defense Acquisition Corps Member Eligible, Waiver Education'),
('APJ','Acquisition, Acquisition Professional Community (APC), Waiver Education'),
('APK','Acquisition, Acquisition Professional Community (APC), Waiver Training'),
('APM','Acquisition, Acquisition Professional Community (APC), Fully Qualified'),
('APN','Acquisition, Acquisition Professional Community (APC), Non-Critical'),
('APT','Acquisition, Defense Acquisition Corps Member Eligible, Waiver Training'),
('AR0','Acquisition, Communications-Computer Systems, Not Certified'),
('AR1','Acquisition, Information Technology, Level 1 Career Field Certified'),
('AR2','Acquisition, Information Technology, Level 2 Career Field Certified'),
('AR3','Acquisition, Information Technology, Level 3 Career Field Certified'),
('ARC','Acquisition, Information Technology, Critical Acquisition Billet'),
('ARD','Acquisition, Communications-Computer Systems, Developmental'),
('ARG','Acquisition, Communications-Computer Systems, Waiver Experience'),
('ARG','Acquisition, Communications-Computer Systems, Waiver Experience'),
('ARJ','Acquisition, Communications-Computer Systems, Waiver Education'),
('ARJ','Acquisition, Communications-Computer Systems, Waiver Education'),
('ARK','Acquisition, Information Technology, Key Leadership Position'),
('ARM','Acquisition, Communications-Computer Systems, Fully Qualified'),
('ARN','Acquisition, Information Technology, Non-Critical Career Billet'),
('AS0','Acquisition, Systems Planning RD&E, Not Certified'),
('AS1','Acquisition, Engineering, Level 1 Career Field Certified'),
('AS2','Acquisition, Engineering, Level 2 Career Field Certified'),
('AS3','Acquisition, Engineering, Level 3 Career Field Certified'),
('ASC','Acquisition, Engineering, Critical Acquisition Billet'),
('ASD','Acquisition, Systems Planning RD&E, Developmental'),
('ASG','Acquisition, Systems Planning RD&E, Waiver Experience'),
('ASG','Acquisition, Systems Planning RD&E, Waiver Experience'),
('ASJ','Acquisition, Systems Planning RD&E, Waiver Education'),
('ASJ','Acquisition, Systems Planning RD&E, Waiver Education'),
('ASK','Acquisition, Engineering, Key Leadership Position'),
('ASM','Acquisition, Systems Planning RD&E, Fully Qualified'),
('ASN','Acquisition, Engineering, Non-Critical Acquisition Billet'),
('AT0','Acquisition, Test & Evaluation Engineering, Not Certified'),
('AT1','Acquisition, Test & Evaluation, Level 1 Career Field Certified'),
('AT2','Acquisition, Test & Evaluation, Level 2 Career Field Certified'),
('AT3','Acquisition, Test & Evaluation, Level 3 Career Field Certified'),
('ATC','Acquisition, Test & Evaluation, Critical Acquisition Billet'),
('ATD','Acquisition, Test & Evaluation Engineering, Developmental'),
('ATG','Acquisition, Test & Evaluation Engineering, Waiver Experience'),
('ATG','Acquisition, Test & Evaluation Engineering, Waiver Experience'),
('ATJ','Acquisition, Test & Evaluation Engineering, Waiver Education'),
('ATJ','Acquisition, Test & Evaluation Engineering, Waiver Education'),
('ATK','Acquisition, Test & Evaluation, Key Leadership Position'),
('ATM','Acquisition, Test & Evaluation Engineering, Fully Qualified'),
('ATN','Acquisition, Test & Evaluation, Non-Critical Acquisition Billet'),
('AU0','Acquisition, Auditing (Reserved for DCAA use), Not Certified'),
('AU1','Acquisition, Auditing (Reserved for DCAA use), Level 1'),
('AU2','Acquisition, Auditing (Reserved for DCAA use), Level 2'),
('AU3','Acquisition, Auditing (Reserved for DCAA use), Level 3'),
('AUC','Acquisition, Auditing (Reserved for DCAA use), Critical'),
('AUD','Acquisition, Auditing (Reserved for DCAA use), Developmental'),
('AUG','Acquisition, Auditing (Reserved for DCAA use), Waiver Experience'),
('AUG','Acquisition, Auditing (Reserved for DCAA use), Waiver Experience'),
('AUJ','Acquisition, Auditing (Reserved for DCAA use), Waiver Education'),
('AUJ','Acquisition, Auditing (Reserved for DCAA use), Waiver Education'),
('AUK','Acquisition, Auditing (Reserved for DCAA use), Waiver Training'),
('AUM','Acquisition, Auditing (Reserved for DCAA use), Fully Qualified'),
('AUN','Acquisition, Auditing (Reserved for DCAA use), Non-Critical'),
('AV0','Acquisition, Program Management Oversight (Reserved for RD&A use), Not Certified'),
('AV1','Acquisition, Program Management Oversight (Reserved for RD&A use), Level 1'),
('AV2','Acquisition, Program Management Oversight (Reserved for RD&A use), Level 2'),
('AV3','Acquisition, Program Management Oversight (Reserved for RD&A use), Level 3'),
('AVC','Acquisition, Program Management Oversight (Reserved for RD&A use), Critical'),
('AVD','Acquisition, Program Management Oversight (Reserved for RD&A use), Developmental'),
('AVG','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Experience'),
('AVG','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Experience'),
('AVJ','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Education'),
('AVJ','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Education'),
('AVK','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Training'),
('AVM','Acquisition, Program Management Oversight (Reserved for RD&A use), Fully Qualified'),
('AVN','Acquisition, Program Management Oversight (Reserved for RD&A use), Non-Critical'),
('AW0','Acquisition, System Planning RD&E - Program Systems Engineering, Not Certified'),
('AW1','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 1 Career Field Certified'),
('AW2','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 2 Career Field Certified'),
('AW3','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 3 Career Field Certified'),
('AWC','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Critical Acquisition Billet'),
('AWD','Acquisition, System Planning RD&E - Program Systems Engineering, Developmental'),
('AWG','Acquisition, System Planning RD&E - Program Systems Engineering, Waiver Experience'),
('AWJ','Acquisition, System Planning RD&E - Program Systems Engineering, Waiver Education'),
('AWK','Acquisition, System Planning RD&E - Program Systems Engineering, Key Leadership Position'),
('AWM','Acquisition, System Planning RD&E - Program Systems Engineering, Fully Qualified'),
('AWN','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Non-Critical Acquisition Billet'),
('AX0','Acquisition, Education, Training & Career Development, Not Certified'),
('AX1','Acquisition, Education, Training & Career Development, Level 1'),
('AX2','Acquisition, Education, Training & Career Development, Level 2'),
('AX3','Acquisition, Education, Training & Career Development, Level 3'),
('AXC','Acquisition, Education, Training, and Career Development, Critical Acquisition Billet'),
('AXD','Acquisition, Education, Training & Career Development, Developmental'),
('AXG','Acquisition, Education, Training & Career Development, Waiver Experience'),
('AXG','Acquisition, Education, Training & Career Development, Waiver Experience'),
('AXJ','Acquisition, Education, Training & Career Development, Waiver Education'),
('AXJ','Acquisition, Education, Training & Career Development, Waiver Education'),
('AXK','Acquisition, Education, Training & Career Development, Waiver Training'),
('AXM','Acquisition, Education, Training & Career Development, Fully Qualified'),
('AXN','Acquisition, Education, Training, and Career Development, Non-Critical Acquisition Billet'),
('AYB','Acquisition, Requirements Management Certification Training (RMCT), Level B'),
('AYC','Acquisition, Requirements Management Certification Training (RMCT), Level C')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 3...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('BA1','Naval Warfare (General), ASW Qualified, Operational'),
('BA2','Naval Warfare (General), ASW Qualified, Operational'),
('BA3','Naval Warfare (General), ASW Qualified, Key Manager'),
('BA4','Naval Warfare (General), ASW Qualified, IUSS'),
('BA5','Naval Warfare (General), ASW Qualified, IUSS Experienced'),
('BA6','Naval Warfare (General), Theater Anti-Submarine Warfare (TASW), Theater Anti-Submarine Warfare Watch Officer (TASWWO)'),
('BA7','Naval Warfare (General), Theater Anti-Submarine Warfare (TASW), Theater Anti- Submarine Warfare Battle Watch Captain (TASW BWC)'),
('BA8','Naval Warfare (General), Undersea Combat Systems, Qualified'),
('BA9','Naval Warfare (General), ASW Qualified, IUSS SURTASS Mission Commander'),
('BB1','Naval Warfare (General), Staff Officer, Battle Watch Captain'),
('BC8','Naval Warfare (General), Naval Aviation Supply Officer, Qualified'),
('BD1','Naval Warfare (General), Naval Aviation Observer, Qualified'),
('BE1','Naval Warfare (General), AAW, Qualified'),
('BF1','Naval Warfare (General), AAW (Supercedes BE), Technical Expert'),
('BG1','Naval Warfare (General), AAW (Supersedes BE), Operational Expert'),
('BH0','Naval Warfare (General), Military Deception, Planner'),
('BI1','Naval Warfare (General), Information Warfare (IW), Basic'),
('BI2','Naval Warfare (General), Information Warfare (IW), Tactical'),
('BI3','Naval Warfare (General), Information Warfare (IW), Operational'),
('BI4','Naval Warfare (General), Information Warfare (IW), Qualified Operational Commander (Captain and Commander billet only)'),
('BJ1','Naval Warfare (General), EW, Qualified'),
('BL1','Naval Warfare (General), Electronic Warfare, Apprentice'),
('BL2','Naval Warfare (General), Electronic Warfare, Journeyman'),
('BL3','Naval Warfare (General), Electronic Warfare, Expert'),
('BM1','Naval Warfare (General), Missile Defense, Basic Level BMD'),
('BM2','Naval Warfare (General), Missile Defense, Senior Level BMD'),
('BN1','Naval Warfare (General), Mine Warfare, Basic Level (Mining)'),
('BN2','Naval Warfare (General), Mine Warfare, Qualified Tactical Planner (Mining)'),
('BN3','Naval Warfare (General), Mine Warfare, Basic Level (Counter Measures)'),
('BN4','Naval Warfare (General), Mine Warfare, Qualified Tactical Planner (Counter Measures)'),
('BN5','Naval Warfare (General), Mine Warfare, Qualified Operational (CAPT and CDR billet only)'),
('BO1','Naval Warfare (General), Computer Network Operations (CNO), Technical Integration Officer'),
('BO2','Naval Warfare (General), Computer Network Operations (CNO), Mission Manager'),
('BO3','Naval Warfare (General), Computer Network Operations (CNO), Service Planner'),
('BO4','Naval Warfare (General), Computer Network Operations (CNO), Joint Planner'),
('BR0','Naval Warfare (General), Regional Hand, Asia Pacific Hand Entry Qualified'),
('BR1','Naval Warfare (General), Regional Hand, Asia Pacific Hand Basic Qualified'),
('BR2','Naval Warfare (General), Regional Hand, Asia Pacific Hand Fully Proficient Qualified'),
('BR3','Naval Warfare (General), Regional Hand, Asia Pacific Hand Master'),
('BR4','Naval Warfare (General), Regional Hand, Asia Pacific Hand Expert'),
('BS1','Naval Warfare (General), TLAM, Shipboard Strike Officer In-Training'),
('BS2','Naval Warfare (General), TLAM, Shipboard Strike Officer Qualified'),
('BS3','Naval Warfare (General), TLAM, Staff Strike Officer In-Training'),
('BS4','Naval Warfare (General), TLAM, Staff Strike Officer Qualified'),
('BS5','Naval Warfare (General), TLAM, Mission Planner'),
('BS6','Naval Warfare (General), TLAM, Liaison Officer'),
('BT1','Naval Warfare (General), Parachutist, Static-line Qualified'),
('BT2','Naval Warfare (General), Parachutist, Freefall Qualified'),
('BU1','Naval Warfare (General), Special Technical Operations, Qualified'),
('BX1','Naval Warfare (General), Expeditionary Warfare, Planner'),
('BX2','Naval Warfare (General), Expeditionary Warfare, Fleet Marine Force (FMF) Warfare Officer'),
('BX3','Naval Warfare (General), Expeditionary Warfare, Basic'),
('BYB','Naval Warfare (General), Requirements Management Certification Training (RMCT), Level B'),
('BYC','Naval Warfare (General), Requirements Management Certification Training (RMCT), Level C'),
('BZA','Naval Warfare (General), Staff FIRES, Graduate � Joint Operational Fires and Effects Course'),
('BZB','Naval Warfare (General), Staff FIRES, Experienced'),
('BZC','Naval Warfare (General), Staff FIRES, Advanced'),
('CA1','Line Officer Shore Assignment, Division Officer, Ensign'),
('CA2','Line Officer Shore Assignment, Division Officer, Lieutenant Junior Grade'),
('CA3','Line Officer Shore Assignment, Division Officer, Lieutenant'),
('CA4','Line Officer Shore Assignment, Division Officer, Lieutenant Commander'),
('CA5','Line Officer Shore Assignment, Division Officer, Commander'),
('CA6','Line Officer Shore Assignment, Division Officer, Captain'),
('CB1','Line Officer Shore Assignment, Department Head, Ensign'),
('CB2','Line Officer Shore Assignment, Department Head, Lieutenant Junior Grade'),
('CB3','Line Officer Shore Assignment, Department Head, Lieutenant'),
('CB4','Line Officer Shore Assignment, Department Head, Lieutenant Commander'),
('CB5','Line Officer Shore Assignment, Department Head, Commander'),
('CB6','Line Officer Shore Assignment, Department Head, Captain'),
('CBB','Line Officer Shore Assignment, Shore Installation Management, Department Head'),
('CBC','Line Officer Shore Assignment, Shore Installation Management, Executive Officer'),
('CBD','Line Officer Shore Assignment, Shore Installation Management, Officer in Charge'),
('CBE','Line Officer Shore Assignment, Shore Installation Management, Shore Command'),
('CBF','Line Officer Shore Assignment, Shore Installation Management, Major Shore Command'),
('CBJ','Line Officer Shore Assignment, Shore Installation Management, Post-Major Shore Command'),
('CC1','Line Officer Shore Assignment, Executive Officer, Ensign'),
('CC2','Line Officer Shore Assignment, Executive Officer, Lieutenant Junior Grade'),
('CC3','Line Officer Shore Assignment, Executive Officer, Lieutenant'),
('CC4','Line Officer Shore Assignment, Executive Officer, Lieutenant Commander'),
('CC5','Line Officer Shore Assignment, Executive Officer, Commander'),
('CC6','Line Officer Shore Assignment, Executive Officer, Captain'),
('CD1','Line Officer Shore Assignment, Officer-in-Charge, Ensign'),
('CD2','Line Officer Shore Assignment, Officer-in-Charge, Lieutenant Junior Grade'),
('CD3','Line Officer Shore Assignment, Officer-in-Charge, Lieutenant'),
('CD4','Line Officer Shore Assignment, Officer-in-Charge, Lieutenant Commander'),
('CD5','Line Officer Shore Assignment, Officer-in-Charge, Commander'),
('CD6','Line Officer Shore Assignment, Officer-in-Charge, Captain'),
('CE1','Line Officer Shore Assignment, Shore Command, Ensign'),
('CE2','Line Officer Shore Assignment, Shore Command, Lieutenant Junior Grade'),
('CE3','Line Officer Shore Assignment, Shore Command, Lieutenant'),
('CE4','Line Officer Shore Assignment, Shore Command, Lieutenant Commander'),
('CE5','Line Officer Shore Assignment, Shore Command, Commander'),
('CE6','Line Officer Shore Assignment, Shore Command, Captain'),
('CF1','Line Officer Shore Assignment, Major Shore Command, Ensign'),
('CF2','Line Officer Shore Assignment, Major Shore Command, Lieutenant Junior Grade'),
('CF3','Line Officer Shore Assignment, Major Shore Command, Lieutenant'),
('CF4','Line Officer Shore Assignment, Major Shore Command, Lieutenant Commander'),
('CF5','Line Officer Shore Assignment, Major Shore Command, Commander'),
('CF6','Line Officer Shore Assignment, Major Shore Command, Captain'),
('CG1','Line Officer Shore Assignment, Deputy Project Manager, Ensign'),
('CG2','Line Officer Shore Assignment, Deputy Project Manager, Lieutenant Junior Grade'),
('CG3','Line Officer Shore Assignment, Deputy Project Manager, Lieutenant'),
('CG4','Line Officer Shore Assignment, Deputy Project Manager, Lieutenant Commander'),
('CG5','Line Officer Shore Assignment, Deputy Project Manager, Commander'),
('CG6','Line Officer Shore Assignment, Deputy Project Manager, Captain'),
('CH1','Line Officer Shore Assignment, Project Manager, Ensign'),
('CH2','Line Officer Shore Assignment, Project Manager, Lieutenant Junior Grade'),
('CH3','Line Officer Shore Assignment, Project Manager, Lieutenant'),
('CH4','Line Officer Shore Assignment, Project Manager, Lieutenant Commander'),
('CH5','Line Officer Shore Assignment, Project Manager, Commander'),
('CH6','Line Officer Shore Assignment, Project Manager, Captain'),
('CI1','Line Officer Shore Assignment, Major Project Manager, Ensign'),
('CI2','Line Officer Shore Assignment, Major Project Manager, Lieutenant Junior Grade'),
('CI3','Line Officer Shore Assignment, Major Project Manager, Lieutenant'),
('CI4','Line Officer Shore Assignment, Major Project Manager, Lieutenant Commander'),
('CI5','Line Officer Shore Assignment, Major Project Manager, Commander'),
('CI6','Line Officer Shore Assignment, Major Project Manager, Captain'),
('DA0','Aviation Warfare, Attack, Any (Attack)'),
('DA1','Aviation Warfare, Attack, Light Attack (TA-4J)'),
('DA2','Aviation Warfare, Attack, Light Attack (A-7)'),
('DA6','Aviation Warfare, Attack, Light Attack (AV-8)'),
('DA7','Aviation Warfare, Attack, Light Attack (FA-18)'),
('DAA','Aviation Warfare, Attack, Strike Warfare Instructor (Attack)'),
('DAB','Aviation Warfare, Attack, Strike Leader Graduate (Attack)'),
('DAC','Aviation Warfare, Attack, Medium attack (A-12)'),
('DB0','Aviation Warfare, Fighter, Any (Fighter)'),
('DB1','Aviation Warfare, Training, Strike Fighter Tactics Instructor (SFTI) (Fighter)'),
('DB2','Aviation Warfare, F-35C, Strike/Fighter Interdiction'),
('DB3','Aviation Warfare, Fighter, FTR/Bomber (F-5)'),
('DB4','Aviation Warfare, Fighter, FTR/Bomber (F-14)'),
('DB6','Aviation Warfare, Fighter, FTR/Bomber (FA-18)'),
('DB7','Aviation Warfare, Fighter, TOPGUN Fighter Graduate (Fighter)'),
('DB8','Aviation Warfare, Fighter, Adversary Graduate (Fighter/Attack)'),
('DB9','Aviation Warfare, Fighter, TOPGUN Instructor (Fighter)'),
('DC4','Aviation Warfare, Combat Support, Photo Recon (F-14)'),
('DC5','Aviation Warfare, Combat Support, ISR Patrol'),
('DC6','Aviation Warfare, Combat Support, Instructor ISR Patrol'),
('DCF','Aviation Warfare, Combat Support, Forward Air Controller (Airborne) (F-14A, F-14B,) FAC (A) (F-14D, FA-18D, or FA-18F)'),
('DD0','Aviation Warfare, Combat Support, Any Recon (ECM Recon)'),
('DD1','Aviation Warfare, Combat Support, ECM Recon (EA-18G)'),
('DD2','Aviation Warfare, Combat Support, ECM Recon (EA-6)'),
('DD3','Aviation Warfare, Combat Support, ECM Recon (ERA-3)'),
('DD4','Aviation Warfare, Combat Support, ECM Recon (EA-3)'),
('DD6','Aviation Warfare, Combat Support, ECM Recon (EA-7)'),
('DD7','Aviation Warfare, Combat Support, ECM/ELINT/COMM (ES-3A)'),
('DD8','Aviation Warfare, Combat Support, COMM'),
('DD9','Aviation Warfare, Combat Support, Prowler Tactics Instructor (EA-6B)'),
('DDA','Aviation Warfare, Combat Support, Mercury Tactics Instructor'),
('DE1','Aviation Warfare, Transport , Light Jet (CT-39)'),
('DE3','Aviation Warfare, Transport , Heavy Jet (C-9)'),
('DE4','Aviation Warfare, Logistics, Medium Jet (C-20)'),
('DE5','Aviation Warfare, Logistics, Heavy Jet (C-40)'),
('DF0','Aviation Warfare, ASW, Any (ASW)'),
('DF2','Aviation Warfare, ASW, Carrier ASW (S-3)'),
('DF3','Aviation Warfare, ASW, Carrier ASW (S-3B)'),
('DF4','Aviation Warfare, ASW, Carrier (SUW) (S-3B)'),
('DF5','Aviation Warfare, P-8, ASW Patrol Aviator'),
('DF6','Aviation Warfare, P-8, ASW Patrol Instructor'),
('DF7','Aviation Warfare, P-8, Poseidon Weapons & Tactics Instructor (WTI)'),
('DF9','Aviation Warfare, Training, Viking Tactic Instructor (S-3B)'),
('DG0','Aviation Warfare, General Jet, Any Jet'),
('DG1','Aviation Warfare, Training, Instructor (Fleet Experience) (Any Jet)'),
('DG2','Aviation Warfare, Training, Instructor (Non-Fleet Experience) (Any Jet)'),
('DG3','Aviation Warfare, General Jet, Composite (Any Jet)'),
('DG5','Aviation Warfare, Training Pipeline, Pilot Training - Jet (Any Jet)'),
('DG6','Aviation Warfare, Training Pipeline, NFO Training - RIO (Any Jet)'),
('DG7','Aviation Warfare, Training Pipeline, NFO Training - AJN (Any Jet)'),
('DG8','Aviation Warfare, Training Pipeline, NFO Training - AELW (Any Jet)'),
('DG9','Aviation Warfare, Training Pipeline, NFO Training - ASW'),
('DGA','Aviation Warfare, Training Pipeline, NFO Training - COMM'),
('DH3','Aviation Warfare, E-2D, Carrier Airborne Early Warning (AEW)'),
('DH4','Aviation Warfare, E-2D, CAPC Instructor/ CICO Instructor'),
('DH5','Aviation Warfare, E-2D, Weapons and Tactics Instructor (WTI)'),
('DJ0','Aviation Warfare, ASW, Any (Any)'),
('DJ3','Aviation Warfare, ASW, ASW Patrol (P-3A/B)'),
('DJ4','Aviation Warfare, ASW, ASW Patrol (P-3C)'),
('DK0','Aviation Warfare, Combat Support, Any (ECM/ELINT)'),
('DK2','Aviation Warfare, Combat Support, ECM/ELINT (EP-3)'),
('DK5','Aviation Warfare, Combat Support, ECM/ELINT (RP-3)'),
('DK6','Aviation Warfare, Combat Support, SPECIAL PROJECTS'),
('DK7','Aviation Warfare, Combat Support, SPECIAL PROJECTS INSTRUCTOR'),
('DK8','Aviation Warfare, Training, Joint Advanced Tactical Signals Intelligence Training Program (JATSTP) Graduate'),
('DK9','Aviation Warfare, Training, VQ Weapons and Tactics Instructor (VQTI) - EP-3E, SP P-3'),
('DL0','Aviation Warfare, Combat Support, Any (AEW)'),
('DL3','Aviation Warfare, Combat Support, Carrier AEW (E-2C)'),
('DL4','Aviation Warfare, Combat Support, Aviation Warfare, Instructor CICO/Instructor CAPC (EC2 HAWKEYE)'),
('DL5','Aviation Warfare, Combat Support, Weapons and Tactics Instructor (WTI) (EC2 HAWKEYE)'),
('DM0','Aviation Warfare, Combat Support, MAGNET/BIRDSEYE/SEASCN (RP-3A/D)'),
('DN2','Aviation Warfare, Combat Support, LT Obervation (OV-10)'),
('DP1','Aviation Warfare, Combat Support, Utility (UC-12)'),
('DP2','Aviation Warfare, Combat Support, Utility Medium (U-6)'),
('DP8','Aviation Warfare, Combat Support, Utility (US-3)'),
('DQ4','Aviation Warfare, Transport, Transport Hvy (C-130)'),
('DQ5','Aviation Warfare, Transport, Transport Hvy (VP-3)'),
('DR0','Aviation Warfare, Transport, Any (Med Trans)'),
('DS0','Aviation Warfare, Transport, Any (Carrier Trans)'),
('DS2','Aviation Warfare, Transport, Carrier Trans (C-2)'),
('DT0','Aviation Warfare, General (Prop), Any Prop'),
('DT1','Aviation Warfare, Transport, Instructor (Fleet Experience) (Any Prop)'),
('DT2','Aviation Warfare, Transport, Instructor (Non-Fleet Experience) (Any Prop)'),
('DT3','Aviation Warfare, General (Prop), Composite (Any Prop)'),
('DT4','Aviation Warfare, Training, Maritime Patrol and Reconnaissance WT1 (P-3C)'),
('DT5','Aviation Warfare, Training Pipeline, Pilot Training - Prop (Any Prop)'),
('DT6','Aviation Warfare, Training Pipeline, NFO Training - NAV (Any Prop)'),
('DT7','Aviation Warfare, Training Pipeline, NFO Training - ATDS (Any Prop)'),
('DT8','Aviation Warfare, Training Pipeline, NFO Training - AEW (Any Prop)'),
('DU1','Aviation Warfare, ASW, Served Aviation Commander Cmd'),
('DU2','Aviation Warfare, Served Second Sequential Aviation Command Cmd'),
('DU3','Aviation Warfare, Served Aviation Captain Cmd'),
('DV0','Aviation Warfare, Any (ASW-Lamps)'),
('DV1','Aviation Warfare, ASW (Carrier) (SH-3)'),
('DV2','Aviation Warfare, ASW (Lamps) (SH-2)'),
('DV3','Aviation Warfare, ASW (Carrier) (SH-60F)'),
('DV4','Aviation Warfare, ASW (Lamps) (SH-60B)'),
('DV5','Aviation Warfare, ASW (Lamps), MH-60R'),
('DW0','Aviation Warfare, Combat Support, Any (SAR/Mine Counter- Measures/Logistics)'),
('DW1','Aviation Warfare, Combat Support, Attack/SAR/Logistics (A/UH-1)'),
('DW4','Aviation Warfare, Combat Support, SAR/Logistics (UH-3)'),
('DW5','Aviation Warfare, Combat Support, SAR/Logistics (C/U/HH-46)'),
('DW6','Aviation Warfare, Combat Support, SAR/MCM/Logistics (RH-53)'),
('DW7','Aviation Warfare, Combat Support, SAR/Logistics (CH-53)'),
('DW8','Aviation Warfare, Combat Support, SAR/MCM/Logistics (MH-53)'),
('DW9','Aviation Warfare, Combat Support, CSAR (HH-60H)'),
('DWA','Aviation Warfare, Combat Support, Basic/PQM (MH-60S)'),
('DWB','Aviation Warfare, Combat Support, SAR/Logistics (MH-60S)'),
('DWC','Aviation Warfare, Combat Support, Combat/SAR (MH-60S)'),
('DWD','Aviation Warfare, Combat Support, Mine Warfare (MH-60S)'),
('DWE','Aviation Warfare, Combat Support, Special Warfare'),
('DX1','Aviation Warfare, Transport, Transport (VH-3)'),
('DY0','Aviation Warfare, General (Helo), Any Helo (Any Helo)'),
('DY1','Aviation Warfare, Training, Instructor (Fleet Experience) (Any Helo)'),
('DY2','Aviation Warfare, Helicopter, Weapons and Tactics Instructor (WTI) (H-60)'),
('DY3','Aviation Warfare, General (Helo), Composite'),
('DY5','Aviation Warfare, Training Pipeline, Pilot Training - Helo (Any Helo)'),
('DY6','Aviation Warfare, Training Pipeline, NFO Training - ASW'),
('DZ1','Aviation Warfare, Spacecraft'),
('DZ2','Aviation Warfare, Unspecified Vehicle'),
('DZ3','Aviation Warfare, Any Vehicle'),
('DZ4','Aviation Warfare, VSTOL'),
('DZ5','Aviation Warfare, Non-Fleet Experienced (Jet)'),
('DZ6','Aviation Warfare, Non-Fleet Experienced (Prop)'),
('DZ7','Aviation Warfare, Non-Fleet Experienced (Helo)'),
('DZA','Aviation Warfare, Joint Air Operations, Graduate � Joint Air Operations Command and Control Course'),
('DZB','Aviation Warfare, Joint Air Operations, AOC experience � Exercise Only'),
('DZC','Aviation Warfare, Joint Air Operations, AOC Qualified'),
('DZD','Aviation Warfare, Joint Air Operations, AOC Operational Experience'),
('DZE','Aviation Warfare, Joint Air Operations, Naval and Amphibious Liaison Element (NALE) Liaison Officer, Embarked'),
('DZF','Aviation Warfare, Joint Air Operations, Graduate � AOC Combat Operations Initial Qualification Training (IQT) course'),
('DZG','Aviation Warfare, Joint Air Operations, Graduate � AOC Combat Plans Initial Qualification Training (IQT) course'),
('DZH','Aviation Warfare, Joint Air Operations, Graduate � AOC Airspace Initial Qualification Training (IQT) course'),
('DZI','Aviation Warfare, Joint Air Operations, Graduate � AOC Strategy Initial Qualification Training (IQT) course'),
('DZJ','Aviation Warfare, Joint Air Operations, Graduate � AOC Intelligence, Surveillance and Reconnaissance (ISR) Initial Qualification Training (IQT) course'),
('DZK','Aviation Warfare, Joint Air Operations, Graduate � AOC Personnel Recovery (PR) Initial Qualification Training (IQT) course'),
('DZL','Aviation Warfare, Joint Air Operations, Graduate � AOC Interface Control Officer (ICO) Initial Qualification Training (IQT) course'),
('DZM','Aviation Warfare, Joint Air Operations, Graduate � Command & Control Warrior Advanced Course (C2WAC)'),
('DZN','Aviation Warfare, Joint Air Operations, Graduate � Joint or Combined Senior Staff Course (J/CSSC)'),
('DZO','Aviation Warfare, Joint Air Operations, Graduate � Joint Force Air Component Commander (JFACC) Augmentation Staff Course'),
('DZP','Aviation Warfare, Training/Experience, TacMobile'),
('DZQ','Aviation Warfare, Joint Air Operations, Graduate � Aviation Safety Officer course (ASO GRAD)'),
('EA2','Aviation Warfare, FLD (Field Qualified), TA-4J'),
('EA5','Aviation Warfare, FLD (Field Qualified), EA6'),
('EA8','Aviation Warfare, FLD (Field Qualified), C2, E2'),
('EAD','Aviation Warfare, FLD (Field Qualified), F14'),
('EAF','Aviation Warfare, FLD (Field Qualified), S3'),
('EAG','Aviation Warfare, FLD (Field Qualified), T2'),
('EAK','Aviation Warfare, FLD (Field Qualified), F14, S3'),
('EAU','Aviation Warfare, FLD (Field Qualified), OTHER'),
('EAY','Aviation Warfare, FLD (Field Qualified), F/A 18'),
('EAZ','Aviation Warfare, FLD (Field Qualified), T2, TA-4J'),
('EB2','Aviation Warfare, SQV (Squadron LSO CV), TA-4J'),
('EB5','Aviation Warfare, SQV (Squadron LSO CV), EA6'),
('EB8','Aviation Warfare, SQV (Squadron LSO CV), C2, E2'),
('EBD','Aviation Warfare, SQV (Squadron LSO CV), F14'),
('EBF','Aviation Warfare, SQV (Squadron LSO CV), S3'),
('EBG','Aviation Warfare, SQV (Squadron LSO CV), T2'),
('EBK','Aviation Warfare, SQV (Squadron LSO CV), F14, S3'),
('EBU','Aviation Warfare, SQV (Squadron LSO CV), OTHER'),
('EBY','Aviation Warfare, SQV (Squadron LSO CV), F/A 18'),
('EBZ','Aviation Warfare, SQV (Squadron LSO CV), T2, TA-4J'),
('EC2','Aviation Warfare, WQV (Wing LSO CV), TA-4J'),
('EC5','Aviation Warfare, WQV (Wing LSO CV), EA6'),
('EC8','Aviation Warfare, WQV (Wing LSO CV), C2, E2'),
('ECD','Aviation Warfare, WQV (Wing LSO CV), F14'),
('ECF','Aviation Warfare, WQV (Wing LSO CV), S3'),
('ECG','Aviation Warfare, WQV (Wing LSO CV), T2'),
('ECK','Aviation Warfare, WQV (Wing LSO CV), F14, S3'),
('ECU','Aviation Warfare, WQV (Wing LSO CV), OTHER'),
('ECY','Aviation Warfare, WQV (Wing LSO CV), F/A 18'),
('ECZ','Aviation Warfare, WQV (Wing LSO CV), T2, TA-4J'),
('ED2','Aviation Warfare, TRV (Training LSO CV), TA-4J'),
('ED5','Aviation Warfare, TRV (Training LSO CV), EA6'),
('ED8','Aviation Warfare, TRV (Training LSO CV), C2, E2'),
('EDD','Aviation Warfare, TRV (Training LSO CV), F14'),
('EDF','Aviation Warfare, TRV (Training LSO CV), S3'),
('EDG','Aviation Warfare, TRV (Training LSO CV), T2'),
('EDK','Aviation Warfare, TRV (Training LSO CV), F14, S3'),
('EDU','Aviation Warfare, TRV (Training LSO CV), OTHER'),
('EDY','Aviation Warfare, TRV (Training LSO CV), F/A 18'),
('EDZ','Aviation Warfare, TRV (Training LSO CV), T2, TA-4J'),
('EF2','Aviation Warfare, SFV (Staff LSO CV), TA-4J'),
('EF5','Aviation Warfare, SFV (Staff LSO CV), EA6'),
('EF8','Aviation Warfare, SFV (Staff LSO CV), C2, E2'),
('EFD','Aviation Warfare, SFV (Staff LSO CV), F14'),
('EFF','Aviation Warfare, SFV (Staff LSO CV), S3'),
('EFG','Aviation Warfare, SFV (Staff LSO CV), T2'),
('EFK','Aviation Warfare, SFV (Staff LSO CV), F14, S3'),
('EFU','Aviation Warfare, SFV (Staff LSO CV), OTHER'),
('EFY','Aviation Warfare, SFV (Staff LSO CV), F/A 18'),
('EFZ','Aviation Warfare, SFV (Staff LSO CV), T2, TA-4J'),
('EH2','Aviation Warfare, VTI (VT LSO CAT I), TA-4J'),
('EH5','Aviation Warfare, VTI (VT LSO CAT I), EA6'),
('EH8','Aviation Warfare, VTI (VT LSO CAT I), C2, E2'),
('EHD','Aviation Warfare, VTI (VT LSO CAT I), F14'),
('EHF','Aviation Warfare, VTI (VT LSO CAT I), S3'),
('EHG','Aviation Warfare, VTI (VT LSO CAT I), T2'),
('EHK','Aviation Warfare, VTI (VT LSO CAT I), F14, S3'),
('EHU','Aviation Warfare, VTI (VT LSO CAT I), OTHER'),
('EHY','Aviation Warfare, VTI (VT LSO CAT I), F/A 18'),
('EHZ','Aviation Warfare, VTI (VT LSO CAT I), T2, TA-4J'),
('EJ2','Aviation Warfare, VTII (VT LSO CAT II), TA-4J'),
('EJ5','Aviation Warfare, VTII (VT LSO CAT II), EA6'),
('EJ8','Aviation Warfare, VTII (VT LSO CAT II), C2, E2'),
('EJD','Aviation Warfare, VTII (VT LSO CAT II), F14'),
('EJF','Aviation Warfare, VTII (VT LSO CAT II), S3'),
('EJG','Aviation Warfare, VTII (VT LSO CAT II), T2'),
('EJK','Aviation Warfare, VTII (VT LSO CAT II), F14, S3'),
('EJU','Aviation Warfare, VTII (VT LSO CAT II), OTHER'),
('EJY','Aviation Warfare, VTII (VT LSO CAT II), F/A 18'),
('EJZ','Aviation Warfare, VTII (VT LSO CAT II), T2, TA-4J'),
('EK2','Aviation Warfare, VTIII (VT LSO CAT III), TA-4J'),
('EK5','Aviation Warfare, VTIII (VT LSO CAT III), EA6'),
('EK8','Aviation Warfare, VTIII (VT LSO CAT III), C2, E2'),
('EKD','Aviation Warfare, VTIII (VT LSO CAT III), F14'),
('EKF','Aviation Warfare, VTIII (VT LSO CAT III), S3'),
('EKG','Aviation Warfare, VTIII (VT LSO CAT III), T2'),
('EKK','Aviation Warfare, VTIII (VT LSO CAT III), F14, S3'),
('EKU','Aviation Warfare, VTIII (VT LSO CAT III), OTHER'),
('EKY','Aviation Warfare, VTIII (VT LSO CAT III), F/A 18'),
('EKZ','Aviation Warfare, VTIII (VT LSO CAT III), T2, TA-4J'),
('EU2','Aviation Warfare, LSO SCHL INT, TA-4J'),
('EU5','Aviation Warfare, LSO SCHL INT, EA6'),
('EU8','Aviation Warfare, LSO SCHL INT, C2, E2'),
('EUD','Aviation Warfare, LSO SCHL INT, F14'),
('EUF','Aviation Warfare, LSO SCHL INT, S3'),
('EUG','Aviation Warfare, LSO SCHL INT, T2'),
('EUK','Aviation Warfare, LSO SCHL INT, F14, S3'),
('EUU','Aviation Warfare, LSO SCHL INT, OTHER'),
('EUY','Aviation Warfare, LSO SCHL INT, F/A 18'),
('EUZ','Aviation Warfare, LSO SCHL INT, T2, TA-4J'),
('EY2','Aviation Warfare, LSO SCHL GRD, TA-4J'),
('EY5','Aviation Warfare, LSO SCHL GRD, EA6'),
('EY8','Aviation Warfare, LSO SCHL GRD, C2, E2'),
('EYD','Aviation Warfare, LSO SCHL GRD, F14'),
('EYF','Aviation Warfare, LSO SCHL GRD, S3'),
('EYG','Aviation Warfare, LSO SCHL GRD, T2'),
('EYK','Aviation Warfare, LSO SCHL GRD, F14, S3'),
('EYU','Aviation Warfare, LSO SCHL GRD, OTHER'),
('EYY','Aviation Warfare, LSO SCHL GRD, F/A 18'),
('EYZ','Aviation Warfare, LSO SCHL GRD, T2, TA-4J'),
('EZ2','Aviation Warfare, LSO SCH GRD, TA-4J'),
('EZ5','Aviation Warfare, LSO SCH GRD, EA6'),
('EZ8','Aviation Warfare, LSO SCH GRD, C2, E2'),
('EZD','Aviation Warfare, LSO SCH GRD, F14'),
('EZF','Aviation Warfare, LSO SCH GRD, S3'),
('EZG','Aviation Warfare, LSO SCH GRD, T2'),
('EZK','Aviation Warfare, LSO SCH GRD, F14, S3'),
('EZU','Aviation Warfare, LSO SCH GRD, OTHER'),
('EZY','Aviation Warfare, LSO SCH GRD, F/A 18'),
('EZZ','Aviation Warfare, LSO SCH GRD, T2, TA-4J'),
('FA1','Foreign Area Officer Program, Qualified, Middle East, South Asia Region (CENTCOM)'),
('FA2','Foreign Area Officer Program, Qualified, East Asia, Pacific Region (PACOM)'),
('FA3','Foreign Area Officer Program, Qualified, Western Hemisphere Region (SOUTHCOM)'),
('FA4','Foreign Area Officer Program, Qualified, Europe, Europe, Eurasia Region (EUCOM)'),
('FA5','Foreign Area Officer Program, Qualified, Africa (AFRICOM)'),
('FFQ','Foreign Area Officer Program, Flying, Qualified'),
('FM1','Foreign Area Officer Program, Milestone, Selected'),
('FM2','Foreign Area Officer Program, Milestone, Completed'),
('FM3','Foreign Area Officer Program, Milestone, Major Selected'),
('FM4','Foreign Area Officer Program, Milestone, Major Completed'),
('FT1','Foreign Area Officer Program, In Training, Middle East, South Asia Region (CENTCOM)'),
('FT2','Foreign Area Officer Program, In Training, East Asia, Pacific Region (PACOM)'),
('FT3','Foreign Area Officer Program, In Training, Western Hemisphere Region (SOUTHCOM)'),
('FT4','Foreign Area Officer Program, In Training, Europe, Eurasia Region (EUCOM)'),
('FT5','Foreign Area Officer Program, In Training, Africa (AFRICOM)'),
('GA1','Information Dominance Warfare, Information Professional, Basic Qualification'),
('GA2','Information Dominance Warfare, Information Professional, Intermediate Qualification'),
('GA3','Information Dominance Warfare, Information Professional, Advanced Qualification'),
('GA4','Information Professional, Qualified as a Strike Group Staff Battle Watch Captain (SGSBWC)'),
('GA5','Information Dominance Warfare, Strike Group Staff Tactical Action Officer (SGSTAO)'),
('GA6','Information Dominance Warfare, Information Professional, Knowledge Management Officer (KM)'),
('GA7','Information Dominance Warfare, Information Assurance Officer (IA)'),
('GA8','Information Dominance Warfare, Chief Information Officer (CIO)'),
('GA9','Information Dominance Warfare, Individual Augmentee'),
('GB1','Information Dominance Warfare, Information Professional, LCDR Milestone'),
('GB2','Information Dominance Warfare, Information Professional, CDR Milestone'),
('GB3','Information Dominance Warfare, Information Professional, CAPT Milestone'),
('GC0','Information Dominance Warfare, Information Dominance Warfare Officer (IDWO)'),
('GC1','Information Dominance Warfare, Information Dominance Warfare Officer (IDWO) Qualification Program, Information Dominance Mid-Career Course Completion'),
('GD1','Information Dominance Warfare, Information Dominance Focus Area, East Asia'),
('HA1','Recruiting, Navy Recruiting Region, Region Commander'),
('HA2','Recruiting, Navy Recruiting Region, Staff Officer'),
('HA3','Recruiting, Navy Recruiting Region, Chief of Staff'),
('HB1','Recruiting, Navy Recruiting District, Commanding Officer'),
('HB2','Recruiting, Navy Recruiting District, Staff'),
('HB3','Recruiting, Navy Recruiting District, Officer Recruiter'),
('HC1','Recruiting, Navy Recruiting District, Executive Officer'),
('HD1','Recruiting, Recruiting Operations Officer, Qualified'),
('HE1','Recruiting, Assistant Recruiting Operations Officer, Qualified'),
('HF1','Recruiting, Officer in Charge, Navy Recruiting District Class "A" Station, Unspecified'),
('HG1','Recruiting, Navy Recruiting Command, General'),
('HG2','Recruiting, Navy Recruiting Command, Headquarters Staff Officer'),
('HG3','Recruiting, Navy Recruiting Command, General'),
('HH1','Recruiting, Navy Recruiting Area, Chief of Staff'),
('HI1','Recruiting, Officer Recruiter, Unspecified'),
('HTF','Recruiting, Training and Administration of Reserve Officer Recruiter, Field Officer Recruiter'),
('HTM','Recruiting, Training and Administration of Reserve Officer Recruiter, Management Officer Recruiter'),
('IL1','Logistic Support, Logistics, Maintenance'),
('IL2','Logistic Support, Logistics, Advanced'),
('IL3','Logistic Support, Logistics, Support'),
('IL4','Logistic Support, Logistics, Depot'),
('IL5','Logistic Support, Logistics, Major AIMD'),
('IL6','Logistic Support, Scholarship, Aviation Maintenance Officer'),
('J1A','Joint Specialty, Joint Staff, Acquisition'),
('J1C','Joint Specialty, Joint Staff, Civil Affairs'),
('J1D','Joint Specialty, Joint Staff, Detainee Operations'),
('J1F','Joint Specialty, Joint Staff, Finance'),
('J1H','Joint Specialty, Joint Staff, Human Resources'),
('J1I','Joint Specialty, Joint Staff, Intelligence'),
('J1L','Joint Specialty, Joint Staff, Logistics'),
('J1M','Joint Specialty, Joint Staff, Medical'),
('J1O','Joint Specialty, Joint Staff, Operations'),
('J1P','Joint Specialty, Joint Staff, Planning'),
('J1T','Joint Specialty, Joint Staff, Training'),
('J1X','Joint Specialty, Joint Staff, Improvised Explosive Device'),
('J2A','Joint Specialty, Multinational HQ, Acquisition'),
('J2C','Joint Specialty, Multinational HQ, Civil Affairs'),
('J2D','Joint Specialty, Multinational HQ, Detainee Operations'),
('J2F','Joint Specialty, Multinational HQ, Finance'),
('J2H','Joint Specialty, Multinational HQ, Human Resources'),
('J2I','Joint Specialty, Multinational HQ, Intelligence'),
('J2L','Joint Specialty, Multinational HQ, Logistics'),
('J2M','Joint Specialty, Multinational HQ, Medical'),
('J2O','Joint Specialty, Multinational HQ, Operations'),
('J2P','Joint Specialty, Multinational HQ, Planning'),
('J2T','Joint Specialty, Multinational HQ, Training'),
('J2X','Joint Specialty, Multinational HQ, Improvised Explosive Device'),
('J3A','Joint Specialty, Combatant Commander Level, Acquisition'),
('J3C','Joint Specialty, Combatant Commander Level, Civil Affairs'),
('J3D','Joint Specialty, Combatant Commander Level, Detainee Operations'),
('J3F','Joint Specialty, Combatant Commander Level, Finance'),
('J3H','Joint Specialty, Combatant Commander Level, Human Resources'),
('J3I','Joint Specialty, Combatant Commander Level, Intelligence'),
('J3L','Joint Specialty, Combatant Commander Level, Logistics'),
('J3M','Joint Specialty, Combatant Commander Level, Medical'),
('J3O','Joint Specialty, Combatant Commander Level, Operations'),
('J3P','Joint Specialty, Combatant Commander Level, Planning'),
('J3T','Joint Specialty, Combatant Commander Level, Training'),
('J3X','Joint Specialty, Combatant Commander Level, Improvised Explosive Device'),
('J4A','Joint Specialty, Fleet/Division Staff, Acquisition'),
('J4C','Joint Specialty, Fleet/Division Staff, Civil Affairs'),
('J4D','Joint Specialty, Fleet/Division Staff, Detainee Operations'),
('J4F','Joint Specialty, Fleet/Division Staff, Finance'),
('J4H','Joint Specialty, Fleet/Division Staff, Human Resources'),
('J4I','Joint Specialty, Fleet/Division Staff, Intelligence'),
('J4L','Joint Specialty, Fleet/Division Staff, Logistics'),
('J4M','Joint Specialty, Fleet/Division Staff, Medical'),
('J4O','Joint Specialty, Fleet/Division Staff, Operations'),
('J4P','Joint Specialty, Fleet/Division Staff, Planning'),
('J4T','Joint Specialty, Fleet/Division Staff, Training'),
('J4X','Joint Specialty, Fleet/Division Staff, Improvised Explosive Device'),
('J5A','Joint Specialty, Joint Task Force, Acquisition'),
('J5C','Joint Specialty, Joint Task Force, Civil Affairs'),
('J5D','Joint Specialty, Joint Task Force, Detainee Operations'),
('J5F','Joint Specialty, Joint Task Force, Finance'),
('J5H','Joint Specialty, Joint Task Force, Human Resources'),
('J5I','Joint Specialty, Joint Task Force, Intelligence'),
('J5L','Joint Specialty, Joint Task Force, Logistics'),
('J5M','Joint Specialty, Joint Task Force, Medical'),
('J5O','Joint Specialty, Joint Task Force, Operations'),
('J5P','Joint Specialty, Joint Task Force, Planning'),
('J5T','Joint Specialty, Joint Task Force, Training'),
('J5X','Joint Specialty, Joint Task Force, Improvised Explosive Device'),
('J6A','Joint Specialty, Other, Acquisition'),
('J6B','Joint Specialty, Other, AFPAK Hands'),
('J6C','Joint Specialty, Other, Civil Affairs'),
('J6D','Joint Specialty, Other, Detainee Operations'),
('J6F','Joint Specialty, Other, Finance'),
('J6H','Joint Specialty, Other, Human Resources'),
('J6I','Joint Specialty, Other, Intelligence'),
('J6L','Joint Specialty, Other, Logistics'),
('J6M','Joint Specialty, Other, Medical'),
('J6O','Joint Specialty, Other, Operations'),
('J6P','Joint Specialty, Other, Planning'),
('J6T','Joint Specialty, Other, Training'),
('J6X','Joint Specialty, Other, Improvised Explosive Device'),
('JC1','Joint Specialty, Terminal Attack Controller, Qualified'),
('JC2','Joint Specialty, Terminal Attack Controller, Instructor'),
('JD1','Joint Specialty, Joint Billet, JDA Billet'),
('JD2','Joint Specialty, Joint Billet, JDA Critical Billet'),
('JJ1','Joint Specialty, Joint Operations Planning and Execution System (JOPES), JOPES Proficiency'),
('JN1','Joint Specialty, Navy Emergency Preparedness Liaison Officer (NEPLO), Qualified'),
('JOM','Joint Specialty, Operational Level Command and Control, Maritime'),
('JP1','Joint Specialty, Joint, Operational Planner'),
('JP2','Joint Specialty, Joint, Operational Planner'),
('JP3','Joint Specialty, Joint, Operational Planner'),
('JPM','Joint Specialty, Maritime Operational Planner'),
('JPN','Joint Specialty, Operational Planner'),
('JS1','Joint Specialty, JPME Graduate'),
('JS2','Joint Specialty, Full Joint Tour Credit'),
('JS3','Joint Specialty, JPME Joint Specialty Nominee'),
('JS4','Joint Specialty, JQS Level II'),
('JS5','Joint Specialty, Joint Qualified Officer (JQO) JQS Level III'),
('JS6','Joint Specialty, JQS Level IV'),
('JS7','Joint Specialty, JPME Phase I Graduate'),
('JS8','Joint Specialty, JPME Phase II Graduate'),
('JS9','Joint Specialty, COS Takeout JQO JQS Level III'),
('JSA','Joint Specialty, AJPME'),
('JSF','Joint Specialty, Joint Duty Assignment (JDA) for Flag'),
('JSR','Joint Specialty, Joint Duty Assignment required after one tour deferral'),
('KA1','Surface Warfare, Qualified Surface Missile Systems Officer , TALOS'),
('KA2','Surface Warfare, Qualified Surface Missile Systems Officer , TERRIER NTDS'),
('KA4','Surface Warfare, Qualified Surface Missile Systems Officer , TARTAR JPTDS'),
('KA5','Surface Warfare, Qualified Surface Missile Systems Officer , TARTAR Non-JPTDS'),
('KA6','Surface Warfare, Qualified Surface Missile Systems Officer , AEGIS'),
('KD1','Surface Warfare, Surface Nuclear Power, Nuclear Propulsion Operator'),
('KD2','Surface Warfare, Surface Nuclear Power, Nuclear Ship Engineer'),
('KD3','Surface Warfare, Surface Nuclear Power, Nuclear Power (Enlisted)'),
('KD4','Surface Warfare, Surface Nuclear Power, LDO and WO Nuclear Power Operator'),
('KD5','Surface Warfare, Surface Nuclear Power, Nuclear RADCON'),
('KD6','Surface Warfare, Surface Nuclear Power, Trainee'),
('KD7','Surface Warfare, Surface Nuclear Power, Naval Reactors Qualified'),
('KD8','Surface Warfare, Surface Nuclear Power, Nuclear Qualifying Assignment Billet'),
('KD9','Surface Warfare, Surface Nuclear Power, NR Support Billet'),
('KG0','Surface Warfare, Explosive Ordnance Disposal, Department Head'),
('KG1','Surface Warfare, Explosive Ordnance Disposal, Basic'),
('KG2','Surface Warfare, Explosive Ordnance Disposal, Senior'),
('KG3','Surface Warfare, Explosive Ordnance Disposal, Master'),
('KG4','Surface Warfare, Explosive Ordnance Disposal, Ordnance Clearance Diver'),
('KG5','Surface Warfare, Explosive Ordnance Disposal, EOD Warfare'),
('KG6','Surface Warfare, Explosive Ordnance Disposal, Executive Officer'),
('KG7','Surface Warfare, Explosive Ordnance Disposal, CDR Command'),
('KG8','Surface Warfare, Explosive Ordnance Disposal, Major Command'),
('KH9','Surface Warfare, Qualified in Riverine Warfare, Unspecified'),
('KI1','Surface Warfare, Qualified in River, Coastal, and Combatant Craft Unconventional Warfare, Operational'),
('KJ1','Surface Warfare, Drydocking Officer, General'),
('KJ2','Surface Warfare, Drydocking Officer, Floating Drydock'),
('KK1','Surface Warfare, Expendable Ordnance Management, Basic'),
('KK2','Surface Warfare, Expendable Ordnance Management, Operational'),
('KK3','Surface Warfare, Expendable Ordnance Management, Master'),
('KL0','Surface Warfare, Qualified Diving Officer , Basic'),
('KM1','Surface Warfare, Ship Salvage Diving Officer, Basic'),
('KM2','Surface Warfare, Ship Salvage Diving Officer, Operational'),
('KN1','Surface Warfare, HeO2 Qualified Diving Officer, Basic'),
('KN2','Surface Warfare, HeO2 Qualified Diving Officer, Operational'),
('KP0','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Qualified'),
('KP1','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Basic'),
('KP2','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Operational'),
('KR1','Surface Warfare, Ship Salvage Operations Officer, Operational'),
('KS1','Surface Warfare, Surface Warfare Enterprise, SWE Officer'),
('KT1','Surface Warfare, LCS, General Dynamics Hull, Command'),
('KT2','Surface Warfare, LCS, General Dynamics Hull, Operations'),
('KT3','Surface Warfare, LCS, General Dynamics Hull, Weapons'),
('KT4','Surface Warfare, LCS, General Dynamics Hull, Combat Systems'),
('KT5','Surface Warfare, LCS, General Dynamics Hull, Electronics Material Officer'),
('KT6','Surface Warfare, LCS, General Dynamics Hull, Engineer'),
('KT7','Surface Warfare, LCS, General Dynamics Hull, Main Propulsion Assistant'),
('KU1','Surface Warfare, LCS, Lockheed Martin Hull, Command'),
('KU2','Surface Warfare, LCS, Lockheed Martin Hull, Operations'),
('KU3','Surface Warfare, LCS, Lockheed Martin Hull, Mission Control Center Officer'),
('KU4','Surface Warfare, LCS, Lockheed Martin Hull, Combat Systems Officer'),
('KU5','Surface Warfare, LCS, Lockheed Martin Hull, Electronics Material Officer'),
('KU6','Surface Warfare, LCS, Lockheed Martin Hull, Engineer'),
('KU7','Surface Warfare, LCS, Lockheed Martin Hull, Main Propulsion Assistant'),
('KW2','Surface Warfare, Weapons Tactics Instructor (WTI), Integrated Air Missile Defense (IAMD)'),
('KX1','Surface Warfare, Surface Anti-Submarine Warfare (SuASW), Weapons Tactics Instructor (WTI)'),
('LA7','Surface Warfare, Qualified, MedicalDepartment'),
('LA8','Surface Warfare, Qualified, Supply Corps'),
('LA9','Surface Warfare, Qualified'),
('LB1','Surface Warfare, Qualified OOD, Independent Steaming'),
('LB2','Surface Warfare, Qualified OOD, Fleet Maneuvers Task Group/Force Operations'),
('LB3','Surface Warfare, Qualified OOD, CDO Underway'),
('LB4','Surface Warfare, Qualified OOD, Conning Officer Alongside'),
('LC1','Surface Warfare, Engineering, EOOW (Steam)'),
('LC2','Surface Warfare, Engineering, EOOW (Diesel)'),
('LC3','Surface Warfare, Engineering, EOOW (Gas Turbine)'),
('LC4','Surface Warfare, Engineering, EOOW (ACC) (Supersedes LC1)'),
('LC5','Surface Warfare, Engineering, EOOW (CVN)'),
('LD9','Surface Warfare, Weapons Control , Qualified'),
('LF6','Surface Warfare, Evaluator/Tactical Action Officer, Qualified in Non-NTDS equipped unit'),
('LF7','Surface Warfare, Evaluator/Tactical Action Officer, Qualified in NTDS equipped unit'),
('LG1','Surface Warfare, Navigation Expert, Surface Ship'),
('LG2','Surface Warfare, Navigation Expert, Navigator/Assistant Navigator, CVN'),
('LK9','Surface Warfare, Executive Officer Afloat (LCDR and above) , Unspecified'),
('LN1','Surface Warfare, Command (Supersedes LM), LT Command'),
('LN2','Surface Warfare, Command (Supersedes LM), LCDR Command'),
('LN3','Surface Warfare, Command (Supersedes LM), CDR Command'),
('LN4','Surface Warfare, Command (Supersedes LM), CAPT Command'),
('LN7','Surface Warfare, Command, Qualified Surface Command Commander'),
('LN8','Surface Warfare, Command, Qualified Surface Command Captain'),
('LOA','Surface Warfare, Option Officer, ED Option'),
('LOB','Surface Warfare, Option Officer, IP Option'),
('LOC','Surface Warfare, Option Officer, IW Option'),
('LOD','Surface Warfare, Option Officer, OCN Option'),
('LOE','Surface Warfare, Option Officer, Intelligence Option'),
('LS0','Surface Warfare, Specialty Career Path, Education and Training Management'),
('LS1','Surface Warfare, Specialty Career Path, Missile Defense'),
('LS2','Surface Warfare, Specialty Career Path, AT/FP'),
('LS3','Surface Warfare, Specialty Career Path, Anti-Submarine Warfare'),
('LS4','Surface Warfare, Specialty Career Path, Mine Warfare'),
('LS5','Surface Warfare, Specialty Career Path, Shore Installation Management'),
('LS6','Surface Warfare, Specialty Career Path, Strategic Sealift'),
('LS7','Surface Warfare, Specialty Career Path, Financial Management'),
('LS8','Surface Warfare, Specialty Career Path, Naval Operational Planner'),
('LS9','Surface Warfare, Specialty Career Path, Operations Analysis'),
('LT1','Surface Warfare, Tactical Digital Information Link (TDL) Officer, Qualified Interface Control Officer (ICO)'),
('LT2','Surface Warfare, Tactical Digital Information Link (TDL) Officer, Qualified Joint Interface Control Officer (JICO)'),
('MH1','Oceanography (METOC), Hydrographer, Naval Hydrographer'),
('MH2','Oceanography (METOC), Hydrographer, Apprentice Naval Hydrographer'),
('NA0','Financial Management, Accounting (Primary), No Masters level education, single experience tour'),
('NA1','Financial Management, Accounting (Primary), No Masters level education, multiple experience tours'),
('NA2','Financial Management, Accounting (Primary), Single SECNAV/OPNAV experience tour'),
('NA3','Financial Management, Accounting (Primary), Multiple SECNAV/OPNAV experience tours'),
('NA4','Financial Management, Accounting (Primary), Single JOINT tour'),
('NA5','Financial Management, Accounting (Primary), Multiple JOINT tours'),
('NA6','Financial Management, Accounting (Primary), SECNAV/OPNAV and JOINT tours'),
('NA7','Financial Management, Accounting (Primary), SECNAV/OPNAV and JOINT other tours'),
('NA8','Financial Management, Accounting (Primary), Fleet (any level) tour'),
('NA9','Financial Management, Accounting (Primary)'),
('NB0','Financial Management, Budget (Primary), No Masters level education, single experience tour'),
('NB1','Financial Management, Budget (Primary), No Masters level education, multiple experience tours'),
('NB2','Financial Management, Budget (Primary), Single SECNAV/OPNAV experience tour'),
('NB3','Financial Management, Budget (Primary), Multiple SECNAV/OPNAV experience tours'),
('NB4','Financial Management, Budget (Primary), Single JOINT tour'),
('NB5','Financial Management, Budget (Primary), Multiple JOINT tours'),
('NB6','Financial Management, Budget (Primary), SECNAV/OPNAV and JOINT tours'),
('NB7','Financial Management, Budget (Primary), SECNAV/OPNAV and JOINT other tours'),
('NB8','Financial Management, Budget (Primary), Fleet (any level) tour'),
('NB9','Financial Management, Budget (Primary), Fleet (any level) and JOINT (any) tours'),
('NC0','Financial Management, Comptroller (Primary), No Masters level education, single experience tour'),
('NC1','Financial Management, Comptroller (Primary), No Masters level education, multiple experience tours'),
('NC2','Financial Management, Comptroller (Primary), Single SECNAV/OPNAV experience tour'),
('NC3','Financial Management, Comptroller (Primary), Multiple SECNAV/OPNAV experience tours'),
('NC4','Financial Management, Comptroller (Primary), Single JOINT tour'),
('NC5','Financial Management, Comptroller (Primary), Multiple JOINT tours'),
('NC6','Financial Management, Comptroller (Primary), SECNAV/OPNAV and JOINT tours'),
('NC7','Financial Management, Comptroller (Primary), SECNAV/OPNAV and JOINT other tours'),
('NC8','Financial Management, Comptroller (Primary), Fleet (any level) tour'),
('NC9','Financial Management, Comptroller (Primary), Fleet (any level) and JOINT (any) tours'),
('ND0','Financial Management, Disbursing (Primary), No Masters level education, single experience tour'),
('ND1','Financial Management, Disbursing (Primary), No Masters level education, multiple experience tours'),
('ND2','Financial Management, Disbursing (Primary), Single SECNAV/OPNAV experience tour'),
('ND3','Financial Management, Disbursing (Primary), Multiple SECNAV/OPNAV experience tours'),
('ND4','Financial Management, Disbursing (Primary), Single JOINT tour'),
('ND5','Financial Management, Disbursing (Primary), Multiple JOINT tours'),
('ND6','Financial Management, Disbursing (Primary), SECNAV/OPNAV and JOINT tours'),
('ND7','Financial Management, Disbursing (Primary), SECNAV/OPNAV and JOINT other tours'),
('ND8','Financial Management, Disbursing (Primary), Fleet (any level) tour'),
('ND9','Financial Management, Disbursing (Primary), Fleet (any level) and JOINT (any) tours'),
('NE0','Financial Management, Internal Review (Primary), No Masters level education, single experience tour'),
('NE1','Financial Management, Internal Review (Primary), No Masters level education, multiple experience tours'),
('NE2','Financial Management, Internal Review (Primary), Single SECNAV/OPNAV experience tour'),
('NE3','Financial Management, Internal Review (Primary), Multiple SECNAV/OPNAV experience tours'),
('NE4','Financial Management, Internal Review (Primary), Single JOINT tour'),
('NE5','Financial Management, Internal Review (Primary), Multiple JOINT tours'),
('NE6','Financial Management, Internal Review (Primary), SECNAV/OPNAV and JOINT tours'),
('NE7','Financial Management, Internal Review (Primary), SECNAV/OPNAV and JOINT other tours'),
('NE8','Financial Management, Internal Review (Primary), Fleet (any level) tour'),
('NE9','Financial Management, Internal Review (Primary), Fleet (any level) and JOINT (any) tours'),
('NF0','Financial Management, Dual Accounting and Budget, No Masters level education, single experience tour'),
('NF1','Financial Management, Dual Accounting and Budget, No Masters level education, multiple experience tours'),
('NF2','Financial Management, Dual Accounting and Budget, Single SECNAV/OPNAV experience tour'),
('NF3','Financial Management, Dual Accounting and Budget, Multiple SECNAV/OPNAV experience tours'),
('NF4','Financial Management, Dual Accounting and Budget, Single JOINT tour'),
('NF5','Financial Management, Dual Accounting and Budget, Multiple JOINT tours'),
('NF6','Financial Management, Dual Accounting and Budget, SECNAV/OPNAV and JOINT tours'),
('NF7','Financial Management, Dual Accounting and Budget, SECNAV/OPNAV and JOINT other tours'),
('NF8','Financial Management, Dual Accounting and Budget, Fleet (any level) tour'),
('NF9','Financial Management, Dual Accounting and Budget, Fleet (any level) and JOINT (any) tours'),
('NG0','Financial Management, Dual Accounting and Comptroller, No Masters level education, single experience tour'),
('NG1','Financial Management, Dual Accounting and Comptroller, No Masters level education, multiple experience tours'),
('NG2','Financial Management, Dual Accounting and Comptroller, Single SECNAV/OPNAV experience tour'),
('NG3','Financial Management, Dual Accounting and Comptroller, Multiple SECNAV/OPNAV experience tours'),
('NG4','Financial Management, Dual Accounting and Comptroller, Single JOINT tour'),
('NG5','Financial Management, Dual Accounting and Comptroller, Multiple JOINT tours'),
('NG6','Financial Management, Dual Accounting and Comptroller, SECNAV/OPNAV and JOINT tours'),
('NG7','Financial Management, Dual Accounting and Comptroller, SECNAV/OPNAV and JOINT other tours'),
('NG8','Financial Management, Dual Accounting and Comptroller, Fleet (any level) tour'),
('NG9','Financial Management, Dual Accounting and Comptroller, Fleet (any level) and JOINT (any) tours'),
('NH0','Financial Management, Dual Accounting and Disbursing, No Masters level education, single experience tour'),
('NH1','Financial Management, Dual Accounting and Disbursing, No Masters level education, multiple experience tours'),
('NH2','Financial Management, Dual Accounting and Disbursing, Single SECNAV/OPNAV experience tour'),
('NH3','Financial Management, Dual Accounting and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NH4','Financial Management, Dual Accounting and Disbursing, Single JOINT tour'),
('NH5','Financial Management, Dual Accounting and Disbursing, Multiple JOINT tours'),
('NH6','Financial Management, Dual Accounting and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NH7','Financial Management, Dual Accounting and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NH8','Financial Management, Dual Accounting and Disbursing, Fleet (any level) tour'),
('NH9','Financial Management, Dual Accounting and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NI0','Financial Management, Dual Accounting and Internal Review, No Masters level education, single experience tour'),
('NI1','Financial Management, Dual Accounting and Internal Review, No Masters level education, multiple experience tours'),
('NI2','Financial Management, Dual Accounting and Internal Review, Single SECNAV/OPNAV experience tour'),
('NI3','Financial Management, Dual Accounting and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NI4','Financial Management, Dual Accounting and Internal Review, Single JOINT tour'),
('NI5','Financial Management, Dual Accounting and Internal Review, Multiple JOINT tours'),
('NI6','Financial Management, Dual Accounting and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NI7','Financial Management, Dual Accounting and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NI8','Financial Management, Dual Accounting and Internal Review, Fleet (any level) tour'),
('NI9','Financial Management, Dual Accounting and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NJ0','Financial Management, Dual Budget and Comptroller, No Masters level education, single experience tour'),
('NJ1','Financial Management, Dual Budget and Comptroller, No Masters level education, multiple experience tours'),
('NJ2','Financial Management, Dual Budget and Comptroller, Single SECNAV/OPNAV experience tour'),
('NJ3','Financial Management, Dual Budget and Comptroller, Multiple SECNAV/OPNAV experience tours'),
('NJ4','Financial Management, Dual Budget and Comptroller, Single JOINT tour'),
('NJ5','Financial Management, Dual Budget and Comptroller, Multiple JOINT tours'),
('NJ6','Financial Management, Dual Budget and Comptroller, SECNAV/OPNAV and JOINT tours'),
('NJ7','Financial Management, Dual Budget and Comptroller, SECNAV/OPNAV and JOINT other tours'),
('NJ8','Financial Management, Dual Budget and Comptroller, Fleet (any level) tour'),
('NJ9','Financial Management, Dual Budget and Comptroller, Fleet (any level) and JOINT (any) tours'),
('NK0','Financial Management, Dual Budget and Disbursing, No Masters level education, single experience tour'),
('NK1','Financial Management, Dual Budget and Disbursing, No Masters level education, multiple experience tours'),
('NK2','Financial Management, Dual Budget and Disbursing, Single SECNAV/OPNAV experience tour'),
('NK3','Financial Management, Dual Budget and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NK4','Financial Management, Dual Budget and Disbursing, Single JOINT tour'),
('NK5','Financial Management, Dual Budget and Disbursing, Multiple JOINT tours'),
('NK6','Financial Management, Dual Budget and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NK7','Financial Management, Dual Budget and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NK8','Financial Management, Dual Budget and Disbursing, Fleet (any level) tour'),
('NK9','Financial Management, Dual Budget and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NL0','Financial Management, Dual Budget and Internal Review, No Masters level education, single experience tour'),
('NL1','Financial Management, Dual Budget and Internal Review, No Masters level education, multiple experience tours'),
('NL2','Financial Management, Dual Budget and Internal Review, Single SECNAV/OPNAV experience tour'),
('NL3','Financial Management, Dual Budget and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NL4','Financial Management, Dual Budget and Internal Review, Single JOINT tour'),
('NL5','Financial Management, Dual Budget and Internal Review, Multiple JOINT tours'),
('NL6','Financial Management, Dual Budget and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NL7','Financial Management, Dual Budget and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NL8','Financial Management, Dual Budget and Internal Review, Fleet (any level) tour'),
('NL9','Financial Management, Dual Budget and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NM0','Financial Management, Dual Comptroller and Disbursing, No Masters level education, single experience tour'),
('NM1','Financial Management, Dual Comptroller and Disbursing, No Masters level education, multiple experience tours'),
('NM2','Financial Management, Dual Comptroller and Disbursing, Single SECNAV/OPNAV experience tour'),
('NM3','Financial Management, Dual Comptroller and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NM4','Financial Management, Dual Comptroller and Disbursing, Single JOINT tour'),
('NM5','Financial Management, Dual Comptroller and Disbursing, Multiple JOINT tours'),
('NM6','Financial Management, Dual Comptroller and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NM7','Financial Management, Dual Comptroller and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NM8','Financial Management, Dual Comptroller and Disbursing, Fleet (any level) tour'),
('NM9','Financial Management, Dual Comptroller and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NN0','Financial Management, Dual Comptroller and Internal Review, No Masters level education, single experience tour'),
('NN1','Financial Management, Dual Comptroller and Internal Review, No Masters level education, multiple experience tours'),
('NN2','Financial Management, Dual Comptroller and Internal Review, Single SECNAV/OPNAV experience tour'),
('NN3','Financial Management, Dual Comptroller and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NN4','Financial Management, Dual Comptroller and Internal Review, Single JOINT tour'),
('NN5','Financial Management, Dual Comptroller and Internal Review, Multiple JOINT tours'),
('NN6','Financial Management, Dual Comptroller and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NN7','Financial Management, Dual Comptroller and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NN8','Financial Management, Dual Comptroller and Internal Review, Fleet (any level) tour'),
('NN9','Financial Management, Dual Comptroller and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NO0','Financial Management, Dual Disbursing and Internal Review, No Masters level education, single experience tour'),
('NO1','Financial Management, Dual Disbursing and Internal Review, No Masters level education, multiple experience tours'),
('NO2','Financial Management, Dual Disbursing and Internal Review, Single SECNAV/OPNAV experience tour'),
('NO3','Financial Management, Dual Disbursing and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NO4','Financial Management, Dual Disbursing and Internal Review, Single JOINT tour'),
('NO5','Financial Management, Dual Disbursing and Internal Review, Multiple JOINT tours'),
('NO6','Financial Management, Dual Disbursing and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NO7','Financial Management, Dual Disbursing and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NO8','Financial Management, Dual Disbursing and Internal Review, Fleet (any level) tour'),
('NO9','Financial Management, Dual Disbursing and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NP0','Financial Management, Appropriation Legislative Liaison, No Masters level education, single experience tour'),
('NP1','Financial Management, Appropriation Legislative Liaison, No Masters level education, multiple experience tours'),
('NP2','Financial Management, Appropriation Legislative Liaison, Single SECNAV/OPNAV experience tour'),
('NP3','Financial Management, Appropriation Legislative Liaison, Multiple SECNAV/OPNAV experience tours'),
('NP4','Financial Management, Appropriation Legislative Liaison, Single JOINT tour'),
('NP5','Financial Management, Appropriation Legislative Liaison, Multiple JOINT tours'),
('NP6','Financial Management, Appropriation Legislative Liaison, SECNAV/OPNAV and JOINT tours'),
('NP7','Financial Management, Appropriation Legislative Liaison, SECNAV/OPNAV and JOINT other tours'),
('NP8','Financial Management, Appropriation Legislative Liaison, Fleet (any level) tour'),
('NP9','Financial Management, Appropriation Legislative Liaison, Fleet (any level) and JOINT (any) tours'),
('NQ0','Financial Management, Any combination of 3 primary qualifications, No Masters level education, single experience tour'),
('NQ1','Financial Management, Any combination of 3 primary qualifications, No Masters level education, multiple experience tours'),
('NQ2','Financial Management, Any combination of 3 primary qualifications, Single SECNAV/OPNAV experience tour'),
('NQ3','Financial Management, Any combination of 3 primary qualifications, Multiple SECNAV/OPNAV experience tours'),
('NQ4','Financial Management, Any combination of 3 primary qualifications, Single JOINT tour'),
('NQ5','Financial Management, Any combination of 3 primary qualifications, Multiple JOINT tours'),
('NQ6','Financial Management, Any combination of 3 primary qualifications, SECNAV/OPNAV and JOINT tours'),
('NQ7','Financial Management, Any combination of 3 primary qualifications, SECNAV/OPNAV and JOINT other tours'),
('NQ8','Financial Management, Any combination of 3 primary qualifications, Fleet (any level) tour'),
('NQ9','Financial Management, Any combination of 3 primary qualifications, Fleet (any level) and JOINT (any) tours'),
('NR1','Financial Management, CDFM'),
('NR2','Financial Management, CDFM-A'),
('NS1','Financial Management, DoD Financial Management Certification, Level 1'),
('NS2','Financial Management, DoD Financial Management Certification, Level 2'),
('NS3','Financial Management, DoD Financial Management Certification, Level 3'),
('PA1','Navy Security Force Officer, Basic'),
('PA2','Navy Security Force Officer, Advanced'),
('PB1','Navy Security Force, Installation Security Officer (ISO), CONUS'),
('PB2','Navy Security Force, Installation Security Officer (ISO), OCONUS'),
('PC1','Navy Security Force, Force Protection/Antiterrorism Officer, Base or Activity'),
('PC2','Navy Security Force, Force Protection/Antiterrorism Officer, Staff'),
('PD1','Navy Security Force, Strategic Systems Programs, Security Officer'),
('QB1','Special Warfare, UDT Qualified, Fleet experienced (2 or more deployments)'),
('QB9','Special Warfare, UDT Qualified, Unspecified'),
('QC1','Special Warfare, SEAL Qualified , Fleet Experienced'),
('QC9','Special Warfare, SEAL Qualified, Unspecified'),
('QD1','Special Warfare, Qualified Platoon Commander/Major Department Head of a SEAL/SBT/SDV/SA, Fleet Experienced'),
('QD9','Special Warfare, Qualified Platoon Commander/Major Department Head SEAL/SBT/SDV/SA, Tour Complete'),
('QE1','Special Warfare, Qualified for Executive Officer of SEAL/SBT/ SDV/SA/Tac D&E Sqdn and equivalent tour, Fleet Experienced'),
('QF1','Special Warfare, Qualified for Team Commanding Officer of SEAL/SBT/SDV/SA/Tac D&E Sqdn and equivalent tour, Fleet Experienced'),
('QG1','Special Warfare, Major Command, Unspecified'),
('QI1','Special Warfare, SDV Qualified , Fleet Experienced'),
('QI9','Special Warfare, SDV Qualified , Qualified'),
('QJ1','Special Warfare, DDS Qualified, Fleet Experienced'),
('QK1','Special Warfare, Qualified as Non-SEAL/SWCC Officer Special Warfare Experience, Fleet Experienced'),
('QK2','Special Warfare, Qualified as NSW Non-SEAL/SWCC Officer Special Warfare Experience, Command Experience'),
('QK3','Special Warfare, Qualified as Non-SEAL/SWCC Officer Special Warfare Experience, Naval Special Warfare Experience'),
('RA1','Human Resources, Human Resource Officer, Professional in Human Resources (PHR) Certified'),
('RA2','Human Resources, Human Resource Officer, Senior Professional in Human Resources (SPHR) Certified'),
('RA3','Human Resources, Human Resource Officer, Global Professional in Human Resources (GPHR) Certified'),
('RA4','Human Resources, Human Resource Officer, Certified Performance Technologist (CPT)'),
('RB4','Human Resources, HR Major Command/Milestone Assignment, Lieutenant Commander'),
('RB5','Human Resources, HR Major Command/Milestone Assignment, Commander'),
('RB6','Human Resources, HR Major Command/Milestone Assignment, Captain'),
('RC4','Human Resources, HR Post-Milestone Assignment, Lieutenant Commander'),
('RC5','Human Resources, HR Post-Milestone Assignment, Commander'),
('RC6','Human Resources, HR Post-Milestone Assignment, Captain'),
('RD1','Human Resources, Development'),
('RD2','Human Resources, Development'),
('RD3','Human Resources, Development'),
('RD4','Human Resources, Development'),
('RD5','Human Resources, Development'),
('RD6','Human Resources, Development'),
('RD7','Human Resources, Development'),
('RD8','Human Resources, Development'),
('RD9','Human Resources, Development'),
('RE1','Human Resources, Management'),
('RE2','Human Resources, Management'),
('RE3','Human Resources, Management'),
('RE4','Human Resources, Management'),
('RE5','Human Resources, Management'),
('RE6','Human Resources, Management'),
('RE7','Human Resources, Management'),
('RE8','Human Resources, Management'),
('RE9','Human Resources, Management'),
('RF1','Human Resources, Requirements'),
('RF2','Human Resources, Requirements'),
('RF3','Human Resources, Requirements'),
('RF4','Human Resources, Requirements'),
('RF5','Human Resources, Requirements'),
('RF6','Human Resources, Requirements'),
('RF7','Human Resources, Requirements'),
('RF8','Human Resources, Requirements'),
('RF9','Human Resources, Requirements'),
('RG1','Human Resources, Recruiting'),
('RG2','Human Resources, Recruiting'),
('RG3','Human Resources, Recruiting'),
('RG4','Human Resources, Recruiting'),
('RG5','Human Resources, Recruiting'),
('RG6','Human Resources, Recruiting'),
('RG7','Human Resources, Recruiting'),
('RG8','Human Resources, Recruiting'),
('RG9','Human Resources, Recruiting'),
('SC1','Submarine Warfare, Command, Qualified for diesel command'),
('SC2','Submarine Warfare, Command, Qualified for Nuclear Command'),
('SC3','Submarine Warfare, Command, Served SS command'),
('SC4','Submarine Warfare, Command, Served SSN Command'),
('SC5','Submarine Warfare, Command, Served SSBN Command'),
('SC6','Submarine Warfare, Command, Served Post SSN/SSBN Command'),
('SC7','Submarine Warfare, Command, Served ASR Command'),
('SD0','Submarine Warfare, Submarine Officer, Assistant Weapons Officer (SSBN)'),
('SD1','Submarine Warfare, Submarine Officer, SSBN SWS Officer'),
('SD2','Submarine Warfare, Submarine Officer, Weapons DH Qual'),
('SD3','Submarine Warfare, Submarine Officer, Served Polaris Weps'),
('SD4','Submarine Warfare, Submarine Officer, Served Poseidon Weps'),
('SD5','Submarine Warfare, Submarine Officer, Served Trident Weps'),
('SD6','Submarine Warfare, Submarine Officer, Served post SSBN Weps'),
('SD7','Submarine Warfare, SCUBA Trained Officer, Qualified'),
('SE1','Submarine Warfare, Submarine Officer, Served Polaris Navigator'),
('SE2','Submarine Warfare, Submarine Officer, Served Poseidon Navigator'),
('SE3','Submarine Warfare, Submarine Officer, Served Trident Navigator'),
('SE4','Submarine Warfare, Submarine Officer, Served post SSBN Navigator'),
('SN0','Submarine Warfare, Nuclear Trained Officer, General'),
('SN1','Submarine Warfare, Nuclear Trained Officer, Engineer Qualified'),
('SN2','Submarine Warfare, Nuclear Trained Officer, Served Engineer'),
('SN3','Submarine Warfare, Nuclear Trained Officer, Served post Engineer'),
('SN9','Submarine Warfare, Nuclear Trained Officer, NR Support Billet'),
('SP0','Submarine Warfare, Nuclear Weapons, Strategic Weapons Officer Qualified'),
('SP1','Submarine Warfare, Nuclear Weapons, Nuclear Command and Control (NC2)'),
('SP2','Submarine Warfare, Nuclear Weapons, SSBN AWEPS'),
('SP3','Submarine Warfare, Nuclear Weapons, SSBN WEPS'),
('SP4','Submarine Warfare, Nuclear Weapons, SSBN NAV'),
('SP5','Submarine Warfare, Nuclear Weapons, SSBN XO'),
('SP6','Submarine Warfare, Nuclear Weapons, Nuclear Weapons Junior Technical Supervisor'),
('SP7','Submarine Warfare, Nuclear Weapons, Nuclear Weapons Senior Technical Supervisor'),
('SP8','Submarine Warfare, Nuclear Weapons, General Strategic Policy'),
('SPA','Submarine Warfare, Nuclear Weapons, Any Strategic Weapons Experience'),
('SPI','Submarine Warfare, Nuclear Weapons, Intermediate Strategic Deterrence Education'),
('SPS','Submarine Warfare, Nuclear Weapons, Senior Strategic Deterrence Education'),
('SQ1','Submarine Warfare, Submarine Qualified SC Officer, Supply Corps'),
('SR1','Submarine Warfare, Submarine Rescue, Submarine Rescue Officer'),
('SS1','Submarine Warfare, DSV, Operator'),
('SU0','Submarine Warfare, Submarine Qualified ED Officer, General'),
('SV1','Submarine Warfare, Enlisted Submarine Qualified, General'),
('SW1','Submarine Warfare, Deep Submergence, Staff'),
('SW2','Submarine Warfare, Deep Submergence, Operational'),
('SW3','Submarine Warfare, Deep Submergence, Ocean Engineering'),
('TD1','Strategic Sealift Officer, Deck Officer, Chief Mate'),
('TD2','Strategic Sealift Officer, Deck Officer, Second Mate'),
('TD3','Strategic Sealift Officer, Deck Officer, Third Mate'),
('TDL','Strategic Sealift Officer, Deck Officer, Master, Limited'),
('TDM','Strategic Sealift Officer, Deck Officer, Master'),
('TDP','Strategic Sealift Officer, Deck Officer, First Class Pilot'),
('TE1','Strategic Sealift Officer, Engineer Officer, Steam, First Assistant Engineer'),
('TE2','Strategic Sealift Officer, Engineer Officer, Steam, Second Assistant Engineer'),
('TE3','Strategic Sealift Officer, Engineer Officer, Steam, Third Assistant Engineer'),
('TEE','Strategic Sealift Officer, Engineer Officer, Steam, Chief Engineer'),
('TEL','Merchant Marine, Engineer Officer, Steam, Chief Engineer Limited'),
('TF1','Strategic Sealift Officer, Engineer Officer, Motor, First Assistant Engineer'),
('TF2','Strategic Sealift Officer, Engineer Officer, Motor, Second Assistant Engineer'),
('TF3','Strategic Sealift Officer, Engineer Officer, Motor, Third Assostant Engineer'),
('TFE','Strategic Sealift Officer, Engineer Officer, Motor, Chief Engineer'),
('TFL','Merchant Marine, Engineer Officer, Steam, Chief Engineer, limited'),
('TG1','Strategic Sealift Officer, Engineer Officer, Gas Turbine, First Assistant Engineer'),
('TG2','Strategic Sealift Officer, Engineer Officer, Gas Turbine, Second Assistant Engineer'),
('TG3','Strategic Sealift Officer, Engineer Officer, Gas Turbine, Third Assistant Engineer'),
('TGE','Strategic Sealift Officer, Engineer Officer, Gas Turbine, Chief Engineer'),
('TP1','Strategic Sealift Officer, Personnel Qualification Standard (PQS), Warfare Qualified'),
('U1A','Intra Service Specialty, Joint Staff, Acquisition'),
('U1C','Intra Service Specialty, Joint Staff, Civil Affairs'),
('U1D','Intra Service Specialty, Joint Staff, Detainee Operations'),
('U1F','Intra Service Specialty, Joint Staff, Finance'),
('U1H','Intra Service Specialty, Joint Staff, Human Resources'),
('U1I','Intra Service Specialty, Joint Staff, Intelligence'),
('U1L','Intra Service Specialty, Joint Staff, Logistics'),
('U1M','Intra Service Specialty, Joint Staff, Medical'),
('U1O','Intra Service Specialty, Joint Staff, Operations'),
('U1P','Intra Service Specialty, Joint Staff, Planning'),
('U1T','Intra Service Specialty, Joint Staff, Training'),
('U1X','Intra Service Specialty, Joint Staff, Improvised Explosive Device'),
('U2A','Intra Service Specialty, Multinational HQ, Acquisition'),
('U2C','Intra Service Specialty, Multinational HQ, Civil Affairs'),
('U2D','Intra Service Specialty, Multinational HQ, Detainee Operations'),
('U2F','Intra Service Specialty, Multinational HQ, Finance'),
('U2H','Intra Service Specialty, Multinational HQ, Human Resources'),
('U2I','Intra Service Specialty, Multinational HQ, Intelligence'),
('U2L','Intra Service Specialty, Multinational HQ, Logistics'),
('U2M','Intra Service Specialty, Multinational HQ, Medical'),
('U2O','Intra Service Specialty, Multinational HQ, Operations'),
('U2P','Intra Service Specialty, Multinational HQ, Planning'),
('U2T','Intra Service Specialty, Multinational HQ, Training'),
('U2X','Intra Service Specialty, Multinational HQ, Improvised Explosive Device'),
('U3A','Intra Service Specialty, Combatant Commander Level, Acquisition'),
('U3C','Intra Service Specialty, Combatant Commander Level, Civil Affairs'),
('U3D','Intra Service Specialty, Combatant Commander Level, Detainee Operations'),
('U3F','Intra Service Specialty, Combatant Commander Level, Finance'),
('U3H','Intra Service Specialty, Combatant Commander Level, Human Resources'),
('U3I','Intra Service Specialty, Combatant Commander Level, Intelligence'),
('U3L','Intra Service Specialty, Combatant Commander Level, Logistics'),
('U3M','Intra Service Specialty, Combatant Commander Level, Medical'),
('U3O','Intra Service Specialty, Combatant Commander Level, Operations'),
('U3P','Intra Service Specialty, Combatant Commander Level, Planning'),
('U3T','Intra Service Specialty, Combatant Commander Level, Training'),
('U3X','Intra Service Specialty, Combatant Commander Level, Improvised Explosive Device'),
('U4A','Intra Service Specialty, Fleet/Division Staff, Acquisition'),
('U4C','Intra Service Specialty, Fleet/Division Staff, Civil Affairs'),
('U4D','Intra Service Specialty, Fleet/Division Staff, Detainee Operations'),
('U4F','Intra Service Specialty, Fleet/Division Staff, Finance'),
('U4H','Intra Service Specialty, Fleet/Division Staff, Human Resources'),
('U4I','Intra Service Specialty, Fleet/Division Staff, Intelligence'),
('U4L','Intra Service Specialty, Fleet/Division Staff, Logistics'),
('U4M','Intra Service Specialty, Fleet/Division Staff, Medical'),
('U4O','Intra Service Specialty, Fleet/Division Staff, Operations'),
('U4P','Intra Service Specialty, Fleet/Division Staff, Planning'),
('U4T','Intra Service Specialty, Fleet/Division Staff, Training'),
('U4X','Intra Service Specialty, Fleet/Division Staff, Improvised Explosive Device'),
('U5A','Intra Service Specialty, Joint Task Force, Acquisition'),
('U5C','Intra Service Specialty, Joint Task Force, Civil Affairs'),
('U5D','Intra Service Specialty, Joint Task Force, Detainee Operations'),
('U5F','Intra Service Specialty, Joint Task Force, Finance'),
('U5H','Intra Service Specialty, Joint Task Force, Human Resources'),
('U5I','Intra Service Specialty, Joint Task Force, Intelligence'),
('U5L','Intra Service Specialty, Joint Task Force, Logistics'),
('U5M','Intra Service Specialty, Joint Task Force, Medical'),
('U5O','Intra Service Specialty, Joint Task Force, Operations'),
('U5P','Intra Service Specialty, Joint Task Force, Planning'),
('U5T','Intra Service Specialty, Joint Task Force, Training'),
('U5X','Intra Service Specialty, Joint Task Force, Improvised Explosive Device'),
('U6A','Intra Service Specialty, Other, Acquisition'),
('U6C','Intra Service Specialty, Other, Civil Affairs'),
('U6D','Intra Service Specialty, Other, Detainee Operations'),
('U6F','Intra Service Specialty, Other, Finance'),
('U6H','Intra Service Specialty, Other, Human Resources'),
('U6I','Intra Service Specialty, Other, Intelligence'),
('U6L','Intra Service Specialty, Other, Logistics'),
('U6M','Intra Service Specialty, Other, Medical'),
('U6O','Intra Service Specialty, Other, Operations'),
('U6P','Intra Service Specialty, Other, Planning'),
('U6T','Intra Service Specialty, Other, Training'),
('U6U','Intra Service Specialty, Other, Military Observer, United Nations Peacekeeping Operations'),
('U6X','Intra Service Specialty, Other, Improvised Explosive Device'),
('U7S','Intra Service Specialty, NATO, Staff Officer')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 4...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('VA1','Space and Electronic Warfare (SEW), Division Officer, Ensign'),
('VA2','Space and Electronic Warfare (SEW), Division Officer, Lieutenant Junior Grade'),
('VA3','Space and Electronic Warfare (SEW), Division Officer, Lieutenant'),
('VA4','Space and Electronic Warfare (SEW), Division Officer, Lieutenant Commander'),
('VA5','Space and Electronic Warfare (SEW), Division Officer, Commander'),
('VA6','Space and Electronic Warfare (SEW), Division Officer, Captain'),
('VB1','Space and Electronic Warfare (SEW), Department Head, Ensign'),
('VB2','Space and Electronic Warfare (SEW), Department Head, Lieutenant Junior Grade'),
('VB3','Space and Electronic Warfare (SEW), Department Head, Lieutenant'),
('VB4','Space and Electronic Warfare (SEW), Department Head, Lieutenant Commander'),
('VB5','Space and Electronic Warfare (SEW), Department Head, Commander'),
('VB6','Space and Electronic Warfare (SEW), Department Head, Captain'),
('VC1','Space and Electronic Warfare (SEW), Executive Officer, Ensign'),
('VC2','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant Junior Grade'),
('VC3','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant'),
('VC4','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant Commander'),
('VC5','Space and Electronic Warfare (SEW), Executive Officer, Commander'),
('VC6','Space and Electronic Warfare (SEW), Executive Officer, Captain'),
('VE1','Space and Electronic Warfare (SEW), Commanding Officer, Ensign'),
('VE2','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant Junior Grade'),
('VE3','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant'),
('VE4','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant Commander'),
('VE5','Space and Electronic Warfare (SEW), Commanding Officer, Commander'),
('VE6','Space and Electronic Warfare (SEW), Commanding Officer, Captain'),
('VF1','Space and Electronic Warfare (SEW), Major Command, Ensign'),
('VF2','Space and Electronic Warfare (SEW), Major Command, Lieutenant Junior Grade'),
('VF3','Space and Electronic Warfare (SEW), Major Command, Lieutenant'),
('VF4','Space and Electronic Warfare (SEW), Major Command, Lieutenant Commander'),
('VF5','Space and Electronic Warfare (SEW), Major Command, Commander'),
('VF6','Space and Electronic Warfare (SEW), Major Command, Captain'),
('VQ1','Space and Electronic Warfare (SEW), SEW Critical, Ensign'),
('VQ2','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant Junior Grade'),
('VQ3','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant'),
('VQ4','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant Commander'),
('VQ5','Space and Electronic Warfare (SEW), SEW Critical, Commander'),
('VQ6','Space and Electronic Warfare (SEW), SEW Critical, Captain'),
('VR1','Space and Electronic Warfare (SEW), Space Acquisition, Level 1'),
('VR2','Space and Electronic Warfare (SEW), Space Acquisition, Level 2'),
('VR3','Space and Electronic Warfare (SEW), Space Acquisition, Level 3'),
('VS1','Space and Electronic Warfare (SEW), Space Cadr1, Recruit'),
('VS2','Space and Electronic Warfare (SEW), Space Cadr2, Apprentice'),
('VS3','Space and Electronic Warfare (SEW), Space Cadr3, Journeyman'),
('VS4','Space and Electronic Warfare (SEW), Space Cadr4, Expert'),
('VS5','Space and Electronic Warfare (SEW), Space Cadre, Basic'),
('VS6','Space and Electronic Warfare (SEW), Space Cadre, Level 1'),
('VS7','Space and Electronic Warfare (SEW), Space Cadre, Level 2'),
('VS8','Space and Electronic Warfare (SEW), Space Cadre, Level 3'),
('VV5','Space and Electronic Warfare (SEW), SIWC2 Critical, Major Command/Senior Staff'),
('VX1','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Basic'),
('VX2','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Operations'),
('VX3','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Technical Expert'),
('VX4','Space and Electronic Warfare (SEW), Naval C4, Qualified Operational Commander (Captain and Commander billet only)'),
('111','Professional Development (General), Sailing, Inshore skipper'),
('112','Professional Development (General), Sailing, Racing Inshore'),
('113','Professional Development (General), Sailing, Offshore skipper'),
('114','Professional Development (General), Sailing, Master skipper'),
('115','Professional Development (General), Sailing, Instructor'),
('211','Professional Development (General), Scholarship, Burke Scholar'),
('212','Professional Development (General), Scholarship, CNO Scholar'),
('213','Professional Development (General), Scholarship, Daedalian Scholar'),
('214','Professional Development (General), Scholarship, Fulbright Scholar'),
('215','Professional Development (General), Scholarship, Guggenheim Scholar'),
('216','Professional Development (General), Scholarship, Hertz Scholar'),
('217','Professional Development (General), Scholarship, Morrison Scholar'),
('218','Professional Development (General), Scholarship, National Science Foundation Program'),
('219','Professional Development (General), Scholarship, Olmsted Scholar'),
('221','Professional Development (General), Scholarship, Rhodes Scholar'),
('222','Professional Development (General), Scholarship, Winston Churchill Foundation'),
('223','Professional Development (General), Scholarship, Other Scholarship'),
('224','Professional Development (General), Scholarship, Faculty'),
('225','Professional Development (General), Scholarship, Physical Education Staff'),
('226','Professional Development (General), Scholarship, Conrad Scholar'),
('227','Professional Development (General), Scholarship, Executive Analysis for the Warfare Commander Certificate'),
('229','Professional Development (General), Scholarship, Operational Law Graduate'),
('231','Professional Development (General), Scholarship, JCS Intern'),
('233','Professional Development (General), Scholarship, White House Fellowship'),
('240','Professional Development (General), Scholarship, Politico-Military Affairs'),
('241','Professional Development (General), Scholarship, Asia �Pacific Graduate'),
('242','Professional Development (General), Scholarship, Western Hemisphere'),
('243','Professional Development (General), Scholarship, Graduate of Africa Studies Concentration Program'),
('246','Professional Development (General), Scholarship, Graduate of EURASIA Studies Concentration Program'),
('248','Professional Development (General), Scholarship, Graduate of Insurgency and Terrorism Elective Cluster'),
('249','Professional Development (General), Scholarship, Graduate of Information Operations, Command and Control and battle space Awareness elective cluster'),
('251','Professional Development (General), Strategic Studies Group, Fellow'),
('252','Professional Development (General), Strategic Studies Group, Associate Fellow'),
('261','Professional Development (General), Leadership Training Courses, Instructor'),
('271','Professional Development (General), Scholarship, Graduate'),
('2A1','Professional Development (General), Permanent Military Professor, Permanent Military Professor (Select)'),
('2A2','Professional Development (General), Permanent Military Professor, Permanent Military Professor (Qualified)'),
('2B1','Professional Development (General), Industrial College of the Armed Forces, Supply Chain Management Concentration Program'),
('2C1','Professional Development (General), Continuous Process Improvement (CPI), Green Belt Certified'),
('2C2','Professional Development (General), Continuous Process Improvement (CPI), Black Belt Certified'),
('3A1','Intelligence, Targeting, USN Targeting Officer'),
('3A2','Intelligence, Targeting, Joint Targeting School Graduate'),
('3H2','Intelligence, Intelligence Officer, qualified in HUMINT, Naval Attache'),
('3R1','Intelligence, Intelligence Officer, qualified in ISR Management, Collection Manager'),
('3R2','Intelligence, Intelligence Officer, qualified in ISR Management, Collection / ISR Requirements Management'),
('3R3','Intelligence, Intelligence Officer, qualified in ISR Management, ISR Architecture Management'),
('3R8','Intelligence, Intelligence Officer, qualified in ISR Management, ISRT Architecture Management Graduate'),
('3R9','Intelligence, Intelligence Officer, qualified in ISR Management, Navy Collection Management Course Graduate'),
('4AJ','Legal Services, Appelate Judge'),
('4AK','Legal Services, Lawyer, Alaska Bar'),
('4AL','Legal Services, Lawyer, Alabama Bar'),
('4AR','Legal Services, Lawyer, Arkansas Bar'),
('4AZ','Legal Services, Lawyer, Arizona Bar'),
('4CA','Legal Services, Lawyer, California Bar'),
('4CO','Legal Services, Lawyer, Colorado Bar'),
('4CT','Legal Services, Lawyer, Connecticut Bar'),
('4DC','Legal Services, Lawyer, District of Columbia Bar'),
('4DE','Legal Services, Lawyer, Delaware Bar'),
('4FL','Legal Services, Lawyer, Florida Bar'),
('4GA','Legal Services, Lawyer, Georgia Bar'),
('4GU','Legal Services, Lawyer, Guam Bar'),
('4HI','Legal Services, Lawyer, Hawaii Bar'),
('4IA','Legal Services, Lawyer, Iowa Bar'),
('4ID','Legal Services, Lawyer, Idaho Bar'),
('4IL','Legal Services, Lawyer, Illinois Bar'),
('4IN','Legal Services, Lawyer, Indiana Bar'),
('4KS','Legal Services, Lawyer, Kansas Bar'),
('4KY','Legal Services, Lawyer, Kentucky Bar'),
('4LA','Legal Services, Lawyer, Louisiana Bar'),
('4MA','Legal Services, Lawyer, Massachusetts Bar'),
('4MD','Legal Services, Lawyer, Maryland Bar'),
('4ME','Legal Services, Lawyer, Maine Bar'),
('4MI','Legal Services, Lawyer, Michigan Bar'),
('4MJ','Legal Services, Military Judge'),
('4MN','Legal Services, Lawyer, Minnesota Bar'),
('4MO','Legal Services, Lawyer, Missouri Bar'),
('4MS','Legal Services, Lawyer, Mississippi Bar'),
('4MT','Legal Services, Lawyer, Montana Bar'),
('4NC','Legal Services, Lawyer, North Carolina Bar'),
('4ND','Legal Services, Lawyer, North Dakota Bar'),
('4NE','Legal Services, Lawyer, Nebraska Bar'),
('4NH','Legal Services, Lawyer, New Hampshire Bar'),
('4NJ','Legal Services, Lawyer, New Jersey Bar'),
('4NM','Legal Services, Lawyer, New Mexico Bar'),
('4NV','Legal Services, Lawyer, Nevada Bar'),
('4NY','Legal Services, Lawyer, New York Bar'),
('4OH','Legal Services, Lawyer, Ohio Bar'),
('4OK','Legal Services, Lawyer, Oklahoma Bar'),
('4OR','Legal Services, Lawyer, Oregon Bar'),
('4PA','Legal Services, Lawyer, Pennsylvania Bar'),
('4PR','Legal Services, Lawyer, Puerto Rico Bar'),
('4RI','Legal Services, Lawyer, Rhode Island Bar'),
('4SC','Legal Services, Lawyer, South Carolina Bar'),
('4SD','Legal Services, Lawyer, South Dakota Bar'),
('4TN','Legal Services, Lawyer, Tennessee Bar'),
('4TX','Legal Services, Lawyer, Texas Bar'),
('4UT','Legal Services, Lawyer, Utah Bar'),
('4VA','Legal Services, Lawyer, Virginia Bar'),
('4VI','Legal Services, Lawyer, Virgin Islands Bar'),
('4VT','Legal Services, Lawyer, Vermont Bar'),
('4WA','Legal Services, Lawyer, Washington Bar'),
('4WI','Legal Services, Lawyer, Wisconsin Bar'),
('4WV','Legal Services, Lawyer, West Virginia Bar'),
('4WY','Legal Services, Lawyer, Wyoming Bar'),
('500','Chaplain Corps Denominations, Roman Catholic'),
('501','Chaplain Corps Denominations, Jewish'),
('502','Chaplain Corps Denominations, The Episcopal Church'),
('503','Chaplain Corps Denominations, Orthodox'),
('504','Chaplain Corps Denominations, Associated Gospel Churches'),
('505','Chaplain Corps Denominations, American Council of Christian Churches'),
('506','Chaplain Corps Denominations, Assemblies of God'),
('507','Chaplain Corps Denominations, Christian Church (Disciples of Christ)'),
('508','Chaplain Corps Denominations, Christian Science'),
('509','Chaplain Corps Denominations, Churches of Christ'),
('510','Chaplain Corps Denominations, Church of Jesus Christ of Latter-Day Saints'),
('511','Chaplain Corps Denominations, Church of the Nazarene'),
('512','Chaplain Corps Denominations, Independent Fundamental Church of America'),
('513','Chaplain Corps Denominations, National Fellowship of Brethren Churches'),
('514','Chaplain Corps Denominations, Plymouth Brethren'),
('516','Chaplain Corps Denominations, Reorganized Church of Jesus Christ of Latter-Day Saints'),
('517','Chaplain Corps Denominations, Church of God General Conference'),
('518','Chaplain Corps Denominations, Brethren Church'),
('519','Chaplain Corps Denominations, United Church of Christ'),
('520','Chaplain Corps Denominations, Church of God of Prophecy'),
('521','Chaplain Corps Denominations, Church of God in Christ'),
('522','Chaplain Corps Denominations, Pentecostal Church of God in North America'),
('523','Chaplain Corps Denominations, Baptist Bible Fellowship'),
('524','Chaplain Corps Denominations, American Baptist Association'),
('525','Chaplain Corps Denominations, American Baptist Churches'),
('526','Chaplain Corps Denominations, General Association of Regular Baptists'),
('527','Chaplain Corps Denominations, Southern Baptist'),
('528','Chaplain Corps Denominations, General Associaton of General Baptists'),
('529','Chaplain Corps Denominations, Baptist Missionary Association of America'),
('530','Chaplain Corps Denominations, African Methodist Episcopal'),
('531','Chaplain Corps Denominations, Christian Methodist Episcopal Church'),
('532','Chaplain Corps Denominations, African Methodist Episcopal Zion'),
('533','Chaplain Corps Denominations, Baptist General Conference'),
('534','Chaplain Corps Denominations, Christian Reformed Church'),
('535','Chaplain Corps Denominations, Church of God (Anderson, Indiana)'),
('536','Chaplain Corps Denominations, Church of God in North America'),
('537','Chaplain Corps Denominations, Evangelical Convenant Church in America'),
('538','Chaplain Corps Denominations, Free Will Baptist'),
('539','Chaplain Corps Denominations, Moravian'),
('540','Chaplain Corps Denominations, National Association of Congregational Christian Churches'),
('541','Chaplain Corps Denominations, National Baptist Convention of America'),
('542','Chaplain Corps Denominations, National Baptist Convention in the U.S.A.'),
('543','Chaplain Corps Denominations, Reformed Church in America'),
('544','Chaplain Corps Denominations, Progressive National Baptist Convention, Inc.'),
('545','Chaplain Corps Denominations, Seventh-Day Adventist'),
('546','Chaplain Corps Denominations, Unitarian Universalist Association'),
('547','Chaplain Corps Denominations, Salvation Army'),
('548','Chaplain Corps Denominations, Liberal Catholic Church'),
('549','Chaplain Corps Denominations, Evangelical Congregation Church'),
('550','Chaplain Corps Denominations, National Association of Baptist Churches'),
('551','Chaplain Corps Denominations, Pentecostal Assemblies of the World'),
('552','Chaplain Corps Denominations, United Pentecostal Church International'),
('554','Chaplain Corps Denominations, Elim Fellowship'),
('555','Chaplain Corps Denominations, North American Baptist Conference'),
('556','Chaplain Corps Denominations, Bible Presbyterian Church'),
('557','Chaplain Corps Denominations, Church of the Living God'),
('558','Chaplain Corps Denominations, International Council of Community Churches'),
('559','Chaplain Corps Denominations, Evangelical Methodist Church'),
('560','Chaplain Corps Denominations, Christian and Missionary Alliance'),
('561','Chaplain Corps Denominations, Christian Churches and Churches of Christ'),
('562','Chaplain Corps Denominations, Church of United Brethren in Christ'),
('563','Chaplain Corps Denominations, Central Bible Church'),
('564','Chaplain Corps Denominations, Conservative Baptist Association in America'),
('565','Chaplain Corps Denominations, Conservative Congregational Christian Conference'),
('566','Chaplain Corps Denominations, Evangelical Free Church of America'),
('567','Chaplain Corps Denominations, Kansas Yearly Meeting of Friends'),
('568','Chaplain Corps Denominations, International Church of Foursquare Gospel'),
('569','Chaplain Corps Denominations, Open Bible Standard Church'),
('570','Chaplain Corps Denominations, Pentecostal Church of God in America'),
('571','Chaplain Corps Denominations, Pentecostal Holiness Church'),
('572','Chaplain Corps Denominations, Missionary Church Association'),
('573','Chaplain Corps Denominations, Church of God (Cleveland, Tennessee)'),
('574','Chaplain Corps Denominations, Presbyterian Church in America'),
('575','Chaplain Corps Denominations, The Missionary Church'),
('576','Chaplain Corps Denominations, Churches of Christ in Christian Union'),
('577','Chaplain Corps Denominations, Full Gospel Fellowship of Church and Ministry International'),
('578','Chaplain Corps Denominations, Pentecostal Free Will Baptist Church, Inc.'),
('579','Chaplain Corps Denominations, Chapaincy Full Gospel Churches'),
('580','Chaplain Corps Denominations, Presbyterian Church, USA'),
('581','Chaplain Corps Denominations, Associated Reformed Presbyterian'),
('582','Chaplain Corps Denominations, Westgate Chapel'),
('583','Chaplain Corps Denominations, Cumberland Presbyterian'),
('584','Chaplain Corps Denominations, Orthodox Presbyterian'),
('585','Chaplain Corps Denominations, Reformed Presbyterian Church of North America'),
('588','Chaplain Corps Denominations, Reformed Episcopal Church'),
('589','Chaplain Corps Denominations, Liberty Baptist Fellowship'),
('590','Chaplain Corps Denominations, United Methodist'),
('591','Chaplain Corps Denominations, Free Methodist of North America'),
('592','Chaplain Corps Denominations, Primitive Methodist'),
('593','Chaplain Corps Denominations, Wesleyan'),
('595','Chaplain Corps Denominations, Conservative Lutheran Association'),
('596','Chaplain Corps Denominations, Evangelical Lutheran Church in America'),
('597','Chaplain Corps Denominations, United Episcopal Church of North America'),
('598','Chaplain Corps Denominations, Anglican Catholic Church'),
('599','Chaplain Corps Denominations, Lutheran Church, Missouri Synod'),
('5AC','Chaplain Corps Religious Organizations, Adventist, Advent Christian Church'),
('5AG','Chaplain Corps Religious Organizations, Adventist, Advent Christian General Conference'),
('5AJ','Chaplain Corps Religious Organizations, Adventist, Jehovah�s Witness'),
('5AM','Chaplain Corps Religious Organizations, Adventist, Church of God, General Conference (Morrow, GA)'),
('5AS','Chaplain Corps Religious Organizations, Adventist, General Conference of Seventh-Day Adventists United States'),
('5AV','Chaplain Corps Religious Organizations, Adventist, Adventist Churches'),
('5BA','Chaplain Corps Religious Organizations, Baptist, American Baptist Churches in the USA'),
('5BB','Chaplain Corps Religious Organizations, Baptist, Baptist Churches'),
('5BC','Chaplain Corps Religious Organizations, Baptist, Southern Baptist Convention'),
('5BD','Chaplain Corps Religious Organizations, Baptist, New Testament Association of Independent Baptist Churches'),
('5BE','Chaplain Corps Religious Organizations, Baptist, Conservative Baptist Association of America'),
('5BF','Chaplain Corps Religious Organizations, Baptist, National Association of Free Will Baptists'),
('5BG','Chaplain Corps Religious Organizations, Baptist, General Association of General Baptists'),
('5BH','Chaplain Corps Religious Organizations, Baptist, Alliance of Baptists in the USA, Inc.'),
('5BI','Chaplain Corps Religious Organizations, Baptist, Baptist General Convention of Texas'),
('5BJ','Chaplain Corps Religious Organizations, Baptist, Baptist General Conference'),
('5BK','Chaplain Corps Religious Organizations, Baptist, Cooperative Baptist Fellowship, Inc.'),
('5BL','Chaplain Corps Religious Organizations, Baptist, Liberty Baptist Fellowship for Church Planting, Inc.'),
('5BM','Chaplain Corps Religious Organizations, Baptist, Baptist Missionary Association of America'),
('5BN','Chaplain Corps Religious Organizations, Baptist, National Baptist Convention of America, Inc.'),
('5BO','Chaplain Corps Religious Organizations, Baptist, Original Free Will Baptists Convention'),
('5BP','Chaplain Corps Religious Organizations, Baptist, Progressive National Baptist Convention, Inc.'),
('5BQ','Chaplain Corps Religious Organizations, Baptist, National Missionary Baptist Convention of America'),
('5BR','Chaplain Corps Religious Organizations, Baptist, General Association of Regular Baptist Churches'),
('5BS','Chaplain Corps Religious Organizations, Baptist, Seventh-Day Baptists General Conference USA and Canada'),
('5BT','Chaplain Corps Religious Organizations, Baptist, North American Baptist Conference'),
('5BU','Chaplain Corps Religious Organizations, Baptist, National Baptist Convention, USA, Inc.'),
('5BV','Chaplain Corps Religious Organizations, Baptist, The Sovereign Grace Baptist Association of Churches'),
('5BW','Chaplain Corps Religious Organizations, Baptist, World Baptist Fellowship, Inc.'),
('5BX','Chaplain Corps Religious Organizations, Baptist, American Baptist Association'),
('5BY','Chaplain Corps Religious Organizations, Baptist, National Association of Baptist Churches'),
('5CA','Chaplain Corps Religious Organizations, Catholic, Apostolic Catholic Orthodox Church'),
('5CC','Chaplain Corps Religious Organizations, Catholic, Catholic Churches'),
('5CH','Chaplain Corps Religious Organizations, Catholic, Old Holy Catholic Church, Archdiocese of Christ the King'),
('5CI','Chaplain Corps Religious Organizations, Catholic, The Independent Catholic Church International'),
('5CL','Chaplain Corps Religious Organizations, Catholic, Liberal Catholic Church'),
('5CN','Chaplain Corps Religious Organizations, Catholic, National Catholic Apostolic Church in the USA'),
('5CO','Chaplain Corps Religious Organizations, Catholic, The Old Holy Catholic Church'),
('5CP','Chaplain Corps Religious Organizations, Catholic, Polish National Catholic Church of America'),
('5CR','Chaplain Corps Religious Organizations, Catholic, The Roman Catholic Church'),
('5CU','Chaplain Corps Religious Organizations, Catholic, United Catholic Church of America'),
('5DL','Chaplain Corps Religious Organizations, Latter-Day Saints, The Church of Jesus Christ of Latter-Day Saints'),
('5DR','Chaplain Corps Religious Organizations, Latter-Day Saints, Community of Christ (Reorganized Church of Jesus Christ of Latter-Day Saints)'),
('5EA','Chaplain Corps Religious Organizations, Episcopalian, The Anglican Catholic Church'),
('5EC','Chaplain Corps Religious Organizations, Episcopalian, The Episcopal Church'),
('5ED','Chaplain Corps Religious Organizations, Episcopalian, The Communion of Evangelical Episcopal Churches'),
('5EE','Chaplain Corps Religious Organizations, Episcopalian, Episcopal Churches'),
('5EH','Chaplain Corps Religious Organizations, Episcopalian, The Holy Catholic Church (Anglican Rite)'),
('5EI','Chaplain Corps Religious Organizations, Episcopalian, Anglican Mission in America Chaplaincy'),
('5EK','Chaplain Corps Religious Organizations, Episcopalian, The Anglican Church in America'),
('5EM','Chaplain Corps Religious Organizations, Episcopalian, The Episcopal Missionary Church'),
('5EO','Chaplain Corps Religious Organizations, Episcopalian, Orthodox Anglican Church'),
('5EP','Chaplain Corps Religious Organizations, Episcopalian, Philippine Independent Catholic Church'),
('5EQ','Chaplain Corps Religious Organizations, Episcopalian, Philippine Independent Catholic Church, Military Diocese'),
('5ER','Chaplain Corps Religious Organizations, Episcopalian, The Reformed Episcopal Church'),
('5ET','Chaplain Corps Religious Organizations, Episcopalian, Anglican Church'),
('5EU','Chaplain Corps Religious Organizations, Episcopalian, United Episcopal Church of North America'),
('5EV','Chaplain Corps Religious Organizations, Episcopalian, The Evangelical Episcopal Church'),
('5EX','Chaplain Corps Religious Organizations, Episcopalian, Charismatic Episcopal Church'),
('5FA','Chaplain Corps Religious Organizations, Fundamentalist, Independent Churches Affiliated'),
('5FB','Chaplain Corps Religious Organizations, Fundamentalist, Independent Fundamental Bible'),
('5FC','Chaplain Corps Religious Organizations, Fundamentalist, IFCA International'),
('5FD','Chaplain Corps Religious Organizations, Fundamentalist, Berean Fundamental Church Council, Inc.'),
('5FE','Chaplain Corps Religious Organizations, Fundamentalist, Evangelical Church Alliance'),
('5FF','Chaplain Corps Religious Organizations, Fundamentalist, Fundamental Churches'),
('5FG','Chaplain Corps Religious Organizations, Fundamentalist, Associated Gospel Churches'),
('5FH','Chaplain Corps Religious Organizations, Fundamentalist, Fundamental Baptist Fellowship International'),
('5FI','Chaplain Corps Religious Organizations, Fundamentalist, American Council of Christian Churches'),
('5FK','Chaplain Corps Religious Organizations, Fundamentalist, Bible Fellowship Church'),
('5FM','Chaplain Corps Religious Organizations, Fundamentalist, Union of Messianic Jewish Congregations'),
('5FO','Chaplain Corps Religious Organizations, Fundamentalist, Calvary Baptist Church (All Points Baptist Mission)'),
('5FT','Chaplain Corps Religious Organizations, Fundamentalist, Baptist Bible Fellowship International'),
('5FX','Chaplain Corps Religious Organizations, Fundamentalist, Grace Gospel Fellowship'),
('5GC','Chaplain Corps Religious Organizations, Restorationist, Christian Churches and Churches of Christ'),
('5GE','Chaplain Corps Religious Organizations, Restorationist, Christian Church (Disciples of Christ)'),
('5GG','Chaplain Corps Religious Organizations, Restorationist, Restorationist Churches'),
('5GT','Chaplain Corps Religious Organizations, Restorationist, Tioga River Christian Conference'),
('5GX','Chaplain Corps Religious Organizations, Restorationist, Church of Christ'),
('5HA','Chaplain Corps Religious Organizations, Holiness, Church of God Ministries (Anderson, IN)'),
('5HC','Chaplain Corps Religious Organizations, Holiness, Churches of Christ in Christian Union'),
('5HF','Chaplain Corps Religious Organizations, Holiness, Free Methodist Church of North America'),
('5HG','Chaplain Corps Religious Organizations, Holiness, Church of God (Holiness)'),
('5HH','Chaplain Corps Religious Organizations, Holiness, Holiness Churches'),
('5HK','Chaplain Corps Religious Organizations, Holiness, Missionary Church, Inc.'),
('5HM','Chaplain Corps Religious Organizations, Holiness, The Wesleyan Church'),
('5HN','Chaplain Corps Religious Organizations, Holiness, Church of the Nazarene'),
('5HS','Chaplain Corps Religious Organizations, Holiness, Salvation Army, The'),
('5HU','Chaplain Corps Religious Organizations, Holiness, The Church of Christ (Holiness) USA'),
('5IL','Chaplain Corps Religious Organizations, Islamic, Islam'),
('5IM','Chaplain Corps Religious Organizations, Islamic, American Muslim Armed Forces And Veterans Affairs Council'),
('5IN','Chaplain Corps Religious Organizations, Islamic, Islamic Society of North America'),
('5JA','Chaplain Corps Religious Organizations, Jewish, The Rabbinical Assembly (Conservative)'),
('5JJ','Chaplain Corps Religious Organizations, Jewish, Judaism'),
('5JO','Chaplain Corps Religious Organizations, Jewish, Rabbinical Council of America (Orthodox)'),
('5JP','Chaplain Corps Religious Organizations, Jewish, Congregation Pirchei Shoshanim'),
('5JR','Chaplain Corps Religious Organizations, Jewish, Central Conference of American Rabbis'),
('5JS','Chaplain Corps Religious Organizations, Jewish, The Shul'),
('5JW','Chaplain Corps Religious Organizations, Jewish, Jewish Chaplains Council (Jewish Welfare Board)'),
('5KB','Chaplain Corps Religious Organizations, Eastern Religions, Buddhism'),
('5KC','Chaplain Corps Religious Organizations, Eastern Religions, Buddhist Churches of America'),
('5KD','Chaplain Corps Religious Organizations, Eastern Religions, Chinmaya Mission West'),
('5KF','Chaplain Corps Religious Organizations, Eastern Religions, Baha�I Faith'),
('5KH','Chaplain Corps Religious Organizations, Eastern Religions, Hinduism'),
('5KK','Chaplain Corps Religious Organizations, Eastern Religions, Eastern Religions'),
('5LA','Chaplain Corps Religious Organizations, Lutheran, The American Association of Lutheran Churches'),
('5LB','Chaplain Corps Religious Organizations, Lutheran, Church of the Lutheran Brethren'),
('5LC','Chaplain Corps Religious Organizations, Lutheran, Conservative Lutheran Association'),
('5LD','Chaplain Corps Religious Organizations, Lutheran, Evangelical Lutheran Conference and Ministerium'),
('5LE','Chaplain Corps Religious Organizations, Lutheran, Evangelical Lutheran Church in America'),
('5LF','Chaplain Corps Religious Organizations, Lutheran, Association of Free Lutheran Congregations'),
('5LI','Chaplain Corps Religious Organizations, Lutheran, Lutheran Congregations in Mission for Christ'),
('5LL','Chaplain Corps Religious Organizations, Lutheran, Lutheran Churches'),
('5LM','Chaplain Corps Religious Organizations, Lutheran, The Lutheran Church-Missouri Synod'),
('5MB','Chaplain Corps Religious Organizations, Methodist, Church of the United Brethren in Christ'),
('5MC','Chaplain Corps Religious Organizations, Methodist, Christian Methodist Episcopal Church'),
('5ME','Chaplain Corps Religious Organizations, Methodist, African Methodist Episcopal Church'),
('5MG','Chaplain Corps Religious Organizations, Methodist, Evangelical Congregational Church'),
('5MI','Chaplain Corps Religious Organizations, Methodist, The Association of Independent Methodists'),
('5MM','Chaplain Corps Religious Organizations, Methodist, Methodist Churches'),
('5MN','Chaplain Corps Religious Organizations, Methodist, Free Methodist Church of North America'),
('5MP','Chaplain Corps Religious Organizations, Methodist, Iglesia Metodista De Puerto Rico'),
('5MQ','Chaplain Corps Religious Organizations, Methodist, Primitive Methodist'),
('5MR','Chaplain Corps Religious Organizations, Methodist, Moravian Church In America'),
('5MS','Chaplain Corps Religious Organizations, Methodist, The Southern Methodist Church'),
('5MT','Chaplain Corps Religious Organizations, Methodist, The Congregational Methodist Church'),
('5MU','Chaplain Corps Religious Organizations, Methodist, The United Methodist Church'),
('5MV','Chaplain Corps Religious Organizations, Methodist, The Evangelical Methodist Church'),
('5MZ','Chaplain Corps Religious Organizations, Methodist, African Methodist Episcopal Zion Church'),
('5NA','Chaplain Corps Religious Organizations, Independent Denomination, American Missionary Fellowship'),
('5NB','Chaplain Corps Religious Organizations, Independent Denomination, Communion of Convergence Churches, Inc'),
('5ND','Chaplain Corps Religious Organizations, Independent Denomination, Churches of Christ'),
('5NE','Chaplain Corps Religious Organizations, Independent Denomination, Christian Evangelical Churches of America, Inc.'),
('5NF','Chaplain Corps Religious Organizations, Independent Denomination, Church of God in North America'),
('5NK','Chaplain Corps Religious Organizations, Independent Denomination, Korean Evangelical Church of America'),
('5NM','Chaplain Corps Religious Organizations, Independent Denomination, Messianic Jewish Congregations, Union of'),
('5NN','Chaplain Corps Religious Organizations, Independent Denomination, Missionary Church, Inc'),
('5NW','Chaplain Corps Religious Organizations, Independent Denomination, The World Council of Independent Christian Churches'),
('5OA','Chaplain Corps Religious Organizations, Orthodox, American Carpatho-Russian Orthodox Greek Catholic Church'),
('5OB','Chaplain Corps Religious Organizations, Orthodox, Standing Conference of Canonical Orthodox Bishops'),
('5OC','Chaplain Corps Religious Organizations, Orthodox, The Orthodox Church in America'),
('5OE','Chaplain Corps Religious Organizations, Orthodox, Eastern Orthodox Churches'),
('5OF','Chaplain Corps Religious Organizations, Orthodox, Federated Orthodox Catholic Churches United Sacramentally'),
('5OG','Chaplain Corps Religious Organizations, Orthodox, Greek Orthodox Archdiocese of Vasiloupolis'),
('5OI','Chaplain Corps Religious Organizations, Orthodox, Federated Orthodox Catholic Churches International'),
('5ON','Chaplain Corps Religious Organizations, Orthodox, Antiochian Orthodox Christian Archdiocese of North America'),
('5OO','Chaplain Corps Religious Organizations, Orthodox, Orthodox Churches'),
('5OR','Chaplain Corps Religious Organizations, Orthodox, Syro-Russian Orthodox Catholic Church (Romano Byzantine Synod)'),
('5OS','Chaplain Corps Religious Organizations, Orthodox, Serbian Orthodox Church in the USA and Canada'),
('5OU','Chaplain Corps Religious Organizations, Orthodox, Ukrainian Orthodox Church of the USA'),
('5OX','Chaplain Corps Religious Organizations, Orthodox, Syrian Eastern Orthodox Exarchate in America'),
('5PA','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, General Council of Assemblies of God'),
('5PB','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Full Gospel Baptist Church Fellowship, Inc.'),
('5PC','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, The Church of God in Christ, Inc.'),
('5PD','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Full Gospel'),
('5PE','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Elim Fellowship'),
('5PF','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, International Church of the Foursquare Gospel'),
('5PG','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, The Church of God of Prophecy'),
('5PH','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Pentecostal Holiness Church, International'),
('5PI','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Church of Our Lord Jesus Christ of the Apostolic Faith, Inc'),
('5PJ','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Pentecostal Church of God, Inc. (Joplin, MO)'),
('5PK','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Grace Churches International'),
('5PL','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Full Gospel Fellowship of Churches and Ministers International'),
('5PM','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Bethel Ministerial Association, Inc.'),
('5PO','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Global Network of Christian Ministries'),
('5PP','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Pentecostal Churches'),
('5PQ','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Pentecostal Churches of the Apostolic Faith Association'),
('5PR','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Church On The Rock International'),
('5PS','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Open Bible Standard Churches, Inc.'),
('5PT','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Church of God (Cleveland, TN)'),
('5PU','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, United Pentecostal Church International'),
('5PV','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Vineyard Christian Fellowship Church of Cobb County, Inc'),
('5PW','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Pentecostal Assemblies of the World, Inc.'),
('5PX','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Calvary Chapel of Mira Mesa'),
('5PY','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, The United Pentecostal Churches of Christ'),
('5PZ','Chaplain Corps Religious Organizations, Pentecostal/Charismatic I, Association of Evangelical Gospel Assemblies Ministries International, Inc.'),
('5QA','Chaplain Corps Religious Organizations, Brethren/Quaker, The Brethren Church, (Ashland, OH)'),
('5QB','Chaplain Corps Religious Organizations, Brethren/Quaker, Brethren Churches'),
('5QE','Chaplain Corps Religious Organizations, Brethren/Quaker, Evangelical Friends Church International'),
('5QF','Chaplain Corps Religious Organizations, Brethren/Quaker, Friends (Quakers)'),
('5QG','Chaplain Corps Religious Organizations, Brethren/Quaker, National Fellowship of Grace Brethren Churches'),
('5QK','Chaplain Corps Religious Organizations, Brethren/Quaker, Kansas Yearly Meeting of Friends'),
('5QQ','Chaplain Corps Religious Organizations, Brethren/Quaker, European Free Churches'),
('5QS','Chaplain Corps Religious Organizations, Brethren/Quaker, Schwenkfelder Churches'),
('5RA','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Associate Reformed Presbyterian Church'),
('5RB','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Cumberland Presbyterian Church'),
('5RC','Chaplain Corps Religious Organizations, Ref/Pres/Cong, National Association of Congregational Christian Churches'),
('5RD','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Christian Reformed Church in North America'),
('5RF','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Reformed Church in America'),
('5RG','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Churches of God, General Conference'),
('5RI','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Presbyterian Church in America'),
('5RJ','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Bible Presbyterian Church (General Synod)'),
('5RK','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Korean Presbyterian Church of America'),
('5RM','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Cumberland Presbyterian Church in America'),
('5RN','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Reformed Presbyterian Church of North America'),
('5RO','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Orthodox Presbyterian Church'),
('5RP','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Presbyterian Church (USA)'),
('5RQ','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Conservative Congregational Christian Conference'),
('5RR','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Reformed and Presbyterian Churches'),
('5RS','Chaplain Corps Religious Organizations, Ref/Pres/Cong, The Congregational Christian Church in American Samoa'),
('5RU','Chaplain Corps Religious Organizations, Ref/Pres/Cong, United Church of Christ'),
('5RV','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Evangelical Presbyterian Church'),
('5RW','Chaplain Corps Religious Organizations, Ref/Pres/Cong, International Council of Community Churches'),
('5RX','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Korean-American Presbyterian Church'),
('5RY','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Presbyterian and Reformed Joint Commission on Chaplains'),
('5RZ','Chaplain Corps Religious Organizations, Ref/Pres/Cong, Presbyterian Conference for Chaplains and Military'),
('5SC','Chaplain Corps Religious Organizations, Scientist, The First Church of Christ, Scientist'),
('5SR','Chaplain Corps Religious Organizations, Scientist, United Church of Religious Science'),
('5SU','Chaplain Corps Religious Organizations, Scientist, Association of Unity Churches'),
('5TA','Chaplain Corps Religious Organizations, Non-Denominational Independent, St Andrews Evangelical Church'),
('5TB','Chaplain Corps Religious Organizations, Non-Denominational Independent, Cedar Mill Bible Churc'),
('5TC','Chaplain Corps Religious Organizations, Non-Denominational Independent, Church of the Living God'),
('5TD','Chaplain Corps Religious Organizations, Non-Denominational Independent, The Woodfield Church'),
('5TE','Chaplain Corps Religious Organizations, Non-Denominational Independent, Evangel Fellowship International'),
('5TF','Chaplain Corps Religious Organizations, Non-Denominational Independent, Central Bible Church'),
('5TG','Chaplain Corps Religious Organizations, Non-Denominational Independent, Community Church of Greenwood, Inc.'),
('5TK','Chaplain Corps Religious Organizations, Non-Denominational Independent, Columbia Bible Church'),
('5TM','Chaplain Corps Religious Organizations, Non-Denominational Independent, Camelback Bible Church'),
('5TP','Chaplain Corps Religious Organizations, Non-Denominational Independent, Grace Place'),
('5TR','Chaplain Corps Religious Organizations, Non-Denominational Independent, Coral Ridge Christian Fellowship'),
('5TU','Chaplain Corps Religious Organizations, Non-Denominational Independent, Westgate Chapel'),
('5TW','Chaplain Corps Religious Organizations, Non-Denominational Independent, Westside Christian Family Chapel'),
('5TX','Chaplain Corps Religious Organizations, Non-Denominational Independent, Christ Community Church'),
('5UU','Chaplain Corps Religious Organizations, Unitarian, The Unitarian Universalist Association'),
('5VA','Chaplain Corps Religious Organizations, Evangelical, Asbury Bible Churches'),
('5VB','Chaplain Corps Religious Organizations, Evangelical, Plymouth Brethren'),
('5VE','Chaplain Corps Religious Organizations, Evangelical, The Evangelical Covenant Church'),
('5VF','Chaplain Corps Religious Organizations, Evangelical, Evangelical Free Church of America'),
('5VM','Chaplain Corps Religious Organizations, Evangelical, Christian and Missionary Alliance'),
('5VN','Chaplain Corps Religious Organizations, Evangelical, National Association of Evangelicals'),
('5VP','Chaplain Corps Religious Organizations, Evangelical, Bible Protestant Church'),
('5VV','Chaplain Corps Religious Organizations, Evangelical, Evangelical Churches'),
('5WA','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Assemblies of God, International Fellowship'),
('5WB','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic I, Pentecostal Church of God, Inc'),
('5WC','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Chaplaincy Full Gospel Churches, Inc.'),
('5WD','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, United Evangelical Churches'),
('5WE','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Evangel Fellowship International'),
('5WF','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Full Faith Church of Love'),
('5WG','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Association of International Gospel Assemblies, Inc.'),
('5WH','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Harvest Network International'),
('5WI','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Christ-Immanuel Ministerial Association'),
('5WJ','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Christ''s Church Fellowship'),
('5WK','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Kingsway Fellowship International'),
('5WL','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Liberty Fellowship of Churches And Ministers, Inc.'),
('5WM','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Fellowship of Churches And Ministers International'),
('5WN','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Faith Christian Fellowship International Church, Inc.'),
('5WO','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Christian Church of North America'),
('5WP','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, International Ministerial Fellowship'),
('5WQ','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Pentecostal Free Will Baptist Church, Inc'),
('5WR','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Rhema Bible Church'),
('5WS','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, The Coalition of Spirit-Filled Churches'),
('5WT','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Trinity Full Gospel Fellowship'),
('5WU','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, United Full Gospel Church'),
('5WV','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Victory Christian Center'),
('5WW','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, International Convention of Faith Ministries, Inc.'),
('5WX','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, International Christian Church'),
('5WY','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, Maranatha Christian Fellowship, Inc.'),
('5WZ','Chaplain Corps Religious Organizations, Pentecostal/ Charismatic II, New Generation Church'),
('5XC','Chaplain Corps Religious Organizations, Unclassified, Iglesia Ni Christo'),
('5XG','Chaplain Corps Religious Organizations, Unclassified, General Church of The New Jerusalem'),
('5XJ','Chaplain Corps Religious Organizations, Unclassified, Churches of the New Jerusalem'),
('5YS','Chaplain Corps Religious Organizations, Spiritualist, The Swedenborgian Church'),
('5YU','Chaplain Corps Religious Organizations, Spiritualist, Holy Spirit Association for the Unification of World Christianity'),
('62G','Health Care Services, Any Medical Corps Specialty, Sports Medicine Specialist'),
('62H','Health Care Services, Interdepartmental, Health Promotion Coordinator'),
('62I','Health Care Services, Interdepartmental, Informatics Nursing'),
('62O','Health Care Services, Interdepartmental, Ambulatory Care Nurse'),
('67A','Health Care Services, Executive Medicine Staff, Executive Medicine'),
('67F','Health Care Services, Executive Medicine Staff, Reserve Liaison Officer'),
('67G','Health Care Services, Executive Medicine Staff, Managed Care Coordinator'),
('67H','Health Care Services, Executive Medicine Staff, Ambulatory Care Administration (ACA) Officer'),
('68H','Health Care Services, Any Medical Department Designator, Heath Promotion Coordinator'),
('69I','Health Care Services, Nurse Corps Related, Informatics Nursing'),
('69L','Health Care Services, Nurse Corps Related, Labor, Delivery and Recovery (LDR) Experienced Nurse'),
('69O','Health Care Services, Nurse Corps Related, Ambulatory Care Nurse'),
('69P','Health Care Services, Nursing Health Care Services, Primary Care Nurse Practitioner'),
('6AA','Health Care Services, Aviation Medicine, Aviation Medical Examiner'),
('6AB','Health Care Services, Aviation Medicine, General Flight Officer'),
('6AC','Health Care Services, Aviation Medicine, Naval Aviator (Naval Flight Officer (NFO))/Flight Surgeon'),
('6AE','Health Care Services, Aviation Medicine, Naval Aviator (Pilot)/Flight Surgeon'),
('6AG','Health Care Services, Aviation Medicine, Aerospace Medicine (Preventive Medicine)'),
('6AJ','Health Care Services, Aviation Medicine, Flight Nurse'),
('6AM','Health Care Services, Aviation Medicine, Aeromedical Safety Officer'),
('6AN','Health Care Services, Aviation Medicine, Aerospace Optometrist'),
('6BG','Health Care Services, Anesthesia, Cardiothoracic'),
('6BH','Health Care Services, Anesthesia, Neurosurgical'),
('6BI','Health Care Services, Anesthesia, Obstetrical'),
('6BJ','Health Care Services, Anesthesia, Pain Management'),
('6BK','Health Care Services, Anesthesia, Pediatric'),
('6DD','Health Care Services, Neurological Surgery, Complex Spinal Neurological Surgery'),
('6DE','Health Care Services, Neurological Surgery, Skull Base Neurological Surgery'),
('6DG','Health Care Services, Neurological Surgery, Neurovascular Neurological Surgery'),
('6EF','Health Care Services, Obstetrics/Gynecology (OB/GYN), Obstetrics Critical Care Medicine'),
('6EG','Health Care Services, Obstetrics/Gynecology (OB/GYN), Gynecologic Oncology'),
('6EH','Health Care Services, Obstetrics/Gynecology (OB/GYN), Maternal Fetal Medicine'),
('6EI','Health Care Services, Obstetrics/Gynecology (OB/GYN), Reproductive Endocrinology'),
('6EJ','Health Care Services, Obstetrics/Gynecology (OB/GYN), Urogynecology and Pelvic Surgery'),
('6EK','Health Care Services, Obstetrics/Gynecology (OB/GYN), Gynecologic Pathology'),
('6FA','Health Care Services, Field Medicine, Marine Corps Medical Officer'),
('6FC','Health Care Services, Field Medicine, Fleet Marine Force Medical Logistics'),
('6FD','Health Care Services, Field Medicine, Surface Experienced Medical Officer'),
('6FE','Health Care Services, Field Medicine, Senior Marine Corps Staff Officer'),
('6GA','Health Care Services, Ophthalmology, Aviation Optometry'),
('6GD','Health Care Services, Ophthalmology, Comprehensive'),
('6GE','Health Care Services, Ophthalmology, Cornea and External Disease'),
('6GF','Health Care Services, Ophthalmology, Glaucoma'),
('6GG','Health Care Services, Ophthalmology, Neuroophthalmology/Surgical Neuroophthalmology'),
('6GH','Health Care Services, Ophthalmology, Oculoplastics'),
('6GI','Health Care Services, Ophthalmology, Ophthalmic Pathology Surgery'),
('6GJ','Health Care Services, Ophthalmology, Retina Vitreous Surgery'),
('6GK','Health Care Services, Ophthalmology, Strabismus'),
('6HD','Health Care Services, Orthopaedic Surgery, Foot and Ankle Surgery'),
('6HF','Health Care Services, Orthopaedic Surgery, Orthopaedic Oncology'),
('6HG','Health Care Services, Orthopaedic Surgery, Pediatric Orthopaedic Surgery'),
('6HH','Health Care Services, Orthopaedic Surgery, Spine Surgery'),
('6HI','Health Care Services, Orthopaedic Surgery, Sports Surgery'),
('6HJ','Health Care Services, Orthopaedic Surgery, Strabismus'),
('6HK','Health Care Services, Orthopaedic Surgery, Trauma Surgery'),
('6HL','Health Care Services, Orthopaedic Surgery, Oprthopaedic Physicians Assistant'),
('6ID','Health Care Services, Otolaryngology, Facial Plastics and Reconstructive Surgery'),
('6IE','Health Care Services, Otolaryngology, Head and Neck Surgery'),
('6IF','Health Care Services, Otolaryngology, Neuro-Otology'),
('6IG','Health Care Services, Otolaryngology, Pediatric Otolaryngology'),
('6JD','Health Care Services, Urologic, Endocrinologic Urologist'),
('6JE','Health Care Services, Urologic, Female Urology'),
('6JF','Health Care Services, Urologic, Infertility Urology'),
('6JG','Health Care Services, Urologic, Pediatric Urology'),
('6JH','Health Care Services, Urologic, Urinary Stone Disease'),
('6JI','Health Care Services, Urologic, Urologic Oncology'),
('6KE','Health Care Services, Preventive/Occupational Medicine, Medical Toxicology'),
('6KL','Health Care Services, Preventive/Occupational Medicine, Radiation Safety Officer`'),
('6LC','Health Care Services, Physical Medicine and Rehabilitation, Electroneuromyographic Specialist'),
('6LD','Health Care Services, Physical Medicine and Rehabilitation, Musculoskeletal Screener'),
('6LJ','Health Care Services, Physical Medicine and Rehabilitation, Upper Extremity Neuromusculoskeletal Evaluator (UENMSE)'),
('6LN','Health Care Services, Physical Medicine and Rehabilitation, Spinal Cord Rehabilitation Specialist'),
('6MA','Health Care Services, Pathology, Anatomic and Clinical'),
('6MB','Health Care Services, Pathology, Anatomic Pathologist'),
('6MC','Health Care Services, Pathology, Clinical Pathologist'),
('6MD','Health Care Services, Pathology, Blood Bank Pathologist'),
('6ME','Health Care Services, Pathology, Chemical Pathologist'),
('6MF','Health Care Services, Pathology, Cytopathologist'),
('6MG','Health Care Services, Pathology, Dermatopathologist'),
('6MH','Health Care Services, Pathology, Forensic Pathologist'),
('6MI','Health Care Services, Pathology, Hematopathologist'),
('6MJ','Health Care Services, Pathology, Immunopathologist'),
('6MK','Health Care Services, Pathology, Neuropathologist'),
('6ML','Health Care Services, Pathology, Surgical Pathologist'),
('6ND','Health Care Services, Dermatology, Dermatological Immunology/Diagnostic and Laboratory Immunology'),
('6NE','Health Care Services, Dermatology, Dermatologic Surgery'),
('6NF','Health Care Services, Dermatology, Dermatopathology'),
('6NG','Health Care Services, Dermatology, Pediatric Dermatologist'),
('6NH','Health Care Services, Dermatology, Photobiologist'),
('6OB','Health Care Services, Contingency/Operational, Shipboard Assignment'),
('6OC','Health Care Services, Contingency/Operational, Hospital Ship Assignment'),
('6OF','Health Care Services, Contingency/Operational, FDPMU (Forward Deployable preventive Medicine unit)'),
('6ON','Health Care Services, Contingency/Operational, Medical Regulator'),
('6OR','Health Care Services, Contingency/Operational, CATF Surgeon'),
('6OT','Health Care Services, Contingency/Operational, C4 Trained Plus Ortho Surg Enhancement Module'),
('6OU','Health Care Services, Contingency/Operational, Fleet Hospital Assignment'),
('6OV','Health Care Services, Contingency/Operational, Blood Donor Operations'),
('6OW','Health Care Services, Contingency/Operational, Trauma Team Trained Officer (TTTO)'),
('6PD','Health Care Services, Emergency Medicine, Emergency Medicine Services'),
('6PE','Health Care Services, Emergency Medicine, Medical Toxicology'),
('6PF','Health Care Services, Emergency Medicine, Pediatric Emergency Medicine'),
('6QF','Health Care Services, Family Practice, Obstetrics (Additional Training)'),
('6RF','Health Care Services, Internal Medicine, Allergy Immunologist DLI'),
('6RM','Health Care Services, Internal Medicine, Hepatology'),
('6SF','Health Care Services, Executive Medicine Staff, Reserve Administrative Officer'),
('6SG','Health Care Services, Executive Medicine Staff, Managed Care Officer'),
('6SH','Health Care Services, Executive Medicine Staff, Ambulatory Care Administration (ACA) Officer'),
('6SI','Health Care Services, Executive Medicine Staff, Credentialed Health Care Administrator (CHCA)'),
('6TD','Health Care Services, Neurology, Child Neurologist'),
('6TF','Health Care Services, Neurology, Medical Neuro-Ophthalmologist'),
('6TG','Health Care Services, Neurology, Neurophysiologist'),
('6UD','Health Care Services, Undersea Medicine, Diver'),
('6UE','Health Care Services, Undersea Medicine, Undersea Occupation Medicine'),
('6UF','Health Care Services, Undersea Medicine, Hyperbaric Medicine Researcher'),
('6UG','Health Care Services, Undersea Medicine, Hyperbaric Medicine Clinician'),
('6UM','Health Care Services, Undersea Medicine, Submarine'),
('6VF','Health Care Services, Pediatric, Allergy Immunologist DLI'),
('6VG','Health Care Services, Pediatric, Pediatric Cardiologist'),
('6VH','Health Care Services, Pediatric, Child/Sexual Abuse Specialist'),
('6VI','Health Care Services, Pediatric, Pediatric Intensivist/Critical Care'),
('6VJ','Health Care Services, Pediatric, Developmental Pediatrician'),
('6VK','Health Care Services, Pediatric, Pediatric Endocrinologist'),
('6VL','Health Care Services, Pediatric, Pediatric Gastroenterologist'),
('6VN','Health Care Services, Pediatric, Pediatric Hematologist-Oncologist'),
('6VO','Health Care Services, Pediatric, Genetic Dysmorphology'),
('6VP','Health Care Services, Pediatric, Pediatric Infectious Disease Specialist'),
('6VQ','Health Care Services, Pediatric, Pediatric Nephrology'),
('6VR','Health Care Services, Pediatric, Pediatric Pulmonologist'),
('6VS','Health Care Services, Pediatric, Pediatric Rheumtologist'),
('6VV','Health Care Services, Pediatric, Neonatologist'),
('6VW','Health Care Services, Pediatric, Toxicologist'),
('6XD','Health Care Services, Psychiatry, Addiction Psychiatry'),
('6XE','Health Care Services, Psychiatry, Administrative Psychiatry'),
('6XF','Health Care Services, Psychiatry, Adolescent Psychiatry'),
('6XG','Health Care Services, Psychiatry, Aviation Psychiatry'),
('6XH','Health Care Services, Psychiatry, Child/Adolescent Psychiatry'),
('6XI','Health Care Services, Psychiatry, Clinical Neurophysiology'),
('6XJ','Health Care Services, Psychiatry, Community/Preventive Psychiatry'),
('6XK','Health Care Services, Psychiatry, Consultation/Liaison Psychiatry'),
('6XL','Health Care Services, Psychiatry, Forensic Psychiatry'),
('6XM','Health Care Services, Psychiatry, Geriatric Psychiatry'),
('6XN','Health Care Services, Psychiatry, Research Psychiatry'),
('6YD','Health Care Services, Diagnostic Radiology, Imaging'),
('6YE','Health Care Services, Diagnostic Radiology, Interventional/Vascular Radiology'),
('6YF','Health Care Services, Diagnostic Radiology, Neuro-Radiology'),
('6YG','Health Care Services, Diagnostic Radiology, Nuclear Radiology'),
('6YI','Health Care Services, Diagnostic Radiology, Pediatric Radiologist'),
('6YK','Health Care Services, Diagnostic Radiology, Radiation Teletherapy Physicist'),
('6ZA','Health Care Services, Educational/Ethics, Instructor'),
('6ZB','Health Care Services, Educational/Ethics, Assistant Professor'),
('6ZC','Health Care Services, Educational/Ethics, Associate Professor'),
('6ZD','Health Care Services, Educational/Ethics, Full Professor'),
('6ZE','Health Care Services, Educational/Ethics, Medical Ethicist'),
('6ZF','Health Care Services, Educational/Ethics, Researcher'),
('6ZG','Health Care Services, Educational/Ethics, Residency Program Director'),
('800','Engineering Duty, Registered Professional Engineer'),
('900','Supply Corps, Financial Management (SC FINMGMT)'),
('901','Supply Corps, Accounting and Fiscal (SC ACTFISC)'),
('902','Supply Corps, Disbursing (SC DISBURS)'),
('903','Supply Corps, Auditing (SC AUDIT)'),
('905','Supply Corps, Systems Inventory Management (SC SYSINV)'),
('906','Supply Corps, Integrated Logistics Support (SC ILS)'),
('908','Supply Corps, Inventory Control Officer (SC INVCONT)'),
('909','Supply Corps, Allowances/Outfitting (SC ALLOW)'),
('910','Supply Corps, Food Service Operations'),
('911','Supply Corps, Food Service Officer (SC FOODSRV)'),
('913','Supply Corps, Petroleum Logistics Officer (SC PETROLOG)'),
('914','Supply Corps, Fuel Storage Officer (SC FUELSTR)'),
('916','Supply Corps, Procurement Management (SC PROCRMGT)'),
('917','Supply Corps, Contract Administration (SC CNTRADM)'),
('918','Supply Corps, Supply Corps Officer Contingency Operations Assignment'),
('919','Supply Corps, Supply Corps Officer Contingency Operations Assignment Level 2'),
('920','Supply Corps, Transportation Management (SC TRNMGT)'),
('921','Supply Corps, Traffic (SC TRAFFIC)'),
('922','Supply Corps, Terminal Operations (SC TERMOPS)'),
('923','Supply Corps, Warehousing (SC WAREHSG)'),
('924','Supply Corps, Property Disposal (SC PROPDSP)'),
('925','Supply Corps, Household Goods (SC HHG)'),
('926','Supply Corps, Computer System Management (SC CPSYSMT)'),
('927','Supply Corps, Data Processing Officer (SC DATAPRO)'),
('928','Supply Corps, Assignment to Non- Conventional Operational Tour (ASGN NCONV)'),
('929','Supply Corps, Completion of two or more Non-Conventional Operational Tours (COMP2 NCONV)'),
('930','Supply Corps, OPS Research/Systems Analysis (SC OPSRSCH)'),
('933','Supply Corps, Merchandising Management (SC MRCHMGT)'),
('934','Supply Corps, Commissary Store Operations (SC COMMISS)'),
('935','Supply Corps, Commander Supply Corps Officer Sea Completed (SC CDRSEA)'),
('936','Supply Corps, Commander Supply Corps Officer Sea Assigned (SC CDRSEAASGN)'),
('937','Supply Corps, Commander Supply Corps Officer Sea Board Select (SC CDRSEABDSEL)'),
('939','Supply Corps, Ordnance Logistics Ammo (SC ORDLOG)'),
('93E','Supply Corps, Navy Expeditionary Supply Corps Officer Warfare Qualification (NESCO)'),
('940','Supply Corps, Ship Outfitting (SC SHIPOUT)'),
('941','Supply Corps, Submarine Support (SC SUBSUPPT)'),
('942','Supply Corps, Aviation Support (SC AVSUPPT)'),
('943','Supply Corps, Joint, Interagency, International, or Multinational Operations'),
('944','Supply Corps, Cold Weather Support (SC COLDWEA)'),
('945','Supply Corps, Naval Reactors Experience'),
('946','Supply Corps, Duty in DSA (SC DSA)'),
('947','Supply Corps, Duty in Joint Activities (SC JNTACT)'),
('948','Supply Corps, Afloat "I" Duty as LCDR or Senior (SC SO AFLT)'),
('949','Supply Corps, Supply Corps School Instructor'),
('950','Civil Engineer Corps, Engineer in Training (CEC EIT)'),
('951','Civil Engineer Corps, Registered Professional Engineer (CEC PE)'),
('952','Civil Engineer Corps, Registered Architect (CEC RA)'),
('960','Civil Engineer Corps, Seabee Combat Warfare (SCW)'),
('970','Civil Engineer Corps, Business Credit Attainment (CEC BCA)'),
('AA0','Acquisition AQD, Program Management, Not Certified'),
('AA1','Acquisition, Program Management, Level 1 Career Field Certified'),
('AA2','Acquisition, Program Management, Level 2 Career Field Certified'),
('AA3','Acquisition, Program Management, Level 3 Career Field Certified'),
('AAC','Acquisition AQD, Program Management, Critical'),
('AAD','Acquisition AQD, Program Management, Developmental'),
('AAG','Acquisition AQD, Program Management, Waiver Experience'),
('AAG','Acquisition, Program Management, Waiver Experience'),
('AAJ','Acquisition, Program Management, Waiver Education'),
('AAJ','Acquisition AQD, Program Management, Waiver Education'),
('AAK','Acquisition, Program Management, Waiver Training'),
('AAM','Acquisition AQD, Program Management, Fully Qualified'),
('AAN','Acquisition AQD, Program Management, Non-Critical Acquisition Billet'),
('AB1','Acquisition, Business - Cost Estimating, Level 1 Career Field Certified'),
('AB2','Acquisition, Business - Cost Estimating, Level 2 Career Field Certified'),
('AB3','Acquisition, Business - Cost Estimating, Level 3 Career Field Certified'),
('ABN','Acquisition, Business - Cost Estimating, Non-Critical Acquisition Billet'),
('AC0','Acquisition AQD, Contracting, Not Certified'),
('AC1','Acquisition, Contracting, Level 1 Career Field Certified'),
('AC2','Acquisition, Contracting, Level 2 Career Field Certified'),
('AC3','Acquisition, Contracting, Level 3 Career Field Certified'),
('ACC','Acquisition AQD, Contracting, Critical'),
('ACD','Acquisition AQD, Contracting, Developmental'),
('ACG','Acquisition, Contracting, Waiver Experience'),
('ACG','Acquisition AQD, Contracting, Waiver Experience'),
('ACJ','Acquisition, Contracting, Waiver Education'),
('ACJ','Acquisition AQD, Contracting, Waiver Education'),
('ACK','Acquisition, Contracting, Waiver Training'),
('ACM','Acquisition AQD, Contracting, Fully Qualified'),
('ACN','Acquisition, Contracting, Non-Critical Acquisition Billet'),
('AD0','Acquisition AQD, Industrial Property Management, Not Certified'),
('AD1','Acquisition AQD, Industrial Property Management, Level 1'),
('AD2','Acquisition AQD, Industrial Property Management, Level 2'),
('AD3','Acquisition AQD, Industrial Property Management, Level 3'),
('ADC','Acquisition AQD, Industrial Property Management, Critical'),
('ADD','Acquisition AQD, Industrial Property Management, Developmental'),
('ADG','Acquisition, Industrial Property Management, Waiver Experience'),
('ADG','Acquisition AQD, Industrial Property Management, Waiver Experience'),
('ADJ','Acquisition, Industrial Property Management, Waiver Education'),
('ADJ','Acquisition AQD, Industrial Property Management, Waiver Education'),
('ADK','Acquisition, Industrial Property Management, Waiver Training'),
('ADM','Acquisition AQD, Industrial Property Management, Fully Qualified'),
('ADN','Acquisition AQD, Industrial Property Management, Non-Critical'),
('AE0','Acquisition AQD, Purchasing, Not Certified'),
('AE1','Acquisition AQD, Purchasing, Level 1'),
('AE2','Acquisition AQD, Purchasing, Level 2'),
('AE3','Acquisition AQD, Purchasing, Level 3'),
('AEC','Acquisition AQD, Purchasing, Critical'),
('AED','Acquisition AQD, Purchasing, Developmental'),
('AEG','Acquisition, Purchasing, Waiver Experience'),
('AEG','Acquisition AQD, Purchasing, Waiver Experience'),
('AEJ','Acquisition, Purchasing, Waiver Education'),
('AEJ','Acquisition AQD, Purchasing, Waiver Education'),
('AEK','Acquisition, Purchasing, Waiver Training'),
('AEM','Acquisition AQD, Purchasing, Fully Qualified'),
('AEN','Acquisition AQD, Purchasing, Non-Critical'),
('AF0','Acquisition AQD, Facilities Engineering, Not Certified'),
('AF1','Acquisition, Facilities Engineering,Level 1 Career Field Certified'),
('AF2','Acquisition, Facilities Engineering, Level 2 Career Field Certified'),
('AF3','Acquisition, Facilities Engineering, Level 3 Career Field Certified'),
('AFC','Acquisition AQD, Facilities Engineering, Critical'),
('AFD','Acquisition AQD, Facilities Engineering, Developmental'),
('AFG','Acquisition, Facilities Engineering, Waiver Experience'),
('AFG','Acquisition AQD, Facilities Engineering, Waiver Experience'),
('AFJ','Acquisition, Facilities Engineering, Waiver Education'),
('AFJ','Acquisition AQD, Facilities Engineering, Waiver Education'),
('AFK','Acquisition, Facilities Engineering, Waiver Training'),
('AFM','Acquisition AQD, Facilities Engineering, Fully Qualified'),
('AFN','Acquisition, Facilities Engineering, Non-Critical Acquisition Billet'),
('AG0','Acquisition AQD, Manufacturing & Production, Not Certified'),
('AG1','Acquisition, Production, Quality, and Manufacturing, Level 1 Career Field Certified'),
('AG2','Acquisition, Production, Quality, and Manufacturing, Level 2 Career Field Certified'),
('AG3','Acquisition, Production, Quality, and Manufacturing, Level 3 Career Field Certified'),
('AGC','Acquisition AQD, Manufacturing & Production, Critical'),
('AGD','Acquisition AQD, Manufacturing & Production, Developmental'),
('AGG','Acquisition, Manufacturing & Production, Waiver Experience'),
('AGG','Acquisition AQD, Manufacturing & Production, Waiver Experience'),
('AGJ','Acquisition, Manufacturing & Production, Waiver Education'),
('AGJ','Acquisition AQD, Manufacturing & Production, Waiver Education'),
('AGK','Acquisition, Manufacturing & Production, Waiver Training'),
('AGM','Acquisition AQD, Manufacturing & Production, Fully Qualified'),
('AGN','Acquisition, Production, Quality, and Manufacturing, Non-Critical Acquisition Billet'),
('AH0','Acquisition AQD, Quality Assurance, Not Certified'),
('AH1','Acquisition AQD, Quality Assurance, Level 1'),
('AH2','Acquisition AQD, Quality Assurance, Level 2'),
('AH3','Acquisition AQD, Quality Assurance, Level 3'),
('AHC','Acquisition AQD, Quality Assurance, Critical'),
('AHD','Acquisition AQD, Quality Assurance, Developmental'),
('AHG','Acquisition, Quality Assurance, Waiver Experience'),
('AHG','Acquisition AQD, Quality Assurance, Waiver Experience'),
('AHJ','Acquisition, Quality Assurance, Waiver Education'),
('AHJ','Acquisition AQD, Quality Assurance, Waiver Education'),
('AHK','Acquisition, Quality Assurance, Waiver Training'),
('AHM','Acquisition AQD, Quality Assurance, Fully Qualified'),
('AHN','Acquisition AQD, Quality Assurance, Non-Critical'),
('AI0','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Not Certified'),
('AI1','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 1 Career Field Certified'),
('AI2','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 2 Career Field Certified'),
('AI3','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Level 3 Career Field Certified'),
('AIC','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Critical'),
('AID','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Developmental'),
('AIG','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Experience'),
('AIG','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Experience'),
('AIJ','Acquisition, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Education'),
('AIJ','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Waiver Education'),
('AIK','Acquisition, Systems Planning, RD&E � Science & Technology Manager, Waiver Training'),
('AIM','Acquisition AQD, Systems Planning, Research, Development & Engineering � Science & Technology Manager, Fully Qualified'),
('AIN','Acquisition, Systems Planning, RD&E - Science and Technology Manager, Non-Critical Acquisition Billet'),
('AJ3','Acquisition, Program Management � International Acquisition, Level 3 Career Field Certified'),
('AJN','Acquisition, Program Management � International Acquisition, Non-Critical Acquisition Billet'),
('AK0','Acquisition AQD, Business, Cost Estimating, & Financial Management, Not Certified'),
('AK1','Acquisition, Business - Financial Management, Level 1 Career Field Certified'),
('AK2','Acquisition, Business - Financial Management, Level 2 Career Field Certified'),
('AK3','Acquisition, Business - Financial Management, Level 3 Career Field Certified'),
('AKC','Acquisition AQD, Business, Cost Estimating, & Financial Management, Critical'),
('AKD','Acquisition AQD, Business, Cost Estimating, & Financial Management, Developmental'),
('AKG','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Experience'),
('AKG','Acquisition AQD, Business, Cost Estimating, & Financial Management, Waiver Experience'),
('AKJ','Acquisition, Business, Cost Estimating, & Financial Management, Waiver Education'),
('AKJ','Acquisition AQD, Business, Cost Estimating, & Financial Management, Waiver Education'),
('AKK','Acquisition, Business, Cost Estimating, & Financing Management, Waiver Training'),
('AKM','Acquisition AQD, Business, Cost Estimating, & Financial Management, Fully Qualified'),
('AKN','Acquisition, Business - Financial Management, Non-Critical Acquisition Billet'),
('AL0','Acquisition AQD, Acquisition Logistics, Not Certified'),
('AL1','Acquisition, Life Cycle Logistics, Level 1 Career Field Certified'),
('AL2','Acquisition, Life Cycle Logistics, Level 2 Career Field Certified'),
('AL3','Acquisition, Life Cycle Logistics, Level 3 Career Field Certified'),
('ALC','Acquisition AQD, Acquisition Logistics, Critical'),
('ALD','Acquisition AQD, Acquisition Logistics, Developmental'),
('ALG','Acquisition, Acquisition Logistics, Waiver Experience'),
('ALG','Acquisition AQD, Acquisition Logistics, Waiver Experience'),
('ALJ','Acquisition, Acquisition Logistics, Waiver Education'),
('ALJ','Acquisition AQD, Acquisition Logistics, Waiver Education'),
('ALK','Acquisition, Acquisition Logistics, Waiver Training'),
('ALM','Acquisition AQD, Acquisition Logistics, Fully Qualified'),
('ALN','Acquisition, Life Cycle Logistics, Non-Critical Acquisition Billet'),
('AM0','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Not Certified'),
('AM1','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Level 1'),
('AM2','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Level 2'),
('AM3','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Level 3'),
('AMC','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Critical'),
('AMD','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Developmental'),
('AMG','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Waiver Experience'),
('AMJ','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Waiver Education'),
('AMK','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Waiver Training'),
('AMM','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Fully Qualified'),
('AMN','Acquisition AQD, Life Cycle Logistics, Systems Sustainment Management, Non-Critical'),
('AP0','Acquisition AQD, Acquisition Professional Community (APC), Not Certified'),
('AP1','Acquisition AQD, Acquisition Professional Community (APC), Level 1'),
('AP2','Acquisition AQD, Acquisition Professional Community (APC), Level 2'),
('AP3','Acquisition AQD, Acquisition Professional Community (APC), Level 3'),
('APC','Acquisition AQD, Acquisition Professional Community (APC), Critical'),
('APD','Acquisition AQD, Acquisition Professional Community (APC), Developmental'),
('APG','Acquisition, Acquisition Professional Community (APC), Waiver Experience'),
('APG','Acquisition AQD, Acquisition Professional Community (APC), Waiver Experience'),
('APJ','Acquisition, Acquisition Professional Community (APC), Waiver Education'),
('APJ','Acquisition AQD, Acquisition Professional Community (APC), Waiver Education'),
('APK','Acquisition AQD, Acquisition Professional Community (APC), Waiver Training'),
('APK','Acquisition, Acquisition Professional Community (APC), Waiver Training'),
('APM','Acquisition AQD, Acquisition Professional Community (APC), Fully Qualified'),
('APN','Acquisition AQD, Acquisition Professional Community (APC), Non-Critical'),
('AR0','Acquisition AQD, Communications-Computer Systems, Not Certified'),
('AR1','Acquisition, Information Technology, Level 1 Career Field Certified'),
('AR2','Acquisition, Information Technology, Level 2 Career Field Certified'),
('AR3','Acquisition, Information Technology, Level 3 Career Field Certified'),
('ARC','Acquisition AQD, Communications-Computer Systems, Critical'),
('ARD','Acquisition AQD, Communications-Computer Systems, Developmental'),
('ARG','Acquisition, Communications-Computer Systems, Waiver Experience'),
('ARG','Acquisition AQD, Communications-Computer Systems, Waiver Experience'),
('ARJ','Acquisition, Communications-Computer Systems, Waiver Education'),
('ARJ','Acquisition AQD, Communications-Computer Systems, Waiver Education'),
('ARK','Acquisition AQD, Communications-Computer Systems, Waiver Training'),
('ARK','Acquisition, Communications-Computer Systems, Waiver Training'),
('ARM','Acquisition AQD, Communications-Computer Systems, Fully Qualified'),
('ARN','Acquisition, Information Technology, Non-Critical Career Billet'),
('AS0','Acquisition AQD, Systems Planning RD&E, Not Certified'),
('AS1','Acquisition, Systems Planning, RD&E � Systems Engineering, Level 1 Career Field Certified'),
('AS2','Acquisition, Systems Planning, RD&E � Systems Engineering, Level 2 Career Field Certified'),
('AS3','Acquisition, Systems Planning, RD&E � Systems Engineering, Level 3 Career Field Certified'),
('ASC','Acquisition AQD, Systems Planning RD&E, Critical'),
('ASD','Acquisition AQD, Systems Planning RD&E, Developmental'),
('ASG','Acquisition, Systems Planning RD&E, Waiver Experience'),
('ASG','Acquisition AQD, Systems Planning RD&E, Waiver Experience'),
('ASJ','Acquisition, Systems Planning RD&E, Waiver Education'),
('ASJ','Acquisition AQD, Systems Planning RD&E, Waiver Education'),
('ASK','Acquisition, Systems Planning RD&E, Waiver Training'),
('ASM','Acquisition AQD, Systems Planning RD&E, Fully Qualified'),
('ASN','Acquisition, Systems Planning, RD&E � Systems Engineering, Non-Critical Acquisition Billet'),
('AT0','Acquisition AQD, Test & Evaluation Engineering, Not Certified'),
('AT1','Acquisition, Test & Evaluation, Level 1 Career Field Certified'),
('AT2','Acquisition, Test & Evaluation, Level 2 Career Field Certified'),
('AT3','Acquisition, Test & Evaluation, Level 3 Career Field Certified'),
('ATC','Acquisition AQD, Test & Evaluation Engineering, Critical'),
('ATD','Acquisition AQD, Test & Evaluation Engineering, Developmental'),
('ATG','Acquisition AQD, Test & Evaluation Engineering, Waiver Experience'),
('ATG','Acquisition, Test & Evaluation Engineering, Waiver Experience'),
('ATJ','Acquisition, Test & Evaluation Engineering, Waiver Education'),
('ATJ','Acquisition AQD, Test & Evaluation Engineering, Waiver Education'),
('ATK','Acquisition, Test & Evaluation Engineering, Waiver Training'),
('ATM','Acquisition AQD, Test & Evaluation Engineering, Fully Qualified'),
('ATN','Acquisition, Test & Evaluation, Non-Critical Acquisition Billet'),
('AU0','Acquisition AQD, Auditing (Reserved for DCAA use), Not Certified'),
('AU1','Acquisition AQD, Auditing (Reserved for DCAA use), Level 1'),
('AU2','Acquisition AQD, Auditing (Reserved for DCAA use), Level 2'),
('AU3','Acquisition AQD, Auditing (Reserved for DCAA use), Level 3'),
('AUC','Acquisition AQD, Auditing (Reserved for DCAA use), Critical'),
('AUD','Acquisition AQD, Auditing (Reserved for DCAA use), Developmental'),
('AUG','Acquisition, Auditing (Reserved for DCAA use), Waiver Experience'),
('AUG','Acquisition AQD, Auditing (Reserved for DCAA use), Waiver Experience'),
('AUJ','Acquisition, Auditing (Reserved for DCAA use), Waiver Education'),
('AUJ','Acquisition AQD, Auditing (Reserved for DCAA use), Waiver Education'),
('AUK','Acquisition, Auditing (Reserved for DCAA use), Waiver Training'),
('AUM','Acquisition AQD, Auditing (Reserved for DCAA use), Fully Qualified'),
('AUN','Acquisition AQD, Auditing (Reserved for DCAA use), Non-Critical'),
('AV0','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Not Certified'),
('AV1','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Level 1'),
('AV2','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Level 2'),
('AV3','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Level 3'),
('AVC','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Critical'),
('AVD','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Developmental'),
('AVG','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Experience'),
('AVG','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Waiver Experience'),
('AVJ','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Education'),
('AVJ','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Waiver Education'),
('AVK','Acquisition, Program Management Oversight (Reserved for RD&A use), Waiver Training'),
('AVM','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Fully Qualified'),
('AVN','Acquisition AQD, Program Management Oversight (Reserved for RD&A use), Non-Critical'),
('AW0','Acquisition, System Planning RD&E - Program Systems Engineering, Not Certified'),
('AW1','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 1 Career Field Certified'),
('AW2','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 2 Career Field Certified'),
('AW3','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Level 3 Career Field Certified'),
('AWD','Acquisition, System Planning RD&E - Program Systems Engineering, Developmental'),
('AWG','Acquisition, System Planning RD&E - Program Systems Engineering, Waiver Experience'),
('AWJ','Acquisition, System Planning RD&E - Program Systems Engineering, Waiver Education'),
('AWK','Acquisition, System Planning RD&E - Program Systems Engineering, Key Leadership Position'),
('AWM','Acquisition, System Planning RD&E - Program Systems Engineering, Fully Qualified'),
('AWN','Acquisition, Systems Planning, RD&E - Program Systems Engineering, Non-Critical Acquisition Billet'),
('AX0','Acquisition AQD, Education, Training & Career Development, Not Certified'),
('AX1','Acquisition AQD, Education, Training & Career Development, Level 1'),
('AX2','Acquisition AQD, Education, Training & Career Development, Level 2'),
('AX3','Acquisition AQD, Education, Training & Career Development, Level 3'),
('AXC','Acquisition AQD, Education, Training & Career Development, Critical'),
('AXD','Acquisition AQD, Education, Training & Career Development, Developmental'),
('AXG','Acquisition, Education, Training & Career Development, Waiver Experience'),
('AXG','Acquisition AQD, Education, Training & Career Development, Waiver Experience'),
('AXJ','Acquisition, Education, Training & Career Development, Waiver Education'),
('AXJ','Acquisition AQD, Education, Training & Career Development, Waiver Education'),
('AXK','Acquisition, Education, Training & Career Development, Waiver Training'),
('AXM','Acquisition AQD, Education, Training & Career Development, Fully Qualified'),
('AXN','Acquisition, Education, Training, and Career Development, Non-Critical Acquisition Billet'),
('AYB','Acquisition, Requirements Management Certification Training (RMCT), Level B'),
('AYC','Acquisition, Requirements Management Certification Training (RMCT), Level C')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 5...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('BA1','Naval Warfare (General), ASW Qualified, Operational'),
('BA2','Naval Warfare (General), ASW Qualified, Operational'),
('BA3','Naval Warfare (General), ASW Qualified, Key Manager'),
('BA4','Naval Warfare (General), ASW Qualified, IUSS'),
('BA5','Naval Warfare (General), ASW Qualified, IUSS Experienced'),
('BA6','Naval Warfare (General), Theater Anti-Submarine Warfare (TASW), Theater Anti-Submarine Warfare Watch Officer (TASWWO)'),
('BA7','Naval Warfare (General), Theater Anti-Submarine Warfare (TASW), Theater Anti- Submarine Warfare Battle Watch Captain (TASW BWC)'),
('BA8','Naval Warfare (General), Undersea Combat Systems, Qualified'),
('BA9','Naval Warfare (General), ASW Qualified, IUSS SURTASS Mission Commander'),
('BB1','Naval Warfare (General), Staff Officer, Battle Watch Captain'),
('BC8','Naval Warfare (General), Naval Aviation Supply Officer, Qualified'),
('BD1','Naval Warfare (General), Naval Aviation Observer, Qualified'),
('BE1','Naval Warfare (General), AAW, Qualified'),
('BF1','Naval Warfare (General), AAW (Supercedes BE), Technical Expert'),
('BG1','Naval Warfare (General), AAW (Supersedes BE), Operational Expert'),
('BH0','Naval Warfare (General), Military Deception, Planner'),
('BI1','Naval Warfare (General), Information Warfare (IW), Basic'),
('BI2','Naval Warfare (General), Information Warfare (IW), Tactical'),
('BI3','Naval Warfare (General), Information Warfare (IW), Operational'),
('BI4','Naval Warfare (General), Information Warfare (IW), Qualified Operational Commander (Captain and Commander billet only)'),
('BJ1','Naval Warfare (General), EW, Qualified'),
('BL1','Naval Warfare (General), Electronic Warfare, Apprentice'),
('BL2','Naval Warfare (General), Electronic Warfare, Journeyman'),
('BM1','Naval Warfare (General), Missile Defense, Basic Level BMD'),
('BM2','Naval Warfare (General), Missile Defense, Senior Level BMD'),
('BN1','Naval Warfare (General), Mine Warfare, Basic Level (Mining)'),
('BN2','Naval Warfare (General), Mine Warfare, Qualified Tactical Planner (Mining)'),
('BN3','Naval Warfare (General), Mine Warfare, Basic Level (Counter Measures)'),
('BN4','Naval Warfare (General), Mine Warfare, Qualified Tactical Planner (Counter Measures)'),
('BN5','Naval Warfare (General), Mine Warfare, Qualified Operational (CAPT and CDR billet only)'),
('BO1','Naval Warfare (General), Computer Network Operations (CNO), Technical Integration Officer'),
('BO2','Naval Warfare (General), Computer Network Operations (CNO), Mission Manager'),
('BO3','Naval Warfare (General), Computer Network Operations (CNO), Service Planner'),
('BO4','Naval Warfare (General), Computer Network Operations (CNO), Joint Planner'),
('BR0','Naval Warfare (General), Regional Hand, Asia Pacific Hand Entry Qualified'),
('BR1','Naval Warfare (General), Regional Hand, Asia Pacific Hand Basic Qualified'),
('BR2','Naval Warfare (General), Regional Hand, Asia Pacific Hand Fully Proficient Qualified'),
('BR3','Naval Warfare (General), Regional Hand, Asia Pacific Hand Master'),
('BR4','Naval Warfare (General), Regional Hand, Asia Pacific Hand Expert'),
('BS1','Naval Warfare (General), Shipboard Tomahawk Strike Officer, In Training'),
('BS2','Naval Warfare (General), Shipboard Tomahawk Strike Officer, Qualified'),
('BS3','Naval Warfare (General), Staff Tomahawk Strike Officer, In Training'),
('BS4','Naval Warfare (General), Staff Tomahawk Strike Officer, Qualified'),
('BT1','Naval Warfare (General), Parachutist, Static-line Qualified'),
('BT2','Naval Warfare (General), Parachutist, Freefall Qualified'),
('BU1','Naval Warfare (General), Special Technical Operations, Qualified'),
('BX1','Naval Warfare (General), Expeditionary Warfare, Planner'),
('BX2','Naval Warfare (General), Expeditionary Warfare, Fleet Marine Force (FMF) Warfare Officer'),
('BYB','Naval Warfare (General), Requirements Management Certification Training (RMCT), Level B'),
('BYC','Naval Warfare (General), Requirements Management Certification Training (RMCT), Level C'),
('CA1','Line Officer Shore Assignment, Division Officer, Chief Warrant Officer'),
('CA2','Line Officer Shore Assignment, Division Officer, Chief Warrant Officer'),
('CA3','Line Officer Shore Assignment, Division Officer, Chief Warrant Officer'),
('CA4','Line Officer Shore Assignment, Division Officer, Chief Warrant Officer'),
('CA5','Line Officer Shore Assignment, Division Officer, Chief Warrant Officer'),
('CA6','Line Officer Shore Assignment, Division Officer, Captain'),
('CB1','Line Officer Shore Assignment, Department Head, Chief Warrant Officer'),
('CB2','Line Officer Shore Assignment, Department Head, Chief Warrant Officer'),
('CB3','Line Officer Shore Assignment, Department Head, Chief Warrant Officer'),
('CB4','Line Officer Shore Assignment, Department Head, Chief Warrant Officer'),
('CB5','Line Officer Shore Assignment, Department Head, Chief Warrant Officer'),
('CB6','Line Officer Shore Assignment, Department Head, Captain'),
('CBD','Line Officer Shore Assignment, Shore Installation Management, Officer in Charge'),
('CC1','Line Officer Shore Assignment, Executive Officer, Chief Warrant Officer'),
('CC2','Line Officer Shore Assignment, Executive Officer, Chief Warrant Officer'),
('CC3','Line Officer Shore Assignment, Executive Officer, Chief Warrant Officer'),
('CC4','Line Officer Shore Assignment, Executive Officer, Chief Warrant Officer'),
('CC5','Line Officer Shore Assignment, Executive Officer, Chief Warrant Officer'),
('CC6','Line Officer Shore Assignment, Executive Officer, Captain'),
('CD1','Line Officer Shore Assignment, Officer-in-Charge, Chief Warrant Officer'),
('CD2','Line Officer Shore Assignment, Officer-in-Charge, Chief Warrant Officer'),
('CD3','Line Officer Shore Assignment, Officer-in-Charge, Chief Warrant Officer'),
('CD4','Line Officer Shore Assignment, Officer-in-Charge, Chief Warrant Officer'),
('CD5','Line Officer Shore Assignment, Officer-in-Charge, Chief Warrant Officer'),
('CD6','Line Officer Shore Assignment, Officer-in-Charge, Captain'),
('CE1','Line Officer Shore Assignment, Shore Command, Chief Warrant Officer'),
('CE2','Line Officer Shore Assignment, Shore Command, Chief Warrant Officer'),
('CE3','Line Officer Shore Assignment, Shore Command, Chief Warrant Officer'),
('CE4','Line Officer Shore Assignment, Shore Command, Chief Warrant Officer'),
('CE5','Line Officer Shore Assignment, Shore Command, Chief Warrant Officer'),
('CE6','Line Officer Shore Assignment, Shore Command, Captain'),
('CF1','Line Officer Shore Assignment, Major Shore Command, Chief Warrant Officer'),
('CF2','Line Officer Shore Assignment, Major Shore Command, Chief Warrant Officer'),
('CF3','Line Officer Shore Assignment, Major Shore Command, Chief Warrant Officer'),
('CF4','Line Officer Shore Assignment, Major Shore Command, Chief Warrant Officer'),
('CF5','Line Officer Shore Assignment, Major Shore Command, Chief Warrant Officer'),
('CF6','Line Officer Shore Assignment, Major Shore Command, Captain'),
('CG1','Line Officer Shore Assignment, Deputy Project Manager, Chief Warrant Officer'),
('CG2','Line Officer Shore Assignment, Deputy Project Manager, Chief Warrant Officer'),
('CG3','Line Officer Shore Assignment, Deputy Project Manager, Chief Warrant Officer'),
('CG4','Line Officer Shore Assignment, Deputy Project Manager, Chief Warrant Officer'),
('CG5','Line Officer Shore Assignment, Deputy Project Manager, Chief Warrant Officer'),
('CG6','Line Officer Shore Assignment, Deputy Project Manager, Captain'),
('CH1','Line Officer Shore Assignment, Project Manager, Chief Warrant Officer'),
('CH2','Line Officer Shore Assignment, Project Manager, Chief Warrant Officer'),
('CH3','Line Officer Shore Assignment, Project Manager, Chief Warrant Officer'),
('CH4','Line Officer Shore Assignment, Project Manager, Chief Warrant Officer'),
('CH5','Line Officer Shore Assignment, Project Manager, Chief Warrant Officer'),
('CH6','Line Officer Shore Assignment, Project Manager, Captain'),
('CI1','Line Officer Shore Assignment, Major Project Manager, Chief Warrant Officer'),
('CI2','Line Officer Shore Assignment, Major Project Manager, Chief Warrant Officer'),
('CI3','Line Officer Shore Assignment, Major Project Manager, Chief Warrant Officer'),
('CI4','Line Officer Shore Assignment, Major Project Manager, Chief Warrant Officer'),
('CI5','Line Officer Shore Assignment, Major Project Manager, Chief Warrant Officer'),
('CI6','Line Officer Shore Assignment, Major Project Manager, Captain'),
('DA0','Aviation Warfare, Attack, Any (Attack)'),
('DA1','Aviation Warfare, Attack, Light Attack (TA-4J)'),
('DA2','Aviation Warfare, Attack, Light Attack (A-7)'),
('DA6','Aviation Warfare, Attack, Light Attack (AV-8)'),
('DA7','Aviation Warfare, Attack, Light Attack (FA-18)'),
('DAA','Aviation Warfare, Attack, Strike Warfare Instructor (Attack)'),
('DAB','Aviation Warfare, Attack, Strike Leader Graduate (Attack)'),
('DAC','Aviation Warfare, Attack, Medium attack (A-12)'),
('DB0','Aviation Warfare, Fighter, Any (Fighter)'),
('DB1','Aviation Warfare, Training, Strike Fighter Tactics Instructor (SFTI) (Fighter)'),
('DB3','Aviation Warfare, Fighter, FTR/Bomber (F-5)'),
('DB4','Aviation Warfare, Fighter, FTR/Bomber (F-14)'),
('DB6','Aviation Warfare, Fighter, FTR/Bomber (FA-18)'),
('DB7','Aviation Warfare, Fighter, TOPGUN Fighter Graduate (Fighter)'),
('DB8','Aviation Warfare, Fighter, Adversary Graduate (Fighter/Attack)'),
('DB9','Aviation Warfare, Fighter, TOPGUN Instructor (Fighter)'),
('DC4','Aviation Warfare, Combat Support, Photo Recon (F-14)'),
('DC5','Aviation Warfare, Combat Support, ISR Patrol'),
('DC6','Aviation Warfare, Combat Support, Instructor ISR Patrol'),
('DCF','Aviation Warfare, Combat Support, Forward Air Controller (Airborne) (F-14A, F-14B,) FAC (A) (F-14D, FA-18D, or FA-18F)'),
('DD0','Aviation Warfare, Combat Support, Any Recon (ECM Recon)'),
('DD1','Aviation Warfare, Combat Support, ECM Recon (EA-18G)'),
('DD2','Aviation Warfare, Combat Support, ECM Recon (EA-6)'),
('DD3','Aviation Warfare, Combat Support, ECM Recon (ERA-3)'),
('DD4','Aviation Warfare, Combat Support, ECM Recon (EA-3)'),
('DD6','Aviation Warfare, Combat Support, ECM Recon (EA-7)'),
('DD7','Aviation Warfare, Combat Support, ECM/ELINT/COMM (ES-3A)'),
('DD8','Aviation Warfare, Combat Support, ECM/ELINT/COMM (E-6A)'),
('DD9','Aviation Warfare, Combat Support, Prowler Tactics Instructor (EA-6B)'),
('DE1','Aviation Warfare, Transport , Light Jet (CT-39)'),
('DE3','Aviation Warfare, Transport , Heavy Jet (C-9)'),
('DE4','Aviation Warfare, Logistics, Medium Jet (C-20)'),
('DE5','Aviation Warfare, Logistics, Heavy Jet (C-40)'),
('DF0','Aviation Warfare, ASW, Any (ASW)'),
('DF2','Aviation Warfare, ASW, Carrier ASW (S-3)'),
('DF3','Aviation Warfare, ASW, Carrier ASW (S-3B)'),
('DF4','Aviation Warfare, ASW, Carrier (SUW) (S-3B)'),
('DF9','Aviation Warfare, Training, Viking Tactic Instructor (S-3B)'),
('DG0','Aviation Warfare, General Jet, Any Jet'),
('DG1','Aviation Warfare, Training, Instructor (Fleet Experience) (Any Jet)'),
('DG2','Aviation Warfare, Training, Instructor (Non-Fleet Experience) (Any Jet)'),
('DG3','Aviation Warfare, General Jet, Composite (Any Jet)'),
('DG5','Aviation Warfare, Training Pipeline, Pilot Training - Jet (Any Jet)'),
('DG6','Aviation Warfare, Training Pipeline, NFO Training - RIO (Any Jet)'),
('DG7','Aviation Warfare, Training Pipeline, NFO Training - AJN (Any Jet)'),
('DG8','Aviation Warfare, Training Pipeline, NFO Training - AELW (Any Jet)'),
('DG9','Aviation Warfare, Training Pipeline, NFO Training - ASW'),
('DJ0','Aviation Warfare, ASW, Any (Any)'),
('DJ3','Aviation Warfare, ASW, ASW Patrol (P-3A/B)'),
('DJ4','Aviation Warfare, ASW, ASW Patrol (P-3C)'),
('DK0','Aviation Warfare, Combat Support, Any (ECM/ELINT)'),
('DK2','Aviation Warfare, Combat Support, ECM/ELINT (EP-3)'),
('DK5','Aviation Warfare, Combat Support, ECM/ELINT (RP-3)'),
('DK6','Aviation Warfare, Combat Support, SPECIAL PROJECTS'),
('DK7','Aviation Warfare, Combat Support, SPECIAL PROJECTS INSTRUCTOR'),
('DK8','Aviation Warfare, Training, Joint Advanced Tactical Signals Intelligence Training Program (JATSTP) Graduate'),
('DK9','Aviation Warfare, Training, VQ Weapons and Tactics Instructor (VQTI) - EP-3E, SP P-3'),
('DL0','Aviation Warfare, Combat Support, Any (AEW)'),
('DL3','Aviation Warfare, Combat Support, Carrier AEW (E-2C)'),
('DL4','Aviation Warfare, Combat Support, Aviation Warfare, Instructor CICO/Instructor CAPC (EC2 HAWKEYE)'),
('DL5','Aviation Warfare, Combat Support, Weapons and Tactics Instructor (WTI) (EC2 HAWKEYE)'),
('DM0','Aviation Warfare, Combat Support, MAGNET/BIRDSEYE/SEASCN (RP-3A/D)'),
('DN2','Aviation Warfare, Combat Support, LT Obervation (OV-10)'),
('DP1','Aviation Warfare, Combat Support, Utility (UC-12)'),
('DP2','Aviation Warfare, Combat Support, Utility Medium (U-6)'),
('DP8','Aviation Warfare, Combat Support, Utility (US-3)'),
('DQ4','Aviation Warfare, Transport, Transport Hvy (C-130)'),
('DQ5','Aviation Warfare, Transport, Transport Hvy (VP-3)'),
('DR0','Aviation Warfare, Transport, Any (Med Trans)'),
('DS0','Aviation Warfare, Transport, Any (Carrier Trans)'),
('DS2','Aviation Warfare, Transport, Carrier Trans (C-2)'),
('DT0','Aviation Warfare, General (Prop), Any Prop'),
('DT1','Aviation Warfare, Transport, Instructor (Fleet Experience) (Any Prop)'),
('DT2','Aviation Warfare, Transport, Instructor (Non-Fleet Experience) (Any Prop)'),
('DT3','Aviation Warfare, General (Prop), Composite (Any Prop)'),
('DT4','Aviation Warfare, Training, Maritime Patrol and Reconnaissance WT1 (P-3C)'),
('DT5','Aviation Warfare, Training Pipeline, Pilot Training - Prop (Any Prop)'),
('DT6','Aviation Warfare, Training Pipeline, NFO Training - NAV (Any Prop)'),
('DT7','Aviation Warfare, Training Pipeline, NFO Training - ATDS (Any Prop)'),
('DT8','Aviation Warfare, Training Pipeline, NFO Training - AEW (Any Prop)'),
('DU1','Aviation Warfare, ASW, Served Aviation Commander Cmd'),
('DU2','Aviation Warfare, Served Second Sequential Aviation Command Cmd'),
('DU3','Aviation Warfare, Served Aviation Captain Cmd'),
('DV0','Aviation Warfare, Any (ASW-Lamps)'),
('DV1','Aviation Warfare, ASW (Carrier) (SH-3)'),
('DV2','Aviation Warfare, ASW (Lamps) (SH-2)'),
('DV3','Aviation Warfare, ASW (Carrier) (SH-60F)'),
('DV4','Aviation Warfare, ASW (Lamps) (SH-60B)'),
('DV5','Aviation Warfare, ASW (Lamps), MH-60R'),
('DW0','Aviation Warfare, Combat Support, Any (SAR/Mine Counter- Measures/Logistics)'),
('DW1','Aviation Warfare, Combat Support, Attack/SAR/Logistics (A/UH-1)'),
('DW4','Aviation Warfare, Combat Support, SAR/Logistics (UH-3)'),
('DW5','Aviation Warfare, Combat Support, SAR/Logistics (C/U/HH-46)'),
('DW6','Aviation Warfare, Combat Support, SAR/MCM/Logistics (RH-53)'),
('DW7','Aviation Warfare, Combat Support, SAR/Logistics (CH-53)'),
('DW8','Aviation Warfare, Combat Support, SAR/MCM/Logistics (MH-53)'),
('DW9','Aviation Warfare, Combat Support, CSAR (HH-60H)'),
('DWA','Aviation Warfare, Combat Support, Basic/PQM (MH-60S)'),
('DWB','Aviation Warfare, Combat Support, SAR/Logistics (MH-60S)'),
('DWC','Aviation Warfare, Combat Support, Combat/SAR (MH-60S)'),
('DWD','Aviation Warfare, Combat Support, Mine Warfare (MH-60S)'),
('DWE','Aviation Warfare, Combat Support, Special Warfare'),
('DX1','Aviation Warfare, Transport, Transport (VH-3)'),
('DY0','Aviation Warfare, General (Helo), Any Helo (Any Helo)'),
('DY1','Aviation Warfare, Training, Instructor (Fleet Experience) (Any Helo)'),
('DY2','Aviation Warfare, Helicopter, Weapons and Tactics Instructor (WTI) (H-60)'),
('DY3','Aviation Warfare, General (Helo), Composite'),
('DY5','Aviation Warfare, Training Pipeline, Pilot Training - Helo (Any Helo)'),
('DY6','Aviation Warfare, Training Pipeline, NFO Training - ASW'),
('DZ1','Aviation Warfare, Spacecraft'),
('DZ2','Aviation Warfare, Unspecified Vehicle'),
('DZ3','Aviation Warfare, Any Vehicle'),
('DZ4','Aviation Warfare, VSTOL'),
('DZ5','Aviation Warfare, Non-Fleet Experienced (Jet)'),
('DZ6','Aviation Warfare, Non-Fleet Experienced (Prop)'),
('DZ7','Aviation Warfare, Non-Fleet Experienced (Helo)'),
('DZA','Aviation Warfare, Joint Air Operations, Graduate � Joint Air Operations Command and Control Course'),
('DZB','Aviation Warfare, Joint Air Operations, AOC experience � Exercise Only'),
('DZC','Aviation Warfare, Joint Air Operations, AOC Qualified'),
('DZD','Aviation Warfare, Joint Air Operations, AOC Operational Experience'),
('DZE','Aviation Warfare, Joint Air Operations, Naval and Amphibious Liaison Element (NALE) Liaison Officer, Embarked'),
('DZF','Aviation Warfare, Joint Air Operations, Graduate � AOC Combat Operations Initial Qualification Training (IQT) course'),
('DZG','Aviation Warfare, Joint Air Operations, Graduate � AOC Combat Plans Initial Qualification Training (IQT) course'),
('DZH','Aviation Warfare, Joint Air Operations, Graduate � AOC Airspace Initial Qualification Training (IQT) course'),
('DZI','Aviation Warfare, STRATEGY'),
('DZJ','Aviation Warfare, Joint Air Operations, Graduate � AOC Intelligence, Surveillance and Reconnaissance (ISR) Initial Qualification Training (IQT) course'),
('DZK','Aviation Warfare, JFACC PR'),
('DZL','Aviation Warfare, Joint Air Operations, Graduate � AOC Interface Control Officer (ICO) Initial Qualification Training (IQT) course'),
('DZM','Aviation Warfare, C2WAC'),
('DZN','Aviation Warfare, J/CSSC'),
('DZO','Aviation Warfare, Joint Air Operations, Graduate � Joint Force Air Component Commander (JFACC) Augmentation Staff Course'),
('DZP','Aviation Warfare, Training/Experience, TacMobile'),
('DZQ','Aviation Warfare, Joint Air Operations, Graduate � Aviation Safety Officer course (ASO GRAD)'),
('DZR','Aviation Warfare, Training/Experience, Avionics'),
('EA2','Aviation Warfare, FLD (Field Qualified), TA-4J'),
('EA5','Aviation Warfare, FLD (Field Qualified), EA6'),
('EA8','Aviation Warfare, FLD (Field Qualified), C2, E2'),
('EAD','Aviation Warfare, FLD (Field Qualified), F14'),
('EAF','Aviation Warfare, FLD (Field Qualified), S3'),
('EAG','Aviation Warfare, FLD (Field Qualified), T2'),
('EAK','Aviation Warfare, FLD (Field Qualified), F14, S3'),
('EAU','Aviation Warfare, FLD (Field Qualified), OTHER'),
('EAY','Aviation Warfare, FLD (Field Qualified), F/A 18'),
('EAZ','Aviation Warfare, FLD (Field Qualified), T2, TA-4J'),
('EB2','Aviation Warfare, SQV (Squadron LSO CV), TA-4J'),
('EB5','Aviation Warfare, SQV (Squadron LSO CV), EA6'),
('EB8','Aviation Warfare, SQV (Squadron LSO CV), C2, E2'),
('EBD','Aviation Warfare, SQV (Squadron LSO CV), F14'),
('EBF','Aviation Warfare, SQV (Squadron LSO CV), S3'),
('EBG','Aviation Warfare, SQV (Squadron LSO CV), T2'),
('EBK','Aviation Warfare, SQV (Squadron LSO CV), F14, S3'),
('EBU','Aviation Warfare, SQV (Squadron LSO CV), OTHER'),
('EBY','Aviation Warfare, SQV (Squadron LSO CV), F/A 18'),
('EBZ','Aviation Warfare, SQV (Squadron LSO CV), T2, TA-4J'),
('EC2','Aviation Warfare, WQV (Wing LSO CV), TA-4J'),
('EC5','Aviation Warfare, WQV (Wing LSO CV), EA6'),
('EC8','Aviation Warfare, WQV (Wing LSO CV), C2, E2'),
('ECD','Aviation Warfare, WQV (Wing LSO CV), F14'),
('ECF','Aviation Warfare, WQV (Wing LSO CV), S3'),
('ECG','Aviation Warfare, WQV (Wing LSO CV), T2'),
('ECK','Aviation Warfare, WQV (Wing LSO CV), F14, S3'),
('ECU','Aviation Warfare, WQV (Wing LSO CV), OTHER'),
('ECY','Aviation Warfare, WQV (Wing LSO CV), F/A 18'),
('ECZ','Aviation Warfare, WQV (Wing LSO CV), T2, TA-4J'),
('ED2','Aviation Warfare, TRV (Training LSO CV), TA-4J'),
('ED5','Aviation Warfare, TRV (Training LSO CV), EA6'),
('ED8','Aviation Warfare, TRV (Training LSO CV), C2, E2'),
('EDD','Aviation Warfare, TRV (Training LSO CV), F14'),
('EDF','Aviation Warfare, TRV (Training LSO CV), S3'),
('EDG','Aviation Warfare, TRV (Training LSO CV), T2'),
('EDK','Aviation Warfare, TRV (Training LSO CV), F14, S3'),
('EDU','Aviation Warfare, TRV (Training LSO CV), OTHER'),
('EDY','Aviation Warfare, TRV (Training LSO CV), F/A 18'),
('EDZ','Aviation Warfare, TRV (Training LSO CV), T2, TA-4J'),
('EF2','Aviation Warfare, SFV (Staff LSO CV), TA-4J'),
('EF5','Aviation Warfare, SFV (Staff LSO CV), EA6'),
('EF8','Aviation Warfare, SFV (Staff LSO CV), C2, E2'),
('EFD','Aviation Warfare, SFV (Staff LSO CV), F14'),
('EFF','Aviation Warfare, SFV (Staff LSO CV), S3'),
('EFG','Aviation Warfare, SFV (Staff LSO CV), T2'),
('EFK','Aviation Warfare, SFV (Staff LSO CV), F14, S3'),
('EFU','Aviation Warfare, SFV (Staff LSO CV), OTHER'),
('EFY','Aviation Warfare, SFV (Staff LSO CV), F/A 18'),
('EFZ','Aviation Warfare, SFV (Staff LSO CV), T2, TA-4J'),
('EH2','Aviation Warfare, VTI (VT LSO CAT I), TA-4J'),
('EH5','Aviation Warfare, VTI (VT LSO CAT I), EA6'),
('EH8','Aviation Warfare, VTI (VT LSO CAT I), C2, E2'),
('EHD','Aviation Warfare, VTI (VT LSO CAT I), F14'),
('EHF','Aviation Warfare, VTI (VT LSO CAT I), S3'),
('EHG','Aviation Warfare, VTI (VT LSO CAT I), T2'),
('EHK','Aviation Warfare, VTI (VT LSO CAT I), F14, S3'),
('EHU','Aviation Warfare, VTI (VT LSO CAT I), OTHER'),
('EHY','Aviation Warfare, VTI (VT LSO CAT I), F/A 18'),
('EHZ','Aviation Warfare, VTI (VT LSO CAT I), T2, TA-4J'),
('EJ2','Aviation Warfare, VTII (VT LSO CAT II), TA-4J'),
('EJ5','Aviation Warfare, VTII (VT LSO CAT II), EA6'),
('EJ8','Aviation Warfare, VTII (VT LSO CAT II), C2, E2'),
('EJD','Aviation Warfare, VTII (VT LSO CAT II), F14'),
('EJF','Aviation Warfare, VTII (VT LSO CAT II), S3'),
('EJG','Aviation Warfare, VTII (VT LSO CAT II), T2'),
('EJK','Aviation Warfare, VTII (VT LSO CAT II), F14, S3'),
('EJU','Aviation Warfare, VTII (VT LSO CAT II), OTHER'),
('EJY','Aviation Warfare, VTII (VT LSO CAT II), F/A 18'),
('EJZ','Aviation Warfare, VTII (VT LSO CAT II), T2, TA-4J'),
('EK2','Aviation Warfare, VTIII (VT LSO CAT III), TA-4J'),
('EK5','Aviation Warfare, VTIII (VT LSO CAT III), EA6'),
('EK8','Aviation Warfare, VTIII (VT LSO CAT III), C2, E2'),
('EKD','Aviation Warfare, VTIII (VT LSO CAT III), F14'),
('EKF','Aviation Warfare, VTIII (VT LSO CAT III), S3'),
('EKG','Aviation Warfare, VTIII (VT LSO CAT III), T2'),
('EKK','Aviation Warfare, VTIII (VT LSO CAT III), F14, S3'),
('EKU','Aviation Warfare, VTIII (VT LSO CAT III), OTHER'),
('EKY','Aviation Warfare, VTIII (VT LSO CAT III), F/A 18'),
('EKZ','Aviation Warfare, VTIII (VT LSO CAT III), T2, TA-4J'),
('EU2','Aviation Warfare, LSO SCHL INT, TA-4J'),
('EU5','Aviation Warfare, LSO SCHL INT, EA6'),
('EU8','Aviation Warfare, LSO SCHL INT, C2, E2'),
('EUD','Aviation Warfare, LSO SCHL INT, F14'),
('EUF','Aviation Warfare, LSO SCHL INT, S3'),
('EUG','Aviation Warfare, LSO SCHL INT, T2'),
('EUK','Aviation Warfare, LSO SCHL INT, F14, S3'),
('EUU','Aviation Warfare, LSO SCHL INT, OTHER'),
('EUY','Aviation Warfare, LSO SCHL INT, F/A 18'),
('EUZ','Aviation Warfare, LSO SCHL INT, T2, TA-4J'),
('EY2','Aviation Warfare, LSO SCHL GRD, TA-4J'),
('EY5','Aviation Warfare, LSO SCHL GRD, EA6'),
('EY8','Aviation Warfare, LSO SCHL GRD, C2, E2'),
('EYD','Aviation Warfare, LSO SCHL GRD, F14'),
('EYF','Aviation Warfare, LSO SCHL GRD, S3'),
('EYG','Aviation Warfare, LSO SCHL GRD, T2'),
('EYK','Aviation Warfare, LSO SCHL GRD, F14, S3'),
('EYU','Aviation Warfare, LSO SCHL GRD, OTHER'),
('EYY','Aviation Warfare, LSO SCHL GRD, F/A 18'),
('EYZ','Aviation Warfare, LSO SCHL GRD, T2, TA-4J'),
('EZ2','Aviation Warfare, LSO SCH GRD, TA-4J'),
('EZ5','Aviation Warfare, LSO SCH GRD, EA6'),
('EZ8','Aviation Warfare, LSO SCH GRD, C2, E2'),
('EZD','Aviation Warfare, LSO SCH GRD, F14'),
('EZF','Aviation Warfare, LSO SCH GRD, S3'),
('EZG','Aviation Warfare, LSO SCH GRD, T2'),
('EZK','Aviation Warfare, LSO SCH GRD, F14, S3'),
('EZU','Aviation Warfare, LSO SCH GRD, OTHER'),
('EZY','Aviation Warfare, LSO SCH GRD, F/A 18'),
('EZZ','Aviation Warfare, LSO SCH GRD, T2, TA-4J'),
('FA1','Foreign Areas (FA), Qualified, Middle East, Africa, South Asia Region'),
('FA2','Foreign Areas (FA), Qualified, East Asia, Pacific Region'),
('FA3','Foreign Areas (FA), Qualified, Western Hemisphere Region'),
('FA4','Foreign Areas (FA), Qualified, Europe, Eurasia Region'),
('FT1','Foreign Areas (FA), In Training, Middle East, Africa, South Asia Region'),
('FT2','Foreign Areas (FA), In Training, East Asia, Pacific Region'),
('FT3','Foreign Areas (FA), In Training, Western Hemisphere Region'),
('FT4','Foreign Areas (FA), In Training, Europe, Eurasia Region'),
('GA1','Information Dominance Warfare, Information Professional, Basic Qualification'),
('GA2','Information Dominance Warfare, Information Professional, Intermediate Qualification'),
('GA3','Information Professional, Advanced Qualification'),
('GA4','Information Professional, Qualified as a Strike Group Staff Battle Watch Captain (SGSBWC)'),
('GA5','Information Dominance Warfare, Strike Group Staff Tactical Action Officer (SGSTAO)'),
('GA6','Information Dominance Warfare, Information Professional, Knowledge Management Officer (KM)'),
('GA7','Information Dominance Warfare, Information Assurance Officer (IA)'),
('GA8','Information Dominance Warfare, Chief Information Officer (CIO)'),
('GA9','Information Dominance Warfare, Individual Augmentee'),
('GB1','Information Professional, LCDR Milestone'),
('GB2','Information Professional, CDR Milestone'),
('GB3','Information Professional, CAPT Milestone'),
('GC0','Information Dominance Warfare, Information Dominance Warfare Officer (IDWO)'),
('GC1','Information Dominance Warfare, Information Dominance Warfare Officer (IDWO) Qualification Program, Information Dominance Mid-Career Course Completion'),
('GD1','Information Dominance Warfare, Information Dominance Focus Area, East Asia'),
('HA1','Recruiting, Navy Recruiting Area, Area Commander'),
('HA2','Recruiting, Navy Recruiting Region, Staff Officer'),
('HB1','Recruiting, Navy Recruiting District, Commanding Officer'),
('HB2','Recruiting, Navy Recruiting District, Staff'),
('HB3','Recruiting, Navy Recruiting District, Officer Recruiter'),
('HC1','Recruiting, Navy Recruiting District, Executive Officer'),
('HD1','Recruiting, Recruiting Operations Officer, Qualified'),
('HE1','Recruiting, Assistant Recruiting Operations Officer, Qualified'),
('HF1','Recruiting, Officer in Charge, Navy Recruiting District Class "A" Station, Unspecified'),
('HG1','Recruiting, Navy Recruiting Command, General'),
('HG2','Recruiting, Recruiting Command, Headquarters Staff'),
('HG3','Recruiting, Navy Recruiting Command, General'),
('HH1','Recruiting, Navy Recruiting Area, Chief of Staff'),
('HI1','Recruiting, Officer Recruiter, Unspecified'),
('HTF','Recruiting, Training and Administration of Reserve Officer Recruiter, Field Officer Recruiter'),
('HTM','Recruiting, Training and Administration of Reserve Officer Recruiter, Management Officer Recruiter'),
('IL1','Logistic Support, Logistics, Maintenance'),
('IL2','Logistic Support, Logistics, Advanced'),
('IL3','Logistic Support, Logistics, Support'),
('IL4','Logistic Support, Logistics, Depot'),
('IL5','Logistic Support, Logistics, Major AIMD'),
('IL6','Logistic Support, Scholarship, Aviation Maintenance Officer'),
('J1C','Interservice Interagency Coalition, Joint Staff, Civil Affairs'),
('J1D','Interservice Interagency Coalition, Joint Staff, Detainee Operations'),
('J1F','Interservice Interagency Coalition, Joint Staff, Finance'),
('J1H','Interservice Interagency Coalition, Joint Staff, Human Resources'),
('J1I','Interservice Interagency Coalition, Joint Staff, Intelligence'),
('J1L','Interservice Interagency Coalition, Joint Staff, Logistics'),
('J1M','Interservice Interagency Coalition, Joint Staff, Medical'),
('J1O','Interservice Interagency Coalition, Joint Staff, Operations'),
('J1P','Interservice Interagency Coalition, Joint Staff, Planning'),
('J1T','Interservice Interagency Coalition, Joint Staff, Training'),
('J1X','Interservice Interagency Coalition, Joint Staff, Improvised Explosive Device'),
('J2C','Interservice Interagency Coalition, Multinational HQ, Civil Affairs'),
('J2D','Interservice Interagency Coalition, Multinational HQ, Detainee Operations'),
('J2F','Interservice Interagency Coalition, Multinational HQ, Finance'),
('J2H','Interservice Interagency Coalition, Multinational HQ, Human Resources'),
('J2I','Interservice Interagency Coalition, Multinational HQ, Intelligence'),
('J2L','Interservice Interagency Coalition, Multinational HQ, Logistics'),
('J2M','Interservice Interagency Coalition, Multinational HQ, Medical'),
('J2O','Interservice Interagency Coalition, Multinational HQ, Operations'),
('J2P','Interservice Interagency Coalition, Multinational HQ, Planning'),
('J2T','Interservice Interagency Coalition, Multinational HQ, Training'),
('J2X','Interservice Interagency Coalition, Multinational HQ, Improvised Explosive Device'),
('J3C','Interservice Interagency Coalition, Combatant Commander Level, Civil Affairs'),
('J3D','Interservice Interagency Coalition, Combatant Commander Level, Detainee Operations'),
('J3F','Interservice Interagency Coalition, Combatant Commander Level, Finance'),
('J3H','Interservice Interagency Coalition, Combatant Commander Level, Human Resources'),
('J3I','Interservice Interagency Coalition, Combatant Commander Level, Intelligence'),
('J3L','Interservice Interagency Coalition, Combatant Commander Level, Logistics'),
('J3M','Interservice Interagency Coalition, Combatant Commander Level, Medical'),
('J3O','Interservice Interagency Coalition, Combatant Commander Level, Operations'),
('J3P','Interservice Interagency Coalition, Combatant Commander Level, Planning'),
('J3T','Interservice Interagency Coalition, Combatant Commander Level, Training'),
('J3X','Interservice Interagency Coalition, Combatant Commander Level, Improvised Explosive Device'),
('J4C','Interservice Interagency Coalition, Fleet/Division Staff, Civil Affairs'),
('J4D','Interservice Interagency Coalition, Fleet/Division Staff, Detainee Operations'),
('J4F','Interservice Interagency Coalition, Fleet/Division Staff, Finance'),
('J4H','Interservice Interagency Coalition, Fleet/Division Staff, Human Resources'),
('J4I','Interservice Interagency Coalition, Fleet/Division Staff, Intelligence'),
('J4L','Interservice Interagency Coalition, Fleet/Division Staff, Logistics'),
('J4M','Interservice Interagency Coalition, Fleet/Division Staff, Medical'),
('J4O','Interservice Interagency Coalition, Fleet/Division Staff, Operations'),
('J4P','Interservice Interagency Coalition, Fleet/Division Staff, Planning'),
('J4T','Interservice Interagency Coalition, Fleet/Division Staff, Training'),
('J4X','Interservice Interagency Coalition, Fleet/Division Staff, Improvised Explosive Device'),
('J5C','Interservice Interagency Coalition, Joint Task Force, Civil Affairs'),
('J5D','Interservice Interagency Coalition, Joint Task Force, Detainee Operations'),
('J5F','Interservice Interagency Coalition, Joint Task Force, Finance'),
('J5H','Interservice Interagency Coalition, Joint Task Force, Human Resources'),
('J5I','Interservice Interagency Coalition, Joint Task Force, Intelligence'),
('J5L','Interservice Interagency Coalition, Joint Task Force, Logistics'),
('J5M','Interservice Interagency Coalition, Joint Task Force, Medical'),
('J5O','Interservice Interagency Coalition, Joint Task Force, Operations'),
('J5P','Interservice Interagency Coalition, Joint Task Force, Planning'),
('J5T','Interservice Interagency Coalition, Joint Task Force, Training'),
('J5X','Interservice Interagency Coalition, Joint Task Force, Improvised Explosive Device'),
('J6B','Joint Specialty, Other, AFPAK Hands'),
('J6C','Interservice Interagency Coalition, Other, Civil Affairs'),
('J6D','Interservice Interagency Coalition, Other, Detainee Operations'),
('J6F','Interservice Interagency Coalition, Other, Finance'),
('J6H','Interservice Interagency Coalition, Other, Human Resources'),
('J6I','Interservice Interagency Coalition, Other, Intelligence'),
('J6L','Interservice Interagency Coalition, Other, Logistics'),
('J6M','Interservice Interagency Coalition, Other, Medical'),
('J6O','Interservice Interagency Coalition, Other, Operations'),
('J6P','Interservice Interagency Coalition, Other, Planning'),
('J6T','Interservice Interagency Coalition, Other, Training'),
('J6X','Interservice Interagency Coalition, Other, Improvised Explosive Device'),
('JC1','Joint Specialty, Terminal Attack Controller, Qualified'),
('JC2','Joint Specialty, Terminal Attack Controller, Instructor'),
('JD1','Joint Specialty, Joint Billet, JDA Billet'),
('JD2','Joint Specialty, Joint Billet, JDA Critical Billet'),
('JJ1','Joint Specialty, Joint Operations Planning and Execution System (JOPES), JOPES Proficiency'),
('JOM','Joint Specialty, Operational Level Command and Control, Maritime'),
('JP1','Joint Specialty, Joint, Operational Planner'),
('JP2','Joint Specialty, Joint, Operational Planner'),
('JP3','Joint Specialty, Joint, Operational Planner'),
('JPN','Joint Specialty, Operational Planner'),
('JS1','Joint Specialty, JPME Graduate'),
('JS2','Joint Specialty, Full Joint Specialty Nominee'),
('JS3','Joint Specialty, JPME Joint Specialty Nominee'),
('JS4','Joint Specialty, Critical Occupational Specialist Joint Specialist Nominee'),
('JS5','Joint Specialty, Joint Specialist Officer (JSO)'),
('JS6','Joint Specialty, Joint Equivalent Assignment'),
('JS7','Joint Specialty, JPME Graduate Phase I'),
('JS8','Joint Specialty, JPME Graduate Phase II'),
('JS9','Joint Specialty, COS Takeout JSO'),
('JSF','Joint Specialty, Joint Duty Assignment (JDA) for Flag'),
('JSR','Joint Specialty, Joint Duty Assignment required after one tour deferral'),
('KA1','Surface Warfare, Qualified Surface Missile Systems Officer , TALOS'),
('KA2','Surface Warfare, Qualified Surface Missile Systems Officer , TERRIER NTDS'),
('KA4','Surface Warfare, Qualified Surface Missile Systems Officer , TARTAR JPTDS'),
('KA5','Surface Warfare, Qualified Surface Missile Systems Officer , TARTAR Non-JPTDS'),
('KA6','Surface Warfare, Qualified Surface Missile Systems Officer , AEGIS'),
('KD1','Surface Warfare, Surface Nuclear Power, Nuclear Propulsion Operator'),
('KD2','Surface Warfare, Surface Nuclear Power, Nuclear Ship Engineer'),
('KD3','Surface Warfare, Surface Nuclear Power, Nuclear Power (Enlisted)'),
('KD4','Surface Warfare, Surface Nuclear Power, LDO and WO Nuclear Power Operator'),
('KD5','Surface Warfare, Surface Nuclear Power, Nuclear RADCON'),
('KD6','Surface Warfare, Surface Nuclear Power, Trainee'),
('KD7','Surface Warfare, Surface Nuclear Power, Naval Reactors Qualified'),
('KD8','Surface Warfare, Surface Nuclear Power, Nuclear Qualifying Assignment Billet'),
('KD9','Surface Warfare, Surface Nuclear Power, NR Support Billet'),
('KG1','Surface Warfare, Explosive Ordnance Disposal, Basic'),
('KG2','Surface Warfare, Explosive Ordnance Disposal, Senior'),
('KG3','Surface Warfare, Explosive Ordnance Disposal, Master'),
('KG4','Surface Warfare, Explosive Ordnance Disposal, Ordnance Clearance Diver'),
('KG5','Surface Warfare, Explosive Ordnance Disposal, EOD Warfare'),
('KG6','Surface Warfare, Explosive Ordnance Disposal, Executive Officer'),
('KG7','Surface Warfare, Explosive Ordnance Disposal, CDR Command'),
('KH9','Surface Warfare, Qualified in Riverine Warfare, Unspecified'),
('KI1','Surface Warfare, Qualified in River, Coastal, and Combatant Craft Unconventional Warfare, Operational'),
('KJ1','Surface Warfare, Drydocking Officer, General'),
('KJ2','Surface Warfare, Drydocking Officer, Floating Drydock'),
('KK1','Surface Warfare, Expendable Ordnance Management, Basic'),
('KK2','Surface Warfare, Expendable Ordnance Management, Operational'),
('KK3','Surface Warfare, Expendable Ordnance Management, Master'),
('KL0','Surface Warfare, Qualified Diving Officer , Basic'),
('KM1','Surface Warfare, Ship Salvage Diving Officer, Basic'),
('KM2','Surface Warfare, Ship Salvage Diving Officer, Operational'),
('KN1','Surface Warfare, HeO2 Qualified Diving Officer, Basic'),
('KN2','Surface Warfare, HeO2 Qualified Diving Officer, Operational'),
('KP0','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Qualified'),
('KP1','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Basic'),
('KP2','Surface Warfare, Shore Based Hyperbaric Facility Saturation Dive Watch Officer, Operational'),
('KR1','Surface Warfare, Ship Salvage Operations Officer, Operational'),
('KS1','Surface Warfare, Surface Warfare Enterprise, SWE Officer'),
('KW2','Surface Warfare, Weapons Tactics Instructor (WTI), Integrated Air Missile Defense (IAMD)'),
('LA7','Surface Warfare, Qualified, MedicalDepartment'),
('LA8','Surface Warfare, Qualified, Supply Corps'),
('LA9','Surface Warfare, Qualified'),
('LB1','Surface Warfare, Qualified OOD, Independent Steaming'),
('LB2','Surface Warfare, Qualified OOD, Fleet Maneuvers Task Group/Force Operations'),
('LB3','Surface Warfare, Qualified OOD, CDO Underway'),
('LB4','Surface Warfare, Qualified OOD, Conning Officer Alongside'),
('LC1','Surface Warfare, Engineering, EOOW (Steam)'),
('LC2','Surface Warfare, Engineering, EOOW (Diesel)'),
('LC3','Surface Warfare, Engineering, EOOW (Gas Turbine)'),
('LC4','Surface Warfare, Engineering, EOOW (ACC) (Supersedes LC1)'),
('LD9','Surface Warfare, Weapons Control , Qualified'),
('LF6','Surface Warfare, Evaluator/Tactical Action Officer, Qualified in Non-NTDS equipped unit'),
('LF7','Surface Warfare, Evaluator/Tactical Action Officer, Qualified in NTDS equipped unit'),
('LK9','Surface Warfare, Executive Officer Afloat (LCDR and above) , Unspecified'),
('LN1','Surface Warfare, Command (Supersedes LM), LT Command'),
('LN2','Surface Warfare, Command (Supersedes LM), LCDR Command'),
('LN3','Surface Warfare, Command (Supersedes LM), CDR Command'),
('LN4','Surface Warfare, Command (Supersedes LM), CAPT Command'),
('LN7','Surface Warfare, Command, Qualified Surface Command Commander'),
('LN8','Surface Warfare, Command, Qualified Surface Command Captain'),
('LS1','Surface Warfare, Specialty Career Path, Missile Defense'),
('LS2','Surface Warfare, AT/FT'),
('LS3','Surface Warfare, Specialty Career Path, Anti-Submarine Warfare'),
('LS4','Surface Warfare, Specialty Career Path, Mine Warfare'),
('LS5','Surface Warfare, Specialty Career Path, Shore Installation Management'),
('LS6','Surface Warfare, Specialty Career Path, Strategic Sealift'),
('LT1','Surface Warfare, Tactical Digital Information Link (TDL) Officer, Qualified Interface Control Officer (ICO)'),
('LT2','Surface Warfare, Tactical Digital Information Link (TDL) Officer, Qualified Joint Interface Control Officer (JICO)'),
('MH1','Meteorology and Oceanography (METOC), Hydrographer, Naval Hydrographer'),
('MH2','Meteorology and Oceanography (METOC), Hydrographer, Apprentice Naval Hydrographer'),
('NA0','Financial Management, Accounting (Primary), No Masters level education, single experience tour'),
('NA1','Financial Management, Accounting (Primary), No Masters level education, multiple experience tours'),
('NA2','Financial Management, Accounting (Primary), Single SECNAV/OPNAV experience tour'),
('NA3','Financial Management, Accounting (Primary), Multiple SECNAV/OPNAV experience tours'),
('NA4','Financial Management, Accounting (Primary), Single JOINT tour'),
('NA5','Financial Management, Accounting (Primary), Multiple JOINT tours'),
('NA6','Financial Management, Accounting (Primary), SECNAV/OPNAV and JOINT tours'),
('NA7','Financial Management, Accounting (Primary), SECNAV/OPNAV and JOINT other tours'),
('NA8','Financial Management, Accounting (Primary), Fleet (any level) tour'),
('NA9','Financial Management, Accounting (Primary)'),
('NB0','Financial Management, Budget (Primary), No Masters level education, single experience tour'),
('NB1','Financial Management, Budget (Primary), No Masters level education, multiple experience tours'),
('NB2','Financial Management, Budget (Primary), Single SECNAV/OPNAV experience tour'),
('NB3','Financial Management, Budget (Primary), Multiple SECNAV/OPNAV experience tours'),
('NB4','Financial Management, Budget (Primary), Single JOINT tour'),
('NB5','Financial Management, Budget (Primary), Multiple JOINT tours'),
('NB6','Financial Management, Budget (Primary), SECNAV/OPNAV and JOINT tours'),
('NB7','Financial Management, Budget (Primary), SECNAV/OPNAV and JOINT other tours'),
('NB8','Financial Management, Budget (Primary), Fleet (any level) tour'),
('NB9','Financial Management, Budget (Primary), Fleet (any level) and JOINT (any) tours'),
('NC0','Financial Management, Comptroller (Primary), No Masters level education, single experience tour'),
('NC1','Financial Management, Comptroller (Primary), No Masters level education, multiple experience tours'),
('NC2','Financial Management, Comptroller (Primary), Single SECNAV/OPNAV experience tour'),
('NC3','Financial Management, Comptroller (Primary), Multiple SECNAV/OPNAV experience tours'),
('NC4','Financial Management, Comptroller (Primary), Single JOINT tour'),
('NC5','Financial Management, Comptroller (Primary), Multiple JOINT tours'),
('NC6','Financial Management, Comptroller (Primary), SECNAV/OPNAV and JOINT tours'),
('NC7','Financial Management, Comptroller (Primary), SECNAV/OPNAV and JOINT other tours'),
('NC8','Financial Management, Comptroller (Primary), Fleet (any level) tour'),
('NC9','Financial Management, Comptroller (Primary), Fleet (any level) and JOINT (any) tours'),
('ND0','Financial Management, Disbursing (Primary), No Masters level education, single experience tour'),
('ND1','Financial Management, Disbursing (Primary), No Masters level education, multiple experience tours'),
('ND2','Financial Management, Disbursing (Primary), Single SECNAV/OPNAV experience tour'),
('ND3','Financial Management, Disbursing (Primary), Multiple SECNAV/OPNAV experience tours'),
('ND4','Financial Management, Disbursing (Primary), Single JOINT tour'),
('ND5','Financial Management, Disbursing (Primary), Multiple JOINT tours'),
('ND6','Financial Management, Disbursing (Primary), SECNAV/OPNAV and JOINT tours'),
('ND7','Financial Management, Disbursing (Primary), SECNAV/OPNAV and JOINT other tours'),
('ND8','Financial Management, Disbursing (Primary), Fleet (any level) tour'),
('ND9','Financial Management, Disbursing (Primary), Fleet (any level) and JOINT (any) tours'),
('NE0','Financial Management, Internal Review (Primary), No Masters level education, single experience tour'),
('NE1','Financial Management, Internal Review (Primary), No Masters level education, multiple experience tours'),
('NE2','Financial Management, Internal Review (Primary), Single SECNAV/OPNAV experience tour'),
('NE3','Financial Management, Internal Review (Primary), Multiple SECNAV/OPNAV experience tours'),
('NE4','Financial Management, Internal Review (Primary), Single JOINT tour'),
('NE5','Financial Management, Internal Review (Primary), Multiple JOINT tours'),
('NE6','Financial Management, Internal Review (Primary), SECNAV/OPNAV and JOINT tours'),
('NE7','Financial Management, Internal Review (Primary), SECNAV/OPNAV and JOINT other tours'),
('NE8','Financial Management, Internal Review (Primary), Fleet (any level) tour'),
('NE9','Financial Management, Internal Review (Primary), Fleet (any level) and JOINT (any) tours'),
('NF0','Financial Management, Dual Accounting and Budget, No Masters level education, single experience tour'),
('NF1','Financial Management, Dual Accounting and Budget, No Masters level education, multiple experience tours'),
('NF2','Financial Management, Dual Accounting and Budget, Single SECNAV/OPNAV experience tour'),
('NF3','Financial Management, Dual Accounting and Budget, Multiple SECNAV/OPNAV experience tours'),
('NF4','Financial Management, Dual Accounting and Budget, Single JOINT tour'),
('NF5','Financial Management, Dual Accounting and Budget, Multiple JOINT tours'),
('NF6','Financial Management, Dual Accounting and Budget, SECNAV/OPNAV and JOINT tours'),
('NF7','Financial Management, Dual Accounting and Budget, SECNAV/OPNAV and JOINT other tours'),
('NF8','Financial Management, Dual Accounting and Budget, Fleet (any level) tour'),
('NF9','Financial Management, Dual Accounting and Budget, Fleet (any level) and JOINT (any) tours'),
('NG0','Financial Management, Dual Accounting and Comptroller, No Masters level education, single experience tour'),
('NG1','Financial Management, Dual Accounting and Comptroller, No Masters level education, multiple experience tours'),
('NG2','Financial Management, Dual Accounting and Comptroller, Single SECNAV/OPNAV experience tour'),
('NG3','Financial Management, Dual Accounting and Comptroller, Multiple SECNAV/OPNAV experience tours'),
('NG4','Financial Management, Dual Accounting and Comptroller, Single JOINT tour'),
('NG5','Financial Management, Dual Accounting and Comptroller, Multiple JOINT tours'),
('NG6','Financial Management, Dual Accounting and Comptroller, SECNAV/OPNAV and JOINT tours'),
('NG7','Financial Management, Dual Accounting and Comptroller, SECNAV/OPNAV and JOINT other tours'),
('NG8','Financial Management, Dual Accounting and Comptroller, Fleet (any level) tour'),
('NG9','Financial Management, Dual Accounting and Comptroller, Fleet (any level) and JOINT (any) tours'),
('NH0','Financial Management, Dual Accounting and Disbursing, No Masters level education, single experience tour'),
('NH1','Financial Management, Dual Accounting and Disbursing, No Masters level education, multiple experience tours'),
('NH2','Financial Management, Dual Accounting and Disbursing, Single SECNAV/OPNAV experience tour'),
('NH3','Financial Management, Dual Accounting and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NH4','Financial Management, Dual Accounting and Disbursing, Single JOINT tour'),
('NH5','Financial Management, Dual Accounting and Disbursing, Multiple JOINT tours'),
('NH6','Financial Management, Dual Accounting and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NH7','Financial Management, Dual Accounting and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NH8','Financial Management, Dual Accounting and Disbursing, Fleet (any level) tour'),
('NH9','Financial Management, Dual Accounting and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NI0','Financial Management, Dual Accounting and Internal Review, No Masters level education, single experience tour'),
('NI1','Financial Management, Dual Accounting and Internal Review, No Masters level education, multiple experience tours'),
('NI2','Financial Management, Dual Accounting and Internal Review, Single SECNAV/OPNAV experience tour'),
('NI3','Financial Management, Dual Accounting and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NI4','Financial Management, Dual Accounting and Internal Review, Single JOINT tour'),
('NI5','Financial Management, Dual Accounting and Internal Review, Multiple JOINT tours'),
('NI6','Financial Management, Dual Accounting and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NI7','Financial Management, Dual Accounting and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NI8','Financial Management, Dual Accounting and Internal Review, Fleet (any level) tour'),
('NI9','Financial Management, Dual Accounting and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NJ0','Financial Management, Dual Budget and Comptroller, No Masters level education, single experience tour'),
('NJ1','Financial Management, Dual Budget and Comptroller, No Masters level education, multiple experience tours'),
('NJ2','Financial Management, Dual Budget and Comptroller, Single SECNAV/OPNAV experience tour'),
('NJ3','Financial Management, Dual Budget and Comptroller, Multiple SECNAV/OPNAV experience tours'),
('NJ4','Financial Management, Dual Budget and Comptroller, Single JOINT tour'),
('NJ5','Financial Management, Dual Budget and Comptroller, Multiple JOINT tours'),
('NJ6','Financial Management, Dual Budget and Comptroller, SECNAV/OPNAV and JOINT tours'),
('NJ7','Financial Management, Dual Budget and Comptroller, SECNAV/OPNAV and JOINT other tours'),
('NJ8','Financial Management, Dual Budget and Comptroller, Fleet (any level) tour'),
('NJ9','Financial Management, Dual Budget and Comptroller, Fleet (any level) and JOINT (any) tours'),
('NK0','Financial Management, Dual Budget and Disbursing, No Masters level education, single experience tour'),
('NK1','Financial Management, Dual Budget and Disbursing, No Masters level education, multiple experience tours'),
('NK2','Financial Management, Dual Budget and Disbursing, Single SECNAV/OPNAV experience tour'),
('NK3','Financial Management, Dual Budget and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NK4','Financial Management, Dual Budget and Disbursing, Single JOINT tour'),
('NK5','Financial Management, Dual Budget and Disbursing, Multiple JOINT tours'),
('NK6','Financial Management, Dual Budget and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NK7','Financial Management, Dual Budget and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NK8','Financial Management, Dual Budget and Disbursing, Fleet (any level) tour'),
('NK9','Financial Management, Dual Budget and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NL0','Financial Management, Dual Budget and Internal Review, No Masters level education, single experience tour'),
('NL1','Financial Management, Dual Budget and Internal Review, No Masters level education, multiple experience tours'),
('NL2','Financial Management, Dual Budget and Internal Review, Single SECNAV/OPNAV experience tour'),
('NL3','Financial Management, Dual Budget and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NL4','Financial Management, Dual Budget and Internal Review, Single JOINT tour'),
('NL5','Financial Management, Dual Budget and Internal Review, Multiple JOINT tours'),
('NL6','Financial Management, Dual Budget and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NL7','Financial Management, Dual Budget and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NL8','Financial Management, Dual Budget and Internal Review, Fleet (any level) tour'),
('NL9','Financial Management, Dual Budget and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NM0','Financial Management, Dual Comptroller and Disbursing, No Masters level education, single experience tour'),
('NM1','Financial Management, Dual Comptroller and Disbursing, No Masters level education, multiple experience tours'),
('NM2','Financial Management, Dual Comptroller and Disbursing, Single SECNAV/OPNAV experience tour'),
('NM3','Financial Management, Dual Comptroller and Disbursing, Multiple SECNAV/OPNAV experience tours'),
('NM4','Financial Management, Dual Comptroller and Disbursing, Single JOINT tour'),
('NM5','Financial Management, Dual Comptroller and Disbursing, Multiple JOINT tours'),
('NM6','Financial Management, Dual Comptroller and Disbursing, SECNAV/OPNAV and JOINT tours'),
('NM7','Financial Management, Dual Comptroller and Disbursing, SECNAV/OPNAV and JOINT other tours'),
('NM8','Financial Management, Dual Comptroller and Disbursing, Fleet (any level) tour'),
('NM9','Financial Management, Dual Comptroller and Disbursing, Fleet (any level) and JOINT (any) tours'),
('NN0','Financial Management, Dual Comptroller and Internal Review, No Masters level education, single experience tour'),
('NN1','Financial Management, Dual Comptroller and Internal Review, No Masters level education, multiple experience tours'),
('NN2','Financial Management, Dual Comptroller and Internal Review, Single SECNAV/OPNAV experience tour'),
('NN3','Financial Management, Dual Comptroller and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NN4','Financial Management, Dual Comptroller and Internal Review, Single JOINT tour'),
('NN5','Financial Management, Dual Comptroller and Internal Review, Multiple JOINT tours'),
('NN6','Financial Management, Dual Comptroller and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NN7','Financial Management, Dual Comptroller and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NN8','Financial Management, Dual Comptroller and Internal Review, Fleet (any level) tour'),
('NN9','Financial Management, Dual Comptroller and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NO0','Financial Management, Dual Disbursing and Internal Review, No Masters level education, single experience tour'),
('NO1','Financial Management, Dual Disbursing and Internal Review, No Masters level education, multiple experience tours'),
('NO2','Financial Management, Dual Disbursing and Internal Review, Single SECNAV/OPNAV experience tour'),
('NO3','Financial Management, Dual Disbursing and Internal Review, Multiple SECNAV/OPNAV experience tours'),
('NO4','Financial Management, Dual Disbursing and Internal Review, Single JOINT tour'),
('NO5','Financial Management, Dual Disbursing and Internal Review, Multiple JOINT tours'),
('NO6','Financial Management, Dual Disbursing and Internal Review, SECNAV/OPNAV and JOINT tours'),
('NO7','Financial Management, Dual Disbursing and Internal Review, SECNAV/OPNAV and JOINT other tours'),
('NO8','Financial Management, Dual Disbursing and Internal Review, Fleet (any level) tour'),
('NO9','Financial Management, Dual Disbursing and Internal Review, Fleet (any level) and JOINT (any) tours'),
('NP0','Financial Management, Appropriation Legislative Liaison, No Masters level education, single experience tour'),
('NP1','Financial Management, Appropriation Legislative Liaison, No Masters level education, multiple experience tours'),
('NP2','Financial Management, Appropriation Legislative Liaison, Single SECNAV/OPNAV experience tour'),
('NP3','Financial Management, Appropriation Legislative Liaison, Multiple SECNAV/OPNAV experience tours'),
('NP4','Financial Management, Appropriation Legislative Liaison, Single JOINT tour'),
('NP5','Financial Management, Appropriation Legislative Liaison, Multiple JOINT tours'),
('NP6','Financial Management, Appropriation Legislative Liaison, SECNAV/OPNAV and JOINT tours'),
('NP7','Financial Management, Appropriation Legislative Liaison, SECNAV/OPNAV and JOINT other tours'),
('NP8','Financial Management, Appropriation Legislative Liaison, Fleet (any level) tour'),
('NP9','Financial Management, Appropriation Legislative Liaison, Fleet (any level) and JOINT (any) tours'),
('NQ0','Financial Management, Any combination of 3 primary qualifications, No Masters level education, single experience tour'),
('NQ1','Financial Management, Any combination of 3 primary qualifications, No Masters level education, multiple experience tours'),
('NQ2','Financial Management, Any combination of 3 primary qualifications, Single SECNAV/OPNAV experience tour'),
('NQ3','Financial Management, Any combination of 3 primary qualifications, Multiple SECNAV/OPNAV experience tours'),
('NQ4','Financial Management, Any combination of 3 primary qualifications, Single JOINT tour'),
('NQ5','Financial Management, Any combination of 3 primary qualifications, Multiple JOINT tours'),
('NQ6','Financial Management, Any combination of 3 primary qualifications, SECNAV/OPNAV and JOINT tours'),
('NQ7','Financial Management, Any combination of 3 primary qualifications, SECNAV/OPNAV and JOINT other tours'),
('NQ8','Financial Management, Any combination of 3 primary qualifications, Fleet (any level) tour'),
('NQ9','Financial Management, Any combination of 3 primary qualifications, Fleet (any level) and JOINT (any) tours'),
('NR1','Financial Management, CDFM'),
('NR2','Financial Management, CDFM-A'),
('PA1','Navy Security Force Officer, Basic'),
('PA2','Law Enforcement and Security, Staff and Advanced'),
('PC1','Navy Security Force, Force Protection/Antiterrorism Officer, Base or Activity'),
('PC2','Navy Security Force, Force Protection/Antiterrorism Officer, Staff'),
('PE1','Navy Security Force, Security Training Assistance and Assessments Team, Staff or Activity'),
('QB1','Special Warfare, UDT Qualified, Fleet experienced (2 or more deployments)'),
('QB9','Special Warfare, UDT Qualified, Unspecified'),
('QC1','Special Warfare, SEAL Qualified, Fleet Experienced'),
('QC9','Special Warfare, SEAL Qualified, Unspecified'),
('QD1','Special Warfare, Qualified as Platoon Commander/Major Department Head of a UDT/SEAL/SBU/SDV Team, Fleet experienced'),
('QD9','Special Warfare, Qualified as Platoon Commander/Major Department Head of a UDT/SEAL/SBU/SDV Team, Unspecified'),
('QE1','Special Warfare, Qualified for Executive Officer of UDT/SEAL/SBU/SDV Team (Supersedes QC) , Fleet experienced'),
('QF1','Special Warfare, Qualified for Commanding Officer of UDT/SEAL/SBU/SDV Team (Supersedes QD), Fleet experienced'),
('QG1','Special Warfare, Qualified for command of SPECWARGRU (Supersedes QE), Fleet experienced'),
('QI1','Special Warfare, SDV Qualified , Fleet experienced (2 or more deployments)'),
('QI9','Special Warfare, SDV Qualified , Qualified'),
('QJ1','Special Warfare, DDS Qualified, Fleet Experienced'),
('QK1','Special Warfare, Qualified as Non-SEAL/SWCC Officer Special Warfare Experience, Fleet Experienced'),
('QK2','Special Warfare, Qualified as NSW Non-SEAL/SWCC Officer, Naval Special Warfare Experience'),
('QK3','Special Warfare, Qualified as NSW Non-SEAL/SWCC Officer, Naval Special Warfare Experience'),
('RA1','Human Resources, Human Resource Officer, Professional in Human Resources (PHR) Certified'),
('RA2','Human Resources, Human Resource Officer, Senior Professional in Human Resources (SPHR) Certified'),
('RA3','Human Resources, Human Resource Officer, Global Professional in Human Resources (GPHR) Certified'),
('RA4','Human Resources, Human Resource Officer, Certified Performance Technologist (CPT)'),
('SC1','Submarine Warfare, Command, Qualified for diesel command'),
('SC2','Submarine Warfare, Command, Qualified for nuclear command'),
('SC3','Submarine Warfare, Command, Served SS command'),
('SC4','Submarine Warfare, Command, Served SSN command'),
('SC5','Submarine Warfare, Command, Served SSBN command'),
('SC6','Submarine Warfare, Command, Served post SSN/SSBN command tour'),
('SC7','Submarine Warfare, Command, Served ASR command'),
('SD0','Submarine Warfare, Submarine Officer, Assistant Weapons Officer (SSBN)'),
('SD1','Submarine Warfare, Submarine Officer, SSBN SWS Officer'),
('SD2','Submarine Warfare, Submarine Officer, Weapons DH Qual'),
('SD3','Submarine Warfare, Submarine Officer, Served Polaris Weps'),
('SD4','Submarine Warfare, Submarine Officer, Served Poseidon Weps'),
('SD5','Submarine Warfare, Submarine Officer, Served Trident Weps'),
('SD6','Submarine Warfare, Submarine Officer, Served post SSBN Weps'),
('SD7','Submarine Warfare, SCUBA Trained Officer, Qualified'),
('SE1','Submarine Warfare, Submarine Officer, Served Polaris Navigator'),
('SE2','Submarine Warfare, Submarine Officer, Served Poseidon Navigator'),
('SE3','Submarine Warfare, Submarine Officer, Served Trident Navigator'),
('SE4','Submarine Warfare, Submarine Officer, Served post SSBN Navigator'),
('SN0','Submarine Warfare, Nuclear Trained Officer, General'),
('SN1','Submarine Warfare, Nuclear Trained Officer, Engineer Qualified'),
('SN2','Submarine Warfare, Nuclear Trained Officer, Served Engineer'),
('SN3','Submarine Warfare, Nuclear Trained Officer, Served post Engineer'),
('SN9','Submarine Warfare, Nuclear Trained Officer, NR Support Billet'),
('SP1','Submarine Warfare, Nuclear Weapons, Nuclear Command and Control (NC2)'),
('SP2','Submarine Warfare, Nuclear Weapons, SSBN AWEPS'),
('SP6','Submarine Warfare, Nuclear Weapons, Nuclear Weapons Junior Technical Supervisor'),
('SP7','Submarine Warfare, Nuclear Weapons, Nuclear Weapons Senior Technical Supervisor'),
('SP8','Submarine Warfare, Nuclear Weapons, General Strategic Policy'),
('SPA','Submarine Warfare, Nuclear Weapons, Any Strategic Weapons Experience'),
('SQ1','Submarine Warfare, Submarine Qualified SC Officer, Supply Corps'),
('SR1','Submarine Warfare, Submarine Rescue, Submarine Rescue Officer'),
('SS1','Submarine Warfare, DSV, Operator'),
('SU0','Submarine Warfare, Submarine Qualified ED Officer, General'),
('SV1','Submarine Warfare, Enlisted Submarine Qualified, General'),
('SW1','Submarine Warfare, Deep Submergence, Staff'),
('SW2','Submarine Warfare, Deep Submergence, Operational'),
('SW3','Submarine Warfare, Deep Submergence, Ocean Engineering'),
('TD1','Merchant Marine, Deck Officer, Chief Mate'),
('TD2','Merchant Marine, Deck Officer, Second Mate'),
('TD3','Merchant Marine, Deck Officer, Third Mate'),
('TDL','Merchant Marine, Deck Officer, Master, Limited'),
('TDM','Merchant Marine, Deck Officer, Master'),
('TE1','Merchant Marine, Engineer Officer, Steam, First Assistant Engineer'),
('TE2','Merchant Marine, Engineer Officer, Steam, Second Assistant Engineer'),
('TE3','Merchant Marine, Engineer Officer, Steam, Third Assistant Engineer'),
('TEE','Merchant Marine, Engineer Officer, Steam, Chief Engineer'),
('TEL','Merchant Marine, Engineer Officer, Steam, Chief Engineer Limited'),
('TF1','Merchant Marine, Engineer Officer, Steam, First Assistant Engineer'),
('TF2','Merchant Marine, Engineer Officer, Steam, Second Assistant Engineer'),
('TF3','Merchant Marine, Engineer Officer, Steam, Third Assostant Engineer'),
('TFE','Merchant Marine, Engineer Officer, Steam, Chief Engineer'),
('TFL','Merchant Marine, Engineer Officer, Steam, Chief Engineer, limited'),
('U1C','Intra Service, Joint Staff, Civil Affairs'),
('U1D','Intra Service, Joint Staff, Detainee Operations'),
('U1F','Intra Service, Joint Staff, Finance'),
('U1H','Intra Service, Joint Staff, Human Resources'),
('U1I','Intra Service, Joint Staff, Intelligence'),
('U1L','Intra Service, Joint Staff, Logistics'),
('U1M','Intra Service, Joint Staff, Medical'),
('U1O','Intra Service, Joint Staff, Operations'),
('U1P','Intra Service, Joint Staff, Planning'),
('U1T','Intra Service, Joint Staff, Training'),
('U1X','Intra Service, Joint Staff, Improvised Explosive Device'),
('U2C','Intra Service, Multinational HQ, Civil Affairs'),
('U2D','Intra Service, Multinational HQ, Detainee Operations'),
('U2F','Intra Service, Multinational HQ, Finance'),
('U2H','Intra Service, Multinational HQ, Human Resources'),
('U2I','Intra Service, Multinational HQ, Intelligence'),
('U2L','Intra Service, Multinational HQ, Logistics'),
('U2M','Intra Service, Multinational HQ, Medical'),
('U2O','Intra Service, Multinational HQ, Operations'),
('U2P','Intra Service, Multinational HQ, Planning'),
('U2T','Intra Service, Multinational HQ, Training'),
('U2X','Intra Service, Multinational HQ, Improvised Explosive Device'),
('U3C','Intra Service, Combatant Commander Level, Civil Affairs'),
('U3D','Intra Service, Combatant Commander Level, Detainee Operations'),
('U3F','Intra Service, Combatant Commander Level, Finance'),
('U3H','Intra Service, Combatant Commander Level, Human Resources'),
('U3I','Intra Service, Combatant Commander Level, Intelligence'),
('U3L','Intra Service, Combatant Commander Level, Logistics'),
('U3M','Intra Service, Combatant Commander Level, Medical'),
('U3O','Intra Service, Combatant Commander Level, Operations'),
('U3P','Intra Service, Combatant Commander Level, Planning'),
('U3T','Intra Service, Combatant Commander Level, Training'),
('U3X','Intra Service, Combatant Commander Level, Improvised Explosive Device'),
('U4C','Intra Service, Fleet/Division Staff, Civil Affairs'),
('U4D','Intra Service, Fleet/Division Staff, Detainee Operations'),
('U4F','Intra Service, Fleet/Division Staff, Finance'),
('U4H','Intra Service, Fleet/Division Staff, Human Resources'),
('U4I','Intra Service, Fleet/Division Staff, Intelligence'),
('U4L','Intra Service, Fleet/Division Staff, Logistics'),
('U4M','Intra Service, Fleet/Division Staff, Medical'),
('U4O','Intra Service, Fleet/Division Staff, Operations'),
('U4P','Intra Service, Fleet/Division Staff, Planning'),
('U4T','Intra Service, Fleet/Division Staff, Training'),
('U4X','Intra Service, Fleet/Division Staff, Improvised Explosive Device'),
('U5C','Intra Service, Joint Task Force, Civil Affairs'),
('U5D','Intra Service, Joint Task Force, Detainee Operations'),
('U5F','Intra Service, Joint Task Force, Finance'),
('U5H','Intra Service, Joint Task Force, Human Resources'),
('U5I','Intra Service, Joint Task Force, Intelligence'),
('U5L','Intra Service, Joint Task Force, Logistics'),
('U5M','Intra Service, Joint Task Force, Medical'),
('U5O','Intra Service, Joint Task Force, Operations'),
('U5P','Intra Service, Joint Task Force, Planning'),
('U5T','Intra Service, Joint Task Force, Training'),
('U5X','Intra Service, Joint Task Force, Improvised Explosive Device'),
('U6C','Intra Service, Other, Civil Affairs'),
('U6D','Intra Service, Other, Detainee Operations'),
('U6F','Intra Service, Other, Finance'),
('U6H','Intra Service, Other, Human Resources'),
('U6I','Intra Service, Other, Intelligence'),
('U6L','Intra Service, Other, Logistics'),
('U6M','Intra Service, Other, Medical'),
('U6O','Intra Service, Other, Operations'),
('U6P','Intra Service, Other, Planning'),
('U6T','Intra Service, Other, Training'),
('U6U','Intra Service Specialty, Other, Military Observer, United Nations Peacekeeping Operations'),
('U6X','Intra Service, Other, Improvised Explosive Device'),
('U7S','Intra Service Specialty, NATO, Staff Officer'),
('VA1','Space and Electronic Warfare (SEW), Division Officer, Ensign'),
('VA2','Space and Electronic Warfare (SEW), Division Officer, Lieutenant Junior Grade'),
('VA3','Space and Electronic Warfare (SEW), Division Officer, Lieutenant'),
('VA4','Space and Electronic Warfare (SEW), Division Officer, Lieutenant Commander'),
('VA5','Space and Electronic Warfare (SEW), Division Officer, Commander'),
('VA6','Space and Electronic Warfare (SEW), Division Officer, Captain'),
('VB1','Space and Electronic Warfare (SEW), Department Head, Ensign'),
('VB2','Space and Electronic Warfare (SEW), Department Head, Lieutenant Junior Grade'),
('VB3','Space and Electronic Warfare (SEW), Department Head, Lieutenant'),
('VB4','Space and Electronic Warfare (SEW), Department Head, Lieutenant Commander'),
('VB5','Space and Electronic Warfare (SEW), Department Head, Commander'),
('VB6','Space and Electronic Warfare (SEW), Department Head, Captain'),
('VC1','Space and Electronic Warfare (SEW), Executive Officer, Ensign'),
('VC2','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant Junior Grade'),
('VC3','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant'),
('VC4','Space and Electronic Warfare (SEW), Executive Officer, Lieutenant Commander'),
('VC5','Space and Electronic Warfare (SEW), Executive Officer, Commander'),
('VC6','Space and Electronic Warfare (SEW), Executive Officer, Captain'),
('VE1','Space and Electronic Warfare (SEW), Commanding Officer, Ensign'),
('VE2','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant Junior Grade'),
('VE3','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant'),
('VE4','Space and Electronic Warfare (SEW), Commanding Officer, Lieutenant Commander'),
('VE5','Space and Electronic Warfare (SEW), Commanding Officer, Commander'),
('VE6','Space and Electronic Warfare (SEW), Commanding Officer, Captain'),
('VF1','Space and Electronic Warfare (SEW), Major Command, Ensign'),
('VF2','Space and Electronic Warfare (SEW), Major Command, Lieutenant Junior Grade'),
('VF3','Space and Electronic Warfare (SEW), Major Command, Lieutenant'),
('VF4','Space and Electronic Warfare (SEW), Major Command, Lieutenant Commander'),
('VF5','Space and Electronic Warfare (SEW), Major Command, Commander'),
('VF6','Space and Electronic Warfare (SEW), Major Command, Captain'),
('VQ1','Space and Electronic Warfare (SEW), SEW Critical, Ensign'),
('VQ2','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant Junior Grade'),
('VQ3','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant'),
('VQ4','Space and Electronic Warfare (SEW), SEW Critical, Lieutenant Commander'),
('VQ5','Space and Electronic Warfare (SEW), SEW Critical, Commander'),
('VQ6','Space and Electronic Warfare (SEW), SEW Critical, Captain'),
('VR1','Space and Electronic Warfare (SEW), Space Acquisition, Level 1'),
('VR2','Space and Electronic Warfare (SEW), Space Acquisition, Level 2'),
('VR3','Space and Electronic Warfare (SEW), Space Acquisition, Level 3'),
('VS1','Space and Electronic Warfare (SEW), Space Cadr1, Recruit'),
('VS2','Space and Electronic Warfare (SEW), Space Cadr2, Apprentice'),
('VS3','Space and Electronic Warfare (SEW), Space Cadr3, Journeyman'),
('VS5','Space and Electronic Warfare (SEW), Space Cadre, Basic'),
('VS6','Space and Electronic Warfare (SEW), Space Cadre, Level 1'),
('VS7','Space and Electronic Warfare (SEW), Space Cadre, Level 2'),
('VS8','Space and Electronic Warfare (SEW), Space Cadre, Level 3'),
('VV5','Space and Electronic Warfare (SEW), SIWC2 Critical, Major Command/Senior Staff'),
('VX1','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Basic'),
('VX2','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Operations'),
('VX3','Space and Electronic Warfare (SEW), Naval C4, Naval C4 Technical Expert'),
('VX4','Space and Electronic Warfare (SEW), Naval C4, Qualified Operational Commander (Captain and Commander billet only)'),
('A','Development Craftsman'),
('C','Flying Crew Chief'),
('D','Enlisted Force Development'),
('E','Electronic Warfare (EW) Support Duty'),
('G','Automated Systems Programming Craftsman'),
('I','Reserved'),
('J','Parachutist'),
('K','Aircrew Instructor'),
('N','Network Systems Administration'),
('Q','Aircrew Standardization/Flight Examiner'),
('R','Contingency/War Planner'),
('T','Formal Training Instructor'),
('U','Information Operations'),
('V','Automated Functional Applications Analyst/Monitor'),
('X','Aircrew'),
('A','Operational Warfare Instructor'),
('B','Squadron Operations/Operations Support Officer'),
('C','Commander'),
('D','Advanced Logistics Officer Course Graduates'),
('E','Electronic Warfare (EW) Support Duty'),
('F','Aircraft Systems Flight Evaluation'),
('G','Automated Systems Program Designer'),
('H','Military Consultant to the Surgeon General'),
('I','Reserved'),
('J','Parachutist'),
('K','Instructor'),
('L','Aircrew Flight Equipment'),
('M','Medical Service Specialist'),
('N','Combat Systems Officer(CSO)/Air Battle Manager (ABM) Required'),
('O','Support Squadron Operations Officer'),
('P','Pilot Required'),
('Q','Standardization and Evaluation'),
('R','Contingency/War Planner'),
('S','Safety'),
('T','Formal Training Instructor'),
('U','Information Operations'),
('V','Automated Functional Applications Analyst'),
('W','Weapons and Tactics Instructor'),
('X','Nonrated Officer Aircrew Duty'),
('Y','Analytical Studies Officer'),
('Z','Cyberspace Engineering')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 6...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('001','Arms Control'),
('002','National Intelligence University (NIU)'),
('003','Victims Advocate'),
('004','Orderly Room/Unit Administration'),
('005','AFSO21 Level I Certification'),
('006','AFSO21 Level II Certification'),
('007','AFSO21 Level III Certification'),
('008','Small Unmanned Aircraft Systems (SUAS) Operator'),
('009','Wholesale Logistics Experience'),
('011','Modeling and Simulation (M&S)'),
('012','Weapons of Mass Destruction Civil Support Team (WMD-CST) Member'),
('013','Data Formatting Equipment Operator'),
('014','AFOSI Technical Services'),
('015','Special Technical Operations'),
('020','Joint Special Operations Experience'),
('021','Joint Special Operations Task Force Experience'),
('023','AN/TRC-170 Digital Troposcatter Radio'),
('024','AN/TYC-39 and/or AN/TTC-39A'),
('025','Circuit Card Repair (CCR) Maintenance Technician'),
('026','Deployable Power Generation and Dis-tribution System (DPGDS)'),
('027','Remote Processing Systems'),
('028','Mobil Pumping System Maintenance and Repair (MPSMR)'),
('030','KN-S4100 Digital Telephone Switching System'),
('031','Crime Prevention/ Resources Protection'),
('032','Budget Experience'),
('033','Digital Telephone Switching Systems, Digital Multiplex Switch 100/200 and Meridian Stored Logic 100/200'),
('035','Forward Area Refueling Point (FARP)'),
('036','Cryogenics Maintainer'),
('037','Cryogenic Fluid Production'),
('039','Base Laboratory Technician'),
('040','Bulk Petroleum Accountant'),
('041','Fuels Operational Readiness Capability Equipment (FORCE) Operator'),
('042','Special Planner'),
('044','Local Registration Authority (LRA)'),
('045','Tactical Air Control System Direct Air Support Center/Air Support Operations Center (TACS DASC/ASOC)'),
('046','Tactical Air Control System Airborne Battlefield Command and Control Center (TACS)'),
('047','Ranger'),
('048','Joint Operations Planning and Execution System Auto-mated Data Processing (JOPES ADP) End User'),
('049','Joint Operation Planning and Execution (JOPES) Automated Data Processing (ADP) Technician'),
('050','Contingency Operation/Mobility Planning and Execution System (COMPES) Technician'),
('051','Worldwide Military Command and Control System (WWMCCS) Intercomputer Network (WIN) Operator'),
('052','Theater Battle Management (TBM) Core Systems'),
('053','Ground Control Approach'),
('054','Ground Control Approach Watch Supervisor/ Senior Controller'),
('055','Control Tower Watch Supervisor/Senior Controller'),
('056','Control Tower'),
('058','Atmospheric Research Equipment'),
('061','HQ/MAJCOM Time Phase Force Deployment Data (TPFDD) Analyst'),
('062','Deliberate and Crisis Action Planning Execution Segments Automated Data Processing (DCAPES ADP) Analyst'),
('064','Combat Crew Training'),
('065','Central Flight Instructor Course Instructor'),
('066','Chief Host Aviation Resource Manager (CHARM)'),
('067','Ground Reconnaissance Specialist'),
('068','Civil Operations Specialist'),
('069','Criminal Analysis Specialist'),
('070','Fleet Management'),
('071','General Purpose Vehicle and Equipment Maintenance'),
('072','Special Purpose Vehicle and Equipment Maintenance'),
('073','KC-135 Boom Operator'),
('074','EC/KC-135 Boom Operator'),
('075','Alert Facility Manager'),
('076','Upgrade Manager'),
('077','Aircrew Flight Equipment (AFE) Guardian Angel/Special Tactics Support Specialist'),
('078','Aircrew Flight Equipment (AFE) Heavy Aircraft Specialist'),
('079','Aircrew Flight Equipment (AFE) ACES II Ejection Seat Equipment Specialist'),
('081','Air Force Office of Special Investigations (AFOSI) Detachment/Squadron Superintendent'),
('084','Aircraft Flight Test'),
('085','Qualified Postal Amn'),
('086','Qualified Postal NCO'),
('087','Qualified Postal SNCO'),
('088','Career Postal Amn'),
('089','CORONET SPARK'),
('090','Contingency Response Forces (CRF)'),
('091','Air Force Office of Special Investigations (AFOSI) Forensic Science Technician (FST)'),
('092','Air Force Office of Special Investigations (AFOSI) Central Systems Fraud Examiner (CSFE)'),
('093','Air Force Office of Special Investigations (AFOSI) Technical Surveillance Operations Agent (TSO)'),
('094','Air Force Office of Special Investigations (AFOSI) Technical Surveillance Counter-Measures Agent (TSCM)'),
('095','Operational Test and Evaluation (OT & E)'),
('096','FM Certification Level 1'),
('097','FM Certification Level 2'),
('098','FM Certification Level 3'),
('099','Deployed Aircraft Ground Response Element (DAGRE)'),
('101','Recruiter, Tier 1'),
('102','Recruiter, Tier 2'),
('103','Recruiter, Tier 3'),
('105','American Forces Network Leadership Experience'),
('106','LEAP (Language Enabled Airmen Program) Qual'),
('107','Master Resilience Trainer'),
('108','FM Certification Level 1 and ACQ Bus FM Level II'),
('109','FM Certification Level 1 and ACQ Bus FM Level III'),
('110','Still Photographer'),
('111','Journalist'),
('112','FM Certification Level 1 and ACQ Audit Level I'),
('113','FM Certification Level 1 and ACQ Audit Level II'),
('114','FM Certification Level 1 and ACQ Audit Level III'),
('115','FM Certification Level 2 and ACQ Audit Level I'),
('116','FM Certification Level 2 and ACQ Audit Level II'),
('117','FM Certification Level 2 and ACQ Audit Level III'),
('118','FM Certification Level 3 and ACQ Audit Level I'),
('119','FM Certification Level 3 and ACQ Audit Level II'),
('120','FM Certification Level 3 and ACQ Audit Level III'),
('121','FM Certification Level 1 and ACQ Bus FM Level I'),
('122','Aircrew Flight Equipment (AFE) Life Sciences Equipment Investigation'),
('123','Aircrew Flight Equipment (AFE) Aircrew Instruct'),
('124','Aircrew Flight Equipment (AFE) Deployed Leadership Course'),
('125','Aircrew Flight Equipment (AFE) Program Manager'),
('126','Acquisition Logistics, Level I'),
('127','Acquisition Logistics, Level II'),
('128','Acquisition Logistics Level III'),
('129','Contracting, Level I'),
('130','Contracting, Level II'),
('131','Contracting, Level III'),
('132','Communications-Computer Systems, Level I'),
('133','Communications-Computer Systems, Level II'),
('134','Communications-Computer Systems, Level III'),
('135','FM Certification Level 2 and ACQ Bus FM Level I'),
('136','FM Certification Level 2 and ACQ Bus FM Level II'),
('137','FM Certification Level 2 and ACQ Bus FM Level III'),
('138','FM Certification Level 3 and ACQ Bus FM Level I'),
('139','FM Certification Level 3 and ACQ Bus FM Level II'),
('140','FM Certification Level 3 and ACQ Bus FM Level III'),
('141','FM Certification Level 1 and ACQ Bus Cost Estimating Level I'),
('142','FM Certification Level 1 and ACQ Bus Cost Estimating Level II'),
('143','FM Certification Level 1 and ACQ Bus Cost Estimating Level III'),
('144','FM Certification Level 2 and ACQ Bus CE Level I'),
('145','FM Certification Level 2 and ACQ Bus CE Level II'),
('146','FM Certification Level 2 and ACQ Bus CE Level III'),
('147','FM Certification Level 3 and ACQ Bus CE Level I'),
('148','FM Certification Level 3 and ACQ Bus CE Level II'),
('149','FM Certification Level 3 and ACQ Bus CE Level III'),
('150','Contracting-Staff/Supervision'),
('151','Warranted Contracting Officer'),
('152','No FM Certification Required'),
('153','Contract Administration'),
('154','Airfield Management Operations Coordinator (AMOC)'),
('155','Airfield Management Operations Supervisor (AMOS)'),
('156','Satellite Systems - Warning'),
('157','Satellite Systems - Intelligence, Surveillance, Reconnaissance'),
('158','Satellite Systems - MILSATCOM'),
('159','Satellite Systems - Precision, Navigation, Timing (PNT)'),
('160','Satellite Systems - Satellite Control Network (SCN)'),
('161','Mission Support System (MSS) & AFMSS'),
('162','Intratheater Imagery Transmission System (IITS)'),
('163','Telecommunication Monitoring Assessment Program (TMAP)'),
('164','Basic Air Advising'),
('165','Intermediate Air Advising (Level II)'),
('166','Advanced Air Advisor'),
('168','WSR - 88D, Next Generation Weather Radar (NEXRAD)'),
('170','Satellite Systems - Orbital Analysis (OA)'),
('171','Satellite Systems - Multi Systems'),
('172','Space lift - Range Systems'),
('173','Space lift - Mission Assurance/Space Launch Maintenance Technicians'),
('174','AN/GPN-22'),
('175','TEMPEST Technician'),
('176','Command and Control (C2), Air and Space Operations Center (AOC) Systems Administration'),
('177','UNIX System Administrator'),
('178','Digital European Backbone (DEB)'),
('179','Communications Antenna Systems'),
('180','AN/MST-T1'),
('181','Modular Control Equipment AN/FYQ 23'),
('182','AN/MPS-T1'),
('183','Airborne Computer Maintenance (AWACs)'),
('184','Strategic Communications Systems (SACCS)'),
('187','National Military Command Center Communications-Electronics Systems Maintenance'),
('188','Knowledge Operations'),
('189','Cyber Systems Operations'),
('190','Cyber Surety'),
('191','AN/TSC-114 Air Mobility Command Control Element (ALCE) Reaction Communication (MARC) System'),
('192','Computer Programming'),
('193','Radio Operations'),
('194','Client Systems'),
('195','Radar Sensor Operations Maintenance Evaluation'),
('196','Cyber Transport'),
('197','RF Transmissions'),
('198','Spectrum Operations'),
('199','Radar Systems'),
('1AA','Direct Support Operator (DSO)'),
('1AB','Basic Data Link Operator (DLO)'),
('1AC','Adversary Tactics Analyst'),
('1AD','Advanced Morse Code Technician'),
('1AE','Advanced Technical Electronic Intelligence (TECHELINT) Analyst'),
('1AF','Intermediate Operational Electronic Intelligence (OPELINT) Analyst'),
('1AG','Intermediate Technical Intelligence (TECHELINT) Analyst'),
('1BA','Link 16 Wing/Unit Manager'),
('1BB','Multi-TDL Advanced Joint Interoperability Technician'),
('1BC','Multi-TDL Operations Planner'),
('1BD','Master of Data Link Employment'),
('1CA','AFPC Reserved - 1'),
('1CB','AFPC Reserved - 2'),
('1CC','AFPC Reserved - 3'),
('1CD','AFPC Reserved - 4'),
('1CE','AFPC Reserved - 5'),
('1CF','AFPC Reserved - 6'),
('1CG','AFPC Reserved - 7'),
('1CH','AFPC Reserved - 8'),
('1CI','AFPC Reserved - 9'),
('1CJ','AFPC Reserved - 10'),
('1CK','AFPC Reserved - 11'),
('1CL','AFPC Reserved - 12'),
('1CM','AFPC Reserved - 13'),
('1CN','AFPC Reserved - 14'),
('1CO','AFPC Reserved - 15'),
('1CP','HH-60G Experience (Fully Qualified)'),
('1CQ','HH-60G Experience (Partially Qualified, prior 1A7X1)'),
('1GG','Deployable Ground Intercept Facility Crypto-Linguist'),
('1HR','Wing Human Resource Advisor (HRA)'),
('1KA','Computer Network Operations (CNO) Analyst'),
('1KB','Intermediate Computer Network Operations Analyst'),
('1KC','Advanced Computer Network Operations Analyst'),
('1KD','System and Network Interdisciplinary Analyst'),
('1KE','Information Operations Analyst'),
('1KF','Advanced Military Signals Intelligence (SIGINT) Analyst Professional'),
('1KG','Skilled Military Communication Signals Analyst Professional'),
('1KH','Air Force Distributed Ground System (DGS) Intelligence Analyst'),
('1KJ','Community Imagery Analyst Course (CIAC)'),
('1KL','Military Operational ELINT Signals Analyst Professional'),
('1KM','Military ELINT Signals Analyst Professional'),
('1ML','Military Language Analyst Professional'),
('1MM','Satellite Crypto-Linguist'),
('1NA','Single-channel Crypto-Linguist'),
('1NN','Multichannel Crypto-Linguist'),
('1PP','Airborne Analyst/Ground Mission Analyst'),
('1QQ','Airborne Mission Supervisor/ Ground Mission Supervisor'),
('1RR','Basic Crypto-Analyst'),
('1ZA','Space Intelligent Analyst'),
('1ZD','Cryptographer'),
('1ZK','Emergency Reaction Unit/Direct Supporting Unit/ Communications Security Technician'),
('200','Engineering Installation (EI)'),
('201','Airfield Systems'),
('202','CEM Quality Control'),
('203','Cable/Antenna'),
('205','Strategic Automated Command and Control System (SACCS)'),
('207','AN/ARC-96'),
('208','Global Command and Control Systems (GCCS) Systems Administration and Database Support'),
('211','Red Switch Maintenance'),
('212','AN/GPN-30 (DSDAR) Maintenance'),
('213','AN/FQS-204 (DASS/STARS) Maintenance'),
('214','AN/TPS-75 Maintenance'),
('215','AN/FMQ-18 (TWR) Maintenance'),
('216','AN/MPN-25 (GCA-2000) Maintenance'),
('217','AN/GPN-20 (ASR) Maintenance'),
('218','AN/TRN-26 (TACAN)'),
('220','AN/TRN-41 (TACAN)'),
('225','Range Operations'),
('226','Space Systems'),
('227','Instrumentation and Telemetry Systems'),
('228','Network Attack (NetA) Capability Specialist'),
('229','Network Defense (NetD) Capability Specialist'),
('230','Network Warfare Support (NS) Capability Specialist'),
('231','Network Warfare Operations Planner'),
('233','Military Deception (MILDEC) Capability Specialist'),
('234','Operations Security (OPSEC) Capability Specialist'),
('235','Public Affairs (PA) Information Operations (IO) Capability Specialist'),
('236','Military Information Support l Operations (MISO) Capability Specialist'),
('237','Influence Operations Planners'),
('238','General Information Operations (IO) Planner'),
('239','Joint Information Operations (IO) Planner'),
('240','Combat Crew Communications'),
('241','Counter Threat Finance (CTF) Analyst'),
('243','Commercial Communications'),
('244','AN/TPN-19'),
('246','AN/TPS-43'),
('250','Integrated Air Missile Defense (IAMD) Phase I'),
('251','Integrated Air Missile Defense (IAMD) Phase II'),
('252','STRAWHAT Communications System'),
('255','Ground-Based Radar - Warning and Surveillance Operations'),
('256','Airborne Command Post'),
('257','Space-Based Warning Operations'),
('258','Warning - Fusion Centers'),
('259','Space Control - Theater AOC'),
('260','Information Assurance Technical Level 1'),
('262','JTAC Weapons and Tactics Instructor'),
('264','Information Assurance Technical Level 2'),
('265','Information Assurance Technical Level 3'),
('266','Information Assurance Management Level 1'),
('267','Information Assurance Management Level 2'),
('268','Information Assurance Management Level 3'),
('269','COMSEC Accounting'),
('270','ECCM/ECM'),
('271','Host Aviation Resource Management Superintendent'),
('271','Benign Fill Operations'),
('272','Space Control - Fusion Centers'),
('273','Space Control - Offensive Operations'),
('274','Space Control - Defensive Operations'),
('275','Space Control - Defensive Operations (deployed)'),
('276','Defense Satellite Communications System (DSCS) Ground Terminals'),
('277','Tactical Air Control Systems/Combat Control Team'),
('278','Meridian Stored Logic 1 (MSL 1) (Created 31 Oct 99)'),
('279','Joint Terminal Attack Controller Instructor (JTAC-I)'),
('280','Chief, Joint Terminal Attack Controller Instructor (CJTAC I)'),
('281','JTAC Standardization/ Evaluation Examiner (SEE)'),
('283','Optical Solar Tele-scope (AN/FMQ-7)'),
('284','Solar Radio Tele-scope (AN/FRR-95)'),
('285','RVR-400'),
('286','Global High Frequency (HF) Systems'),
('288','Joint Threat Warning System'),
('290','Defense Meteoro-logical Satellite Pro-gram (DMSP) Equip-ment - MARK IVB'),
('291','Missile Communications System Evaluator/Instructor'),
('292','Satellite Ground Communications'),
('293','Space Situational Awareness (SSA) Optical'),
('295','DECAPES-Wing Level User'),
('297','Personnel Control Team (PCT) Member'),
('299','Manpower and Personnel Base Level (MANPER-B) Operator'),
('2AA','Intermediate Level Crypto-Linguist'),
('2BA','Integrated Maintenance Data System (IMDS)'),
('2BB','Integrated Maintenance Information System (IMIS)'),
('2BC','G081 Mobility Aircraft Data System'),
('2BD','Autonomic Logistics Information System (ALIS)'),
('2BE','Reliability and Maintainability Information System (REMIS)'),
('2FF','Collection Manager'),
('2GG','Interrogation Analyst'),
('2MM','Precise Point Mensuration (PPM)'),
('2TT','Combat Convoy Commander'),
('2ZA','High Frequency Crypto-Linguist'),
('2ZG','High Frequency Direction Finding (HFDF) Technician'),
('2ZX','Special Program'),
('2ZY','Advanced Communications Signals Analyst'),
('2ZZ','Intermediate Communications Signals Analysis'),
('300','Technical Order Acquisition Verification Management'),
('301','Air National Guard Readiness Center (ANGRC)'),
('302','ICBM Technical Engineering Personnel'),
('303','Retention Office Manager (ROM)'),
('305','NCO Preparatory Course Instructor'),
('306','Special Operations Force'),
('307','Flight Safety'),
('308','Base Engine Manager'),
('309','Installation Inspector General'),
('310','Security Forces Non-Lethal Weapons Instructor'),
('311','Military Working Dog (MWD) Handler'),
('312','Combat Arms'),
('313','Security Forces Sharpshooter'),
('314','Combat Logistics Support Squadron (CLSS) (Created 30 Apr 00)'),
('315','Central NOTAM Facility (CNF)'),
('316','AETC Technical Instructor (TI)'),
('317','Personnel PRP Management'),
('319','Intelligence, Surveillance, Reconnaissance - Multi Systems'),
('320','PMEL Production Scheduler'),
('321','Security Forces Investigator'),
('322','Information Security Experience'),
('323','Electronic Security Systems'),
('325','Medical Readiness'),
('326','Red Horse Experience'),
('327','Missile Defense- Theater AOC'),
('328','Air Base Survivability (ABS)'),
('329','PHOENIX RAVEN (Established 30 Apr 01)'),
('330','Combat Aviation Advisor (CAA)'),
('331','Missile Defense Operations'),
('332','Photojournalist'),
('333','Broadcast Journalist'),
('334','Missile Defense Operations (Deployed)'),
('335','Logistics Composite Model (LCOM)'),
('336','Teleproduction Facility Experience'),
('337','Aircrew Life Support'),
('338','Survival Equipment'),
('340','Rotary Wing Team Leader'),
('341','Fixed Wing Team Leader'),
('342','AN/MSN-7'),
('343','AN/MPN-14K'),
('344','Ground Radio Maintenance'),
('345','AN/MPN-26'),
('346','AN/FQS-143(V) Weapons Storage and Security System (WS3)'),
('347','Space Warfare C2 - Multi Systems'),
('348','Safety Education Program'),
('349','Space Warfare C2 - Space AOC'),
('350','Airspace Management'),
('351','Water & Fuels System Maintenance'),
('352','Utilities Systems'),
('353','Space Warfare C2 - Theater AOC (Deployed)'),
('354','Repair and Reclamation Shop'),
('356','Hazardous Materials Trainer'),
('357','Terminal Instrument Procedures (TERPS)'),
('358','Space Warfare C2 - Theater AOC'),
('359','Stock Fund Financial Management'),
('361','Terminal Instrument Procedures (TERPS)'),
('362','Air Traffic Control Radar Approach Control Watch Supervisor/Senior Controller'),
('363','Air Traffic Control Radar Center'),
('364','Air Traffic Control Radar Approach Control'),
('365','Radar Final Control (RFC)'),
('366','Materials Testing (Concrete, Asphalt, and Soils)'),
('368','Airfield Manager (AFM)'),
('369','Aerial Bulk Fuel Delivery Systems Operator'),
('370','Protocol'),
('371','NAF Accountant'),
('372','Additional Duty Military Equal Opportunity NCO'),
('373','Precision Photographic Reconnaissance Systems Processing Equipment Maintenance'),
('374','Precision Photo-graphic Audiovisual Systems Processing Equipment Maintenance'),
('375','Weapon Safety Manager'),
('376','Airfield Operations System Specialist'),
('377','Space Warfare C2 - Cyberspace'),
('378','Morse Code Qualified'),
('379','Certified Welder'),
('380','Space Test'),
('381','Space Instructor'),
('382','Space Evaluator'),
('383','Space Staff 1 - NAF/MAJCOM/COCOM/HAF (Manpower/Personnel/CFM/FAM)'),
('384','Space Staff 2 - SPO/NAF/MAJCOM/COCOM/HAF (Plans/Programs/PPBE/PEM/Program Management/Policy)'),
('385','Instructional Systems Development (ISD) Manager'),
('386','Instructional Materials Writer/ Manager'),
('387','Air Transportable Hydrant Refueling Systems (ATHRS)'),
('389','Acquisition Security'),
('390','Space Staff 3 - NAF/MAJCOM/COCOM/HAF (Requirements)'),
('391','Space Staff 4 - NAF/MAJCOM/COCOM/HAF (Operations)'),
('392','Special Security Office (SSO) Level I'),
('393','Special Security Office (SSO) Level II'),
('394','Special Security Office (SSO) Level III'),
('3AA','Advanced Level Crypto-Linguist'),
('3QQ','Geospatial Metadata Analyst (GMA)'),
('3ZC','Foreign Instrumentation Analyst'),
('3ZD','Advisory Interactive Reporting System Technician'),
('3ZJ','Airborne Maintenance Technician (AMT)'),
('3ZN','Ground RIVET JOINT Maintenance Technician'),
('3ZU','MXT-1200 Printer Maintenance Technician'),
('3ZY','SENIOR YEAR Ground Station Maintenance Technician'),
('402','IA Workforce System Architect and Engineer (IASAE) Level 1'),
('403','IA Workforce System Architect and Engineer (IASAE) Level 2'),
('404','IA Workforce System Architect and Engineer (IASAE) Level 3'),
('405','Enlisted Mission Planner'),
('406','Targeting'),
('407','AFOSI Counterespionage Case Officer'),
('408','AFOSI Special Agent in Charge'),
('409','AFOSI Polygrapher'),
('410','AFOSI Embedded Rapid Deployment Force Member'),
('411','AFOSI Computer Crime Investigator'),
('412','Air Force Office of Special Investigations (AFOSI) Surveillance Specialist'),
('413','Joint Task Force Spectrum Management'),
('415','Collateral Duty Mediator Level I Certification'),
('416','Collateral Duty Mediator Level II Certification'),
('417','Collateral Duty Mediator Level III Certification'),
('418','Collateral Duty Mediator Level IV Certification'),
('422','Fitness Manager'),
('423','Fitness and Exercise Specialist'),
('424','Food Facility Manager'),
('425','Food Shift Leader'),
('426','Lodging Manager'),
('427','Front Desk Supervisor'),
('428','Readiness Manager'),
('430','Weapons Accident Prevention Technician'),
('435','Army Combat Skills Training'),
('445','Latin America'),
('448','Africa Level I Certification'),
('449','Africa Level II Certification'),
('450','Inter-American Air Forces Academy (IAAFA)--Latin America'),
('451','Associate International Health Specialist (IHS)'),
('452','Regional International Health Specialist (IHS)'),
('453','Allergy/Immunization'),
('454','Immunizations'),
('455','Special Operations Command Medic'),
('456','Emergency Medical Technician � Paramedic (EMT-P)'),
('457','Global International Health Specialist (IHS)'),
('458','Surgical Ophthalmology'),
('460','Diagnostic Imaging, Mammography'),
('461','High Altitude Airdrop Mission Support (HAAMS) Team Member'),
('462','Legacy Occupational Therapy Technician (OTT)'),
('463','Medical PRP'),
('464','Occupational Therapy'),
('470','Flight Medicine Technician'),
('471','Neonatal Intensive Care Technician'),
('474','Licensed Practical Nurse'),
('475','Substance Abuse Certification'),
('476','Medical Illustration'),
('477','Medical Photography'),
('478','Computed Tomography'),
('479','Special Procedures'),
('481','Dental Hygienist (Established 31 Oct 01)'),
('486','Dialysis Medical Technician (DMT)'),
('487','Critical Care Technician'),
('489','Medical Development NCO (MDNCO)'),
('490','Hyperbaric Medical Technician (HMT)'),
('492','Radiation Health Technician'),
('493','Physiological Support'),
('494','Aeromedical Evacuation'),
('496','Independent Duty Medical Technician (IDMT)'),
('498','Neurosurgery'),
('4ZA','AN/FLR-9 Enlarger Maintenance Technician'),
('4ZK','Ground System Digital Technician'),
('4ZZ','PARSEC Maintenance Technician'),
('501','A-10'),
('502','CV-22'),
('503','KC-10'),
('504','T/UH-1D/F/N'),
('505','Any H-60'),
('506','F-117'),
('508','F-22'),
('509','C-130J'),
('510','U-2'),
('511','Any H-3'),
('512','Any H-53'),
('513','AC-130H/U/J/W, Gunship'),
('514','HC-130P/MC-130P'),
('515','MC-130E'),
('516','MC-130H/W'),
('517','E-130E (ABCCC)'),
('520','Reaper UAS Sensor Operator'),
('523','MQ-9 Remotely Piloted Aircraft (RPA)'),
('524','RQ-4'),
('525','MQ-1 Remotely Piloted Aircraft (RPA)'),
('531','Airborne Mission Systems'),
('532','T-1/T-37/T-38'),
('533','F-15'),
('534','MC-130J'),
('535','F-16'),
('537','Fuels Functional Headquarters Staffer'),
('545','C-5'),
('546','C-17'),
('547','C-12'),
('548','C-29'),
('549','C-40'),
('550','C-141'),
('557','KC-46A'),
('569','E-3A/BC/G (AWACS)'),
('570','E-8C, Joint Stars'),
('572','C-130E/H'),
('573','EC-130 Compass Call'),
('574','EC-135C/J (ABNCP)'),
('580','Any C-135/Boeing 707 Modification'),
('581','RC-135'),
('583','KC-135'),
('584','E-4A/B (NOAC)'),
('586','B-52'),
('588','B-1'),
('589','T-39'),
('590','Special Air Missions (SAM) (VC-25)'),
('591','VC/C-9/T-43'),
('594','Special Air Missions (SAM) (C-32)'),
('596','B-2'),
('5RA','Requirements Manager Certification Training (RMCT) Level A'),
('5RB','Requirements Manager Certification Training (RMCT) Level B'),
('5RC','Requirements Manager Certification Training (RMCT) Level C'),
('5RJ','Requirements Manager Certification Training (RMCT) Level B Plus'),
('5RK','Requirements Manager Certification Training (RMCT) Level C Plus'),
('5ZC','SENIOR SCOUT Operator'),
('5ZD','SENIOR RUBY Operator'),
('5ZE','Sensor Operator'),
('5ZF','Middle Enlisted Cryptologic Career Advancement Program (MECCAP)'),
('5ZG','PROFORMA Operator'),
('600','F101'),
('601','F100'),
('602','F110'),
('604','F118-100/101'),
('605','J69'),
('606','AE1107C(CV-22)'),
('607','J79'),
('608','J85 (T-38)'),
('609','AE2100D3 (C-130J)'),
('610','HC-130J'),
('611','TF30'),
('612','TF33'),
('613','TF34'),
('614','F108'),
('615','TF39'),
('616','F-35'),
('617','P/W F-135'),
('618','GE F-136'),
('619','C-40'),
('621','Low Observable (LO) Maintenance'),
('622','JT8D-9A'),
('623','611-8'),
('624','BR710-A1-10'),
('625','Automated Engine Tracking'),
('626','Integrated Avionics Facility Technician'),
('628','Low Light Level Television'),
('629','Tactical Electronic Reconnaissance (TEREC)'),
('630','AN/ALQ-131'),
('631','PW2020'),
('632','JT3D-3'),
('633','Low Altitude Navigation Targeting Infrared for Night (LANTIRN)'),
('634','PAVE PENNY'),
('635','F177-100'),
('638','CF6-80C2/81'),
('639','CF6-50'),
('640','T56'),
('641','T400-400'),
('642','T-64 (Created 31 Oct 99)'),
('643','T-700 (Created 31 Oct 99)'),
('645','F119'),
('646','ALQ-172'),
('648','A-10 IATS'),
('650','Infrared Detecting Set (IDS)'),
('655','Cyber Signals Analyst'),
('656','ALQ-119'),
('659','Adverse Weather Aerial Delivery Systems (AWADS)'),
('660','AN/AWN 37'),
('661','Spectrometric Oil Analysis'),
('662','PAVE SPIKE'),
('663','PAVE TACK'),
('664','AN/307 Operator'),
('665','Digital Scan Converter Group (DSCG)'),
('666','Turbojet/Turbofan Engine Maintenance'),
('667','Turboprop/Turboshaft Engine Maintenance'),
('668','AN/APX 81'),
('669','AN/APQ 99/172'),
('670','AN/ARN 101'),
('671','Nuclear Mission MAJCOM'),
('672','Target Identification System Electro- Optical (TISEO)'),
('676','AN/ALQ-184'),
('677','Air Force Satellite Communications Systems (AFSAT COM)/Fleet Satellite Communications Systems (FLEETSATCOM)'),
('678','Advanced Range Instrumentation System'),
('679','Rivet Eagle 66M Camera System'),
('680','ALM-204/ALQ-99E, Tactical Jamming Subsystem'),
('684','AN/ALQ-99E TJS'),
('685','C-145'),
('686','C-146'),
('687','RQ-170'),
('688','MC-12'),
('689','C-37'),
('690','Intermediate or Depot Level Maintenance'),
('6AA','Headquarters Staff (EDT)'),
('6AB','Inter-Continental Ballistic Missile - ICBM (EDT)'),
('6AC','Bomber (EDT)'),
('6AD','Dual Capable Aircraft - DCA (EDT)'),
('6AE','Storage (EDT)'),
('6AF','Inspector/ Evaluator (EDT)'),
('6AG','Aerospace Laboratory Technician'),
('714','Specialized Aerial Spray Equipment (SASE)'),
('715','Award criterion is under development.'),
('716','Award criterion is under development.'),
('717','Award criterion is under development.'),
('718','Award criterion is under development.'),
('719','Award criterion is under development.'),
('720','Award criterion is under development.'),
('721','Award criterion is under development.'),
('722','Award criterion is under development.'),
('723','Award criterion is under development.'),
('724','Award criterion is under development.'),
('725','Award criterion is under development.'),
('726','Award criterion is under development.'),
('727','Award criterion is under development.'),
('728','Award criterion is under development.'),
('729','Award criterion is under development.'),
('730','Award criterion is under development.'),
('731','Award criterion is under development.'),
('732','Award criterion is under development.'),
('733','Award criterion is under development.'),
('734','Afghan Pakistan Hands (APH)'),
('753','Forecasting (Space Environment)'),
('761','Observing (Space Environment)'),
('800','Special Operations Weather Team (SOWT)'),
('802','International Nuclear Treaty Inspector'),
('809','Missile Electronic Equipment Maintenance'),
('810','MMIII Missile Maintenance'),
('811','Nuclear Experience #2'),
('812','Weapons Storage and Security System Maintenance'),
('813','Missile Electronic Equipment Maintenance (VACE)'),
('814','Missile Electronic Equipment Maintenance (ELAB)'),
('815','ICBM Codes'),
('816','Nuclear Security Level I (Flight) Qualified'),
('817','Primary Nuclear Air Force (PNAF) Certification'),
('818','Nuclear Mission Operations or Support (Level I)'),
('819','Nuclear Mission Operations or Support (Level II)'),
('820','AGM-86C-CALCM'),
('821','AGM-86B ALCM'),
('822','Nuclear Manager'),
('823','Nuclear Experience #14'),
('824','Nuclear Experience #15'),
('825','Nuclear Experience #16'),
('826','Nuclear Experience #17'),
('827','Nuclear Experience #18'),
('828','MK-12A Reentry Vehicle'),
('829','MMIII Reentry System Maintenance'),
('830','MK-12 Reentry Vehicle'),
('831','MK-21 Reentry Vehicle'),
('836','Munitions Inspector'),
('837','Nuclear Experience #19'),
('838','Nuclear Experience #20'),
('839','Special Handling'),
('840','Nuclear Security Level II (Squadron/Group) Qualified'),
('841','Nuclear SecurityLevel III (HHQ Policy) Qualified'),
('842','Nuclear Security Manager'),
('843','Nuclear Mission Intelligence'),
('844','Intelligence CMF Specialist'),
('845','Nuclear Tanker Operations (Level I)'),
('846','Nuclear Tanker Operations (Level II)'),
('857','WS-133B (Minuteman)'),
('858','WS-133A/M (Minuteman)'),
('860','WS-118'),
('861','AGM 86B/C/D'),
('862','Aerial Nuclear Security'),
('869','Knowledge Operations Client Systems Admin'),
('870','Personal Wireless Communications Systems'),
('871','Voice Switching Systems Administration'),
('872','Computer Network Defense Service Provider (CND-SP) Analyst (CND-A)'),
('873','Computer Network Defense Service provider (CND-SP) Infrastructure Support (CND-IS)'),
('874','Computer Network Defense Service Provider (CND-SP) Incident Responder (CND-IR)'),
('875','Computer Network Defense Service Provider (CND-SP) Auditor (CND-AU)'),
('876','Computer Network Defense Service Provider (CND-SP) Manager'),
('877','Computer Network Defense Service Provider (CND-SP) Incident Responder (CND-IR)'),
('877','Cyberspace Operations - Computer Network Exploitation (CNE) Operator'),
('878','Computer Network Defense Service Provider (CND-SP) Auditor (CND-AU)'),
('879','Computer Network Defense Service Provider (CND-SP) Manager'),
('880','Prior 2E190'),
('881','Prior 2E290'),
('882','Prior 2E0X1'),
('883','Prior 2E1X1'),
('884','Prior 2E1X2'),
('885','Prior 2E1X3'),
('886','Prior 2E1X4'),
('887','Prior 2E2X1'),
('888','Prior 2E6X2'),
('889','Prior 2E6X3'),
('890','Prior 3A0X1'),
('891','Prior 3C090'),
('892','Prior 3C0X1'),
('893','Prior 3C0X2'),
('894','Prior 3C1X1'),
('895','Prior 3C1X2'),
('896','Prior 3C2X1'),
('897','Prior 3C3X1'),
('898','Joint Cyber Analysis Course (JCAC)'),
('899','Cyberspace Support Project Management'),
('8AA','Afrikaans Proficiency'),
('8AC','Amharic Proficiency'),
('8AD','Arabic-MSA Proficiency'),
('8AE','Arabic-Egyptian Proficiency'),
('8AL','Albanian Proficiency'),
('8AM','Arabic-Libyan Proficiency'),
('8AN','Arabic-Saudi Proficiency'),
('8AP','Arabic-Syrian Proficiency'),
('8AR','Armenian Proficiency'),
('8AU','Arabic-Yemeni Proficiency'),
('8AV','Arabic-Sudanese Proficiency'),
('8AX','Azeri Proficiency'),
('8BL','Belarusian Proficiency'),
('8BS','Arabic-Moroccan Proficiency'),
('8BT','Baluchi Proficiency'),
('8BW','Arabic-Tunisian Proficiency'),
('8CA','Cambodian Proficiency'),
('8CC','Cantonese Proficiency'),
('8CK','Chechen Proficiency'),
('8CM','Chinese Proficiency'),
('8CX','Czech Proficiency'),
('8DG','Arabic-Iraqi Proficiency'),
('8DU','Dutch Proficiency'),
('8FR','French Proficiency'),
('8GG','Georgian Proficiency'),
('8GM','German Proficiency'),
('8GR','Greek Proficiency'),
('8HC','Haitian-Creole Proficiency'),
('8HE','Hebrew Proficiency'),
('8HJ','Hindi Proficiency'),
('8JA','Japanese Proficiency'),
('8JN','Indonesian Proficiency'),
('8JT','Italian Proficiency'),
('8KP','Korean Proficiency'),
('8LC','Lao Proficiency'),
('8MA','Macedonian Proficiency'),
('8PF','Farsi Proficiency'),
('8PG','Dari Proficiency'),
('8PJ','Punjabi Proficiency'),
('8PQ','Portuguese Proficiency'),
('8PV','Pushtu Proficiency'),
('8QB','Spanish Proficiency'),
('8RQ','Romanian Proficiency'),
('8RU','Russian Proficiency'),
('8SC','Serbo-Croation Proficiency'),
('8SM','Somali Proficiency'),
('8SW','Swahili Proficiency'),
('8TA','Tagalog Proficiency'),
('8TH','Thai Proficiency'),
('8TL','Tigrinya Proficiency'),
('8TU','Turkish Proficiency'),
('8UJ','Uigher Proficiency'),
('8UK','Ukrainian Proficiency'),
('8UR','Urdu Proficiency'),
('8UX','Uzbek Proficiency'),
('8VN','Vietnamese Proficiency'),
('8XK','Kurmanji Proficiency'),
('8XS','Sorani Proficiency'),
('900','Combat Airspace Management Level I'),
('901','Command and Control (C2), Air Operations Center (AOC)'),
('902','Command and Control (C2), Joint Interface Control Non Commissioned Officer (JIC NCO)'),
('903','Nuclear Command and Control'),
('904','Advanced Weapons Director (AWD) Graduate'),
('905','407L Tactical Air Control System'),
('906','416L Continental Air Defense Control and Warning System'),
('907','Defense Meteorological Satellite Pro-gram - Control Read-out Station (CRS)'),
('908','Defense Meteorological Satellite Pro-gram (DMSP) Command Control Center'),
('909','Combat Airspace Management Level II'),
('910','Over the Horizon - Backscatter (OTH-B)'),
('911','Modular Control Equipment (MCE), AN/TYQ-23'),
('912','427M American Air Defense COC (NORAD)'),
('914','Joint Terminal Attack Controller (JTAC)'),
('915','465L SAC Command Control Systems (SACCS)'),
('916','Strategic Defense Radar Systems Evaluator'),
('917','Command and Control (C2), Air and Space Operations Center (AOC) Air Mobility Division (AMD)'),
('918','Command and Control (C2), Air and Space Operations Center (AOC) Combat Operations Division (COD), Personnel Recovery Coordination Cell (PRCC)'),
('919','Inland Search and Rescue (ISAR)'),
('920','USAF Combat Search and Rescue (CSAR) Controller'),
('921','USAF Maritime Search and Rescue (SAR) Controller'),
('922','ISR-Special Tactics'),
('923','SOF ISR Tactical Controller (ITC)'),
('924','Department of the Air Force Command and Control System (DAFCCS)'),
('927','Ballistic Missile Early Warning Sys-tem (BMEWS)-Mech'),
('928','Ballistic Missile Early Warning Sys-tem (BMEWS) - Phased-Array'),
('929','Air Combat Forensics'),
('933','481L Post Attack Command and Control System (PACCS)'),
('934','Fixed and Mobile Space Based Communications Operation'),
('935','Space Based Communications Operation, Large Processing Station (LPS)'),
('936','Defense Satellite Communications System Operations Center (DSCSOC)'),
('942','484L Presidential Aircraft Support System'),
('943','Control and Reporting Center (CRC) Surveillance Technician (ST)'),
('944','Control and Reporting (CRC) Electronic Protection Technician (EPT)'),
('945','Control and Reporting Center (CRC) Data Systems Technician (DST)'),
('946','Control and Reporting (CRC) Electronic Air Surveillance Technician (AST)'),
('947','Control and Reporting Center (CRC) Interface Control Technician (ICT)'),
('948','Control and Reporting (CRC) Weapons Director (WD)'),
('949','Control and Reporting Center (CRC) Battle Staff Coordinator (BSC)'),
('950','Control and Reporting (CRC) Operations Coordinator (OC)'),
('954','487L Survivable Low Frequency Communications System'),
('955','Tower, Chief Controller'),
('956','RAPCON, Chief Controller'),
('957','GCA, Chief Controller'),
('961','Subsurface Analysis'),
('962','Subsurface Maintenance'),
('963','Materials Maintenance'),
('964','Laboratory Specialist'),
('970','Special Tactics'),
('971','Special Tactics Operator'),
('978','Communications Satellites/ Satellite Control Network'),
('979','Space Defense Operations Center (SPADOC)'),
('982','496L SPACETRACK (Phased-Array Radar/ Cobra Dane/FPS-85)'),
('983','496L SPACETRACK (Optical Surveillance)'),
('984','Postal Training or Experience'),
('985','Research and Development Technician Serving in Development Engineering Position'),
('986','Sea Launched Ballistic Missile (SLBM) Phased-Array Warning System (PAVE PAWS)'),
('987','MILSTAR Maintenance'),
('988','Sector/Region Operations Control Center'),
('990','Space Surveillance Center'),
('991','Air Force Space Operations Center'),
('992','Space Command Center'),
('993','Global Positioning System'),
('994','Deep Space Tracking System'),
('995','Milstar'),
('996','Defense Support Program/ Satellite Control Network'),
('9AD','Arabic-MSA Proficiency'),
('9AE','Arabic-Egyptian Proficiency'),
('9AL','Arabic-Libyan Proficiency'),
('9AN','Arabic-Saudi Proficiency'),
('9AP','Arabic-Syrian Proficiency'),
('9AU','Arabic-Yemeni Proficiency'),
('9AV','Arabic-Sudanese Proficiency'),
('9BS','Arabic-Moroccan Proficiency'),
('9BW','Arabic-Tunisian Proficiency'),
('9CM','Chinese Proficiency'),
('9DG','Arabic-Iraqi Proficiency'),
('9HJ','Hindi Proficiency'),
('9KP','Korean Proficiency'),
('9PF','Farsi Proficiency'),
('9PG','Dari Proficiency'),
('9PJ','Punjabi Proficiency'),
('9PV','Pushtu Proficiency'),
('9QB','Spanish Proficiency'),
('9RU','Russian Proficiency'),
('00','Experience undetermined'),
('01','Chemical, Biological, Radiological, and Nuclear(CBRN) Qualification Level I'),
('02','Chemical, Biological, Radiological, and Nuclear (CBRN) Qualification Level II'),
('03','Chemical, Biological, Radiological, and Nuclear (CBRN) Qualification Level III'),
('04','Army Combat Skills Training (CST)'),
('05','AFSO21 Level I Certification'),
('06','AFSO21 Level II Certification'),
('07','AFSO21 Level III Certification'),
('08','Manpower-Personnel'),
('09','Services'),
('0A','Special Programs Management/Exchange'),
('0B','Special Programs Management/Exchange'),
('0C','Special Programs Management/Exchange'),
('0D','Exchange Tour - European Area'),
('0E','Exchange Tour - Pacific Area'),
('0F','Exchange Tour - Western Hemisphere'),
('0G','Exchange Tour - Sister Service'),
('0H','Personnel Support for Contingency Operations (PERSCO)'),
('0I','Information Assurance Management Level 1'),
('0J','Information Assurance Management Level 2'),
('0K','Information Assurance Management Level 3'),
('0L','Air National Guard Readiness Center (ANGRC)'),
('0M','Quality Air Force (QAF) Advisor'),
('0N','Quality Air Force (QAF) Facilitator'),
('0P','Quality Air Force (QAF) Instructor'),
('0Q','Quality Air Force (QAF) Master Instructor'),
('0R','Arms Control'),
('0S','Modeling and Simulation (M&S)'),
('0T','Weapons of Mass Destruction Civil Support Team (WMD CST) Member'),
('0U','Force Support Transition Training'),
('0V','Victim Advocate'),
('0W','Modeling and Simulation (M&S) Manager Level'),
('0X','Modeling and Simulation (M&S) Senior Leader'),
('0Y','Level I - Sexual Assault Response Coordinator (SARC)'),
('0Z','Level II - Sexual Assault Response Coordinator (SARC)'),
('1A','Stability and Control'),
('1B','Range Support'),
('1C','Airborne Digital EW Systems'),
('1D','Digital Avionics Fire Control/Navigation System'),
('1E','Crew Station Engineering'),
('1F','Environmental Control'),
('1G','Test Facility Engineering'),
('1H','System Safety'),
('1I','Ground Communications Electronics, Meteorological'),
('1J','Engineering Standards and Specifications'),
('1L','Support Equipment/AGE'),
('21','Micro Processors'),
('22','8-Bit Minicomputers'),
('23','16-Bit Minicomputers'),
('24','32-Bit Minicomputers'),
('25','65-Bit Minicomputers'),
('26','Minicomputers, Other'),
('2A','Honeywell 6000'),
('2B','IBM (VIRTUAL)'),
('2C','IBM (Non-VIRTUAL)'),
('2D','MULTICS'),
('2E','Minicomputers (VIRTUAL)'),
('2F','B3500/3700/4700'),
('2G','B6700'),
('2H','U1050-II'),
('2I','RJETS'),
('2J','B-4000 Series'),
('2K','UNIVAC - Other'),
('2L','CDC - Other'),
('2M','Burroughs - Other'),
('2N','CDC 6000 Series'),
('2O','CDC 7000 Series'),
('2S','U-9000 Series'),
('3A','COBOL'),
('3B','FORTRAN'),
('3C','PL/1'),
('3D','ALGOL'),
('3E','JOVIAL'),
('3F','APL'),
('3G','BASIC'),
('3H','GPSS'),
('3I','SIMSCRIPT'),
('3J','Simulation Languages-Other'),
('3K','SNOBOL'),
('3L','List Processing Languages-Other'),
('3M','File Format System (FFS) Language'),
('3N','Assembly Languages'),
('3O','Programmer, General'),
('3P','SDC Programmer Proficiency Trained'),
('4A','Programmer/Analyst'),
('4B','Systems Analyst'),
('4C','Network Management'),
('4D','MICRO Programming'),
('4E','Requirements Analyst'),
('4F','CDTS'),
('4G','Programming Productivity Techniques'),
('4H','ADP Security'),
('4I','CPE'),
('4J','Data Base Administration'),
('4K','Graphics'),
('4L','Command and Control Hardware'),
('4M','Command and Control Software'),
('4N','Systems Computer Program Support'),
('4O','Computer Aided Support for Automatic Test Equipment (ATE)'),
('4P','Automatic Test Equipment'),
('4Q','Digital Simulation for Operational Flight Program'),
('4R','L-COM'),
('4S','Ground Reconnaissance Specialist'),
('4T','Criminal Analysis Specialist'),
('4U','Civil Operations Specialist'),
('4V','Counter Threat Finance (CTF) Analyst'),
('5C','Command, Control, and Communications Countermeasures (C3CM)'),
('5D','Tactical Communications'),
('5E','Tactical Radar Maintenance'),
('5H','Combat Information Systems Group (CISG)'),
('61','Information Assurance Technical Level 1'),
('62','Information Assurance Technical Level 2'),
('63','Information Assurance Technical Level 3'),
('6A','Precision Location Strike System (PLSS)'),
('6D','TACS/Combat Communications Experience'),
('6L','AN/TYC-10 Message Processing Center'),
('7A','Operational Test and Evaluation (OT&E)'),
('8A','Associate International Health Specialist (IHS)'),
('8B','Regional Health Specialist (IHS)'),
('8C','Global International Health Specialist (IHS)'),
('8D','Link 16 Wing/Unit Manager'),
('8E','Multi-TDL Advanced Joint Interoperability Manager'),
('8F','Multi-TDL Operations Planning Manager'),
('8G','Master of Data Link Employment'),
('8H','Master of Data Link Management')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 7...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('91','Command and Control (C2), Air and Space Operations Center (AOC) Combat Operations Division (COD)'),
('92','Command and Control (C2), Air and Space Operations Center (AOC) Air Mobility Division (AMD)'),
('93','Command and Control (C2), Air and Space Operations Center (AOC) Strategy Division (SD), Operations Assessment Team (OAT)'),
('94','Command and Control (C2), Air and Space Operations Center (AOC) Combat Plans Division, Targeting Effects Team (TET)'),
('95','Command and Control (C2), Air and Space Operations Center (AOC) Combat Plans Division (CPD), Master Air Attack Plan (MAAP) Team'),
('96','Command and Control (C2), Air and Space Operations Center (AOC) Combat Plans (CPD), Air Tasking Order (ATO) Production Team'),
('97','Command and Control (C2), Air and Space Operations Center (AOC) Combat Plans Division (CPD), C2 Planning Team'),
('98','Command and Control (C2), Air and Space Operations Center (AOC) Air Tasking Order (ATO) Coordinator/Team'),
('99','Command and Control (C2), Air and Space Operations Center (AOC) Combat Operations Division (COD), Personnel Recovery Coordination Cell (PRCC)'),
('9A','Command and Control (C2), Air Operations Center (AOC)'),
('9B','Command and Control (C2), Joint Interface Control Officer (JICO)'),
('9C','Joint Terminal Attack Controller (JTAC)'),
('9D','Joint Terminal Attack Controller (JTAC)-Instructor'),
('9E','Joint Terminal Attack Controller (JTAC)-Standardization/Evaluation Examiner (SEE)'),
('9F','Electronic Attack Capability Specialist'),
('9G','Electronic Warfare Capability Specialist'),
('9H','Electronic Warfare Operations Planner'),
('9I','Network Attack (NetA) Capability Specialist'),
('9J','Network Defense (NetD) Capability Specialist'),
('9K','Network Warfare Support (NS) Capability Specialist'),
('9L','Network Warfare Operations Planner'),
('9M','Counter Intelligence (CI) Capability Specialist'),
('9N','Military Deception (MILDEC) Capability Specialist'),
('9O','Operations Security (OPSEC) Capability Specialist'),
('9P','Public Affairs (PA) Capability Specialist'),
('9Q','Military Information Support Operations (MISO) Capability Specialist'),
('9R','Advanced Degree Information Operations (IO) Planner'),
('9S','General Information Operations (IO) Planner'),
('9T','Joint Information Operations (IO) Planner'),
('9U','Information Operations Staff Officer'),
('9V','IO Legal Advisor'),
('9W','Air Support Operations Center (ASOC)'),
('A1','CRC ASO'),
('A2','CRC SD'),
('A3','CRC MCC'),
('A4','Air Defense AWO'),
('A5','F-106'),
('A5','Air Defense ASO'),
('A6','Air Defense SD'),
('A7','Air Defense MCC'),
('A8','ABM Weapons Instructor Course (ABM WIC) Graduate'),
('A9','USN E-2 Exchange Officer'),
('AA','T-38'),
('AB','Master Resilience Trainer'),
('AC','Joint Operations - Air Mobility Liaison Officer (AMLO)'),
('AE','F-105'),
('AF','F-4'),
('AG','F-111'),
('AH','F-5'),
('AI','F-16'),
('AJ','F-117'),
('AK','A-7'),
('AM','F-15'),
('AN','A-10'),
('AP','AWACS AWO/WC'),
('AQ','AWACS ECO/PC'),
('AR','AWACS ASO/SC'),
('AS','AWACS SD/FA'),
('AT','AWACS MCC/MC'),
('AU','JSTARS AWO'),
('AW','JSTARS SMO'),
('AX','JSTARS SD'),
('AY','JSTARS MCC'),
('AZ','CRC AWO'),
('B0','Developmental Testing and Evaluation Navigator'),
('B1','C-141'),
('B2','E-6B (ABNCP) Airborne Launch Control System (ALCS)'),
('B3','C-5'),
('B4','KC-10'),
('B6','Flight Commander and Flight Commander Primary Crew Members'),
('B7','Training Flight Instructor'),
('B8','Receiver-Aerial Refueling Qualified'),
('B9','SAR RESCORT Qualified'),
('BA','B-2'),
('BB','Basic Air Advising'),
('BC','Intermediate Air Advising (Level II)'),
('BD','Advanced Air Advisor'),
('BH','B-1'),
('BI','B-52'),
('BK','U-2'),
('BL','SR-71'),
('BS','E-3A/B (AWACS)'),
('BT','E-4A/B (NAOC)'),
('BU','Intelligence Sensor Weapons Instructor Course (ISWIC)'),
('BW','Intelligence Weapons Instructor Course (IWIC)'),
('BX','C-135/137'),
('C0','Red Flag'),
('C1','Maintenance Officer Manning Enhancement Program'),
('C2','Career Trainer'),
('C3','Joint/Component Staff Augmentee'),
('C4','PAVE SPIKE'),
('C5','PAVE TACK'),
('C6','PAVEWAY I/PAVE KNIFE'),
('C7','F-15'),
('C8','Special Operations Staff Augmentee'),
('C9','Special Operations Staff Officer'),
('CA','Glide Bomb Unit (GBU)'),
('CB','ACEVAL/AIMVAL'),
('CC','Production Activities in TAF Aircraft Maintenance COMO Units'),
('CD','C-130B/E'),
('CE','Air Surveillance Officer'),
('CF','Night Vision Goggle (NVG) Operations'),
('CG','Air Base Operability (ABO) Operations'),
('CH','Airfield Management'),
('CJ','Tactical Deception'),
('CK','Combat Airspace Management Level I'),
('CP','Clinical Pastoral Education'),
('CR','Combat Airspace Management Level II'),
('CS','Combat Airspace Management Level III'),
('CU','UH-1, Other'),
('CY','CH-53'),
('CZ','HH-53'),
('D1','FM Certification Level 2 and ACQ Bus CE Level II'),
('D2','OV-10'),
('D3','Aggressor Qualified'),
('D4','FM Certification Level 2 and ACQ Bus CE Level III'),
('D5','FM Certification Level 3 and ACQ Bus CE Level I'),
('D6','FM Certification Level 3 and ACQ Bus CE Level II'),
('D7','FM Certification Level 3 and ACQ Bus CE Level III'),
('D8','No FM Certification Required'),
('DA','FM Certification Level 1'),
('DB','FM Certification Level 2'),
('DC','FM Certification Level 3'),
('DD','FM Certification Level 1 and ACQ Audit Level I'),
('DE','C-12'),
('DF','FM Certification Level 1 and ACQ Audit Level II'),
('DG','FM Certification Level 1 and ACQ Audit Level III'),
('DH','FM Certification Level 2 and ACQ Audit Level I'),
('DI','FM Certification Level 2 and ACQ Audit Level II'),
('DJ','FM Certification Level 2 and ACQ Audit Level III'),
('DK','FM Certification Level 3 and ACQ Audit Level I'),
('DL','FM Certification Level 3 and ACQ Audit Level II'),
('DM','FM Certification Level 3 and ACQ Audit Level III'),
('DN','FM Certification Level 1 and ACQ Bus FM Level I'),
('DO','FM Certification Level 1 and ACQ Bus FM Level II'),
('DP','FM Certification Level 1 and ACQ Bus FM Level III'),
('DQ','FM Certification Level 2 and ACQ Bus FM Level I'),
('DR','FM Certification Level 2 and ACQ Bus FM Level II'),
('DS','FM Certification Level 2 and ACQ Bus FM Level III'),
('DT','FM Certification Level 3 and ACQ Bus FM Level I'),
('DU','FM Certification Level 3 and ACQ Bus FM Level II'),
('DV','FM Certification Level 3 and ACQ Bus FM Level III'),
('DW','FM Certification Level 1 and ACQ Bus Cost Estimating Level I'),
('DX','FM Certification Level 1 and ACQ Bus Cost Estimating Level II'),
('DY','FM Certification Level 1 and ACQ Bus Cost Estimating Level III'),
('DZ','FM Certification Level 2 and ACQ Bus CE Level I'),
('E1','Deliberate and Crisis Action Planning Execution Segments Automated Data Processing (DCAPES ADP) Analyst'),
('E2','Pacific SAC ADVON'),
('E3','European SAC ADVON'),
('E4','Southwest Asia SAC ADVON'),
('E5','Atlantic SAC ADVON'),
('E6','Theater Battle Management (TBM)'),
('E7','A-10 ABDR Engineer'),
('E8','Bomber ABDR Engineer'),
('E9','C-130 ABDR Engineer'),
('EA','Mid Air Recovery System (MARS)'),
('EB','Surface Recovery Operations'),
('EC','Night Recovery System (NRS)'),
('ED','Central NOTAM Facility'),
('EE','Single Integrated Operations Plans (SIOP) Experience'),
('EF','Revolutionary Warfare'),
('EG','Psychological Operations'),
('EH','Foreign Internal Defense or Civic Action'),
('EI','All Weather Recovery System (PAVE LOW)'),
('EK','Joint Operation Planning and Execution System (JOPES) Automated Data Processing (ADP) Management'),
('EM','Contingency Operation/Mobility Planning and Execution System (COMES) Management'),
('EN','BLUE FLAG (Korean)'),
('EO','BLUE FLAG (Contingency)'),
('EP','COPE THUNDER'),
('EQ','BLUE FLAG (Northern Region)'),
('ER','BLUE FLAG (Central Region)'),
('ES','BLUE FLAG (Southern Region)'),
('ET','Weapons Safety (Explosives and Nuclear)'),
('EU','German Air Defense Ground Environment (GEADGE)'),
('EV','USAF Advanced Instrument School'),
('EW','Worldwide Military Command and Control System (WWMCCS) Intercomputer Network (WIN) Operator'),
('EX','Electronic Combat Coordinator'),
('EY','Stage Crew Manager'),
('EZ','HQ/MAJCOM Time Phase Force Deployment Data (TPFDD) Analyst'),
('F0','Air Transportable Hospital'),
('F1','Quality Assurance Coordinator'),
('F2','Social Health Insurance Systems Manager'),
('F3','Medical Air Reserve Forces'),
('F4','Recruiting'),
('F5','Health Promotion Coordinator'),
('F6','Emergency Department Clinical Nurse Specialist'),
('F7','Flight Nurse Clinical Nurse Specialist'),
('F8','General Dental Officer-Clinical Specialist'),
('F9','Advanced Trauma Life Support (ATLS) Qualified Instructor'),
('FA','Aeromedical Staging'),
('FB','Acute and Critical Care Nurse Specialist Adult, Pediatric or Neonatal (Intensive Care Unit Clinical Nurse Specialist)'),
('FC','Chief of Hospital Services/ MAJCOM Chief of Professional Services'),
('FD','Health Facilities Officer'),
('FE','Research'),
('FF','Biomedical Equipment Maintenance'),
('FG','Health Systems Analyst'),
('FH','Pediatric Nursing'),
('FI','Public Health'),
('FJ','Primary Care Clinic'),
('FK','Director, Ambulatory Services'),
('FL','Aeromedical Evacuation'),
('FM','Hyperbaric Nursing'),
('FN','Base Dental Surgeon'),
('FO','Medical Materiel'),
('FS','Renal Dialysis'),
('FT','Health Promotion Manager'),
('FU','Inhalation Therapy'),
('FW','Infection Control/Nurse Epidemiologist'),
('FX','Oncology'),
('FZ','Medical Operations'),
('G0','Ambulatory Care Clinical Nurse Specialist'),
('G1','Nurse Scientist'),
('G3','Special Access Program'),
('G8','Joint Operations Center'),
('GA','Senior Level Maintenance Certification'),
('GB','Master Level Maintenance Certification'),
('GC','Satellite C2 � Space-Based Warning'),
('GD','Satellite C2 � Intelligence, Surveillance, Reconnaissance'),
('GE','Satellite C2 � Precision, Navigation, Timing'),
('GF','Satellite C2 � Military Satellite Communications (MILSATCOM)'),
('GH','Satellite C2 � Space Situational Awareness'),
('GI','Satellite C2 � Satellite Control Network'),
('GJ','Satellite C2 � Orbital Analysis (OA)'),
('GK','Satellite C2 � Other Systems'),
('GL','Offensive Space Control Operations'),
('GN','Defensive Space Control Operations'),
('GP','Space Situational Awareness Mission Operations'),
('GQ','Spacelift Operations'),
('GR','Spacelift � Range Operations'),
('GS','Ground-Based Radar � Missile Warning'),
('GT','Ground-Based Radar � Space Situational Awareness (SSA) Operations'),
('GU','Ground-Based Optical � Space Situational Awareness (SSA) Operations'),
('GV','Adult Psychiatric & Mental Health CNS (Mental Health Clinical Nurse Specialist)'),
('GW','Perioperative Clinical Nurse Specialist'),
('GX','Maternal/Child Clinical Nurse Specialist'),
('GY','Adult Health CNS (Medical/Surgical Clinical Nurse Specialist)'),
('GZ','Pediatrics Clinical Nurse Specialist'),
('H1','F-22 ABDR Engineer'),
('H2','F-15 ABDR Engineer'),
('H3','F-16 ABDR Engineer'),
('H4','Space Air and Space Operations Center (AOC)'),
('H5','Sexual Assault Prevention and Response Victim Advocates'),
('H6','Space Test'),
('HA','Joint Special Operations Experience'),
('HB','Joint Special Operations Task Force Experience'),
('HC','Collateral Duty Mediator Level I Certification'),
('HD','Collateral Duty Mediator Level II Certification'),
('HE','Collateral Duty Mediator Level III Certification'),
('HF','Collateral Duty Mediator Level IV Certification'),
('HH','HH-60 ABDR Engineer'),
('HJ','Inter-American Air Forces Academy (IAAFA) - Latin America'),
('HK','Africa Level I Certification'),
('HL','Africa Level II Certification'),
('HM','Medical Service Corps Health Plans'),
('HP','Medical PRP'),
('HQ','LEAP (Language Enabled Airmen Program) Qual'),
('HR','Installation Inspector General'),
('HS','Personnel PRP Management'),
('HT','Sleep Medicine Specialist'),
('HU','Total Force Service Center'),
('IB','Regional Experience, Eurasia - Level 1'),
('IC','Regional Experience, Latin America (LATAM) - Level 1'),
('ID','Regional Experience, Northeast Asia (NEA) - Level 1'),
('IE','Regional Experience, Southeast Asia (SEA) - Level 1'),
('IF','Regional Experience, Middle East/North Africa (MENA) - Level 1'),
('IG','Regional Experience, Sub-Saharan Africa (SSA) - Level 1'),
('IH','Regional Experience, Europe - Level 1'),
('IJ','Regional Experience, South Asia (SA) - Level 1'),
('IK','Regional Experience, China - Level 1'),
('IL','Certified RAS, Non-deliberately developed, Level 1'),
('IM','Certified RAS, Non-deliberately developed, Level 2'),
('IN','Certified RAS, Non-deliberately developed, Level 3'),
('IP','Certified RAS, Deliberately Developed, Level 1'),
('IQ','Certified RAS, Deliberately Developed, Level 2'),
('IR','Certified RAS, Deliberately Developed, Level 3'),
('IS','PAS'),
('IT','Military Observer, Peacekeeping Operation'),
('JA','Staff Judge Advocate'),
('JB','Area Defense Counsel'),
('JC','Circuit Counsel'),
('JD','Appellate Counsel'),
('JE','Military Judge'),
('JF','Military Justice Reviewing Officer'),
('JG','Logistics Contract Law Specialist'),
('JH','Systems Contract Law Specialist'),
('JI','General Contract Law Specialist'),
('JJ','Civil Law Specialist'),
('JK','Administrative Law Specialist'),
('JL','Claims and Tort Law Specialist'),
('JM','Forensic Medicine Specialist/Physical Evaluation Board Counsel'),
('JN','International Law Specialist'),
('JO','Labor Law Specialist'),
('JP','Lawyer Serving as Line Officer'),
('JQ','Environmental Law Specialist'),
('JR','Base Contract Specialist'),
('JS','Base Claims Specialist'),
('KA','Manufacturing Planning'),
('KB','Manufacturing (Systems)'),
('KC','Pricing Analyst'),
('KD','Contracting Officer'),
('KE','Administrative Contracting Officer (ACO)'),
('KF','Base Contracting'),
('KG','Contracting Overseas'),
('KH','Production (Central/Departmental)'),
('KI','Quality Assurance'),
('KJ','Program Management Responsibility Transfer (PMRT)'),
('KK','Deputy Program Manager for Logistics'),
('KL','Space Acquisition Logistics'),
('KM','Contingency Operations'),
('KN','Distribution Management'),
('KO','Materiel Management'),
('KQ','Airlift Contracting-Buying'),
('KR','Contract Termination'),
('KS','Contract Administration'),
('KT','Aerial Port Operations'),
('KU','Distribution Management'),
('KV','Vehicle Management'),
('KW','Materiel Management'),
('KX','Contingency Operations'),
('KY','Fuels Management'),
('LA','AF Logistics Officer Career Broadening Program'),
('LB','AFMC International Logistics Training Program'),
('LC','Explosive Ordnance Disposal (EOD)'),
('LE','Maintenance Control'),
('LF','Munitions Technical Escort'),
('LG','Medical Service Corps Logistics'),
('LM','ALC Directorate of Materiel Management'),
('LO','Logistics Composite Model'),
('LS','Logistics Sustainment'),
('M','Maintenance'),
('MC','Special Operations Command Medical Officer'),
('MD','Medical Service Corps Facilities'),
('ME','Clinic or Academic Grand Master Llevel'),
('MF','Excellence in Clinical or Academic Teaching, Level II'),
('MG','Expert Acupuncturist, Level I'),
('MH','Master Acupuncturist, Level II'),
('MQ','Medical Service Corps Acquisitions'),
('MV','Medical Service Corps Aeromedical Evacuation'),
('N2','Special Operations Weather Team'),
('N3','Weather'),
('PA','Air Force One Advance Agent'),
('PL','USAF Operations Staff Planner'),
('PN','LGM-25C'),
('PO','WS-133A'),
('PP','WS-133B'),
('PQ','WS-133A/M'),
('PS','AGM-65/MAVERICK'),
('PT','Integrated Air Missile Defense (IAMD) Phase I'),
('PU','Integrated Air Missile Defense (IAMD) Phase II'),
('Q0','Afghan Pakistan Hands (APH)'),
('Q1','Reserve #11'),
('Q2','Reserve #12'),
('Q3','Reserve #13'),
('Q4','Reserve #14'),
('Q5','Reserve #15'),
('Q6','Reserve #16'),
('Q7','USAF AMMOS Graduate'),
('Q8','Tier I USAF AMMOS Graduate Payback'),
('Q9','Tier II USAF AMMOS Graduate Payback'),
('QC','Radar Sensor Operations/Maintenance Evaluation'),
('QQ','ICBM Manpower/Personnel'),
('QR','ICBM Plans/Programs/ Requirements/Policy Stragegy'),
('QS','ICBM Inspections'),
('QT','ICBM Maintenance Mgt�Level I'),
('QU','ICBM Maintenance Mgt�Level II'),
('QV','ICBM Maintenance Mgt�Level III'),
('QW','Reserve #7'),
('QX','Reserve #8'),
('QY','Reserve #9'),
('QZ','Reserve #10'),
('RA','Requirements Manager Certification Training (RMCT) Level A'),
('RB','Requirements Manager Certification Training (RMCT) Level B'),
('RC','Requirements Manager Certification Training (RMCT) Level C'),
('RD','Medical Service Corps Readiness'),
('RJ','Requirements Manager Certification Training (RMCT) Level B Plus'),
('RK','Requirements Manager Certification Training (RMCT) Level C Plus'),
('RM','Medical Service Corps Resource Management'),
('RN','Air Support Radar Team (ASRT)'),
('S1','Space Shuttle Operations'),
('S2','Mission Control Complex (MCC) Operations'),
('S3','Cheyenne Mountain Complex, Missile Warning Center'),
('S4','Cheyenne Mountain Complex, Space Defense Operations Center'),
('S5','Cheyenne Mountain Complex, NORAD Space Surveillance Center'),
('SY','Medical Service Corps Information Management'),
('T0','Systems Management'),
('T1','Tactical Air Control System (TACS)'),
('T2','Low Observable'),
('T3','Strategic Mobility Operations'),
('T4','Tactical Airlift'),
('T5','Imagery Intelligence (IMINT)'),
('T6','Human Intelligence (HUMINT)'),
('T7','Collection Management'),
('T8','Signals Intelligence (SIGINT)'),
('T9','Measurement and Signature Intelligence (MASINT)'),
('TA','Western Europe'),
('TM','Targeting'),
('TN','Analysis'),
('TO','Space'),
('TP','Support to Ground Operations'),
('TQ','Force Management'),
('TS','Intelligence Surveillance and Reconnaissance (ISR) Operations'),
('TT','Cryptologic Career Program'),
('TU','Geospatial'),
('TV','Resource Management'),
('TW','Special Operations'),
('TX','Air-to-Air'),
('TY','Intelligence Resource Management'),
('TZ','Air-to-Ground'),
('U0','Medical Mishap Investigator'),
('U1','MAJCOM Level Readiness'),
('U2','ASTRA Officer'),
('U3','Mishap Investigator'),
('U4','Career Broadening Program'),
('U5','ANG Advisor'),
('U6','Service on a Joint or Combined Staff'),
('U7','Instructional Systems Development (ISD) Manager'),
('U8','Aerial Spray Operation'),
('U9','Maintenance Mishap Investigator'),
('UA','Instructor'),
('UB','Inspector'),
('UC','Certified Public Accountant'),
('UD','Human Relations'),
('UE','Education in Race Relations'),
('UF','Social Actions as Additional Duty'),
('UG','Command Experience/ Qualified AFSC Dual Mission'),
('UH','USAF Postal Experience'),
('UI','USAF Advance Agent for Presidential Trips'),
('UJ','Previous Experience as Primary Duty Protocol Officer'),
('UK','Contingency Planning Support Capability (CPSC) Experience'),
('UL','Airspace Management'),
('UM','Administrative Systems Management'),
('UN','Mishap Board President'),
('UO','Journalistic Experience'),
('UP','Drug and Alcohol Abuse Control'),
('UQ','Tactical Air Control System Direct Air Support Center/Air Support Operations Center (TACS DASC/ASOC)'),
('UR','Tactical Air Control System Airborne Battlefield Command and Control Center (TACS ABCCC)'),
('US','Aerial Combat Maneuvering Instrumentation (ACMI) Operator'),
('UT','Tactical Air Control System Tactical Air Control Center (TACS TACC)'),
('UU','Morale, Welfare, and Recreation (MWR)'),
('UV','Nonappropriated Fund Financial Management (NAFFM)'),
('UW','Air Base Ground Defense'),
('UX','Manned Spaceflight Engineer (MSE)'),
('UY','Payload Specialist (PS)'),
('UZ','Mission Qualified Payload Specialist (PS)'),
('V0','Reserved'),
('V1','Reserved'),
('V2','Reserved'),
('V3','Reserved'),
('V4','Reserved'),
('V5','Reserved'),
('V6','Reserved'),
('V7','Reserved'),
('V8','Reserved'),
('V9','Reserved'),
('VA','Professional Engineer or Architect'),
('VH','Special Technical Operations'),
('VR','Regional Experience, Eurasia � Level 2'),
('VS','Regional Experience, Latin America (LATAM) � Level 2'),
('VT','Regional Experience, Northeast Asia (NEA) � Level 2'),
('VU','Regional Experience, Southeast Asia (SEA) � Level 2'),
('VV','Regional Experience, Middle East/North Africa (MENA) � Level 2'),
('VW','Regional Experience, Sub-Saharan Africa (SSA) � Level 2'),
('VX','Regional Experience, Europe � Level 2'),
('VY','Regional Experience, South Asia (SA) � Level 2'),
('VZ','Regional Experience, China � Level 2'),
('W1','Nuclear Weapon System Acquisition'),
('W2','Cyberspace Operations - Computer Network Exploitation (CNE) Operator'),
('W3','Computer Network Operations Development Program (CNODP)'),
('WA','Nuclear Weapons Maintenance Mgt�Level I'),
('WB','Nuclear Weapons Maintenance Mgt�Level II'),
('WC','Nuclear Weapons Maintenance Mgt�Level III'),
('WD','Nuclear Strike Certification'),
('WE','Primary Nuclear Airlift Force (PNAF) Certification'),
('WF','Nuclear Security Level I (Flight) Qualified'),
('WG','Nuclear Mission Operations or Support (Level I)'),
('WH','Nuclear Mission Operations or Support (Level II)'),
('WI','Nuclear Command and Control'),
('WJ','Nuclear Experience #10'),
('WK','ICBM Codes'),
('WL','ICBM EWO Training'),
('WM','Nuclear Experience #13'),
('WN','ICBM OT&E'),
('WO','Nuclear Experience #15'),
('WP','Nuclear Experience #16'),
('WQ','Nuclear Experience #17'),
('WR','Nuclear Enterprise Experience Level 2'),
('WS','Nuclear Experience #19'),
('WT','Nuclear Experience #20'),
('WU','ICBM Maintenance Management-Level I'),
('WV','ICBM Maintenance Management-Level II'),
('WW','ICBM Maintenance Management-Level III'),
('WX','Aerial Nuclear Security'),
('WY','Nuclear Security Level II (Squadron/Group) Qualified'),
('WZ','Nuclear Security Level III (HHQ Policy) Qualified'),
('X1','Laser Beam Control'),
('X2','Laser System Optical Components'),
('X3','Nuclear Weapon Effects (Environment)'),
('X4','Econometrics'),
('X5','Operations Research/ Simulation Analysis'),
('X6','Personnel Measurement'),
('X7','Guidance and Counseling'),
('X8','Personnel and Training Research'),
('X9','International Programs'),
('XA','Economics'),
('XB','Nuclear Weapons'),
('XC','Survivability/ Vulnerability'),
('XD','Laser Development'),
('XE','E/O Guided/Designated Weapons'),
('XF','Electronic Components'),
('XG','Electromagnetic Waves'),
('XH','Infrared Techniques'),
('XI','Electrical Energy Sources'),
('XJ','Aerial Photographic Equipment'),
('XK','Optics and Photographic Materials'),
('XL','Propulsion Research'),
('XM','Fuels and Lubricants'),
('XN','Nonmetallic Materials'),
('XO','Cryogenic Devices'),
('XQ','Electroanalysis'),
('XR','Human Engineering'),
('XS','Fluid Mechanics'),
('XT','Gas Dynamics'),
('XU','Earth and Hydrospheric Science'),
('XV','Atmospheric Sciences'),
('XW','Sensors'),
('XX','Laser Effects/-Vulnerability/-Hardening'),
('XY','High/Low Energy Laser Integrator'),
('XZ','Laser Propagation'),
('Y0','Acquisition Security'),
('Y1','Control and Communication System'),
('Y2','Air Traffic Control Systems'),
('Y3','Surveillance and Navigation Systems'),
('Y4','NASA'),
('Y5','Reconnaissance Systems'),
('Y6','Information Transmission/Processing Systems'),
('Y7','Acquisition Logistics'),
('Y8','Production'),
('Y9','Manager of Small Programs/Project Manager'),
('YA','Security Assistance'),
('YB','Life Cycle Cost Analysis'),
('YC','Key Program Office Position'),
('YD','Configuration Management'),
('YE','Program Control'),
('YF','Program Analysis'),
('YG','Financial Manager'),
('YH','Financial Analyst'),
('YI','Field Test Manager'),
('YJ','System Deployment/Turnover'),
('YK','Systems Engineer'),
('YL','Subsystems Engineer'),
('YM','Integrated Logistics Support'),
('YN','Data Management'),
('YO','Human Factors'),
('YP','AFPRO'),
('YQ','Strategic Aircraft Systems'),
('YR','Tactical Aircraft Systems'),
('YS','Airlift Aircraft'),
('YT','V/STOL Aircraft Systems'),
('YU','Recon/Strike Electronic Warfare Systems'),
('YV','Tactical Missile Systems'),
('YW','Strategic Missile Systems'),
('YX','Satellite Communication System'),
('YY','Space Booster Systems'),
('YZ','Armament Systems'),
('Z1','Test Instrumentation Engineer'),
('Z2','Test Safety Engineer'),
('Z3','Parachutes, Aerial Delivery, and Recovery'),
('Z4','Life Support Equipment'),
('Z5','Crew Training Simulators'),
('Z6','Flight Engineer'),
('Z7','Aircraft Battle Damage Repair (ABDR) Engineer'),
('Z8','Air Combat Forensics'),
('ZA','Management Information Systems Manager'),
('ZB','Command and Management Systems'),
('ZC','Satellite Operations'),
('ZD','Satellite Systems/Mechanical Astronautical'),
('ZE','Satellite Systems/Electrical'),
('ZF','Performance/Mission Analysis Optimization'),
('ZG','Aircraft Design'),
('ZH','Manufacturing - Operations'),
('ZI','Manufacturing - Industrial Resources'),
('ZJ','Flight Test Engineer'),
('ZK','Multi Sensor Display Group (MSDG)'),
('ZL','Guidance and Control/Inertial'),
('ZM','Guidance and Control/Non-Inertial'),
('ZN','Propulsion - Air Breathing'),
('ZO','Propulsion-Space Vehicle'),
('ZP','Structural Analysis'),
('ZQ','Space Flight Mechanics'),
('ZR','Materials'),
('ZS','Reliability/ Maintainability'),
('ZT','Technical Intelligence'),
('ZU','Electronic Warfare Systems'),
('ZV','Packaging and Crating'),
('ZW','Computer Hardware'),
('ZX','Avionics'),
('ZY','Avionics Computer Program Development/ Modification'),
('ZZ','Ballistic Missile and Space Launch'),
('A','Acquisition of Systems'),
('B','Technical Acquisition of Systems'),
('C','Computer Systems'),
('D','Chaplain'),
('E','Engineering'),
('F','Security Forces'),
('H','Health'),
('I','Security'),
('J','International Skills'),
('L','Logistics'),
('M','Maintenance'),
('O','Operations'),
('P','Force Support'),
('R','Research'),
('S','Strategic Analysis'),
('T','Tactical Analysis'),
('U','Space'),
('W','Testing'),
('X','Planning, Programming, Budgeting'),
('Y','Not Applicable'),
('10','Infantry, Gun Crews, and Seamanship Specialists'),
('9700','Infantry, Gun Crews, and Seamanship Specialists'),
('101','Infantry'),
('11B','Infantryman'),
('11C','Indirect Fire Infantryman'),
('11H','Heavy Antiarmor Weapons Infantryman'),
('11L','Infantry Senior Sergeant'),
('11M','Fighting Vehicle Infantryman'),
('11Z','Infantry Senior Sergeant'),
('101000','Infantry, General'),
('99135','Combat Security Policeman'),
('99507','Combat Security Policeman'),
('0311','Rifleman'),
('0312','LAV Assaultman'),
('0313','Light Armored Vehicle (LAV) Crewman'),
('0317','Scout Sniper'),
('0321','Reconnaissance Man'),
('0323','Reconnaissance Man, Parachutist Qualified'),
('0324','Reconnaissance Man, Combatant Diver Qualified'),
('0326','Reconnaissance Man, Parachute and Combatant Diver Qualified'),
('0331','Machine Gunner'),
('0332','Gunner, Heavy Machinegun'),
('0341','Mortarman'),
('0351','Infantry Assaultman'),
('0352','Anti-tank Missileman'),
('0361','Anti-Tank/Assault Guided Missile Man'),
('0369','Infantry Unit Leader'),
('0372','Critical Skills Operator'),
('8023','Parachutist'),
('8024','Combatant Diver Marine'),
('8026','Parachutist/Combatant Diver Marine'),
('8541','Scout-Sniper'),
('8652','Reconnaissance Man, Parachutist Qualified'),
('8653','Reconnaissance Man, Combatant Diver Qualified'),
('8654','Reconnaissance Man, Parachute and Combatant Diver Qualified'),
('9952','Combatant Diver Marine'),
('9953','Parachutist/Combatant Diver Marine'),
('9962','Parachutist'),
('90BC','GWOT Support Assignment-Basic Combat Unit Member'),
('90CS','Expeditionary Force - Combat Skills'),
('90MM','GWOT IA/ILO Multi-National Force, Not Deployed'),
('90MN','Individual GWOT IA/ILO Multi-National Force'),
('90MS','Expeditionary - Maritime Security'),
('SB','Special Warfare Combatant - Craft Crewman Boat Captain'),
('18B','Special Forces Weapons Sergeant'),
('18C','Special Forces Engineer Sergeant'),
('18D','Special Forces Medical Sergeant'),
('18E','Special Forces Communications Sergeant'),
('18F','Special Forces Assistant Operations and Intelligence Sergeant'),
('18Z','Special Forces Senior Sergeant'),
('101100','Special Forces'),
('001720','Sea Air and Land (SEAL)'),
('001775','Special Warfare Combatant-Craft Crewman (SWCC)'),
('001782','Special Warfare Combatant-Craft Crewman Boat Captain (SWCC)'),
('001787','Special Warfare Combatant-Craft Crewman Patrol Officer (SWCC)'),
('5329','NSW Development and Evaluation Operator'),
('5350','Special Warfare Boat Operator (SB) Candidate'),
('5351','Special Warfare Combatant Crewman (SWCC) Intermediate'),
('5352','Special Warfare Combatant-craft Crewman (SWCC)'),
('5392','Naval Special Warfare Medic'),
('9533','Special Warfare Combatant Crewmember (SWCC)'),
('9534','Seal Delivery Vehicle (SDV) Team Technician'),
('9535','Advance Seal Delivery System Maintainer'),
('9557','Joint Special Operations'),
('9558','Fleet Tactical Deception Group (FLTDECGRU) Specialist'),
('SB','Special Warfare Boat Operator'),
('SO','Special Warfare Operator'),
('S','Special Operations Support Personnel'),
('101200','Military Training Instructor'),
('12100','Survival Training Manager'),
('12130','Survival Training Specialist'),
('12150','Survival Training Specialist'),
('12170','Survival Training Specialist'),
('12190','Survival Training Superintendent'),
('1T000','Survival, Evasion, Resistance, and Escape (SERE) Manager'),
('1T031','Survival, Evasion, Resistance, and Escape (SERE) Apprentice'),
('1T051','Survival, Evasion, Resistance, and Escape (SERE) Journeyman'),
('1T071','Survival, Evasion, Resistance, and Escape (SERE) Craftsman'),
('1T091','Survival, Evasion, Resistance, and Escape (SERE) Superintendent'),
('3P100','Combat Arms Training And Maintenance Manager'),
('3P131','Combat Arms Training And Maintenance Apprentice'),
('3P131A','Combat Arms Training And Maintenance Apprentice, Gunsmith'),
('3P151','Combat Arms Training And Maintenance Journeyman'),
('3P151A','Combat Arms Training And Maintenance Journeyman, Gunsmith'),
('3P171','Combat Arms Training And Maintenance Craftsman'),
('3P190','Combat Arms Training And Maintenance Superintendent'),
('75300','Combat Arms Training & Maintenance Manager'),
('75330','Combat Arms Training & Maintenance Specialist'),
('75350','Combat Arms Training & Maintenance Specialist'),
('75370','Combat Arms Training & Maintenance Specialist'),
('75391','Small Arms Superintendent'),
('75399','Combat Arms Training & Maintenance Superintendent'),
('8B000','Military Training Instructor'),
('8B100','Military Training Leader'),
('8B200','Academy Military Training NCO'),
('8T000','Professional Military Education Instructor'),
('92100','Survival Training Manager'),
('92130','Survival Training Specialist'),
('92150','Survival Training Specialist'),
('92170','Survival Training Specialist'),
('99128','Military Training Instructor'),
('99138','Student Training Advisor'),
('99502','Military Training Instructor'),
('99600','Military Training Manager'),
('99605','Professional Military Education Instructor'),
('0911','Drill Instructor'),
('0913','Marine Combat Instructor'),
('0916','Martial Arts Instructor'),
('0917','Martial Arts Instructor-Trainer'),
('0918','Water Safety/Survival Instructor'),
('0931','Marksmanship Instructor'),
('0932','Small Arms Weapons Instructor'),
('0933','Marksmanship Coach'),
('8077','Weapons and Tactics Instructor (WTI)'),
('8511','Drill Instructor'),
('8512','Drill Sergeant'),
('8513','Marine Combat Instructor'),
('8530','Marksmanship Coach'),
('8531','Marksmanship Instructor'),
('8532','Small Arms Weapons Instructor'),
('8551','Martial Arts Instructor'),
('8552','Martial Arts Instructor-Trainer'),
('8563','Water Safety/Survival Instructor'),
('0811','Small Arms Marksmanship Instructor'),
('0812','Small Arms Marksmanship Instructor'),
('0814','Crew Served Weapons (CSW) Instructor'),
('7354','Master Naval Parachutist'),
('90ES','GWOT IA/ILO Embedded Military Mobile Training Team, Not Deployed'),
('90ET','Expeditionary Security Force Advisor/Trainer'),
('90MT','GWOT Support Assignment-Military Transition Team/Iraq Assistance Group'),
('90NI','GWOT IA/ILO Combat Training (NIACT)-Deployed'),
('90NJ','GWOT IA/ILO Combat Training (NIACT)-Not Deployed'),
('9501','Anti-Terrorism Training Supervisor Instructor'),
('9501','Learning Center Instructor'),
('9502','Instructor'),
('9504','Aviation Water Survival Instructor'),
('9505','Survival, Evasion, Resistance, & Escape (SERE) Instructor'),
('9508','Recruit/Assistant Recruit Company Commander/Recruit Instructor'),
('9510','Basic Swimming and Water Survival Instructor'),
('9518','Professional Development Instructor'),
('9536','Naval Special Warfare Small Arms Organizational Level Maintenance Technician'),
('9554','Master Naval Parachutist'),
('8','Instructor'),
('H','Instructor'),
('102','Armor and Amphibious'),
('11E','Armor Crewman'),
('19E','M48-M60 Armor Crewman'),
('19F','M48/M60 Tank Driver'),
('19G','Armor Reconnaissance Vehicle Crewman'),
('19H','Armor Reconnaissance Vehicle Driver'),
('19J','M60A2 Armor Crewman'),
('19K','M1 Armor Crewman'),
('19L','XM1 Tank Driver'),
('19Z','Armor Senior Sergeant'),
('102000','Armor and Amphibious, General'),
('5707','Tank Driving'),
('1811','M60A1 Tank Crewman'),
('1812','M1A1 Tank Crewman'),
('1833','Assault Amphibious Vehicle (AAV) Crewman'),
('1834','Amphibious Combat Vehicle (ACV) Crewman'),
('0110','IMA Rigging and Weight Testing Shop Journeyman'),
('0120','NAMTS Rigger/Weight Tester'),
('9539','Patrol Combatant Missile (Hydrofoil) (PHM) Technician'),
('103','Combat Engineering'),
('12A','Engineer Senior Sergeant'),
('12A','Pioneer'),
('12B','Combat Engineer'),
('12B','Combat Engineer'),
('12C','Bridge Crewmember'),
('12C','Bridge Crewmember'),
('12D','Powered Bridge Specialist'),
('12E','Atomic Demolition Munitions Specialist'),
('12F','Engineer Tracked Vehicle Crewman'),
('12Z','Combat Engineering Senior Sergeant'),
('12Z','Combat Engineering Senior Sergeant'),
('17E','Field Illumination Crewman'),
('21B','Combat Engineer'),
('21C','Bridge Crewmember'),
('21Z','Combat Engineering Senior Sergeant'),
('54A','Chemical Operations Assistant'),
('54C','Smoke Operations Specialist'),
('103000','Combat Engineering, General'),
('0481','Landing Support Specialist'),
('0843','Searchlight Man'),
('1371','Combat Engineer'),
('1372','Assault Breacher Vehicle (ABV)/Armored Vehicle Launched Bridge (AVLB) Crewman'),
('1381','Shore Party Specialist'),
('104','Artillery/Gunnery, Rockets, and Missiles'),
('13A','Field Artillery Basic'),
('13B','Cannon Crewmember'),
('13Y','Cannon/Missile Senior Sergeant'),
('13Z','Field Artillery Senior Sergeant'),
('16L','SGT YORK Air Defense Gun Crewmember'),
('16R','VULCAN Crewmember'),
('GM','Gunner''s Mate'),
('104100','Artillery and Gunnery'),
('0811','Field Artillery Cannoneer'),
('0812','Field Artillery Nuclear Projectileman'),
('0842','Field Artillery Radar Operator'),
('0844','Field Artillery Fire Control Man'),
('0846','Artillery Scout Observer'),
('0848','Field Artillery Operations Man'),
('0849','Shore Fire Control Party Man'),
('0891','Field Artillery Chief'),
('0894','Observer Liaison Chief'),
('9813','GCS Payload Operator'),
('003730','Weapons Administrator'),
('003731','Weapons Delivery System Technician'),
('003732','Small Arms Technician'),
('0756','Ordnance Management Specialist'),
('0801','IMA Ordnance Journeyman'),
('0814','Minor Caliber Gun System Specialist'),
('0857','25mm Machine Gun System (MGS) MK 38 MOD Gun Weapon System (GWS) Technician'),
('0871','3"/50 Rapid Fire Mount (Single or Twin) Maintenanceman'),
('0876','5"/54 Mount MK 42 MOD 9/10 Maintenanceman'),
('0877','5"/54 Mount MK 45 MOD 0 Maintenanceman'),
('0878','MK-75 Operator/Maintainer'),
('0879','5"/54 Caliber Gun System MK 45 Mod 1 and 2 Maintenanceman'),
('0880','5"/62-Caliber MK 45 MOD 4 Gun Mount Maintenance'),
('0882','76MM/62 Caliber Gun Mount MK75 MODs 0/1 Adv Maint Technician'),
('0891','ASROC Launching Group MK-16 Maintenanceman'),
('0893','ASROC Weapons Handling System Maintenanceman'),
('0979','MK-41 VLS Baseline IV through VII Technician'),
('0983','MK 41 Vertical Launching System (VLS) Advanced Technician'),
('90CR','GWOT Support Assignment-Counter Rocket Artillery and Mortar (C-RAM)'),
('9540','Stinger Anti-Terrorist Weapon (ATW) Operator Maintenanceman'),
('GM','Gunner''s Mate'),
('GMG','Gunner''s Mate G (Guns)'),
('GMM','Gunner''s Mate M (Missiles)'),
('13M','Multiple Launch Rocket System (MLRS)/High Mobility Artillery Rocket System (HIMARS) Crewmember'),
('13M','Multiple Launch Rocket System (MLRS) Crewmember'),
('15D','LANCE Crewmember/MLRS Sergeant'),
('15F','HONEST JOHN Rocket Crew Member'),
('104200','Rocket Artillery'),
('13N','LANCE Crewmember'),
('13P','Multiple Launch Rocket System (MLRS) Operations/Fire Direction Specialist'),
('14D','HAWK Missile System Crewmember'),
('14E','PATRIOT Fire Control Enhanced Operator/Maintainer'),
('14G','Air Defense (AD) Battle Management System Operator'),
('14H','Air Defense (AD) Enhanced Early Warning System Operator'),
('14J','Air Defense Command, Control, Communications, Computers and Intelligence Tactical Operations Center Enhanced Operator/Maintainer'),
('14M','Man Portable Air Defense System Crewmember (RC)'),
('14R','BRADLEY LINEBACKER Crewmember'),
('14S','Air and Missile Defense (AMD) Crewmember'),
('14T','PATRIOT Launching Station Enhanced Operator/Maintainer'),
('14X','Space and Missile Defense Operations'),
('14Z','Air Defense Artillery Senior Sergeant'),
('15B','SERGEANT Missile Crewman'),
('15E','PERSHING Missile Crewmember'),
('15J','MLRS/LANCE Operational/Fire Direction Specialist'),
('15Z','Field Artillery Missile-Rocket Senior Sergeant'),
('16B','HERCULES Missile Crew Member'),
('16C','HERCULES Fire Control Crewman'),
('16D','HAWK Missile Crewmember'),
('16E','HAWK Fire Control Crewmember'),
('16F','Light Air Defense Artillery Crewmember (Reserve Forces)'),
('16G','ROLAND Systems Crewmember (Reserve Forces)'),
('16P','CHAPARRAL Crewmember'),
('16S','Man Portable Air Defense Systems (MANPADS) Crewmember'),
('16T','PATRIOT Missile Crewmember'),
('16Z','Air Defense Artillery Senior Sergeant'),
('104300','Missile Artillery, Operating Crew'),
('0814','High Mobility Artillery Rocket System (HIMARS) Operator'),
('105','Air Crew'),
('105000','Air Crew, General'),
('11100','Defensive Aerial Gunner Manager'),
('11130','Defensive Aerial Gunner'),
('11150','Defensive Aerial Gunner'),
('11170','Defensive Aerial Gunner'),
('11190','Defensive Aerial Gunner Superintendent'),
('11200','In-Flight Refueling Manager'),
('11230','In-Flight Refueling Operator'),
('11250','In-Flight Refueling Operator'),
('11270','In-Flight Refueling Operator'),
('11290','In-Flight Refueling Superintendent'),
('11300','Flight Engineer Manager'),
('11330','Flight Engineer'),
('11350','Flight Engineer'),
('11370','Flight Engineer'),
('11399','Flight Engineer Superintendent'),
('11400','Aircraft Loadmaster Manager'),
('11430','Aircraft Loadmaster'),
('11450','Aircraft Loadmaster'),
('11470','Aircraft Loadmaster'),
('11490','Aircraft Loadmaster Superintendent'),
('11500','Pararescue/Recovery Manager'),
('11530','Pararescue/Recovery Specialist'),
('11550','Pararescue/Recovery Specialist'),
('11570','Pararescue/Recovery Specialist'),
('11590','Pararescue/Recovery Superintendent'),
('1A000','In-Flight Refueling Manager'),
('1A031','In-Flight Refueling Apprentice'),
('1A051','In-Flight Refueling Journeyman'),
('1A071','In-Flight Refueling Craftsman'),
('1A091','In-Flight Refueling Superintendent'),
('1A100','Flight Engineer Manager'),
('1A131','Flight Engineer Apprentice'),
('1A131B','Flight Engineer Apprentice, Helicopter'),
('1A131C','Flight Engineer Apprentice, Performance Qualified'),
('1A151','Flight Engineer Journeyman'),
('1A151B','Flight Engineer Journeyman, Helicopter'),
('1A151C','Flight Engineer Journeyman, Performance Qualified'),
('1A171','Flight Engineer Craftsman'),
('1A171B','Flight Engineer Craftsman, Helicopter'),
('1A171C','Flight Engineer Craftsman, Performance Qualified'),
('1A190','Flight Engineer Superintendent'),
('1A191','Flight Engineer Superintendent'),
('1A200','Aircraft Loadmaster Manager'),
('1A231','Aircraft Loadmaster Apprentice'),
('1A251','Aircraft Loadmaster Journeyman'),
('1A271','Aircraft Loadmaster Craftsman'),
('1A291','Aircraft Loadmaster Superintendent'),
('1A900','Special Missions Aviation Manager'),
('1A931','Special Missions Aviation Apprentice'),
('1A951','Special Missions Aviation Journeyman'),
('1A971','Special Missions Aviation Craftsman'),
('1A991','Special Missions Aviation Superintendent'),
('1T200','Pararescue Manager'),
('1T231','Pararescue Apprentice'),
('1T251','Pararescue Journeyman'),
('1T271','Pararescue Craftsman'),
('1T291','Pararescue Superintendent'),
('8S100','Sensor Operator'),
('99134','Combat Information Monitor'),
('99140','Sensor Operator'),
('99506','Combat Information Monitor'),
('99602','Sensor Operator'),
('6030','Aircraft Flight Mechanic, KC-130'),
('6032','Aircraft Flight Engineer, KC-130'),
('6167','Helicopter Crew Chief'),
('6172','Helicopter Crew Chief, CH-46'),
('6173','Helicopter Crew Chief, CH-53'),
('6174','Helicopter Crew Chief, UH-1'),
('6175','Tiltrotor Crew Chief, MV-22'),
('6176','Tiltrotor Crew Chief, MV-22'),
('6176','Helicopter Crew Chief, V-22'),
('6177','Weapons and Tactics Crew Chief Instructor'),
('6177','Weapons and Tactics Crew Chief Instructor'),
('6178','VH-60N Presidential Helicopter Crew Chief'),
('6179','VH-3D Presidential Helicopter Crew Chief'),
('6181','VH-XX Presidential Helicopter Crew Chief'),
('6199','Enlisted Aircrew/Aerial Observer/Gunner'),
('6232','Fixed-Wing Aircraft Flight Mechanic, KC-130'),
('6241','Fixed-Wing Aircraft Flight Engineer, KC-130 Trainee'),
('6242','Fixed-Wing Aircraft Flight Engineer, KC-130'),
('6243','Fixed-Wing Transport Aircraft Specialist, C-9'),
('6244','Fixed-Wing Transport Aircraft Specialist, C-12'),
('6246','Fixed-Wing Transport Aircraft Specialist, C-20'),
('6247','Fixed-Wing Transport Aircraft Specialist, UC-35'),
('6276','Fixed-Wing Aircraft Crew Chief, KC-130'),
('7312','Fixed-Wing Transport Aircraft Specialist, KC-130J'),
('8972','Aircrew Trainee'),
('9972','Aircrew Trainee'),
('9973','Fixed-Wing Transport Aircraft Specialist, KC-130J')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 8...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('001590','Airborne Communicator'),
('001595','Air Warfare Systems Engineer'),
('001610','In-flight Technician'),
('002539','Aircrew Readiness Manager'),
('0170','Surface Rescue Swimmer'),
('7352','Senior Naval Parachutist'),
('7356','Aircrew Survival Equipmentman (IMA) Technician'),
('7801','Naval Aircrewman Candidate'),
('7805','MH-60S Multi-Mission Helicopter Aircrewman'),
('7807','HH-60H Utility Aircrewman'),
('7811','Helicopter Utility Aircrewman'),
('7815','Helicopter Search and Rescue Aircrew Swimmer'),
('7841','P-3C UPDATE III Acoustic Sensor Operator'),
('7842','P8-A Acoustic Systems Specialist Aircrewman'),
('7862','P8-A Electronic Warfare Operator Aircrewman'),
('7873','SH60B Multi Sensor Operator'),
('7875','MH-60R Multi Mission Helicopter Aircrewman'),
('7876','SH-60F/HH-60H Multi-Sensor Operator'),
('7885','MH-53 Utility Aircrewman'),
('7886','MH-53 Airborne Mine Countermeasures (AMCM) Aircrewman'),
('8201','Naval Aircrewman Candidate'),
('8202','Naval Aircrewman (Special Assignment)'),
('8204','C-9 Loadmaster'),
('8205','MH-60S Multi-Mission Helicopter Aircrewman'),
('8206','C-130 Flight Mechanic'),
('8208','C-130 Second Loadmaster'),
('8209','C-40A Crew Chief'),
('8210','Weapons and Tactics Instructor'),
('8211','Helicopter Utility Aircrewman'),
('8215','Helicopter Search and Rescue Aircrew Swimmer'),
('8216','H-46 Utility Aircrewman'),
('8220','C-130 Loadmaster'),
('8225','MH-53 Utility Aircrewman'),
('8226','MH-53 Airborne Mine Countermeasures (AMCM) Aircrewman'),
('8227','E-6B REEL System Operator'),
('8228','E-6B Communications Operator'),
('8229','E-6B Airborne Communications Technician'),
('8235','E-6B Flight Engineer'),
('8241','C-12/C26 Transport Aircrewman'),
('8243','A-3 Plane Captain/Crew Chief'),
('8244','A-3 Crewman/Navigator'),
('8245','C-20/C-37 Crew Chief'),
('8250','C-9 Crew Chief'),
('8251','P-3 Flight Engineer'),
('8252','C-130 Flight Engineer'),
('8258','Transport Flight Crew Plan Captain'),
('8261','P-3/EP-3J In-Flight Technician'),
('8262','P-3C UPDATE III In-Flight Technician'),
('8263','P-3C In-Flight Technician'),
('8265','P-3/C-37 Flight Communications Operator'),
('8267','E-2B AEW Flight Technician'),
('8269','Flight Electronics Technician'),
('8271','P-3 Flight Crew Ordnanceman'),
('8272','P-3C Update IV Inflight Maintenance Technician'),
('8279','C-2 Transport Aircrewman'),
('8284','Aviation Electronic Warfare Operator'),
('8289','Second Loadmaster'),
('8296','EP-3E Cryptologic Technician Operator/Analyst'),
('9401','EP-3E In-flight Technician'),
('9402','P-3C UPDATE III ASUW Improvement Program (AIP) In-Flight Technician'),
('AW','Naval Aircrewman'),
('AWF','Naval Aircrewman Mechanical'),
('AWO','Naval Aircrewman Operator'),
('AWR','Naval Aircrewman Tactical Helicopter'),
('AWS','Naval Aircrewman Helicopter'),
('AWV','Naval Aircrewman Avionics'),
('620','Aviation Pilot'),
('771','Light Plane Pilot'),
('105100','Pilots and Navigators'),
('7372','Tactical Systems Operator/Mission Specialist'),
('106','Seamanship'),
('100','Boatswain''s Mate'),
('BM','Boatswain''s Mate'),
('106000','Boatswains'),
('3507','Deckhand-Sailor'),
('5724','Ship Operating'),
('5782','Ship Operating'),
('5788','Deckhand'),
('9811','Boatswain'),
('9812','Boatswain (Freighter)'),
('9820','Boatswain''s Mate'),
('9821','Boatswain''s Mate (Heavy Lift Operator)'),
('9822','Boatswain''s Mate (Day)'),
('9823','Boatswain''s Mate (Watch)'),
('9825','Able Seaman'),
('9894','Deckhand-Seaman'),
('9920','Boatswain'),
('9923','Boatswain''s Mate'),
('9924','Able Seaman'),
('9928','Ordinary Seaman'),
('8111','Combat Rubber Reconnaissance Craft (CRRC) Coxswain'),
('003720','Ships and Boats Mate'),
('003721','Ordinary Seaman'),
('003722','Able Seaman'),
('003806','Landing Craft Air Cushion Operator/Navigator'),
('0107','Minesweeping Boatswain''s Mate'),
('0108','Non-Diving Salvage/Towing Operator'),
('0114','Stevedore'),
('0121','NAMTS Rigger/Weight Tester'),
('0171','Landing Craft Utility Craftsmaster'),
('0172','LCAC Loadmaster'),
('0181','Navy Lighterage Deck Supervisor'),
('9570','Maritime Cargo Handling Specialist: Supervisory'),
('BM','Boatswain''s Mate'),
('110','Quartermaster'),
('106100','Navigators'),
('9808','Alaska Pilot'),
('9896','Pilot'),
('9904','Ship Pilot'),
('9926','Quartermaster'),
('003743','Navigation Administrator'),
('003744','Navigation Specialist'),
('003745','Navigation Manager'),
('0202','Assistant Navigator'),
('0207','LCAC Radar Operator/Navigator'),
('0215','Harbor/Docking Pilot'),
('0216','Harbor/Docking Pilot Trainee'),
('0304','LCAC Radar Operator/Navigator'),
('QM','Quartermaster'),
('61A','Seaman'),
('61B','Watercraft Operator'),
('61D','Amphibian Operator'),
('61Z','Marine Senior Sergeant'),
('88K','Watercraft Operator'),
('88Y','Marine Senior Sergeant'),
('106200','Small Boat Operators'),
('2B031','Seaman'),
('2B051','Seaman'),
('2B071','Seaman'),
('59130','Seaman'),
('59150','Seaman'),
('59170','Boatmaster'),
('5723','Boat Operating'),
('5784','Riverboat Operating'),
('5786','Small Craft Operating'),
('0312','Riverine Assault Craft (RAC) Crewman'),
('0314','Rigid Raiding Craft (RRC)/Rigid Hull Inflatable Boat (RHIB) Coxswain'),
('0316','Combat Rubber Reconnaissance Craft (CRRC) Coxswain'),
('8112','Riverine Assault Craft (RAC) Crewman'),
('002648','Boat Crew Specialist'),
('003802','Landing Craft Air Cushion Craftmaster'),
('0160','Causeway Barge Ferry Pilot'),
('0161','Tugmaster'),
('0162','Yard Craft Boat Captain/Craftmaster'),
('0163','Minesweeper Boat Captain'),
('0164','Patrol Boat Coxswain'),
('0165','Landing Craft Utility Captain'),
('0166','Causeway Craftmaster'),
('0167','LCAC Operator'),
('0168','Torpedo Retriever/Torpedo Weapon Retriever (TR/TWR) Craft Master'),
('0169','Causeway Barge Ferry Coxswain'),
('0180','Causeway Lighterage Craftmaster'),
('0190','Force Protection Boat Coxswain'),
('9562','Deep Submergence Vehicle Operator'),
('9563','Deep Submergence Vehicle Crewmember'),
('106300','Seamanship, General'),
('5734','Wheel Operating'),
('9801','Miscellaneous Vessel Jobs'),
('9901','Miscellaneous Vessel Jobs'),
('002690','Seaman'),
('SN','Seaman'),
('107','Installation Security'),
('107000','Security Guards'),
('81130','Security Specialist'),
('81150','Security Specialist'),
('81170','Security Specialist'),
('0085','Security Guard'),
('0085','Security Guard'),
('5816','Special Reaction Team (SRT) Member'),
('8151','Guard'),
('8152','Marine Corps Security Force (MCSF) Guard'),
('8153','Marine Corps Security Force (MCSF) Cadre Trainer'),
('8154','Marine Corps Security Force (MCSF) Close Quarters Battle (CQB) Team Member'),
('8156','Marine Security Guard (MSG)'),
('002649','Camp/Convoy Security Specialist'),
('002650','Boarding Specialist'),
('003767','Security Support Specialist'),
('2005','Dog Handler'),
('2008','Afloat Corrections Specialist'),
('2009','Protective Service Specialist'),
('9541','Patrol Dog Handler'),
('9542','Drug Detector Dog Handler'),
('9543','Patrol/Explosive Detector Dog Handler'),
('9544','Kennel Master'),
('9545','Navy Law Enforcement Specialist'),
('9546','Supervisory Security Specialist'),
('108','Unmanned Vehicle System (UVS) Operation'),
('15W','Unmanned Aerial Vehicle (UAV) Operator'),
('35K','Unmanned Aerial Vehicle (UAV) Operator'),
('96U','Unmanned Aerial Vehicle Operator'),
('108000','Unmanned Vehicle System (UVS) Operators, General'),
('1U000','Remotely Piloted Aircraft (RPA) Sensor Operator Manager'),
('1U031','Remotely Piloted Aircraft (RPA) Sensor Operator Apprentice'),
('1U051','Remotely Piloted Aircraft (RPA) Sensor Operator Journeyman'),
('1U071','Remotely Piloted Aircraft (RPA) Sensor Operator Craftsman'),
('1U091','Remotely Piloted Aircraft (RPA) Sensor Operator Superintendent'),
('7314','Unmanned Aircraft System (UAS) Operator'),
('7316','External Unmanned Aerial Vehicle (UAV) Operator'),
('7374','Vertical Takeoff Unmanned Aerial Vehicle Specialist'),
('7377','Weapons and Tactics Instructor (WTI) Unmanned Aircraft Systems'),
('9814','External Unmanned Aerial Vehicle (UAV) Operator'),
('9974','Vertical Takeoff Unmanned Aerial Vehicle Specialist'),
('7828','Planning Series - MQ-4C Unmanned Aircraft System (UAS) Mission Payload Operator'),
('8362','Unmanned Aerial Vehicle (UAV) External Pilot'),
('8363','Unmanned Aerial Vehicle (UAV) Internal Pilot'),
('8364','Unmanned Aerial Vehicle (UAV) Payload Operator'),
('8367','MQ-8B Mission Payload Operator (MPO)'),
('8368','MQ-8B Air Vehicle Operator (AVO)'),
('8369','Planning Series - RQ-21A Operator'),
('90UV','Expeditionary Force - Unmanned Systems (UAV/USV/USG) Operator'),
('9550','Unmanned Undersea Vehicle (UUV) Operator'),
('11','Electronic Equipment Repairers'),
('9710','Electronic Equipment Repairman'),
('110','Radio/Radar'),
('240','Electronics Technician'),
('250','Electronics Technician Communications'),
('261','Electronics Technician Radar'),
('330','Electronics Technician - Watchstander'),
('ET','Electronics Technician'),
('110000','Radio/Radar, General'),
('2E131','Satellite, Wideband and Telemetry Systems Apprentice'),
('2E151','Satellite, Wideband and Telemetry Systems Journeyman'),
('2E171','Satellite, Wideband and Telemetry Systems Craftsman'),
('6312','Aircraft Communications/Navigation/Electrical/Weapon Systems Technician, A-4/TA-4/OA-4'),
('6312','Aircraft Communications/Navigation/Radar Systems Technician, AV-8'),
('6313','Aircraft Communications/Navigation/Radar System Technician, EA-6'),
('6314','Aircraft Communications/Navigation/Electrical/Weapon/DECM Systems Technician RF-4/F-4'),
('6315','Aircraft Communications/Navigation/Weapon Systems Technician, AV-8'),
('6316','Aircraft Communications/Navigation Systems Technician, KC-130'),
('6317','Aircraft Communications/Navigation/Radar Systems Technician, F/A-18'),
('6318','Aircraft Communications/Navigation/Radar Systems Technician F-35'),
('6318','Aircraft Communications/Navigation/Electrical Weapons Systems Technician OV-10'),
('6322','Aircraft Avionics Technician, CH-46'),
('6323','Aircraft Avionics Technician, CH-53'),
('6324','Aircraft Avionics Technician, U/AH-1'),
('6325','Aircraft Communications/Navigation/Electrical/Weapons Systems Technician, V-22'),
('6326','Aircraft Avionics Technician, V-22'),
('6391','Avionics Chief'),
('6411','Aircraft Communications/Navigation Systems Technician Trainee, IMA'),
('6412','Aircraft Communications Systems Technician, IMA'),
('6413','Aircraft Navigation Systems Technician, IFF/RADAR/TACAN, IMA'),
('6422','Aircraft Cryptographic Systems Technician, IMA'),
('6472','Consolidated Automated Support System (CASS), Electro-Optical (EO)/Forward Looking Infrared Tech (FLTR)'),
('6473','Consolidated Automated Support System High Power/Radar Technician'),
('6612','Aircraft Comm./Navigation Systems Technician, Helicopter/OV-10'),
('6613','Aircraft Comm./Navigation Systems Technician, Transport/Utility'),
('6614','Aircraft Comm./Navigation Systems Technician, A-4/TA-4/A-6/EA-6'),
('6615','Aircraft Communications/Navigation Systems Technician, AV-8'),
('6616','Aircraft Communications/Navigation Systems Technician, RF-4/F-4'),
('6617','Aircraft Communications Systems Technician, IMA'),
('6622','Aircraft Cryptographic Systems Technician, IMA'),
('6623','A/C Passive Electronic Countermeasures Systems Technician, EA-6'),
('6624','A/C Active Electronic Countermeasures Systems Technician, EA-6'),
('6691','Avionics Maintenance Chief'),
('001215','Communications Operator'),
('001220','Communications Manager'),
('001227','Communications Technician'),
('003723','Electronics Communications Technician'),
('003724','Electronics Data Systems Technician'),
('003725','Electronics Radar Systems Technician'),
('003726','Electronics Systems Manager'),
('003779','Submarine Reactor Controls Operator'),
('003780','Surface Reactor Controls Operator'),
('003787','Submarine Reactor Controls Supervisor'),
('003788','Surface Reactor Controls Supervisor'),
('003795','Submarine Reactor Controls Manager'),
('003796','Surface Reactor Controls Manager'),
('0345','Joint Tactical Ground Station (JTAGS)/Multi-Mission Mobile Processor (M3P) System Operator/Maintainer'),
('1501','Electronics Technician Trainee (Radar)'),
('1591','Minature/Microminature Module Test and Repair (2MTR) Technician'),
('9503','Miniature/Microminiature Electronic Repair Inspector'),
('9509','2M Instructor/Master Inspector'),
('9526','Microminiature Electronic Repair Technician'),
('9527','Miniature Electronic Repair Technician'),
('AV','Avionics Technician'),
('AV','Master Chief Avionics Maintenance Technician'),
('ET','Electronics Technician'),
('ET(NUC)','Electronics Technician (Nuclear)'),
('ET(SUB)','Electronics Technician (Submarine)'),
('ET(SURF)','Electronics Technician (Surface)'),
('ET(V)','Electronics Technicians (Navigation)'),
('ETN','Electronics Technician N (Communications)'),
('ETR','Electronics Technician R (Radar)'),
('25P','Microwave Systems Operator-Maintainer'),
('25U','Signal Support Systems Specialist'),
('26L','Tactical Microwave Systems Repairer'),
('26V','Strategic Microwave Systems Repairer'),
('29E','Radio Repairer'),
('29M','Tactical Satellite/Microwave Repairer'),
('29T','Satellite/Microwave Communications Chief'),
('29V','Microwave Systems Operator/Repairer'),
('29W','Electronics Maintenance Supervisor'),
('29X','Communications Equipment Maintenance Chief'),
('29Z','Electronics Maintenance Chief'),
('31B','Field Communications-Electronics Equipment Mechanic'),
('31E','Field Radio Repairer'),
('31G','Tactical Communications Chief'),
('31P','Microwave Systems Operator-Maintainer'),
('31U','Signal Support Systems Specialist'),
('31V','UL Communications Maintainer'),
('31X','Communications Systems Circuit Control Supervisor'),
('32D','Communications Systems Circuit Controller'),
('32E','Fixed Plant Carrier Repairman'),
('32H','Fixed Station Radio Repairer'),
('32Z','Communications-Electronics Maintenance Chief'),
('35E','Radio and Communications Security (COMSEC) Repairer'),
('35W','Electronic Maintenance Chief'),
('35Z','Senior Electronics Maintenance Chief'),
('39W','Radar Special Electronic Devices Maintenance Chief'),
('39X','Electronic Equipment Maintenance Chief'),
('94E','Radio and Communications Security (COMSEC) Repairer'),
('94W','Electronic Maintenance Chief'),
('94Z','Senior Electronic Maintenance Chief'),
('110100','Communications Radio'),
('11831','Airborne Command & Control Communications Equipment Specialist'),
('11851','Airborne Command & Control Communications Equipment Specialist'),
('11871','Airborne Command & Control Communications Equipment Specialist'),
('1A532','Airborne Command And Control Communications Equipment'),
('1A552','Airborne Command And Control Communications Equipment'),
('1A572','Airborne Command And Control Communications Equipment'),
('1B100','Cyber Systems Manager'),
('1B133','RF Transmission Systems Apprentice'),
('1B153','RF Transmission Systems Journeyman'),
('1B173','RF Transmission Systems Craftsman'),
('1B190','Cyber Systems Superintendent'),
('1C800','Ground Radar/Airfield Systems Maintenance Manager'),
('1C890','Ground Radar/Airfield Systems Maintenance Superintendent'),
('2A136','Airborne Command Post Communications Equipment'),
('2A156','Airborne Command Post Communications Equipment'),
('2A176','Airborne Command Post Communications Equipment'),
('2E000','Communications Systems Manager'),
('2E133','Ground Radio Communications Apprentice'),
('2E153','Ground Radio Communications Journeyman'),
('2E173','Ground Radio Communications Craftsman'),
('2E190','Communications Systems Superintendent'),
('30100','Communications-Electronics Systems Manager'),
('30430','Wideband Communications Equipment Specialist'),
('30434','Ground Radio Communications Specialist'),
('30436','Satellite Communication Systems Equipment Specialist'),
('30450','Wideband Communications Equipment Specialist'),
('30454','Ground Radio Communications Specialist'),
('30456','Satellite Communication Systems Equipment Specialist'),
('30470','Wideband Communications Equipment Specialist'),
('30474','Ground Radio Communications Specialist'),
('30476','Satellite Communication Systems Equipment Specialist'),
('30496','Ground Radio Communications Superintendent'),
('30499','Communications Systems Superintendent'),
('30700','Telecommunications Systems Control Manager'),
('30730','Telecommunications Systems Control Specialist'),
('30750','Telecommunications Systems Control Specialist'),
('30770','Telecommunications Systems Control Specialist'),
('32830','Avionic Communications Specialist'),
('32835','Airborne Command Post Communications Equipment Specialist'),
('32850','Avionic Communications Specialist'),
('32855','Airborne Command Post Communications Equipment Specialist'),
('32870','Avionic Communications Specialist'),
('32875','Airborne Command Post Communications Equipment Specialist'),
('3D100','Cyberspace Support Manager'),
('3D133','RF Transmission Systems Apprentice'),
('3D153','RF Transmission Systems Journeyman'),
('3D173','RF Transmission Systems Craftsman'),
('3D190','Cyberspace Support Superintendent'),
('45536','Airborne Command Post Communications Equipment Specialist'),
('45556','Airborne Command Post Communications Equipment Specialist'),
('45576','Airborne Command Post Communications Equipment Specialist'),
('9995','Chief, Radio Electronics Technician'),
('9997','First Radio Electronics Technician'),
('9999','Second Radio Electronics Technician'),
('2821','Technical Controller'),
('2822','Electronic Switching Equipment Technician'),
('2823','Technical Control Chief'),
('2831','Digital Wideband Systems Maintainer'),
('2832','AN/TRC-170 Technician'),
('2833','Fleet Satellite Terminal Technician'),
('2834','Advanced Extremely High Frequency (AEHF) Technician'),
('2841','Ground Electronics Transmission Systems Maintainer'),
('2841','Ground Radio Repairer'),
('2843','PLRS Support Maintenance Technician'),
('2844','Ground Communications Organizational Repairer'),
('2845','Ground Organizational Radio Repairer'),
('2846','Ground Radio Intermediate Repairer'),
('2847','Ground Electronics Telecommunications and Information Technology Systems Maintainer'),
('2851','Aviation Radio Repairman'),
('2853','Aviation Meteorological Equipment Repairman'),
('2861','Radio Technician'),
('2862','Ground Electronics Systems Maintenance Technician'),
('2864','Satellite Terminal Technician'),
('2866','Aviation Radio Technician'),
('2867','AN/TSC-120 Radio Technician'),
('5937','Aviation Radio Repairer'),
('5938','Aviation Meteorological Equipment Technician'),
('5939','Aviation Communication Systems Technician'),
('6493','Aviation Meteorological Equipment Technician OMA/IMA'),
('6694','Aviation Logistics Information Management System (ALIMS) Specialist'),
('1401','IMA Antenna/Mast Shop Journeyman'),
('1402','Tactical Communications Maintenance Technician'),
('1403','AN/USC-38(V)2,3 Maintenance Technician'),
('1403','AN/WSC-6(V)5 Super High Frequency (SHF) Satellite Communications (SATCOM) Maintenance'),
('1404','AN/FRT-96 Maintenance Technician'),
('1404','AN/WSC-8 Super High Frequency (SHF) Satellite Communications (SATCOM) Maintenance'),
('1405','Communications Equipment (FRT-39, URT-19, & URA-30) Technician'),
('1405','AN/WSC-6(V)7 Combatant Super High Frequency (SHF) Satellite Communications (SATCOM) Maintenance'),
('1406','AN/WSC-6(V)9 Combatant Super High Frequency (SHF) Satellite Communications (SATCOM) Maintenance'),
('1407','AN/SSC-12 Shipboard Air Traffic Control Communications (SATCC) Technician'),
('1408','Communications Equipment (FRC-84 & FCC-17) Technician'),
('1410','AN/SRC-55(V) HYDRA, ENG WIFCOM, WPCS Technician'),
('1411','Digital Subscriber, Terminal Equipment Maintenance Technician'),
('1412','Special Fixed Communications Maintenance Technician'),
('1413','Meteorologist Equipment Maintenance Technician'),
('1414','Communications Equipment (VLF/LF) Technician'),
('1415','Combined Shore Communications Maintenance Technician'),
('1417','ASCOMM/ASWOC TSC Communications System Technician'),
('1418','Digital Microwave Communications System (DMCS) Technician'),
('1419','Electromagnetic Compatibility Technician'),
('1420','Surface HF Communications Systems Maintenance Technician'),
('1421','Submarine Electromagnetic Compatibility Technician'),
('1422','Communications Equipment (UCC-1) Technician'),
('1423','Communications Equipment (SRC-20/21 & URC-9) UHF Technician'),
('1424','Communications Equipment (SRQ-4) Technician'),
('1425','Communications Equipment (WSC-3/UHF DAMA) Technician'),
('1426','AEGIS Data Link Technician'),
('1427','Communications Equipment (Tactical Data Systems ) Technician'),
('1428','Small Combatant Communications Electronic Subsystem Technician'),
('1429','Flight Deck Communications System (FDCS) Maintenance Technician'),
('1430','AN/USC-38(V) 2,3 Maintenance Technician'),
('1440','LINK 11 (AN/USQ-74) Maintenance Technician'),
('1442','KG-30 Family Limited Maintenance Technician'),
('1444','Communication Security Devices (KG-84/84A) Technician'),
('1445','Parkhill Maintenance Technician'),
('1446','Communications Security Devices (KY-57/58) Technician'),
('1447','Communications Security Devices (T/SEC/KW-46 T/R) Technician'),
('1454','DD-963 Communications Systems Technician'),
('1457','LHA Radio Communications System (RCS) Maintenance Technician'),
('1458','BKS/SMG Communications Systems Technician'),
('1465','Special Maintenance (AN/GSC-52(V), GSC-39, FSC-78/79 SHF Satellite Terminal) Technician'),
('1493','Tactical Support Communications (TSCOMM) Replacement Program Maintenance Technician'),
('1494','LHD Class Radio Communications System Maintenance Technician'),
('1496','TADIXS-A Phase IV Maintenance Technician'),
('1497','AN/UYK-1(V) BRANDS Technician'),
('14AA','Common Submarine Radio Room (CSRR) Maintenance Technician'),
('14SM','SWS Navigation System Maintenance Technician'),
('14SO','SWS Navigation System Operator'),
('14TM','TRIDENT I/II Radio Frequency (RF) Equipment Maintenance Technician'),
('14TO','TRIDENT I/II Radio Frequency (RF) Equipment Operator'),
('1502','CATC Radar Technician'),
('1517','DASR/STARS Maintenance Technician Pipeline'),
('2333','Radio Equipment (Submarine) Maintenanceman'),
('2335','Trident Sub Integrated Radio Room (IRR) Operation & Maint. Tech.'),
('2347','Submarine Digital Communications Equipment Technician'),
('2348','Radio Receiving Set WRR-7 (VERDIN) Technician'),
('2353','FLTSATCOM (SSIXS)/Radio Equipment (Submarine) Maintenanceman'),
('2376','LHD Class Radio Communications Systems Controller'),
('2378','VERDIN/ISABPS Shore Communications System Operator'),
('9547','Network Security Vulnerability Technician'),
('9560','Mobile Systems Facilities Technician'),
('9609','TADIXS B TRE Maintenance Technician'),
('9613','Naval Special Warfare (NSW) Communication Technician'),
('15N','Avionic Mechanic'),
('25Q','Multichannel Transmission Systems Operator-Maintainer'),
('25S','Satellite Communications Systems Operator-Maintainer'),
('25T','Satellite/Microwave Systems Chief'),
('26Y','SATCOM Equipment Repairer')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 9...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('29Y','SATCOM Systems Repairer'),
('31R','Multichannel Transmission Systems Operator-Maintainer'),
('31S','Satellite Communications Systems Operator-Maintainer'),
('31T','Satellite/Microwave Systems Chief'),
('33C','Terminal Intercept Equipment Repairman'),
('33D','Intercept Recording Systems Repairman'),
('33F','Intercept Demultiplex Systems Repairman'),
('33G','ECM/DF Systems Repairman'),
('33M','EW/Intercept Strategic System Analyst and Command and Control Subsystem Repairer'),
('33P','EW/Intercept Strategic Receiving Subsystems/Repairer'),
('33Q','EW/Intercept Strategic Processing & Storage Subsystems Repairer'),
('33R','Electronic Warfare/Intercept Aviation Systems Repairer'),
('33S','EW/Intercept Tactical System Repairer'),
('33T','Electronic Warfare/Intercept Tactical Systems Repairer'),
('33V','EW/Intercept Aerial Sensor Repairer'),
('33W','Military Intelligence Systems Maintainer/Integrator'),
('33Y','Strategic Systems Repairer'),
('33Z','EW/Intercept Systems Maintenance Supervisor'),
('35D','Air Traffic Control Equipment Repairer'),
('35K','Avionic Mechanic'),
('35L','Avionic Communications Equipment Repairer'),
('35M','Avionic Navigation & Flight Control Equipment Repairer'),
('35N','Avionic Flight Control Equipment Repairman'),
('35P','Avionic Equipment Maintenance Supervisor'),
('35Q','Avionic Flight Systems Repairer'),
('35R','Avionic Special Equipment Repairer'),
('35R','Avionic Systems Repairer'),
('35T','Military Intelligence (MI) Systems Maintainer/Integrator'),
('68J','Aircraft Armament/Missile Systems Repairer (RC)'),
('68L','Avionic Communications Equipment Repairer'),
('68N','Avionic Mechanic'),
('68Q','Avionic Flight Systems Repairer'),
('68R','Avionic Radar Repairer'),
('93D','Air Traffic Controller (ATC) Equipment Repairer'),
('94L','Avionic Communications Equipment Repairer'),
('94R','Avionic and Survivability Equipment Repairer'),
('553','Avionics Electrical Technician'),
('555','Avionics Technician'),
('AET','Avionics Electrical Technician'),
('110200','Navigation, Communication and Countermeasure, N.E.C.'),
('1B136','Airfield Systems Apprentice'),
('1B156','Airfield Systems Journeyman'),
('1B176','Airfield Systems Craftsman'),
('1C812','Airfield Systems Helper Helper'),
('1C832','Airfield Systems Apprentice'),
('1C852','Airfield Systems Journeyman'),
('1C872','Airfield Systems Craftsman'),
('2A000','Avionics Systems Manager'),
('2A090','Avionics Superintendent'),
('2A131','Avionic Sensors Maintenance Apprentice'),
('2A132','Avionics Guidance And Control Systems'),
('2A133','Communication And Navigation Systems'),
('2A137','Electronic Warfare Systems Apprentice'),
('2A151','Avionic Sensors Maintenance Journeyman'),
('2A152','Avionics Guidance And Control Systems Journeyman'),
('2A153','Communication And Navigation Systems Journeyman'),
('2A157','Electronic Warfare Systems Journeyman'),
('2A171','Avionic Sensors Maintenance Craftsman'),
('2A172','Avionics Guidance And Control Systems Craftsman'),
('2A173','Communication And Navigation Systems Craftsman'),
('2A177','Electronic Warfare Systems Craftsman'),
('2A190','Avionics Superintendent'),
('2A232','Electronic Warfare Systems'),
('2A252','Electronic Warfare Systems'),
('2A272','Electronic Warfare Systems'),
('2A290','Electronic Warfare/Offensive Avionic'),
('2A292','Electronic Warfare Superintendent'),
('2A431','Aircraft Guidance And Control Systems Apprentice'),
('2A432','Aircraft Communication And Navigation Systems Apprentice'),
('2A433','Aircraft Command Control Communications and Navigation Systems Apprentice'),
('2A451','Aircraft Guidance And Control Systems Journeyman'),
('2A452','Aircraft Communication And Navigation Systems Journeyman'),
('2A453','Aircraft Command Control Communications and Navigation Systems Journeyman'),
('2A471','Aircraft Guidance And Control Systems Craftsman'),
('2A472','Aircraft Communication And Navigation Systems Craftsman'),
('2A473','Aircraft Command Control Communications and Navigation Systems Craftsman'),
('2A490','Aircraft Avionics Superintendent'),
('2E132','Airfield Systems Apprentice'),
('2E152','Airfield Systems Journeyman'),
('2E172','Airfield Systems Craftsman'),
('30431','Navigational Aids Equipment Specialist'),
('30432','Meteorological and Navigation Systems Specialist'),
('30451','Navigational Aids Equipment Specialist'),
('30452','Meteorological and Navigation Systems Specialist'),
('30471','Navigational Aids Equipment Specialist'),
('30472','Meteorological and Navigation Systems Specialist'),
('32232','Avionic Sensor Systems Specialist'),
('32252','Avionic Sensor Systems Specialist'),
('32272','Avionic Sensor Systems Specialist'),
('32299','Avionic Sensor Systems Superintendent'),
('32333','Defensive Avionics Systems Specialist'),
('32353','Defensive Avionics Systems Specialist'),
('32373','Defensive Avionics Systems Specialist'),
('32530','Automatic Flight Control Systems Specialist'),
('32550','Automatic Flight Control Systems Specialist'),
('32570','Automatic Flight Control Systems Specialist'),
('32831','Avionic Navigation Systems Specialist'),
('32833','Electronic Warfare Systems Specialist'),
('32834','Avionic Inertial & Radar Navigation Systems Specialist'),
('32851','Avionic Navigation Systems Specialist'),
('32853','Electronic Warfare Systems Specialist'),
('32854','Avionic Inertial & Radar Navigation Systems Specialist'),
('32871','Avionic Navigation Systems Specialist'),
('32873','Electronic Warfare Systems Specialist'),
('32874','Avionic Inertial & Radar Navigation Systems Specialist'),
('32894','Avionic Communications-Navigation Systems Superintendent'),
('32899','Avionic Communications Navigation Systems Superintendent'),
('32900','Avionics Manager'),
('32930','Avionic Sensor Systems Specialist'),
('32950','Avionic Sensor Systems Specialist'),
('32970','Avionic Sensor Systems Specialist'),
('3D136','Airfield Systems Apprentice'),
('3D156','Airfield Systems Journeyman'),
('3D176','Airfield Systems Craftsman'),
('45331','Aircraft Guidance and Control Specialist'),
('45332','Aircraft Communication and Navigation Systems Specialist'),
('45351','Aircraft Guidance and Control Specialist'),
('45352','Aircraft Communication and Navigation Systems Specialist'),
('45371','Aircraft Guidance and Control Specialist'),
('45372','Aircraft Communication and Navigation Systems Specialist'),
('45399','Aircraft Avionics Superintendent'),
('45530','Photographic and Sensors Maintenance Specialist'),
('45531','Avionics Guidance and Control Systems Specialist'),
('45532','Communication and Navigation Systems Specialist'),
('45550','Photographic and Sensors Maintenance Specialist'),
('45551','Avionics Guidance and Control Systems Specialist'),
('45552','Communication and Navigation Systems Specialist'),
('45570','Photographic and Sensors Maintenance Specialist'),
('45571','Avionics Guidance and Control Systems Specialist'),
('45572','Communication and Navigation Systems Specialist'),
('45590','Photo-Sensors Maintenance Superintendent'),
('45599','Conventional Avionic Superintendent'),
('45631','Electronic Warfare Systems Specialist'),
('45651','Electronic Warfare Systems Specialist'),
('45671','Electronic Warfare Systems Specialist'),
('45699','Offensive/Defensive Avionic Superintendent'),
('4843','Navigation Aids Repairing'),
('2848','Tactical Remote Sensor System (TRSS) Maintainer'),
('6314','Avionics/Maintenance Technician, Unmanned Aircraft System (UAS)'),
('6365','Aircraft Communications/Navigation/Radar Systems Tech., EA-6B'),
('6384','Aircraft Electronic Countermeasures Systems Technician, EA-6A'),
('6385','Aircraft Active ECM Systems Technician, EA-6A'),
('6386','Aircraft Electronic Countermeasures Systems Technician, EA-6B'),
('6414','Aircraft Communications/Navigation/Cryptographic Systems Technician, IMA'),
('6415','Aircraft Navigation Systems Technician, Radar, IMA'),
('6416','Aircraft Navigation Systems Technician, TACAN, IMA'),
('6452','Aircraft ALQ-99 Jammer Systems Technician, IMA'),
('6453','Aircraft ALQ-99 Track & Surveillance Systems Technician, IMA'),
('6454','Aircraft ALQ-99 Display/AYA-6 Systems Technician, IMA'),
('6455','ECM Module Repair Technician, IMA'),
('6482','Aircraft Electronic Countermeasures Systems Technician, Fixed Wing, IMA'),
('6483','Communication/Navigation/Cryptographic/Countermeasures Systems Technician, IMA'),
('6484','Consolidated Automatic Support System (CASS) Electronic Warfare (EW) Technician, IMA'),
('6485','Advanced Aircraft ECM System Technician, IMA'),
('6486','Advanced Aircraft Electronic Countermeasures Technician, IMA'),
('6618','Aircraft Navigation Systems Technician, IFF, IMA'),
('6619','Aircraft Navigation Systems Technician, Radar, IMA'),
('6620','Aircraft Navigation Systems Technician, TACAN, IMA'),
('6626','A/C Passive Electronic Countermeasures Systems Technician, IMA'),
('6627','A/C Active Electronic Countermeasures Systems Technician, IMA'),
('6628','A/C Deceptive Electronic Countermeasures Systems Technician, IMA'),
('6662','Aircraft Communications/Navigation/Radar Systems Technician, OMA'),
('6663','Aircraft Electronic Countermeasures Systems Tech., EA-6B, OMA'),
('6664','Aircraft ALQ-99 Jammer Systems Technician, IMA'),
('6665','Aircraft ALQ-99 Track & Surveillance Systems Technician, IMA'),
('6666','Aircraft ALQ-99 Display/AYA-6 Systems Technician, IMA'),
('6667','ECM Module Repair Technician, IMA'),
('8631','Surveillance Sensor Maintenance Marine'),
('001035','Electronic Equipment Technician'),
('001040','Equipment Maintenance Director'),
('001045','Network Maintenance Technician'),
('001182','Submarine Navigation Operator'),
('001187','Submarine Navigation Technician'),
('001192','Submarine Navigation Manager'),
('001200','Strategic Navigation Operator'),
('001205','Strategic Navigation Technician'),
('001210','Strategic Navigation Manager'),
('002365','Aviation Calibration Technician'),
('002410','Aviation Electronics Intermediate Level Technician'),
('002455','Aviation Electronics Organizational Level Technician'),
('002493','Intermediate Level Automatic Test Equipment Technician'),
('002729','Equipment Installation Technician'),
('003756','Electronics Maintenance Technician'),
('0343','AN/SYQ-13 NAV/C2 Operator'),
('0541','AN/SQQ-34C (V) 2 Aircraft Carrier Tactical Support Center (CV-TSC) Maintenance Technicians'),
('1416','SNAP II (AN/UYK-62(V)) Maintenance Technician'),
('1433','Super High Frequency (SHF) Satellite Communications (SATCOM) Maintenance Technician'),
('1450','NAVMACS(V)5 Shipboard Maintenance Technician'),
('1451','SMQ-10/TMQ-29 Technician'),
('1452','NAVMACS (V)3 Shipboard Maintenance Technician'),
('1453','FLTSATCOM (NAVMACS (V)2) Shipboard Maintenance Technician'),
('1456','FLTSATCOM (CUDIXS/DAMA-NAVCOMMSTA) Maintenance Technician'),
('1459','Mobile Maintenance System Technician'),
('1461','Special Maintenance (FSC-78/79 SHF Satellite Terminal) Technician'),
('1462','Special Maintenance (MSC-46 Satellite Communications) Technician'),
('1463','Special Maintenance (TSC-54 Satellite Communications) Technician'),
('1464','WSC-28(V) Satellite Communications Set Technician'),
('1466','Special Maintenance (SSC-6 Major Ship SHF SATCOM Terminal) Tech.'),
('1467','UHF DAMA Shore System Technician'),
('1468','Special Maintenance (SHF SATCOM System) Technician'),
('1469','Electrically Suspended Gyro Navigator (ESGN) Technician'),
('1481','Electronic Warfare Support Measures (ESM) (WLR-1Series ) System Technician'),
('1482','Electronic Warfare System Technician'),
('1483','Electronic Warfare System Technician (WRL-8 (V)2/(BLD-1)'),
('1484','Electronic Warfare System Technician (BRD-7)'),
('1485','Electronic Warfare Technician (WLQ-4(V) Sea NYMPH)'),
('1486','Single Audio System (SAS)'),
('1491','FFG-7 Class Navigation Electronics Subsystem Technician'),
('1495','AN/SYQ-13 NAV/C2 Maintainer'),
('1498','Planning Series - AN/USN-3(V) Satellite Signals Landing System Maintenance Technician'),
('14BB','SSN 594 Class ESM Technician'),
('14BF','Project SSN 637 ESM Technician'),
('14BG','SSN 768-773 ESM Technician'),
('14BH','SSN 774 Class Electronic Support Equipment Maintenance Technician'),
('14CM','SSN Radio Frequency (RF) Equipment Technician'),
('14CT','Submarine Conversion Technician'),
('14EB','SSN 668 Class ESM Technician'),
('14EM','SSN ESM Equipment Maintenance Technician'),
('14EP','SSN 719-767 ESM Technician'),
('14ET','ESM Technician (All Classes)'),
('14FA','TRIDENT Submarine Electronics Technician Command and Control System'),
('14GM','SSGN Navigation Maintenance Electronics Technician'),
('14HB','SSN 637 Class ESM Technician'),
('14HH','SSN 21 Class ESM Technician'),
('14IC','Former IC(SS)'),
('14JA','TRIDENT ESM Technician'),
('14NM','Navigation Equipment Maintenance Technician'),
('14NO','Navigation Equipment Operator'),
('14NP','SSN 774 Class Navigation and Ship''s Electronic Equipment Technician'),
('14NV','SSN/SSBN Assistant Navigator'),
('14QM','Former QM(SS)'),
('14RD','SSN 637 Class Navigation Technician'),
('14RM','Former RM (SS)'),
('14RO','SSN Radio Frequency (RF)Equipment Operator'),
('14SF','SSN 594/688 Class Navigation Technician'),
('14TG','SSN 637/688 Class Navigation Technician'),
('14TK','SSN 21 Navigation Technician'),
('14XM','Electronics Technician Trident II SWS D-5 Backfit SWS Navigation Maintenance Technician'),
('14XO','Electronics Technician Trident II SWS D-5 Backfit SWS Navigation Operator'),
('14ZA','AN/BRD-7 Submarine Radio Direction Finding (RDF) Set Maintenance Technician'),
('14ZL','AN/WRN-5 Submarine Satellite Navigation Equipment Maintenance Tech'),
('14ZQ','SSN/SSGN AN/BLQ-10A (V) Submarine Electronic Warfare Support (ES) Equipment Operator'),
('14ZR','SSN/SSBN AN/WLR-8(v) Submarine Electronic Warfare Support (ES) Equipment Operator'),
('14ZS','Planning Series - SSBN SSI Inc 4 Electronics Technician Journeyman'),
('14ZT','Planning Series - SSBN Inc 4 Electronics Technician Maintainer'),
('14ZU','Planning Series - AN/URN � 32 Navigational Set, Tactical Air Navigation (TACAN) System Technician'),
('1572','AIMS System Technician'),
('1685','Tactical Support Center (TSC) Acoustic System Maintenance Technician'),
('1690','TacMobile Acoustic Support System Maintenance Technician'),
('16ET','Former DS'),
('16FC','Former DS'),
('1702','AN/SLQ-32A/B (V) 2 Technician'),
('1708','AN/SLQ-32(V) Electronic Warfare Operations Technician'),
('4708','Automated Electrolytic Oxygen Generator (AEOG) Maintenance Technician'),
('4728','WSN-5 Inertial Navigation Set Technician'),
('4739','Gigabit Ethernet Data Multiplex System (GEDMS) Interior Communications (IC) Electrician'),
('6529','ASW Sonobuoy Receivers and Recorder Group IMA Technician'),
('6534','AQA-7 DIFAR System IMA Technician'),
('6564','ASW Acoustic Detection Systems IMA Technician'),
('6604','Integrated Communication/Navigation/IFF IMA Technician'),
('6608','Aircraft Navigation Computers IMA Technician'),
('6609','Aircraft Electronic Identification (IFF) IMA Technician'),
('6611','Aircraft UHF Communications, Automatic Direction Finder (ADF) and Intercommunications Systems (ICS) Equipment IMA Technician'),
('6612','Aircraft TACAN/Radio Navigation Equipment IMA Technician'),
('6613','Aircraft HF Communications Equipment IMA Technician'),
('6614','APS-116 IMA Technician'),
('6615','P-3 FLIR IMA Technician'),
('6617','APM-341(V) PGSE IMA Technician'),
('6618','USM-458/USM-641 IMA Technician'),
('6619','HATS (USM-403) Operator'),
('6621','Search Radar IMA Technician'),
('6622','Electronic Countermeasures (ECM) Technician/Weapons Replaceable Assembly (WRA) IMA Technician'),
('6624','APS-96 Search Radar IMA Technician'),
('6628','HATS (USM-403) IMA Maintenance Technician'),
('6631','AN/USM-629 Electro Optic Test Set (EOTS) Operator/Maintainer, IMA'),
('6633','USM-467 RADCOM IMA Technician'),
('6634','Aircraft Communications Security Devices Equipment IMA Technician'),
('6635','EP-3E ESM IMA Technician'),
('6639','Countermeasures Receiving and Dispensing Equipment IMA Technician'),
('6640','EP-3E ESM OMA Technician'),
('6641','ALQ-126 ECM IMA Technician'),
('6643','ALQ-100 ECM IMA Technician'),
('6644','DECM (ALQ-92) IMA Technician'),
('6645','ALM-106 (MATE) Test Console IMA Technician'),
('6646','ALQ-91/108 DECM IMA Technician'),
('6647','ALQ-99 Transmitter Test Station IMA Technician'),
('6648','ALQ-99 Exciter IMA Technician'),
('6649','ECM/Simulator IMA Technician'),
('6662','APA-125/APS-80 Radar System IMA Technician'),
('6664','APS-115 Search Radar IMA Technician'),
('6667','EA-6B EXCAP DTS Oper & ALQ-99 Displays Int Maintenance Technician'),
('6668','EA-6B ECM OMA System Analyst'),
('6669','EA-6A ECM/ESM Organizational Maintenance Technician'),
('6670','APS-133(V) Weather Radar System IMA Technician'),
('6671','Radio Frequency Test Station (RFTS) IMA Technician'),
('6672','P-3C COMNAV OMA Technician'),
('6673','Field Calibration Activity Technician (Electrical/Electronic)'),
('6674','ALQ-99/ALQ-86 Surveillance and Receiver Test Station IMA Tech.'),
('6675','P-3C Update IV Comm/NAV Technician'),
('6676','ALQ-99 Module Support Technician'),
('6677','TARPS Camera Repair IMA Technician'),
('6679','DTS/DTG Operator and Digital Display Group IMA Technician'),
('6680','ICAP Computer Group/ICAP II Digital Interface Unit IMA Technician'),
('6681','ERA-3B OMA ESM/ECM Technician'),
('6682','FEWSG Airborne Electronic Warfare System (FAEWS) Inter. Mainten.'),
('6683','USM-429 CAT III D Operator'),
('6684','AAM-60(V)6 Electro Optical System Test Set IMA Technician'),
('6685','Strike ECM/CNI OMA Technician'),
('6686','USM-429 CAT III D Maintenance Technician'),
('6688','USM-484 Hybrid Test Set (HTS) IMA Technician'),
('6689','USM-484 HTS Advanced IMA Technician'),
('6690','Mission Avionics OMA Technician'),
('6691','E-2C Passive Detection System OMA Technician'),
('6692','E-2C AEW System Analyst OMA Technician'),
('6693','USM-470(V)2 Automatic Test System Operator'),
('6694','USM-470(V)2 Automatic Test Systems On-Line Maintenance Technician'),
('6695','USM-470(V)2 ATS Advanced IMA Technician'),
('6696','TACAMO CCCS/UHF/HF Communications IMA Technician'),
('6697','TACAMO VLF and VERDIN IMA Technician'),
('6698','EC-130 TACAMO OMA Technician'),
('6701','Advanced Avionics Integrated Systems Technician'),
('6702','E-6B Mission Avionics System IMA Technician'),
('6703','E-6B Aviation Organizational Maintenance Technician'),
('6708','E-2C Group II AEW System Analyst'),
('6709','E-2C Group II AEW System Maintenance Technician'),
('6710','P-3 Navigation System Equipment Technician'),
('6712','EP-3E Special Installation Technician'),
('6716','AN/USM-449A (V) Test Set Operator Intermediate Maintenance'),
('6717','P-3 Peculiar Communications Equipment IMA Technician'),
('6720','AN/ALQ-167(V) Tactical/Shipboard Training Intermediate MaintenanceTechnician'),
('6722','ES-3A Systems Organizational Maintenance Technician'),
('7153','E-2C Navigation System OMA Technician'),
('7196','Inertial Platform Test Station IMA Technician'),
('7951','A-6E OMA Weapons System Technician'),
('7952','A-6E OMA Weapons System Specialist'),
('7984','AWG-9/AWM-23 Radio Frequency Test Console IMA Technician'),
('8237','E-6A Flight Communications Operator'),
('8264','E-2C AEW Flight Technician'),
('8275','TACAMO Systems In-Flight Avionics Technician'),
('8340','F/A-18E/F Block 2 Avionics System Organizational Career Maintenance Technician'),
('8373','MH-60S Organic Airborne Mine Countermeasures (OAMCM) Systems Maintenance Technician'),
('8388','SH-60R Electronics Systems Organizational Career Maintenance Technician'),
('8389','MH-60S Systems Organizational Career Maintenance Technician'),
('8807','SH-60R Electronics Systems Organizational Initial Maintenance Technician'),
('8808','SH-60S Electronics Systems Organizational Initial Maintenance Technician'),
('8816','E-2C Hawkeye 2000 Systems Organizational Initial Maintenance Technician'),
('8840','F/A-18E/F Block 2 Avionics System Organizational Initial Maintenance Technician'),
('90UE','GWOT Support Assignment - SHADOW Unmanned Aircraft System (UAS) Electronics Maintenance Specialist'),
('9126','SEAMARK Advanced Operator Maintainer'),
('9224','Tactical Exploitation System Maintenance'),
('9225','AN/SSQ-137 Ship Signal Exploitation Equipment - SSEE Maintenance Technician'),
('9226','CLASSIC OWL Maintenance Technician'),
('9227','SEAMARK System Maintenance Technician'),
('9228','COMSAT System Maintenance Technician'),
('9229','Submarine Carry on Equipment Technician'),
('9238','Submarine Carry-on Equipment Maintenance Technician'),
('9244','WOLFERS/ROCKETEER System Maintenance Technician'),
('9245','NEWSDEALER System Maintenance Technician'),
('9247','Outboard II Acquisition Maintenance Technician'),
('9248','Outboard II Direction Finding (DF) Maintenance Technician'),
('9249','OUTBOARD II System Maintenance Technician'),
('9251','Wideband Acquisitions & Analysis (WBAA) Hardware Maintenance Tech.'),
('9252','High Frequency Direction Finding (HFDF) Hardware Maintenance Tech.'),
('9254','Net Control System (AN/FSK-3(V)) Maintenance Technician'),
('9256','Radio Frequency Distribution (RFD) Maintenance Technician'),
('9257','WOLFERS/ROCKETEER and Chainwork PTTI Maintenance Technician'),
('9258','Outstation Communication (FLAGHOIST) System Maintenance Technician'),
('9259','Digital Systems Maintenance Technician'),
('9263','SIEGEL/LIFEMAN Systems Maintenance Technician'),
('9266','ASTW Maintenance Technician'),
('9267','MUSIC Maintenance Technician'),
('9268','Teletype (MOD-40) Maintenance Technician'),
('9270','STREAMLINER Communications System Maintenance Technician'),
('9271','CRITICOM Maintenance Technician'),
('9272','Dory/Ullman Maintenance Technician'),
('9273','KEELAN Systems Maintenance Technician'),
('9274','DISS Systems Maintenance Technician'),
('9279','NAVSECGRU Maintenance Management System Application Analyst'),
('9280','Tactical Intelligence (TACINTEL) Communications Subsy. Maint. Tech'),
('9281','OUTBOARD I System Maintenance Technician'),
('9282','FES Maintenance Technician'),
('9283','Mobile Electronics Maintenance Technician (WLQ-4)'),
('9284','Mobile Electronics Maintenance Technician (Submarine)'),
('9286','Chainwork PTTI System Maintenance Technician'),
('9287','Cryptologic Combat Support System (CCSS) Maintenance Technician'),
('9288','Cryptologic Combat Support Console (CCSC) Maintenance Technician'),
('9289','Combat Direction Finding System (SRS-1) Maintenance Technician'),
('9292','Sub-HF System Maintenance Technician'),
('9293','FYK-16 System Maintenance Technician'),
('9294','FSQ-111 System Maintenance Technician'),
('9295','Network Systems Maintenance Technician'),
('9296','Communications Electronics Equipment Installer'),
('9297','CLASSIC WIZARD System Maintenance Technician'),
('9298','Ship''s Signal Exploitation Equipment Increment Foxtrot (SSEE INC F) Maintenance Technician'),
('9403','EP-3E Electronic Warfare Operator'),
('9601','Single Channel Ground and Airborne System (SINCGARS)'),
('9602','Amphibious Air Traffic Control (AATC) Radar Technician (AN/SPN-43C)'),
('9603','Inertial Measuring Unit (IMU) Technician'),
('9604','Data Link Communications System Maintenance Technician'),
('9605','Naval Modular Automated Communications Systems II (NAVMACS II) Maintenance Technician'),
('9607','High Frequency Radio Group (HFRG) Maintenance Technician'),
('9614','AN/SPN-35C Maintenance Technician'),
('AT','Aviation Electronics Technician'),
('ATI','Aviation Electronics Technician (Intermediate Maintenance)'),
('ATO','Aviation Electronics Technician (Organizational Maintenance)'),
('AX','Aviation Antisubmarine Warfare Technician'),
('CTM','Cryptologic Technician Maintenance'),
('ET(R)','Electronics Technicians (Communication)'),
('94D','Air Traffic Control Equipment Repairer'),
('110300','Air Traffic Control Radar'),
('1B135','Ground Radar Systems Apprentice'),
('1B155','Ground Radar Systems Journeyman'),
('1B175','Ground Radar Systems Craftsman'),
('1C811','Ground Radar Systems Helper'),
('1C831','Ground Radar Systems Apprentice'),
('1C851','Ground Radar Systems Journeyman'),
('1C871','Ground Radar Systems Craftsman'),
('2E031','Ground Radar Systems Apprentice'),
('2E031A','Air Traffic Control Radar, GPN-20/FPN-62'),
('2E031B','Air Traffic Control Radar, GPN-20/GPN-22'),
('2E031C','Air Traffic Control Radar, GPN-12/FPN-61'),
('2E031D','Air Traffic Control Radar, GPN-12/GPN-22'),
('2E031E','Air Traffic Control Radar, MPN-14K/GPN-20/GPN-22'),
('2E051','Ground Radar Systems Journeyman'),
('2E071','Ground Radar Systems Craftsman'),
('30331','Air Traffic Control Radar Specialist'),
('30351','Air Traffic Control Radar Specialist'),
('30371','Air Traffic Control Radar Specialist'),
('3D135','Ground Radar Systems Apprentice'),
('3D155','Ground Radar Systems Journeyman'),
('3D175','Ground Radar Systems Craftsman'),
('5951','Air Traffic Control Maintenance Trainee'),
('5952','Air Traffic Control Navigational Aids Technician'),
('5953','Air Traffic Control Radar Technician'),
('5954','Air Traffic Control Communications Technician'),
('5955','Air Traffic Control Navigational Aids Repairer'),
('5958','Air Traffic Control Communications Repairer'),
('5959','Air Traffic Control Systems Maintenance Chief'),
('1523','Amphibious Air Traffic Control (AATC) Radar'),
('1574','AN/TPX-42(V)5 Maintenance Technician'),
('1578','AN/TPX-42(V)10 Maintenance Technician'),
('1579','Precision Approach Radar Technician'),
('1580','ASR-8 Maintenance Technician'),
('1590','AN/SPN-46(V) Radar Technician'),
('1592','AN/TPX-42A (V) 14 Shipboard DAIR Maintenance Technician'),
('9606','Shipboard Air Traffic Control (SATC) Radar Technician'),
('23N','NIKE Track Radar Repairer'),
('23S','HAWK Pulse Radar Repairer'),
('23T','HAWK Continuous Wave Radar Repairman'),
('23U','NIKE High Power Radar-Simulator Repairer'),
('23W','NIKE Maintenance Chief'),
('24B','HAWK Continuous Wave Radar Mechanic'),
('24J','HAWK Pulse Radar Repairer'),
('24K','HAWK Continuous Wave Radar Repairer'),
('24P','Defense Acquisition Radar Mechanic'),
('26B','Weapons Support Radar Repairer'),
('26C','Target Acquisition Surveillance Radar Repairer'),
('26C','Combat Area Surveillance Radar Repairer'),
('26D','Ground Control Approach Radar Repairer'),
('26E','Aerial Radar Sensor Repairer'),
('26H','Air Defense Radar Repairer (RC)'),
('26K','Aerial Electronic Warning Defense Equipment Repairer'),
('26M','Aerial Surveillance Radar Repairer (RC)'),
('26N','Aerial Surveillance Infrared Repairer (RC)'),
('26U','Unattended Ground Sensor Systems Repairman'),
('26W','Radar Maintenance Supervisor-Inspector'),
('27J','HAWK Field Maintenance Equipment/Pulse Acquisition Radar Repairer'),
('27K','HAWK Fire Control/Continuous Wave Radar Repairer'),
('27N','Forward Area Alerting Radar (FAAR) Repairer'),
('35C','Surveillance Radar Repairer'),
('35M','Radar Repairer'),
('39C','Target Acquisition Surveillance Radar Repairer'),
('94M','Radar Repairer'),
('110400','Surveillance/Target Acquisition and Tracking Radar'),
('11832','Airborne Radar Systems Specialist'),
('11852','Airborne Radar Systems Specialist'),
('11872','Airborne Radar Systems Specialist'),
('1A533','Airborne Radar Systems'),
('1A553','Airborne Radar Systems'),
('1A573','Airborne Radar Systems'),
('2A134','Airborne Surveillance Radar Systems Apprentice'),
('2A154','Airborne Surveillance Radar Systems Journeyman'),
('2A174','Airborne Surveillance Radar Systems Craftsman'),
('2E032','Aircraft Control And Warning Radar'),
('2E033','Automatic Tracking Radar'),
('2E052','Aircraft Control And Warning Radar'),
('2E053','Automatic Tracking Radar'),
('2E072','Aircraft Control And Warning Radar'),
('2E073','Automatic Tracking Radar'),
('2E090','Ground Radar'),
('2E091','Ground Radar Superintendent'),
('2E431','Space Systems Apprentice'),
('2E451','Space Systems Journeyman'),
('2E471','Space Systems Craftsman'),
('2E491','Space Systems Superintendent'),
('30332','Aircraft Control & Warning Radar Specialist'),
('30333','Automatic Tracking Radar Specialist'),
('30352','Aircraft Control & Warning Radar Specialist'),
('30353','Automatic Tracking Radar Specialist'),
('30372','Aircraft Control & Warning Radar Specialist'),
('30373','Automatic Tracking Radar Specialist'),
('30393','Ground Radar Superintendent'),
('30399','Ground Radar Superintendent'),
('30930','Space Systems Equipment Maintenance Specialist'),
('30950','Space Systems Equipment Maintenance Specialist'),
('30970','Space Systems Equipment Maintenance Specialist'),
('30999','Missile Warning & Space Surveillance Sensor Superintendent'),
('32832','Airborne Warning & Control Radar Specialist'),
('32852','Airborne Warning & Control Radar Specialist'),
('32872','Airborne Warning & Control Radar Specialist'),
('45534','Airborne Warning and Control Radar Specialist'),
('45554','Airborne Warning and Control Radar Specialist'),
('45574','Airborne Warning and Control Radar Specialist'),
('99136','Scatter Communications Maintenance Technician'),
('99508','Scatter Communication Maintenance Technician'),
('2827','Tactical Electronic Reconnaissance Process/Evaluation Systems (TERPES) Technician'),
('2884','Ground Radar Repairer'),
('2885','Artillery Electronic Systems Repairer'),
('2886','Artillery Electronic System Repairer'),
('2886','Artillery Electronics Repairer'),
('2887','Artillery Electronics Technician'),
('2888','Counter Mortar Radar Repairman'),
('2889','Ground Radar Technician'),
('5921','HAWK Fire Control Repairer'),
('5922','HAWK Information Coordination Central Repairer'),
('5929','HAWK Mechanical System Repairer'),
('5931','Ground Radar Repairman'),
('5932','FADAC Radar Repairman'),
('5933','Artillery Electronics Repairman'),
('5934','Weapons Location Equipment Repairman'),
('5935','Counter Mortar Radar Repairman'),
('5936','Ground Radar Technician'),
('5941','Aviation Radar Repairman A'),
('5942','Aviation Radar Repairer'),
('5943','Aviation Fire Control Repairer'),
('5944','Aviation Radar Repairer (AN/TPS-63)'),
('5945','Aviation Radar Repairer (AN/TPS-32)'),
('5947','Aviation Fire Control Technician'),
('5948','Aviation Radar Repairer'),
('5951','Aviation Meteorological Equipment Technician, OMA/IMA'),
('5956','Station Air Traffic Control Surveillance Radar System Technician'),
('5957','Station Air Traffic Control Precision Approach Radar Technician'),
('5993','Electronics Maintenance Chief (Aviation (C2))'),
('6363','Aircraft Radar Reconnaissance/Camera Systems Technician, RF-4B'),
('6463','Consolidated Automatic Support System (CASS) High Power (HP) Technician, IMA'),
('6475','Aircraft Radar/IR Reconnaissance Systems Technician, IMA'),
('6629','Aircraft Radar/IR Reconnaissance Systems Technician, IMA'),
('7222','Hawk Missile System Operator'),
('1093','AEGIS Radar System (SPY-1) Ballistic Missile Defense (BMD) 4.X Technician'),
('1094','AEGIS Fire Control System (FCS) Ballistic Missile Defense (BMD) 4.X Technician'),
('1095','AEGIS Fire Control System (FCS) Ballistic Missile Defense (BMD) 5.X Technician'),
('1113','AEGIS SPY-1B/D (TK II)/AEGIS Ballistic Missile Defense SPY Radar Operator'),
('1119','AEGIS Radar System (SPY-1B/D) Technician'),
('1135','Search Radar (SPS-39, 39A OR 42) Technician'),
('1137','Search Radar (SPS 52A or SPS 52B)'),
('1138','Search Radar (SPS 48C) Technician'),
('1140','AN/SPS 48E Search Radar Technician'),
('1141','TARTAR Missile Fire Control Systems MK 74 MOD 15 Technician'),
('1142','Search Radar (SPS 52C) Technician'),
('1143','AEGIS Fire Control System MK-99/Operational Readiness Test System Technician'),
('1148','AEGIS Fire Control System Technician, Track III'),
('1156','NATO Seasparrow Surface Missile System (NSSMS) MK 57 Mods 10 and Above'),
('1161','AN/SPG-55B MOD 10 (TOP) Fire Control Radar Operation & Maint Tech'),
('1162','Fire Control Radar Technicians'),
('1163','SPG-55B Fire Control Radar Technician (MFCS MK 76 MOD 8/9)'),
('1166','Fire Control Radar Technicians'),
('1167','TARTAR Fire Control Radar (MFCS MK 74 MOD 14 w/RDP) Technician'),
('1168','Radar (SPG-51D) Technician'),
('1169','HARPOON (AN/SWG 1A) Maintenance Technician'),
('1337','AN/SPY-1D(V) Radar Technician'),
('1503','Radar SPS-49(V)1-4 Technician'),
('1504','Radar (SPS-55) Technician'),
('1506','Radar (SPS-29E) Technician'),
('1507','Radar (SPS-67(V)1) Technician'),
('1508','Radar (SPS-40B/C/D with DMTI) Technician'),
('1509','Radar (SPS-65(V)1) Technician'),
('1510','Radar AN/SPS-49(V) 5, 7 & 8 Technician'),
('1511','Radar (AN/SPS-40E) Technician'),
('1512','Radar Systems (SPS-37A & SPS-43A) Technician'),
('1513','Fixed Array Radar (FAR) Technician'),
('1514','Radar (SPS-40) Technician'),
('1515','Radar (SPS-40A) Technician'),
('1516','Radar (SPS-40B/C/D) Technician'),
('1518','Radar (AN/SPS-43) Technician'),
('1519','Radar (SPS-30) Technician'),
('1520','AN/SPS-73(V) 12 & 17 Maintenance Technician'),
('1522','Radar (SPN-42) Technician'),
('1529','Standard Terminal Automation Replacement System (STARS) Maintenance Technician'),
('1530','Digital Airport Surveillance Radar (DASR)'),
('1568','AN/TPX-42A(V) 13 Shipboard DAIR Maintenance Technician'),
('1571','AN/UPX-29(V) Ship System Maintainer'),
('1575','AN/SPS-48G(V)1 Maintenance Technician'),
('1576','CATC DAIR Maintenance Technician'),
('1577','Ground Controlled Approach (CPN-4A or MPN-5) Technician'),
('6616','APS-120 Radar IMA Technician'),
('6638','AAD-5 IMA Technician'),
('6713','Video Test Set (VTS) AN/SSM-9 Test Set Operator'),
('6714','Enhanced Comprehensive Asset Manager System (ECAMS) Maintainer'),
('6715','FLIR Systems IMA Technician'),
('7910','IRST System Intermediate Maintenance Technician'),
('7918','APQ-116 Radar IMA Technician'),
('7919','APQ-126 FLR SSE IMA Technician'),
('7921','AVQ-7 HUD IMA Technician'),
('7922','AVQ-7 HUD SSE (AVM-11) IMA Technician'),
('7931','AWG-10 Transmitter & Antenna IMA Technician'),
('7932','AWG-10 Receiver IMA Technician'),
('7934','AWG-10A Fire Control System Maintenance Technician'),
('7935','AWG-10A/AWM-80 Computer/Computer Test Sta Int Maintenance Tech.'),
('7936','AWG-10A Xmtr, Antenna, & Missile Control Int Maintenance Tech.'),
('7937','Receiver & Indicator Maintenance Technician'),
('7953','APQ-148/156 & APS-130 Radar, AAS-33 FLIR & APM 375 MSTRC IMA Tech'),
('7954','ASQ-133/155 Ballistic Comp & Comp Systems Test Console IMA Tech.'),
('7955','Radar Systems Module Repair Intermediate Maintenance Technician'),
('7958','A-6E TRAM Weapon System Organizational Maintenance Technician'),
('7959','FLIR Systems Intermediate Maintenance Technician'),
('7963','APQ-103/129 Search Radar, Mini-SACE Test Console IMA Tech'),
('7964','AVA-1 Analog Display Indicator & Test Console IMA Technician'),
('7965','A-6A/B/C OMA Weapons System Specialist'),
('7967','A-7E Integrated System Specialist'),
('7968','A-6E/EA-6B Radar/Mini-SACE IMA Technician'),
('7969','F/A-18 OMA Integrated Weapons Technician'),
('7970','F-14D OMA Integrated Weapons Technician'),
('7971','F-14A/B OMA Integrated Weapons Technician'),
('7973','A-6A/B/C OMA Weapons System Technician'),
('7975','APQ-126 FLR IMA Technician'),
('7976','C-8185 ASCU IMA Technician'),
('7977','APM-446 Radar Set System Test Station (RSTS) Operator'),
('7978','Radar Set Test Station IMA Technician'),
('7979','APM-446 Radar System Test Station (RSTS) Test Prog Set (TPS) Anal'),
('7983','AERO-1A Missile Control System IMA Technician'),
('8236','E-6A Reel System Operator'),
('8273','TACAMO Airborne Communications Operator'),
('8274','TACAMO Systems Reel Operator'),
('9608','Radar Technician (AN/SPS-67(V)3)'),
('9610','Radar AN/SPS-49A(V)1 Technician'),
('9615','AN/SPS-67(V)5 Radar Technician'),
('111','Fire Control Electronic Systems (Non-Missile)'),
('111100','Bomb-Navigation'),
('2A231','Bomb-navigation Systems'),
('2A251','Bomb-navigation Systems'),
('2A271','Bomb-navigation Systems'),
('32130','Bomb-Navigation Systems Mechanic'),
('32150','Bomb-Navigation Systems Mechanic'),
('32170','Bomb-Navigation Systems Mechanic'),
('45630','Bomb-Navigation Systems Specialist'),
('45650','Bomb-Navigation Systems Specialist'),
('45670','Bomb-Navigation Systems Specialist'),
('7946','Bomb Director Set (ASB-1) Technician'),
('35J','Aircraft Fire Control Repairman'),
('111200','Airborne Fire Control'),
('32131','Defensive Fire Control Systems Mechanic'),
('32132','Weapon Control Systems Mechanic'),
('32151','Defensive Fire Control Systems Mechanic'),
('32152','Weapon Control Systems Mechanic'),
('32171','Defensive Fire Control Systems Mechanic'),
('32172','Weapon Control Systems Mechanic'),
('32192','Avionic Weapon Delivery Systems Superintendent'),
('32199','Avionic Weapon Delivery Systems Superintendent'),
('32231','Weapons Control Systems Mechanic'),
('32251','Weapons Control Systems Mechanic'),
('32271','Weapons Control Systems Mechanic'),
('32331','Offensive Avionics Systems Specialist'),
('32351','Offensive Avionics Systems Specialist'),
('32371','Offensive Avionics Systems Specialist'),
('45533','Weapon Control Systems Specialist'),
('45553','Weapon Control Systems Specialist'),
('45573','Weapon Control Systems Specialist'),
('45632','Defensive Fire Control Systems (DFCS) Specialist'),
('45652','Defensive Fire Control Systems (DFCS) Specialist'),
('45672','Defensive Fire Control Systems (DFCS) Specialist'),
('AQ','Aviation Fire Control Technician'),
('34G','Fire Control Computer Repairer'),
('34L','Field Artillery Digital Systems Repairer'),
('34Y','FA Computer Repairer'),
('39Y','Field Artillery Tactical Fire Direction Systems Repairer'),
('45G','Fire Control Repairer'),
('91G','Fire Control Repairer'),
('111300','Shipboard and Other Fire Control'),
('0870','MK 46 MOD 2 Gun Weapon System (GWS) Technician'),
('1050','ACB-12 Gun Computer System (GCS) MK 160 MODs 14-16/Electro-Optical Sensor System (EOSS) MK 20 MOD 0 Fire Control (FC) Technician'),
('1080','Close-In Weapon System (CIWS) Phalanx Block 1B Baseline 2 Technician'),
('1106','AEGIS Fire Control System MK 99/Operational Readiness Test System MK-1 Technician'),
('1108','AEGIS Weapon System MK-7 Technician'),
('1109','Rolling Airframe Missile (RAM) MK-31 Mod 1 & 3 Guided Missile Weapons Systems Technician'),
('1110','TOMAHAWK Weapon System (VLS) Maintenance Technician'),
('1111','HARPOON Weapon System Maintenance Technician'),
('1112','TOMAHAWK Weapon System (Surface) Technician'),
('1116','Gun Computer System (GCS) MK 160 MOD 11/Electro-Optical Sensor System (EOSS) MK 20 MOD 0 Fire Control Technician'),
('1120','GCS MK 160 MOD 4 Fire Control Technician'),
('1121','CIWS MK-15 BLOCK 11-14 Technician'),
('1122','PHALANX Close-In Weapon System MK 15, MOD 21, 22, and 25 (BLOCK 1B) Technician'),
('1123','AGFCS MK37 Technician'),
('1124','AGFCS MK 86 MOD 3/4/5 Data Technician'),
('1125','AGFCS MK 86 MOD 3/4 System Technician'),
('1126','Automatic Gunfire Control Systems Technicians'),
('1127','AGFCS MK-15 BLOCK 0 (PHALANX) Technician'),
('1128','AGFCS MK 86 Radar Technician'),
('1129','AGFCS MK 86 MOD 8/9/10 Data Technician'),
('1130','AGFCS MK 86 MOD 5/8/9/10 System Technician'),
('1131','GFCS (MK 68) Technician/Supervisor'),
('1132','GFCS MK 68 (SPG-53F) Radar Technician'),
('1133','GFCS MK 68/MK 47 MOD 8/11 DIF Computer Technician'),
('1134','GFSC (MK 38) Technician'),
('1150','GFCS MK68 Mod 16 System Technician/Supervisor'),
('1151','GFCS MK68 Mod 16/MK160 Mod 1 Gun Computing System Technician'),
('1164','Ship Self Defense System (SSDS) MK1 Maintenance Technician'),
('1171','HARPOON (AN/SWG-1A) Operator/Maintainer'),
('1172','Fire Control Systems MK 117 Senior Maintenance Technician'),
('1173','Combat Control System MK 1 Senior Maintenance Technician'),
('1174','Combat Control System MK-1 Vertical Launch Subsystem Organizational/Intermediate Level Maintenance Technician'),
('1175','Combat Control System MK-1 MOD 1 Organizational/Intermediate Level Maintenance Technician'),
('1176','Underwater Fire Control System MK-117 Combined Maint. Technician'),
('1177','Underwater Fire Control System CCS MK 1 Combined Maintenance Technician'),
('1181','Underwater Fire Control System (MK 117 Mods 0, 1, 2, 3) Technician'),
('1182','Underwater Fire Control System MK117/CCS MK1 Conversion Technician'),
('1190','TRIDENT (AN/UYK-43) Submarine Comm. & Control Sys (CCS) O&M Tech.'),
('1191','Trident Defensive Weapons Subsys/Cmd Subsys Op/Maintenance Tech.'),
('1192','Underwater Fire Control System MK 112 MOD 2 Technicians'),
('1193','Underwater Fire Control System MK 113 MOD 6/8 Technician'),
('1194','AN/BSY-2(V) Advanced Maintainer'),
('1195','Underwater Fire Control System MK 101 MOD 17/18/19/20 Technician'),
('1196','Underwater Fire Control System MK 113 MOD 9 Technician'),
('1197','Underwater Fire Control System MK 113 MOD 10 Technician'),
('11AA','Shipboard Protection System (SPS) AN/SSQ-132(V)1 Operations and Maintenance Technician'),
('1301','TRIDENT DWS/CS Operation and Maintenance Technician'),
('1302','TRIDENT I LEVEL II DWS/CS Journeyman Operation and Maintenance Technician'),
('1303','TRIDENT I LEVEL III DWS/CS Master Operation and Maintenance Technician'),
('1304','TRIDENT II LEVEL II DWS/CS Journeyman Operation and Maintenance Technician'),
('1305','TRIDENT II LEVEL III DWS/CS Master Operation and Maintenance Technician'),
('1306','TRIDENT I (AN/UYK-7) CCS Level I Apprentice Operation and Maintenance Technician'),
('1307','TRIDENT I (AN/UYK-7) CCS Level II Journeyman Operation and Maintenance Technician'),
('1308','TRIDENT I (AN/UYK-7) CCS Level III Master Operation and Maintenance Technician'),
('1309','TRIDENT I/II (AN/UYK-43) CCS Level I Apprentice and Maintenance Technician'),
('1310','TRIDENT I/II (AN/UYK-43) CCS Level II Journeyman Operation and Maintenance Technician'),
('1311','TRIDENT I/II (AN/UYK-43) CCS Level III Master Operation and Maintenance Technician'),
('1312','CCS MK 2 MOD 0 Maintenance Technician'),
('1313','CCS MK 2 MOD 1 Maintenance Technician'),
('1314','CCS MK2 BLK 1 (all MODs) Maintenance Technician'),
('1315','CCS MK 2 MOD 3 Maintenance Technician'),
('1316','AN/BYG-1 (V) TI04 Combat Control Maintenance Technician'),
('1317','SSGN Tactical Tomahawk Weapon System (TTWCS) Operator'),
('1319','SSGN Tactical TOMAHAWK Weapon System (TTWCS) Maintenance Technician'),
('1320','TRIDENT MK 118 Combat Control System Maintenance Technician'),
('1323','AGFCS MK 86 MOD 8/10 Systems Technician'),
('1324','AGFCS MK 86 MOD 9 System Technician'),
('1325','Cooperative Engagement Capability (CEC) AN/USG-2 Cooperative Engagement Transmission Processing Set (CETPS) Technician'),
('1326','AN/SPQ-9B Radar Technician'),
('1327','Fire Control Technician Basic Maintainer'),
('1328','Master Fire Control Technician'),
('1329','Combat Control Subsystem Equipment Operator'),
('1330','Combat Control, Sonar and Architecture (CC/S/A) Equipment Technician'),
('1333','Advanced TOMAHAWK Weapon Control System (ATWCS) AN/SWG-4 Operator and Maintenance Technician'),
('1334','ATWCS Launch Control Group Replacement (LCGR) Operation and Maintenance Technician'),
('1336','AEGIS Weapons Systems Technician TRACK 3'),
('1340','AEGIS Weapon System MK-7 (TK-II) Supervisor'),
('1341','AEGIS Weapon System MK-7 (TK-II) Technician/AN/SPY-1 Radar (TK-I or II) Supervisor'),
('1342','AEGIS Weapon System MK-7 (TK-II) Technician/AEGIS Fire Control System MK-99/Operational Readiness Test System MK-1 (TK-I or II) Supervisor'),
('1343','AEGIS Weapon System MK-7 Technician (TK-II)/AEGIS Computer System (TK-II) Supervisor'),
('1344','AEGIS Weapon System MK-7 (TK-II) Technician/AEGIS Display System (TK-I or II) Supervisor'),
('1346','AN/BYG-1 (V)9 TI-10 Combat Control Maintenance Technician'),
('1347','AN/BYG-1(V) TI-12/14 Maintainer'),
('1350','AEGIS Weapon System MK-7 (TK-III) Supervisor'),
('1351','AEGIS Weapon System MK-7 (TK-III) Technician/AN/SPY-1 Radar (TK-II) Supervisor'),
('1352','AEGIS Weapon System MK-7 (TK-III) Technician/AEGIS Fire Control System MK-99/Operational Readiness Test System MK-1 (TK-II) Supervisor'),
('1355','AEGIS Weapon System MK-7 (TK-III)/AEGIS Computer Network Technician (TK-I) Supervisor'),
('1360','AEGIS Weapon System MK-7 (TK-IV) Supervisor'),
('1362','AEGIS Weapon System MK-7 Technician (TK-IV)/AEGIS Fire Control System MK-99/Operational Readiness Test System MK-1 (TK-II) Supervisor'),
('1365','AEGIS Weapon System MK-7 (TK-IV) Technician/AEGIS Computer Network Technician (TK-II or III) Supervisor'),
('1380','AEGIS Weapons System (AWS) Baseline 9A Supervisor'),
('1381','AEGIS Weapons System (AWS) Technician Baseline 9A AN/SPY-1B Radar Supervisor'),
('1382','AEGIS Weapon System (AWS) Technician Baseline 9A AEGIS Fire Control System (FCS) MK-99 Supervisor'),
('1387','AEGIS AN/SPY-1 Radar System Baseline 9C BMD 5.0 Technician'),
('1388','AEGIS AN/SPY-1 Radar System Baseline 9A Technician'),
('1390','AEGIS Weapon System (AWS) Baseline 9C Supervisor'),
('1391','AEGIS Weapons System (AWS) Technician Baseline 9C AN/SPY-1D Radar Supervisor'),
('1392','AEGIS Weapon System (AWS) Technician Baseline 9C AEGIS Fire Control System (FCS) MK-99 Supervisor'),
('4241','TRIDENT Submarine Aux Equipment Apprentice Technician (Level I)'),
('4242','TRIDENT Submarine Aux Equipment Journeyman Technician (Level II)'),
('4243','TRIDENT Submarine Aux Equipment Master Technician Level III'),
('4735','TRIDENT Submarine SC&AS Apprentice Oper & Maint Tech (Level I)'),
('4736','TRIDENT Submarine SC&AS Journeyman Oper & Maint Tech (Level II)'),
('4737','TRIDENT Submarine Ship Control and Atmosphere Support Master Operation and Maint Tech (Level III)'),
('9537','Aegis Combat System Technician'),
('FTG','Fire Control Technician G (Gunfire Control)'),
('112','Missile Guidance, Control and Checkout'),
('21G','PERSHING Electronics Materiel Specialist'),
('21L','PERSHING Electronics Repairer'),
('21R','SERGEANT Firing Set Repairman'),
('21S','SERGEANT Missile Guidance Repairman'),
('21T','SERGEANT Test Equipment Repairman'),
('21U','SERGEANT Maintenance Chief'),
('22K','HAWK Missile-Launcher Repairer'),
('22L','NIKE Test Equipment Repairer'),
('22N','NIKE-HERCULES Missile-Launcher Repairer'),
('23B','CORPORAL Fire Control Mechanic'),
('23Q','HAWK Fire Control Repairer'),
('23V','HAWK Maintenance Chief'),
('24D','HAWK Missile Launcher Mechanic'),
('24E','HAWK Fire Control Mechanic (RC)'),
('24F','HAWK Fire Control Mechanic'),
('24L','HAWK Launcher/Mechanical Systems Repairer'),
('24Q','NIKE-HERCULES Fire Control Mechanic'),
('24S','ROLAND System Mechanic'),
('24U','NIKE-HERCULES Custodial Mechanic'),
('24V','HAWK Maintenance Chief'),
('24W','SGT YORK Air Defense Gun Systems Mechanic'),
('27B','Land Combat Support System Test Specialist'),
('27C','ROLAND Repairer (RC)'),
('27E','Land Combat Electronic Missile System Repairer'),
('27F','VULCAN Repairer'),
('27G','CHAPARRAL/REDEYE Repairer'),
('27H','HAWK Field Maintenance/Firing Section Repairer'),
('27L','LANCE System Repairer'),
('27M','Multiple Launch Rocket System (MLRS) Repairer'),
('27P','SGT YORK Air Defense Gun Radar/Electrical Repairer'),
('27T','AVENGER System Repairer'),
('27V','HAWK Maintenance Chief'),
('27X','PATRIOT System Repairer'),
('27Z','Missile Systems Maintenance Chief'),
('28M','Anti-Ballistic Missile Maintenance Specialist'),
('35A','Land Combat Electronics Missile System Repairer'),
('35B','Land Combat Support Systems (LCSS) Test Specialist'),
('35P','Multiple Launch Rocket System (MLRS) Repairer'),
('35S','PATRIOT System Repairer'),
('35T','AVENGER System Repairer'),
('35V','Electronic and Missile Systems Maintenance Chief'),
('46D','Improved HAWK Mechanical Systems Repairman'),
('94A','Land Combat Electronic Missile System Repairer'),
('94P','Multiple Launch Rocket System (MLRS) Repairer'),
('94S','PATRIOT System Repairer'),
('94T','AVENGER System Repairer'),
('94V','Electronic and Missile Systems Maintenance Chief'),
('94X','Senior Missile Systems Maintainer'),
('180','Fire Control Technician'),
('112100','Missile Guidance and Control'),
('2M000','Missile And Space Systems Maintenance Manager'),
('2M031','Missile And Space Systems Electronic Maintenance Apprentice'),
('2M031A','Missile And Space Systems Electronic Maintenance Apprentice, ICBM'),
('2M031B','Missile And Space Systems Electronic Maintenance Apprentice, ALCM'),
('2M051','Missile And Space Systems Electronic Maintenance Journeyman'),
('2M051A','Missile And Space Systems Electronic Maintenance, ICBM'),
('2M051B','Missile And Space Systems Electronic Maintenance, ALCM'),
('2M071','Missile And Space Systems Electronic Maintenance Craftsman'),
('2M071A','Missile And Space Systems Electronic Maintenance, ICBM'),
('2M071B','Missile And Space Systems Electronic Maintenance, ALCM'),
('2M090','Missile And Space Systems Maintenance Superintendent'),
('31631','Missile Systems Maintenance Specialist'),
('31651','Missile Systems Maintenance Specialist'),
('31671','Missile Systems Maintenance Specialist'),
('41130','Missile Systems Maintenance Specialist'),
('41150','Missile Systems Maintenance Specialist'),
('41170','Missile Systems Maintenance Specialist'),
('41199','Missile Systems Maintenance Superintendent'),
('46600','Air Launched Missile Systems Manager'),
('46630','Air Launched Missile Systems Specialist'),
('46650','Air Launched Missile Systems Specialist'),
('46670','Air Launched Missile Systems Specialist'),
('46690','Air Launched Missile Systems Superintendent'),
('5911','Circuit Card Repairer'),
('5912','AVENGER System Maintainer'),
('5914','Surface to Air Missile Systems Ordnance Technician'),
('5915','Surface to Air Missile Systems Fire Control Technician'),
('5918','HAWK Missile Systems Operator/Technician'),
('5923','HAWK Firing Section Repairer'),
('5924','Surface Air Defense Systems Acquisition Technician'),
('5925','Surface Air Defense Systems Fire Control Technician'),
('5926','Improved HAWK Auto Fire Distr & Engagement Sim or Sys. Technician'),
('5927','Improved HAWK Fire Control Technician'),
('5928','Surface Air Defense Systems Chief'),
('5995','Missile System Maintenance Chief'),
('6352','Aircraft Weapons Systems Specialist, A-4/TA-4/OA-4'),
('6353','Aircraft Weapons Systems Specialist, A-6'),
('6354','Aircraft Weapons Systems Specialist, F-4S'),
('6355','Aircraft Weapons Systems Specialist, AV-8'),
('6357','Aircraft Weapons Systems Specialist, F/A-18'),
('6359','Aircraft Weapons Systems Specialist, EA-6A'),
('6362','Aircraft Weapons Systems Specialist, F-4N'),
('6364','Aircraft Weapons Systems Specialist, Helicopter/A-6/OV-10/F/A-18'),
('6367','Aircraft Integrated Weapon Systems Technician, F/A-18, OMA'),
('6423','Aviation Electronic Micro/miniature Component and Cable Repair Technician, IMA'),
('6434','Advanced Aircraft Electrical/Instrument/Flight Control Systems Technician, IMA'),
('6435','Aircraft Flight Control and Air Data Computer Systems Technician, Helo/KC-130/OV-10, IMA'),
('6442','Aircraft Analog Display System SACE Technician, A-6/EA-6, IMA'),
('6443','Aircraft Ballistics Computer Technician, A-6E, IMA'),
('6444','Aircraft Radar Systems Technician, A-6E/SACE, IMA'),
('6445','Aircraft Inertial Navigation Systems SACE Technician, A-6, IMA'),
('6446','Semi-Automatic Checkout Eqpt. (SACE) MATC/EMTC Systems Tech., IMA'),
('6461','Hybrid Test Set Technician, IMA'),
('6462','Avionics Test Set (ATS) Technician, IMA'),
('6464','Aircraft Inertial Navigation System Technician, IMA'),
('6465','Hybrid Test Set Technician, IMA'),
('6466','Consolidated Automatic Support System Electro-Optical (EO) Technician, IMA'),
('6467','Consolidated Automatic Support System (CASS) Technician, IMA'),
('6468','Aircraft Elec Equip Test Set (EETS)/Mobile Elec Test Set Tech, IMA'),
('6469','Reconfigurable Transportable Consolidated Automated Support System (RTCASS) Technician, IMA'),
('6472','Aircraft Weapons Systems Technician, A-4/AV-8, IMA'),
('6473','Aircraft Weapons Systems Technician, AERO-1A, IMA'),
('6474','Aircraft Weapons Systems Technician, AWG-10, IMA'),
('6477','Aircraft Forward Looking Infrared/TOW Technician, IMA'),
('6478','Advanced Aircraft Weapon Systems Technician, IMA'),
('6491','Aviation Precision Measuring Equipment (PME) Chief'),
('6492','Aviation Precision Measurement Equipment (PME) Calibration/Repair Technician, IMA'),
('6625','Aircraft Radar Reconnaissance Systems Technician, RF-4'),
('6640','Aviation Electronic Micro-Miniature Repair Technician'),
('6646','Aircraft Weapon Systems Technician, A-4/AV-8, IMA'),
('6647','Aircraft Ballistics Computer Technician, A-6E, IMA'),
('6648','Aircraft Radar Systems Technician, A-6E/SACE'),
('6649','Aircraft Forward Looking Infrared/TOW Technician, IMA'),
('6650','VAST Technician, IMA'),
('6651','VAST Repair Technician, IMA'),
('6652','Aircraft Search/Track Radar SACE Technician, A-6A, IMA'),
('6653','Aircraft Ballistics Computer SACE Technician, A-6A, IMA'),
('6654','Aircraft Inertial Navigation Systems SACE Technician, A-6A, IMA'),
('6655','Semi-Automatic Checkout Eqpt. (SACE) MATC/EMTC Systems Tech., IMA'),
('6656','Aircraft Weapon Systems Specialist, F-4N'),
('6657','Aircraft Weapon Systems Specialist, F-4J/S'),
('6658','Aircraft Weapon Systems Technician, AERO-1A, IMA'),
('6659','Aircraft Weapon Systems Technician, AWG-10, IMA'),
('6660','Aircraft Weapon Systems Specialist, Helicopter/A-6/OV-10'),
('6668','Aviation PME Calibration Technician'),
('6669','Aviation PME & ATE Repair Technician'),
('6682','Aviation PME Calibration Technician'),
('6683','Aviation Precision Measurement/Auto Test Equipment Repair Tech.'),
('6689','Aviation PME Chief'),
('7212','Low Altitude Air Defense (LAAD) Gunner'),
('8641','Microminiature Repairer'),
('001232','Combat Control Systems Operator'),
('001237','Combat Control Systems Technician'),
('001242','Combat Control Systems Manager'),
('001552','Strategic Weapons Manager'),
('001562','Strategic Weapons Technician'),
('001567','Strategic Weapons Operator'),
('003727','Fire Control Operator'),
('003728','Fire Control Technician'),
('003729','Fire Control Administrator'),
('0718','ASROC Missile Assemblyman'),
('0719','SUBROC Missile Test Equipment Technician'),
('0720','TOMAHAWK Cruise Missile Warheading Technician (Submarine)'),
('0721','SUBROC Missile Assemblyman'),
('0722','Vertical Launch ASROC (VLA) Missile Assemblyman'),
('0892','Basic Point Defense SMS Maintenanceman'),
('0981','MK-41 Vertical Launching System Maintenance Technician'),
('0982','Guided Missile Launching System (GMLS) MK 26 ORP Technician'),
('0985','TERRIER Missile and GMLS MK 10 (W/SSCS) Maintenance Technician'),
('0986','TERRIER Missile and GMLS MK 4/10 Maintenance Technician'),
('0987','TERRIER Missile and GMLS MK 11 Maintenance Technician'),
('0988','Tartar Missile and GMLS MK 13/22 Maintenance Technician'),
('0989','Guided Missile Launching System MK 26 MODS 0, 1, and 2 Maintenance Technician'),
('0990','Guided Missile Launching System & Missile Maintenance Technicians'),
('0991','Guided Missile Launching System MK-13 MOD 4/MK-22 MOD 1 Maintenance Technician'),
('1101','Fire Control System (FCS) MK-92 MOD 6 Coherent Receiver/Transmitter (CORT) Technician'),
('1102','MK 92 Fire Control System Technician'),
('1103','AEGIS Combat System Maintenance Supervisor'),
('1104','AEGIS Combat System (BL4) Maintenance Supervisor'),
('1105','AEGIS Weapon System MK 7 Technician'),
('1109','TERRIER Missile Fire Control Sys (MK 76 Mods 6, 7, 8) Technician'),
('1112','AEGIS Ballistic Missile Defense Weapon System Supervisor'),
('1113','TARTAR WDS MK 4 Technician'),
('1114','AEGIS Combat System Computer System Maintenance Technician'),
('1114','AEGIS Fire Control System MK-99/Operational Test System MK-1 Technician/AEGIS Ballistic Missile Defense Fire Control System Operator'),
('1115','AEGIS Combat System Display Maintenance Technician'),
('1116','TERRIER WDS MK 14/SYR-1 CTD Technician'),
('1117','TARTAR WDS MK 14 MOD 4/CTS SYR-1 Technician'),
('1118','AEGIS Display Technician (CG 60/DDG-58)'),
('1136','Tactical TOMAHAWK Weapon Control System (TTWCS) Operation and Maintenance (O&M) Technician'),
('1139','GCS MK 160 MOD 8/OSS MK 46 MOD 1 Fire Control Technician'),
('1145','Rolling Airframe Missile (RAM) MK-31 Guided Missile Weapons Systems Technician'),
('1146','Basic Point Defense SMS Technician'),
('1146','Gun Computer System (GCS) MK 160 MOD 9/10 Fire Control Technician'),
('1147','NATO SEASPARROW Surface Missile System MK 57 Mod 2, 3 Technician'),
('1148','NATO SEASPARROW Surface Missile System MK-57 Technician'),
('1149','Improved Point Defense Target Acquisition System MK-23 (IPD/TAS)'),
('1153','TARTAR MK 74 (Digital Update) Weapons Control System Technician'),
('1154','Missile Weapons Control Systems Technicians'),
('1155','TERRIER Missile Fire Control System MK 76 MOD 9 Technician'),
('1157','Improved Self Defense Surface Missile System Technician'),
('1158','TARTAR Missile Fire Control System (MK 74 Mod 14) Technician'),
('1159','TERRIER Missile Fire Control System MK 76 MOD 10 Technician'),
('1160','TARTAR Fire Control Radar Technician (MFCS MK 74 MOD)'),
('1165','Ship Self Defense System (SSDS) MK1 System Technician'),
('1170','IMA Fire Control Shop Journeyman'),
('1179','AN/BSY-1 (XN-1)(V) Organizational/Intermediate Level Maintenance Technician'),
('1180','AN/BSY-1 (XN-1)(V) Intermediate Level Maintenance Technician'),
('1331','AEGIS Weapons System Technician (TK IV)'),
('1332','Tomahawk Strike Manager (TSM)'),
('1356','Combat Systems Maintenance Manager (CSMM), Commercial Off The Shelf (COTS) Management'),
('1361','AEGIS Weapon System MK-7 Technician (TK-IV)/AN/SPY-1 Radar (TK-III) Supervisor'),
('1370','AEGIS Weapons System MK-7 (CR2) Supervisor'),
('1371','AEGIS Weapons System MK-7 (CR2) Technician/AN/SPY-1A Radar Supervisor'),
('1372','AEGIS Weapons System MK-7 (CR2) Technician/AEGIS Fire Control System MK-99 Supervisor'),
('1375','AEGIS Weapons System MK-7 (CR2) Technician/AEGIS Computer Network Technician Supervisor')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 10...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('1628','SSDS MK2 Maintenance Technician'),
('3301','FBM Weapons & Navigation System Technician - Special Category'),
('3302','Missile Fire Control System Technician (POLARIS A-3 Intermediate Level Maintenance)'),
('3303','Missile Fire Control Systems Technician (MK88 MOD 1 with POSEIDON)'),
('3303','Missile Technician TRIDENT II SWS MK 98 MOD 6'),
('3304','Missile Fire Control Systems Technician (ILM C3 or C4)'),
('3305','Missile Tech (MK 88 MOD2 FC Sys w/TRIDENT-I Backfit SSBN or MK 98 MOD O FC Sys w/ TRIDENT-I SSBN)'),
('3307','Missile Technician (MK 98 MOD 1) TRIDENT II D-5 SWS'),
('3310','Missile Technician (TRIDENT I (C-4) SWS)'),
('3311','Missile Technician (TRIDENT II (D-5) SWS)'),
('3312','Missile Technician TRIDENT II SWS D-5 Backfit'),
('3313','Missile and Missile Checkout Technician (POSEIDON SSBN)'),
('3314','Missile and Missile Checkout Technician (POSEIDON C-3 ILM)'),
('3315','Missile and Missile Checkout Technician (TRIDENT-I Backfit SSBN)'),
('3316','Missile and Missile Checkout Technician (ILM on C-4 Capable SSBN)'),
('3317','Missile Technician (TRIDENT-I SSBN)'),
('3318','POSEIDON/TRIDENT-1 Backfit FBM Tender Missile Technician'),
('3319','Missile and Missile Checkout Technician (TRIDENT D-5 SWS SSBN)'),
('3320','Nuclear Weapons Specialist'),
('3342','PORI/IDAS Technician'),
('3346','Missile Fire Control Technician (Poseidon C-3 IMA)'),
('3348','In-Tube Conversion Technician'),
('3349','Fleet Ballistic Missile Weapons and Navigation System Technician - Special Category'),
('3350','SSGN Attack Weapon System (AWS) Missile Technician'),
('3375','Strategic Weapon System Master Chief (SWSMC)'),
('3380','Planning Series - TRIDENT II SWS MT Apprentice'),
('3381','Planning Series - TRIDENT II SWS MT Journeyman'),
('3397','In-Tube Conversion Technician'),
('7986','AWG-9/AWM-23 Phoenix AMCS Radar IMA Technician'),
('FC','Fire Controlman'),
('FT','Fire Control Technician'),
('FTB','Fire Control Technician B (Ballistic Missile Fire Control)'),
('FTM','Fire Control Technician M (Surface Missile Fire Control)'),
('MT','Missile Technician'),
('24G','HAWK Information Coordination Central Mechanic'),
('24H','HAWK Fire Control Repairer'),
('27D','ROLAND FMTS Repairer (RC)'),
('27Q','SGT YORK Air Defense Gun System Test Specialist'),
('112200','Missile Checkout Equipment, Test Equipment, and Calibration'),
('2E800','Instrumentation And Telemetry Systems Manager'),
('2E831','Instrumentation And Telemetry Systems Apprentice'),
('2E851','Instrumentation And Telemetry Systems Journeyman'),
('2E871','Instrumentation And Telemetry Systems Craftsman'),
('2E891','Instrumentation And Telemetry Systems Superintendent'),
('30800','Instrumentation and Telemetry Systems Manager'),
('30830','Instrumentation and Telemetry Systems Specialist'),
('30850','Instrumentation and Telemetry Systems Specialist'),
('30870','Instrumentation and Telemetry Systems Specialist'),
('30890','Instrumentation and Telemetry Systems Superitendent'),
('31600','Instrumentation Manager'),
('31630','Missile Systems Analysis Specialist'),
('31632','Missile Electronic Equipment Specialist'),
('31633','Instrumentation Specialist'),
('31650','Missile Systems Analysis Specialist'),
('31652','Missile Electronic Equipment Specialist'),
('31653','Instrumentation Specialist'),
('31670','Missile Systems Analysis Specialist'),
('31672','Missile Electronic Equipment Specialist'),
('31673','Instrumentation Specialist'),
('31693','Missile Electronic Maintenance Superintendent'),
('31699','Missile Electronic Maintenance Superintendent'),
('31730','Instrumentation Mechanic'),
('31750','Instrumentation Mechanic'),
('31770','Instrumentation Mechanic'),
('41100','Missile Systems Maintenance Manager'),
('99139','ICBM Maintenance Manager'),
('99601','Missile Maintenance Manager'),
('191','Torpedoman''s Mate'),
('112300','Torpedo Repair'),
('0715','Torpedo (MK-14/Mod 5 & MK 16/Mod 8) Maintenance Technician'),
('0746','Advanced Undersea MK 46 Maintenance Weaponsman'),
('0747','Advanced Undersea MK 46 Test Equipment Weaponsman'),
('0748','Advanced Undersea MK 46 Weaponsman'),
('0749','MK 48 Heavyweight Torpedo Test Equipment Maintenance Technician'),
('0750','Torpedo MK48 Heavyweight Off-Line Technician'),
('0751','Torpedo MK48 Heavyweight On-Line Technician'),
('0752','MK 50 Torpedo Maintenance Technician'),
('0754','TRIDENT Torpedoman''s Mate (Level III)'),
('4236','Combined Torpedo MK48 Heavyweight Technician'),
('TM','Torpedoman''s Mate'),
('113','Sonar Equipment'),
('140','Sonar Technician'),
('160','Sonar Watchstander'),
('275','Information Systems Technician'),
('113000','Sonar, General'),
('001755','Basic Sonar Operator'),
('001760','Advanced Sonar Operator'),
('001765','Sonar Supervisor'),
('003746','Anti-Submarine Warfare Operations Manager'),
('003747','Anti-Submarine Warfare Equipment Operator'),
('003748','Anti-Submarine Warfare Equipment Technician'),
('0401','AN/SQQ-30 Mine Classifying/Detecting Set Maintenance Technician'),
('0402','AN/SQQ-89(V)2/9 Active Sonar Level II Technician'),
('0403','AN/SQQ-28(V) Sonar Subsystem Level I Technician (Operator)'),
('0404','AN/SQQ-28(V) Sonar Subsystem Level II Technician'),
('0405','Sonar Auxiliary Maintenance and Operations Repairman'),
('0406','AN/SQQ-89(V)2/(V)9 Sonar Subsystem Level I Operator'),
('0407','AN/SQQ-89(V)2/3/5 Passive Sonar Level II Technician/Operator'),
('0408','Underwater Object Locator (SQQ-14) Repairman & Operator'),
('0409','Submarine Sonar (BQG Series) Technician'),
('0410','AN/SLQ-48(V) Mine Neutralization Systems (MNS) Operator/Maintenance Technician'),
('0411','AN/SQQ-89(V)4/6 Sonar Subsystem Level I Operator'),
('0412','BQQ-5/5 (V) Submarine Sonar Basic Maintenance Technician'),
('0413','AN/SQQ-89(V)3/5/8 Sonar Subsystem Level I Operator'),
('0414','AN/SQQ-89(V)3/5 Active Sonar Level II Technician/Operator'),
('0415','AN/SQQ-89(V) 2/3/4/6/7/8/9/12 Passive Sonar Level II Technician/Operator'),
('0418','AN/BSY-1 (XN-1)(V) Basic Organizational Maintenance Technician'),
('0419','AN/BSY-1 (XN-1)(V) Advanced Organizational Maintenance Technician'),
('0420','AN/BSY-1 (XN-1)(V) Intermediate Level Maintenance Technician'),
('0421','Submarine Special Purpose Acoustic Equipment Maintenance Technician'),
('0422','BQQ-5/5 (Series) Submarine Sonar Advanced Maintenance Technician'),
('0423','AN/BQQ-6 TRIDENT Level I Apprentice Operation & Maintenance Tech'),
('0424','AN/BQQ-6 TRIDENT Level II Journeyman Operation and Maintenance Technician'),
('0425','AN/BQQ-6 TRIDENT Level III Master Operation and Maintenance Technician'),
('0426','BQQ-6 Sonar Equipment Maintenance Technician'),
('0427','Submarine Sonar System OA-1283 Maintenance Technician'),
('0428','SSBN/Pre-594 Class SSN Sonar Technician'),
('0429','AN/SQQ-89(V) MK-116 Mod 6/7/8 Anti-Submarine Warfare Control System Level II Technician'),
('0430','Underwater Fire Control System MK-116 MOD 7 Anti-Submarine Warfare Control System Operator'),
('0431','MK 111 ASROC Underwater Fire Control System Level II Technician'),
('0432','MK 114 MOD 24/27 ASROC Underwater Fire Control System Level II'),
('0433','MK 114 MOD 25/26 TERRIER/ASROC Underwater Fire Control Level II'),
('0434','MK 114 ASROC Underwater Fire Control System Level II Technician'),
('0435','MK 114 MOD 9 TERRIER/ASROC Underwater Fire Control Level II Tech.'),
('0436','MK-116 MOD 2/4/4A Underwater Fire Control Subsystem Level II Technician/Operator'),
('0437','MK 116 MOD 0 ASROC Underwater Fire Control System Level II Tech.'),
('0438','MK-116 MOD 1 Underwater Fire Control System Level II Technician'),
('0439','Underwater Fire Control System MK-116 MOD 6/8 Anti-Submarine Warfare Control Subsystem Operator'),
('0440','Surface Sonar Supervisor'),
('0441','Surface Sonar Operator'),
('0442','AN/SQR-15 TASS Operator'),
('0443','AN/SQR-17/17A(V) Series Sonar Signal Processor Subsystem (SSPS) Level II Technician'),
('0444','FF-1052 Sonar System Operator'),
('0445','Basic Acoustic Analyst'),
('0446','Acoustic Processor (SQS-54) Technician'),
('0447','Acoustic Processor (SQR-17) Technician'),
('0449','AN/SQR-18A(V) 1 Tactical Towed Array Sonar (TACTAS) Subsystem Level II Technician'),
('0450','Journeyman Level Acoustic Analyst'),
('0451','AN/ASQ-18A(V2) TACTAS Subsystem Level II Technician'),
('0452','AN/SQS-26B Sonar Level II Technician'),
('0454','AN/SQS-26C Sonar Subsystem Level II Technician'),
('0455','AN/SQQ-89(V)4/6 Active Sonar Level II Technician'),
('0456','AN/SQS-35 IVDS Subsystem/SQQ-13 Hoist Level II Technician'),
('0457','AN/SQS-53A Sonar Subsystem Level II Technician/Operator'),
('0458','SQS-56 Surface Set Shipboard Maintenance Technician'),
('0459','AN/SQQ-23 PAIR Sonar System Level II Technician'),
('0461','AN/BSY-2(V) Advanced Maintainer'),
('0464','AN/SQQ-89(V)1/3 Sonar Supervisor'),
('0465','AN/SQQ-89(V)2 Sonar Supervisor'),
('0466','Journeyman Surface Ship USW Supervisor'),
('0467','FF-1052 Sonar Supervisor'),
('0469','AN/SQQ-89(V)14 Sensor Level II Technician/Operator'),
('0472','AN/SQS-53A Sonar/MK 116 MOD 4 ASW Fire Control System Level II Tec'),
('0473','AN/SQS-53A Sonar/MK 116 MOD 1 Terrier/ASROC ASW FCS Level II Tech'),
('0474','AN/SQS-53A Sonar/MK 116 MOD 0 Underwater FCS Level II Tech'),
('0475','AN/SQQ-23 Sonar/MK 111 ASROC ASW Fire Control System Level II Tech'),
('0476','AN/SQQ-89(V) 10 Sensor Level II Technician/Operator'),
('0477','AN/SQQ-23 Sonar/MK 114 ASROC ASW Fire Control System Level II Tech'),
('0482','AN/SQQ-26B Sonar/MK 114 ASROC ASW Fire Control System Level II Tec'),
('0483','AN/SQS-26C Sonar/MK 114 ASROC ASW Fire Control System Level II Tec'),
('0488','AN/SQQ-32 Minehunting Sonar Set Operator'),
('0490','AN/SQQ-32 Minehunting Sonar Set Maintenance Technician'),
('0492','AN/SQS-26B Sonar/MK 114 MOD 9 Terrier/ASROC ASW FCS Level II Tech'),
('0495','Sonar Technician AN/BQQ5 Series (B/C/D/E) Advanced Maintainer'),
('0496','Surface Sonar/ASW Fire Control Systems Technicians'),
('0501','Sonar (Submarines) Leading Chief Petty Officer'),
('0502','SQQ-23 Sonar MK-114 MOD 25/26 ASROC ASW Fire Contl Sys Levl II Tec'),
('0503','SQS-16BX Sonar/MK-114 MOD 25/26 Terrier ASROC ASW Fire Levl II Tec'),
('0504','SQS-26 CX/MX-114 MOD 24/27 ASROC ASW Fire Contl Sys Level II Tech'),
('0508','AN/SQQ-89(V)14 Sonar System Level I Operator'),
('0509','AN/SQQ-89(V) Adjunct Subsystem Level II Technician'),
('0510','AN/SQS-53D Sensor Subsystem Level II Technician/Operator'),
('0511','AN/SQQ-89(V) 11/12 Sonar Subsystem Level I Operator'),
('0512','AN/BSY-1 and AN/BQQ-5E Combined Retained Equipment Maintenance Technician'),
('0516','AN/SQQ-89(V)14 Undersea Warfare Control Operator'),
('0518','Sonar Technician AN/BQQ-10(V) Operator/Maintainer'),
('0519','Sonar Subsystem Equipment Operator'),
('0520','Sonar, Combat Control and Architecture (S/CC/A) Equipment Technician'),
('0522','AN/SQQ-89(V)15 Sonar System Level II Technician'),
('0523','AN/SQQ-89(V)15 Sonar System Journeyman'),
('0524','AN/SQQ-89A(V)15/(V)15 EC204 Surface Ship USW Combat Systems Senor Operator'),
('0525','AN/SQQ-89A(V)15 Surface Ship USW Combat Systems Maintenance Technician'),
('0527','AN/SQQ-89A(V)15/(V)15 EC204 Surface Ship USW Combat Systems Journeyman'),
('0528','Planning Series - AN/WLD-1(V)1 Remote Minehunting System Operator'),
('0529','Planning Series - AN/WLD-1(V)1 Remote Minehunting System Variable Depth Sensor (VDS) Maintenance Technician'),
('0530','AN/BQQ-10(V) TI-10/12 Operator/Maintainer'),
('0550','Integrated Undersea Surveillance System (IUSS) Passive Sensor Operator (PSO)'),
('0550','Planning Series - IUSS Passive Sensor Operator (PSO)'),
('0551','Integrated Undersea Surveillance System (IUSS) Supervisor'),
('0551','Planning Series - IUSS Supervisor'),
('0552','Integrated Undersea Surveillance System (IUSS) Low Frequency Active (LFA)/Compact Low Frequency Active (CLFA) Operator'),
('0552','Planning Series - IUSS Low Frequency Active (LFA)/ Compact Low Frequency Active (CLFA) Operator'),
('0553','Integrated Undersea Surveillance System (IUSS) SURTASS Mission Commander'),
('0553','Planning Series - IUSS SURTASS Mission Commander'),
('0622','Ocean Systems Maintenance Technician'),
('0623','TASS Maintenance Technician'),
('0624','SURTASS Maintenance Technician'),
('0625','Ocean Systems Advanced Maintenance Technician'),
('0626','Ocean Systems ADP Maintenance Technician'),
('0627','Searchlight Surveillance Maintenance Technician'),
('0628','Ocean Systems Communications Maintenance Technician'),
('0629','TDP Maintenance Technician'),
('1212','AN/SQQ-32(V)3 Minehunting Sonar Set Maintenance Technician'),
('1214','AN/SQQ-32 (V) 4 Minehunting Sonar Set (MSS) Operator'),
('1215','AN/SQQ-32 (V) 4 Minehunting Sonar Set (MSS) Maintenance Technician'),
('23JH','Submarine Radioman Tactical Communications (TACTICOMM) Equipment Technician'),
('23JL','Submarine Radioman Tactical Communications Equipment Technician'),
('9616','AN/SSN-2(V)5 Precise Integrated Navigation System (PINS) O & M Technician'),
('OTA','Ocean Systems Technician Analyst'),
('OTM','Ocean Systems Technician Maintainer'),
('ST','Sonar Technician'),
('STG','Sonar Technician (Surface)'),
('STS','Sonar Technician (Submarine)'),
('114','Nuclear Weapons Equipment'),
('35F','Nuclear Weapons Electronics Specialist'),
('114000','Nuclear Weapons Equipment Repair, General'),
('2W200','Nuclear Weapons Manager'),
('2W231','Nuclear Weapons Apprentice'),
('2W251','Nuclear Weapons Journeyman'),
('2W271','Nuclear Weapons Craftsman'),
('2W291','Nuclear Weapons Superintendent'),
('46300','Nuclear Weapons Manager'),
('46330','Nuclear Weapons Specialist'),
('46350','Nuclear Weapons Specialist'),
('46370','Nuclear Weapons Specialist'),
('46390','Nuclear Weapons Superintendent'),
('115','ADP Computers'),
('14L','AN/TSQ-73 Air Defense Artillery Command and Control System Operator/Maintainer'),
('25D','BIRDIE Repairman'),
('25G','Mobile Air Defense Command Post Monitor Repairman'),
('25H','Radar Data Processing Equipment Repairman'),
('25J','Operations Central Repairer'),
('25K','AN/TSQ-51 System Repairer/Maintenance Chief'),
('25L','AN/TSQ-73 ADA Command & Control System Operator/Maintainer'),
('29G','Digital Communications Equipment Repairer'),
('29H','ADMSE Repairer'),
('29U','Digital Equipment Maintenance Chief'),
('34B','Card Punch Machine Repairer'),
('34C','Decentralized Auto Support Systems (DAS3) Computer Repairer'),
('34D','ADPS Repairman'),
('34E','NCR 500 Computer Repairer'),
('34F','DSTE Repairer'),
('34H','ADMSE Repairer'),
('34J','Univac 1004/1005 DCT 9000 System Repairer'),
('34K','IBM 360 Repairer'),
('34M','SDS 920 Equipment Repairman'),
('34T','Tactical Computer Systems Repairer'),
('34Z','ADP Maintenance Supervisor'),
('39D','DAS3 Computer Systems Repairer'),
('39G','Automated Communications Computer Systems Repairer'),
('39K','IBM ADPS Repairer'),
('39L','Field Artillery Digital Systems Repairer'),
('39T','Tactical Computer System Repairer'),
('39V','Computerized System Maintenance Chief'),
('74G','Telecommunications Computer Operator-Maintainer'),
('115000','ADP Computers, General'),
('11830','Airborne Computer Systems Specialist'),
('11850','Airborne Computer Systems Specialist'),
('11870','Airborne Computer Systems Specialist'),
('1A500','Airborne Missions Systems Manager'),
('1A531','Airborne Missions Systems Apprentice'),
('1A551','Airborne Missions Systems Journeyman'),
('1A571','Airborne Missions Systems Craftsman'),
('1A591','Airborne Missions Systems Superintendent'),
('1B131','Client Systems Apprentice'),
('1B132','Cyber Transport Systems Apprentice'),
('1B151','Client Systems Journeyman'),
('1B152','Cyber Transport Systems Journeyman'),
('1B171','Client Systems Craftsman'),
('1B172','Cyber Transport Systems Craftsman'),
('2E231','Network Infrastructure Systems Apprentice'),
('2E231A','Electronic Computer and Switching Systems Apprentice, AN/TYQ-23(V)2 Modular Control Equipment (MCE)'),
('2E231B','Electronic Computer and Switching Systems Apprentice, Airborne Computer Maintenance'),
('2E231C','Electronic Computer and Switching Systems Apprentice, Strategic Communications Systems'),
('2E231D','Electronic Computer and Switching Systems Apprentice, AN/FYQ-93 Joint Surveillance System (JSS)'),
('2E231E','Electronic Computer And Switching Systems, General Computer Systems'),
('2E231K','Electronic Computer And Switching Systems, HM-4118/407l'),
('2E231L','Electronic Computer And Switching Systems, SAC Digital Network'),
('2E231M','Electronic Computer And Switching Systems, AN/FYQ-93'),
('2E231P','Electronic Computer And Switching Systems, 490l O/S Autovon'),
('2E231Q','Electronic Computer And Switching Systems, AN/TTC-30 Electronic Switching System'),
('2E231R','Electronic Computer And Switching Systems, 427M Computer Maintenance'),
('2E231T','Electronic Computer And Switching Systems, Airborne Computer Maintenance'),
('2E251','Network Infrastructure Systems Journeyman'),
('2E251A','Electronic Computer and Switching Systems Journeyman, AN/TYQ-23(V2) Modular Control Equipment (MCE)'),
('2E251B','Electronic Computer and Switching Systems Journeyman, Airborne Computer Maintenance'),
('2E251C','Electronic Computer and Switching Systems Journeyman, Strategic Communications Systems'),
('2E251D','Electronic Computer and Switching Systems Journeyman, AN/FYQ-93 Joint Surveillance System (JSS)'),
('2E271','Network Infrastructure Systems Craftsman'),
('2E290','Communications Infrastructure Systems Superintendent'),
('2E291','Computer Network, Switching and Cryptographic Systems Superintendent'),
('30534','Electronic Computer and Switching Systems Specialist'),
('30554','Electronic Computer and Switching Systems Specialist'),
('30574','Electronic Computer and Switching Systems Specialist'),
('30594','Electronic Computer and Switching Maintenance Superintendent'),
('3D131','Client Systems Apprentice'),
('3D151','Client Systems Journeyman'),
('3D171','Client Systems Craftsman'),
('2608','Electronic Digital Computer Mechanic'),
('2690','Digital Computer Mechanic'),
('0659','Cyber Network Systems Chief'),
('0699','Communications Chief'),
('2821','Computer Technician'),
('2824','Microcomputer Organizational Maintainer'),
('2826','AN/MSC-63A Maintenance Technician'),
('2842','Enhanced Position Location Reporting System (EPLRS) System Specialist'),
('2855','Tactical Electronic Reconnaissance Process/Evaluations System (TERPES) Technician'),
('5962','Tactical Data Systems Equipment (TDSE) Repairer'),
('5963','Tactical Air Operations Module Repairer'),
('5964','Tactical Air Command Center CTAPS/Systems Administrator'),
('5974','Tactical Data Systems Technician'),
('5977','Tactical General Purpose Computer Technician'),
('5978','Tactical Data Communications Central Technician'),
('5979','Tactical Air Operations/Air Defense Systems Technician'),
('5982','Computer Systems Technician Honeywell DPS6 (AN/UYK-65V) System'),
('5994','Tactical Data Systems Maintenance Chief'),
('6494','Aviation Logistics Tactical Information Systems (ALTIS) Specialist'),
('001414','Information Technology Network Systems Specialist'),
('001422','Information Technology Security Manager'),
('001427','Information Technology Security Technician'),
('001432','Information Technology Technician'),
('002684','Digital computer Network Analyst'),
('002712','Information Systems Technician Submarines'),
('002713','Information Technology Manager Submarines'),
('1091','AEGIS Computer System Ballistic Missile Defense (BMD) 4.X Technician'),
('1097','Aegis Ballistic Missle Defense (BMD) 4.X Supervisor'),
('1107','AEGIS Radar System (SPY-1A) Technician'),
('1111','AEGIS Combat System Computer System Maintenance Technician/AEGIS Ballistic Missile Defense Computer Technician'),
('1144','AEGIS Combat System (BL4) Computer System Maintenance Technician'),
('1152','AN/SYQ-27 Naval Fire Control System (NFCS) Phase I Fire Control Technician'),
('1183','TARTAR WDS MK 13 MOD 4 Computer Complex Technician'),
('1188','TARTAR Fire Control Computer MK 152 Complex Technician'),
('1189','TERRIER Fire Control Computer MK 152 Complex Tech. Maint. Technician'),
('1318','AEGIS Computer Network Technician, Track II'),
('1322','AEGIS Display Technician'),
('1335','UYQ-70 Computer/Display LAN Technician'),
('1339','AEGIS Computer Network Technician, Track III'),
('1345','AEGIS Computer Network Technician (ACNT) (TK IV)'),
('1348','CEC AN/USG-2B Technician'),
('1385','AEGIS Fire Controlman (FC), AEGIS Weapon System (AWS) Technician Baseline 9A AEGIS Computer Network Technician (ACNT) Supervisor'),
('1386','AEGIS Fire Controlman (FC) AEGIS Computer Network Baseline 9 (9A/9C) Technician (ACNT)'),
('1395','AEGIS Fire Controlman (FC), AEGIS Weapon System (AWS) Technician Baseline 9C AEGIS Computer Network Technician (ACNT) Supervisor'),
('1397','CSMM Rating Enhancing Shore Duty'),
('1601','SSDS OA Maintenance Technician'),
('1613','Command Center Maintenance Technician'),
('1614','FDDS Maintenance Technician'),
('1615','Shipboard Tactical Data Systems Technician'),
('1616','Data Display Equipment Maintenance Technician'),
('1622','CDS Upgrade Computer/Peripheral Maintenance Technician'),
('1623','Data Communications LINK Maintenance Technician'),
('1624','AN/UYQ-21 Computer Display System Maintenance Technician'),
('1625','AN/SYQ-24(V) 1 Maintenance Technician'),
('1633','ASWOC Fast Time Analyzer Subsystem (FTAS) Maintenance Technician'),
('1634','ASWOC Data Systems Maintenance Technician'),
('1635','Message Processing Distribution System (MPDS) Technician'),
('1636','UYK-4 (V) Computer System Maintenance Technician'),
('1637','Submarine Computer System Maintenance Technician'),
('1638','Trident Sub Command & Control Systems (CCS) Op. & Maint. Tech.'),
('1645','FLTSATCOM (SSIXS/ISABPS) OPCONCEN Maintenance Technician'),
('1646','FLTSATCOM (SSIXS-OPCONCEN) Maintenance Technician'),
('1647','NCCS Ashore Maintenance Technician'),
('1648','NCCS Ashore Operations Support System Maintenance Technician'),
('1653','NIPS Maintenance Technician'),
('1654','Intelligence Center Maintenance Technician'),
('1655','CV-ASWM Data Systems Technician'),
('1656','CVN Combat Direction System (CDS)/Antisubmarine Warfare Module (ASWM) Computer/Peripheral Subsystem Maintenance'),
('1657','CV-ASWM Fast Time Analyzer Subsystem Upgrade (FTAS-U) Systems Technician'),
('1658','LDH 1 Class ITAWDS Computer/Peripheral Subsystem Maintenance Technician'),
('1664','SNAP I Computer System Maintenance Technician'),
('1665','UYA-4 Data Display Equipment Maintenance Technician'),
('1666','UYK-5(V) Computer System Maintenance Technician'),
('1667','UYK-7 Computer & Associated Peripheral Technician'),
('1668','USQ-20(V) Peripheral & Conversion Eqpt. Maintenance Technician'),
('1671','FFG-7 Class Computer/Peripheral Technician'),
('1672','DD-963 Class Computer/Peripheral Technician'),
('1673','LHA Class Computer & Associated Subsystems Technician'),
('1674','LHA Integrated Tactical Amphibious Warfare Data Systems Maintenance Technician'),
('1676','Afloat Planning System (APS) Maintenance Technician'),
('1677','Tactical Advanced Computer (TAC-n) Maintenance Technician'),
('1678','Information System Maintenance Technician'),
('1681','FFG-7 Class Display Equipment Maintenance Technician'),
('1682','DD-963/LHA Class Display Equipment Maintenance Technician'),
('1683','CGN-38 Class Display Equipment Maintenance Technician'),
('1684','CG/CGN/DDG CDS Upgrade Data Display Technician'),
('1686','ASWOC Data Systems Maintenance Technician'),
('2762','Punched Card Accounting Machine (PCAM) Repairman'),
('2765','Global Command and Control System-Maritime (4.1) Increment 2 System Administrator'),
('2766','Global Command and Control System-Maritime 4.0.3 (GCCS-M 4.0.3) System Administrator'),
('2791','Information Systems Administrator (IAT II)'),
('2792','CANES AN/USQ-208(V) System Administrator/Maintainer'),
('6533','ASA-16 Integrated Tactical Display IMA Technician'),
('6555','S3A Weapons System Integrator'),
('6556','S-3B Computer System Specialist'),
('6569','ASW Operations Center Technician'),
('6607','Digital Data Link Communications IMA Technician'),
('6623','CI ASA-27 SACE Test Bench IMA Technician'),
('6625','USM-449 (V) & AAI 5500 Series ATE Int Maintenance Level Tech.'),
('6626','CD CP-413/ASA-27A SACE Test Bench IMA Technician'),
('6627','ASQ-52 Multi-Purpose Communications System IMA Technician'),
('6629','USM-449 (V) & AAI 5500 Series ATE Operator'),
('6666','EA-6B EXCAP Central Computer (AYA-6) Technician'),
('7171','CP-953 ADC & AJM-32 SSE IMA Technician'),
('7961','ASQ-61A Ballistic Computer & ASM-308 Test Bench IMA Technician'),
('7985','ASM-624 Operator/AWM-23 Test Equipment Calibrator'),
('7988','AWG-9/AWM-23 Low Frequency Test Station IMA Technician'),
('7989','AWG-9/AWM-23 Computer Test Station IMA Technician'),
('7991','AWG-9/AWM-23 Controls & Displays Test Station IMA Technician'),
('7992','AWG-9/AWM-23 Module Test Station IMA Technician'),
('9517','Ship''s 3-M System Coordinator'),
('9573','SNAP II Ship System Coordinator'),
('DS','Data Systems Technician'),
('IT','Information Systems Technician'),
('ITS','Information Systems Technician Submarines'),
('116','Teletype and Cryptographic Equipment'),
('29F','Fixed COMSEC Equipment Repairer'),
('29J','Teletypewriter Equipment Repairer'),
('29P','COMSEC Maintenance Chief'),
('29S','Communications Security Equipment Repairer'),
('31J','Teletypewriter'),
('32F','Fixed Ciphony Repairer'),
('32G','Fixed Cryptographic Equipment Repairer'),
('35J','Computer/Automation Systems Repairer'),
('116000','Teletype and Cryptographic Equipment, General'),
('2E331','Secure Communications Systems Apprentice'),
('2E351','Secure Communications Systems Journeyman'),
('2E371','Secure Communications Systems Craftsman'),
('2E391','Secure Communications Systems Superintendent'),
('30630','Electronic Comm. & Cryptographic Equipment Systems Specialist'),
('30631','Electronic-Mechanical Comm. & Crypto. Equipment Systems Spec.'),
('30632','Telecom Sys/Equipment Maintenance Specialist'),
('30633','Secure Communications Systems Maintenance Specialist'),
('30636','Secure Communications Systems Maintenance'),
('30650','Electronic Comm. & Cryptographic Equipment Systems Specialist'),
('30651','Electronic-Mechanical Comm. & Crypto. Equipment Systems Spec.'),
('30652','Telecom Sys/Equipment Maintenance Specialist'),
('30653','Secure Communications Systems Maintenance Specialist'),
('30656','Secure Communications Systems Maintenance'),
('30670','Electronic Comm. & Cryptographic Equipment Systems Specialist'),
('30671','Electronic-Mechanical Comm. & Crypto. Equipment Systems Spec.'),
('30672','Telecom Sys/Equipment Maintenance Specialist'),
('30673','Secure Communications Systems Maintenance Specialist'),
('30676','Secure Communications Systems Maintenance'),
('30692','Telecom Fac Elec/Elec Mech Comm & Crypto Equipment Systems Supt.'),
('30699','Telecom Fac Elec/Electromech Comm & Crypto Equip Systems Supt.'),
('36232','Electronic Switching Systems Specialist'),
('36252','Electronic Switching Systems Specialist'),
('36272','Electronic Switching Systems Specialist'),
('36330','Comm. & Relay Ctr. Equipment Repairman, Electro-Mechanical'),
('36350','Comm. & Relay Ctr. Equipment Repairman, Electro-Mechanical'),
('36370','Comm. & Relay Ctr. Equipment Repairman, Electro-Mechanical'),
('2818','Personal Computer/Tactical Office Machine Repairer'),
('2819','KG/13 Teletype Technician'),
('2825','Fixed Ciphony Technician'),
('2827','Mobile Data Terminal Technician'),
('2828','KW-26 Terminal Technician'),
('2829','Mobile Communications Central Technician'),
('2891','Ground Electronics Systems Maintenance Chief'),
('1449','NBST Equipment Technician'),
('1460','Limited Communications Security (COMSEC) Maintenance Technician'),
('1573','AIMS (TSEC/Crypto) Technician'),
('2306','Computer Based Training Technician'),
('2314','Cryptographic Machines Repairman'),
('2332','Submarine Radioman Crypto Technician'),
('2342','Teletype MOD 28, UGC-6 and UGC-20 Repairman'),
('2343','AN/UGC-143 A (V) Communications Maintainer'),
('2345','Teletype (UGC-20/258 TT-187 TT-253) Repairman'),
('2346','Low-Level Keying Teletype Repairman'),
('23EY','Submarine Radioman Strategic Communications (STRATEGICOMM) Equipment Technician'),
('23JS','Submarine Radioman Tactical Communications (TACTICOMM) Equipment Technician'),
('23MZ','Submarine Radioman Communications (SUBCOMM) Combined Maintenance Technician'),
('23NG','Submarine Radioman Communications Combined Maintenance Technician'),
('23NH','Submarine Radioman Communications Combined Maintenance Technician'),
('23NJ','Submarine Radioman Communications (SUBCOMM) Combined Maintenance Technician'),
('23SM','SSN ECS Maintenance Technician'),
('23SO','ECS Operator'),
('23TA','TRIDENT Radioman Exterior Comm Sub-Systems Operations and Maint Technician'),
('23TB','TRIDENT Radioman Exterior Comm Sub-Systems Operations and Maint Technician'),
('23TC','TRIDENT Radioman Exterior Comm Sub-Systems Operations and Maint Technician'),
('23TM','TRIDENT ECS Maintenance Technician'),
('23TO','TRIDENT ECS Operator'),
('6632','Communications Security Devices Equipment (KY-28) Technician'),
('6661','TT-264 Teletype Repair IMA Technician'),
('119','Other Electronic Equipment'),
('84D','Audio Specialist'),
('811','Tradesman'),
('119100','Training Devices'),
('2E134','Visual Imagery and Intrusion Detection Systems Apprentice'),
('2E154','Visual Imagery and Intrusion Detection Systems Journeyman'),
('2E174','Visual Imagery and Intrusion Detection Systems Craftsman'),
('30435','Television System Specialist'),
('30455','Television System Specialist'),
('30475','Television System Specialist'),
('34100','Training Devices Manager'),
('34131','Instrument Trainer Specialist'),
('34132','Defensive Systems Trainer Specialist'),
('34133','Analog Flight Simulator Specialist'),
('34134','Flight Simulator Specialist'),
('34135','Analog Navigation/Tactics Training Devices Specialist'),
('34136','Navigation/Tactics Training Devices Specialist'),
('34137','Missile Trainer Specialist'),
('34151','Instrument Trainer Specialist'),
('34152','Defensive Systems Trainer Specialist'),
('34153','Analog Flight Simulator Specialist'),
('34154','Flight Simulator Specialist'),
('34155','Analog Navigation/Tactics Training Devices Specialist'),
('34156','Navigation/Tactics Training Devices Specialist'),
('34157','Missile Trainer Specialist'),
('34171','Instrument Trainer Specialist'),
('34172','Defensive Systems Trainer Specialist'),
('34173','Analog Flight Simulator Specialist'),
('34174','Flight Simulator Specialist'),
('34175','Analog Navigation/Tactics Training Devices Specialist'),
('34176','Navigation/Tactics Training Devices Specialist'),
('34177','Missile Trainer Specialist'),
('34197','Training Devices Superintendent'),
('34199','Training Devices Superintendent'),
('34230','Flight Simulator Specialist'),
('34250','Flight Simulator Specialist'),
('34270','Flight Simulator Specialist'),
('34330','Navigation/Bombing/Tactics Trainer Specialist'),
('34350','Navigation/Bombing/Tactics Trainer Specialist'),
('34370','Navigation/Bombing/Tactics Trainer Specialist'),
('34530','Missile Trainer Specialist'),
('34550','Missile Trainer Specialist'),
('34570','Missile Trainer Specialist'),
('5365','Physiological Trainer Mechanic'),
('4653','Combat Visual Information Equipment Technician'),
('4941','Audiovisual Equipment Technician'),
('4743','Integrated Launch and Recovery Television Surveillance (ILARTS) System Maintenance Technician'),
('4746','Closed Circuit TV Technician'),
('4747','Broadcast Engineering Technician'),
('7514','Surface Training Equipment Technician'),
('7523','Operational Flight/Weapons Systems Trainer Technician'),
('7553','Submarine Training Equipment Technician'),
('TD','Artillery, Gunnery and Missile Personnel'),
('TD','Tradesman'),
('119300','Shipboard Inertial Navigation Systems'),
('0325','AN/SSN-2 (V) 4 Operator'),
('1470','Navigation Equipment (SRN-9/SRN-18) Technician'),
('1471','URN-25 Tactical Air Navigation Technician'),
('1472','Tactical Air Navigation (SRN6/URN3/GRN9) Technician'),
('1473','Tactical Air Navigation (URN-20) Technician'),
('1474','Inertial Navigation MK II MOD 1 SINS (N7B) Technician'),
('1475','Inertial Navigation MK III MOD 4 SINS Technician'),
('1476','Inertial Navigation MK III MOD 6 SINS Technician'),
('1479','Ship''s Nav. & Aircraft Inertial Alignment System (CVNS/SNAIS) Tech'),
('1480','AN/FAC-6(V) Intersite System Maintenance Technician'),
('1490','AN/SSN-2(V) Precise Integrated Navigation System (PINS) Operator'),
('1492','AN/SSN-2(V) Precise Integrated Navigation System (PINS) Maint Tech'),
('3321','Navigation Data Computer (NAVDAC) Technician (NAVDAC MK-2 MOD4 on POLARIS SSBN)'),
('3322','Central Navigation Computer (CNC) Technician (CP-890A or POSEIDON)'),
('3323','Central Navigation Computer (CNC) Technician (CNC CP-890B on TRIDENT SBN)'),
('3324','Ships Inertial Navigation System (SINS) Technician (SINS MK 2 MOD 3,4,6,7)'),
('3325','Navigation AIDS (NAVAIDS) TECHNICIAN (POSEIDON w/o ESGM)'),
('3326','Navigation AIDS (NAVAIDS) TECHNICIAN (POSEIDON with ESGM)'),
('3327','Navigation AIDS (NAVAIDS) Technician (TRIDENT Navigation Subsystem)'),
('3328','Navigation Electronics Technician'),
('3329','Naviagation Electronics Operations and Maintenance Technician (TRIDENT II D5 Backfit SWS)'),
('3332','Central Navigation Computer (CNC) Technician (ILM on POSEIDON)'),
('3334','Ship''s Inertial Navigation System (SINS) Technician Intermediate Level Maintenance on SSBN Tenders)'),
('3335','Navigation Electronics Technicians'),
('3336','Navigation AIDS (NAVAIDS) Technician'),
('3343','Ocean Survey Technician- NAVAIDS'),
('3344','Ocean Survey Technician Sonar'),
('9611','AN/SSN-2(V)4 Maintainer'),
('9612','AN/WSN-7(V) Operations and Maintenance Technician'),
('26F','Aerial Photo Sensor Repairer'),
('26P','Radio Propagation Specialist'),
('35D','Meteorological Equipment Repairman'),
('35E','Special Electrical Devices Repairer'),
('35F','Special Electronic Devices Repairer'),
('35H','TMDE Maintenance Support Specialist'),
('35K','APACHE Attack Helicopter Systems Repairer'),
('35S','Electronic Biomedical Equipment Repairer'),
('35T','X-Ray Biomedical Equipment Repairer'),
('35Y','Integrated Family of Test Equipment Operator/Maintainer'),
('39B','Automatic Test Equipment Operator/Maintainer'),
('39E','Special Electronics Devices Repairer'),
('41E','Audio-Visual Equipment Repairer'),
('41F','Projector Repairman'),
('41G','Aerial Surveillance Photo Equipment Repairer (RC)'),
('41H','Photographic Equipment Repair Chief'),
('94F','Computer/Detection Systems Repairer'),
('94H','Test, Measurement, and Diagnostic Equipment (TMDE) Maintenance Support Specialist'),
('94K','APACHE Attack Helicopter Systems Repairer'),
('94Y','Integrated Family of Test Equipment (IFTE) Operator and Maintainer'),
('119800','Electronic Instruments, N.E.C.'),
('2A031A','Avionics Test Station And Components Apprentice, Avionics Systems, F-15'),
('2A031B','Avionics Test Station And Components Apprentice, Avionics Systems, All Helicopters and Aircraft (Except F-15)'),
('2A031C','Avionics Test Station And Components Apprentice, Avionics Sensor Systems, All Helicopters and Aircraft'),
('2A031D','Avionics Test Station And Components Apprentice, Electronic Warfare Systems, All Helicopters and Aircraft'),
('2A031K','Avionics Test Station And Components Apprentice, A-10/B-2/C-17/CV-22/F-16/AFSOC Avionics Systems'),
('2A031M','Avionics Test Station And Components Apprentice, B-1/E-8/F-15 Avionics Systems'),
('2A031P','Avionics Test Station And Components Apprentice, Avionics Sensor Systems and ElectronicWarfare Systems'),
('2A031S','Avionics Test Station And Components Apprentice, Avionics Systems'),
('2A051A','Avionics Test Station And Components Journeyman, Avionics Systems, F-15'),
('2A051B','Avionics Test Station And Components Journeyman, Avionics Systems, All Helicopters and Aircraft (Except F-15)'),
('2A051C','Avionics Test Station And Components Journeyman, Avionics Sensor Systems, All Helicopters and Aircraft'),
('2A051D','Avionics Test Station And Components Journeyman, Electronic Warfare Systems, All Helicopters and Aircraft'),
('2A051K','Avionics Test Station And Components Journeyman, A-10/B-2/C-17/CV-22/F-16/AFSOC Avionics Systems'),
('2A051M','Avionics Test Station And Components Journeyman, B-1/E-8/F-15 Avionics Systems'),
('2A051P','Avionics Test Station And Components Journeyman, Avionics Sensor Systems and ElectronicWarfare Systems'),
('2A051S','Avionics Test Station And Components Journeyman, Avionics Systems'),
('2A071A','Avionics Test Station And Components Craftsman, Avionics Systems, F-15'),
('2A071B','Avionics Test Station And Components Craftsman, Avionics Systems, All Helicopters and Aircraft (Except F-15)'),
('2A071C','Avionics Test Station And Components Craftsman, Avionics Sensor Systems, All Helicopters and Aircraft'),
('2A071D','Avionics Test Station And Components Craftsman, Electronic Warfare Systems, All Helicopters and Aircraft'),
('2A071K','Avionics Test Station And Components Craftsman, A-10/B-2/C-17/CV-22/F-16/AFSOC Avionics Systems'),
('2A071M','Avionics Test Station And Components Craftsman, B-1/E-8/F-15 Avionics Systems'),
('2A071P','Avionics Test Station And Components Craftsman, Avionics Sensor Systems and ElectronicWarfare Systems'),
('2A071S','Avionics Test Station And Components Craftsman, Avionics Systems'),
('2A090','Avionics Test Station And Components Superintendent'),
('2A135A','Avionics Support Equipment (SE) Apprentice, F-4'),
('2A135B','Avionics Support Equipment (SE) Apprentice, C-5'),
('2A155A','Avionics Support Equipment (SE) Journeyman, F-4'),
('2A155B','Avionics Support Equipment (SE) Journeyman, C-5'),
('2A175A','Avionics Support Equipment (SE) Craftsman, F-4'),
('2A175B','Avionics Support Equipment (SE) Craftsman, C-5'),
('2A231','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Apprentice'),
('2A231A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Apprentice, CV-22'),
('2A232','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Instrument and Flight Control Systems Apprentice'),
('2A233','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Apprentice'),
('2A233A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Apprentice, CV-22'),
('2A251','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Journeyman'),
('2A251A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Journeyman, CV-22'),
('2A252','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Instrument and Flight Control Systems Journeyman'),
('2A253','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Journeyman'),
('2A253A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Journeyman, CV-22'),
('2A271','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Craftsman'),
('2A272','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Instrument and Flight Control Systems Craftsman'),
('2A273','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Craftsman'),
('2A331A','A-10, F-15, and U-2 Avionics Systems Apprentice, Attack Control'),
('2A331B','A-10, F-15, and U-2 Avionics Systems Apprentice, Instrument And Flight Control'),
('2A331C','A-10, F-15, and U-2 Avionics Systems Apprentice, Communication, Navigation, And Penetration Aids'),
('2A332','F-16, F-117, RQ-1, CV-22 Avionic Systems Apprentice'),
('2A332A','Integrated Avionics Systems (Attack/Special) Apprentice, F-22, F-35'),
('2A332A','F-16 Avionic Systems Apprentice, Attack Control'),
('2A332B','Integrated Avionics Systems (Attack/Special) Apprentice, CV-22, F-16, MQ-1, MQ-9, RQ-4'),
('2A332B','F-16 Avionic Systems Apprentice, Instrument And Flight Control'),
('2A332C','F-16 Avionic Systems Apprentice, Communication, Navigation, And Penetration Aids'),
('2A334A','Fighter Aircraft Integrated Avionics Apprentice, A-10/U-2 Avionics'),
('2A334B','Fighter Aircraft Integrated Avionics Apprentice, F-15 Avionics'),
('2A334C','Fighter Aircraft Integrated Avionics Apprentice, F-16 Avionics'),
('2A335A','Advanced Fighter Aircraft Integrated Avionics Apprentice, F-22'),
('2A335B','Advanced Fighter Aircraft Integrated Avionics Apprentice, F-35'),
('2A335C','Advanced Fighter Aircraft Integrated Avionics Apprentice, MQ-1, MQ-9, RQ-4'),
('2A351','A-10, F-15, and U-2 Avionics Systems Journeyman'),
('2A351A','A-10, F-15, and U-2 Avionics Systems Journeyman, Attack Control'),
('2A351B','A-10, F-15, and U-2 Avionics Systems Journeyman, Instrument And Flight Control'),
('2A351C','A-10, F-15, and U-2 Avionics Systems Journeyman, Communication, Navigation, And Penetration Aids'),
('2A352','Integrated Avionics Systems (Attack/Special) Journeyman'),
('2A352A','F-16 Avionic Systems Journeyman, Attack Control'),
('2A352B','F-16 Avionic Systems Journeyman, Instrument And Flight Control'),
('2A352C','F-16 Avionic Systems Journeyman, Communication, Navigation, And Penetration Aids'),
('2A354A','Fighter Aircraft Integrated Avionics Journeyman, A-10/U-2 Avionics'),
('2A354B','Fighter Aircraft Integrated Avionics Journeyman, F-15 Avionics'),
('2A354C','Fighter Aircraft Integrated Avionics Journeyman, F-16 Avionics'),
('2A355A','Advanced Fighter Aircraft Integrated Avionics Journeyman, F-22'),
('2A355B','Advanced Fighter Aircraft Integrated Avionics Journeyman, F-35'),
('2A355C','Advanced Fighter Aircraft Integrated Avionics Journeyman, MQ-1, MQ-9, RQ-4'),
('2A371','A-10, F-15, and U-2 Avionics Systems Craftsman'),
('2A372','Integrated Avionics Systems (Attack/Special) Craftsman'),
('2A374','Fighter Aircraft Integrated Avionics Craftsman'),
('2A375','Advanced Fighter Aircraft Integrated Avionics Craftsman'),
('2A533','Mobility Air Forces Electronic Warfare Systems Apprentice'),
('2A533A','Integrated Avionics Systems (Heavy) Apprentice, Communication, Navigation, and Mission'),
('2A533B','Integrated Avionics Systems (Heavy) Apprentice, Instrument And Flight Controls'),
('2A533C','Integrated Avionics Systems (Heavy) Apprentice, Electronics Warfare'),
('2A533D','Integrated Avionics Systems (Heavy) Apprentice, Airborne Surveillance Radar Systems'),
('2A553','Mobility Air Forces Electronic Warfare Systems Journeyman'),
('2A553A','Integrated Avionics Systems (Heavy) Journeyman, Communication, Navigation, and Mission'),
('2A553B','Integrated Avionics Systems (Heavy) Journeyman, Instrument And Flight Controls'),
('2A553C','Integrated Avionics Systems (Heavy) Journeyman, Electronics Warfare'),
('2A553D','Integrated Avionics Systems (Heavy) Journeyman, Airborne Surveillance Radar Systems'),
('2A573','Mobility Air Forces Electronic Warfare Systems Craftsman'),
('2A573A','Integrated Avionics Systems (Heavy) Craftsman, Communication, Navigation, and Mission'),
('2A573B','Integrated Avionics Systems (Heavy) Craftsman, Instrument And Flight Controls'),
('2A573C','Integrated Avionics Systems (Heavy) Craftsman, Electronics Warfare'),
('2A573D','Integrated Avionics Systems (Heavy) Craftsman, Airborne Surveillance Radar Systems'),
('2A593','B-1B And B-2 Avionics Systems'),
('2A831A','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, C-5'),
('2A831B','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, C-17'),
('2A831C','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A831D','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, C-12/21/27/32/37/38/39/40'),
('2A831F','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, KC-10'),
('2A831G','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, KC-135'),
('2A831H','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Apprentice, KC-46'),
('2A832A','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, C-5'),
('2A832B','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, C-17'),
('2A832C','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A832D','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, C-12/21/27/32/37/38/39/40'),
('2A832F','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, KC-10'),
('2A832G','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, KC-135'),
('2A832H','Mobility Air Forces Integrated Instrument and Flight Control Systems Apprentice, KC-46'),
('2A851A','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, C-5'),
('2A851B','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, C-17'),
('2A851C','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A851D','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, C-12/21/27/32/37/38/39/40'),
('2A851F','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, KC-10'),
('2A851G','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, KC-135'),
('2A851H','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Journeyman, KC-46'),
('2A852A','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, C-5'),
('2A852B','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, C-17'),
('2A852C','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A852D','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, C-12/21/27/32/37/38/39/40'),
('2A852F','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, KC-10'),
('2A852G','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, KC-135'),
('2A852H','Mobility Air Forces Integrated Instrument and Flight Control Systems Journeyman, KC-46'),
('2A871E','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Craftsman, Cargo Comm/Counter/Nav Systems'),
('2A871J','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Craftsman, Tanker Comm/Counter/Nav Systems'),
('2A872E','Mobility Air Forces Integrated Instrument and Flight Control Systems Craftsman, Cargo IFCS'),
('2A872J','Mobility Air Forces Integrated Instrument and Flight Control Systems Craftsman, Tanker IFCS'),
('2A931A','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, E-3'),
('2A931B','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, E-4/VC-25'),
('2A931C','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, E-8'),
('2A931D','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, RC-135'),
('2A931E','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, B-1'),
('2A931F','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, B-2'),
('2A931G','Bomber/Special Integrated Communication/Navigation/Mission Systems Apprentice, B-52'),
('2A932A','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, E-3'),
('2A932B','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, E-4/VC-25'),
('2A932C','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, E-8'),
('2A932D','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, RC-135'),
('2A932E','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, B-1'),
('2A932F','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, B-2'),
('2A932G','Bomber/Special Integrated Instrument and Flight Control Systems Apprentice, B-52'),
('2A933A','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, E-3 Radar Surveillance'),
('2A933B','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, E-3 Computer/Electronic Warfare Systems'),
('2A933C','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, E-8'),
('2A933D','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, RC-135/AFISRA Systems/Carry-on EW'),
('2A933E','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, B-1'),
('2A933F','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, B-2'),
('2A933G','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, B-52'),
('2A933H','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, EC-130 Compass Call'),
('2A933J','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Apprentice, VC-25'),
('2A951A','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, E-3'),
('2A951B','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, E-4/VC-25'),
('2A951C','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, E-8'),
('2A951D','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, RC-135'),
('2A951E','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, B-1'),
('2A951F','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, B-2'),
('2A951G','Bomber/Special Integrated Communication/Navigation/Mission Systems Journeyman, B-52'),
('2A952A','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, E-3'),
('2A952B','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, E-4/VC-25'),
('2A952C','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, E-8'),
('2A952D','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, RC-135'),
('2A952E','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, B-1'),
('2A952F','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, B-2'),
('2A952G','Bomber/Special Integrated Instrument and Flight Control Systems Journeyman, B-52'),
('2A953A','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, E-3 Radar Surveillance'),
('2A953B','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, E-3 Computer/Electronic Warfare Systems'),
('2A953C','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, E-8'),
('2A953D','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, RC-135/AFISRA Systems/Carry-on EW'),
('2A953E','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, B-1'),
('2A953F','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, B-2'),
('2A953G','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, B-52'),
('2A953H','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, EC-130 Compass Call'),
('2A953J','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Journeyman, VC-25'),
('2A971','Bomber/Special Integrated Communication/Navigation/Mission Systems Craftsman'),
('2A972','Bomber/Special Integrated Instrument and Flight Control Systems Craftsman'),
('2A973','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Craftsman'),
('2E531','Imagery Systems Maintenance Apprentice'),
('2E551','Imagery Systems Maintenance Journeyman'),
('2E571','Imagery Systems Maintenance Craftsman'),
('2E591','Imagery Systems Maintenance'),
('2P000','Precision Measurement Equipment Laboratory Manager'),
('2P031','Precision Measurement Equipment Laboratory Apprentice'),
('2P051','Precision Measurement Equipment Laboratory Journeyman'),
('2P071','Precision Measurement Equipment Laboratory Craftsman'),
('2P091','Precision Measurement Equipment Laboratory Superintendent'),
('30230','Weather Equipment Specialist'),
('30231','Airborne Meteorological/Atmospheric Research Equipment Specialist'),
('30250','Weather Equipment Specialist'),
('30251','Airborne Meteorological/Atmospheric Research Equipment Specialist'),
('30270','Weather Equipment Specialist'),
('30271','Airborne Meteorological/Atmospheric Research Equipment Specialist'),
('30290','Weather Equipment Superintendent'),
('30291','Weather Equipment Superintendent'),
('30299','Weather Equipment Superintendent'),
('32090','Avionic Systems Superintendent'),
('32332','Aircraft Computer and Multiplexing Systems Specialist'),
('32352','Aircraft Computer and Multiplexing Systems Specialist'),
('32372','Aircraft Computer and Multiplexing Systems Specialist'),
('32399','Advanced Avionics Systems Superintendent'),
('32400','Precision Measurement Equipment Laboratory Manager'),
('32430','Precision Measurement Equipment Laboratory Specialist'),
('32450','Precision Measurement Equipment Laboratory Specialist'),
('32470','Precision Measurement Equipment Laboratory Specialist'),
('32490','Precision Measurement Equipment Lab Superintendent'),
('32531','Avionics Instrument Systems Specialist'),
('32551','Avionics Instrument Systems Specialist'),
('32571','Avionics Instrument Systems Specialist'),
('32591','Automatic Flight Control/Avionic Instrument Systems Supt.'),
('32599','Automatic Flight Control/Avionic Instrument Systems Superintendent'),
('32630','Avionics Aerospace Ground Equipment Specialist'),
('32631','Integrated Avionics Component Specialist'),
('32632','Integrated Avionic Systems Specialist'),
('32633','Integrated Avionics EW Equipment & Component Specialist'),
('32634','Integrated Avionics Computerized Test Sta & Component Specialist'),
('32635','Integrated Avionics Manual Test Sta & Component Specialist'),
('32636','Integrated Avionics Attack Control Systems Specialist'),
('32637','Integrated Avionics Instrument & Flight Control Systems Spec.'),
('32638','Integrated Avionics Comm, Nav & Penetration Aids Systems Spec.'),
('32650','Avionics Aerospace Ground Equipment Specialist'),
('32651','Integrated Avionics Component Specialist'),
('32652','Integrated Avionic Systems Specialist'),
('32653','Integrated Avionics EW Equipment & Component Specialist'),
('32654','Integrated Avionics Computerized Test Sta & Component Specialist'),
('32655','Integrated Avionics Manual Test Sta & Component Specialist'),
('32656','Integrated Avionics Attack Control Systems Specialist'),
('32657','Integrated Avionics Instrument & Flight Control Systems Spec.'),
('32658','Integrated Avionics Comm, Nav & Penetration Aids Systems Spec.'),
('32670','Avionics Aerospace Ground Equipment Specialist'),
('32671','Integrated Avionics Component Specialist'),
('32672','Integrated Avionic Systems Specialist'),
('32673','Integrated Avionics EW Equipment & Component Specialist'),
('32674','Integrated Avionics Computerized Test Sta & Component Specialist'),
('32675','Integrated Avionics Manual Test Sta & Component Specialist'),
('32676','Integrated Avionics Attack Control Systems Specialist'),
('32677','Integrated Avionics Instrument & Flight Control Systems Spec.'),
('32678','Integrated Avionics Comm, Nav & Penetration Aids Systems Spec.'),
('32690','Avionics AGE Superintendent'),
('32692','Integrated Avionic Superintendent'),
('32699','Integrated Avionics Superintendent'),
('40300','Biomedical Equipment Maintenance Manager'),
('40330','Biomedical Equipment Maintenance Specialist'),
('40350','Biomedical Equipment Maintenance Specialist'),
('40370','Biomedical Equipment Maintenance Specialist'),
('40400','Imagery Systems Maintenance Manager'),
('40430','Imagery Systems Maintenance Specialist'),
('40431','Aerospace Photographic Systems Specialist'),
('40450','Imagery Systems Maintenance Specialist'),
('40451','Aerospace Photographic Systems Specialist'),
('40470','Imagery Systems Maintenance Specialist'),
('40471','Aerospace Photographic Systems Specialist'),
('40490','Imagery Systems Maintenance Superintendent'),
('40491','Photographic Systems Maintenance Superintendent'),
('40499','Photographic Systems Maintenance Superintendent'),
('45100','Avionics Systems Manager'),
('45134','F-15 Avionics Test Station and Component Specialist'),
('45135','F-16/A-10 Avionics Test Station and Component Specialist'),
('45136','F/FB-111 Avionics Test Station and Component Specialist'),
('45137','B-1B Avionic Test Station and Component Technician'),
('45154','F-15 Avionics Test Station and Component Specialist'),
('45155','F-16/A-10 Avionics Test Station and Component Specialist'),
('45156','F/FB-111 Avionics Test Station and Component Specialist'),
('45157','B-1B Avionic Test Station and Component Technician'),
('45174','F-15 Avionics Test Station and Component Specialist'),
('45175','F-16/A-10 Avionics Test Station and Component Specialist'),
('45176','F/FB-111 Avionics Test Station and Component Specialist'),
('45177','B-1B Avionic Test Station and Component Technician'),
('45199','Avionic Test Stations Superintendent'),
('45200','Aircraft Manager'),
('45231','F-15 Avionic Systems Specialist'),
('45232','F-16 Avionic Systems Specialist'),
('45233','F/FB-111 Avionic Systems Specialist'),
('45251','F-15 Avionic Systems Specialist'),
('45252','F-16 Avionic Systems Specialist'),
('45253','F/FB-111 Avionic Systems Specialist'),
('45271','F-15 Avionic Systems Specialist'),
('45272','F-16 Avionic Systems Specialist'),
('45273','F/FB-111 Avionic Systems Specialist'),
('45299','Tactical Aircraft Superintendent'),
('45535','Avionics Support Equipment Specialist'),
('45555','Avionics Support Equipment Specialist'),
('45575','Avionics Support Equipment Specialist'),
('45733','B-1B and B-2 Avionics Systems Specialist'),
('45753','B-1B and B-2 Avionics Systems Specialist'),
('45773','B-1B and B-2 Avionics Systems Specialist'),
('45793','Advanced Avionic System Superintendent'),
('99104','Systems Repair Technician'),
('99125','Special Electronic Technician'),
('99132','Electromagnetic Radiation Research Technician'),
('99133','Scientific Instrumentation Technician'),
('9S000','Systems Repair Technician'),
('2601','Miscellaneous Electronic Equipment Installation and Maintenance'),
('2602','Electronic Measurement Equipment Mechanic'),
('2604','Electronics Mechanic'),
('2606','Electronic Industrial Controls Mechanic'),
('2610','Electronic Integrated Systems Mechanic'),
('2614','Electronics Mechanic'),
('2650','Electronic Integrated Systems Mechanic'),
('2663','Electronic Industrial Controls Mechanic'),
('3378','Precision Measurement Equipment Calibrating'),
('2871','Calibration Technician'),
('2872','Electronic Calibration Technician'),
('2873','Mechanical Calibration Technician'),
('2874','Metrology Technician'),
('2877','Radiac Instrument Technician'),
('2881','2M/ATE Technician'),
('2882','KG-30 Comsec Technician'),
('2894','Calibration Chief'),
('1588','Electronics Standards Specialist'),
('1589','Fleet Electronics Calibration (FECL) Technician'),
('1598','Electronics Standards Specialist'),
('6620','USM-458 Operator'),
('6636','AN/USM-470(V)1 Automatic Test System (ATS) Off-Line Maint. Tech.'),
('6650','AN/USM-470(V)1 Automatic Test System (ATS) Advanced IMA Technician'),
('6651','ASM-347 (GT-1) SACE Programmer/Maintenance IMA Technician'),
('6652','VAST (USM-247(V)) Operator'),
('6653','VAST (USM-247 (V)) On-Line Maintenance Technician'),
('6654','Digital Test Station/Digital Test Group IMA Technician'),
('6655','TS-2109 & TS-2110/ASA-48 SACE Programmer IMA Technician'),
('6656','AN/USM-470(V)1 Automatic Test System (ATS) Operator'),
('6658','AN/ASM-686 Night Attack IMA Technician'),
('6659','AN/USM-247 Versatile Avionic Shop Test (VAST) Advanced Operator (Intermediate Maintenance)'),
('6660','Dynamic Alignment Test Set IMA Technician'),
('6663','VAST (USM-247 (V)) Off-Line Maintenance/Calibration Technician'),
('6665','Drone Electronics Technician'),
('6687','USM-484 Hybrid Test Set (HTS) Operator'),
('6704','Consolidated Automated Support System (CASS) Test Station IMA Operator/Maintainer'),
('6705','Consolidated Automated Support System (CASS) Test Station IMA Calibration/Advanced Maintenance Technician'),
('6718','Electronics Standards Specialist'),
('6721','AN/USM-449A(V) Automatic Test System Maintenance Technician'),
('6723','Consolidated Automated Support System (CASS) Test Station (RADAR) IMA Technician'),
('6724','Consolidated Automated Support System (CASS) Test Station (EO) IMA Technician'),
('6725','Consolidated Automated Support System (CASS) Test Station (EW) IMA Technician'),
('7923','ASCU & Tactical Computer SSE IMA Technician'),
('12','Communications and Intelligence Specialists'),
('9720','Communications and Intelligence Specialists'),
('120','Radio and Radio Code'),
('05B','Radio Operator'),
('05C','Radio Teletype Operator'),
('05E','Voice-Radio Operator'),
('05F','Radio Teletypewriter Operator (Non-Morse)'),
('25C','Radio Operator-Maintainer'),
('25E','Electromagnetic Spectrum Manager'),
('26Q','Tactical Satellite/Microwave Systems Operator'),
('26R','Strategic Microwave Systems Operator'),
('31C','Radio Operator-Maintainer'),
('31K','Combat Signaler'),
('31Q','Tactical Satellite Microwave Systems Operator'),
('350','Radioman'),
('355','Radioman Watchstander'),
('120100','Radio Code'),
('11600','Airborne Communications Systems Manager'),
('11630','Airborne Communications Systems Operator'),
('11650','Airborne Communications Systems Operator'),
('11670','Airborne Communications Systems Operator'),
('11690','Airborne Communications Systems Superintendent'),
('11800','Airborne Command & Control Mission Electronic Systems Manager'),
('11899','Airborne Command & Control Mission Elec Systems Superintendent'),
('1A300','Airborne Mission Systems Operator Manager'),
('1A331','Airborne Mission Systems Operator Apprentice'),
('1A351','Airborne Mission Systems Operator Journeyman'),
('1A371','Airborne Mission Systems Operator Craftsman'),
('1A391','Airborne Mission Systems Operator Superintendent'),
('1A590','Airborne Command And Control Mission Electronic Systems'),
('1B134','Spectrum Operations Apprentice'),
('1B154','Spectrum Operations Journeyman'),
('1B174','Spectrum Operations Craftsman'),
('1B331','Electronic Warfare Operator Apprentice'),
('1B351','Electronic Warfare Operator Journeyman'),
('1B371','Electronic Warfare Operator Craftsman'),
('29300','Ground Radio Operations Manager'),
('29333','Ground Radio Operator'),
('29353','Ground Radio Operator'),
('29373','Ground Radio Operator')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 11...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('29400','Airborne Communications Systems Manager'),
('29430','Airborne Communications Systems Operator/Technician'),
('29450','Airborne Communications Systems Operator/Technician'),
('29470','Airborne Communications Systems Operator/Technician'),
('29600','Communications-Electronics Programs Manager'),
('29630','Communications Programs/Requirements & Resources Mgt Spec'),
('29650','Communications Programs/Requirements & Resources Mgt Spec'),
('29670','Communications Programs/Requirements & Resources Mgt Spec'),
('29700','Radio Frequency Manager'),
('29730','Radio Frequency Management Specialist'),
('29750','Radio Frequency Management Specialist'),
('29770','Radio Frequency Management Specialist'),
('3C100','Communications Systems Radio/spectrum Manager'),
('3C131','Radio Communications Systems Apprentice'),
('3C132','Electromagnetic Spectrum Management Apprentice'),
('3C151','Radio Communications Systems Journeyman'),
('3C152','Electromagnetic Spectrum Management Journeyman'),
('3C171','Radio Communications Systems Craftsman'),
('3C172','Electromagnetic Spectrum Management Craftsman'),
('3C191','Radio Communications Systems Superintendent'),
('3C192','Electromagnetic Spectrum Management Superintendent'),
('3C200','Communications - Computer Systems Control Manager'),
('3C231','Network Integration Apprentice'),
('3C251','Network Integration Journeyman'),
('3C271','Network Integration Craftsman'),
('3C291','Network Integration Superintendent'),
('3D134','Spectrum Operations Apprentice'),
('3D154','Spectrum Operations Journeyman'),
('3D174','Spectrum Operations Craftsman'),
('49200','Communications Systems Radio/Spectrum Manager'),
('49231','Communications Systems Radio Operator'),
('49232','Communications Systems Electromagnetic Spectrum Management Spec.'),
('49251','Communications Systems Radio Operator'),
('49252','Communications Systems Electromagnetic Spectrum Management Spec.'),
('49271','Communications Systems Radio Operator'),
('49272','Communications Systems Electromagnetic Spectrum Management Spec.'),
('49291','Communications Systems Radio Operations Superintendent'),
('49292','Communications Systems Electromagnetic Spectrum Management Super.'),
('49300','Communications - Computer Systems Control Manager'),
('49330','Communications - Computer Systems Control Specialist'),
('49350','Communications - Computer Systems Control Specialist'),
('49370','Communications - Computer Systems Control Specialist'),
('49390','Communications - Computer Systems Control Superintendent'),
('0389','Radio Operating'),
('0629','Radio Chief'),
('0648','Spectrum Manager'),
('0652','Certification Authority Workstation (CAW) Operator'),
('0691','Operational Communication Chief'),
('2533','Radio Telegraph Operator'),
('2537','Radio Chief'),
('2538','Fleet SATCOM Radio Chief'),
('2539','Ground Mobile Forces SATCOM Radio Chief'),
('2581','Radio Frequency Management Technician'),
('2591','Operational Communication Chief'),
('7382','Airborne Radio Operator/In-Flight Refueling Observer/Loadmaster'),
('8981','Military Affiliate Radio System Radio Operator'),
('14AB','Common Submarine Radio Room (CSRR) Equipment Operator'),
('2301','Enlisted Frequency Manager'),
('2302','Joint Task Force (JTF) Spectrum Management Master Level'),
('2304','Intermediate Radio Operator'),
('2313','Communications System Manager'),
('2318','Communications System Technical Control Operator'),
('2319','Communication System Technical Control Supervisor'),
('2321','Surface Communication System Operator'),
('2351','FLTSATCOM (NAVMACS A+) Shipboard Operator'),
('2379','Transmission System Technician'),
('2393','Special Fixed Communication System Operator'),
('2782','Defense Message System Administrator'),
('9577','Military Affiliate Radio System (MARS) Operator'),
('RM','Radioman'),
('31M','Multichannel Transmission Systems Operator'),
('120200','Non-Code Radio'),
('0621','Field Radio Operator'),
('0622','Digital (Multi-channel) Wideband Transmission Equipment Operator'),
('0623','Tropospheric Scatter Radio Multi-channel Equipment Operator'),
('0624','High Frequency Communication Central Operator'),
('0626','Fleet SATCOM Terminal Operator'),
('0627','Satellite Communications Operator'),
('0628','EHF Satellite Communications Operator-Maintainer'),
('2531','Field Radio Operator'),
('2532','Multichannel Equipment Operator'),
('2534','High Frequency Communication Central Operator'),
('2535','Fleet SATCOM Terminal Operator'),
('2536','Ground Mobile Forces SATCOM Operator'),
('2538','Fleet SATCOM Terminal Operator'),
('2305','DCS Satellite Communications Term. Oper. (MSC-46 and/or TSC-54)'),
('2358','SHF SATCOM Systems Operator'),
('2359','ASCOMM Operator'),
('2374','LHA Automated Communications System Operator'),
('2375','Tactical Support Communications (TSCOMM) Replacement Program System Operator'),
('2790','Information Systems Technician (IAT I)'),
('120','Signalman'),
('121','Signalman'),
('120300','Non-Radio Communications (Visual)'),
('9303','Communication Information Systems Course'),
('SM','Signalman'),
('121','Sonar'),
('121000','Sonar Operator, General'),
('002521','Tactical Multi-Sensor Operator'),
('002544','Acoustic Systems Specialist'),
('002549','Tactical Systems Operator'),
('002554','Tactical Aircrew Watch Officer'),
('002571','Electronic Systems Specialist'),
('002671','Tactical/Mobile Tactical Operations Center Analyst'),
('0416','Acoustic Intelligence Specialist'),
('0417','ASW Specialist'),
('0448','AN/SQR-15 TASS Operator/Maintenance Technician'),
('0505','IUSS Analyst'),
('0506','IUSS Maintenance Technician'),
('0507','IUSS Master Analyst'),
('0521','AN/SQQ-89(V)15 Sonar System Level I Operator'),
('0540','AN/SQQ-34C (V) 2 Aircraft Carrier Tactical Support Center (CV-TSC) Operator'),
('0611','Improved SOSUS Operator/Analyst'),
('0612','TDP Displays Analyst'),
('0613','TASS Analyst'),
('0614','SURTASS Analyst'),
('0615','IAP Displays Analyst'),
('0619','IUSS Acoustic Analyst'),
('0621','IUSS Advanced Acoustic Analyst/Watch Supervisor Coordinator'),
('0631','IUSS Advanced Technician'),
('1213','AN/SQQ-32(V)3 Minehunting Sonar Set Operator (MSS)'),
('7811','Acoustic Operator'),
('7821','P3B/C Acoustic Sensor Operator'),
('7824','CV-ASW Module (Model 4.0) Equipment Operator'),
('7825','ASW Operations Center Equipment Operator'),
('7826','CV-VSW Module (Model 4.0) Acoustic Analyst'),
('7827','ASW Operations Center Electronic Warfare Analyst'),
('7831','S-3A Multi-Sensor Operator'),
('7834','S3B Multi-Sensor Operator'),
('7835','Tactical/Mobile (TacMobile) Ashore Analysis Systems Operator'),
('7836','Tactical/Mobile (TacMobile) Watch Officer'),
('7842','Planning Series - P-8A Acoustic Operator'),
('7843','P3C Update IV Acoustic Sensor Operator'),
('7845','CV-ASE Module (Model 4.1/4.2) Equipment Operator'),
('7846','CVN CV-TSC System Operator'),
('7851','P-3/EP-3J Non-Acoustic Operator'),
('7861','P3C Non-Acoustic Operator'),
('7862','Planning Series - P-8A Non-Acoustic Operator'),
('7863','P3C Update IV Electronic Non-Acoustic Operator'),
('7871','SH2F Multi-Sensor Operator'),
('7872','SH3H Multi-Sensor Operator'),
('7874','SH2G Multi-Sensor Operator'),
('7877','P-3C UPDATE III ASUW Improvement Program (AIP) Non-Acoustic Operator'),
('7881','Sonar Systems Operator'),
('98AS','Anti-Sub Warfare (ASW) Mission Specialist'),
('98MC','Mine Countermeasure (MCM) Mission Specialist'),
('AW','Aviation Antisubmarine Warfare Operator'),
('AW','Aviation Warfare Systems Operator'),
('AWA','Aviation Warfare Systems Operator (Acoustic)'),
('AWH','Aviation Warfare Systems Operator (Helicopter)'),
('AWN','Aviation Warfare Systems Operator (Non-Acoustic)'),
('OT','Ocean Systems Technician'),
('122','Radar and Air Traffic Control'),
('13R','Field Artillery (FA) Firefinder Radar Operator'),
('16J','Defense Acquisition Radar Operator'),
('17A','Combat Surveillance & Target Acquisition Crewman'),
('17B','Field Artillery Radar Crewmember'),
('17K','Ground Surveillance Radar Crewman'),
('17M','Remote Sensor Specialist'),
('17Z','Combat Surveillance & Target Acquisition NCO'),
('130','Radarman'),
('122100','Radar'),
('11700','Airborne Warning Command and Control Systems Manager'),
('11730','Airborne Warning Command and Control Systems Operator'),
('11750','Airborne Warning Command and Control Systems Operator'),
('11770','Airborne Warning Command and Control Systems Operator'),
('11790','Airborne Warning Command and Control Systems Superintendent'),
('1A400','Airborne Operations Manager'),
('1A431','Airborne Operations Apprentice'),
('1A451','Airborne Operations Journeyman'),
('1A451D','Airborne Battle Management Systems Journeyman, Weapons Director'),
('1A471','Airborne Operations Craftsman'),
('1A471D','Airborne Battle Management Systems Craftsman, Weapons Director'),
('1A491','Airborne Operations Superintendent'),
('1C500','Command and Control Battle Management Operations Manager'),
('1C531','Command and Control Battle Management Operations Apprentice'),
('1C531A','Aerospace Control And Warning Systems Apprentice, Manual Systems'),
('1C531B','Aerospace Control And Warning Systems Apprentice, Sector Operations Control Center'),
('1C531C','Aerospace Control And Warning Systems Apprentice, Theater Air Control System'),
('1C531D','Command and Control Battle Management Operations Apprentice, Weapons Director'),
('1C551','Command and Control Battle Management Operations Journeyman'),
('1C551D','Command and Control Battle Management Operations Journeyman, Weapons Director'),
('1C571','Command and Control Battle Management Operations Craftsman'),
('1C571D','Command and Control Battle Management Operations Craftsman, Weapons Director'),
('1C591','Command and Control Battle Management Operations Superintendent'),
('1C600','Space Systems Operations Manager'),
('1C631','Space Systems Operations Apprentice'),
('1C651','Space Systems Operations Journeyman'),
('1C671','Space Systems Operations Craftsman'),
('1C691','Space Systems Operations Superintendent'),
('27600','Aerospace Control & Warning Systems Manager'),
('27630','Aerospace Control & Warning Systems Operator'),
('27632','Intercept Director Specialist'),
('27650','Aerospace Control & Warning Systems Operator'),
('27652','Intercept Director Specialist'),
('27670','Aerospace Control & Warning Systems Operator'),
('27672','Intercept Director Specialist'),
('27690','Aerospace Control & Warning Systems Superintendent'),
('27692','Aerospace Control & Warning Systems Superintendent'),
('27700','Space Systems Operations Manager'),
('27730','Space Systems Operations Specialist'),
('27750','Space Systems Operations Specialist'),
('27770','Space Systems Operations Specialist'),
('27790','Space Systems Operations Superintendent'),
('7234','Air Control Electronics Operator'),
('7236','Tactical Air Defense Controller'),
('7239','Air Command, Control & Defense System Supervisor'),
('7242','Air Support Operations Operator'),
('7277','Weapons and Tactics Instructor-Air Control'),
('003738','Combat Air Controller'),
('003739','Navigation and Plotting Specialist'),
('003740','Warfare Operator'),
('003741','Operations Administrator'),
('003742','Electronic Systems Operator'),
('0201','Voyage Management System Operator'),
('0230','ECDIS-N Navigation Operator'),
('0301','FFG-7/FFG-36 Class Subsystem Component Specialist'),
('0302','AN/SYS-2 Integrated Automatic Detection and Tracking (IADT) Systems Operator'),
('0310','AEGIS Operations Specialist (CG 65-DDG 79)'),
('0311','AEGIS Operations Specialist (CG 47-64)'),
('0312','OJ-194 Console Operator'),
('0313','Air Intercept Controller'),
('0314','Supervisory Air Intercept Controller'),
('0315','Mine Countermeasure Air Controller'),
('0316','Antisubmarine Air Controller'),
('0317','NTDS-Input/Utilization Display Equipment Operator'),
('0318','Air Intercept Controller'),
('0319','Supervisory Air Intercept Controller'),
('0321','Antisubmarine Air Controller'),
('0322','LAMPS MK III Air Tactical Control Operator'),
('0323','ASW/ASUW Tactical Supervisor'),
('0324','ASW/SUW Tactical Air Controller (ASTAC)'),
('0326','Operations Systems Specialist'),
('0327','Sea Combat Air Controller (SCAC)'),
('0328','ASW/ASUW Tactical Air Control (ASTAC) Leadership'),
('0331','ASWOC Operator'),
('0332','TOMAHAWK Weapon System (Surface) Operator'),
('0333','FHLT Operator'),
('0334','HARPOON (AN/SWG-1A) Engagement Planning Operator'),
('0336','Tactical/Mobile (TacMobile) Operations Control (OPCON) Operator'),
('0340','Global Command and Control System Common Operational Picture/Maritime 4.X (GCCS COP/M 4.X) Operator'),
('0341','Naval Warfare Operations Specialist'),
('0342','Global Command and Control System Common Operational Picture/Maritime (GCCS COP/M) Operator'),
('0344','Navy Command and Control System (NCCS) Ashore System/Operator'),
('0346','AEGIS Console Operator Track 3'),
('0347','Ship Self Defense System (SSDS) MK1 Operator'),
('0348','Multi-Tactical Digital Information Link Operator (TADIL)'),
('0349','SSDS MK 2 Advanced Operator'),
('0350','Interface Control Officer (ICO)'),
('0355','ROTHR AN/TPS-71 (XN-1) Base Operator'),
('0356','Global Command and Control System-Maritime (4.1) Increment 2 (GCCS-M 4.1 Inc 2) Operator'),
('98GD','General Dynamics (GD) Littoral Combat Ship (LCS) Core Crew Mission Specialist'),
('98LM','Lockheed Martin (LM) Littoral Combat Ship (LCS) Core Crew Mission Specialist'),
('98SU','Surface Warfare (SUW) Mission Specialist'),
('OS','Operations Specialist'),
('15Q','Air Traffic Control (ATC) Operator'),
('93C','Air Traffic Control Operator'),
('93H','Air Traffic Control Tower Operator'),
('93J','Air Traffic Control Radar Controller'),
('93K','ATC Approach Control/Enroute Specialist'),
('93L','ATC Chief'),
('591','Air Controlman'),
('122200','Air Traffic Control'),
('1C100','Air Traffic Control Manager'),
('1C131','Air Traffic Control Apprentice'),
('1C151','Air Traffic Control Journeyman'),
('1C171','Air Traffic Control Craftsman'),
('1C191','Air Traffic Control Superintendent'),
('27200','Air Traffic Control Manager'),
('27230','Air Traffic Control Operator'),
('27250','Air Traffic Control Operator'),
('27270','Air Traffic Control Operator'),
('27290','Air Traffic Control Superintendent'),
('27299','Air Traffic Control Superintendent'),
('2152','Air Traffic Control'),
('2154','Air Traffic Assistance'),
('2152','Air Traffic Control Specialist'),
('2154','Air Traffic Control Technician'),
('7252','Air Traffic Controller-Tower'),
('7253','Air Traffic Controller-Radar Arrival/Departure Controller'),
('7254','Air Traffic Controller-Radar Approach Controller'),
('7257','Air Traffic Controller'),
('7277','Weapons and Tactics Instructor - Air Command and Control'),
('7291','Senior Air Traffic Controller'),
('7311','Air Traffic Controller-Trainee'),
('7312','Air Traffic Controller-Tower'),
('7322','Air Traffic Controller-Radar'),
('7324','Radar Approach Controller'),
('7391','Senior Air Traffic Controller'),
('8002','Joint Terminal Attack Controller'),
('9986','Joint Terminal Attack Controller'),
('001307','Air Traffic Controller'),
('1570','Air Traffic Control Communications Technician'),
('6901','Facility Rated Approach Controller'),
('6902','Carrier Air Traffic Control Center Controller'),
('6903','Amphibious Air Traffic Control Center Controllers'),
('6904','Air Traffic Control Manager'),
('6922','Ground Controlled Approach Controller'),
('6931','Facility Rated Terminal RADAR Approach (TRACON) Controller'),
('6932','Facility Rated Carrier Air Traffic Control Center (CATCC) Controller'),
('6933','Facility Rated Amphibious Air Traffic Control Center (AATCC) Controller'),
('6934','Facility Rated Tactical Air Control Center (TACC) Controller'),
('6935','Facility Rated Fleet Area Control and Surveillance Facility (FACSFAC) Controller'),
('6936','Facility Rated RADAR Air Traffic Control Facility (RATCF) Controller'),
('6937','Control Tower Operator'),
('AC','Air Traffic Controller'),
('123','Signal Intelligence/Electronic Warfare'),
('35Q','Cryptologic Network Warfare Specialist'),
('35Z','Signals Intelligence (SIGINT) Senior Sergeant/SIGINT Chief'),
('98Z','Signals Intelligence (Electronic Warfare) Senior Sergeant/Chief'),
('123000','Signal Intelligence/Electronic Warfare, General'),
('1B000','Cyber Warfare Operations Manager'),
('1B431','Cyber Warfare Operations Apprentice'),
('1B451','Cyber Warfare Operations Journeyman'),
('1B471','Cyber Warfare Operations Craftsman'),
('1B491','Cyber Warfare Operations Superintendent'),
('1N290','Signals Intelligence Superintendent'),
('2691','Signals Intelligence/Electronic Warfare Chief'),
('0303','ACDS Block 1 Operator'),
('90IW','Expeditionary Information Warfare (Tactical)'),
('9102','National OPELINT Analyst'),
('9103','Fleet Cryptologic Systems Maintenance Technician'),
('9104','Telemetry Collection and Analysis Technician'),
('9105','C2 Tactical Analysis Technician'),
('9107','High Frequency Direction Finding (HFDF) Computer Programmer'),
('9108','Special Purpose Computer (UYK-20) Programmer'),
('9109','Cryptologic System Software Support Computer (FORTRAN) Programmer'),
('9110','Cryptologic System Software Support (PASCAL) Programmer'),
('9111','Mobile Systems Technical Data Facility (MSTDF) Operator'),
('9112','BULLSEYE Outstation Operator'),
('9115','Cryptologic Systems Programmer'),
('9116','Cryptologic Supervisor'),
('9118','Multiple Branches/Rating Series (Cryptology)'),
('9120','SIGINT Classification of Recognized Emitters (SCORE) Operator'),
('9121','Submarine Electronics Warfare Support Measures System (WLR-6) Operator'),
('9122','Submarine Electronic Warfare Support Measure Systems (WLR-6, BRD-7, WY-7 and BRQ-1) Operator'),
('9123','Submarine Electronic Warfare Support Measures System (WLQ-4) Operator'),
('9124','Direct Support (DIRSUP)/Ships Signals Exploitation Equipment Operator'),
('9125','OUTBOARD System Operator'),
('9127','Signals Security Operator'),
('9128','Signals Security Technician'),
('9129','High Frequency Direction Finding Specialist (NET Control)'),
('9130','Cryptologic CCSC/CCSS Operator'),
('9132','Afloat Cryptologic Manager'),
('9133','BULLSEYE Net Control/BULLSEYE Support Center Operator'),
('9134','Subsurface Augmentee Operator'),
('9135','Subsurface Augmentee ELINT Operator'),
('9136','NTDS Tactical Signals Operator'),
('9137','Apprentice Analysis and Reporting Specialist'),
('9159','Vulnerability Assessment Operator'),
('9160','Classic Wizard EDP Tuner'),
('9170','CLASSIC WIZARD Basic Operator'),
('9171','CLASSIC WIZARD Collection System Operator'),
('9172','CLASSIC WIZARD PLB System Operator'),
('9173','CLASSIC WIZARD Network System Operator'),
('9174','Classic Wizard Configuration Maintenance Analyst'),
('9175','CLASSIC WIZARD Reporting System Operator'),
('9176','CLASSIC WIZARD System Support Operator'),
('9177','CLASSIC OWL Operator'),
('9206','Master Cryptologic Linguist'),
('9304','Database Administrator'),
('EW','Electronics Warfare Technician'),
('05D','EW/SIGINT Emitter Identifier/Locator'),
('05G','Signal Security Specialist'),
('05H','EW/SIGINT Morse Interceptor'),
('05K','EW/SIGINT Non-Morse Interceptor'),
('35P','Cryptologic Linguist'),
('35U','Multi Sensor Operator'),
('97G','Multi-Discipline Counter-Intelligence Operator/Analyst'),
('98D','Emitter Locator/Identifier'),
('98G','Cryptologic Communications Interceptor/Locator'),
('98H','Communications Interceptor/Locator'),
('98K','Signals Collection/Identification Analyst'),
('98P','Multi-Sensor Operator'),
('123100','Intercept Operators (Code and Non-Code)'),
('1A800','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Manager'),
('1A832','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Operator Apprentice'),
('1A852','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Operator Journeyman'),
('1A872','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Operator Craftsman'),
('1A890','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Superintendent'),
('1N231','Communication Signals Intelligence Apprentice'),
('1N231A','Signals Intelligence Analyst Apprentice, Electronic'),
('1N231C','Signals Intelligence Analyst Apprentice, Communications'),
('1N251','Communication Signals Intelligence Journeyman'),
('1N251A','Signals Intelligence Analyst Journeyman, Electronic'),
('1N251C','Signals Intelligence Analyst Journeyman, Communications'),
('1N271','Communication Signals Intelligence Craftsman'),
('1N271A','Signals Intelligence Analyst Craftsman, Electronic'),
('1N271C','Signals Intelligence Analyst Craftsman, Communications'),
('1N291','Communication Signals Intelligence Superintendent'),
('20700','Communications Collection/Systems Manager'),
('20731','Morse Systems Operator'),
('20732','Printer Systems Operator'),
('20751','Morse Systems Operator'),
('20752','Printer Systems Operator'),
('20771','Morse Systems Operator'),
('20772','Printer Systems Operator'),
('20792','Communications Collection/Systems Superintendent'),
('20799','Communications Collection Systems Superintendent'),
('2611','Cryptologic Digital Network Operator/Analyst'),
('2621','Special Communication Signals Collection Operator/Analyst'),
('2622','Radio Direction Finder Operator'),
('2631','Electronic Intelligence (ELINT) Intercept Operator/Analyst'),
('2632','Non-Communications Intercept Operator/Analyst'),
('2641','Voice Intercept Operator'),
('2651','Special Intelligence System Administrator/Communicator'),
('2659','Special Intelligence Communication Supervisor'),
('001072','Signals Intelligence Collection Analyst and Reporter'),
('001077','Communication Intelligence Collection Signals Analyst'),
('001082','Collection Operations Manager'),
('001090','Electronic Intelligence Analyst'),
('001095','Electronic Warfare Operator'),
('002676','Electronic Warfare Maintainer'),
('002677','Electronic Warfare Planner'),
('90SI','Individual GWOT IA/ILO Signal Intelligence Gathering'),
('90SJ','Individual GWOT IA/ILO Signal Intelligence Gathering, Not Deployed'),
('9101','Cryptological Field Training Technician'),
('9106','Advanced Operational Electronic Intelligence (OPELINT) Non-Communications Collection and Analysis Technician'),
('9114','Fleet Signals Exploitation Operator'),
('9131','Combat Direction Finding System (AN/SRS-1) Operator'),
('9136','Cooperative OUTBOARD Logistics Update (COBLU) Operator'),
('9136','Tactical Exploitation System (TES) Operator'),
('9138','Journeyman Analysis and Reporting Specialist'),
('9139','Senior Analysis and Reporting Specialist'),
('9140','Noncommunications Technician'),
('9141','Intermediate Technical ELINT (TECHELINT) Analysis Technician'),
('9142','CLASSIC WIZARD Operator'),
('9143','CLASSIC WIZARD Analyst'),
('9144','Technical Guidance Unit (TGU) ELINT Specialist'),
('9145','Wideband Systems Technician'),
('9146','Senior Non-Morse Collection Supervisor'),
('9147','Intermediate Signals Analyst'),
('9148','Immediate Signals Analyst'),
('9150','Cryptologic Technicians (Technical) (CTT)'),
('9150','Maritime Cryptologic Systems (Ship Signal Exploitation Equipment - SSEE) Operator'),
('9151','Basic Non-Morse Operator'),
('9154','Collection and Forwarding System (CFS) Operator'),
('9155','Collection and Forwarding System (CFS) Analyst'),
('9156','Collection and Forwarding (CFS) Supervisor'),
('9157','Collection and Forwarding System (CFS) Technical Spt & Acq. Spec.'),
('9158','ClASSIC WIZARD Analyst'),
('9161','Ship''s Signal Exploitation Equipment Increment Foxtrot (SSEE INC F) Operator'),
('9162','CORALINE Collection Technician'),
('9163','CARDIGAN Collection Technician'),
('9165','High Frequency Direction Finding Specialist (Outstation)'),
('9166','Direction Finding Outstation Operator'),
('9167','Improved AG-22 Terminal Subsystems (IATS) System Controller'),
('9168','Advance Non-communications Collection and Analysis Technician'),
('9169','Morse Code Intercept Operator'),
('CT','Cryptologic Technician'),
('CTR','Cryptologic Technician Collection'),
('CTT','Cryptologic Technician Technical'),
('35N','Signals Intelligence Analyst'),
('98B','EW/Cryptanalytic Cryptanalyst'),
('98C','Signals Intelligence Analyst'),
('123200','Analysis'),
('1A831','Airborne Cryptologic Language Analyst Apprentice'),
('1A831A','Airborne Cryptologic Linguist Apprentice, Germanic'),
('1A831B','Airborne Cryptologic Linguist Apprentice, Romance'),
('1A831C','Airborne Cryptologic Linguist Apprentice, Slavic'),
('1A831D','Airborne Cryptologic Linguist Apprentice, Far East'),
('1A831E','Airborne Cryptologic Linguist Apprentice, Mid East'),
('1A831F','Airborne Cryptologic Language Analyst Apprentice, Arabic'),
('1A831G','Airborne Cryptologic Language Analyst Apprentice, Chinese'),
('1A831H','Airborne Cryptologic Language Analyst Apprentice, Korean'),
('1A831I','Airborne Cryptologic Language Analyst Apprentice, Russian'),
('1A831J','Airborne Cryptologic Language Analyst Apprentice, Spanish'),
('1A831K','Airborne Cryptologic Language Analyst Apprentice, Persian'),
('1A831L','Airborne Cryptologic Language Analyst Apprentice, Hebrew'),
('1A831M','Airborne Cryptologic Language Analyst Apprentice, Pashto'),
('1A831Z','Airborne Cryptologic Language Analyst Apprentice, Low-Flow'),
('1A851','Airborne Cryptologic Language Analyst Journeyman'),
('1A851A','Airborne Cryptologic Linguist Journeyman, Germanic'),
('1A851B','Airborne Cryptologic Linguist Journeyman, Romance'),
('1A851C','Airborne Cryptologic Linguist Journeyman, Slavic'),
('1A851D','Airborne Cryptologic Linguist Journeyman, Far East'),
('1A851E','Airborne Cryptologic Linguist Journeyman, Mid East'),
('1A851F','Airborne Cryptologic Language Analyst Journeyman, Arabic'),
('1A851G','Airborne Cryptologic Language Analyst Journeyman, Chinese'),
('1A851H','Airborne Cryptologic Language Analyst Journeyman, Korean'),
('1A851I','Airborne Cryptologic Language Analyst Journeyman, Russian'),
('1A851J','Airborne Cryptologic Language Analyst Journeyman, Spanish'),
('1A851K','Airborne Cryptologic Language Analyst Journeyman, Persian'),
('1A851L','Airborne Cryptologic Language Analyst Journeyman, Hebrew'),
('1A851M','Airborne Cryptologic Language Analyst Journeyman, Pashto'),
('1A851Z','Airborne Cryptologic Language Analyst Journeyman, Low-Flow'),
('1A871','Airborne Cryptologic Language Analyst Craftsman'),
('1A871A','Airborne Cryptologic Linguist Craftsman, Germanic'),
('1A871B','Airborne Cryptologic Linguist Craftsman, Romance'),
('1A871C','Airborne Cryptologic Linguist Craftsman, Slavic'),
('1A871D','Airborne Cryptologic Linguist Craftsman, Far East'),
('1A871E','Airborne Cryptologic Linguist Craftsman, Mid East'),
('1A871F','Airborne Cryptologic Language Analyst Craftsman, Arabic'),
('1A871G','Airborne Cryptologic Language Analyst Craftsman, Chinese'),
('1A871H','Airborne Cryptologic Language Analyst Craftsman, Korean'),
('1A871I','Airborne Cryptologic Language Analyst Craftsman, Russian'),
('1A871J','Airborne Cryptologic Language Analyst Craftsman, Spanish'),
('1A871K','Airborne Cryptologic Language Analyst Craftsman, Persian'),
('1A871L','Airborne Cryptologic Language Analyst Craftsman, Hebrew'),
('1A871M','Airborne Cryptologic Language Analyst Craftsman, Pashto'),
('1A871Z','Airborne Cryptologic Language Analyst Craftsman, Low-Flow'),
('1A891','Airborne Cryptologic Linguist Superintendent'),
('1N200','Signals Intelligence Analysis Manager'),
('1N331','Cryptologic Language Analyst Apprentice'),
('1N331A','Germanic Cryptologic Linguist Apprentice, German'),
('1N331B','Germanic Cryptologic Linguist Apprentice, Dutch'),
('1N331C','Germanic Cryptologic Linguist Apprentice, Flemish'),
('1N331D','Germanic Cryptologic Linguist Apprentice, Swedish'),
('1N331E','Germanic Cryptologic Linguist Apprentice, Afrikaans'),
('1N331F','Cryptologic Language Analyst Apprentice, Arabic'),
('1N331G','Cryptologic Language Analyst Apprentice, Chinese'),
('1N331H','Cryptologic Language Analyst Apprentice, Korean'),
('1N331I','Cryptologic Language Analyst Apprentice, Russian'),
('1N331J','Cryptologic Language Analyst Apprentice, Spanish'),
('1N331K','Cryptologic Language Analyst Apprentice, Persian'),
('1N331L','Cryptologic Language Analyst Apprentice, Hebrew'),
('1N331M','Cryptologic Language Analyst Apprentice, Pashto'),
('1N331N','Cryptologic Language Analyst Apprentice, Urdu'),
('1N331Z','Cryptologic Language Analyst Apprentice, Low-Flow'),
('1N332A','Romance Cryptologic Linguist Apprentice, Spanish (Latin American)'),
('1N332B','Romance Cryptologic Linguist Apprentice, Portuguese (Latin American)'),
('1N332C','Romance Cryptologic Linguist Apprentice, French'),
('1N332D','Romance Cryptologic Linguist Apprentice, Italian'),
('1N332E','Romance Cryptologic Linguist Apprentice, Romanian'),
('1N332F','Romance Cryptologic Linguist Apprentice, Haitian-Creole'),
('1N332G','Romance Cryptologic Linguist Apprentice, Moldovan'),
('1N333A','Slavic Cryptologic Linguist Apprentice, Russian'),
('1N333B','Slavic Cryptologic Linguist Apprentice, Polish'),
('1N333C','Slavic Cryptologic Linguist Apprentice, Czech'),
('1N333D','Slavic Cryptologic Linguist Apprentice, Serbo-Croatian'),
('1N333E','Slavic Cryptologic Linguist Apprentice, Belarusian'),
('1N333F','Slavic Cryptologic Linguist Apprentice, Hungarian'),
('1N333G','Slavic Cryptologic Linguist Apprentice, Lithuanian'),
('1N333H','Slavic Cryptologic Linguist Apprentice, Slovenian'),
('1N333J','Slavic Cryptologic Linguist Apprentice, Bulgarian'),
('1N333K','Slavic Cryptologic Linguist Apprentice, Ukrainian'),
('1N333L','Slavic Cryptologic Linguist Apprentice, Macedonian'),
('1N333M','Slavic Cryptologic Linguist Apprentice, Albanian'),
('1N334A','Far East Cryptologic Linguist Apprentice, Chinese (Mandarin)'),
('1N334B','Far East Cryptologic Linguist Apprentice, Vietnamese'),
('1N334C','Far East Cryptologic Linguist Apprentice, Thai'),
('1N334D','Far East Cryptologic Linguist Apprentice, Cambodian'),
('1N334E','Far East Cryptologic Linguist Apprentice, Lao'),
('1N334F','Far East Cryptologic Linguist Apprentice, Japanese'),
('1N334G','Far East Cryptologic Linguist Apprentice, Korean'),
('1N334H','Far East Cryptologic Linguist Apprentice, Chinese (Cantonese)'),
('1N334J','Far East Cryptologic Linguist Apprentice, Tagalog'),
('1N335A','Mid East Cryptologic Linguist Apprentice, Arabic'),
('1N335B','Mid East Cryptologic Linguist Apprentice, Arabic (Syrian)'),
('1N335C','Mid East Cryptologic Linguist Apprentice, Hebrew'),
('1N335D','Mid East Cryptologic Linguist Apprentice, Persian (Farsi)'),
('1N335E','Mid East Cryptologic Linguist Apprentice, Turkish'),
('1N335F','Mid East Cryptologic Linguist Apprentice, Greek'),
('1N335G','Mid East Cryptologic Linguist Apprentice, Indonesian'),
('1N335H','Mid East Cryptologic Linguist Apprentice, Hindi'),
('1N335J','Mid East Cryptologic Linguist Apprentice, Armenian'),
('1N335K','Mid East Cryptologic Linguist Apprentice, Azeri'),
('1N335L','Mid East Cryptologic Linguist Apprentice, Pushtu'),
('1N335M','Mid East Cryptologic Linguist Apprentice, Georgian'),
('1N335N','Mid East Cryptologic Linguist Apprentice, Tadzhik'),
('1N335P','Mid East Cryptologic Linguist Apprentice, Kazakh'),
('1N335Q','Mid East Cryptologic Linguist Apprentice, Turkmen'),
('1N335R','Mid East Cryptologic Linguist Apprentice, Uzbek'),
('1N335S','Mid East Cryptologic Linguist Apprentice, Persian (Dari)'),
('1N335T','Mid East Cryptologic Linguist Apprentice, Punjabi'),
('1N335V','Mid East Cryptologic Linguist Apprentice, Sindhi'),
('1N335W','Mid East Cryptologic Linguist Apprentice, Urdu'),
('1N336A','African Cryptologic Linguist Apprentice, Swahili'),
('1N336B','African Cryptologic Linguist Apprentice, Zande'),
('1N336C','African Cryptologic Linguist Apprentice, Berber (Shawia)'),
('1N336D','African Cryptologic Linguist Apprentice, Bedawi (Beja)'),
('1N336E','African Cryptologic Linguist Apprentice, Sidamo'),
('1N336F','African Cryptologic Linguist Apprentice, Somali'),
('1N336G','African Cryptologic Linguist Apprentice, Nubian'),
('1N336H','African Cryptologic Linguist Apprentice, Bari'),
('1N336J','African Cryptologic Linguist Apprentice, Dinka'),
('1N336K','African Cryptologic Linguist Apprentice, Nuer'),
('1N336L','African Cryptologic Linguist Apprentice, Otuho'),
('1N336M','African Cryptologic Linguist Apprentice, Shilluk'),
('1N336N','African Cryptologic Linguist Apprentice, Fur'),
('1N336P','African Cryptologic Linguist Apprentice, Amharic'),
('1N336Q','African Cryptologic Linguist Apprentice, Aramaic'),
('1N336R','African Cryptologic Linguist Apprentice, Assyrian'),
('1N336S','African Cryptologic Linguist Apprentice, Tigre'),
('1N336T','African Cryptologic Linguist Apprentice, Tigrinya'),
('1N337A','Turkic Cryptologic Linguist Apprentice, Chechen'),
('1N337B','Turkic Cryptologic Linguist Apprentice, Circassian'),
('1N337C','Turkic Cryptologic Linguist Apprentice, Kirgiz'),
('1N337D','Turkic Cryptologic Linguist Apprentice, Tatar'),
('1N337E','Turkic Cryptologic Linguist Apprentice, Uighur'),
('1N338A','Polynesian Cryptologic Linguist Apprentice, Bikol'),
('1N338B','Polynesian Cryptologic Linguist Apprentice, Cebuano'),
('1N338C','Polynesian Cryptologic Linguist Apprentice, Ilocano'),
('1N338D','Polynesian Cryptologic Linguist Apprentice, Javanese'),
('1N338E','Polynesian Cryptologic Linguist Apprentice, Sudanese'),
('1N338F','Polynesian Cryptologic Linguist Apprentice, Tausug'),
('1N338G','Polynesian Cryptologic Linguist Apprentice, Brahui'),
('1N338H','Polynesian Cryptologic Linguist Apprentice, Telugu'),
('1N338J','Polynesian Cryptologic Linguist Apprentice, Kanarese'),
('1N338K','Polynesian Cryptologic Linguist Apprentice, Malayalam'),
('1N338L','Polynesian Cryptologic Linguist Apprentice, Tamil'),
('1N338M','Polynesian Cryptologic Linguist Apprentice, Malay'),
('1N339A','Indo-Iranian Cryptologic Linguist Apprentice, Assamese'),
('1N339B','Indo-Iranian Cryptologic Linguist Apprentice, Baluchi'),
('1N339C','Indo-Iranian Cryptologic Linguist Apprentice,Bengali'),
('1N339D','Indo-Iranian Cryptologic Linguist Apprentice,Bihari'),
('1N339E','Indo-Iranian Cryptologic Linguist Apprentice,Kurdish (Kurmanji)'),
('1N339F','Indo-Iranian Cryptologic Linguist Apprentice,Kurdish (Sorani)'),
('1N339G','Indo-Iranian Cryptologic Linguist Apprentice, Nepali'),
('1N339H','Indo-Iranian Cryptologic Linguist Apprentice, Sinhala (Singhalese)'),
('1N351','Cryptologic Language Analyst Journeyman'),
('1N351A','Germanic Cryptologic Linguist Journeyman, German'),
('1N351B','Germanic Cryptologic Linguist Journeyman, Dutch'),
('1N351C','Germanic Cryptologic Linguist Journeyman, Flemish'),
('1N351D','Germanic Cryptologic Linguist Journeyman, Swedish'),
('1N351E','Germanic Cryptologic Linguist Journeyman, Afrikaans'),
('1N351F','Cryptologic Language Analyst Journeyman, Arabic'),
('1N351G','Cryptologic Language Analyst Journeyman, Chinese'),
('1N351H','Cryptologic Language Analyst Journeyman, Korean'),
('1N351I','Cryptologic Language Analyst Journeyman, Russian'),
('1N351J','Cryptologic Language Analyst Journeyman, Spanish'),
('1N351K','Cryptologic Language Analyst Journeyman, Persian'),
('1N351L','Cryptologic Language Analyst Journeyman, Hebrew'),
('1N351M','Cryptologic Language Analyst Journeyman, Pashto'),
('1N351N','Cryptologic Language Analyst Journeyman, Urdu'),
('1N351Z','Cryptologic Language Analyst Journeyman, Low-Flow'),
('1N352A','Romance Cryptologic Linguist Journeyman, Spanish (Latin American)'),
('1N352B','Romance Cryptologic Linguist Journeyman, Portuguese (Latin American)'),
('1N352C','Romance Cryptologic Linguist Journeyman, French'),
('1N352D','Romance Cryptologic Linguist Journeyman, Italian'),
('1N352E','Romance Cryptologic Linguist Journeyman, Romanian'),
('1N352F','Romance Cryptologic Linguist Journeyman, Haitian-Creole'),
('1N352G','Romance Cryptologic Linguist Journeyman, Moldovan'),
('1N353A','Slavic Cryptologic Linguist Journeyman, Russian'),
('1N353B','Slavic Cryptologic Linguist Journeyman, Polish'),
('1N353C','Slavic Cryptologic Linguist Journeyman, Czech'),
('1N353D','Slavic Cryptologic Linguist Journeyman, Serbo-Croatian'),
('1N353E','Slavic Cryptologic Linguist Journeyman, Belarusian'),
('1N353F','Slavic Cryptologic Linguist Journeyman, Hungarian'),
('1N353G','Slavic Cryptologic Linguist Journeyman, Lithuanian'),
('1N353H','Slavic Cryptologic Linguist Journeyman, Slovenian'),
('1N353J','Slavic Cryptologic Linguist Journeyman, Bulgarian'),
('1N353K','Slavic Cryptologic Linguist Journeyman, Ukrainian'),
('1N353L','Slavic Cryptologic Linguist Journeyman, Macedonian'),
('1N353M','Slavic Cryptologic Linguist Journeyman, Albanian'),
('1N354A','Far East Cryptologic Linguist Journeyman, Chinese (Mandarin)'),
('1N354B','Far East Cryptologic Linguist Journeyman, Vietnamese'),
('1N354C','Far East Cryptologic Linguist Journeyman, Thai'),
('1N354D','Far East Cryptologic Linguist Journeyman, Cambodian'),
('1N354E','Far East Cryptologic Linguist Journeyman, Lao'),
('1N354F','Far East Cryptologic Linguist Journeyman, Japanese'),
('1N354G','Far East Cryptologic Linguist Journeyman, Korean'),
('1N354H','Far East Cryptologic Linguist Journeyman, Chinese (Cantonese)'),
('1N354J','Far East Cryptologic Linguist Journeyman, Tagalog'),
('1N355A','Mid East Cryptologic Linguist Journeyman, Arabic'),
('1N355B','Mid East Cryptologic Linguist Journeyman, Arabic (Syrian)'),
('1N355C','Mid East Cryptologic Linguist Journeyman, Hebrew'),
('1N355D','Mid East Cryptologic Linguist Journeyman, Persian (Farsi)'),
('1N355E','Mid East Cryptologic Linguist Journeyman, Turkish'),
('1N355F','Mid East Cryptologic Linguist Journeyman, Greek'),
('1N355G','Mid East Cryptologic Linguist Journeyman, Indonesian'),
('1N355H','Mid East Cryptologic Linguist Journeyman, Hindi'),
('1N355J','Mid East Cryptologic Linguist Journeyman, Armenian'),
('1N355K','Mid East Cryptologic Linguist Journeyman, Azeri'),
('1N355L','Mid East Cryptologic Linguist Journeyman, Pushtu'),
('1N355M','Mid East Cryptologic Linguist Journeyman, Georgian'),
('1N355N','Mid East Cryptologic Linguist Journeyman, Tadzhik'),
('1N355P','Mid East Cryptologic Linguist Journeyman, Kazakh'),
('1N355Q','Mid East Cryptologic Linguist Journeyman, Turkmen'),
('1N355R','Mid East Cryptologic Linguist Journeyman, Uzbek'),
('1N355S','Mid East Cryptologic Linguist Journeyman, Persian (Dari)'),
('1N355T','Mid East Cryptologic Linguist Journeyman, Punjabi'),
('1N355V','Mid East Cryptologic Linguist Journeyman, Sindhi'),
('1N355W','Mid East Cryptologic Linguist Journeyman, Urdu'),
('1N356A','African Cryptologic Linguist Journeyman, Swahili'),
('1N356B','African Cryptologic Linguist Journeyman, Zande'),
('1N356C','African Cryptologic Linguist Journeyman, Berber (Shawia)'),
('1N356D','African Cryptologic Linguist Journeyman, Bedawi (Beja)'),
('1N356E','African Cryptologic Linguist Journeyman, Sidamo'),
('1N356F','African Cryptologic Linguist Journeyman, Somali'),
('1N356G','African Cryptologic Linguist Journeyman, Nubian'),
('1N356H','African Cryptologic Linguist Journeyman, Bari'),
('1N356J','African Cryptologic Linguist Journeyman, Dinka'),
('1N356K','African Cryptologic Linguist Journeyman, Nuer'),
('1N356L','African Cryptologic Linguist Journeyman, Otuho'),
('1N356M','African Cryptologic Linguist Journeyman, Shilluk'),
('1N356N','African Cryptologic Linguist Journeyman, Fur'),
('1N356P','African Cryptologic Linguist Journeyman, Amharic'),
('1N356Q','African Cryptologic Linguist Journeyman, Aramaic'),
('1N356R','African Cryptologic Linguist Journeyman, Assyrian'),
('1N356S','African Cryptologic Linguist Journeyman, Tigre'),
('1N356T','African Cryptologic Linguist Journeyman, Tigrinya'),
('1N357A','Turkic Cryptologic Linguist Journeyman, Chechen'),
('1N357B','Turkic Cryptologic Linguist Journeyman, Circassian'),
('1N357C','Turkic Cryptologic Linguist Journeyman, Kirgiz'),
('1N357D','Turkic Cryptologic Linguist Journeyman, Tatar'),
('1N357E','Turkic Cryptologic Linguist Journeyman, Uighur'),
('1N358A','Polynesian Cryptologic Linguist Journeyman, Bikol'),
('1N358B','Polynesian Cryptologic Linguist Journeyman, Cebuano'),
('1N358C','Polynesian Cryptologic Linguist Journeyman, Ilocano'),
('1N358D','Polynesian Cryptologic Linguist Journeyman, Javanese'),
('1N358E','Polynesian Cryptologic Linguist Journeyman, Sudanese'),
('1N358F','Polynesian Cryptologic Linguist Journeyman, Tausug'),
('1N358G','Polynesian Cryptologic Linguist Journeyman, Brahui'),
('1N358H','Polynesian Cryptologic Linguist Journeyman, Telugu'),
('1N358J','Polynesian Cryptologic Linguist Journeyman, Kanarese'),
('1N358K','Polynesian Cryptologic Linguist Journeyman, Malayalam'),
('1N358L','Polynesian Cryptologic Linguist Journeyman, Tamil'),
('1N358M','Polynesian Cryptologic Linguist Journeyman, Malay'),
('1N359A','Indo-Iranian Cryptologic Linguist Journeyman, Assamese'),
('1N359B','Indo-Iranian Cryptologic Linguist Journeyman, Baluchi'),
('1N359C','Indo-Iranian Cryptologic Linguist Journeyman, Bengali'),
('1N359D','Indo-Iranian Cryptologic Linguist Journeyman, Bihari'),
('1N359E','Indo-Iranian Cryptologic Linguist Journeyman, Kurdish (Kurmanji)'),
('1N359F','Indo-Iranian Cryptologic Linguist Journeyman, Kurdish (Sorani)'),
('1N359G','Indo-Iranian Cryptologic Linguist Journeyman, Nepali'),
('1N359H','Indo-Iranian Cryptologic Linguist Journeyman, Sinhala (Singhalese)'),
('1N371','Cryptologic Language Analyst Craftsman'),
('1N371A','Germanic Cryptologic Linguist Craftsman, German'),
('1N371B','Germanic Cryptologic Linguist Craftsman, Dutch'),
('1N371C','Germanic Cryptologic Linguist Craftsman, Flemish'),
('1N371D','Germanic Cryptologic Linguist Craftsman, Swedish'),
('1N371E','Germanic Cryptologic Linguist Craftsman, Afrikaans'),
('1N371F','Cryptologic Language Analyst Craftsman, Arabic'),
('1N371G','Cryptologic Language Analyst Craftsman, Chinese'),
('1N371H','Cryptologic Language Analyst Craftsman, Korean'),
('1N371I','Cryptologic Language Analyst Craftsman, Russian'),
('1N371J','Cryptologic Language Analyst Craftsman, Spanish'),
('1N371K','Cryptologic Language Analyst Craftsman, Persian'),
('1N371L','Cryptologic Language Analyst Craftsman, Hebrew'),
('1N371M','Cryptologic Language Analyst Craftsman, Pashto'),
('1N371N','Cryptologic Language Analyst Craftsman, Urdu'),
('1N371Z','Cryptologic Language Analyst Craftsman, Low-Flow'),
('1N372A','Romance Cryptologic Linguist Craftsman, Spanish (Latin American)'),
('1N372B','Romance Cryptologic Linguist Craftsman, Portuguese (Latin American)'),
('1N372C','Romance Cryptologic Linguist Craftsman, French'),
('1N372D','Romance Cryptologic Linguist Craftsman, Italian'),
('1N372E','Romance Cryptologic Linguist Craftsman, Romanian'),
('1N372F','Romance Cryptologic Linguist Craftsman, Haitian-Creole'),
('1N372G','Romance Cryptologic Linguist Craftsman, Moldovan'),
('1N373A','Slavic Cryptologic Linguist Craftsman, Russian'),
('1N373B','Slavic Cryptologic Linguist Craftsman, Polish'),
('1N373C','Slavic Cryptologic Linguist Craftsman, Czech'),
('1N373D','Slavic Cryptologic Linguist Craftsman, Serbo-Croatian'),
('1N373E','Slavic Cryptologic Linguist Craftsman, Belarusian'),
('1N373F','Slavic Cryptologic Linguist Craftsman, Hungarian'),
('1N373G','Slavic Cryptologic Linguist Craftsman, Lithuanian'),
('1N373H','Slavic Cryptologic Linguist Craftsman, Slovenian'),
('1N373J','Slavic Cryptologic Linguist Craftsman, Bulgarian'),
('1N373K','Slavic Cryptologic Linguist Craftsman, Ukrainian'),
('1N373L','Slavic Cryptologic Linguist Craftsman, Macedonian'),
('1N373M','Slavic Cryptologic Linguist Craftsman, Albanian'),
('1N374A','Far East Cryptologic Linguist Craftsman, Chinese (Mandarin)'),
('1N374B','Far East Cryptologic Linguist Craftsman, Vietnamese'),
('1N374C','Far East Cryptologic Linguist Craftsman, Thai'),
('1N374D','Far East Cryptologic Linguist Craftsman, Cambodian'),
('1N374E','Far East Cryptologic Linguist Craftsman, Lao'),
('1N374F','Far East Cryptologic Linguist Craftsman, Japanese'),
('1N374G','Far East Cryptologic Linguist Craftsman, Korean'),
('1N374H','Far East Cryptologic Linguist Craftsman, Chinese (Cantonese)'),
('1N374J','Far East Cryptologic Linguist Craftsman, Tagalog'),
('1N375A','Mid East Cryptologic Linguist Craftsman, Arabic'),
('1N375B','Mid East Cryptologic Linguist Craftsman, Arabic (Syrian)'),
('1N375C','Mid East Cryptologic Linguist Craftsman, Hebrew'),
('1N375D','Mid East Cryptologic Linguist Craftsman, Persian (Farsi)'),
('1N375E','Mid East Cryptologic Linguist Craftsman, Turkish'),
('1N375F','Mid East Cryptologic Linguist Craftsman, Greek'),
('1N375G','Mid East Cryptologic Linguist Craftsman, Indonesian'),
('1N375H','Mid East Cryptologic Linguist Craftsman, Hindi'),
('1N375J','Mid East Cryptologic Linguist Craftsman, Armenian'),
('1N375K','Mid East Cryptologic Linguist Craftsman, Azeri'),
('1N375L','Mid East Cryptologic Linguist Craftsman, Pushtu'),
('1N375M','Mid East Cryptologic Linguist Craftsman, Georgian'),
('1N375N','Mid East Cryptologic Linguist Craftsman, Tadzhik'),
('1N375P','Mid East Cryptologic Linguist Craftsman, Kazakh'),
('1N375Q','Mid East Cryptologic Linguist Craftsman, Turkmen'),
('1N375R','Mid East Cryptologic Linguist Craftsman, Uzbek'),
('1N375S','Mid East Cryptologic Linguist Craftsman, Persian (Dari)'),
('1N375T','Mid East Cryptologic Linguist Craftsman, Punjabi'),
('1N375V','Mid East Cryptologic Linguist Craftsman, Sindhi'),
('1N375W','Mid East Cryptologic Linguist Craftsman, Urdu'),
('1N376A','African Cryptologic Linguist Craftsman, Swahili'),
('1N376B','African Cryptologic Linguist Craftsman, Zande'),
('1N376C','African Cryptologic Linguist Craftsman, Berber (Shawia)'),
('1N376D','African Cryptologic Linguist Craftsman, Bedawi (Beja)'),
('1N376E','African Cryptologic Linguist Craftsman, Sidamo'),
('1N376F','African Cryptologic Linguist Craftsman, Somali'),
('1N376G','African Cryptologic Linguist Craftsman, Nubian'),
('1N376H','African Cryptologic Linguist Craftsman, Bari'),
('1N376J','African Cryptologic Linguist Craftsman, Dinka'),
('1N376K','African Cryptologic Linguist Craftsman, Nuer'),
('1N376L','African Cryptologic Linguist Craftsman, Otuho'),
('1N376M','African Cryptologic Linguist Craftsman, Shilluk'),
('1N376N','African Cryptologic Linguist Craftsman, Fur'),
('1N376P','African Cryptologic Linguist Craftsman, Amharic'),
('1N376Q','African Cryptologic Linguist Craftsman, Aramaic'),
('1N376R','African Cryptologic Linguist Craftsman, Assyrian'),
('1N376S','African Cryptologic Linguist Craftsman, Tigre'),
('1N376T','African Cryptologic Linguist Craftsman, Tigrinya'),
('1N377A','Turkic Cryptologic Linguist Craftsman, Chechen'),
('1N377B','Turkic Cryptologic Linguist Craftsman, Circassian'),
('1N377C','Turkic Cryptologic Linguist Craftsman, Kirgiz'),
('1N377D','Turkic Cryptologic Linguist Craftsman, Tatar'),
('1N377E','Turkic Cryptologic Linguist Craftsman, Uighur'),
('1N378A','Polynesian Cryptologic Linguist Craftsman, Bikol'),
('1N378B','Polynesian Cryptologic Linguist Craftsman, Cebuano'),
('1N378C','Polynesian Cryptologic Linguist Craftsman, Ilocano'),
('1N378D','Polynesian Cryptologic Linguist Craftsman, Javanese'),
('1N378E','Polynesian Cryptologic Linguist Craftsman, Sudanese'),
('1N378F','Polynesian Cryptologic Linguist Craftsman, Tausug'),
('1N378G','Polynesian Cryptologic Linguist Craftsman, Brahui'),
('1N378H','Polynesian Cryptologic Linguist Craftsman, Telugu'),
('1N378J','Polynesian Cryptologic Linguist Craftsman, Kanarese'),
('1N378K','Polynesian Cryptologic Linguist Craftsman, Malayalam'),
('1N378L','Polynesian Cryptologic Linguist Craftsman, Tamil'),
('1N378M','Polynesian Cryptologic Linguist Craftsman, Malay'),
('1N379A','Indo-Iranian Cryptologic Linguist Craftsman, Assamese'),
('1N379B','Indo-Iranian Cryptologic Linguist Craftsman, Baluchi'),
('1N379C','Indo-Iranian Cryptologic Linguist Craftsman, Bengali'),
('1N379D','Indo-Iranian Cryptologic Linguist Craftsman, Bihari'),
('1N379E','Indo-Iranian Cryptologic Linguist Craftsman, Kurdish (Kurmanji)'),
('1N379F','Indo-Iranian Cryptologic Linguist Craftsman, Kurdish (Sorani)'),
('1N379G','Indo-Iranian Cryptologic Linguist Craftsman, Nepali'),
('1N379H','Indo-Iranian Cryptologic Linguist Craftsman, Sinhala (Singhalese)'),
('1N390','Cryptologic Linguist Superintendent'),
('1N391','Cryptologic Language Analyst Superintendent'),
('1N431','Network Intelligence Analyst Apprentice'),
('1N451','Network Intelligence Analyst Journeyman'),
('1N471','Network Intelligence Analyst Craftsman'),
('1N490','Fusion Analysis Superintendent'),
('1N491','Network Intelligence Analyst Superintendent'),
('20200','Signals Intelligence Analysis Manager'),
('20230','Signal Intelligence Analysis Specialist'),
('20250','Signal Intelligence Analysis Specialist'),
('20270','Signal Intelligence Analysis Specialist'),
('20290','Signals Intelligence Analysis Superintendent'),
('20299','Radio Communications Analysis Security Superintendent'),
('20331','Voice Processing Specialist'),
('20351','Voice Processing Specialist'),
('20371','Voice Processing Specialist'),
('20800','Cryptologic Linguist Manager'),
('20830','Voice Processing Specialist'),
('20831','Germanic Cryptologic Linguist Technician'),
('20832','Romance Cryptologic Linguist Technician'),
('20833','Slavic Cryptologic Linguist Technician'),
('20834','Far East Cryptologic Linguist Technician'),
('20835','Mid East Cryptologic Linguist Technician'),
('20850','Voice Processing Specialist'),
('20851','Germanic Cryptologic Linguist Technician'),
('20852','Romance Cryptologic Linguist Technician'),
('20853','Slavic Cryptologic Linguist Technician'),
('20854','Far East Cryptologic Linguist Technician'),
('20855','Mid East Cryptologic Linguist Technician'),
('20870','Voice Processing Specialist'),
('20871','Germanic Cryptologic Linguist Technician'),
('20872','Romance Cryptologic Linguist Technician'),
('20873','Slavic Cryptologic Linguist Technician'),
('20874','Far East Cryptologic Linguist Technician'),
('20875','Mid East Cryptologic Linguist Technician'),
('20899','Cryptologic Linguist Superintendent'),
('1541','Cryptanalysis'),
('2629','Signals Intelligence Analyst'),
('2639','Non-Morse Communications/Electronic Intelligence Analyst'),
('2642','Cryptologic Translator/Transcriber'),
('2643','Cryptologic Linguist'),
('2649','Cryptanalyst'),
('2669','Cryptologic Support Specialist'),
('2670','Cryptologic Translator'),
('2671','Middle East Cryptologic Linguist'),
('2672','Cryptologic Linguist, Chinese'),
('2673','Asia-Pacific Cryptologic Linguist'),
('2674','European Cryptologic Linguist'),
('2675','Cryptologic Linguist, Russian'),
('2676','Central Asian Cryptologic Linguist'),
('2711','Linguist, Afghan Pushtu'),
('2712','Linguist, Arabic (Mod Std)'),
('2713','Linguist, Arabic (Egyptian)'),
('2714','Linguist, Arabic (Syrian)'),
('2715','Linguist, Arabic (Levantine)'),
('2715','Linguist, Persian-Afghan (Dari)'),
('2716','Linguist, Amharic'),
('2717','Linguist, Bengali'),
('2717','Linguist, Arabic (Maghrebi)'),
('2718','Linguist, Hebrew'),
('2719','Linguist, Hindi'),
('2721','Linguist, Kurdish'),
('2722','Linguist, Persian-Farsi'),
('2723','Linguist, Somali'),
('2724','Linguist, Swahili'),
('2726','Linguist, Turkish'),
('2727','Linguist, Urdu'),
('2728','Linguist, Arabic (Iraqi)'),
('2729','Linguist, Algerian'),
('2733','Linguist, Burmese'),
('2734','Linguist, Cambodian'),
('2735','Linguist, Cebuano'),
('2736','Linguist, Chinese (Cant)'),
('2737','Linguist, Chinese (Man)'),
('2738','Linguist, Indonesian'),
('2739','Linguist, Japanese'),
('2740','Linguist, Maguindanao'),
('2741','Linguist, Korean'),
('2742','Linguist, Laotian'),
('2743','Linguist, Malay'),
('2744','Linguist, Tagalog'),
('2745','Linguist, Tausug'),
('2746','Linguist, Thai'),
('2747','Linguist, Vietnamese'),
('2748','Linguist, Maranao'),
('2749','Linguist, Yakan'),
('2754','Linguist, Dutch'),
('2756','Linguist, Finnish'),
('2757','Linguist, French'),
('2758','Linguist, German'),
('2759','Linguist, Greek'),
('2761','Linguist, Haitian-Creole'),
('2762','Linguist, Icelandic'),
('2763','Linguist, Italian'),
('2764','Linguist, Norwegian'),
('2766','Linguist, Portuguese (BR)'),
('2767','Linguist, Portuguese (EU)'),
('2768','Linguist, Spanish'),
('2769','Linguist, Swedish'),
('2772','Linguist, Afghan Pushtu'),
('2773','Linguist, Persian-Afghan (Dari)'),
('2774','Linguist, Persian-Farsi'),
('2775','Linguist, Urdu'),
('2776','Linguist, Albanian'),
('2777','Linguist, Armenian'),
('2778','Linguist, Bulgarian'),
('2779','Linguist, Czech'),
('2780','Linguist, Uzbek'),
('2781','Linguist, Estonian'),
('2782','Linguist, Georgian'),
('2783','Linguist, Hungarian'),
('2784','Linguist, Latvian'),
('2785','Linguist, Azerbaijani'),
('2786','Linguist, Lithuanian'),
('2787','Linguist, Macedonian'),
('2788','Linguist, Polish'),
('2789','Linguist, Romanian'),
('2791','Linguist, Russian'),
('2792','Linguist, Serb-Croat'),
('2793','Linguist, Slovenian'),
('2794','Linguist, Ukranian'),
('2795','Linguist, Hindi'),
('2796','Linguist, Bengali'),
('001022','Language Analyst Operator'),
('001027','Language Analyst Supervisor'),
('002683','Master Language Analyst'),
('003006','Global Network Operations Technician'),
('003103','Global Network Operations Director'),
('003303','Global Network Operations Manager'),
('8203','ES-3 Electronic Warfare Operational Intelligence Crewman'),
('8295','Cryptologic Technician Operator/Analyst'),
('8297','ES-3A Cryptologic Technician Operator/Analyst'),
('9113','AN/SQQ-137 (SSEE INC E) Advanced Cryptologic Supervisor'),
('9149','Advanced Signals Analyst'),
('9192','Basic Thai Linguist'),
('9193','Basic Indonesian Linguist'),
('9194','Basic Cambodian Linguist'),
('9195','Basic Burmese Linguist'),
('9196','Basic Maly Linguist'),
('9197','Basic Serbia-Croatian Linguist'),
('9198','Basic Polish Linguist'),
('9199','Basic Linguists'),
('9201','Basic Russian Linguist'),
('9202','Basic Tagalog Linguist'),
('9203','Basic Spanish Linguist'),
('9204','Basic French Linguist'),
('9207','Basic German Linguist'),
('9208','Basic Albanian Linguist'),
('9209','Basic Persian (Farsi) Linguist'),
('9211','Basic Chinese (Mandarin) Linguist'),
('9212','Basic Korean Linguist'),
('9213','Basic North Vietnamese Linguist'),
('9215','Basic Hebrew Linguist'),
('9216','Basic Arabic Linguist'),
('9230','Intermediate Russian Linguist'),
('9231','Intermediate Chinese (Mandarin) Linguist'),
('9231','Basic Cryptolinguist'),
('9232','Intermediate Korean Linguists'),
('9233','Intermediate Spanish Linguists'),
('9234','Multilingual-Cryptolinguist'),
('9234','Intermediate French Linguists'),
('9235','Intermediate Hebrew Linguists'),
('9236','Intermediate Arabic Linguists'),
('9237','Intermediate North Vietnamese Linguist'),
('9240','Advanced Russian Linguist'),
('9241','Advanced Chinese (Mandarin) Linguists'),
('9242','Advanced Korean Linguist'),
('9243','Advanced Spanish Linguists'),
('9246','Advanced Arabic Linguists'),
('9310','Basic Bulgarian Linguist'),
('9311','Basic Georgian Linguist'),
('9312','Basic Kurdish Linguist'),
('9313','Basic Portuguese Linguist'),
('9314','Basic Romanian Linguist'),
('9315','Basic Ukrainian Linguist'),
('9316','Basic Linguist')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 12...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('9317','Language Program Manager'),
('9320','Middle East and North Africa Cryptologic Linguist'),
('9321','East and Far East Asia Cryptologic Linguist'),
('9322','Latin and South America Cryptologic Linguist'),
('9323','Eastern Europe Cryptologic Linguist'),
('9ACE','Language Capability (Billets and Personnel) - ACHINESE'),
('9ACH','Language Capability (Personnel Only) - ACHOLI'),
('9ADY','Language Capability (Personnel Only) - ADIGEY'),
('9AEB','Language Capability (Billets and Personnel) - ARABIC-TUNISIAN'),
('9AFR','Language Capability (Billets and Personnel) - AFRIKAANS'),
('9AII','Language Capability (Personnel Only) - ASSYRIAN'),
('9AKA','Language Capability (Personnel Only) - AKAN'),
('9ALE','Language Capability (Personnel Only) - ALEUT'),
('9ALN','Language Capability (Personnel Only) - ALBANIAN-GHEG'),
('9ALS','Language Capability (Personnel Only) - ALBANIAN-TOSK'),
('9AMH','Language Capability (Billets and Personnel) - AMHARIC'),
('9APA','Language Capability (Personnel Only) - APACHE'),
('9APD','Language Capability (Billets and Personnel) - ARABIC-SUDANESE'),
('9ARA','Language Capability (Billets and Personnel) - ARABIC'),
('9ARB','Language Capability (Billets and Personnel) - ARABIC (MODERN STANDARD)'),
('9ARQ','Language Capability (Billets and Personnel) - ARABIC-ALGERIAN'),
('9ARY','Language Capability (Billets and Personnel) - ARABIC-MOROCCAN'),
('9ARZ','Language Capability (Billets and Personnel) - ARABIC-EGYPTIAN'),
('9ASM','Language Capability (Personnel Only) - ASSAMESE'),
('9AVA','Language Capability (Personnel Only) - AVAR'),
('9AVE','Language Capability (Personnel Only) - AVESTAN'),
('9AYL','Language Capability (Billets and Personnel) - ARABIC-LIBYAN'),
('9AYM','Language Capability (Personnel Only) - AYMARA'),
('9AZB','Language Capability (Personnel Only) - AZERBAIJANI, SOUTH'),
('9AZE','Language Capability (Billets and Personnel) - AZERBAIJANI'),
('9AZJ','Language Capability (Personnel Only) - AZERBAIJANI, NORTH'),
('9BAI','Language Capability (Personnel Only) - BAMILIKE'),
('9BAK','Language Capability (Personnel Only) - BASHKIR'),
('9BAL','Language Capability (Billets and Personnel) - BALUCHI'),
('9BAM','Language Capability (Billets and Personnel) - MANDINGO-BAMBARA'),
('9BAN','Language Capability (Billets and Personnel) - BALINESE'),
('9BAR','Language Capability (Personnel Only) - GERMAN-BAVARIAN'),
('9BAS','Language Capability (Personnel Only) - BASSA (CAMAROONS)'),
('9BDQ','Language Capability (Personnel Only) - BAHNAR'),
('9BEJ','Language Capability (Personnel Only) - BEJA'),
('9BEL','Language Capability (Personnel Only) - BELORUSSIAN'),
('9BEM','Language Capability (Personnel Only) - BEMBA'),
('9BEN','Language Capability (Billets and Personnel) - BENGALI'),
('9BER','Language Capability (Personnel Only) - BERBER'),
('9BHB','Language Capability (Personnel Only) - BHILI'),
('9BIH','Language Capability (Personnel Only) - BIHARI'),
('9BIK','Language Capability (Personnel Only) - BICOL'),
('9BIN','Language Capability (Personnel Only) - BINI'),
('9BLA','Language Capability (Personnel Only) - BLACKFOOT'),
('9BOD','Language Capability (Personnel Only) - TIBETAN'),
('9BRE','Language Capability (Personnel Only) - BRETON'),
('9BRH','Language Capability (Personnel Only) - BRAHUI'),
('9BRI','Language Capability (Personnel Only) - BAKWERI'),
('9BSK','Language Capability (Personnel Only) - BURUSHASKI'),
('9BSQ','Language Capability (Personnel Only) - BASSA-KRU'),
('9BTB','Language Capability (Personnel Only) - BETI'),
('9BTK','Language Capability (Personnel Only) - BATAK'),
('9BUL','Language Capability (Billets and Personnel) - BULGARIAN'),
('9CAT','Language Capability (Personnel Only) - CATALAN'),
('9CBK','Language Capability (Billets and Personnel) - CHAVACANO'),
('9CEB','Language Capability (Personnel Only) - CEBUANO'),
('9CES','Language Capability (Personnel Only) - CZECH'),
('9CGG','Language Capability (Personnel Only) - CHIGA'),
('9CHA','Language Capability (Personnel Only) - GUAMANIAN'),
('9CHE','Language Capability (Billets and Personnel) - CHECHEN'),
('9CHK','Language Capability (Personnel Only) - TRUKESE'),
('9CHO','Language Capability (Personnel Only) - CHOCTAW'),
('9CHR','Language Capability (Personnel Only) - CHEROKEE'),
('9CHU','Language Capability (Personnel Only) - OLD SLAVONIC'),
('9CHV','Language Capability (Personnel Only) - CHUVASH'),
('9CJK','Language Capability (Personnel Only) - CHOKWE'),
('9CKT','Language Capability (Personnel Only) - CHUKCHI'),
('9CLD','Language Capability (Personnel Only) - CHALDEAN'),
('9CMN','Language Capability (Billets and Personnel) - CHINESE-MANDARIN'),
('9COP','Language Capability (Personnel Only) - COPTIC'),
('9COR','Language Capability (Personnel Only) - CORNISH'),
('9CPF','Language Capability (Personnel Only) - FRENCH CREOLE'),
('9CRE','Language Capability (Personnel Only) - CREE'),
('9CSB','Language Capability (Personnel Only) - KASHUBIAN'),
('9CYM','Language Capability (Personnel Only) - WELSH'),
('9CZH','Language Capability (Personnel Only) - CHINESE-ANHWEI'),
('9DAK','Language Capability (Personnel Only) - DAKOTA'),
('9DAN','Language Capability (Billets and Personnel) - DANISH'),
('9DCR','Language Capability (Personnel Only) - DUTCH-CREOLE'),
('9DEU','Language Capability (Billets and Personnel) - GERMAN'),
('9DIN','Language Capability (Personnel Only) - DINKA'),
('9DIQ','Language Capability (Personnel Only) - DIMLI'),
('9DIV','Language Capability (Personnel Only) - DIVEHI'),
('9DOI','Language Capability (Personnel Only) - DOGRI-KANGRI'),
('9DUA','Language Capability (Personnel Only) - DUALA'),
('9DYU','Language Capability (Personnel Only) - MANDINGO-DIOULA'),
('9DZO','Language Capability (Personnel Only) - DZONGKHA'),
('9EFI','Language Capability (Personnel Only) - EFIK'),
('9ELL','Language Capability (Billets and Personnel) - GREEK'),
('9EST','Language Capability (Billets and Personnel) - ESTONIAN'),
('9EUS','Language Capability (Personnel Only) - BASQUE'),
('9EVN','Language Capability (Personnel Only) - TUNGUSU'),
('9EWE','Language Capability (Personnel Only) - EWE'),
('9EWO','Language Capability (Personnel Only) - EWONDO'),
('9FAO','Language Capability (Personnel Only) - FAROESE'),
('9FIJ','Language Capability (Personnel Only) - FIJIAN'),
('9FIN','Language Capability (Billets and Personnel) - FINNISH'),
('9FNG','Language Capability (Personnel Only) - FANA'),
('9FON','Language Capability (Personnel Only) - FON'),
('9FRA','Language Capability (Billets and Personnel) - FRENCH'),
('9FRC','Language Capability (Personnel Only) - CAJUN'),
('9FRO','Language Capability (Personnel Only) - OLD FRENCH'),
('9FRY','Language Capability (Personnel Only) - FRISIAN'),
('9FUD','Language Capability (Personnel Only) - FUTNIAN'),
('9FUF','Language Capability (Personnel Only) - FUUTA JALON'),
('9FUL','Language Capability (Billets and Personnel) - FULANI'),
('9GAA','Language Capability (Personnel Only) - GA'),
('9GAN','Language Capability (Billets and Personnel) - CHINESE-GAN'),
('9GIL','Language Capability (Personnel Only) - KIRIBATI'),
('9GLA','Language Capability (Personnel Only) - SCOTCH-GAELIC'),
('9GLE','Language Capability (Personnel Only) - GAELIC'),
('9GLG','Language Capability (Personnel Only) - GALICIAN'),
('9GLK','Language Capability (Personnel Only) - GILAKI'),
('9GLV','Language Capability (Personnel Only) - MANX'),
('9GOG','Language Capability (Personnel Only) - GOGO'),
('9GOH','Language Capability (Personnel Only) - OLD HIGH GERMAN'),
('9GON','Language Capability (Personnel Only) - GONDI'),
('9GOT','Language Capability (Personnel Only) - GOTHIC'),
('9GRC','Language Capability (Personnel Only) - GREEK-ANCIENT'),
('9GRN','Language Capability (Billets and Personnel) - GUARANI'),
('9GSW','Language Capability (Billets and Personnel) - GERMAN-SWISS'),
('9GUJ','Language Capability (Billets and Personnel) - GUJARATI'),
('9GUZ','Language Capability (Personnel Only) - GUSII'),
('9HAK','Language Capability (Personnel Only) - CHINESE-HAKKA'),
('9HAT','Language Capability (Billets and Personnel) - HAITIAN-CREOLE'),
('9HAU','Language Capability (Billets and Personnel) - HAUSA'),
('9HAW','Language Capability (Personnel Only) - HAWAIIAN'),
('9HAY','Language Capability (Personnel Only) - HAYA'),
('9HBO','Language Capability (Personnel Only) - HEBREW-ANCIENT'),
('9HBS','Language Capability (Billets and Personnel) - SERBO-CROATIAN'),
('9HDY','Language Capability (Personnel Only) - HADIYYA'),
('9HEB','Language Capability (Billets and Personnel) - HEBREW'),
('9HER','Language Capability (Personnel Only) - HERERO'),
('9HIL','Language Capability (Billets and Personnel) - HILIGAYNON'),
('9HIN','Language Capability (Billets and Personnel) - HINDI'),
('9HMN','Language Capability (Personnel Only) - HMONG'),
('9HMO','Language Capability (Personnel Only) - PAPUAN'),
('9HOC','Language Capability (Personnel Only) - HO'),
('9HOP','Language Capability (Personnel Only) - HOPI'),
('9HSN','Language Capability (Personnel Only) - CHINESE-HSIANG'),
('9HUN','Language Capability (Personnel Only) - HUNGARIAN'),
('9HWC','Language Capability (Personnel Only) - HAWAIIAN CREOLE'),
('9HYE','Language Capability (Billets and Personnel) - ARMENIAN'),
('9IBA','Language Capability (Personnel Only) - IBAN'),
('9IBG','Language Capability (Personnel Only) - IBANAG'),
('9IBO','Language Capability (Billets and Personnel) - IBO'),
('9IJO','Language Capability (Personnel Only) - IJAW'),
('9ILB','Language Capability (Personnel Only) - ILA-TONGA'),
('9ILO','Language Capability (Personnel Only) - ILOCANO'),
('9IND','Language Capability (Billets and Personnel) - INDONESIAN'),
('9ISL','Language Capability (Personnel Only) - ICELANDIC'),
('9ITA','Language Capability (Billets and Personnel) - ITALIAN'),
('9JAM','Language Capability (Personnel Only) - ENGLISH CARIBBEAN CREOLE'),
('9JAV','Language Capability (Billets and Personnel) - JAVANESE'),
('9JBN','Language Capability (Personnel Only) - ZERBA'),
('9JPN','Language Capability (Billets and Personnel) - JAPANESE'),
('9JRA','Language Capability (Personnel Only) - JARAI'),
('9KAB','Language Capability (Personnel Only) - KABYLE'),
('9KAC','Language Capability (Personnel Only) - KACHIN'),
('9KAM','Language Capability (Personnel Only) - KAMBA'),
('9KAN','Language Capability (Billets and Personnel) - KANARESE'),
('9KAR','Language Capability (Personnel Only) - KAREN'),
('9KAS','Language Capability (Personnel Only) - KASHMIRI'),
('9KAT','Language Capability (Billets and Personnel) - GEORGIAN'),
('9KAU','Language Capability (Personnel Only) - KANURI'),
('9KAZ','Language Capability (Billets and Personnel) - KAZAKH'),
('9KBP','Language Capability (Personnel Only) - KABRE'),
('9KHM','Language Capability (Billets and Personnel) - CAMBODIAN'),
('9KIK','Language Capability (Personnel Only) - KIKUYU'),
('9KIN','Language Capability (Personnel Only) - KINYARWANDA'),
('9KIR','Language Capability (Personnel Only) - KIRGHIZ'),
('9KMB','Language Capability (Personnel Only) - KIMBUNDU'),
('9KMR','Language Capability (Personnel Only) - KURMANJE'),
('9KOK','Language Capability (Personnel Only) - KONKANIS'),
('9KON','Language Capability (Personnel Only) - KIKONGO'),
('9KOR','Language Capability (Billets and Personnel) - KOREAN'),
('9KOS','Language Capability (Personnel Only) - KUSAIE'),
('9KPE','Language Capability (Personnel Only) - KPELLE'),
('9KPG','Language Capability (Personnel Only) - KAPINGAMARANGI'),
('9KPO','Language Capability (Personnel Only) - AKPOSSO'),
('9KRC','Language Capability (Personnel Only) - KARACHAI-BALKHAR'),
('9KRI','Language Capability (Personnel Only) - KRIO'),
('9KRU','Language Capability (Personnel Only) - KURUKH'),
('9KTB','Language Capability (Personnel Only) - KAMBATTA'),
('9KTU','Language Capability (Personnel Only) - KITUBA'),
('9KUR','Language Capability (Billets and Personnel) - KURDISH'),
('9LAD','Language Capability (Personnel Only) - LADINO'),
('9LAH','Language Capability (Personnel Only) - LAHNDA'),
('9LAM','Language Capability (Personnel Only) - LAMBA'),
('9LAO','Language Capability (Billets and Personnel) - LAO'),
('9LAT','Language Capability (Personnel Only) - LATIN'),
('9LAV','Language Capability (Billets and Personnel) - LATVIAN'),
('9LCF','Language Capability (Personnel Only) - LUBU'),
('9LDD','Language Capability (Personnel Only) - LURI'),
('9LHU','Language Capability (Personnel Only) - LAHU'),
('9LIN','Language Capability (Billets and Personnel) - LINGALA'),
('9LIS','Language Capability (Personnel Only) - LISU'),
('9LIT','Language Capability (Billets and Personnel) - LITHUANIAN'),
('9LJP','Language Capability (Personnel Only) - LAMPUNG'),
('9LKT','Language Capability (Personnel Only) - LAKOTA'),
('9LNS','Language Capability (Personnel Only) - KUMBO/LAMNSO'),
('9LOL','Language Capability (Personnel Only) - LOMONGO'),
('9LOM','Language Capability (Personnel Only) - LOMA'),
('9LUA','Language Capability (Personnel Only) - LUBA KASAI'),
('9LUB','Language Capability (Personnel Only) - LUBA KATANGA'),
('9LUE','Language Capability (Personnel Only) - LUVALE'),
('9LUG','Language Capability (Personnel Only) - LUGANDA'),
('9LUN','Language Capability (Personnel Only) - LUNDA'),
('9LUO','Language Capability (Personnel Only) - LUO'),
('9LUY','Language Capability (Personnel Only) - LUYIA'),
('9MAD','Language Capability (Billets and Personnel) - MADURESE'),
('9MAH','Language Capability (Personnel Only) - MARSHALESE'),
('9MAK','Language Capability (Personnel Only) - MAKASSAR'),
('9MAL','Language Capability (Billets and Personnel) - MALAYALAM'),
('9MAR','Language Capability (Billets and Personnel) - MARATHI'),
('9MAS','Language Capability (Personnel Only) - MASAI'),
('9MDH','Language Capability (Billets and Personnel) - MAGINDANAON'),
('9MEN','Language Capability (Personnel Only) - MENDE'),
('9MER','Language Capability (Personnel Only) - MERU'),
('9MFA','Language Capability (Personnel Only) - MALAY PATTANI'),
('9MIN','Language Capability (Personnel Only) - MINANGKABAU'),
('9MIQ','Language Capability (Personnel Only) - MISKITO'),
('9MKD','Language Capability (Billets and Personnel) - MACEDONIAN'),
('9MLG','Language Capability (Personnel Only) - MALAGASY'),
('9MLQ','Language Capability (Personnel Only) - MANDINGO-MALINKE'),
('9MLT','Language Capability (Personnel Only) - MALTESE'),
('9MLY','Language Capability (Billets and Personnel) - MALAY'),
('9MNI','Language Capability (Personnel Only) - MEITHEI'),
('9MNP','Language Capability (Personnel Only) - CHINESE-FUCHOW'),
('9MON','Language Capability (Personnel Only) - MONGOLIAN'),
('9MOS','Language Capability (Personnel Only) - MOSSI'),
('9MRI','Language Capability (Personnel Only) - MAORI'),
('9MRL','Language Capability (Personnel Only) - MORTLOCKESE'),
('9MRW','Language Capability (Personnel Only) - MARANAO'),
('9MSI','Language Capability (Personnel Only) - PIZAR MALAY'),
('9MTQ','Language Capability (Personnel Only) - MUONG'),
('9MUS','Language Capability (Personnel Only) - MUSKOGEE'),
('9MWR','Language Capability (Personnel Only) - RAJASTHANI'),
('9MYA','Language Capability (Billets and Personnel) - BURMESE'),
('9MYE','Language Capability (Personnel Only) - MPONGWE'),
('9MYG','Language Capability (Personnel Only) - AMASHI'),
('9MYN','Language Capability (Personnel Only) - MAYA'),
('9MZN','Language Capability (Personnel Only) - MAZANDERANI'),
('9NAN','Language Capability (Billets and Personnel) - CHINESE-AMOY (SOUTH MIN)'),
('9NAP','Language Capability (Personnel Only) - ITALIAN-NEAPOLITAN'),
('9NAU','Language Capability (Personnel Only) - NAURUAN'),
('9NAV','Language Capability (Personnel Only) - NAVAJO'),
('9NDE','Language Capability (Personnel Only) - NDEBELE'),
('9NEP','Language Capability (Billets and Personnel) - NEPALESE'),
('9NGL','Language Capability (Personnel Only) - LOMWE'),
('9NIU','Language Capability (Personnel Only) - NIUE'),
('9NLD','Language Capability (Billets and Personnel) - DUTCH'),
('9NNO','Language Capability (Personnel Only) - LANDSMAL'),
('9NOB','Language Capability (Billets and Personnel) - NORWEGIAN'),
('9NOD','Language Capability (Personnel Only) - LANNA'),
('9NON','Language Capability (Personnel Only) - OLD NORSE'),
('9NUB','Language Capability (Personnel Only) - NUBIAN'),
('9NUP','Language Capability (Personnel Only) - NUPE'),
('9NUT','Language Capability (Personnel Only) - NUNG'),
('9NYA','Language Capability (Personnel Only) - NYANJA'),
('9NYN','Language Capability (Personnel Only) - NYANKOLE'),
('9NYO','Language Capability (Personnel Only) - NYORO'),
('9OJI','Language Capability (Personnel Only) - OGIBWA'),
('9OOD','Language Capability (Personnel Only) - PAPAGO-PIMA'),
('9ORI','Language Capability (Billets and Personnel) - ORYIA'),
('9ORM','Language Capability (Personnel Only) - GALLA'),
('9OSS','Language Capability (Billets and Personnel) - OSSETIC'),
('9PAG','Language Capability (Personnel Only) - PANGASINAN'),
('9PAM','Language Capability (Personnel Only) - PAMPANGAN'),
('9PAN','Language Capability (Billets and Personnel) - PUNJABI'),
('9PAP','Language Capability (Billets and Personnel) - PAPIAMENTO'),
('9PAU','Language Capability (Personnel Only) - PALAUAN'),
('9PBT','Language Capability (Billets and Personnel) - PASHTO-AFGHAN'),
('9PBU','Language Capability (Billets and Personnel) - PASHTO-PESHAWARI'),
('9PDC','Language Capability (Personnel Only) - PENNSYLVANIA DUTCH'),
('9PES','Language Capability (Billets and Personnel) - PERSIAN-FARSI (IRANIAN)'),
('9PLI','Language Capability (Personnel Only) - PALI'),
('9POL','Language Capability (Billets and Personnel) - POLISH'),
('9PON','Language Capability (Personnel Only) - PONAPEAN'),
('9POR','Language Capability (Billets and Personnel) - PORTUGUESE'),
('9PRS','Language Capability (Billets and Personnel) - PERSIAN-DARI (AFGHAN)'),
('9PRV','Language Capability (Personnel Only) - PROVENCAL'),
('9PUS','Language Capability (Billets and Personnel) - PASHTO'),
('9PUW','Language Capability (Personnel Only) - PULAP'),
('9QAC','Language Capability (Billets and Personnel) - ARABIC-CLASSICAL'),
('9QAG','Language Capability (Billets and Personnel) - ARABIC-GULF'),
('9QAI','Language Capability (Billets and Personnel) - ARABIC-IRAQI'),
('9QAJ','Language Capability (Billets and Personnel) - ARABIC-JORDANIAN'),
('9QAL','Language Capability (Billets and Personnel) - ARABIC-SYRIAN'),
('9QAM','Language Capability (Billets and Personnel) - ARABIC-MAGHREBI'),
('9QAS','Language Capability (Billets and Personnel) - ARABIC-PENINSULA'),
('9QAY','Language Capability (Billets and Personnel) - ARABIC-YEMENI'),
('9QBA','Language Capability (Personnel Only) - BAULE'),
('9QBG','Language Capability (Personnel Only) - BUGINESE-MAKASSARESE'),
('9QBS','Language Capability (Billets and Personnel) - VISAYAN OR BISAYAN'),
('9QCB','Language Capability (Personnel Only) - SPANISH-CARIBBEAN'),
('9QCS','Language Capability (Personnel Only) - CHINESE-SWATOW'),
('9QDK','Language Capability (Personnel Only) - KADAZAN-DUSUN'),
('9QDS','Language Capability (Personnel Only) - DJERMA-SONGHAI'),
('9QES','Language Capability (Personnel Only) - ESKIMO'),
('9QFB','Language Capability (Personnel Only) - FANG'),
('9QFO','Language Capability (Personnel Only) - FORMOSAN'),
('9QGD','Language Capability (Personnel Only) - GREEK DEMOTIC'),
('9QGK','Language Capability (Personnel Only) - GREEK KATHAREVOUSA'),
('9QGN','Language Capability (Billets and Personnel) - GREEK (NEW TESTAMENT)'),
('9QHN','Language Capability (Billets and Personnel) - HINDUSTANI'),
('9QKE','Language Capability (Personnel Only) - KERES'),
('9QKS','Language Capability (Personnel Only) - KISSI'),
('9QLB','Language Capability (Billets and Personnel) - ARABIC-LEBANESE (LEVANTINE)'),
('9QLE','Language Capability (Billets and Personnel) - LATIN (ECCLESIASTIC)'),
('9QLO','Language Capability (Personnel Only) - LOLO'),
('9QMI','Language Capability (Personnel Only) - YAO (CHINA)'),
('9QMN','Language Capability (Personnel Only) - CHINESE-FUKIENESE'),
('9QMR','Language Capability (Personnel Only) - MORDVIN'),
('9QNC','Language Capability (Personnel Only) - VIETNAMESE-CENTRAL'),
('9QNG','Language Capability (Personnel Only) - NGBANI'),
('9QNS','Language Capability (Personnel Only) - VIETNAMESE-SAIGON'),
('9QPA','Language Capability (Personnel Only) - PAHARI'),
('9QPB','Language Capability (Billets and Personnel) - PORTUGUESE-BRAZILIAN'),
('9QPE','Language Capability (Billets and Personnel) - PORTUGUESE-EUROPEAN'),
('9QRY','Language Capability (Personnel Only) - RYUKYUAN'),
('9QSA','Language Capability (Billets and Personnel) - SPANISH-AMERICAN'),
('9QSB','Language Capability (Personnel Only) - KHERWARI'),
('9QSC','Language Capability (Billets and Personnel) - SPANISH-CREOLE'),
('9QSE','Language Capability (Billets and Personnel) - SPANISH-CASTILLIAN'),
('9QSM','Language Capability (Personnel Only) - SAMA'),
('9QSN','Language Capability (Personnel Only) - SUKUMA-NYAMWEZI'),
('9QSO','Language Capability (Billets and Personnel) - SOTHO'),
('9QTH','Language Capability (Personnel Only) - TAPACHULA'),
('9QTO','Language Capability (Personnel Only) - CHINESE-TOISHAN'),
('9QUE','Language Capability (Billets and Personnel) - QUECHUA'),
('9RAD','Language Capability (Personnel Only) - RHADE'),
('9RAR','Language Capability (Personnel Only) - ROROTONGAN'),
('9REJ','Language Capability (Personnel Only) - REJANG'),
('9RIF','Language Capability (Personnel Only) - TARIFT'),
('9ROH','Language Capability (Personnel Only) - RHAETO-ROMANCE'),
('9ROM','Language Capability (Personnel Only) - ROMANY'),
('9RON','Language Capability (Billets and Personnel) - ROMANIAN'),
('9RUN','Language Capability (Personnel Only) - RUNDI/KIRUNDI'),
('9RUS','Language Capability (Billets and Personnel) - RUSSIAN'),
('9SAG','Language Capability (Personnel Only) - SANGO'),
('9SAH','Language Capability (Personnel Only) - YAKUT'),
('9SAI','Language Capability (Billets and Personnel) - SOUTH AMERICAN'),
('9SAN','Language Capability (Personnel Only) - SANSKRIT'),
('9SAS','Language Capability (Personnel Only) - SASAK'),
('9SAT','Language Capability (Personnel Only) - SANTALI'),
('9SCN','Language Capability (Personnel Only) - ITALIAN-SICILIAN'),
('9SDH','Language Capability (Personnel Only) - SORANI'),
('9SED','Language Capability (Personnel Only) - SEDANG'),
('9SEH','Language Capability (Billets and Personnel) - SENA'),
('9SHI','Language Capability (Personnel Only) - SHLUH'),
('9SHN','Language Capability (Personnel Only) - SHAN'),
('9SID','Language Capability (Personnel Only) - SIDAMO'),
('9SIN','Language Capability (Personnel Only) - SINGHALESE'),
('9SLK','Language Capability (Billets and Personnel) - SLOVAK'),
('9SLV','Language Capability (Billets and Personnel) - SLOVENIAN'),
('9SMI','Language Capability (Personnel Only) - LAPP'),
('9SMO','Language Capability (Personnel Only) - SAMOAN'),
('9SNA','Language Capability (Personnel Only) - SHONA'),
('9SND','Language Capability (Billets and Personnel) - SINDHI'),
('9SNK','Language Capability (Personnel Only) - SONINKE'),
('9SOM','Language Capability (Billets and Personnel) - SOMALI'),
('9SOP','Language Capability (Personnel Only) - SONGE'),
('9SOU','Language Capability (Personnel Only) - PAKTAI'),
('9SPA','Language Capability (Billets and Personnel) - SPANISH'),
('9SQI','Language Capability (Billets and Personnel) - ALBANIAN'),
('9SRB','Language Capability (Personnel Only) - SARA'),
('9SRD','Language Capability (Personnel Only) - ITALIAN-SARDINIAN'),
('9SRN','Language Capability (Billets and Personnel) - TAKI-TAKI'),
('9SRR','Language Capability (Personnel Only) - SERER'),
('9SSW','Language Capability (Personnel Only) - SWATI'),
('9SUN','Language Capability (Personnel Only) - SUNDANESE'),
('9SUS','Language Capability (Personnel Only) - SUSU'),
('9SUX','Language Capability (Personnel Only) - SUMERIAN'),
('9SWA','Language Capability (Billets and Personnel) - SWAHILI'),
('9SWB','Language Capability (Personnel Only) - COMORIAN'),
('9SWE','Language Capability (Billets and Personnel) - SWEDISH'),
('9SYC','Language Capability (Personnel Only) - SYRIAC'),
('9SYL','Language Capability (Personnel Only) - SYLHETTI'),
('9SYR','Language Capability (Personnel Only) - ARAMAIC'),
('9TAH','Language Capability (Personnel Only) - TAHITIAN'),
('9TAM','Language Capability (Billets and Personnel) - TAMIL'),
('9TAT','Language Capability (Personnel Only) - TATAR'),
('9TCY','Language Capability (Personnel Only) - TULU'),
('9TEL','Language Capability (Billets and Personnel) - TELUGU'),
('9TEM','Language Capability (Personnel Only) - TEMNE'),
('9TET','Language Capability (Personnel Only) - TETUM'),
('9TGK','Language Capability (Billets and Personnel) - TADJIK (TAJIK)'),
('9TGL','Language Capability (Billets and Personnel) - TAGALOG'),
('9THA','Language Capability (Billets and Personnel) - THAI'),
('9TIG','Language Capability (Personnel Only) - TIGRE'),
('9TIR','Language Capability (Billets and Personnel) - TIGRINYA'),
('9TIV','Language Capability (Personnel Only) - TIV'),
('9TKL','Language Capability (Personnel Only) - TOKELAUAN'),
('9TLL','Language Capability (Personnel Only) - OTETELA'),
('9TMH','Language Capability (Personnel Only) - TAMACHEK'),
('9TOI','Language Capability (Personnel Only) - TONGA-TOI'),
('9TOU','Language Capability (Personnel Only) - THO'),
('9TPI','Language Capability (Personnel Only) - PIDGIN ENGLISH'),
('9TSC','Language Capability (Personnel Only) - TSWA'),
('9TSG','Language Capability (Billets and Personnel) - MORO'),
('9TSN','Language Capability (Personnel Only) - TSWANA'),
('9TSO','Language Capability (Personnel Only) - TSONGA'),
('9TUK','Language Capability (Personnel Only) - TURKOMAN'),
('9TUM','Language Capability (Personnel Only) - TUMBUKA'),
('9TUP','Language Capability (Personnel Only) - TUPI'),
('9TUR','Language Capability (Billets and Personnel) - TURKISH'),
('9TVL','Language Capability (Personnel Only) - TUVULAN'),
('9TZM','Language Capability (Personnel Only) - TAMAZIGHT'),
('9UIG','Language Capability (Billets and Personnel) - UIGHUR'),
('9UKR','Language Capability (Billets and Personnel) - UKRAINIAN'),
('9ULI','Language Capability (Personnel Only) - ULITHI'),
('9UMB','Language Capability (Personnel Only) - UMBUNDU OR MBUNDU'),
('9URD','Language Capability (Billets and Personnel) - URDU'),
('9UZB','Language Capability (Billets and Personnel) - UZBEK'),
('9VAI','Language Capability (Personnel Only) - VAI'),
('9VIE','Language Capability (Billets and Personnel) - VIETNAMESE-HANOI'),
('9VMW','Language Capability (Personnel Only) - MAKUA'),
('9VOL','Language Capability (Personnel Only) - VOLAPUK'),
('9WAL','Language Capability (Personnel Only) - WALAMO'),
('9WAR','Language Capability (Personnel Only) - WARAY-WARAY'),
('9WBM','Language Capability (Personnel Only) - WA'),
('9WEN','Language Capability (Personnel Only) - WENDISH'),
('9WES','Language Capability (Personnel Only) - WESCOS'),
('9WLS','Language Capability (Personnel Only) - WALLISIAN'),
('9WOE','Language Capability (Personnel Only) - WOLEAI'),
('9WOL','Language Capability (Billets and Personnel) - WOLOF'),
('9WUU','Language Capability (Billets and Personnel) - CHINESE-WU'),
('9XHO','Language Capability (Personnel Only) - XHOSA'),
('9XOG','Language Capability (Personnel Only) - SOGA'),
('9YAO','Language Capability (Personnel Only) - YAO (MALAWI & MOZAMBIQUE)'),
('9YAP','Language Capability (Personnel Only) - YAPPESE'),
('9YID','Language Capability (Personnel Only) - YIDDISH'),
('9YKA','Language Capability (Personnel Only) - YAKAN'),
('9YOR','Language Capability (Billets and Personnel) - YORUBA'),
('9YUE','Language Capability (Billets and Personnel) - CHINESE-CANTONESE'),
('9ZAP','Language Capability (Personnel Only) - ZAPOTECO'),
('9ZEN','Language Capability (Personnel Only) - ZENAGA'),
('9ZHA','Language Capability (Personnel Only) - T-UNG'),
('9ZHO','Language Capability (Billets and Personnel) - CHINESE'),
('9ZNE','Language Capability (Personnel Only) - ZANDE'),
('9ZUL','Language Capability (Personnel Only) - ZULU'),
('9ZUN','Language Capability (Personnel Only) - ZUNI'),
('CTI','Cryptologic Technician Interpretative'),
('CTN','Cryptologic Technician Networks'),
('17L','Aerial Sensor Specialist (RC)'),
('29E','Electronic Warfare Specialist'),
('35H','Common Ground Station (CGS) Analyst'),
('35S','Signals Collector/Analyst'),
('96H','Common Ground Station Operator'),
('98J','Electronic Intelligence Interceptor/Analyst'),
('98Y','Signals Collector/Analyst'),
('123300','Electronic Countermeasures'),
('1N600','Electronic Systems Security Assessment Manager'),
('1N631','Electronic Systems Security Assessment Apprentice'),
('1N651','Electronic Systems Security Assessment Journeyman'),
('1N671','Electronic Systems Security Assessment Craftsman'),
('1N691','Electronic Systems Security Assessment Superintendent'),
('20500','Electronic Intelligence Operations Manager'),
('20530','Electronic Intelligence Operations Specialist'),
('20550','Electronic Intelligence Operations Specialist'),
('20570','Electronic Intelligence Operations Specialist'),
('20590','Electronic Intelligence Operations Superintendent'),
('20900','Defensive C3CM Manager'),
('20930','Defensive C3CM Specialist'),
('20950','Defensive C3CM Specialist'),
('20970','Defensive C3CM Specialist'),
('20990','Defensive C3CM Superintendent'),
('27631','Electronic Warfare Countermeasures Specialist'),
('27651','Electronic Warfare Countermeasures Specialist'),
('27671','Electronic Warfare Countermeasures Specialist'),
('8621','Surveillance Sensor Operator'),
('001600','Airborne Electronic Intelligence Specialist'),
('1733','Electronic Warfare Systems Technician (AN/SLQ-32(V)2)'),
('1734','Electronic Warfare Systems Technician (AN/SLQ-32(V)3)'),
('1736','Electronic Warfare Systems Maintenance Technician (AN/SLQ-32(V)4)'),
('1737','Electronics Warfare Systems Technician (AN/SLQ-32A(V)5/AN/SLQ-32(V)5)'),
('1738','Electronic Warfare Journeyman Maintenance Technician (AN/SLQ-32A(V)3/AN/SLQ-2(V)3)'),
('1743','Electronic Warfare Systems Technician (AN/WLR-1H)'),
('1753','Electronics Warfare Systems Technician (AN/SQL-17A(V)2)'),
('1781','Electronic Warfare Technician (Advanced Application)'),
('3907','OSIS Baseline Upgrade (OBU) User/Analyst'),
('124','Intelligence'),
('04B','Translator-Interpreter'),
('04C','Expert Linguist'),
('09L','Interpreter/Translator'),
('35M','Human Intelligence Collector'),
('96C','Interrogator'),
('97E','Human Intelligence Collector'),
('97L','Translator/Interpreter (RC)'),
('124100','Language Interrogation/Interpretation'),
('20300','Linguist/Interrogator Manager'),
('20330','Linguist/Interrogator Specialist'),
('20350','Linguist/Interrogator Specialist'),
('20370','Linguist/Interrogator Specialist'),
('8D000','Strategic Debriefer'),
('8D100','Language & Culture Advisor'),
('99103','Interpreter/Translator'),
('99606','Linguist Debriefer/Interrogator'),
('9L000','Interpreter/Translator'),
('1040','Language Specialist'),
('1045','Translator'),
('1047','Interpreter'),
('1040','Language Specialist'),
('0251','Interrogator/Debriefer'),
('0294','Interrogator-Translator Chief'),
('2799','Military Interpreter/Translator'),
('8611','Interpreter (Designated Language)'),
('003807','Defense Threat Reduction Agency Linguist'),
('9520','Consecutive Foreign Language Translator'),
('35G','Geospatial Intelligence Imagery Analyst'),
('96D','Imagery Analyst'),
('124200','Image Interpretation'),
('1N000','Intelligence Manager'),
('1N032','Target Intelligence'),
('1N052','Target Intelligence'),
('1N072','Target Intelligence'),
('1N131','Imagery Analysis Apprentice'),
('1N131A','Geospatial Intelligence Apprentice, Analyst'),
('1N131B','Geospatial Intelligence Apprentice, Targeteer'),
('1N151','Imagery Analysis Journeyman'),
('1N151A','Geospatial Intelligence Journeyman, Analyst'),
('1N151B','Geospatial Intelligence Journeyman, Targeteer'),
('1N171','Imagery Analysis Craftsman'),
('1N171A','Geospatial Intelligence Craftsman, Analyst'),
('1N171B','Geospatial Intelligence Craftsman, Targeteer'),
('1N191','Geospatial Intelligence Superintendent'),
('20131','Target Intelligence Specialist'),
('20151','Target Intelligence Specialist'),
('20171','Target Intelligence Specialist'),
('20600','Intelligence Operations & Exploitation Manager'),
('20630','Imagery Interpreter Specialist'),
('20631','Target Intelligence Specialist'),
('20650','Imagery Interpreter Specialist'),
('20651','Target Intelligence Specialist'),
('20670','Imagery Interpreter Specialist'),
('20671','Target Intelligence Specialist'),
('20690','Imagery Interpreter Superintendent'),
('20699','Intelligence Exploitation Superintendent'),
('0241','Imagery Analysis Specialist'),
('0293','Imagery Interpretation Chief'),
('001399','Strike Warfare Intelligence Analyst'),
('001409','Imagery Intelligence Analyst'),
('002685','Expeditionary Warfare Intelligence Analyst'),
('3901','Satellite Sensor Interpreter'),
('3905','Shipboard Intelligence Analyst'),
('3910','Imagery Intelligence Analyst'),
('3911','Tactical Reconnaissance Support'),
('3921','Operational Intelligence and Intelligence Support Afloat'),
('3922','Navy Tactical Command System-Afloat (NTCS-A) IDB Analyst'),
('3923','Strike Warfare Intelligence Analyst'),
('3924','Operational Intelligence (OPINTEL) Analyst'),
('3925','Digital Imagery Workstation Suite Afloat (DIWSA) Operator/Analyst'),
('3926','Afloat Imagery Manager'),
('IS','Intelligence Specialist'),
('35F','Intelligence Analyst'),
('35X','Intelligence Senior Sergeant/Chief Intelligence Sergeant'),
('37F','Psychological Operations Specialist'),
('71S','Attache Specialist'),
('96B','Intelligence Analyst'),
('96F','Psychological Operations Specialist'),
('96R','Ground Surveillance Systems Operator'),
('96Z','Intelligence Senior Sergeant'),
('411','Intelligenceman'),
('IS','Intelligence Specialist'),
('124300','Operational Intelligence'),
('1N031','Operations Intelligence Apprentice'),
('1N051','Operations Intelligence Journeyman'),
('1N071','Operations Intelligence Craftsman'),
('1N090','Intelligence Operations And Targeting'),
('1N091','Operations Intelligence Superintendent'),
('1N431A','Fusion Analyst Apprentice, Digital Network Analyst'),
('1N431B','Fusion Analyst Apprentice, Analysis and Production'),
('1N451A','Fusion Analyst Journeyman, Digital Network Analyst'),
('1N451B','Fusion Analyst Journeyman, Analysis and Production'),
('1N471A','Fusion Analyst Craftsman, Digital Network Analyst'),
('1N471B','Fusion Analyst Craftsman, Analysis and Production'),
('20130','Intelligence Operations Specialist'),
('20150','Intelligence Operations Specialist'),
('20170','Intelligence Operations Specialist'),
('20199','Intelligence Operations & Targeting Superintendent'),
('20400','Intelligence Operations Manager'),
('20430','Intelligence Operations Specialist'),
('20450','Intelligence Operations Specialist'),
('20470','Intelligence Operations Specialist'),
('0231','Intelligence Specialist'),
('0239','Intelligence Assistant'),
('0277','Weapons and Tactics Instructor (WTI) Intelligence Marine'),
('0282','Tactical Debriefer'),
('0287','Military Source Operations Specialist (MSOS)'),
('0289','Strategic Debriefing Specialist (SDS)'),
('0291','Intelligence Chief'),
('0293','Advanced Military Source Operations Specialist (AMOS)'),
('0513','Civil Affairs Noncommissioned Officer'),
('0521','Military Information Support Operations (MISO) Non-Commissioned Officer'),
('0571','Foreign Security Force Advisor'),
('0577','Operations and Tactics Instructor'),
('8431','Psychological Operations Non-Commissioned Officer'),
('8441','Civil Affairs Non-Commissioned Officer'),
('9817','Remote Receiving Station (RRS) Operator'),
('001404','Operational Intelligence Analyst'),
('1705','East Asia Area Specialist'),
('2505','Naval Intelligence Clerk'),
('3902','Carrier Based Strike Warfare Opintel Analyst'),
('3903','Ocean Surveillance Information System (OSIS) Analyst'),
('3904','Amphibious Warfare Operational Intelligence Analyst'),
('3912','Expeditionary Warfare Intelligence Analyst'),
('3920','Operational Intelligence Analyst'),
('3927','Advanced Strike and Tomahawk Land Attack Missile (TLAM) Mensuration Analyst'),
('90IM','GWOT IA/ILO Intelligence Support, Not Deployed'),
('90IN','GWOT IA/ILO Intelligence Support'),
('35L','Counter Intelligence Agent'),
('35Y','Chief Counterintelligence/Human Intelligence Sergeant'),
('97B','Counterintelligence Agent'),
('97C','Area Intelligence Specialist'),
('97D','Military Intelligence Coordinator'),
('97Z','Counterintelligence/Human Intelligence, Senior Sergeant'),
('124400','Counterintelligence'),
('0211','Counterintelligence/Human Intelligence (CI/HUMINT) Specialist'),
('0212','Technical Surveillance Countermeasures (TSCM) Specialist'),
('0283','Advanced Foreign Counterintelligence Specialist (AFCS)'),
('0292','Counterintelligence Chief'),
('3913','Navy Tactical Counter-Intelligence and Human Intelligence (CI/HUMINT) Specialist'),
('125','Combat Operations Control'),
('11D','Armor Reconnaissance Specialist'),
('13C','Tactical Automated Fire Control Systems Specialist'),
('13D','Field Artillery Automated Tactical Data System Specialist'),
('13E','Cannon Fire Direction Specialist'),
('13F','Fire Support Specialist'),
('13T','Remotely Piloted Vehicle Crewmember'),
('13W','Field Artillery Target Acquisition Senior Sergeant'),
('16H','Air Defense Artillery Operations & Intelligence Assistant'),
('17C','Field Artillery Target Acquisition Specialist'),
('19D','Cavalry Scout'),
('93B','Aeroscout Observer'),
('205','Operations Specialists'),
('OS','Operations Specialist'),
('125000','Combat Operations Control, General'),
('1C200','Combat Control Manager'),
('1C231','Combat Control Apprentice'),
('1C251','Combat Control Journeyman'),
('1C271','Combat Control Craftsman'),
('1C291','Combat Control Superintendent'),
('1C300','Command Post Manager'),
('1C331','Command Post Apprentice'),
('1C351','Command Post Journeyman'),
('1C371','Command Post Craftsman'),
('1C391','Command Post Superintendent'),
('1C400','Tactical Air Control Party (TACP) Manager'),
('1C431','Tactical Air Control Party (TACP) Apprentice'),
('1C451','Tactical Air Control Party (TACP) Journeyman'),
('1C471','Tactical Air Control Party (TACP) Craftsman'),
('1C491','Tactical Air Control Party (TACP) Superintendent'),
('27300','Combat Control Manager'),
('27330','Combat Control Operator'),
('27350','Combat Control Operator'),
('27370','Combat Control Operator'),
('27390','Combat Control Superintendent'),
('27400','Command & Control Manager'),
('27430','Command & Control Specialist'),
('27450','Command & Control Specialist')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 13...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('27470','Command & Control Specialist'),
('27490','Command and Control Superintendent'),
('27500','Tactical Air Command & Control Manager'),
('27530','Tactical Air Command & Control Specialist'),
('27550','Tactical Air Command & Control Specialist'),
('27570','Tactical Air Command & Control Specialist'),
('27590','Tactical Air Command and Control Superintendent'),
('99608','Alert Facility Controller'),
('0861','Fire Support Man'),
('0893','Field Artillery Operations Chief'),
('8711','Ground Operations Specialist'),
('1321','Combat Systems Senior Enlisted'),
('5304','Joint Terminal Attack Controller (JTAC)'),
('5305','Joint Terminal Attack Controller Instructor (JTAC-I)'),
('9568','Joint Terminal Attack Controller (JTAC)'),
('9569','Joint Terminal Attack Controller Instructor (JTAC-I)'),
('126','Communications Center Operations'),
('25D','Telecommunications Operator-Maintainer'),
('25F','Network Switching Systems Operator-Maintainer'),
('25N','Nodal Network Systems Operator-Maintainer'),
('25W','Telecommunications Operations Chief'),
('25X','Chief Signal NCO'),
('31D','MSE Transmission System Operator'),
('31F','Network Switching Systems Operator-Maintainer'),
('31N','Communications Systems/Circuit Controller'),
('31W','Telecommunications Operations Chief'),
('31Y','Telecommunications Systems Supervisor'),
('31Z','Senior Signal Sergeant'),
('72B','Communications Center Specialist'),
('72C','Central Office Switchboard Operator'),
('72D','Cryptographic Center Specialist'),
('72E','Tactical Telecommunications Center Operator'),
('72F','Data Communications Center Specialist'),
('72G','Automatic Data Telecommunications Operator'),
('72H','Central Office Operations Operator'),
('74C','Telecommunications Operator-Maintainer'),
('74C','Data Analysis Specialist'),
('74C','Record Telecommunications Operator-Maintainer'),
('370','Telecommunications Specialist'),
('375','Telecommunications Watchstander'),
('IT','Information System Technician'),
('126000','Communications Center Operations, General'),
('29100','Telecommunications Operations Manager'),
('29130','Telecommunications Operations Specialist'),
('29150','Telecommunications Operations Specialist'),
('29170','Telecommunications Operations Specialist'),
('29500','Automatic Digital Switching Manager'),
('29530','Automatic Digital Switching Specialist'),
('29550','Automatic Digital Switching Specialist'),
('29570','Automatic Digital Switching Specialist'),
('0382','Telephone Operating'),
('0385','Teletypist'),
('0388','Cryptographic Equipment Operation'),
('0390','Telecommunications Processing'),
('0392','General Telecommunications'),
('0382','Telephone Operator'),
('0390','Telecommunications Equipment Operator'),
('0392','Telecommunications Technician'),
('0647','PLRS Master Station Operator'),
('0651','Cyber Network Operator'),
('0653','Defense Message System (DMS) Specialist'),
('2539','PLRS Master Station Operator'),
('2542','Defense Message System (DMS) Specialist'),
('2549','Defense Message System (DMS) Chief'),
('2585','PLRS Master Station Operator'),
('2350','NAVMACS(V)5 Ship System Operator'),
('2354','FLTSATCOM (SSIXS-OPCONCEN) Operator'),
('2355','FLTSATCOM (CUDIXS) NAVCOMMSTA Operator'),
('2361','SATCOM Operator (MSC-46, TSC-54, FSC-78, FSC-79, & DCSS)'),
('2363','Strategic SHF SATCOM Systems/DSCS Operator'),
('2370','RIXT/Standard Remote Terminal (SRT) Operator'),
('2371','LDMX or NAVCOMPARS Message Center Specialist'),
('2372','LDMX or NAVCOMPARS Computer Center Specialist'),
('9152','Communications Satellite (COMSAT) Operator'),
('9153','Communications Satellite Analyst'),
('9178','NEWSDEALER Communications Operator'),
('9179','NEWSDEALER Managers Course'),
('9180','Tactical Communications Systems Operation and Management Technician'),
('9181','Communications Technical Controller'),
('9182','Automated Telecommunications Systems Technician'),
('9183','StreamLiner Communications Operator'),
('9184','Cryptologic Technicians (Communications)'),
('9185','Fleet Integrated Cryptologic Communications Systems'),
('9186','CryptoLogic Technical Control Operator'),
('9187','Cryptologic Communications System Specialist'),
('9188','Navy Integrated Cryptologic Communications Systems Specialist'),
('9285','HPW Fundamentals Technician'),
('CTO','Cryptologic Technician Communications'),
('13','Health Care Specialists'),
('9730','Medical and Dental Specialists'),
('130','Medical Care'),
('68N','Cardiovascular Specialist'),
('68U','Ear, Nose, and Throat (ENT) Specialist'),
('68W','Health Care Specialist'),
('68Z','Chief Medical NCO'),
('91A','Medical Specialist'),
('91N','Cardiac Specialist'),
('91W','Health Care Specialist'),
('91Z','Medical Senior Sergeant'),
('91Z','Chief Medical NCO'),
('870','Health Services Technician'),
('891','Hospitalman'),
('HS','Health Services Technician'),
('130000','Medical Care and Treatment, General'),
('4N000','Aerospace Medical Service Manager'),
('4N031','Aerospace Medical Service Apprentice'),
('4N031A','Aerospace Medical Service Apprentice, Allergy/immunology'),
('4N031B','Aerospace Medical Service Apprentice, Neurodiagnostic Medical Technician'),
('4N051','Aerospace Medical Service Journeyman'),
('4N051A','Aerospace Medical Service Journeyman, Allergy/immunology'),
('4N051B','Aerospace Medical Service Journeyman, Neurodiagnostic Medical Technician'),
('4N051F','Aerospace Medical Service Journeyman, Flight and Operational Medical Technician'),
('4N071','Aerospace Medical Service Craftsman'),
('4N071B','Aerospace Medical Service Craftsman, Neurodiagnostic Medical Technician'),
('4N071F','Aerospace Medical Service Craftsman, Flight and Operational Medical Technician'),
('4N090','Medical Service Superintendent'),
('4N091','Aerospace Medical Service Superintendent'),
('90200','Medical Service Manager'),
('90230','Medical Service Specialist'),
('90230A','Medical Service Specialist, Allergy and Immunology'),
('90230B','Medical Service Specialist, Neurology'),
('90231','Cardiopulmonary Laboratory Specialist'),
('90250','Medical Service Specialist'),
('90250A','Medical Service Specialist, Allergy and Immunology'),
('90250B','Medical Service Specialist, Neurology'),
('90251','Cardiopulmonary Laboratory Specialist'),
('90270','Medical Service Specialist'),
('90270A','Medical Service Specialist, Allergy and Immunology'),
('90270B','Medical Service Specialist, Neurology'),
('90271','Cardiopulmonary Laboratory Specialist'),
('90299','Medical Service Superintendent'),
('90430','Cardiopulmonary Laboratory Specialist'),
('90450','Cardiopulmonary Laboratory Specialist'),
('90470','Cardiopulmonary Laboratory Specialist'),
('90490','Cardiopulmonary Laboratory Superintendent'),
('91230','Ophthalmology Surgical Specialist'),
('91231','Otorhinolaryngology Surgical Specialist'),
('91232','Urology Surgical Specialist'),
('91234','Allergy/Immunology Specialist'),
('91250','Ophthalmology Surgical Specialist'),
('91251','Otorhinolaryngology Surgical Specialist'),
('91252','Urology Surgical Specialist'),
('91254','Allergy/Immunology Specialist'),
('91270','Ophthalmology Surgical Specialist'),
('91271','Otorhinolaryngology Surgical Specialist'),
('91272','Urology Surgical Specialist'),
('91274','Allergy/Immunology Specialist'),
('91600','Cardiopulmonary Laboratory Manager'),
('91630','Cardiopulmonary Laboratory Specialist'),
('91650','Cardiopulmonary Laboratory Specialist'),
('91670','Cardiopulmonary Laboratory Specialist'),
('91700','Physician Senior Assistant'),
('91730','Physician Assistant'),
('91750','Physician Assistant'),
('91770','Physician Assistant'),
('0621','Nursing Assistant'),
('0640','Health Aid and Technician'),
('0699','Medical and Health Student Trainee'),
('9893','Orderly'),
('0621','Nursing Assistant'),
('0640','Health Technician'),
('0699','Medical and Health Student Trainee'),
('001255','Hospital Corpsman'),
('001260','Field Medical Service Technician'),
('001354','Cardiovascular Technician'),
('001394','Urology Technician'),
('003358','Hospitalman'),
('003455','Electroneurodiagnostic Technician'),
('003700','Aerospace Medical Technician'),
('00DT','Dental Tracking NEC'),
('8294','Search & Rescue Medical Technician'),
('8405','Paramedic'),
('8408','Cardiovascular Technician'),
('8422','Physician''s Assistant Trainee'),
('8426','Advanced Care Technician (ACT)'),
('8454','Electroneurodiagnostic Technologist'),
('8472','Biomedical Photography Technician'),
('8491','Special Operations Independent Duty Corpsman'),
('8492','Special Operations Technician'),
('8495','Dermatology Technician'),
('HA','Hospital Apprentice'),
('HM','Hospital Corpsman'),
('HN','Hospitalman'),
('HR','Hospitalman Recruit'),
('68D','Operating Room Specialist'),
('91D','Operating Room Specialist'),
('91U','Ear, Nose, & Throat (ENT) Specialist'),
('130100','Operating Room Services'),
('4N131','Surgical Service Apprentice'),
('4N131B','Surgical Service Apprentice, Urology'),
('4N131D','Surgical Service Apprentice, Otolaryngology'),
('4N151','Surgical Service Journeyman'),
('4N151B','Surgical Service Journeyman, Urology'),
('4N151D','Surgical Service Journeyman, Otolaryngology'),
('4N171','Surgical Service Craftsman'),
('4N171B','Surgical Service Craftsman, Urology'),
('4N171D','Surgical Service Craftsman, Otolaryngology'),
('4N191','Surgical Service Superintendent'),
('90232','Surgical Service Specialist'),
('90232B','Surgical Service Specialist, Urology'),
('90232C','Surgical Service Specialist, Orthopedics'),
('90232D','Surgical Service Specialist, Otorhinolaryngology'),
('90252','Surgical Service Specialist'),
('90252B','Surgical Service Specialist, Urology'),
('90252C','Surgical Service Specialist, Orthopedics'),
('90252D','Surgical Service Specialist, Otorhinolaryngology'),
('90272','Surgical Service Specialist'),
('90272B','Surgical Service Specialist, Urology'),
('90272C','Surgical Service Specialist, Orthopedics'),
('90272D','Surgical Service Specialist, Otorhinolaryngology'),
('90292','Medical Service Superintendent'),
('P2','Ear, Nose, and Throat Specialist'),
('001372','Surgical Technologist'),
('8433','Transplantation Technician'),
('8446','Otolaryngology Technician'),
('8483','Sugical Technologist'),
('8486','Urology Technician'),
('8783','Dental Surgical Technologist'),
('68X','Behavioral Health Specialist'),
('91F','Psychiatric Specialist'),
('91G','Behavioral Science Specialist'),
('91X','Mental Health Specialist'),
('130200','Behavioral Sciences/Mental Health Services'),
('4C000','Mental Health Service Manager'),
('4C031','Mental Health Service Apprentice'),
('4C051','Mental Health Service Journeyman'),
('4C071','Mental Health Service Craftsman'),
('4C091','Mental Health Service Superintendent'),
('90932','Neurology Specialist'),
('90952','Neurology Specialist'),
('90972','Neurology Specialist'),
('91400','Mental Health Service Manager'),
('91430','Mental Health Clinic Specialist'),
('91431','Mental Health Unit Specialist'),
('91450','Mental Health Clinic Specialist'),
('91451','Mental Health Unit Specialist'),
('91470','Mental Health Clinic Specialist'),
('91471','Mental Health Unit Specialist'),
('91490','Mental Health Service Superintendent'),
('91491','Mental Health Service Superintendent'),
('91499','Mental Health Service Superintendent'),
('001387','Psychiatry Technician'),
('8485','Psychiatry Technician'),
('68F','Physical Therapy Specialist'),
('68L','Occupational Therapy Specialist'),
('91J','Physical Therapy Specialist'),
('91K','Physical Reconditioning Specialist'),
('91L','Occupational Therapy Specialist'),
('130300','Physical/Occupational Therapy Services'),
('4J000','Physical Medicine Manager'),
('4J031','Occupational Therapy Apprentice'),
('4J032','Physical Medicine Apprentice'),
('4J032A','Physical Medicine Apprentice, Orthotic'),
('4J051','Occupational Therapy Journeyman'),
('4J052','Physical Medicine Journeyman'),
('4J052A','Physical Medicine Journeyman, Orthotic'),
('4J071','Occupational Therapy Craftsman'),
('4J072','Physical Medicine Craftsman'),
('4J072A','Physical Medicine Craftsman, Orthotic'),
('4J090','Physical Medicine Superintendent'),
('4J091','Occupational Therapy Superintendent'),
('4J092','Physical Therapy Superintendent'),
('91300','Biomedical Therapy Manager'),
('91330','Physical Therapy Specialist'),
('91331','Occupational Therapy Specialist'),
('91350','Physical Therapy Specialist'),
('91351','Occupational Therapy Specialist'),
('91370','Physical Therapy Specialist'),
('91371','Occupational Therapy Specialist'),
('91399','Biomedical Therapy Superintendent'),
('0636','Rehabilitation Therapy Assistant'),
('N3','Occupational Therapy'),
('N9','Physical Therapy Specialty'),
('0636','Rehabilitation Therapy Technician'),
('001344','Physical Therapy Technician'),
('003055','Occupational Therapy Assistant'),
('8466','Physical Therapy Technician'),
('8467','Occupational Therapy Assistant'),
('42C','Orthotic Specialist'),
('68B','Orthopedic Specialist'),
('91H','Orthopedic Specialist'),
('130400','Orthopedic Services'),
('4N131C','Surgical Service Apprentice, Orthopedics'),
('4N151C','Surgical Service Journeyman, Orthopedics'),
('4N171C','Surgical Service Craftsman, Orthopedics'),
('4U000','Orthotic Manager'),
('4U031','Orthotic Apprentice'),
('4U051','Orthotic Journeyman'),
('4U071','Orthotic Craftsman'),
('4U091','Orthotic Superintendent'),
('91233','Orthopedic Clinic Specialist'),
('91253','Orthopedic Clinic Specialist'),
('91273','Orthopedic Clinic Specialist'),
('91332','Orthotic Specialist'),
('91352','Orthotic Specialist'),
('91372','Orthotic Specialist'),
('91392','Physical Medicine Superintendent'),
('91900','Orthotic Manager'),
('91930','Orthotic Specialist'),
('91950','Orthotic Specialist'),
('91970','Orthotic Specialist'),
('91990','Orthotic Superintendent'),
('0664','Restoration Technician'),
('0667','Orthotist and Prosthetist'),
('0672','Prosthetic Representative'),
('P1','Orthopedic Specialist'),
('0664','Restoration Technician'),
('0667','Orthotics and Prosthetics Technician'),
('001265','Orthopedic Cast Room Technician'),
('8489','Orthopedic Cast Room Technician'),
('130500','Undersea/Aviation Medicine'),
('4F000','Aeromedical Manager'),
('4F031','Aeromedical Apprentice'),
('4F051','Aeromedical Journeyman'),
('4F071','Aeromedical Craftsman'),
('4F091','Aeromedical Superintendent'),
('90100','Aeromedical Manager'),
('90130','Aeromedical Specialist'),
('90150','Aeromedical Specialist'),
('90170','Aeromedical Specialist'),
('90190','Aeromedical Superintendent'),
('90230C','Medical Service Specialist, Aeromedical'),
('90250C','Medical Service Specialist, Aeromedical'),
('90270C','Medical Service Specialist, Aeromedical'),
('003020','Medical Deep Sea Diving Technician'),
('003501','Search and Rescue Medical Technician'),
('8401','Search and Rescue Medical Technician'),
('8406','Aerospace Medical Technician'),
('8493','Medical Deep Sea Diving Technician'),
('68C','Practical Nursing Specialist'),
('91C','Practical Nurse'),
('130600','Licensed Practical Nurse'),
('M6','Practical Nurse'),
('68V','Respiratory Specialist'),
('91V','Respiratory Specialist'),
('130700','Respiratory Therapy Services'),
('4H000','Cardiopulmonary Laboratory Manager'),
('4H031','Cardiopulmonary Laboratory Apprentice'),
('4H051','Cardiopulmonary Laboratory Journeyman'),
('4H071','Cardiopulmonary Laboratory Craftsman'),
('4H091','Cardiopulmonary Laboratory Superintendent'),
('0651','Respiratory Therapist'),
('0651','Respiratory Therapy Technician'),
('003155','Respiratory Therapy Technician'),
('8541','Respiratory Therapy Technician'),
('130800','Expeditionary Medical Services'),
('8404','Field Medical Service Technician'),
('8427','Fleet Marine Force Reconnaissance Corpsman'),
('8707','Field Service Dental Technician'),
('130900','Independent Duty Hospital Services'),
('4N051C','Aerospace Medical Service Journeyman, Independent Duty Medical Technician'),
('4N071C','Aerospace Medical Service Craftsman, Independent Duty Medical Technician'),
('001247','Deep Sea Diving Independent Duty Corpsman'),
('001289','Fleet Marine Force Reconnaissance Corpsman'),
('001317','Fleet Marine Force Reconnaissance Independent Duty Corpsman'),
('001327','Submarine Force Independent Duty Corpsman'),
('001349','Surface Force Independent Duty Corpsman'),
('8402','Submarine Force Independent Duty Corpsman'),
('8403','Fleet Marine Force Reconnaissance Independent Duty Corpsman'),
('8425','Surface Force Independent Duty Corpsman'),
('8494','Deep Sea Diving Independent Duty Corpsman'),
('131','Ancillary Medical Support'),
('01H','Biological Sciences Assistant'),
('68K','Medical Laboratory Specialist'),
('91B','Medical Specialist'),
('91K','Medical Laboratory Specialist'),
('91M','Electroencepthalography Specialist'),
('92B','Medical Laboratory Specialist'),
('92E','Cytology Specialist'),
('131100','Biomedical Laboratory Services'),
('4T000','Medical Laboratory Manager'),
('4T031','Medical Laboratory Apprentice'),
('4T032','Histopathology Apprentice'),
('4T033','Cytotechnology Apprentice'),
('4T051','Medical Laboratory Journeyman'),
('4T052','Histopathology Journeyman'),
('4T053','Cytotechnology Journeyman'),
('4T071','Medical Laboratory Craftsman'),
('4T072','Histopathology Craftsman'),
('4T073','Cytotechnology Craftsman'),
('4T090','Medical Laboratory Superintendent'),
('90400','Medical Laboratory Manager'),
('90431','Histopathology Specialist'),
('90432','Cytotechnology Specialist'),
('90451','Histopathology Specialist'),
('90452','Cytotechnology Specialist'),
('90471','Histopathology Specialist'),
('90472','Cytotechnology Specialist'),
('90491','Medical Laboratory Superintendent'),
('90492','Cytotechnology Superintendent'),
('90499','Medical Laboratory Superintendent'),
('90900','Special Laboratory Manager'),
('90930','Nuclear Medicine Specialist'),
('90950','Nuclear Medicine Specialist'),
('90970','Nuclear Medicine Specialist'),
('90999','Special Laboratory Superintendent'),
('92400','Medical Laboratory Manager'),
('92430','Medical Laboratory Specialist'),
('92431','Histopathology Specialist'),
('92450','Medical Laboratory Specialist'),
('92451','Histopathology Specialist'),
('92470','Medical Laboratory Specialist'),
('92471','Histopathology Specialist'),
('92499','Medical Laboratory Superintendent'),
('92530','Cytotechnology Specialist'),
('92550','Cytotechnology Specialist'),
('92570','Cytotechnology Specialist'),
('0625','Autopsy Assistant'),
('0645','Medical Technician'),
('0646','Pathology Technician'),
('0650','Medical Technical Assistant'),
('0625','Autopsy Technician'),
('0645','Medical Technician'),
('0646','Cytology, Histopathology, and Pathology Technician'),
('001339','Hemodialysis/Apheresis Technician'),
('001359','Histopathology Technician'),
('001377','Cytotechnologist'),
('001382','Medical Laboratory Technician'),
('8434','Hemodialysis Technician'),
('8496','Mortician'),
('8501','Basic Laboratory Technician'),
('8503','Histopathology Technician'),
('8505','Cytotechnologist'),
('8506','Medical Laboratory Technician, Advanced'),
('68Q','Pharmacy Specialist'),
('91Q','Pharmacy Specialist'),
('131200','Pharmacy'),
('4P000','Pharmacy Manager'),
('4P031','Pharmacy Apprentice'),
('4P051','Pharmacy Journeyman'),
('4P071','Pharmacy Craftsman'),
('4P091','Pharmacy Superintendent'),
('90500','Pharmacy Manager'),
('90530','Pharmacy Specialist'),
('90550','Pharmacy Specialist'),
('90570','Pharmacy Specialist'),
('90590','Pharmacy Superintendent'),
('0661','Pharmacy Technician'),
('0661','Pharmacy Technician'),
('001322','Pharmacy Technician'),
('8482','Pharmacy Technician'),
('68P','Radiology Specialist'),
('91P','Radiology Specialist'),
('91W','Nuclear Medicine Specialist'),
('131300','Radiology'),
('4R000','Diagnostic Imaging Manager'),
('4R031','Diagnostic Imaging Apprentice'),
('4R031A','Diagnostic Imaging Apprentice, Nuclear Medicine'),
('4R031B','Diagnostic Imaging Apprentice, Ultrasound'),
('4R031C','Diagnostic Imaging Apprentice, Magnetic Resonance Imaging'),
('4R032','Nuclear Medicine'),
('4R051','Diagnostic Imaging Journeyman'),
('4R051A','Diagnostic Imaging Journeyman, Nuclear Medicine'),
('4R051B','Diagnostic Imaging Journeyman, Ultrasound'),
('4R051C','Diagnostic Imaging Journeyman, Magnetic Resonance Imaging'),
('4R071','Diagnostic Imaging Craftsman'),
('4R071A','Diagnostic Imaging Craftsman, Nuclear Medicine'),
('4R071B','Diagnostic Imaging Craftsman, Ultrasound'),
('4R071C','Diagnostic Imaging Craftsman, Magnetic Resonance Imaging'),
('4R072','Nuclear Medicine'),
('4R090','Diagnostic Imaging Superintendent'),
('90300','Radiologic Manager'),
('90330','Radiologic Specialist'),
('90331','Nuclear Medicine Technician'),
('90350','Radiologic Specialist'),
('90351','Nuclear Medicine Technician'),
('90370','Radiologic Specialist'),
('90371','Nuclear Medicine Technician'),
('90399','Radiologic Superintendent'),
('0642','Nuclear Medicine Technician'),
('0647','Diagnostic Radiologic Technologist'),
('0648','Therapeutic Radiologic Technologist'),
('M5','Nuclear Medicine Specialist'),
('0642','Nuclear Medicine Technician'),
('0647','Diagnostic Radiologic Technician'),
('0648','Therapeutic Radiologic Technician'),
('003355','Nuclear Medicine Technician'),
('003652','Advanced X-Ray Technician'),
('8416','Nuclear Medicine Technologist'),
('8447','Ultrasound Technologist'),
('8450','Mammography Technologist'),
('8451','Basic X-Ray Technician'),
('8452','Advanced X-Ray Technician'),
('132','Biomedical Sciences and Allied Health'),
('68R','Veterinary Food Inspection Specialist'),
('68T','Animal Care Specialist'),
('91R','Veterinary Food Inspection Specialist'),
('91T','Animal Care Specialist'),
('132100','Veterinary Medicine'),
('90831','Animal Specialist'),
('90851','Animal Specialist'),
('90871','Animal Specialist'),
('0704','Animal Health Technician'),
('1863','Food Inspection'),
('0704','Animal Health Technician'),
('1863','Food Inspector'),
('3373','Veterinary Technician'),
('5349','Marine Mammal Veterinary Technician'),
('68S','Preventive Medicine Specialist'),
('91S','Preventive Medicine Specialist'),
('91X','Health Physics Specialist'),
('132200','Environmental Health/Preventive Medicine Services'),
('4E000','Public Health Manager'),
('4E031','Public Health Apprentice'),
('4E051','Public Health Journeyman'),
('4E071','Public Health Craftsman'),
('4E091','Public Health Superintendent'),
('90700','Bioenvironmental Engineering Manager'),
('90730','Bioenvironmental Engineering Specialist'),
('90750','Bioenvironmental Engineering Specialist'),
('90770','Bioenvironmental Engineering Specialist'),
('90790','Bioenvironmental Engineering Superintendent'),
('90800','Public Health Manager'),
('90830','Public Health Specialist'),
('90850','Public Health Specialist'),
('90870','Public Health Specialist'),
('90890','Public Health Superintendent'),
('0698','Environmental Health Technician'),
('1860','Public Health Inspection'),
('1864','Public Health Quarantine Inspection'),
('6913','Hazardous Waste Disposing'),
('0698','Environmental Health Technician'),
('001367','Preventive Medicine Technician'),
('8407','Radiation Health Technician'),
('8432','Preventive Medicine Technician'),
('42E','Optical Laboratory Specialist'),
('68H','Optical Laboratory Specialist'),
('68Y','Eye Specialist'),
('91H','Optical Laboratory Specialist'),
('91Y','Eye Specialist'),
('132300','Ophthalmology/Optometry'),
('4V000','Optometry Manager'),
('4V031','Optometry Apprentice'),
('4V031A','Optometry Apprentice, Ophthalmology'),
('4V031S','Optometry Apprentice, Ophthalmology'),
('4V051','Optometry Journeyman'),
('4V051A','Optometry Journeyman, Ophthalmology'),
('4V051S','Optometry Journeyman, Ophthalmology'),
('4V071','Optometry Craftsman'),
('4V071A','Optometry Craftsman, Ophthalmology'),
('4V071S','Optometry Craftsman, Ophthalmology'),
('4V090','Ophthalmic Superintendent'),
('4V091','Optometry Superintendent'),
('91200','Optometry Manager'),
('91235','Optometry Specialist'),
('91235A','Optometry Specialist, Ophthalmology'),
('91255','Optometry Specialist'),
('91255A','Optometry Specialist, Ophthalmology'),
('91275','Optometry Specialist'),
('91275A','Optometry Specialist, Ophthalmology'),
('91299','Optometry Superintendent'),
('P3','Eye Specialist'),
('001304','Optician'),
('8437','Opthalmic Surgical Technician'),
('8444','Ocular Technician'),
('8445','Ocular Technician'),
('8463','Optician'),
('132400','Physiology'),
('4M000','Aerospace and Operational Physiology Manager'),
('4M031','Aerospace and Operational Physiology Apprentice'),
('4M051','Aerospace and Operational Physiology Journeyman'),
('4M071','Aerospace and Operational Physiology Craftsman'),
('4M091','Aerospace and Operational Physiology Superintendent'),
('91100','Aerospace Physiology Manager'),
('91130','Aerospace Physiology Specialist'),
('91150','Aerospace Physiology Specialist'),
('91170','Aerospace Physiology Specialist'),
('91190','Aerospace Physiology Manager Superintendent'),
('N4','Health Physics Specialist'),
('003462','Aerospace Physiology Technician'),
('8409','Aerospace Physiology Technician'),
('68M','Nutrition Care Specialist'),
('91M','Nutrition Care Specialist'),
('94F','Hospital Food Service Specialist'),
('132500','Diet Therapy'),
('4D000','Diet Therapy Manager'),
('4D031','Diet Therapy Apprentice'),
('4D051','Diet Therapy Journeyman'),
('4D071','Diet Therapy Craftsman'),
('4D091','Diet Therapy Superintendent'),
('92600','Diet Therapy Manager'),
('92630','Diet Therapy Specialist'),
('92650','Diet Therapy Specialist'),
('92670','Diet Therapy Specialist'),
('92690','Diet Therapy Superintendent'),
('35G','Medical Equipment Repairer, Unit Level'),
('35U','Medical Equipment Repairer, Advanced'),
('68A','Biomedical Equipment Specialist'),
('91A','Medical Equipment Repairer'),
('132600','Biomedical Equipment Maintenance and Repair Services'),
('4A200','Biomedical Equipment Manager'),
('4A231','Biomedical Equipment Apprentice'),
('4A251','Biomedical Equipment Journeyman'),
('4A271','Biomedical Equipment Craftsman'),
('4A291','Biomedical Equipment Superintendent'),
('91800','Biomedical Equipment Manager'),
('91830','Biomedical Equipment Specialist'),
('91850','Biomedical Equipment Specialist'),
('91870','Biomedical Equipment Specialist'),
('91890','Biomedical Equipment Superintendent'),
('0649','Medical Instrument Technician'),
('0649','Medical Instrument Technician'),
('001312','Biomedical Equipment Technician'),
('8410','Bio-Medical Equipment Technician'),
('8477','Biomedical Equipment Technician, Basic'),
('8478','Advanced Biomedical Equipment Technician'),
('8479','Basic Biomedical Equipment System Technician'),
('8732','Dental Equipment Repair Technician'),
('132700','Other Biomedical Science and Allied Health'),
('132800','Bioenvironmental Engineering'),
('4B000','Bioenvironmental Engineering Manager'),
('4B031','Bioenvironmental Engineering Apprentice'),
('4B051','Bioenvironmental Engineering Journeyman'),
('4B071','Bioenvironmental Engineering Craftsman'),
('4B091','Bioenvironmental Engineering Superintendent'),
('133','Dental Care'),
('68E','Dental Specialist'),
('91E','Dental Specialist'),
('890','Health Services - Dental'),
('133000','Dental Care, General'),
('4Y000','Dental Manager'),
('4Y031','Dental Assistant Apprentice'),
('4Y051','Dental Assistant Journeyman'),
('4Y071','Dental Assistant Craftsman'),
('4Y090','Dental Superintendent'),
('4Y091','Dental Assistant'),
('98100','Dental Manager'),
('98130','Dental Assistant Specialist'),
('98131','Preventive Dentistry Specialist'),
('98150','Dental Assistant Specialist'),
('98151','Preventive Dentistry Specialist'),
('98170','Dental Assistant Specialist'),
('98171','Preventive Dentistry Specialist'),
('98190','Dental Superintendent'),
('98191','Dental Superintendent'),
('98300','Dental Senior Assistant'),
('98330','Dental Assistant'),
('98350','Dental Assistant'),
('98370','Dental Assistant'),
('0681','Dental Assistant'),
('0684','Public Health Dental Hygiene'),
('0681','Dental Assistant'),
('001155','Dental Assistant'),
('002669','Advanced Dental Assistant'),
('8701','Dental Assistant'),
('8702','Advanced Dental Assistant'),
('8703','Dental Department Administrative Assistant'),
('8705','Dental Hygiene Technician'),
('8714','Dental Research Assistant'),
('DA','Dentalman Apprentice'),
('DN','Dentalman'),
('DR','Dentalman Recruit'),
('DT','Dental Technician'),
('42D','Dental Laboratory Specialist'),
('42F','Dental Fixed Prosthetic Specialist'),
('133100','Dental Laboratory'),
('4Y032','Dental Laboratory Apprentice'),
('4Y052','Dental Laboratory Journeyman'),
('4Y072','Dental Laboratory Craftsman'),
('4Y100','Dental Laboratory Manager'),
('4Y131','Dental Laboratory'),
('4Y151','Dental Laboratory'),
('4Y171','Dental Laboratory'),
('4Y191','Dental Laboratory'),
('98200','Dental Laboratory Manager'),
('98230','Dental Laboratory Specialist'),
('98250','Dental Laboratory Specialist'),
('98270','Dental Laboratory Specialist'),
('98290','Dental Laboratory Superintendent'),
('0683','Dental Laboratory Aid and Technician'),
('N5','Dental Laboratory Specialist'),
('0683','Dental Laboratory Technician'),
('002670','Dental Laboratory Technician, Advanced'),
('003301','Dental Laboratory Technician, Maxillofacial'),
('003401','Dental Laboratory Technician, Basic'),
('8752','Dental Laboratory Technician, Basic'),
('8753','Dental Laboratory Technician, Advanced'),
('8765','Dental Laboratory Technician, Maxillofacial'),
('133200','Dental Hygiene'),
('4Y051H','Dental Assistant Journeyman, Dental Hygienist'),
('4Y071H','Dental Assistant Craftsman, Dental Hygienist'),
('0682','Dental Hygiene'),
('X2','Preventive Dentistry Specialty'),
('0682','Dental Hygienist'),
('003007','Dental Hygienist'),
('8708','Dental Hygienist'),
('134','Medical Administration and Logistics'),
('68G','Patient Administration Specialist'),
('71G','Patient Administration Specialist'),
('91G','Patient Administration Specialist'),
('134000','Medical Administration'),
('4A000','Health Services Management Manager'),
('4A031','Health Services Management Apprentice'),
('4A051','Health Services Management Journeyman'),
('4A071','Health Services Management Craftsman'),
('4A091','Health Services Management Superintendent'),
('90600','Health Services Management Support Manager'),
('90630','Health Services Management Support Specialist'),
('90650','Health Services Management Support Specialist'),
('90670','Health Services Management Support Specialist'),
('90690','Health Services Management Support Superintendent'),
('91500','Medical Materiel Manager'),
('91530','Medical Materiel Specialist'),
('91550','Medical Materiel Specialist'),
('91570','Medical Materiel Specialist'),
('91590','Medical Materiel Superintendent'),
('99607','Medical Squadron Section First Sergeant'),
('0669','Medical Records Administration'),
('0675','Medical Records Technician'),
('0679','Medical Support Assistance'),
('0669','Medical Records Specialist'),
('0675','Medical Records Technician'),
('0679','Medical Support Technician'),
('8424','Medical Department Administrative Assistant'),
('68J','Medical Logistics Specialist'),
('76J','Medical Supply Specialist'),
('91J','Medical Logistics Specialist'),
('134100','Medical Logistics'),
('4A100','Medical Materiel Manager'),
('4A131','Medical Materiel Apprentice'),
('4A151','Medical Materiel Journeyman'),
('4A171','Medical Materiel Craftsman'),
('4A191','Medical Materiel Superintendent'),
('0622','Medical Supply Aide and Technician'),
('0622','Medical Supply Technician'),
('14','Other Technical and Allied Specialists'),
('9740','Other Technical and Allied Specialists'),
('140','Photography'),
('25M','Multimedia Illustrator'),
('25P','Visual Information/Audio Documentation Systems Specialist'),
('25R','Visual Information Equipment Operator-Maintainer'),
('25S','Still Documentation Specialist'),
('25V','Combat Documentation/Production Specialist'),
('25Z','Visual Information Operations Chief'),
('84B','Still Photographic Specialist'),
('84C','Motion Picture Specialist'),
('84E','Television Cameraman'),
('84F','Audio/Television Specialist'),
('84G','Photographic Laboratory Specialist'),
('340','Public Affairs Specialist'),
('PA','Public Affairs Specialist'),
('140000','Photography, General'),
('23100','Visual Information Manager'),
('23130','Visual Information Media Specialist'),
('23132','Still Photographic Specialist'),
('23133','Visual Information Production Documentation Specialist'),
('23150','Visual Information Media Specialist'),
('23152','Still Photographic Specialist'),
('23153','Visual Information Production Documentation Specialist'),
('23170','Visual Information Media Specialist'),
('23172','Still Photographic Specialist'),
('23173','Visual Information Production Documentation Specialist'),
('23192','Audiovisual Services Superintendent'),
('23199','Visual Information Services Superintendent'),
('23230','Visual Information Production-Documentation Specialist'),
('23231','Television Production Specialist'),
('23250','Visual Information Production-Documentation Specialist'),
('23251','Television Production Specialist'),
('23270','Visual Information Production-Documentation Specialist'),
('23271','Television Production Specialist'),
('23291','Audiovisual Production-Documentation Superintendent'),
('23299','Audiovisual Production-Documentation Superintendent'),
('23330','Imagery Production Specialist'),
('23331','Photoprocessing Control Specialist'),
('23350','Imagery Production Specialist'),
('23351','Photoprocessing Control Specialist'),
('23370','Imagery Production Specialist'),
('23371','Photoprocessing Control Specialist'),
('23390','Imagery Production Superintendent'),
('23391','Photoprocessing Superintendent'),
('23399','Imagery Production Superintendent'),
('3N032','Broadcast Journalist Apprentice'),
('3N034','Still Photography Apprentice'),
('3N035B','Photojournalist Apprentice, Photographer'),
('3N052','Broadcast Journalist Journeyman'),
('3N054','Still Photography Journeyman'),
('3N072','Broadcast Journalist Craftsman'),
('3N074','Still Photography Craftsman'),
('3V000','Multimedia Manager'),
('3V032','Still Photography Apprentice'),
('3V033','Video Apprentice'),
('3V052','Still Photography Journeyman'),
('3V053','Video Journeyman'),
('3V072','Still Photography Craftsman'),
('3V073','Video Craftsman'),
('3V090','Multimedia Superintendent'),
('3V131','Imagery Production'),
('3V151','Imagery Production'),
('3V171','Imagery Production'),
('3V191','Imagery Production'),
('79131','Radio & TV Broadcasting Specialist'),
('79151','Radio & TV Broadcasting Specialist'),
('79171','Radio & TV Broadcasting Specialist'),
('1060','Photography'),
('3901','Miscellaneous Motion Picture, Radio, Television, and Sound Equipment Operation'),
('3910','Motion Picture Projection'),
('3911','Sound Recording Equipment Operating'),
('3919','Television Equipment Operating'),
('3940','Broadcasting Equipment Operating'),
('3941','Public Address Equipment Operating'),
('9001','Miscellaneous Film Processing'),
('9003','Film Assembling and Repairing'),
('9004','Motion Picture Developing/Printing Machine Operating'),
('9055','Photographic Solution Mixing'),
('1060','Photographer and Videographer'),
('4631','Photographer'),
('4632','Photographic Equipment Repairman'),
('4633','Photographic Quality Control Specialist'),
('4641','Combat Photographer'),
('4642','Combat Photographic Technician'),
('4651','Television Production Specialist'),
('4671','Combat Videographer'),
('4672','Motion Picture Editor/Scriptwriter'),
('4673','Audio/Television Production Specialist'),
('4675','Photographic Laboratory Technician'),
('4681','Motion Picture Film Editor'),
('4691','Combat Camera Chief'),
('6674','Imagery Interpretation Equipment Repair Technician'),
('6675','Aviation Photographic Film Processor'),
('6679','Aviation Photographic/Electronic Systems Chief'),
('002619','Photojournalist'),
('8126','Photographic Quality Controlman'),
('8133','EH-38 Photographic Quality Control Technician'),
('8136','Underwater Photographer'),
('8143','Multimedia Cameraman'),
('8144','Multimedia Director/Producer'),
('8146','Motion Picture Script Writer'),
('8147','Photojournalist Journeyman'),
('8148','Master Photojournalist'),
('8149','Motion Picture Sound Transmission & Recording Engineer'),
('8191','Photographic Equipment Maintenance Technician'),
('8192','Photographic Equipment Maintenance Technician'),
('8193','Graphic Illustrator Apprentice'),
('8288','Aerial Cameraman'),
('PH','Photographer''s Mate'),
('141','Mapping, Surveying, Drafting, and Illustrating'),
('21U','Topographic Analyst'),
('81C','Cartographer'),
('81Q','Terrain Analyst'),
('81T','Topographic Analyst'),
('141100','Mapping'),
('22130','Photogrammetric Cartographer'),
('22150','Photogrammetric Cartographer'),
('22170','Photogrammetric Cartographer'),
('22231','Apprentice Geodetic Computations Specialist'),
('22251','Geodetic Computations Specialist'),
('22271','Geodetic Computations Technician'),
('1371','Cartographic Technician'),
('1374','Geodetic Technician'),
('1371','Cartographic Technician'),
('1374','Geodetic Technician'),
('0261','Geographic Intelligence Specialist'),
('1431','Map Compiler'),
('1432','Cartographer'),
('1453','Mapping Chief'),
('12Y','Geospatial Engineer'),
('13S','Field Artillery Surveyor'),
('13T','Field Artillery Surveyor/Meteorological Crewmember'),
('17C','Sound Ranging Crewman'),
('17D','Flash Ranging Crewman'),
('21S','Topographic Surveyor'),
('21Y','Geospatial Engineer'),
('81Z','Topographic Engineering Supervisor'),
('82A','Rodman & Tapeman'),
('82B','Construction Surveyor'),
('82C','Field Artillery Surveyor'),
('82D','Topographic Surveyor'),
('82E','Topographic Computer'),
('671','Engineering Aide'),
('673','Engineering Aide - Surveyor'),
('141200','Surveying'),
('22200','Geodetic Manager'),
('22230','Geodetic Specialist'),
('22250','Geodetic Specialist'),
('22270','Geodetic Specialist'),
('22290','Geodetic Superintendent'),
('22291','Geodetic Superintendent'),
('22299','Geodetic Superintendent'),
('3E531','Engineering Apprentice'),
('3E551','Engineering Journeyman'),
('3E571','Engineering Craftsman'),
('3E591','Engineering Superintendent'),
('55300','Engineering Manager'),
('55330','Engineering Specialist'),
('55350','Engineering Specialist'),
('55370','Engineering Specialist'),
('55390','Engineering Superintendent'),
('0817','Survey Technical'),
('0817','Surveying Technician'),
('1361','Engineer Assistant'),
('1421','Surveyor'),
('1422','Surveying & Drafting Chief'),
('1441','Construction Surveyor'),
('1442','Geodetic Surveyor'),
('5503','Advanced Engineering Aide'),
('12T','Technical Engineer'),
('21T','Technical Engineer'),
('51T','Technical Engineering Specialist'),
('81A','General Draftsman'),
('81B','Technical Drafting Specialist'),
('672','Engineering Aide - Draftsman'),
('141300','Drafting'),
('0818','Engineering Drafting'),
('1021','Office Drafting'),
('1021','Drafting Technician'),
('1411','Construction Drafter'),
('25Q','Graphics Documentation Specialist'),
('81E','Illustrator'),
('141400','Illustrating'),
('23131','Visual Information Specialist'),
('23151','Visual Information Specialist'),
('23171','Visual Information Specialist'),
('3N033','Graphic Arts Apprentice'),
('3N053','Graphic Arts Journeyman'),
('3N073','Graphic Arts Craftsman'),
('3V031','Graphic Arts Apprentice'),
('3V051','Graphic Arts Journeyman'),
('3V071','Graphic Arts Craftsman'),
('1010','Exhibits Specialist'),
('1020','Illustrating'),
('4104','Sign Painting'),
('4110','Scenery Painting'),
('4445','Bank Note Designing'),
('1010','Exhibits Specialist'),
('1020','Illustrator'),
('4611','Combat Illustrator'),
('4911','Illustrator'),
('8151','Graphic Illustrator Journeyman'),
('DM','Illustrator Draftsman'),
('142','Weather'),
('13W','Field Artillery Meteorological Crewmember'),
('93E','Meteorological Observer'),
('93F','Field Artillery Meteorological Crewmember'),
('142000','Weather, General'),
('1W000','Weather Manager'),
('1W031','Weather Apprentice'),
('1W031A','Weather Apprentice, Forecaster'),
('1W031B','Weather Apprentice, Battlefield Airman'),
('1W031C','Weather Apprentice, Advanced Battlefield Airman'),
('1W032','Special Operations Weather Apprentice'),
('1W051','Weather Journeyman'),
('1W051A','Weather Journeyman, Forecaster'),
('1W051B','Weather Journeyman, Battlefield Airman'),
('1W051C','Weather Journeyman, Advanced Battlefield Airman'),
('1W052','Special Operations Weather Journeyman'),
('1W071','Weather Craftsman'),
('1W071A','Weather Craftsman, Forecaster'),
('1W071B','Weather Craftsman, Battlefield Airman'),
('1W071C','Weather Craftsman, Advanced Battlefield Airman'),
('1W072','Special Operations Weather Craftsman'),
('1W091','Weather Superintendent'),
('1W092','Special Operations Weather Superintendent'),
('25100','Weather Manager'),
('25130','Weather Specialist'),
('25150','Weather Specialist'),
('25170','Weather Specialist'),
('25190','Weather Superintendent'),
('25231','Weather Observer'),
('25251','Weather Observer'),
('25271','Weather Observer'),
('1341','Meteorological Technician'),
('1341','Meteorological Technician'),
('0847','Field Artillery Sensor Support Man'),
('6821','Meteorology and Oceanography (METOC) Observer'),
('6822','Rawinsonde Operator')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 14...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('6831','Weather Observer/Rawinsonde Operator'),
('6842','Meteorology and Oceanography (METOC) Analyst Forecaster'),
('6852','Meteorology and Oceanography (METOC) Impacts Analyst'),
('001585','Meteorological Forecaster'),
('001640','Meteorological and Oceanographic Manager'),
('001695','Meteorological and Oceanographic Technician'),
('001750','Oceanographic Forecaster'),
('7412','Analyst-Forecaster'),
('7414','Rawin/Radiosonde Operator'),
('7416','Tactical Environmental Support System (TESS) Operator'),
('7418','Tactical Environmental Support System (TESS) Interpreteral Briefer'),
('7424','ASWEPS Technician'),
('AG','Aerographer''s Mate'),
('143','Ordnance Disposal and Diving'),
('55D','Explosive Ordnance Disposal Specialist'),
('89D','Explosive Ordnance Disposal Specialist'),
('143100','EOD/UDT'),
('3E800','Explosive Ordnance Disposal Manager'),
('3E831','Explosive Ordnance Disposal Apprentice'),
('3E851','Explosive Ordnance Disposal Journeyman'),
('3E871','Explosive Ordnance Disposal Craftsman'),
('3E891','Explosive Ordnance Disposal Superintendent'),
('46400','Explosive Ordnance Disposal Manager'),
('46430','Explosive Ordnance Disposal Specialist'),
('46450','Explosive Ordnance Disposal Specialist'),
('46470','Explosive Ordnance Disposal Specialist'),
('46490','Explosive Ordnance Superintendent'),
('6505','Munitions Destroying'),
('6517','Explosives Test Operating'),
('2336','Explosive Ordnance Disposal (EOD) Technician'),
('001172','Senior Explosive Ordnance Disposal Technician'),
('001177','Explosive Ordnance Disposal Master'),
('001792','Underwater Construction Technician'),
('002617','Basic Explosive Ordnance Disposal Technician'),
('5309','Explosive Ordnance Disposal Mobile Unit (EODMU) Apprentice'),
('5320','SO Candidate'),
('5321','Combatant Swimmer (UDT)'),
('5322','Combatant Swimmer (UDT-EOD Qualified) (Nonnuclear)'),
('5323','SDV Operator'),
('5324','SDV Pilot/Navigator (EOD Qualified) Nonnuclear)'),
('5325','DDS Operator'),
('5326','Combatant Swimmer (SEAL)'),
('5327','Combatant Swimmer (SEAL EOD Qualified) (Nonnuclear)'),
('5330','(EOD) Apprentice Diver (Student Status)'),
('5331','EOD Assistant'),
('5332','Basic EOD Technician-Reserves'),
('5333','Basic EOD Technician'),
('5334','Senior EOD Technician-Reserves'),
('5335','Senior EOD Technician'),
('5336','Master EOD Technician-Reserves'),
('5337','Master EOD Technician'),
('5338','Explosive Ordnance Disposal (EOD) Exploitation Specialist'),
('90IE','Riverine Patrol Boat Operator/Crewman'),
('90IF','Riverine Small Craft Maritime Interdiction Operations'),
('EOD','Explosive Ordnance Disposal'),
('00B','Diver'),
('12D','Diver'),
('21D','Diver'),
('143300','Divers'),
('5222','Diving'),
('001100','Second Class Diver'),
('001105','First Class Diver'),
('001110','Master Diver'),
('001605','Helicopter Warfare Specialist'),
('5301','UDT/SEAL Candidate'),
('5302','EOD Candidate'),
('5303','Second Class Diver Candidate'),
('5311','Saturation Diver'),
('5328','Very Shallow Water Mine Counter-Measure Operator (VSW MCM Operator)'),
('5339','Ordnance Clearance Diver'),
('5341','Master Diver'),
('5342','Diver First Class'),
('5343','Diver Second Class'),
('5344','Submarine SCUBA Diver'),
('5345','Scuba Diver'),
('5346','Master Saturation Diver'),
('5348','Marine Mammal Systems Operator'),
('5375','Salvage/Construction Demolition Diver'),
('5376','Saturation Demolition Diver'),
('5931','Underwater Construction Technician Advanced'),
('5932','Underwater Construction Technician Basic'),
('ND','Diver'),
('ND','Navy Diver'),
('144','Scientific and Engineering Aides'),
('144000','Scientific and Engineering Aides, General'),
('145','Musicians'),
('02A','Army Bandperson'),
('02B','Cornet or Trumpet Player'),
('02C','Euphonium Player'),
('02D','French Horn Player'),
('02E','Trombone Player'),
('02F','Tuba Player'),
('02G','Flute or Piccolo Player'),
('02H','Oboe Player'),
('02J','Clarinet Player'),
('02K','Bassoon Player'),
('02L','Saxophone Player'),
('02M','Percussion Player'),
('02N','Keyboard Player'),
('02P','Brass Group Leader'),
('02Q','Woodwind Group Leader'),
('02R','Percussion Group Leader'),
('02S','Special Bands Member'),
('02T','Guitar Player'),
('02U','Electric Bass Player'),
('02Z','Bands Senior Sergeant'),
('42R','Musician'),
('42S','Special Band Musician'),
('840','Musician'),
('145000','Musicians, General'),
('3N100','Regional Band Manager'),
('3N131A','Regional Band Apprentice, Clarinet'),
('3N131B','Regional Band Apprentice, Saxophone'),
('3N131C','Regional Band Apprentice, Bassoon'),
('3N131D','Regional Band Apprentice, Oboe'),
('3N131E','Regional Band Apprentice, Flute Or Piccolo'),
('3N131F','Regional Band Apprentice, French Horn'),
('3N131G','Regional Band Apprentice, Cornet Or Trumpet'),
('3N131H','Regional Band Apprentice, Baritone Or Euphonium'),
('3N131J','Regional Band Apprentice, Trombone'),
('3N131K','Regional Band Apprentice, Tuba'),
('3N131L','Regional Band Apprentice, Percussion'),
('3N131M','Regional Band Apprentice, Piano'),
('3N131N','Regional Band Apprentice, Guitar'),
('3N131P','Regional Band Apprentice, Music Arranger'),
('3N131Q','Regional Band Apprentice, Bagpipe'),
('3N131R','Regional Band Apprentice, Vocalist'),
('3N131S','Regional Band Apprentice, Electric Bass/String Bass'),
('3N131T','Regional Band Apprentice, Military Band Support (USAF Band)'),
('3N131U','Regional Band Apprentice, Steel Guitar'),
('3N131V','Regional Band Apprentice, Audio And Lighting Engineer'),
('3N131Z','Regional Band Apprentice, Instrumentalist, General (Air National Guard Bands)'),
('3N151A','Regional Band Journeyman, Clarinet'),
('3N151B','Regional Band Journeyman, Saxophone'),
('3N151C','Regional Band Journeyman, Bassoon'),
('3N151D','Regional Band Journeyman, Oboe'),
('3N151E','Regional Band Journeyman, Flute Or Piccolo'),
('3N151F','Regional Band Journeyman, French Horn'),
('3N151G','Regional Band Journeyman, Cornet Or Trumpet'),
('3N151H','Regional Band Journeyman, Baritone Or Euphonium'),
('3N151J','Regional Band Journeyman, Trombone'),
('3N151K','Regional Band Journeyman, Tuba'),
('3N151L','Regional Band Journeyman, Percussion'),
('3N151M','Regional Band Journeyman, Piano'),
('3N151N','Regional Band Journeyman, Guitar'),
('3N151P','Regional Band Journeyman, Music Arranger'),
('3N151Q','Regional Band Journeyman, Bagpipe'),
('3N151R','Regional Band Journeyman, Vocalist'),
('3N151S','Regional Band Journeyman, Electric Bass/String Bass'),
('3N151T','Regional Band Journeyman, Military Band Support (USAF Band)'),
('3N151U','Regional Band Journeyman, Steel Guitar'),
('3N151V','Regional Band Journeyman, Audio And Lighting Engineer'),
('3N151Z','Regional Band Journeyman, Instrumentalist, General (Air National Guard Bands)'),
('3N171A','Regional Band Craftsman, Clarinet'),
('3N171B','Regional Band Craftsman, Saxophone'),
('3N171C','Regional Band Craftsman, Bassoon'),
('3N171D','Regional Band Craftsman, Oboe'),
('3N171E','Regional Band Craftsman, Flute or Piccolo'),
('3N171F','Regional Band Craftsman, French Horn'),
('3N171G','Regional Band Craftsman, Cornet or Trumpet'),
('3N171H','Regional Band Craftsman, Baritone or Euphonium'),
('3N171J','Regional Band Craftsman, Trombone'),
('3N171K','Regional Band Craftsman, Tuba'),
('3N171L','Regional Band Craftsman, Percussion'),
('3N171M','Regional Band Craftsman, Piano'),
('3N171N','Regional Band Craftsman, Guitar'),
('3N171P','Regional Band Craftsman, Music Arranger'),
('3N171Q','Regional Band Craftsman, Bagpipe'),
('3N171R','Regional Band Craftsman, Vocalist'),
('3N171S','Regional Band Craftsman, Electric Bass/string Bass'),
('3N171T','Regional Band Craftsman, Military Band Support (USAF Band)'),
('3N171U','Regional Band Craftsman, Steel Guitar'),
('3N171V','Regional Band Craftsman, Audio And Lighting Engineer'),
('3N171Z','Regional Band Craftsman, Instrumentalist, General (Air National Guard Bands)'),
('3N190','Regional Band Superintendent'),
('3N191','Regional Band Superintendent'),
('3N200','Premier Band Manager'),
('3N231','Premier Band Apprentice'),
('3N271','Premier Band Craftsman'),
('3N291','Premier Band Superintendent'),
('87100','Band Manager'),
('87130','Instrumentalist'),
('87131','Instrumentalist'),
('87150','Instrumentalist'),
('87151','Instrumentalist'),
('87170','Instrumentalist'),
('87171','Instrumentalist'),
('87199','Band Superintendent'),
('87200','Instrumentalist Manager'),
('87230','Instrumentalist Technician'),
('87250','Instrumentalist Technician'),
('87270','Instrumentalist Technician'),
('87290','Instrumentalist Superintendent'),
('1051','Music Specialist'),
('1051','Music Specialist'),
('5511','Member, The President''s Own, United States Marine Band'),
('5512','Member, The Commandant''s Own, U.S. Marine Drum and Bugle Corps'),
('5517','Band Master'),
('5519','Enlisted Conductor'),
('5521','Drum Major'),
('5522','Small Ensemble Leader'),
('5523','Instrument Repair Technician'),
('5524','Musician'),
('5526','Musician, Oboe'),
('5528','Musician, Bassoon'),
('5534','Musician, Clarinet'),
('5536','Musician, Flute/Piccolo'),
('5537','Musician, Saxophone'),
('5541','Musician, Trumpet'),
('5543','Musician, Euphonium'),
('5544','Musician, Horn'),
('5546','Musician, Trombone'),
('5547','Musician, Tuba/Sousaphone'),
('5548','Musician, Electric Bass'),
('5562','Bandsman, Timpani/Xylophone, Marimba, & Vibraphone'),
('5563','Musician, Percussion (Drums, Timpani, Mallets)'),
('5565','Musician, Piano'),
('5566','Musician, Guitar'),
('5567','Arranger, Band'),
('5571','Drum & Bugle Corps Drum Major'),
('5574','Musician, Soprano or Mellophone Bugle'),
('5576','Musician, French Horn Bugle'),
('5577','Musician, Bass Baritone Bugle'),
('5579','Musician, Contrabass Bugle'),
('5592','Drum & Bugle Corps Arranger'),
('5593','Musician, Percussion (Drum and Bugle Corps)'),
('9811','Member "The President''s Own" U.S.M.C. Band'),
('9812','Member, "The Commandant''s Own," U.S. Marine Drum and Bugle Corps'),
('001572','Musician'),
('3801','Flute/Piccolo Instrumentalist'),
('3802','Oboe Instrumentalist'),
('3803','Clarinet Instrumentalist'),
('3804','Bassoon Instrumentalist'),
('3805','Saxophone Instrumentalist'),
('3806','Trumpet Instrumentalist'),
('3807','French Horn Instrumentalist'),
('3808','Euphonium Instrumentalist'),
('3809','Trombone Instrumentalist'),
('3811','Tuba Instrumentalist'),
('3812','Guitar Instrumentalist'),
('3813','Percussion Instrumentalist'),
('3814','Keyboard Instrumentalist'),
('3815','Electric Bass/String Bass Instrumentalist'),
('3825','Vocalist/Entertainer'),
('3851','Enlisted Band Leader'),
('3852','Arranger'),
('3853','Unit Leader'),
('3854','Ceremonial Conductor-Drum Major'),
('3855','Sound Reinforcement Technician'),
('MU','Musician'),
('149','Technical Specialists, N.E.C.'),
('51G','Materials Quality Specialist'),
('77L','Petroleum Laboratory Specialist'),
('92C','Petroleum Laboratory Specialist'),
('92D','Chemical Laboratory Specialist'),
('92L','Petroleum Laboratory Specialist'),
('149100','Physical Science Laboratory'),
('99106','Applied Sciences Technician'),
('9S200','Applied Sciences'),
('0458','Soil Conservation Technician'),
('0458','Soil Conservation Technician'),
('6034','Spectrometric Oil Analysis Technician'),
('6401','Spectrometric Oil Analysis Program (SOAP) Evaluator'),
('6403','Oil Analysis Operator/Evaluator'),
('9559','Engineering Bulk Fuel System (Shore) Technician'),
('9561','Petroleum Specialist'),
('9571','Safety Technician'),
('9591','Radiological Control Monitor'),
('57F','Mortuary Affairs Specialist'),
('92M','Mortuary Affairs Specialist'),
('149200','Memorial Activities and Embalming'),
('7607','Mortuary Attending'),
('0471','Personnel Retrieval and Processing Specialist'),
('0472','Personnel Retrieval and Processing Technician'),
('9051','Graves Registration Specialist'),
('003178','Mortician'),
('003753','Ceremonial Specialist'),
('149300','Safety'),
('1S000','Safety Manager'),
('1S031','Safety Apprentice'),
('1S051','Safety Journeyman'),
('1S071','Safety Craftsman'),
('1S091','Safety Superintendent'),
('24100','Safety Manager'),
('24130','Safety Specialist'),
('24150','Safety Specialist'),
('24170','Safety Specialist'),
('24190','Safety Superintendent'),
('0019','Safety Technician'),
('1822','Mine Safety and Health Inspection'),
('1862','Consumer Safety Inspection'),
('0019','Safety Technician'),
('8012','Ground Safety Specialist'),
('9954','Hazardous Material/Hazardous Waste Staff Non-Commissioned Officer/Non-Comm Officer'),
('9956','Ground Safety Specialist'),
('6021','Safety Inspector'),
('9595','Hazardous Materiel Control Management Technician'),
('54B','Chemical Operations Specialist'),
('54E','NBC Specialist'),
('54Z','Chemical Senior Sergeant'),
('74D','Chemical, Biological, Radiological, and Nuclear (CBRN) Specialist'),
('790','Marine Science Technician'),
('MST','Marine Science Technician'),
('149400','Nuclear, Biological, and Chemical Warfare Specialists'),
('24200','Disaster Preparedness Manager'),
('24230','Disaster Preparedness Specialist'),
('24250','Disaster Preparedness Specialist'),
('24270','Disaster Preparedness Specialist'),
('24290','Disaster Preparedness Superintendent'),
('3E900','Emergency Management Manager'),
('3E931','Emergency Management Apprentice'),
('3E951','Emergency Management Journeyman'),
('3E971','Emergency Management Craftsman'),
('3E991','Emergency Management Superintendent'),
('0084','Nuclear Materials Courier'),
('5205','Gas and Radiation Detecting'),
('5711','Chemical, Biological, Radiological, and Nuclear (CBRN) Defense Specialist'),
('5712','Chemical Technical Escort'),
('5731','Joint Chemical, Biological, Radiological, Nuclear Reconnaissance System Operator (JCBRNRS) LAV Operator'),
('003555','Radiation Health Technician'),
('4905','Shipboard Chem. Bio. & Radiological Def.(CBR-D) Opr & Trn Spec'),
('9598','Disaster Preparedness Operations & Training Specialist'),
('12M','Firefighter'),
('21M','Firefighter'),
('51M','Fire Fighter'),
('210','Damage Controlman'),
('DC','Damage Controlman'),
('149500','Firefighting and Damage Control'),
('3E700','Fire Protection Manager'),
('3E731','Fire Protection Apprentice'),
('3E751','Fire Protection Journeyman'),
('3E771','Fire Protection Craftsman'),
('3E791','Fire Protection Superintendent'),
('57100','Fire Protection Manager'),
('57130','Fire Protection Specialist'),
('57150','Fire Protection Specialist'),
('57170','Fire Protection Specialist'),
('57190','Fire Protection Superintendent'),
('0081','Fire Protection and Prevention'),
('0456','Forest and Range Fire Control'),
('9809','Damage Control Instructor'),
('9816','Watchman (Fire)'),
('9918','Damage Control Leader'),
('9919','Damage Control Assistant Leader'),
('9929','Damage Controlman'),
('0081','Firefighter, Protection Inspector/Specialist, and Chief'),
('7051','Aircraft Rescue and Firefighting Specialist'),
('8811','Firefighter'),
('4805','Shipboard Chemical, Biological and Radiological-Defense (CBR-D) Operations and Training Specialist'),
('4962','Damage Controlman (Qualified)'),
('01B','Electrical-Electronic Engineering Assistant'),
('01C','Mechanical Engineering Assistant'),
('01D','Civil Engineering Assistant'),
('01E','Mathematics-Statistics Assistant'),
('01F','Physical Sciences Assistant'),
('01G','Chemical Engineering Assistant'),
('149600','Other Technical Specialists and Assistants'),
('8E000','Research, Analysis and Lessons Learned'),
('99127','Engineering or Scientific Assistant'),
('99501','Research & Development Technician'),
('9S100','Scientific Applications Specialist'),
('0021','Community Planning Technician'),
('0062','Clothing Design'),
('0102','Social Science Aid and Technician'),
('0119','Economics Assistant'),
('0181','Psychology Aid and Technician'),
('0404','Biological Science Technician'),
('0421','Plant Protection Technician'),
('0455','Range Technician'),
('0459','Irrigation System Operation'),
('0462','Forestry Technician'),
('0488','Fish Hatchery Management'),
('0802','Engineering Technical'),
('0805','Engineering Technology'),
('0828','Construction Analyst'),
('0895','Industrial Engineering Technical'),
('1016','Museum Specialist and Technician'),
('1311','Physical Science Technician'),
('1316','Hydrologic Technician'),
('1397','Document Analysis'),
('1421','Archives Technician'),
('1521','Mathematics Technician'),
('1531','Statistical Assistant'),
('1659','Fishery Methods and Equipment'),
('1898','Admeasurement'),
('1981','Agricultural Commodity Aid'),
('3515','Laboratory Support Working'),
('5235','Test Range Tracking'),
('5439','Testing Equipment Operating'),
('6606','Artillery Testing'),
('0021','Community Planning Technician'),
('0062','Clothing Designer'),
('0102','Social Science Support'),
('0119','Economics Technician'),
('0181','Psychology Technician'),
('0404','Biological Science and Laboratory Technician'),
('0462','Forestry Technician'),
('0802','Engineering Technician'),
('0895','Industrial Engineering Technician'),
('1016','Museum Technician'),
('1311','Physical Science Technician'),
('1316','Hydrologic Technician'),
('1397','Document Analysis Specialist'),
('1421','Archives Technician'),
('1521','Mathematics Technician'),
('1531','Statistical Assistant'),
('8056','Hazardous Material/Hazardous Waste (HM/HW) Staff Noncommissioned Officer/Noncommissioned Officer'),
('003755','Disaster Preparedness Operations Specialist'),
('003757','Environmental Specialist'),
('003805','Landing Craft Air Cushion Loadmaster'),
('9530','Special Technical Operations Specialist'),
('15','Functional Support and Administration'),
('9750','Functional Support and Administration'),
('150','Personnel'),
('00U','Equal Opportunity Specialist'),
('01K','Personnel Psychology Specialist'),
('42A','Human Resources Specialist'),
('42F','Human Resources Information Systems Management Specialist'),
('75B','Personnel Administration Specialist'),
('75C','Personnel Management Specialist'),
('75D','Personnel Records Specialist'),
('75E','Personnel Actions Specialist'),
('75F','Personnel Information Systems Management Specialist'),
('75H','Personnel Services Specialist'),
('75Z','Personnel Sergeant'),
('381','Personnelman'),
('150000','Personnel, General'),
('3S000','Force Support Manager'),
('3S031','Personnel Apprentice'),
('3S051','Personnel Journeyman'),
('3S071','Personnel Craftsman'),
('3S090','Personnel Superintendent'),
('3S091','Personnel Superintendent'),
('3S300','Manpower Manager'),
('3S331','Manpower Apprentice'),
('3S333','Manpower Apprentice'),
('3S351','Manpower Journeyman'),
('3S353','Manpower Journeyman'),
('3S371','Manpower Craftsman'),
('3S373','Manpower Craftsman'),
('3S391','Manpower Superintendent'),
('3S393','Manpower Superintendent'),
('3U000','Manpower Manager'),
('3U031','Manpower Apprentice'),
('3U051','Manpower Journeyman'),
('3U071','Manpower Craftsman'),
('3U091','Manpower Superintendent'),
('73200','Personnel Resource Manager'),
('73230','Personnel Specialist'),
('73231','Personal Affairs Specialist'),
('73250','Personnel Specialist'),
('73251','Personal Affairs Specialist'),
('73270','Personnel Specialist'),
('73271','Personal Affairs Specialist'),
('73299','Personnel Superintendent'),
('73300','Manpower Management Manager'),
('73331','Manpower Management Technician'),
('73351','Manpower Management Technician'),
('73371','Manpower Management Technician'),
('73391','Manpower Management Superintendent'),
('8C000','Airman and Family Readiness Center Readiness NCO'),
('99700','Family Support Center Superintendent'),
('0086','Security Clerical and Assistance'),
('0203','Human Resources Assistance'),
('0204','Military Personnel Clerical and Technician'),
('0967','Passport and Visa Examining'),
('1008','Interior Design'),
('0086','Security Technician'),
('0203','Human Resources Technician'),
('0967','Passport and Visa Specialist'),
('1008','Interior Design Specialist'),
('0147','Equal Opportunity Advisor (EOA)'),
('8534','Equal Opportunity Advisor'),
('001008','EO Advisor'),
('003714','Command Leader'),
('003716','Primary Leader'),
('003717','Advanced Leader'),
('003718','Executive Leader'),
('003719','First Line Leader'),
('003759','Human Resources Specialist'),
('2526','Personnel Administrationman'),
('2612','Classification Interviewer'),
('2614','Job Analyst'),
('2625','Officer Personnel Administrationman'),
('9513','Manpower Analyst'),
('9514','Management Engineering Technician'),
('9528','Organizational Effectiveness Specialist'),
('PN','Personnelman'),
('00E','Recruiter'),
('00R','Recruiter/Retention NCO'),
('79D','Reenlistment NCO'),
('79R','Recruiter'),
('79S','Career Counselor'),
('79T','Recruiting and Retention NCO (Army National Guard of the United States)'),
('79V','Army Reserve Career Counselor (Army Reserve)'),
('150100','Recruiting and Counseling'),
('3S100','Equal Opportunity Manager'),
('3S131','Equal Opportunity Journeyman'),
('3S131A','Social Actions Apprentice, Equal Opportunity/human Relations'),
('3S131B','Social Actions Apprentice, Substance Abuse Control'),
('3S171','Equal Opportunity Craftsman'),
('3S171A','Social Actions Craftsman, Equal Opportunity/human Relations'),
('3S171B','Social Actions Craftsman, Substance Abuse Control'),
('3S190','Social Actions Superintendent'),
('3S191','Equal Opportunity Superintendent'),
('73234','Career Advisory Technician'),
('73254','Career Advisory Technician'),
('73274','Career Advisory Technician'),
('73400','Social Actions Manager'),
('73430','Social Actions Technician'),
('73450','Social Actions Technician'),
('73470','Social Actions Technician'),
('73499','Social Actions Superintendent'),
('8A100','Career Assistance Advisor'),
('8R000','Enlisted Accessions Recruiter'),
('8R200','Second Tier Recruiter'),
('8R300','Third Tier Recruiter'),
('99120','Recruiter'),
('99500','Recruiter'),
('0399','Administration and Office Support Student Trainee'),
('0399','General Analysis/Office Support Student Trainee'),
('0143','Career Retention Specialist'),
('0149','Substance Abuse Control Specialist'),
('4821','Career Retention Specialist'),
('8411','Recruiter'),
('8412','Career Recruiter'),
('8421','Career Retention Specialist'),
('8535','Human Relations Instructor'),
('8538','Substance Abuse Counselor'),
('9936','Substance Abuse Control Specialist'),
('001617','Command Career Counselor'),
('001622','Career Specialist'),
('001627','Recruiting Manager'),
('001632','Recruiting Supervisor'),
('001800','Drug and Alcohol Counselor Intern'),
('003380','Drug and Alcohol Counselor'),
('003754','Counselor'),
('003766','Recruiter'),
('003776','Chief Career Counselor'),
('2186','Career Recruiter'),
('2187','Hometown Career Recruiting Force (HCRF) Recruiter'),
('9515','Command Climate Specialist'),
('9519','Navy Drug and Alcohol Counselor'),
('9521','Collateral Duty Alcoholism Advisor'),
('9522','Navy Drug and Alcohol Counselor Intern'),
('9565','Convoy Commodore Staff Assistant'),
('9585','Navy Recruiter Canvasser'),
('9586','Navy Recruiting District (NRD) Recruiter/Classifier'),
('9587','Officer Recruiter'),
('9588','Career Information Program Advisor'),
('9589','Command Career Information Retention Counselor/Coordinator'),
('9592','Reserve Career Information Program Advisor'),
('NC','Navy Counselor'),
('NCC','Navy Counselor (Counselor)'),
('NCR','Navy Counselor (Recruiter)'),
('151','Administration'),
('42L','Administrative Specialist'),
('71B','Clerk-Typist'),
('71L','Administrative Specialist'),
('71T','Equipment Maintenance Clerk'),
('360','Yeoman'),
('371','Communications Yeoman'),
('391','Postal Clerk'),
('151000','Administration, General'),
('1B031','Knowledge Operations Management Apprentice'),
('1B051','Knowledge Operations Management Journeyman'),
('1B071','Knowledge Operations Management Craftsman'),
('3A000','Knowledge Operations Management Manager'),
('3A031','Knowledge Operations Management Apprentice'),
('3A051','Knowledge Operations Management Journeyman'),
('3A071','Knowledge Operations Management Craftsman'),
('3A091','Knowledge Operations Management Superintendent'),
('3A100','Administration Manager'),
('3A131','Administration Apprentice'),
('3A151','Administration Journeyman'),
('3A171','Administration Craftsman'),
('3A191','Administration Superintendent'),
('3D031','Knowledge Management Apprentice'),
('3D051','Knowledge Management Journeyman'),
('3D071','Knowledge Management Craftsman'),
('70200','Information Management Manager'),
('70230','Information Management Specialist'),
('70250','Information Management Specialist'),
('70270','Information Management Specialist'),
('70290','Information Management Superintendent'),
('70299','Administration Superintendent'),
('70490','Administration Superintendent'),
('8P100','Defense Attache'),
('8S200','Icbm Nco Code Controller'),
('99131','Courier'),
('99603','ICBM NCO Code Controller'),
('99703','Defense Attache Specialist'),
('0029','Environmental Protection Assistant'),
('0072','Fingerprint Identification'),
('0134','Intelligence Aid and Clerk'),
('0302','Messenger'),
('0303','Miscellaneous Clerk and Assistant'),
('0304','Information Receptionist'),
('0305','Mail and File'),
('0309','Correspondence Clerk'),
('0313','Work Unit Supervising'),
('0318','Secretary'),
('0322','Clerk-Typist'),
('0324','Cold-Type Composing Machine'),
('0326','Office Automation Clerical and Assistance'),
('0342','Support Services Administration'),
('0344','Management and Program Clerical and Assistance'),
('0350','Equipment Operator'),
('0351','Printing Clerical'),
('0355','Calculating Machine Operation'),
('0357','Coding'),
('0361','Equal Opportunity Assistance'),
('0394','Communications Clerical'),
('0998','Claims Assistance and Examining'),
('1046','Language Clerical'),
('1087','Editorial Assistance'),
('1411','Library Technician'),
('1499','Library and Archives Student Trainee'),
('1603','Equipment, Facilities, and Services Assistance'),
('1897','Customs Aid'),
('9817','Yeoman (Deck)'),
('9843','Yeoman (Engine)'),
('0029','Environmental Protection Technician'),
('0072','Fingerprint Specialist'),
('0134','Intelligence Technician'),
('0302','Messenger'),
('0303','General Support'),
('0304','Information Receptionist'),
('0305','Mail and File Technician'),
('0309','Correspondence Technician'),
('0313','Work Unit Supervisor'),
('0318','Secretary'),
('0322','Typist'),
('0326','Office Automation Technician'),
('0342','Support Services Specialist'),
('0344','Management and Program Technician'),
('0350','Equipment Operator'),
('0357','Coding Technician'),
('0361','Equal Opportunity Technician'),
('0394','Communications Technician'),
('0998','Claims Technician'),
('1046','Language Technician'),
('1087','Editorial Technician'),
('1411','Library Technician'),
('1499','Library Student Trainee'),
('1603','Equipment, Facilities, and Services Support'),
('1897','Customs Technician'),
('0151','Administrative Clerk'),
('9935','Special Technical Operations Marine'),
('001012','Information Management Specialist'),
('001017','Special Compartmented Information Security Program Specialist'),
('001802','Administrative Assistant'),
('001810','Administrative Supervisor'),
('001815','Office Manager'),
('003764','Office Support Specialist'),
('2514','Flag Officer Writer'),
('48EA','Special Intelligence Clerk'),
('9190','Special Security Assistant'),
('9191','Independence Duty CTA'),
('9556','Security Specialist'),
('9566','Naval Control of Shipping Staff Assistant'),
('9567','Military Sealift Command Staff Assistant'),
('9578','Country, Area, or Regional Classification Enlisted (CARCE)'),
('9596','Joint Maritime Staff Operator'),
('CTA','Cryptologic Technician Administrative'),
('YN','Yeoman'),
('71C','Executive Administrative Assistant'),
('151100','Stenography'),
('70231','Stenographic Specialist'),
('70251','Stenographic Specialist'),
('70271','Stenographic Specialist'),
('70430','Apprentice Stenographic Specialist'),
('70450','Stenographic Specialist'),
('70470','Stenographic Technician'),
('0312','Clerk-Stenographer and Reporter'),
('0316','Clerk-Dictating Machine Transcribing'),
('0319','Closed Microphone Reporting'),
('0312','Stenographer'),
('0319','Closed Microphone Reporter'),
('2512','Staff Writer'),
('27D','Paralegal Specialist'),
('71D','Legal Specialist'),
('71E','Court Reporter'),
('151200','Legal'),
('5J000','Paralegal Manager'),
('5J031','Paralegal Apprentice'),
('5J051','Paralegal Journeyman'),
('5J071','Paralegal Craftsman'),
('5J091','Paralegal Superintendent'),
('70500','Legal Services Manager'),
('70530','Legal Services Specialist'),
('70550','Legal Services Specialist'),
('70570','Legal Services Specialist'),
('88100','Paralegal Manager'),
('88130','Paralegal Specialist'),
('88150','Paralegal Specialist'),
('88170','Paralegal Specialist'),
('88190','Paralegal Superintendent'),
('0901','General Legal and Kindred Administration'),
('0945','Clerk of Court'),
('0950','Paralegal Specialist'),
('0954','Legal Assistance'),
('0960','Adjudicating'),
('0962','Contact Representative'),
('0963','Legal Instruments Examining'),
('0965','Land Law Examining'),
('0986','Legal Assistance'),
('0990','General Claims Examining'),
('0991','Workers'' Compensation Claims Examining'),
('0992','Loss and Damage Claims Examining'),
('0993','Railroad Retirement Claims Examining'),
('0994','Unemployment Compensation Claims Examining'),
('0995','Dependents and Estates Claims Examining'),
('0996','Veterans Claims Examining'),
('0997','Civil Service Retirement Claims Examining'),
('0999','Legal Occupations Student Trainee'),
('1202','Patent Technician'),
('1211','Copyright Technician'),
('1241','Trade-Mark Examining'),
('1299','Copyright and Patent Student Trainee'),
('0901','Legal Specialist'),
('0950','Paralegal Specialist'),
('0962','Contact Representative'),
('0963','Legal Instruments Examiner'),
('0986','Legal Technician'),
('0996','Veterans Claims Specialist'),
('0999','Legal Student Trainee'),
('4421','Legal Services Specialist'),
('4422','Legal Services Court Reporter'),
('4422','Legal Services Reporter SPCM (Closed Microphone)'),
('4423','Legal Services Reporter GCM (Closed Microphone)'),
('4424','Legal Services Reporter-GCM (Stenotype)'),
('4425','Legal Services Notereader/Transcriber-Stenotype'),
('4429','Legal Services Reporter'),
('4449','Legal Services Chief'),
('001469','Paralegal'),
('001477','Law Office Specialist'),
('001482','Law Office Clerk'),
('2511','Court Reporter'),
('2516','Legal Clerk'),
('2960','Navy Paralegal'),
('LN','Legalman'),
('151300','Medical'),
('151400','Transportation'),
('151500','Postal'),
('151600','Aviation Maintenance Records and Reports'),
('151700','Flight Operations'),
('152','Clerical/Personnel'),
('YN','Yeoman'),
('152000','Combined Personnel and Administration, General'),
('0590','Time and Leave'),
('0593','Insurance Accounts'),
('0111','Administrative Specialist'),
('0121','Personnel Clerk'),
('0131','Unit Diary Clerk'),
('0171','Manpower Information Systems (MIS) Analyst'),
('0182','Personnel Chief'),
('0193','Personnel/Administrative Chief'),
('001117','Financial Specialist Supervisor'),
('001122','Financial Specialist'),
('001127','Financial Specialist Clerk'),
('001665','Personnel Clerk'),
('001672','Customer Service Clerk'),
('001677','Personnel Supervisor'),
('001682','Personnel Manager'),
('003765','Operations Support Technician'),
('003768','Support Services Specialist'),
('PS','Personnel Specialist'),
('00J','Command Sergeant Major (CSM) Engineer/Signal/Military Police/Military Intelligence Immaterial'),
('00K','Command Sergeant Major (CSM) Maneuver Support(MS)/Logistics'),
('00L','Command Sergeant Major (CSM) Logistics'),
('00P','Command Sergeant Major (CSM) Force Sustainment'),
('00R','Command Sergeant Major (CSM) Infantry/Armor Immaterial'),
('00T','Command Sergeant Major (CSM) Infantry/Armor/Field Artillery/Combat Engineer Immaterial'),
('00X','Command Sergeant Major (CSM) MOS Immaterial'),
('00Z','Command Sergeant Major Nominative'),
('910','Petty Officer'),
('990','Master Chief Petty Officer of the Coast Guard'),
('152100','First Sergeants, Sergeants Major, and Leading Chiefs'),
('10000','First Sergeant'),
('10090','First Sergeant'),
('8F000','First Sergeant'),
('99107','Senior Enlisted Advisor'),
('99108','Chief Master Sergeant of the Air Force'),
('99130','LGM-30 Facility Manager'),
('99504','Missile Facility Manager'),
('9C000','Chief Master Sergeant of the Air Force'),
('9D100','Key Developmental Senior Enlisted Positions on Headquarters Air Force Staff and Air Force Senior Noncommissioned Officer Academy at Maxwell-Gunter Annex'),
('9E000','Command Chief Master Sergeant'),
('9G100','Group Superintendent'),
('9L100','Enlisted Engagement Manager/International Affairs'),
('9M000','Military Entrance Processing Command (MEPCON) Senior Enlisted Advisor'),
('9M400','Chief, Medical Enlisted Force'),
('9N000','Secretary of the Air Force Enlisted Legislative Fellows'),
('8991','Sergeant Major of The Marine Corps'),
('8999','Sergeant Major-First Sergeant'),
('9991','Sergeant Major of The Marine Corps'),
('9999','Sergeant Major/First Sergeant'),
('002581','Maintenance Master Chief'),
('003707','Flag Command Master Chief'),
('003708','Installation Command Master Chief'),
('003709','Command Master Chief'),
('003710','Chief of Naval Operations-Force-Fleet Master Chief'),
('003711','Immediate Superior In Command Master Chief'),
('003712','Chief of the Boat'),
('003713','Large Deck Command Master Chief'),
('92CC','Command Master Chief'),
('92CD','Command Master Chief Petty Officer'),
('92FL','Fleet Master Chief Petty Officer'),
('92FO','Force Master Chief Petty Officer'),
('92MN','Master Chief Petty Officer of the Navy'),
('9578','Command Senior Chief'),
('9579','Chief of The Boat (All Submarines)'),
('9580','Command Master Chief'),
('CMC','Command Master Chief'),
('CMD','Command Master Chief Petty Officer'),
('CNO','CNO - Directed Command Master Chief'),
('FLT','Fleet Master Chief Petty Officer'),
('FOR','Force Master Chief Petty Officer'),
('MCN','Master Chief Petty Officer of the Navy'),
('153','Data Processing'),
('25B','Information Technology Specialist'),
('25D','Cyber Network Defender'),
('25Y','Information Systems Chief'),
('71U','Card & Tape Writer'),
('74B','Information Systems Operator-Analyst'),
('74D','Computer/Machine Operator'),
('74D','Information System Operator'),
('74E','Computer Systems Operator'),
('74Z','Information Systems Chief'),
('153100','Operators/Analysts'),
('1B032','Cyber Systems Operations Apprentice'),
('1B033','Cyber Surety Apprentice'),
('1B052','Cyber Systems Operations Journeyman'),
('1B053','Cyber Surety Journeyman'),
('1B072','Cyber Systems Operations Craftsman'),
('1B073','Cyber Surety Craftsman'),
('1B431','Network Warfare Operator Apprentice'),
('1B451','Network Warfare Operator Journeyman'),
('1B471','Network Warfare Operator Craftsman'),
('3C031','Communications - Computer Systems Operations Apprentice'),
('3C051','Communications - Computer Systems Operations Journeyman'),
('3C071','Communications - Computer Systems Operations Craftsman'),
('3D032','Cyber Systems Operations Apprentice'),
('3D033','Cyber Surety Apprentice'),
('3D052','Cyber Systems Operations Journeyman'),
('3D053','Cyber Surety Journeyman'),
('3D072','Cyber Systems Operations Craftsman'),
('3D073','Cyber Surety Craftsman'),
('3S032','Personnel System Management (PSM) Apprentice'),
('3S052','Personnel System Management (PSM) Journeyman'),
('3S072','Personnel System Management (PSM) Craftsman'),
('49131','Communications - Computer Systems Operator'),
('49151','Communications - Computer Systems Operator'),
('49171','Communications - Computer Systems Operator'),
('51130','Computer Operator'),
('51132','Apprentice Computer Systems Analysis & Design Specialist'),
('51150','Computer Operator'),
('51152','Computer Systems Analysis & Design Specialist'),
('51170','Computer Operator'),
('51172','Computer Systems Analysis & Design Technician'),
('73100','Personnel Systems Manager'),
('73130','Personnel Systems Specialist'),
('73150','Personnel Systems Specialist'),
('73170','Personnel Systems Specialist'),
('73190','Personnel Systems Superintendent'),
('73233','Personnel Systems Management Specialist'),
('73253','Personnel Systems Management Specialist'),
('73273','Personnel Systems Management Specialist'),
('99105','Scientific Measurement Technician'),
('99137','Data Formatting Equipment Operator'),
('99509','Data Formatting Equipment Operator'),
('0332','Computer Operation'),
('0335','Computer Clerk and Assistant'),
('0356','Data Transcriber'),
('0359','Electric Accounting Machine Operation'),
('0362','Electric Accounting Machine Project Planning'),
('0356','Data Transcriber'),
('2203','Computer Operator'),
('2204','Computer Technician'),
('0511','Marine Air Ground Task Force (MAGTF) Planning Specialist'),
('0656','Tactical Network Specialist'),
('0658','Tactical Data Network Gateway Systems Administrator'),
('0681','Information Security Technician'),
('0689','Cyber Security Technician'),
('3073','Automated Information System (AIS) Computer Operator'),
('4013','Card Punch Operator'),
('4014','Electric Accounting Machine Operator'),
('4016','Data Processing Equipment Operator'),
('4019','Data Systems Librarian'),
('4025','Network Control Specialist'),
('4033','Computer Operator IBM S/360'),
('4034','Computer Operator'),
('4038','Data Control Specialist'),
('4068','Data Network Technician'),
('4099','Data Processing Chief'),
('6047','Aircraft Maintenance Data Analyst/Administrator'),
('6048','Aircraft Maintenance Computer Systems Analyst/Operator'),
('6673','Automated Information Systems (AIS) Computer Operator'),
('9982','Small Computer Systems Operator/Programmer'),
('2702','Computer System Operator'),
('2703','Computer Systems Operator/Configuration Specialist (WWMCCS)'),
('2704','LHA Computer System Operator'),
('2705','LHA Intelligence Center ADP Operator'),
('2706','ASWOC Data Processing Technician'),
('2707','NCCS ADP Operator'),
('2708','OSIS Baseline Upgrade (OBU) System Manager'),
('2709','Joint Force Air Component Commander (JFACC) System Administrator'),
('2710','Global Command and Control System-Maritime 4.X (GCCS-M 4.X) System Administrator'),
('2711','Computer Systems Operation Supervisor'),
('2720','GCCS-M System Administrator'),
('2723','Planning Series - MQ-4C Unmanned Aircraft System (UAS) Mission Control System Administrator'),
('2730','Naval Tactical Command Support System (NTCSS) II Manager'),
('2731','SNAP III Database/Network Administrator'),
('2732','SNAP III Automated Information Systems (AIS) Resource Technician'),
('2734','NIPS Storage & Retrieval Operator & Data Base Manager'),
('2735','Journeyman Networking Core'),
('2736','Database Management System (DBMS) Specialist'),
('2739','Information Center Supervisor'),
('2740','Intelligence Data Handling Systems (IDHS) Supervisor, Ashore'),
('2751','System Analyst'),
('2752','Application System Analyst (WWMCCS)'),
('2753','NWSS System Support Analyst (WWMCCS)'),
('2755','AN/UYK-65 System Supervisor (SNAP I)'),
('2756','AN/UYK-65(V) System Operator (SNAP I)'),
('2757','CV-ASWM Data Processing System Operator'),
('2759','CV-ASWM Data Processing Technician'),
('2776','Navy Command and Control System (NCCS) Ashore System Manager'),
('2777','Tactical Support Center (TSC) Data Processing System Operator'),
('2778','Mission Distribution System Operator'),
('2779','Information System Security Manager'),
('2780','Network Security Vulnerability Technician'),
('2781','Advanced Network Analyst'),
('2783','Submarine Local Area Network (SUBLAN) Technician'),
('4778','Fiber Optic Data Multiplex System (FODMS) Technician'),
('7423','Computer Operator'),
('9301','Entry Level Programmer/Analyst'),
('9302','Cryptologic Network Configuration Manager'),
('9305','Basic Digital Network Analysis'),
('9306','Network Operations (NWO)'),
('9307','Network Analysis and Reporting (NAR)'),
('9308','Navy Interactive ON-NET Operator'),
('9309','Navy Interactive ON-NET Operator Trainer'),
('9325','Basic Cyber Analyst/Operator'),
('9326','Navy Interactive On-Net (ION) Operator (Windows)'),
('9327','Navy Interactive On-Net (ION) Operator (Unix)'),
('9328','Navy Interactive On-Net (ION) Operator (Networks)'),
('DP','Data Processing Technician'),
('2770','Applied Cyber Operations Master'),
('74F','Software Analyst'),
('153200','Programmers'),
('1B000','Cyber Operations Manager'),
('1B034','Computer Systems Programming Apprentice'),
('1B054','Computer Systems Programming Journeyman'),
('1B074','Computer Systems Programming Craftsman'),
('1B090','Cyber Operations Superintendent'),
('3C000','Communications - Computer Systems Manager'),
('3C032','Communications - Computer Systems Programming Apprentice'),
('3C052','Communications - Computer Systems Programming Journeyman'),
('3C072','Communications - Computer Systems Programming Craftsman'),
('3C090','Communications - Computer Systems Superintendent'),
('3D000','Cyber Operations Manager'),
('3D034','Computer Systems Programming Apprentice'),
('3D054','Computer Systems Programming Journeyman'),
('3D074','Computer Systems Programming Craftsman')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 15...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('3D090','Cyber Operations Superintendent'),
('49100','Communications - Computer Systems Manager'),
('49132','Communications - Computer Systems Programming Specialist'),
('49152','Communications - Computer Systems Programming Specialist'),
('49172','Communications - Computer Systems Programming Specialist'),
('49199','Communications - Computer Systems Superintendent'),
('51100','Computer Systems Manager'),
('51131','Computer Programming Specialist'),
('51151','Computer Programming Specialist'),
('51171','Computer Programming Specialist'),
('51192','Computer Systems Superintendent'),
('51199','Computer Systems Superintendent'),
('4041','Teleprocessing Specialist'),
('4044','Operator/Programmer, Univac 1500'),
('4058','Programmer, Autocoder 1401'),
('4063','COBOL Programmer'),
('4065','Programmer, ALC'),
('4066','Small Computer Systems Specialist (SCSS)'),
('4067','Programmer, ADA'),
('4069','Systems Programmer'),
('4071','Data Base Management System (DBMS) Specialist'),
('4075','Computer Security Specialist'),
('4076','Computer Security Specialist'),
('4093','Data Systems Operation Chief'),
('4095','Data Systems Programming Chief'),
('4098','Systems Software Chief'),
('9975','Information Computer Security Specialist'),
('9981','Tactical Data Systems Specialist'),
('2738','Computer Programmer (ADA)'),
('2741','Computer Programmer (Assembler Language)'),
('2742','Computer Programmer (COBOL)'),
('2743','Computer Programmer (FORTRAN)'),
('2744','Systems Programmer'),
('2745','System Software Programmer (WWMCCS)'),
('2746','System Programmer (LDMX/NAVCOMMPARS)'),
('2747','Application Programmer/Analyst (WWMCCS)'),
('2750','Small Computer System Specialist'),
('9507','Digital Computer Programmer'),
('154','Accounting, Finance and Disbursing'),
('73D','Accounting Specialist'),
('441','Machine Accountant'),
('443','Data Processing Technician'),
('154100','Auditing and Accounting'),
('55400','CE Resources Manager'),
('55430','CE Resources Management Specialist'),
('55450','CE Resources Management Specialist'),
('55470','CE Resources Management Specialist'),
('67200','Financial Manager'),
('67230','Budget Specialist'),
('67231','Financial Management Specialist'),
('67250','Budget Specialist'),
('67251','Financial Management Specialist'),
('67270','Budget Specialist'),
('67271','Financial Management Specialist'),
('67273','Financial Management Supervisor'),
('67299','Financial Management & Services Superintendent'),
('67300','Auditing Manager'),
('67330','Auditing Specialist'),
('67350','Auditing Specialist'),
('67370','Auditing Specialist'),
('67390','Auditing Superintendent'),
('6F000','Financial Management and Comptroller Manager'),
('6F031','Financial Management and Comptroller Apprentice'),
('6F051','Financial Management and Comptroller Journeyman'),
('6F070','Financial Management And Services Craftsman'),
('6F071','Financial Management and Comptroller Craftsman'),
('6F090','Financial Management And Services Superintendent'),
('6F091','Financial Management and Comptroller Superintendent'),
('0354','Bookkeeping Machine Operation'),
('0503','Financial Clerical and Technician'),
('0504','Budget and Accounting'),
('0520','Accounts Maintenance Clerical'),
('0525','Accounting Technician'),
('0526','Tax Specialist'),
('0540','Voucher Examining'),
('0541','Fiscal Auditing (GAO)'),
('0561','Budget Clerical and Assistance'),
('0592','Tax Examining'),
('0503','Financial Technician'),
('0525','Accounting Technician'),
('0526','Tax Specialist'),
('0540','Voucher Examiner'),
('0561','Budget Technician'),
('3431','Travel Clerk'),
('3441','NAF Audit Technician'),
('3451','Financial Management Resource Analyst'),
('3452','Accounting Analyst/Finance Chief'),
('4111','Bookkeeper, Nonappropriated Funds'),
('36B','Financial Management Technician'),
('44C','Financial Management Technician'),
('73C','Finance Specialist'),
('73Z','Finance Senior Sergeant'),
('431','Disbursing Clerk'),
('154200','Disbursing'),
('67232','Financial Services Specialist'),
('67252','Financial Services Specialist'),
('67272','Financial Services Specialist'),
('6F032','Financial Services Apprentice'),
('6F052','Financial Services Journeyman'),
('0530','Cash Processing'),
('0544','Civilian Pay'),
('0545','Military Pay'),
('0547','Benefit-Payment Roll'),
('9889','Purser (Freighter)'),
('9899','Purser'),
('9988','Purser'),
('9989','Junior Purser'),
('0530','Cash Processing Technician'),
('0544','Civilian Pay Technician'),
('0545','Military Pay Technician'),
('3421','Personal Financial Records Clerk'),
('3432','Finance Technician'),
('2905','Personnel Specialist Advanced Disbursing Operations'),
('DK','Disbursing Clerk'),
('155','Other Functional Support'),
('51C','Acquisition, Logistics & Technology (AL&T) Contracting NCO'),
('55R','Ammunition Stock Control & Accounting Specialist'),
('76A','Supplyman'),
('76C','Equipment Records & Parts Specialist'),
('76D','Materiel Supply Specialist'),
('76N','Procurement Sergeant'),
('76P','Materiel Control & Accounting Specialist'),
('76Q','Special Purpose Materiel Supply Specialist'),
('76R','Weapons Material Supply Specialist'),
('76S','Vehicle Materiel Supply Specialist'),
('76T','Aircraft Materiel Supply Specialist'),
('76U','Communications Electronics (COMMEL) Materiel Supply Specialist'),
('76V','Materiel Storage & Handling Specialist'),
('76X','Subsistence Supply Specialist'),
('76Z','Senior Supply/Service Sergeant'),
('92A','Automated Logistical Specialist'),
('92Y','Unit Supply Specialist'),
('420','Storekeeper'),
('500','Food Service Specialist'),
('FS','Food Service Specialist'),
('SK','Storekeeper'),
('155100','Supply Administration'),
('2G000','Logistics Plans Manager'),
('2G031','Logistics Plans Apprentice'),
('2G051','Logistics Plans Journeyman'),
('2G071','Logistics Plans Craftsman'),
('2G091','Logistics Plans Superintendent'),
('2S000','Materiel Manager'),
('2S031','Materiel Management Apprentice'),
('2S032','Supply Systems Analysis Apprentice'),
('2S051','Materiel Management Journeyman'),
('2S052','Supply Systems Analysis Journeyman'),
('2S071','Materiel Management Craftsman'),
('2S072','Supply Systems Analysis Craftsman'),
('2S090','Supply Management Superintendent'),
('2S091','Materiel Management Superintendent'),
('45600','Munitions Operations Manager'),
('46500','Munitions Operations Manager'),
('46530','Munitions Operations Specialist'),
('46550','Munitions Operations Specialist'),
('46570','Munitions Operations Specialist'),
('46590','Munitions Operations Superintendent'),
('64500','Supply Manager'),
('64530','Inventory Management Specialist'),
('64532','Supply Systems Analysis Specialist'),
('64550','Inventory Management Specialist'),
('64552','Supply Systems Analysis Specialist'),
('64570','Inventory Management Specialist'),
('64572','Supply Systems Analysis Specialist'),
('64592','Supply Management Superintendent'),
('64599','Supply Management Superintendent'),
('64830','Supply Systems Specialist'),
('64850','Supply Systems Specialist'),
('64870','Supply Systems Specialist'),
('65100','Contracting Manager'),
('65130','Contracting Specialist'),
('65150','Contracting Specialist'),
('65170','Contracting Specialist'),
('65190','Contracting Superintendent'),
('66100','Logistics Plans Manager'),
('66130','Logistics Plans Specialist'),
('66150','Logistics Plans Specialist'),
('66170','Logistics Plans Specialist'),
('66190','Logistics Plans Superintendent'),
('6C000','Contracting Manager'),
('6C031','Contracting Apprentice'),
('6C051','Contracting Journeyman'),
('6C071','Contracting Craftsman'),
('6C091','Contracting Superintendent'),
('8U000','Unit Deployment Manager'),
('1101','General Business and Industry'),
('1105','Purchasing'),
('1106','Procurement Clerical and Technician'),
('1107','Property Disposal Clerical and Technician'),
('1199','Business and Industry Student Trainee'),
('2001','General Supply'),
('2005','Supply Clerical and Technician'),
('2010','Inventory Management'),
('2050','Supply Cataloging'),
('2099','Supply Student Trainee'),
('9818','Storekeeper (Deck)'),
('9819','Yeoman-Storekeeper (Deck)'),
('9844','Storekeeper (Engine)'),
('9845','Yeoman-Storekeeper (Engine)'),
('9890','Yeoman-Storekeeper (Purser)'),
('9994','Assistant Storekeeper'),
('9998','Yeoman-Storekeeper'),
('1101','Business'),
('1105','Purchasing Technician'),
('1106','Procurement Technician'),
('1107','Property Disposal Technician'),
('1108','Business Support'),
('1199','Business Student Trainee'),
('2001','Supply Specialist'),
('2005','Supply Technician'),
('2010','Inventory Management Specialist'),
('2050','Supply Cataloging Specialist'),
('2099','Supply Student Trainee'),
('0411','Maintenance Management Specialist'),
('0431','Logistics/Embarkation Specialist'),
('0441','Logistics/Combat Service Support (CSS) Specialist'),
('0491','Logistics/ Mobility Chief'),
('3043','Supply Administration and Operations Specialist'),
('3044','Contingency Contract Specialist'),
('3046','Intermediate Contingency Contract Specialist'),
('3048','Advanced Contingency Contract Specialist'),
('3071','Supply Man, Manual Account'),
('3072','Aviation Supply Clerk'),
('3081','Purchasing & Contracting Specialist'),
('3091','Supply Administration & Operations Chief'),
('6672','Aviation Supply Specialist'),
('8060','Acquisition Specialist'),
('9960','Acquisition Specialist'),
('001742','Supply Chain Manager'),
('001747','Logistics Specialist'),
('003762','Logistics Support Technician'),
('2813','Independent Duty Ashore Storekeeper'),
('2814','SNAP II Supply and Financial Management (SFM) Storekeeper'),
('2815','Independent Duty Afloat Storekeeper'),
('2816','Supply & Accounting (Non-Mechanized) Analyst'),
('2817','Supply & Accounting (SUADPS) Analyst'),
('2818','Supply & Accounting (NSA Class 207) Analyst'),
('2819','Personal Property Specialist'),
('2820','SNAP II Supply and Financial Management (SFM) Functional Area Supervisor'),
('2822','Supply and Accounting (SUADPS) Technical Specialist'),
('2823','Supply and Accounting (SUADPS R/T) Analyst'),
('2824','Supply and Accounting (SUADPS R/T) Technical Specialist'),
('2825','Supply and Accounting (SUADPS R/T) Advanced Technical Specialist'),
('2826','Purchasing Specialist'),
('2828','Relational Supply Force Technical Specialist'),
('2829','Relational Supply Unit Technical Specialist'),
('2830','Relational Supply Force Advanced Technical Specialist'),
('2831','Relational Supply Unit Advanced Technical Specialist'),
('2840','Expeditionary Logistics Specialist'),
('8011','Aviation Repairables Management Specialist'),
('8012','Aviation Supply Systems Specialist'),
('8014','Optimized Naval Aviation Logistic Command Operations Maintenance Information System (NALCOMIS) Intermediate Maintenance Activity (IMA) Aviation Supply Systems Specialist'),
('90LG','Expeditionary Force Logistic Support - Deployed'),
('90LS','Expeditionary Force Logistic Support - Not Deployed'),
('9525','Ammunition Inventory Management Specialist'),
('9549','Acquisition Logistics Specialist'),
('AK','Aviation Storekeeper'),
('LS','Logistics Specialist'),
('SK','Storekeeper'),
('76Y','Unit Supply Specialist'),
('92Z','Senior Noncommissioned Logistician'),
('155200','Unit Supply'),
('90SN','Individual GWOT IA/ILO Special Operations Support, Not Deployed'),
('90SP','Individual GWOT IA/ILO Special Oerations Support Team'),
('65K','Railway Movement Coordinator (RC)'),
('71N','Traffic Management Coordinator'),
('88N','Transportation Management Coordinator'),
('88W','Railway Movement Coordinator (RC)'),
('155300','Transportation'),
('1A600','Flight Attendant Manager'),
('1A631','Flight Attendant Apprentice'),
('1A651','Flight Attendant Journeyman'),
('1A671','Flight Attendant Craftsman'),
('1A691','Flight Attendant Superintendent'),
('2T000','Traffic Manager'),
('2T031','Traffic Management Apprentice'),
('2T051','Traffic Management Journeyman'),
('2T071','Traffic Management Craftsman'),
('2T091','Traffic Management Superintendent'),
('2T200','Air Transportation Manager'),
('2T231','Air Transportation Apprentice'),
('2T251','Air Transportation Journeyman'),
('2T271','Air Transportation Craftsman'),
('2T291','Air Transportation Superintendent'),
('60200','Traffic Manager'),
('60230','Passenger & Household Goods Specialist'),
('60231','Freight and Packaging Specialist'),
('60250','Passenger & Household Goods Specialist'),
('60251','Freight and Packaging Specialist'),
('60270','Passenger & Household Goods Specialist'),
('60271','Freight and Packaging Specialist'),
('60273','Traffic Management Supervisor'),
('60291','Traffic Management Superintendent'),
('60299','Traffic Management Superintendent'),
('60500','Air Transportation Manager'),
('60530','Air Passenger Specialist'),
('60531','Air Cargo Specialist'),
('60535','Air Transportation Specialist'),
('60550','Air Passenger Specialist'),
('60551','Air Cargo Specialist'),
('60555','Air Transportation Specialist'),
('60570','Air Passenger Specialist'),
('60571','Air Transportation Supervisor'),
('60572','Air Transportation Supervisor'),
('60575','Air Transportation Specialist'),
('60591','Air Transportation Superintendent'),
('60595','Air Transportation Superintendent'),
('60599','Air Transportation Superintendent'),
('8A000','Flight Attendant'),
('99701','Inflight Passenger Service Specialist'),
('2102','Transportation Clerk and Assistant'),
('2111','Transportation Rate and Tariff Examining'),
('2131','Freight Rate'),
('2132','Travel'),
('2133','Passenger Rate'),
('2134','Shipment Clerical and Assistance'),
('2135','Transportation Loss and Damage Claims Examining'),
('2144','Cargo Scheduling'),
('2161','Marine Cargo'),
('2199','Transportation Student Trainee'),
('2102','Transportation Technician'),
('2131','Freight Rate Technician'),
('2135','Transportation Loss and Damage Claims Examiner'),
('2144','Cargo Scheduling Technician'),
('2161','Marine Cargo Specialist'),
('2199','Transportation Student Trainee'),
('3112','Distribution Management Specialist'),
('3121','Freight Transportation Clerk'),
('3122','Air Freight Transportation Clerk'),
('3141','Passenger Transportation Clerk'),
('3191','Transportation Chief'),
('6617','Enlisted Aviation Logistician'),
('003769','Transportation Specialist'),
('2821','Air Transportation Specialist'),
('8278','Loadmaster'),
('71F','Postal Clerk'),
('155400','Postal'),
('8M000','Postal'),
('8P000','Courier'),
('99505','Courier'),
('99604','Postal Specialist'),
('0161','Postal Clerk'),
('001637','Postal Worker'),
('001645','Postal Inspector'),
('00PC','Postal Clerk (PC) Tracking NEC'),
('2211','Area Mail Router'),
('3001','Independent Duty Postal Clerk'),
('PC','Postal Clerk'),
('155500','Aviation Maintenance Records and Reports'),
('43330','Maintenance Scheduling Specialist'),
('43350','Maintenance Scheduling Specialist'),
('43370','Maintenance Scheduling Specialist'),
('6046','Aviation Maintenance Data Specialist'),
('002576','Aviation Administrator'),
('6301','Enhanced Comprehensive Asset Management Systems (ECAMS) Operator'),
('6302','F-18 Automated Maintenance Environment Operator'),
('6303','Optimized NALCOMIS System Administrator/Analyst OMA'),
('6304','Optimized NALCOMIS Database Administrator/Analysis IMA'),
('6313','3-M System Data Analyst'),
('6314','Naval Aviation Logistics Command Management Information System (NALCOMIS) Data Base Administrator/Analyst (DBA/A)'),
('6315','Naval Aviation Logistics Command Management Information System (NALCOMIS) System Administrator/Analyst (SA/A)'),
('8013','Naval Aviation Logistics Command Management Information System (NALCOMIS) Supply Data Base Administrator (DBA)'),
('8015','Optimized Naval Aviation Logistic Command Operations Maintenance Information System (NALCOMIS) Supply Application Administrator (SAA)'),
('9590','Support Equipment Asset Manager'),
('AZ','Aviation Maintenance Administrationman'),
('15P','Aviation Operations Specialist'),
('71P','Flight Operations Coordinator'),
('93P','Aviation Operations Specialist'),
('155600','Flight Operations'),
('1C000','Air Operations Manager'),
('1C031','Airfield Management Apprentice'),
('1C032','Aviation Resource Management Apprentice'),
('1C051','Airfield Management Journeyman'),
('1C052','Aviation Resource Management Journeyman'),
('1C071','Airfield Management Craftsman'),
('1C072','Aviation Resource Management Craftsman'),
('1C091','Airfield Management Superintendent'),
('1C092','Aviation Resource Management Superintendent'),
('1C700','Airfield Manager'),
('1C731','Airfield Management Apprentice'),
('1C751','Airfield Management Journeyman'),
('1C771','Airfield Management Craftsman'),
('1C791','Airfield Management Superintendent'),
('1N500','Electronic Signals Intelligence Exploitation Manager'),
('1N531','Electronic Signals Intelligence Exploitation Apprentice'),
('1N551','Electronic Signals Intelligence Exploitation Journeyman'),
('1N571','Electronic Signals Intelligence Exploitation Craftsman'),
('1N591','Electronic Signals Intelligence Exploitation Superintendent'),
('27100','Air Operations Manager'),
('27130','Air Operations Specialist'),
('27131','Airfield Management Specialist'),
('27132','Operations Resources Management Specialist'),
('27150','Air Operations Specialist'),
('27151','Airfield Management Specialist'),
('27152','Operations Resources Management Specialist'),
('27170','Air Operations Specialist'),
('27171','Airfield Management Specialist'),
('27172','Operations Resources Management Specialist'),
('27191','Airfield Management Superintendent'),
('27192','Operations Resources Management Superintendent'),
('27199','Air Operations Superintendent'),
('9R000','Civil Air Patrol (CAP)-USAF Reserve Assistance NCO'),
('7041','Aviation Operations Specialist'),
('155700','Production and Quality Control'),
('1152','Production Control'),
('1901','General Commodities Quality Control & Inspection'),
('1903','Quality Control and Inspection Management'),
('1905','Subsistence Quality Control & Inspection'),
('1906','Clothing, Textiles, and Leather Quality Control & Inspection'),
('1910','Quality Assurance'),
('1916','Petroleum Quality Control and Inspection'),
('1920','Materials Quality Control and Inspection'),
('1935','Electrical Equipment Quality Control & Inspection'),
('1936','Electronic Equipment Quality Control & Inspection'),
('1940','Mechanical Equipment Quality Control & Inspection'),
('1941','Automotive Equipment Quality Control & Inspection'),
('1942','Aircraft Quality Control and Inspection'),
('1947','Ordnance Quality Control and Inspection'),
('1948','Ammunition Quality Control and Inspection'),
('1950','Missile Quality Control and Inspection'),
('1960','Quality Inspection'),
('1961','Calibration and Measurement Quality Control & Inspection'),
('1965','Materials Treatment Processes Quality Control & Inspection'),
('1970','Preservation and Packaging Quality Control & Inspection'),
('1980','Agricultural Commodity Grading'),
('1999','Quality Inspection Student Trainee'),
('1152','Production Controller'),
('1910','Quality Assurance Specialist'),
('1999','Quality Assurance Student Trainee'),
('002589','Maintenance and Production Chief'),
('9564','Continuous Process Improvement Core Green Belt'),
('9582','Continuous Process Improvement Core Black Belt'),
('155800','Functional Analysis'),
('2R000','Maintenance Manager'),
('2R031','Maintenance Management Analysis Apprentice'),
('2R051','Maintenance Management Analysis Journeyman'),
('2R071','Maintenance Management Analysis Craftsman'),
('2R090','Maintenance Management Superintendent'),
('2R091','Maintenance Data Systems Analysis Superintendent'),
('2R100','Maintenance Production Management Manager'),
('2R131','Maintenance Management Production, Apprentice'),
('2R151','Maintenance Management Production Journeyman'),
('2R171','Maintenance Management Production Craftsman'),
('2R191','Maintenance Production Management Superintendent'),
('2T333','Vehicle Maintenance Control And Analysis Apprentice'),
('2T337','Vehicle Management and Analysis Apprentice'),
('2T353','Vehicle Maintenance Control And Analysis Journeyman'),
('2T357','Vehicle Management and Analysis Journeyman'),
('2T373','Vehicle Maintenance Control And Analysis Craftsman'),
('2T377','Vehicle Management and Analysis, Craftsman'),
('39100','Maintenance Systems Analysis Manager'),
('39130','Maintenance Data Systems Analysis Specialist'),
('39150','Maintenance Data Systems Analysis Specialist'),
('39170','Maintenance Data Systems Analysis Specialist'),
('39199','Maintenance Analysis Superintendent'),
('39200','Maintenance Scheduling Manager'),
('39230','Maintenance Scheduling Specialist'),
('39250','Maintenance Scheduling Specialist'),
('39270','Maintenance Scheduling Specialist'),
('39300','Maintenance Manager'),
('3C300','Communications - Computer Systems Programs Manager'),
('3C331','Communications - Computer Systems Planning And Implementation Apprentice'),
('3C351','Communications - Computer Systems Planning And Implementation Journeyman'),
('3C371','Communications - Computer Systems Planning And Implementation Craftsman'),
('3C391','Communications - Computer Systems Planning And Implementation Superintendent'),
('47234','Vehicle Maintenance Control & Analysis Specialist'),
('47254','Vehicle Maintenance Control & Analysis Specialist'),
('47274','Vehicle Maintenance Control & Analysis Specialist'),
('49600','Communications - Computer Systems Programs Manager'),
('49630','Communications-Computer Systems Planning & Programs Management Spe'),
('49650','Communications-Computer Systems Planning & Programs Management Spe'),
('49670','Communications-Computer Systems Planning & Programs Management Spe'),
('49690','Communications-Computer Systems Planning & Programs Management Sup'),
('67400','Financial Analyszis Manager'),
('67430','Financial Analysis Specialist'),
('67450','Financial Analysis Specialist'),
('67470','Financial Analysis Specialist'),
('67490','Financial Analysis Superintendent'),
('69100','Cost & Management Analysis Manager'),
('69130','Cost & Management Analysis Specialist'),
('69150','Cost & Management Analysis Specialist'),
('69170','Cost & Management Analysis Specialist'),
('6F100','Financial Analysis Manager'),
('6F131','Financial Analysis Apprentice'),
('6F151','Financial Analysis Journeyman'),
('6F171','Financial Analysis Craftsman'),
('6F191','Financial Analysis Superintendent'),
('8I000','Superintendent, Inspections'),
('0531','Civil Affairs Noncommissioned Officer'),
('0532','Civil Affairs Specialist'),
('6618','Enlisted AIRSpeed Coordinator'),
('001000','Preventive Maintenance Manager'),
('002068','Aircraft Launch and Recovery Equipment Maintenance and Administrative Operations Technician'),
('9511','3-M System Maintenance Operations Manager'),
('9512','3-M System Coordinator'),
('156','Religious, Morale and Welfare'),
('56M','Chaplain Assistant'),
('71M','Chaplain Assistant'),
('156100','Chaplain''s Assistants'),
('5R000','Chaplain Assistant Manager'),
('5R031','Chaplain Assistant Apprentice'),
('5R051','Chaplain Assistant Journeyman'),
('5R071','Chaplain Assistant Craftsman'),
('5R091','Chaplain Assistant Superintendent'),
('70100','Chapel Manager'),
('70130','Chapel Management Specialist'),
('70150','Chapel Management Specialist'),
('70170','Chapel Management Specialist'),
('89300','Chaplain Service Support Manager'),
('89330','Chaplain Service Support Specialist'),
('89350','Chaplain Service Support Specialist'),
('89370','Chaplain Service Support Specialist'),
('89390','Chapel Management Superintendent'),
('001710','Religious Program Specialist'),
('001715','Religious Program Manager'),
('2401','Marine Basic Combat Skills Specialist'),
('2525','Chaplain''s Professional Assistant'),
('RP','Religious Program Specialist'),
('03B','Performing Arts Specialist'),
('03C','Physical Activities Specialist'),
('03D','Arts & Crafts Specialist'),
('03Z','Special Services Senior Sergeant'),
('156200','Recreation and Welfare'),
('74100','Fitness and Recreation Manager'),
('74130','Athletic Specialist'),
('74131','Fitness and Recreation Specialist'),
('74150','Athletic Specialist'),
('74151','Fitness and Recreation Specialist'),
('74170','Athletic Specialist'),
('74171','Fitness and Recreation Specialist'),
('74191','Fitness and Recreation Superintendent'),
('0026','Park Technician'),
('0030','Sports Specialist'),
('0090','Guide'),
('0186','Social Services Aid and Assistant'),
('0187','Social Services'),
('0189','Recreation Aid and Assistant'),
('1054','Theater Specialist'),
('1056','Art Specialist'),
('0030','Sports Specialist'),
('0090','Visitor Guide'),
('0186','Social Services Technician'),
('0187','Social Services Specialist'),
('0189','Recreation Technician'),
('1054','Theater Specialist'),
('1056','Art Specialist'),
('4621','Training Equipment and Library Specialist'),
('4652','Audiovisual Equipment Operator'),
('4921','Audiovisual Librarian'),
('4931','Audiovisual Equipment Operator'),
('8561','Physical Training Instructor'),
('8921','Athletic & Recreation Assistant'),
('003758','Hospitality Specialist'),
('95PT','Command Fitness Leader (CFL)'),
('157','Information and Education'),
('26T','Radio/Television Systems Specialist'),
('38A','Civil Affairs Specialist (RC)'),
('38B','Civil Affairs Specialist'),
('46Q','Public Affairs Specialist'),
('46R','Public Affairs Broadcast Specialist'),
('46Z','Chief Public Affairs NCO'),
('71Q','Journalist'),
('71R','Broadcast Journalist'),
('84T','TV/Radio Broadcast Operations Chief'),
('84Z','Public Affairs Chief'),
('157000','Information and Education, General'),
('3H000','Historian Manager'),
('3H031','Historian Apprentice'),
('3H051','Historian Journeyman'),
('3H071','Historian Craftsman'),
('3H091','Historian Superintendent'),
('3N000','Public Affairs Manager'),
('3N031','Public Affairs Apprentice'),
('3N035','Photojournalist Apprentice'),
('3N035A','Photojournalist Apprentice, Journalist'),
('3N051','Public Affairs Journeyman'),
('3N055','Photojournalist Journeyman'),
('3N071','Public Affairs Craftsman'),
('3N075','Photojournalist Craftsman'),
('3N090','Public Affairs Superintendent'),
('3S200','Education And Training Manager'),
('3S231','Education And Training Apprentice'),
('3S251','Education and Training Journeyman'),
('3S271','Education And Training Craftsman'),
('3S291','Education And Training Superintendent'),
('75100','Education and Training Manager'),
('75130','Education Specialist'),
('75131','Training Systems Technician'),
('75132','Training Specialist'),
('75133','Instructional System Specialist'),
('75150','Education Specialist'),
('75151','Training Systems Technician'),
('75152','Training Specialist'),
('75153','Instructional System Specialist'),
('75170','Education Specialist'),
('75171','Training Systems Technician'),
('75172','Training Specialist'),
('75173','Instructional System Specialist'),
('75193','Education & Training Superintendent'),
('75199','Education & Training Superintendent'),
('79100','Public Affairs Manager'),
('79130','Public Affairs Specialist'),
('79132','Historian Specialist'),
('79150','Public Affairs Specialist'),
('79152','Historian Specialist'),
('79170','Public Affairs Specialist'),
('79172','Historian Specialist'),
('79191','Information Superintendent'),
('79199','Public Affairs Superintendent'),
('79200','Historian Manager'),
('79232','Historian Specialist'),
('79252','Historian Specialist'),
('79272','Historian Specialist'),
('79292','Historian Superintendent'),
('1001','General Arts and Information'),
('1048','Foreign Language Broadcasting'),
('1099','Information and Arts Student Trainee'),
('1702','Education and Training Technician'),
('1799','Education Student Trainee'),
('1001','Arts and Information'),
('1002','Arts and Information Support'),
('1099','Information and Arts Student Trainee'),
('1702','Education and Training Technician'),
('1703','Education Specialist'),
('1799','Education Student Trainee'),
('0551','Information Operations Specialist'),
('4312','Print Journalist'),
('4313','Broadcaster'),
('4321','Print Journalist'),
('4322','Photojournalist'),
('4341','Mass Communicator'),
('4391','Public Affairs Chief'),
('4991','Training Support Chief'),
('8028','Marine Enlisted Commissioning Education Program (MECEP) Participant'),
('8231','Education Assistant'),
('9928','MECEP Participant'),
('002206','Mass Communication Specialist'),
('002274','Public Affairs Supervisor'),
('002618','Broadcaster'),
('002620','Multi Media Supervisor'),
('002621','Public Affairs Manager'),
('002622','Production Manager'),
('003704','Formal Instructor'),
('003705','Training Manager'),
('003706','Workspace Trainer'),
('3221','Broadcast Operations Specialist'),
('3251','Broadcast Operations Director'),
('8142','Broadcast Reporter'),
('8145','Content Manager'),
('8150','Broadcaster'),
('8152','Public Affairs Officer (Enlisted)'),
('8153','Public Affairs Supervisor'),
('8154','Senior Enlisted Public Affairs Advisor'),
('90CA','Expeditionary Force - Maritime Civil Affairs'),
('90CD','GWOT IA/ILO Training for Civil Affairs/Provincial Reconstruction'),
('9506','Curriculum and Instructional Standards Specialist'),
('JO','Journalist'),
('MC','Mass Communications Specialist'),
('158','Communications Center Operations'),
('158000','Communications Center Operations, General'),
('16','Electrical/Mechanical Equipment Repairers'),
('9760','Electrical/Mechanical Equipment Repairman'),
('160','Aircraft and Aircraft Related'),
('15E','Unmanned Aircraft Systems Repairer'),
('15M','UH-1 Helicopter Repairer (RC)'),
('15R','AH-64 Attack Helicopter Repairer'),
('15S','OH-58D Helicopter Repairer'),
('15T','UH-60 Helicopter Repairer'),
('15U','CH-47 Helicopter Repairer'),
('15V','Observation/Scout Helicopter Repairer (RC)'),
('15Z','Aircraft Maintenance Senior Sergeant'),
('66G','Utility Airplane Technical Inspector'),
('66H','Observation Airplane Technical Inspector'),
('66J','Aircraft Armament Technical Inspector'),
('66N','Utility Helicopter Technical Inspector'),
('66R','Attack Helicopter (AH-64) Technical Inspector'),
('66S','Scout Helicopter Technical Inspector (NISH)'),
('66T','Tactical Transport Helicopter Technical Inspector'),
('66U','Medium Helicopter Technical Inspector'),
('66V','Observation/Scout Helicopter Technical Inspector'),
('66X','Heavylift Helicopter Technical Inspector'),
('66Y','Attack Helicopter (AH-1) Technical Inspector'),
('67A','General Aircraft Repairer'),
('67B','O-1/U-6 Airplane Repairman'),
('67C','U-1A Airplane Repairman'),
('67F','Airplane Technical Inspector'),
('67G','Utility Airplane Repairer (RC)'),
('67H','Observation Airplane Repairer'),
('67M','OH-13/OH-23 Helicopter Repairman'),
('67N','UH-1 Helicopter Repairer'),
('67R','AH-64 Attack Helicopter Repairer'),
('67S','OH-58D Scout Helicopter Repairer'),
('67T','UH-60 Helicopter Repairer'),
('67U','CH-47 Helicopter Repairer'),
('67V','Observation/Scout Helicopter Repairer'),
('67W','Aircraft Quality Control Supervisor'),
('67X','Heavy Lift Helicopter Repairer'),
('67Y','AH-1 Attack Helicopter Repairer (RC)'),
('67Z','Aircraft Maintenance Senior Sergeant'),
('525','Aviation Maintenance Technician'),
('AMT','Aviation Maintenance Technician'),
('160000','Aircraft, General'),
('2A300','Fighter/Remotely Piloted Aircraft Manager'),
('2A333A','Tactical Aircraft Maintenance Apprentice, F-15'),
('2A333B','Tactical Aircraft Maintenance Apprentice, F-16'),
('2A333C','Tactical Aircraft Maintenance Apprentice, F/EF-111'),
('2A333D','Tactical Aircraft Maintenance Apprentice, F-4'),
('2A333E','Tactical Aircraft Maintenance Apprentice, A-10/U-2'),
('2A333F','Tactical Aircraft Maintenance Apprentice, MQ-1, MQ-9, RQ-4'),
('2A333G','Tactical Aircraft Maintenance Apprentice, T-37/OA-37'),
('2A333H','Tactical Aircraft Maintenance Apprentice, U-2'),
('2A333J','Tactical Aircraft Maintenance Apprentice, F-35'),
('2A333K','Tactical Aircraft Maintenance Apprentice, F-22'),
('2A333L','Tactical Aircraft Maintenance Apprentice, F-15'),
('2A333M','Tactical Aircraft Maintenance Apprentice, F-16'),
('2A333Z','Tactical Aircraft Maintenance Apprentice, All Other'),
('2A337A','Tactical Aircraft Maintenance (5th Generation) Apprentice, F-22'),
('2A337B','Tactical Aircraft Maintenance (5th Generation) Apprentice, F-35'),
('2A338A','Remotely Piloted Aircraft Maintenance Apprentice, MQ-1/MQ-9'),
('2A338B','Remotely Piloted Aircraft Maintenance Apprentice, RQ-4'),
('2A353','Tactical Aircraft Maintenance Journeyman'),
('2A353A','Tactical Aircraft Maintenance Journeyman, F-15'),
('2A353B','Tactical Aircraft Maintenance Journeyman, F-16/F-117'),
('2A353E','Tactical Aircraft Maintenance Journeyman, A-10/U-2'),
('2A353J','Tactical Aircraft Maintenance Journeyman, General (except F-15/F-16)'),
('2A353K','Tactical Aircraft Maintenance Journeyman, F-22A'),
('2A353L','Tactical Aircraft Maintenance Journeyman, F-15'),
('2A353M','Tactical Aircraft Maintenance Journeyman'),
('2A357A','Tactical Aircraft Maintenance (5th Generation) Journeyman, F-22'),
('2A357B','Tactical Aircraft Maintenance (5th Generation) Journeyman, F-35'),
('2A358A','Remotely Piloted Aircraft Maintenance Journeyman, MQ-1/MQ-9'),
('2A358B','Remotely Piloted Aircraft Maintenance Journeyman, RQ-4'),
('2A373','Tactical Aircraft Maintenance Craftsman'),
('2A373A','Tactical Aircraft Maintenance Craftsman, F-15'),
('2A373B','Tactical Aircraft Maintenance Craftsman, F-16/F-117'),
('2A373J','Tactical Aircraft Maintenance Craftsman, General (except F-15/F-16)'),
('2A377','Tactical Aircraft Maintenance (5th Generation) Craftsman'),
('2A378','Remotely Piloted Aircraft Maintenance Craftsman'),
('2A390','Fighter/Remotely Piloted Aircraft Superintendent'),
('2A500','Airlift/Special Mission Aircraft Maintenance Manager'),
('2A531A','Airlift/Special Mission Aircraft Maintenance Apprentice, C-20/C-21/C-22/C-37/C-40/E-4/VC-25'),
('2A531B','Airlift/Special Mission Aircraft Maintenance Apprentice, C-130/C-27J'),
('2A531C','Aerospace Maintenance Apprentice, C-5'),
('2A531D','Aerospace Maintenance Apprentice, C-17'),
('2A531E','Aerospace Maintenance Apprentice, B-1/B-2'),
('2A531F','Aerospace Maintenance Apprentice, B-52'),
('2A531G','Aerospace Maintenance Apprentice, C-18/C-135/E-3/VC-25/VC-137'),
('2A531H','Aerospace Maintenance Apprentice, KC-10/E-4'),
('2A532','Helicopter Maintenance'),
('2A532A','Helicopter/Tiltrotor Maintenance Apprentice, MH-53'),
('2A532B','Helicopter/Tiltrotor Aircraft Maintenance Apprentice, H-60'),
('2A532C','Helicopter/Tiltrotor Maintenance Apprentice, H-1'),
('2A532D','Helicopter/Tiltrotor Aircraft Maintenance Apprentice, CV-22'),
('2A534A','Refuel/Bomber Aircraft Maintenance Apprentice, Any C-135/E-3/E-8'),
('2A534B','Refuel/Bomber Aircraft Maintenance Apprentice, KC-10'),
('2A534C','Refuel/Bomber Aircraft Maintenance Apprentice, KC-46'),
('2A534D','Refuel/Bomber Aircraft Maintenance Apprentice, B-52'),
('2A534E','Refuel/Bomber Aircraft Maintenance Apprentice, B-1'),
('2A534F','Refuel/Bomber Aircraft Maintenance Apprentice, B-2'),
('2A551','Aerospace Maintenance Journeyman'),
('2A551A','Airlift/Special Mission Aircraft Maintenance Journeyman, C-20/C-21/C-22/C-37/C-40/E-4/VC-25'),
('2A551B','Airlift/Special Mission Aircraft Maintenance Journeyman, C-130/C-27J'),
('2A551C','Airlift/Special Mission Aircraft Maintenance Journeyman, C-5'),
('2A551D','Airlift/Special Mission Aircraft Maintenance Journeyman, C-17'),
('2A551J','Aerospace Maintenance Journeyman, C-5/C-9/C-12/C-17/C-20/C-21/C-22/ C 26/C-27/C-130/T-39/T-43'),
('2A551K','Aerospace Maintenance Journeyman, B-1/B-2/B-52'),
('2A551L','Aerospace Maintenance Journeyman, All C-135/C-18/E-3/E-4/KC-10/ VC-25/VC-137'),
('2A552','Helicopter/Tiltrotor Maintenance Journeyman'),
('2A552B','Helicopter/Tiltrotor Aircraft Maintenance Journeyman, H-60'),
('2A552D','Helicopter/Tiltrotor Aircraft Maintenance Journeyman, CV-22'),
('2A554A','Refuel/Bomber Aircraft Maintenance Journeyman, Any C-135/E-3/E-8'),
('2A554B','Refuel/Bomber Aircraft Maintenance Journeyman, KC-10'),
('2A554C','Refuel/Bomber Aircraft Maintenance Journeyman, KC-46'),
('2A554D','Refuel/Bomber Aircraft Maintenance Journeyman, B-52'),
('2A554E','Refuel/Bomber Aircraft Maintenance Journeyman, B-1'),
('2A554F','Refuel/Bomber Aircraft Maintenance Journeyman, B-2'),
('2A571','Airlift/Special Mission Aircraft Maintenance Craftsman'),
('2A572','Helicopter/Tiltrotor Aircraft Maintenance Craftsman'),
('2A574','Refuel/Bomber Aircraft Maintenance Craftsman'),
('2A590','Airlift/Special Mission Aircraft Maintenance Superintendent'),
('43130','Helicopter Mechanic'),
('43131','Tactical Aircraft Maintenance Specialist'),
('43132','Airlift/Bombardment Aircraft Maintenance Specialist'),
('43133','Airlife Aircraft Maintenance Specialist'),
('43134','General Aircraft Maintenance Specialist'),
('43150','Helicopter Mechanic'),
('43151','Tactical Aircraft Maintenance Specialist'),
('43152','Airlift/Bombardment Aircraft Maintenance Specialist'),
('43153','Airlife Aircraft Maintenance Specialist'),
('43154','General Aircraft Maintenance Specialist'),
('43170','Helicopter Mechanic'),
('43171','Tactical Aircraft Maintenance Specialist'),
('43172','Airlift/Bombardment Aircraft Maintenance Specialist'),
('43173','Airlife Aircraft Maintenance Specialist'),
('43174','General Aircraft Maintenance Specialist'),
('43199','Aircraft Maintenance Superintendent'),
('43200','Aircraft Maintenance Manager'),
('45234','Tactical Aircraft Maintenance Specialist'),
('45254','Tactical Aircraft Maintenance Specialist'),
('45274','Tactical Aircraft Maintenance Specialist'),
('45730','Strategic Aircraft Maintenance Specialist'),
('45731','Helicopter Maintenance Specialist'),
('45732','Airlift Aircraft Maintenance Specialist'),
('45750','Strategic Aircraft Maintenance Specialist'),
('45751','Helicopter Maintenance Specialist'),
('45752','Airlift Aircraft Maintenance Specialist'),
('45770','Strategic Aircraft Maintenance Specialist'),
('45771','Helicopter Maintenance Specialist'),
('45772','Airlift Aircraft Maintenance Specialist'),
('45799','Strategic/Airlift Maintenance Superintendent'),
('8801','Miscellaneous Aircraft Overhaul'),
('8852','Aircraft Mechanic'),
('8862','Aircraft Attending'),
('8865','Flight Mechanic'),
('6012','Aviation Maintenance Controller/Production Controller'),
('6012','Aircraft Mechanic, A-4/TA-4/OA-4'),
('6013','Aircraft Mechanic, A-6/EA-6'),
('6014','Unmanned Aerial Vehicle (UAV) Mechanic'),
('6015','Aircraft Mechanic, AV-8/TAV-8'),
('6016','Aircraft Mechanic, KC-130'),
('6017','Aircraft Mechanic, F/A-18'),
('6018','Aircraft Mechanic, OV-10'),
('6018','Aviation Quality Assurance Representative (QAR)/Inspector'),
('6019','Aircraft Maintenance Chief'),
('6020','Aircraft Mechanic, F-14A'),
('6029','Maintenance Line Chief, Fixed Wing'),
('6037','AV-8B Maintenance Specialist'),
('6038','AV-8B Maintenance Specialist'),
('6042','Individual Material Readiness List (IMRL) Asset Manager'),
('6052','Aircraft Airframe Mechanic, A-4/TA-4'),
('6053','Aircraft Airframes Mechanic, EA-6'),
('6054','Aircraft Hydraulic/Pneumatic Mechanic, F-4/RF-4'),
('6055','Aircraft Airframe Mechanic, AV-8/TAV-8'),
('6056','Aircraft Airframe Mechanic, KC-130'),
('6056','Aircraft Hydraulic/Pneumatic Mechanic, KC-130'),
('6057','Aircraft Airframe Mechanic, F/A-18'),
('6058','Aircraft Hydraulic/Pneumatic Mechanic, OV-10'),
('6112','Helicopter Mechanic, CH-46'),
('6113','Helicopter Mechanic, CH-53'),
('6114','Helicopter Mechanic, UH/AH-1'),
('6115','Tiltrotor Mechanic, MV-22'),
('6116','Tiltrotor Mechanic, MV-22'),
('6119','Helicopter/Tiltrotor Maintenance Chief'),
('6129','Maintenance Line Chief, Helicopter'),
('6152','Helicopter Airframe Mechanic, CH-46'),
('6153','Helicopter Airframe Mechanic, CH-53'),
('6154','Helicopter Airframe Mechanic, UH/AH-1'),
('6162','Presidential Support Specialist'),
('6212','Fixed-Wing Aircraft Mechanic, AV-8/TAV-8'),
('6213','Fixed-Wing Aircraft Mechanic, EA-6'),
('6214','Unmanned Aerial Vehicle (UAV) Mechanic'),
('6216','Fixed-Wing Aircraft Mechanic, KC-130'),
('6217','Fixed-Wing Aircraft Mechanic, F/A-18'),
('6218','Fixed-Wing Aircraft Mechanic, F-35B'),
('6252','Fixed-Wing Aircraft Airframe Mechanic, AV-8/TAV-8'),
('6253','Fixed-Wing Aircraft Airframe Mechanic, EA-6'),
('6256','Fixed-Wing Aircraft Airframe Mechanic, KC-130'),
('6257','Fixed-Wing Aircraft Airframe Mechanic, F/A-18'),
('6258','Fixed-Wing Aircraft Airframe Mechanic, F-35B'),
('7313','Helicopter Specialist, AH-1Z/UH-1Y'),
('9815','Electronic/Electrical Maintenance Technician'),
('9976','Helicopter Specialist, AH-1Z/UH-1Y'),
('002672','Unmanned Aerial Vehicle Pilot/Maintainer'),
('002687','Airman'),
('003752','Aviation Maintenance Technician'),
('6522','AKT-22 Data Link IMA Technician'),
('6526','Aviation ASW (MAD) IMA Technician'),
('6527','Aviation ASW (Airborne Sonar) IMA Technician'),
('6570','CV-ASWM Fast Time Analyzer Sub. Upgrade (FTAS-U) Syst. Tech.'),
('6571','CV-ASWM Antisubmarine Warfare Technician'),
('6581','P-3C Update IV Sensor Stations 1 and 2 EMSP OMA Technician'),
('6584','P-3C UPDATE III Sensor Stations 1 and 2 SASP OMA Technician'),
('6587','P-3C UPDATE III OMA Weapons System Technician'),
('6588','P-3C Update IV OMA Weapons System Technician'),
('6589','P-3C Update IV Sensor Station 3 OMA Technician'),
('6602','VHF Communications Equipment IMA Technician'),
('6603','ASN-99 Projected Map Display Set & ASM-398 PGSE IMA Technician'),
('6605','Aircraft Radar Altimeter Equipment IMA Technician'),
('6606','Aircraft Doppler Radar Navigation IMA Technician'),
('8207','HH-60H Utility Aircrewman'),
('8238','E-6A In-Flight Technician'),
('8276','P-3 Second Mechanic'),
('8300','Aviation Maintenance Material Control Master Chief'),
('8301','Aviation Safety Specialist'),
('8302','T-2C System Organizational Maintenance Technician'),
('8303','CH/MH-53E Systems Organizational Maintenance Technician'),
('8304','H-53 System Organizational Maintenance Technician'),
('8305','C2/E2 System Organizational Career Maintenance Technician'),
('8306','E-2C Group II Systems Organizational Career Maintenance Technician'),
('8307','C-2A Systems Organizational Maintenance Technician'),
('8308','CT-39 System Organizational Maintenance Technician'),
('8310','C-9B Systems Organizational Maintenance Technician'),
('8311','Aerial Target System Maintenance Technician'),
('8311','Planning Series - MQ-4C Unmanned Aircraft System (UAS) Organizational Career Maintenance Technician'),
('8312','Aircraft Aerial Refueling Stores (ARS) Organizational Career Maintenance Technician'),
('8313','C-40A Systems Organizational Maintenance Technician'),
('8314','C-20G Systems Organizational Maintenance Technician'),
('8315','E-6B System Organizational Career Maintenance Technician'),
('8316','E-2C Systems Organizational Career Maintenance Technician'),
('8317','EC-130 TACAMO System Organization Maintenance Technician'),
('8318','C-130 Systems Organizational Maintenance Technician'),
('8319','P-3 System Organizational Career Maintenance Technician'),
('8320','E-2D Aircraft Systems Organizational Career Maintenance Technician'),
('8323','F-4 System Organizational Maintenance Technician'),
('8326','A-7A/B System Organizational Maintenance Technician'),
('8327','A-7E System Organizational Maintenance Technician'),
('8328','Planning Series - MQ-4C Unmanned Aircraft System (UAS) Mission Control System Organizational Maintenance Technician'),
('8330','P-8A Aircraft Systems Organizational Career Maintenance Technician'),
('8331','A-6 System Organization Maintenance Technician'),
('8332','EA-6B System Organizational Career Maintenance Technician'),
('8333','EA-6A System Organizational Maintenance Technician'),
('8335','F-14B/D Systems Organizational Career Maintenance Technician'),
('8341','F/A-18E/F Systems Organizational Career Maintenance Technician'),
('8342','F/A-18 A/B/C/D System Organizational Maintenance Technician'),
('8343','E-6 System Organizational Career Maintenance Technician'),
('8344','RF-8 System Organizational Maintenance Technician'),
('8345','F-14 Systems Organizational Career Maintenance Technician'),
('8346','S-3A System Organizational Career Maintenance Technician'),
('8347','S-3B System Organizational Career Maintenance Technician'),
('8348','F-35C Aircraft Systems Organizational Maintenance Technician'),
('8348','Planning Series -F-35C Aircraft Systems Organizational Maintenance Technician'),
('8351','A-4 Systems Organizational Maintenance Technician'),
('8357','A-3 System Organizational Maintenance Technician'),
('8361','Unmanned Aerial Vehicle (UAV) Systems Organizational Maintenance Technician'),
('8366','MQ-8B Organizational Maintenance Technician'),
('8367','A-12 System Organizational Maintenance Technician'),
('8368','A-12 System Organizational Maintenance Technician (Master)'),
('8370','SH-2G LAMPS System Organizational Career Maintenance Technician'),
('8371','Planning Series - RQ-21A Organizational Maintenance Technician'),
('8374','H-1 System Organization Maintenance Technician'),
('8375','H-2 LAMPS System Organizational Career Maintenance Technician'),
('8376','SH-60 (LAMPS MK 111) System Organizational Career Maintenance Technician'),
('8377','SH-3 System Organizational Career Maintenance Technician'),
('8378','H-60 Systems Organizational Career Maintenance Technician'),
('8379','H-46 Systems Organizational Maintenance Technician'),
('8380','UH-1N Systems Organizational Maintenance Technician'),
('8381','C-1A/S-2 System Organizational Maintenance Technician'),
('8391','Airborne Mine Countermeasure Systems Career Maintenance (AMCM) Technician (Level I and O)'),
('8392','C-20A/D Organizational Maintenance Technician'),
('8394','EA-18G Electronic Counter Measures (ECM) System Maintenance Technician'),
('8395','EA-6B Electronic Counter Measures (ECM) System Organizational Career Maintenance Technician'),
('8800','Aviation Maintenance/Production Chief'),
('8803','CH/MH-53 Organizational Apprentice Maintenance Technician'),
('8805','C-2/E-2 Systems Organizational Initial Maintenance Technician'),
('8806','E-2C Group II Systems Organizational Initial Maintenance Technician'),
('8809','E-6B System Organizational Initial Maintenance Technician'),
('8810','EA-6B Electronic Counter Measures (ECM) System Organizational Initial Maintenance Technician'),
('8811','Planning Series - MQ-4C Unmanned Aircraft System (UAS) Organizational Initial Maintenance Technician'),
('8819','P-3 Systems Organizational Initial Maintenance Technician'),
('8820','E-2D Aircraft Systems Organizational Initial Maintenance Technician'),
('8830','P-8A Aircraft Systems Organizational Initial Maintenance Technician'),
('8832','EA-6B Systems Organizational Initial Maintenance Technician'),
('8835','F-14B/D Initial Organizational Maintenance Technician'),
('8841','F/A-18E/F Systems Organizational Initial Maintenance Technician'),
('8842','F/A-18 A/B/C/D Systems Organizational Initial Maintenance Technician'),
('8843','E-6 System Organizational Initial Maintenance Technician'),
('8845','F-14 Initial Organizational Maintenance Technician'),
('8847','S-3 Systems Organizational Initial Maintenance Technician'),
('8868','EA-6B Systems Organizational Initial Maintenance Technician'),
('8876','SH-60B (LAMPS MK III) System Organizational Initial Maintenance Technician'),
('8877','H-3 Systems Organizational Initial Maintenance Technician'),
('8878','H-60 Systems Organizational Initial Maintenance Technician'),
('8879','H-46 Systems Organizational Apprentice Maintenance Technician'),
('8891','Airborne Mine Countermeasures (AMCM) Systems Org Apprentice Maint Tech'),
('90UN','Expeditionary Force - Unmanned Systems (UAV/USV/USG) Maintenance')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 16...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('AF','Aircraft Maintenanceman'),
('AF','Master Chief Aircraft Maintenanceman'),
('AN','Airman'),
('15B','Aircraft Powerplant Repairer'),
('68B','Aircraft Powerplant Repairer'),
('520','Aviation Machinist''s Mate'),
('521','Aviation Machinist''s Mate - Turbojet Engines'),
('522','Aviation Machinist''s Mate - Reciprocating Engines'),
('160100','Aircraft Engines'),
('2A631A','Aerospace Propulsion, Jet Engines'),
('2A631B','Aerospace Propulsion Apprentice, Turboprop And Turboshaft Propulsion'),
('2A631C','Aerospace Propulsion Apprentice, TF33, CF6, F103, F108, F117, TFE-731, TF34, TF39, PW 2040, F138 Jet Engines'),
('2A631D','Aerospace Propulsion Apprentice, F100, F119, F135 Jet Engines'),
('2A631E','Aerospace Propulsion Apprentice, F101, F110, F118 Jet Engines'),
('2A631H','Aerospace Propulsion Apprentice, Turboprop And Turboshaft Propulsion'),
('2A651','Aerospace Propulsion Journeyman'),
('2A651A','Aerospace Propulsion Journeyman, Jet Engines'),
('2A651B','Aerospace Propulsion Journeyman, Turboprop And Turboshaft Propulsion'),
('2A651C','Aerospace Propulsion Journeyman, TF33, CF6, F103, F108, F117, TFE-731, TF34, TF39, PW 2040, F138 Jet Engines'),
('2A651F','Aerospace Propulsion Journeyman, F100, F101, F110, F118, F119, F135 Jet Engines'),
('2A651H','Aerospace Propulsion Journeyman, Turboprop And Turboshaft Propulsion'),
('2A671','Aerospace Propulsion Craftsman'),
('2A671A','Aerospace Propulsion Craftsman, Jet Engines'),
('2A671B','Aerospace Propulsion Craftsman, Turboprop And Turboshaft Propulsion'),
('2A671G','Aerospace Propulsion Craftsman, Turbofan and Turbojet Propulsion'),
('2A671H','Aerospace Propulsion Craftsman, Turboprop And Turboshaft Propulsion'),
('2A691','Aerospace Propulsion Superintendent'),
('42631','Reciprocating Propulsion Mechanic'),
('42632','Jet Engine Mechanic'),
('42633','Turboprop Propulsion Mechanic'),
('42634','F-100 Jet Engine Mechanic'),
('42651','Reciprocating Propulsion Mechanic'),
('42652','Jet Engine Mechanic'),
('42653','Turboprop Propulsion Mechanic'),
('42654','F-100 Jet Engine Mechanic'),
('42671','Reciprocating Propulsion Mechanic'),
('42672','Jet Engine Mechanic'),
('42673','Turboprop Propulsion Mechanic'),
('42674','F-100 Jet Engine Mechanic'),
('42692','Aircraft Propulsion Superintendent'),
('42699','Aircraft Propulsion Superintendent'),
('43230','Jet Engine Mechanic'),
('43231','Reciprocating Engine Mechanic'),
('43250','Jet Engine Mechanic'),
('43251','Reciprocating Engine Mechanic'),
('43270','Jet Engine Mechanic'),
('43271','Reciprocating Engine Mechanic'),
('45430','Aerospace Propulsion Specialist'),
('45450','Aerospace Propulsion Specialist'),
('45470','Aerospace Propulsion Specialist'),
('45490','Aerospace Propulsion Superintendent'),
('8601','Miscellaneous Engine Overhaul'),
('8602','Aircraft Engine Mechanic'),
('8810','Aircraft Propellor Mechanic'),
('1342','Small Craft Mechanic'),
('6022','Aircraft Power Plants Mechanic J52'),
('6023','Aircraft Power Plants Test Cell Operator'),
('6023','Aircraft Power Plants Mechanic T76'),
('6024','Aircraft Power Plants Mechanic J79'),
('6025','Aircraft Power Plants Mechanic Rolls Royce Pegasus'),
('6026','Aircraft Power Plants Mechanic T56'),
('6027','Aircraft Power Plants Mechanic, F-404'),
('6028','Aircraft Mechanic Reciprocating'),
('6035','Aircraft Power Plants Test Cell Operator, Fixed Wing'),
('6122','Helicopter Power Plants Mechanic, T-58'),
('6123','Helicopter Power Plants Mechanic, T-64'),
('6124','Helicopter Power Plants Mechanic, T-400/T-700'),
('6125','Tiltrotor Power Plants Mechanic, T-406'),
('6135','Aircraft Power Plants Test Cell Operator, Rotary Wing/Tiltrotor'),
('6222','Fixed-Wing Aircraft Power Plants Mechanic, F-402'),
('6223','Fixed-Wing Aircraft Power Plants Mechanic, J-52'),
('6226','Fixed-Wing Aircraft Power Plants Mechanic, T-56'),
('6227','Fixed-Wing Aircraft Power Plants Mechanic, F-404'),
('9816','Mechanical Maintenance Technician'),
('001362','Aviation Machinist Mate Organizational Level'),
('001417','Aviation Machinist Mate Intermediate Level'),
('6402','Reciprocating Engine Technician'),
('6409','J-57 Turbojet Engine First Degree/IMA Mechanic'),
('6410','F-110 Turbofan Jet Engine First Degree Repair/IMA Technician'),
('6412','J-79 Turbojet Engine First Degree/IMA Mechanic'),
('6414','TF-41 Turbofan Jet Engine First Degree/IMA Mechanic'),
('6415','TF-30 Turbofan Jet Engine First Degree/IMA Mechanic'),
('6416','J-52 Jet Turbojet Engine First Degree/IMA Mechanic'),
('6417','T-400 Turboshaft Jet Engine First Degree/IMA Mechanic'),
('6418','T-56 Turboprop Engine and 54H60 Series Propeller First Degree/IMA Mechanic'),
('6419','T-58 Turboshaft Jet Engine First Degree/IMA Mechanic'),
('6420','F-404 Turbofan Jet Engine First Degree/IMA Mechanic'),
('6421','TF-34 Turbofan Jet Engine First Degree/IMA Mechanic'),
('6422','Test Cell Operator/Maintainer'),
('6423','T-56-425/427 Turboprop Engine IMA Mechanic'),
('6424','T-64 Turboshaft Jet Engine First Degree/IMA Mechanic'),
('6425','F414-GE-400 Turbofan Jet Engine Third Degree/IMA Mechanic'),
('6426','T-700 Turboshaft Jet Engine First Degree/IMA Mechanic'),
('6427','J-85 Turbojet Engine First Degree/IMA Mechanic'),
('6428','Helicopter Rotors/Related Components IMA Mechanic'),
('6429','Turbo Shaft/Prop Engine Test Cell Operator'),
('AD','Aviation Machinist''s Mate'),
('ADJ','Aviation Machinist''s Mate J (Jet Engine Mechanic)'),
('ADR','Aviation Machinist''s Mate R (Reciprocating Engine Mechanic)'),
('15D','Aircraft Powertrain Repairer'),
('15F','Aircraft Electrician'),
('15H','Aircraft Pneudraulics Repairer'),
('15J','OH-58D/Armament/Electrical/Avionics Systems Repairer'),
('15K','Aircraft Components Repair Supervisor'),
('68D','Aircraft Powertrain Repairer'),
('68E','Aircraft Rotor & Propeller Repairman'),
('68F','Aircraft Electrician'),
('68H','Aircraft Pneudraulics Repairer'),
('68K','Aircraft Components Repair Supervisor'),
('68M','Aircraft Weapons Systems Repairer'),
('68P','Avionics Maintenance Supervisor'),
('68S','OH-58D Armament/Electrical/Avionics Systems Repairer'),
('541','Aviation Ordnanceman'),
('550','Aviation Electronics Technician'),
('551','Aviation Electronics Technician - Communications Equipment'),
('552','Aviation Electronics Technician - Radar'),
('560','Aviation Electrician''s Mate'),
('160200','Aircraft Accessories'),
('2A632','Aerospace Ground Equipment Apprentice'),
('2A633','Aircrew Egress Systems Apprentice'),
('2A634','Aircraft Fuel Systems Apprentice'),
('2A635','Aircraft Hydraulic Systems Apprentice'),
('2A636','Aircraft Electrical And Environmental Systems Apprentice'),
('2A652','Aerospace Ground Equipment Journeyman'),
('2A653','Aircrew Egress Systems Journeyman'),
('2A654','Aircraft Fuel Systems Journeyman'),
('2A655','Aircraft Hydraulic Systems Journeyman'),
('2A656','Aircraft Electrical And Environmental Systems Journeyman'),
('2A672','Aerospace Ground Equipment Craftsman'),
('2A673','Aircrew Egress Systems Craftsman'),
('2A674','Aircraft Fuel Systems Craftsman'),
('2A675','Aircraft Hydraulic Systems Craftsman'),
('2A676','Aircraft Electrical And Environmental Systems Craftsman'),
('2A690','Aircraft Systems Superintendent'),
('2A692','Aerospace Ground Equipment Superintendent'),
('42131','Aircraft Propeller Repairman'),
('42132','Aircraft Pneudraulic Repairman'),
('42133','Aerospace Ground Equipment Repairman'),
('42151','Aircraft Propeller Repairman'),
('42152','Aircraft Pneudraulic Repairman'),
('42153','Aerospace Ground Equipment Repairman'),
('42171','Aircraft Propeller Repairman'),
('42172','Aircraft Pneudraulic Repairman'),
('42173','Aerospace Ground Equipment Repairman'),
('42231','Aircraft Environmental Systems Repairman'),
('42232','Aircrew Egress Systems Repairman'),
('42251','Aircraft Environmental Systems Repairman'),
('42252','Aircrew Egress Systems Repairman'),
('42271','Aircraft Environmental Systems Repairman'),
('42272','Aircrew Egress Systems Repairman'),
('42330','Aircraft Electrical Systems Specialist'),
('42331','Aircraft Environmental Systems Mechanic'),
('42332','Aircrew Egress Systems Mechanic'),
('42333','Aircraft Fuel Systems Mechanic'),
('42334','Aircraft Pneudraulic Systems Mechanic'),
('42335','Aerospace Ground Equipment Mechanic'),
('42336','In-Flight Refueling Systems Mechanic'),
('42350','Aircraft Electrical Systems Specialist'),
('42351','Aircraft Environmental Systems Mechanic'),
('42352','Aircrew Egress Systems Mechanic'),
('42353','Aircraft Fuel Systems Mechanic'),
('42354','Aircraft Pneudraulic Systems Mechanic'),
('42355','Aerospace Ground Equipment Mechanic'),
('42356','In-Flight Refueling Systems Mechanic'),
('42370','Aircraft Electrical Systems Specialist'),
('42371','Aircraft Environmental Systems Mechanic'),
('42372','Aircrew Egress Systems Mechanic'),
('42373','Aircraft Fuel Systems Mechanic'),
('42374','Aircraft Pneudraulic Systems Mechanic'),
('42375','Aerospace Ground Equipment Mechanic'),
('42376','In-Flight Refueling Systems Mechanic'),
('42396','Aircraft Accessory Systems Superintendent'),
('42399','Aircraft Accessory Systems Superintendent'),
('42430','Aircraft Fuel Systems Mechanic'),
('42431','In-Flight Refueling Systems Repairman'),
('42450','Aircraft Fuel Systems Mechanic'),
('42451','In-Flight Refueling Systems Repairman'),
('42470','Aircraft Fuel Systems Mechanic'),
('42471','In-Flight Refueling Systems Repairman'),
('42630','Aircraft Propeller Mechanic'),
('42650','Aircraft Propeller Mechanic'),
('42670','Aircraft Propeller Mechanic'),
('45235','Tactical Electrical and Environmental Systems Specialist'),
('45255','Tactical Electrical and Environmental Systems Specialist'),
('45275','Tactical Electrical and Environmental Systems Specialist'),
('45400','Systems Manager'),
('45431','Aerospace Ground Equipment Mechanic'),
('45432','Aircrew Egress Systems Mechanic'),
('45433','Aircraft Fuel Systems Mechanic'),
('45434','Aircraft Pneudraulic Systems'),
('45435','Strategic Electrical and Environmental Systems Specialist'),
('45436','Airlift Electrical and Environmental Systems Specialist'),
('45451','Aerospace Ground Equipment Mechanic'),
('45452','Aircrew Egress Systems Mechanic'),
('45453','Aircraft Fuel Systems Mechanic'),
('45454','Aircraft Pneudraulic Systems'),
('45455','Strategic Electrical and Environmental Systems Specialist'),
('45456','Airlift Electrical and Environmental Systems Specialist'),
('45471','Aerospace Ground Equipment Mechanic'),
('45472','Aircrew Egress Systems Mechanic'),
('45473','Aircraft Fuel Systems Mechanic'),
('45474','Aircraft Pneudraulic Systems'),
('45475','Strategic Electrical and Environmental Systems Specialist'),
('45476','Airlift Electrical and Environmental Systems Specialist'),
('45491','Aerospace Ground Equipment (AGE) Superintendent'),
('45499','Aircraft Systems Superintendent'),
('2892','Aircraft Electrician'),
('8268','Aircraft Pneudraulic Systems Mechanic'),
('8807','Aircraft Propeller/Rotor Mechanic'),
('8840','Aircraft Mechanical Parts Repairing'),
('8863','Aircraft Tire Mounting'),
('6036','Aircraft Propeller Mechanic'),
('6062','Aircraft Safety Equipment Mechanic'),
('6067','Aircraft Safety Equipment Chief'),
('6073','Aircraft Maintenance Support Equipment Electrician/Refrigeration Mechanic'),
('6076','Aircraft Maintenance Ground Support Equipment Hydraulic/Pneumatic/Structures Mechanic'),
('6077','Aircraft Maintenance Ground Support Equipment Electrician'),
('6082','Aircraft Safety Equipment Mechanic, A-4/TA-4/OA-4'),
('6083','Aircraft Safety Equipment Mechanic, EA-6'),
('6084','Aircraft Safety Equipment Mechanic, F-4/RF-4'),
('6085','Aircraft Safety Equipment Mechanic, AV-8/TAV-8'),
('6086','Aircraft Safety Equipment Mechanic, KC-130/MV-22'),
('6087','Aircraft Safety Equipment Mechanic, F/A-18'),
('6088','Aircraft Safety Equipment Mechanic, OV-10'),
('6089','Aircraft Safety Equipment Mechanic, A-6/EA-6'),
('6090','Aircraft Safety Equipment Chief'),
('6132','Helicopter/Tiltrotor Dynamic Components Mechanic'),
('6282','Fixed-Wing Aircraft Safety Equipment Mechanic, AV-8/TAV-8'),
('6283','Fixed-Wing Aircraft Safety Equipment Mechanic, EA-6'),
('6286','Fixed-Wing Aircraft Safety Equipment Mechanic, KC-130/V-22'),
('6287','Fixed-Wing Aircraft Safety Equipment Mechanic, F/A-18'),
('6288','Fixed-Wing Aircraft Safety Equipment Mechanic, F-35B'),
('6332','Aircraft Avionics Technician, AV-8B'),
('6332','Aircraft Electrical Systems Technician, A-4/TA-4/OA-4'),
('6333','Aircraft Electrical Systems Technician, EA-6'),
('6334','Aircraft Electrical Systems Technician, F-4/RF-4'),
('6335','Aircraft Electrical Systems Technician, AV-8'),
('6336','Aircraft Electrical Systems Technician, KC-130'),
('6337','Aircraft Electrical Systems Technician, F/A-18'),
('6338','Aircraft Avionics Technician, F-35B'),
('6342','Aircraft Electrical Systems Technician, CH-46'),
('6343','Aircraft Electrical Systems Technician, CH-53'),
('6344','Aircraft Electrical Systems Technician, U/AH-1'),
('6345','Helicopter Electrical Systems Technician, CH-53E'),
('6372','Aerial Camera Systems Technician'),
('6374','Imagery Interpretation Equipment Repair Technician'),
('6431','Aircraft Electrical Systems Technician Trainee'),
('6432','Aircraft Electrical/Instrument/Flight Control Systems Technician, IMA'),
('6433','Aircraft Electrical/Instrument/Flight Control Systems Technician, Rotor Wing, IMA'),
('6476','Aerial Camera, ADAS Systems Technician, IMA'),
('6632','Aircraft Electrical Systems Technician, Helicopter/OV-10'),
('6633','Aircraft Electrical Systems Technician, Transport/Utility'),
('6634','Aircraft Electrical Systems Technician, A-4/TA-4'),
('6635','Aircraft Electrical Systems Technician, AV-8'),
('6636','Aircraft Electrical Systems Technician, RF-4/F-4'),
('6637','Aircraft Electrical Systems Technician, A-6/EA-6'),
('6638','Aircraft Electrical/Instrument Systems Technician, IMA'),
('6639','A/C Flight Control & Air Data Computer Systems Technician, IMA'),
('6642','Aircraft Weapon Systems Specialist, A-6E'),
('6643','Aircraft Weapon Systems Specialist, EA-6'),
('6644','Aircraft Weapon Systems Specialist, A-4, AV-8'),
('6645','A/C Analog Display System SACE Technician, A-6/EA-6, IMA'),
('001472','Aviation Electrician''s Mate Intermediate Level Technician'),
('001527','Aviation Electrician''s Mate Organizational Level Technician'),
('002320','Aviation Support Equipment Technician'),
('7011','Shipboard Aircraft Rescue, Firefighting and Salvage Specialists'),
('7012','Shore Base Airport and Aircraft Firefighter'),
('7103','A-4E Bombing System (AJB-3A) AFRS Technician'),
('7105','Attitude Heading Reference System IMA Technician'),
('7106','Central Air Data Computer IMA Technician'),
('7107','Helicopter Electrical Component IMA Technician'),
('7109','Loft Bomb Computer Set (AJB-3A/3B) AFRS IMA Technician'),
('7112','ASA-48 Semi Automatic Checkout Equipment IMA Technician'),
('7114','ASN-42 INS AFRS IMA Technician'),
('7115','Attitude Ref. Bombing Computer Set (AJB-7) AFRS IMA Technician'),
('7116','ASN-90 Inertial Measurement Set IMA Technician'),
('7117','ASN-84 Inertial Navigation System IMA Technician'),
('7123','S-5 AFCS IMA Technician'),
('7124','A-4C/E AFCS OMA Technician'),
('7125','RA-5C AFCS OMA Technician'),
('7128','A-7 AFCS IMA Technician'),
('7129','F-14 EMATS IMA Technician'),
('7131','Power Generating Systems IMA Technician'),
('7132','ASW-15/16/39/40/41/42 AFCS & ADC IMA Technician'),
('7133','EA-6B Electrical Component IMA Technician'),
('7135','H-53 AFCS OMA Technician'),
('7136','P-3C Automatic Flight Control Systems (AFCS) IMA Technician'),
('7137','Aircraft Instrument IMA Technician'),
('7138','MH-67 AFCS IMA Technician'),
('7139','Automatic Flight Control and Electrical Systems Intermediate Maintenance'),
('7140','A/F 37T-21 Aircraft Engine Components Test Stand'),
('7144','Helicopter ASE/AFCS IMA Technician'),
('7147','ASM-608 Inertial Measurement Unit Test Set Operator'),
('7149','ASN-92 Navigation Maintenance Technician'),
('7152','E-2B/C-2 AFCS/INS/E & I/ADC OMA Technician'),
('7166','Engine Test Cell Electrician'),
('7172','ASM-375 PGSE IMA Technician'),
('7173','ASM-175 Electronic Module Test Console IMA Technician'),
('7174','AFCS/ADC/INS/DRS & Flight Sys Mini-SACE GT-4 Test Cons Int Tech'),
('7175','P-3/C-130/E-2/C-2 Electrical Component IMA Technician'),
('7181','P-3C Integrated Electrical System OMA Specialist'),
('7182','P-3A/B Integrated Electrical System OMA Specialist'),
('7183','A-7E Electrical Intermediate Maintenance Technician'),
('7184','F/A-18 Electrical Systems IMA Technician'),
('7197','ASM-608 Inertial Measurement Unit Test Set Maintenance Tech.'),
('7198','E-2C Plus Aircraft Electrical and Instrument Systems Specialist'),
('7212','Stationary Hydraulics Test Stand Operator/Maintenanceman'),
('7213','Hydraulic, Pneumatic, Servocylinder Test (STS) Operator/Maintainer'),
('7227','A/F-27T-10 and (STS) Operator/Maintainer'),
('7232','Advanced Composite Structural Repair IMA Technician'),
('7601','Support Equipment Cryogenic Mechanic'),
('7602','Support Equipment Mobile Electric Power Plants Mechanic'),
('7603','Support Equipment Air Conditioning and Mobile Maintenance Facility (MMF) Technician'),
('7604','Ammunition Handling Equipment Mechanic'),
('7605','Crash and Material Handling Mechanic'),
('7606','Support Equipment Gas Turbine Mechanic'),
('7607','Support Equipment Tow Tractor Technician'),
('7608','Support Equipment Hydraulic Technician'),
('7609','Support Equipment Maintenance Manager'),
('7610','Weapons Handling/Loading Equipment Mechanic'),
('7611','Shore Based Weapons Handling/Loading Equipment Mechanic'),
('7612','SE Hydraulic Intermediate Maintenance Technician'),
('7613','Shore Based SE Hydraulic Equipment IMA Technician'),
('7614','Mobile Electric Power Plants Intermediate Maintenance Technician'),
('7615','Afloat Mobile Electric Power Plant Technician'),
('7616','Maintenance Crane Intermediate Maintenance Technician'),
('7617','Crash Equipment Technician (SEA)'),
('7618','Afloat Support Equipment Technician'),
('8385','MH60R/S Electrical Systems Organizational Career Maintenance Technician'),
('8885','MH60R/S Electrical Systems Organizational Initial Maintenance Technician'),
('AE','Aviation Electrician''s Mate'),
('AS','Aviation Support Equipmentman'),
('ASE','Aviation Support Equipment Technician E (Electrical)'),
('ASH','Aviation Support Equipment Technician H (Hydraulics & Structures)'),
('ASM','Aviation Support Equipment Technician M (Mechanical)'),
('15G','Aircraft Structural Repairer'),
('68G','Aircraft Structural Repairer'),
('570','Aviation Structural Mechanic'),
('571','Aviation Structural Mechanic - Safety Equipment'),
('572','Aviation Structural Mechanic - Hydraulics'),
('573','Aviation Structural Mechanic - Structures'),
('160300','Aircraft Structures'),
('2A733','Aircraft Structural Maintenance Apprentice'),
('2A735','Low Observable Aircraft Structural Maintenance Apprentice'),
('2A753','Aircraft Structural Maintenance Journeyman'),
('2A755','Low Observable Aircraft Structural Maintenance Journeyman'),
('2A773','Aircraft Structural Maintenance Craftsman'),
('2A775','Low Observable Aircraft Structural Maintenance Craftsman'),
('42735','Airframe Repair Specialist'),
('42755','Airframe Repair Specialist'),
('42775','Airframe Repair Specialist'),
('43135','O-2 Aircraft Airframe'),
('43155','O-2 Aircraft Airframe'),
('43175','O-2 Aircraft Airframe'),
('45832','Aircraft Structural Maintenance'),
('45852','Aircraft Structural Maintenance'),
('45872','Aircraft Structural Maintenance'),
('53133','Airframe Repair Specialist'),
('53153','Airframe Repair Specialist'),
('53173','Airframe Repair Specialist'),
('3819','Airframe Jig Fitting'),
('8882','Airframe Test Operating'),
('6033','Aircraft Nondestructive Inspection Technician'),
('6034','Aircraft Nondestructive Inspection Operator'),
('6042','Aircraft Structures Mechanic'),
('6044','Aircraft Non-Destructive Inspection Technician'),
('6045','Aircraft Non-Destructive Inspection Operator'),
('6059','Aircraft Airframes Maintenance Chief'),
('6061','Aircraft Intermediate Level Hydraulic/Pneumatic Mechanic-Trainee'),
('6062','Aircraft Intermediate Level Hydraulic/Pneumatic Mechanic'),
('6092','Aircraft Intermediate Level Structures Mechanic'),
('6093','Aircraft Intermediate Level Hydraulic/Pneumatic Mechanic Trainee'),
('6094','Aircraft Intermediate Level Hydraulic/Pneumatic Mechanic'),
('6095','Aircraft Structures Mechanic, AV-8/TAV-8'),
('6096','Aircraft Structures Mechanic, KC-130'),
('6097','Aircraft Structures Mechanic, F/A-18'),
('6098','Aircraft Structures Mechanic, OV-10'),
('6142','Helicopter Structures Mechanic, CH-46'),
('6143','Helicopter Structures Mechanic, CH-53'),
('6144','Helicopter Structures Mechanic, U/AH-1'),
('6145','Helicopter Structures Mechanic, MV-22'),
('6155','Tiltrotor Airframe Mechanic, MV-22'),
('6156','Tiltrotor Airframe Mechanic, MV-22'),
('6159','Helicopter Airframes Maintenance Chief'),
('001805','Aviation Structural Mechanic Intermediate Level'),
('001862','Aviation Structural Mechanic Organizational Level'),
('001955','Aviation Environmental/Egress Technician'),
('7214','E-2/C-2 Organizational Structural/Hydraulic Repairman'),
('7225','Aircraft Non-Destructive Inspection Technician'),
('7226','A/F-27T-10 Operator/Maintainer'),
('AM','Aviation Structural Mechanic'),
('AME','Aviation Structural Mechanic, Safety Equipment'),
('AMH','Aviation Structural Mechanic, Hydraulics'),
('AMS','Aviation Structural Mechanic, Structures'),
('160400','Aircraft Launch Equipment'),
('7011','Expeditionary Airfield Systems Technician'),
('001030','Aviation Fuels Below Deck Operations Technician'),
('001085','Aviation Fuels Flight Deck Operations Technician'),
('001140','Aviation Fuels Shore Base Operations Technician'),
('001195','Aircraft Director'),
('001250','Crash and Salvage Fire Fighter'),
('001555','Air Operations Technician'),
('002506','Arresting Gear Technician'),
('002584','Catapult Technician'),
('7002','C-7/11 Catapult Operator'),
('7003','C-13 Catapult Operator'),
('7004','C-13 Catapult Operator'),
('7005','MK-7 Arresting Gear Operator'),
('7006','Aircraft Launch and Recovery Equipment Maintenance Technician'),
('7008','Planning Series - Advanced Arresting Gear Operator'),
('7013','Steam Catapultman'),
('7015','Arresting Gear Maintenanceman'),
('AB','Aviation Boatswain''s Mate'),
('ABE','Aviation Boatswain''s Mate, Launching & Recovery Equipment'),
('ABF','Aviation Boatswain''s Mate, Fuels'),
('ABH','Aviation Boatswain''s Mate, Aircraft Handling'),
('161','Automotive'),
('52X','Special Purpose Equipment Repairer'),
('63A','Mechanical Maintenance Helper'),
('63B','Wheeled Vehicle Mechanic'),
('63F','Recovery Specialist'),
('63G','Fuel & Electrical System Repairer'),
('63S','Heavy Wheel Vehicle Mechanic'),
('63W','Wheel Vehicle Repairer'),
('63X','Maintenance Supervisor'),
('63Z','Mechanical Maintenance Supervisor'),
('91B','Wheeled Vehicle Repairer'),
('91S','STRYKER Systems Maintainer'),
('91X','Maintenance Supervisor'),
('91Z','Senior Maintenance Supervisor'),
('161000','Automotive, General'),
('2T331','Vehicle And Vehicular Equipment Maintenance Apprentice'),
('2T332A','Special Vehicle Maintenance Apprentice, Fire Fighting Vehicles'),
('2T332B','Special Vehicle Maintenance Apprentice, Refueling Vehicles'),
('2T332C','Special Vehicle Maintenance, Apprentice, 463L Material Handling Equipment (MHE)'),
('2T334','General Purpose Vehicle Maintenance Apprentice'),
('2T351','Vehicle And Vehicular Equipment Maintenance Journeyman'),
('2T352A','Special Vehicle Maintenance Journeyman, Fire Fighting Vehicles'),
('2T352B','Special Vehicle Maintenance Journeyman, Refueling Vehicles'),
('2T352C','Special Vehicle Maintenance, Journeyman, 463L Material Handling Equipment (MHE)'),
('2T354','General Purpose Vehicle Maintenance Journeyman'),
('2T370','Vehicle And Vehicular Equipment Maintenance Craftsman'),
('2T431','General Purpose Vehicle Mechanic Apprentice'),
('2T451','General Purpose Vehicle Mechanic Journeyman'),
('47231','Special Vehicle Mechanic'),
('47232','General Purpose Vehicle Mechanic'),
('47251','Special Vehicle Mechanic'),
('47252','General Purpose Vehicle Mechanic'),
('47271','Special Purpose Vehicle and Equipment Supervisor'),
('47272','General Purpose Vehicle Mechanic'),
('5806','Mobile Equipment Servicing'),
('5823','Automotive Mechanic'),
('5876','Electromotive Equipment Mechanic'),
('3516','Automotive Mechanic'),
('3521','Automotive Maintenance Technician'),
('3522','Automotive Intermediate Maintenance Technician'),
('3523','Vehicle Recovery Mechanic'),
('3523','Logistics Vehicle System Mechanic'),
('3524','Fuel and Electrical Systems Mechanic'),
('3525','Crash /Fire/ Rescue Vehicle Mechanic'),
('3526','Crash/Fire/Rescue Vehicle Technician'),
('3529','Motor Transport Maintenance Chief'),
('6072','Aircraft Maintenance Support Equipment Hydraulic/Pneumatic/Structures Mechanic'),
('6079','Aircraft Maintenance Ground Support Equipment Chief'),
('5801','Automatic Transmission/Hydraulic Systems Mechanic'),
('5802','Automotive Electrical Technician'),
('5805','Advanced Construction Mechanic'),
('5810','Advanced Diagnostics Shop Management'),
('EQ','Master Chief Equipmentman'),
('63A','M1 ABRAMS Tank System Maintainer'),
('63C','Track Vehicle Mechanic'),
('63D','Artillery Mechanic'),
('63E','M1 ABRAMS Tank System Mechanic'),
('63H','Track Vehicle Repairer'),
('63M','BRADLEY Fighting Vehicle System Maintainer'),
('63N','M60A1/A3 Tank System Mechanic'),
('63R','M60A2 Tank System Mechanic'),
('63T','BRADLEY Fighting Vehicle System Mechanic'),
('63Y','Track Vehicle Mechanic'),
('91A','M1 Abrams Tank System Maintainer'),
('91H','Tracked Vehicle Repairer'),
('91M','BRADLEY Fighting Vehicle System Maintainer'),
('91P','Self Propelled Artillery Systems Maintainer'),
('161100','Tracked Vehicles'),
('2141','Assault Amphibious Vehicle (AAV) Repairer/Technician'),
('2142','Tracked Vehicle Repairer, Assault Amphibian Vehicle'),
('2143','Self-Propelled Artillery (SPARTY) Repairer/Technician')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO

PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 17...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('2144','Tracked Vehicle Repairer, Self-Propelled Artillery'),
('2145','Combat Tank Repairer/Technician'),
('2146','Main Battle Tank (MBT) Repairer/Technician'),
('2147','Light Armored Vehicle (LAV) Repairer/Technician'),
('2148','Expeditionary Fighting Vehicle (EFV) Repairer/Technician'),
('2149','Ordnance Vehicle Maintenance Chief'),
('2193','Tracked Vehicle Chief'),
('62B','Construction Equipment Repairer'),
('91L','Construction Equipment Repairer'),
('161200','Construction Equipment'),
('47230','Special Purpose Vehicle & Equipment Mechanic'),
('47250','Special Purpose Vehicle & Equipment Mechanic'),
('47270','Special Purpose Vehicle & Equipment Mechanic'),
('5801','Miscellaneous Transportation/Mobile Equipment Maintenance'),
('5803','Heavy Mobile Equipment Mechanic'),
('1341','Engineer Equipment Mechanic'),
('1343','Assault Breacher Vehicle/Joint Assault Bridge (JAB) Mechanic'),
('1349','Engineer Equipment Chief'),
('1379','Engineer Operations Chief'),
('002604','Construction Mechanic'),
('CM','Construction Mechanic'),
('EQ','Equipmentman'),
('162','Wire Communications'),
('162000','Wire Communications, General'),
('6049','Aviation Data Analyst'),
('25L','Cable Systems Installer-Maintainer'),
('31L','Cable Systems Installer-Maintainer'),
('36C','Wire Systems Installer'),
('36D','Antenna Installer Specialist'),
('36E','Cable Splicer'),
('36K','Tactical Wire Operations Specialist'),
('36M','Switching Systems Operator'),
('162100','Linemen'),
('1B137','Cable and Antenna Systems Apprentice'),
('1B157','Cable and Antenna Systems Journeyman'),
('1B177','Cable and Antenna Systems Craftsman'),
('2E600','Telephone and Distributed Communications System Manager'),
('2E631','Communications Antenna Systems Apprentice'),
('2E632','Communications Cable and Antenna Systems Apprentice'),
('2E651','Communications Antenna Systems Journeyman'),
('2E652','Communications Cable and Antenna Systems Journeyman'),
('2E671','Communications Antenna Systems Craftsman'),
('2E672','Communications Cable and Antenna Systems Craftsman'),
('2E690','Telephone and Distributed Communications Systems Superintendent'),
('36130','Antenna Systems Installation/Maintenance Specialist'),
('36131','Communications Cable Systems Installation/Maintenance Specialist'),
('36132','Cable Installation/Maintenance Specialist'),
('36133','Missile Systems Cable Maintenance/Splicing Specialist'),
('36134','Cable Maintenance/Splicing Specialist'),
('36150','Antenna Systems Installation/Maintenance Specialist'),
('36151','Communications Cable Systems Installation/Maintenance Specialist'),
('36152','Cable Installation/Maintenance Specialist'),
('36153','Missile Systems Cable Maintenance/Splicing Specialist'),
('36154','Cable Maintenance/Splicing Specialist'),
('36170','Antenna Systems Installation/Maintenance Specialist'),
('36171','Communications Cable Systems Installation/Maintenance Specialist'),
('36172','Cable Installation/Maintenance Specialist'),
('36173','Missile Systems Cable Maintenance/Splicing Specialist'),
('36174','Cable Maintenance/Splicing Specialist'),
('36194','Outside Wire Installation & Maintenance Superintendent'),
('36199','Antenna & Cable Systems Installation/Maintenance Superintendent'),
('3D137','Cable and Antenna Systems Apprentice'),
('3D157','Cable and Antenna Systems Journeyman'),
('3D177','Cable and Antenna Systems Craftsman'),
('2504','Wire Communications Cable Splicing'),
('2508','Communications Line Installing and Repairing'),
('0612','Tactical Switching Operator'),
('0613','Construction Wireman'),
('0614','Unit Level Circuit Switch (ULCS) Operator/Maintainer'),
('0618','Electronic Switching Operator/Maintainer (DTC)'),
('0619','Telecommunications Systems Chiefs'),
('2511','Wireman'),
('2512','Field Wireman'),
('2513','Construction Wireman'),
('2514','Unit Level Circuit Switch (ULCS) Operator/Maintainer'),
('2514','Unit Level Switchboard Installer/Maintainer'),
('2515','Unit Level Circuit Switch Operator/Maintainer'),
('2519','Wire Chief'),
('2813','Cable Systems Technician'),
('5644','Cable Splicing Technician'),
('29N','Switching Central Repairer'),
('35N','Wire Systems Equipment Repairer'),
('36G','Manual Central Office Repairman'),
('36H','Dial/Manual Central Office Repairer'),
('36L','Transportable Automatic Switching Systems Operator/Maintainer'),
('280','Telephone Technician'),
('281','Telephone Technician - Outside'),
('282','Telephone Technician - Inside'),
('162200','Central Office'),
('2E633','Voice Network Systems Apprentice'),
('2E653','Voice Network Systems Journeyman'),
('2E673','Voice Network Systems Craftsman'),
('2E731','Telephone Switching Systems'),
('2E751','Telephone Switching Systems'),
('2E771','Telephone Switching Systems'),
('36231','Telephone Switching Specialist'),
('36251','Telephone Switching Specialist'),
('36271','Telephone Switching Specialist'),
('3D132','Cyber Transport Systems Apprentice'),
('3D152','Cyber Transport Systems Journeyman'),
('3D172','Cyber Transport Systems Craftsman'),
('2814','Central Office Installer-Repairer'),
('5642','Central Office Exchange Technician'),
('162300','Interior Communications'),
('2E700','Telephone/Cable And Antenna Maintenance Manager'),
('2E732','Missile Control Communications Systems'),
('2E733','Telephone And Data Circuitry Equipment'),
('2E752','Missile Control Communications Systems'),
('2E753','Telephone And Data Circuitry Equipment'),
('2E772','Missile Control Communications Systems'),
('2E773','Telephone And Data Circuitry Equipment'),
('2E790','Telephone Communications Systems'),
('36200','Telephone/Cable & Antenna Maintenance Manager'),
('36233','Missile Control Communications Systems Specialist'),
('36234','Telephone and Data Circuitry Equipment Specialist'),
('36253','Missile Control Communications Systems Specialist'),
('36254','Telephone and Data Circuitry Equipment Specialist'),
('36273','Missile Control Communications Systems Specialist'),
('36274','Telephone and Data Circuitry Equipment Specialist'),
('36294','Telephone Plant Maintenance Superintendent'),
('36299','Telephone and Missile Control Communications Systems Super.'),
('2501','Miscellaneous Wire Communication Equipment Installation and Maintenance'),
('2502','Telecommunications Mechanic'),
('2511','Wire Communications Equipment Installing and Repairing'),
('2811','Telephone Technician'),
('003733','Interior Communication Operator'),
('003734','Interior Communication Technician'),
('003735','Interior Communication Administrator'),
('4703','FFG-7 Class Interior Communications Subsystem Technician'),
('4711','Interior Voice Communications Systems Maintenance Technician'),
('4712','Integrated Voice Communications Technician'),
('4713','MarCom Integrated Voice Communication System (IVCS) Technician'),
('4713','Automatic Telephone Repairmen'),
('4714','Stromberg-Carison Telephone Repairman'),
('4715','DYNALEC Telephone Repairman'),
('4716','Ship''s Service Telephone System (Dimension 2000) PBX Repairman'),
('4717','AN/STC-3(V) Integrated Voice Communications System (IVCS) Maintenance Technician'),
('4718','IC Journeyman'),
('4731','Auxiliary Electrician'),
('4734','Trident Sub Ship Control & Atmosphere Supp Op & Maintenance Tech.'),
('4740','Advanced Integrated Voice Communication Network (IVCN) Maintenance Technician'),
('4741','Basic Integrated Voice Communication Network (IVCN) Maintenance Technician'),
('4755','LSD 41 Console Maintenance'),
('4756','AO 177 Console Maintenance'),
('4757','ARS 50 Console Maintenance'),
('4758','Stabilized Glide Slope Indicator System Maintenance'),
('4771','MK HC-2 MOD 0 (Marshand) Plotting System Technician'),
('4772','MK HC-2 MOD 1/1A (Sperry) Plotting System Technician'),
('4773','PT 512/S (Hartman) Tactical Display Plotting System Technician'),
('4774','MK NC-2 MOD 2/2A Plotting/MK 9 MOD 0/2 DRAI Technician'),
('4775','MK 9 MOD 4 DRAI/MK 6 MOD 4B DRT Technician'),
('4776','MK 9 MOD 4/MK 10 MOD 0 DRAI and MK 6 MOD 4B DRT Technician'),
('4777','MK6 MOD 4D Digital Dead Reckoning Trace (DDRT) Technician'),
('4781','NAMTS Interior Communication Repair Technician'),
('4783','MHC-51CL Console Maintenance'),
('4784','MCM-ICL Console Maintenance'),
('4785','NAMTS Interior Communication Repair Technician, FFG-7 Class Specialization'),
('4786','NAMTS Interior Communication Repair Technician, IVCS (STC-2(V)) Specialization'),
('IC','Interior Communications Electrician'),
('163','Missile Mechanical and Electrical'),
('46L','SERGEANT Electrical-Mechanical Repairman'),
('46N','PERSHING Electrical-Mechanical Repairer'),
('163100','Missile Engine'),
('8675','Liquid Fuel Rocket Engine Mechanic'),
('23R','HAWK Missile System Mechanic'),
('24C','HAWK Firing Section Mechanic'),
('24M','VULCAN System Mechanic'),
('24N','CHAPARRAL System Mechanic'),
('24R','HAWK Master Mechanic'),
('24T','PATRIOT Operator System Mechanic'),
('163200','Missile Mechanic'),
('2M032','Missile And Space Systems Maintenance Apprentice'),
('2M032A','Missile And Space Systems Maintenance Apprentice, ICBM'),
('2M052','Missile And Space Systems Maintenance Journeyman'),
('2M052A','Missile And Space Systems Maintenance, ICBM'),
('2M072','Missile And Space Systems Maintenance Craftsman'),
('2M072A','Missile And Space Systems Maintenance, ICBM'),
('41131','Missile Maintenance Specialist'),
('41151','Missile Maintenance Specialist'),
('41171','Missile Maintenance Specialist'),
('44300','Missile Maintenance Manager'),
('44330','Missile Maintenance Specialist'),
('44350','Missile Maintenance Specialist'),
('44370','Missile Maintenance Specialist'),
('44390','Missile Maintenance Superintendent'),
('44399','Missile Maintenance Superintendent'),
('2875','Small Missile System Technician'),
('62C','Engineer Missile Equipment Specialist'),
('170','Gunner''s Mate'),
('163300','Missile Launch and Support Facilities'),
('2M033','Missile And Space Facilities Apprentice'),
('2M033A','Missile And Space Facilities Apprentice, ICBM'),
('2M053','Missile And Space Facilities Journeyman'),
('2M053A','Missile And Space Facilities, ICBM'),
('2M073','Missile And Space Facilities Craftsman'),
('2M073A','Missile And Space Facilities, ICBM'),
('41132','Missile Facilities Specialist'),
('41133','Missile Pneudraulic Specialist'),
('41134','Missile Liquid Propellant Systems Maintenance Specialist'),
('41152','Missile Facilities Specialist'),
('41153','Missile Pneudraulic Specialist'),
('41154','Missile Liquid Propellant Systems Maintenance Specialist'),
('41172','Missile Facilities Specialist'),
('41173','Missile Pneudraulic Specialist'),
('41174','Missile Liquid Propellant Systems Maintenance Specialist'),
('44230','Missile Pneudraulic Repairman'),
('44250','Missile Pneudraulic Repairman'),
('44270','Missile Pneudraulic Repairman'),
('44331','Missile Pneudraulic Specialist'),
('44351','Missile Pneudraulic Specialist'),
('44371','Missile Pneudraulic Specialist'),
('44500','Missile Facilities/Propellant Systems Manager'),
('44530','Missile Facilities Specialist'),
('44531','Missile Liquid Propellant Systems Maintenance Specialist'),
('44550','Missile Facilities Specialist'),
('44551','Missile Liquid Propellant Systems Maintenance Specialist'),
('44570','Missile Facilities Specialist'),
('44571','Missile Liquid Propellant Systems Maintenance Specialist'),
('44599','Missile Facilities/Propellant Systems Superintendent'),
('54100','Missile Facilities Manager'),
('54130','Missile Facilities Specialist'),
('54150','Missile Facilities Specialist'),
('54170','Missile Facilities Specialist'),
('54199','Missile Facilities Superintendent'),
('164','Armament and Munitions'),
('45A','Armament Maintenance Apprentice'),
('45Z','Armament/Fire Control Maintenance Supervisor'),
('164000','Armament Maintenance, General'),
('6601','Miscellaneous Armament Work'),
('6641','Ordnance Equipment Mechanic'),
('2181','Senior Ground Ordnance Weapons Chief'),
('2191','Ordnance Chief'),
('001537','Tactical Weapons Operator'),
('001542','Tactical Weapons Manager'),
('001547','Tactical Weapons Technician'),
('003749','Torpedo Systems Manager'),
('003750','Torpedo Systems Operator'),
('003751','Torpedo Systems Technician'),
('45B','Small Arms/Artillery Repairer'),
('91F','Small Arms/Artillery Repairer'),
('164100','Small Arms Repair'),
('75331','Gunsmith Technician'),
('75351','Gunsmith Technician'),
('75371','Gunsmith Technician'),
('6610','Small Arms Repairing'),
('2111','Small Arms Repairer/Technician'),
('2112','Precision Weapons Repairer/Technician'),
('45D','Self-Propelled Field Artillery Turret Mechanic'),
('45L','Artillery Repairer'),
('164200','Artillery Repair'),
('6605','Artillery Repairing'),
('2131','Towed Artillery Systems Technician'),
('2192','Weapons Chief'),
('45E','M1 ABRAMS Tank Turret Mechanic'),
('45K','Armament Repairer'),
('45N','M60A1/A3 Tank Turret Mechanic (RC)'),
('45P','SHERIDAN Turret Mechanic'),
('45R','M60A2 Tank Turret Mechanic'),
('45T','BRADLEY Fighting Vehicle System Turret Mechanic'),
('91K','Armament Repairer'),
('164300','Turret Repair'),
('2151','Tank Turret Repairman'),
('55G','Nuclear Weapons Specialist'),
('164400','Nuclear Weapons Maintenance and Assembly'),
('6656','Special Weapons Systems Mechanic'),
('1372','Atomic Demolition Employment Technician'),
('2362','Ground Nuclear Ordnance Technician'),
('5761','Marine Wing Weapons Unit Specialist'),
('6561','Marine Wing Weapons Unit Specialist'),
('8061','Marine Wing Weapons Unit Specialist'),
('8062','Ground Nuclear Weapons Technician'),
('0771','Nuclear Depth Bomb Technician'),
('0926','Warhead Maintenance Specialist'),
('1026','Warhead Maintenance Specialist'),
('1028','TOMAHAWK Cruise Missile Technician'),
('GMT','Gunner''s Mate T (Technician)'),
('WT','Weapons Technician'),
('55A','Ammunition Helper'),
('55B','Ammunition Specialist'),
('55C','Ammunition Specialist'),
('55X','Ammunition Inspector'),
('55Z','Ammunition Supervisor'),
('89A','Ammunition Stock Control and Accounting Specialist'),
('89B','Ammunition Specialist'),
('164500','Ammunition Repair'),
('2W000','Munitions Maintenance Manager'),
('2W031','Munitions Systems Apprentice'),
('2W031A','Munitions Systems Apprentice, Material'),
('2W031B','Munitions Systems Apprentice, Production'),
('2W051','Munitions Systems Journeyman'),
('2W071','Munitions Systems Craftsman'),
('2W091','Munitions Systems Superintendent'),
('46100','Munitions Maintenance Manager'),
('46130','Munitions Systems Specialist'),
('46150','Munitions Systems Specialist'),
('46170','Munitions Systems Specialist'),
('46190','Munitions Systems Superintendent'),
('6501','Miscellaneous Ammunition, Explosives, and Toxic Materials Work'),
('6502','Explosives Operating'),
('2311','Ammunition Technician'),
('15X','AH-64A Armament/Electrical/Avionics Systems Repairer'),
('15X','AH-64A Armament/Electrical Systems Repairer'),
('15Y','AH-64D Armament/Electrical/Avionics Systems Repairer'),
('45J','Aircraft Armament Repairman'),
('45M','Aircraft Armament Subsystem Mechanic'),
('68X','AH-64A Armament/Electrical Systems Repairer'),
('68Y','AH-64D Armament/Electrical/Avionics Systems Repairer'),
('164600','Aviation Ordnance'),
('1A700','Aerial Gunner Manager'),
('1A731','Aerial Gunner Apprentice'),
('1A751','Aerial Gunner Journeyman'),
('1A771','Aerial Gunner Craftsman'),
('1A791','Aerial Gunner, Superintendent'),
('2W100','Aircraft Armament Manager'),
('2W131C','Aircraft Armament Systems Apprentice, A10'),
('2W131D','Aircraft Armament Systems Apprentice, F-4'),
('2W131E','Aircraft Armament Systems Apprentice, F-15'),
('2W131F','Aircraft Armament Systems Apprentice, F-16'),
('2W131H','Aircraft Armament Systems Apprentice, F-111'),
('2W131J','Aircraft Armament Systems Apprentice, F-35'),
('2W131K','Aircraft Armament Systems Apprentice, B-52/B-2'),
('2W131L','Aircraft Armament Systems Apprentice, B-1'),
('2W131N','Aircraft Armament Systems Apprentice, F/A-22'),
('2W131Q','Aircraft Armament Systems Apprentice, RPA (MQ-1/MQ-9)'),
('2W131Z','Aircraft Armament Systems Apprentice, All Other'),
('2W151','Aircraft Armament Systems Journeyman'),
('2W171','Aircraft Armament Systems Craftsman'),
('2W191','Aircraft Armament Systems Superintendent'),
('46200','Aircraft Armament Manager'),
('46230','Aircraft Armament Systems Specialist'),
('46250','Aircraft Armament Systems Specialist'),
('46270','Aircraft Armament Systems Specialist'),
('46290','Aircraft Armament Systems Superintendent'),
('6652','Aircraft Ordnance Systems Mechanic'),
('6521','Aviation Ordnance Munitions Technician, IMA'),
('6531','Aircraft Ordnance Technician'),
('6532','Aircraft Ordnance Technician, A-4/TA-4/OA-4'),
('6533','Aviation Ordnance Chief'),
('6534','Aircraft Ordnance Technician, F-4/RF-4'),
('6535','Aircraft Ordnance Technician, AV-8'),
('6536','Aircraft Ordnance Technician, Rotary Wing/OV-10'),
('6537','Aircraft Ordnance Technician, F/A-18'),
('6538','Aircraft Ordnance Technician, OV-10'),
('6541','Aviation Ordnance Systems Technician'),
('6542','Aviation Ordnance Equipment Repair Technician-Rotary Wing, IMA'),
('6591','Aviation Ordnance Chief'),
('002000','Armament Weapons Support Equipment Technician'),
('002045','Aircraft Armament Equipment Technician'),
('002093','Armorer'),
('002138','Weapons Department Technician'),
('002183','Ammunition Logistics Manager'),
('002228','Squadron Ordnance Technician'),
('002273','Aviation Ordnance Quality Assurance Safety Supervisor'),
('6582','P-3A/B Weapons System OMA Technician'),
('6583','P-3C Sensor Station 1&2 (AQA-7) OMA Technician'),
('6585','P-3C Sensor Station Three (Radar & Display) OMA Technician'),
('6586','P-3C OMA Weapons System Technician'),
('6719','Update III ASUW Improvement Program (AIP) OMA Weapons Systems Technician'),
('6801','Air Launch Weapons Technician'),
('6802','Strike Intermediate Armament Maintenanceman'),
('6803','P-3 Armament/Ordnance IMA Technician'),
('6804','P-3C Armament/Ordnance System OMA Technician'),
('6806','P-3A/B Armament/Ordnance System OMA Technician'),
('6810','Armament Weapons Support Equipment (ASWE) Maintenance Manager'),
('6811','Armament Weapons Support Equipment Technician'),
('6813','Airborne Weapons Technical Manager'),
('AO','Aviation Ordnanceman'),
('164700','Mines and Degaussing'),
('003736','Mine Warfare Specialist'),
('003737','Mine Warfare Manager'),
('1200','Advanced Supervisory Mineman Technician'),
('1201','Mine Test Set Maintenanceman'),
('1202','CAPTOR (MK 60 Mod 0) Weapons System Technician'),
('1203','Submarine Launched Mobile Mine EX-67 MOD 0 Technician'),
('1205','Underwater Mine Test Set Maintenance Technician'),
('1206','Planning Series - Littoral Combat Ship Mine Warfare Mission Package Specialist'),
('1210','Versatile Exercise Mine System (VEMS) Operator'),
('1211','Versatile Exercise Mine System (VEMS) Technician'),
('MN','Mineman'),
('165','Shipboard Propulsion'),
('320','Fireman'),
('165100','Main Propulsion'),
('9826','Able Seaman Maintenance'),
('9855','Oiler'),
('9856','Oiler (Diesel)'),
('9858','Fireman (Oil)'),
('9859','Wiper'),
('9895','Fireman-Watertender'),
('9925','Able Seaman-Maintenance'),
('9960','Oiler'),
('9961','Oiler-Diesel'),
('9963','Fireman'),
('9964','Fireman-Watertender'),
('9965','Wiper'),
('002689','Fireman'),
('003005','Steam Plant Auxiliary Systems Maintainer'),
('003177','Steam Plant Auxiliary Systems Technician'),
('003651','Steam Plant Auxiliary Systems Manager'),
('003789','Propulsion Plant Mechanical Supervisor'),
('003797','Propulsion Plant Mechanical Manager'),
('003803','Landing Craft Air Cushion Deck Engineer'),
('003804','Landing Craft Air Cushion Engineer'),
('4140','NAMTS Gas Turbine Repair'),
('4146','DDG-M Gas Turbine Mechanical Maintenance Technician'),
('4204','Steam Propulsion Maintenance Supervisor'),
('4206','Shipboard Engineering Plant Program Manager'),
('4208','Automated Electrolytic Oxygen Generator (AEOG) Maintenance Technician'),
('4221','IMA Outside Machine Shop Journeyman'),
('4222','NAMTS Pump Repair'),
('4223','NAMTS Air Conditioning and Refrigeration'),
('4224','Battle Force Intermediate Maintenance Activity (BFIMA) Flex Hose Fabricator'),
('4225','NAMTS Boiler Repair Technician'),
('4226','Battle Force Intermediate Maintenance Activity (BFIMA) Boiler ACC Technician'),
('4297','Propulsion Machinery Technician (600 PSI)'),
('4303','Cummins Diesel Engines Technician'),
('4304','MTU Diesel Technician'),
('4305','Caterpillar Diesel Technician'),
('4306','Caterpillar Electronically Controlled Engine Technician'),
('4308','Causeway Section Powered/Side Loadable Warping Tug (CSP/SLWT) Engineer'),
('4310','ALCO (251C), and General Motors EMD (645) Diesel Engine Technician'),
('4311','Detroit Diesel (16V149TI and V-71) Engine Technician'),
('4312','Master Diesel Mechanic'),
('4313','Outboard Engine Maintenance Technician'),
('4314','Diesel Engine Inspector'),
('4315','Diesel Engine Technicians'),
('4316','MCM 1&2 Propulsion Technician'),
('4317','Diesel Engine Technicians'),
('4318','Diesel Engine Technicians'),
('4319','Surface Ship Diesel Propulsion Apprentice'),
('4329','Surface Ship Diesel Propulsion Operator'),
('4331','IMA Engine Shop Journeyman'),
('4333','Fairbanks Morse (38D 8-1/8) and Colt Pielstick (PC2.5V) Diesel Engine Technician'),
('4334','LSD-41/49 Class Advanced Engineering Control System-Machinery Control System (AECS-MCS) Propulsion Systems Technician'),
('4335','Issotta Fraschini (F.ID-36) and Caterpillar (D-399) Diesel EngTech'),
('4341','Battle Force Intermediate Maintenance Activity (BFIMA) Governor and Injector Repair Technician'),
('4501','Automated Propulsion Control System Operator'),
('4502','Boiler Repairer Technician'),
('4503','Main Propulsion Steam Generating Plant Inspector'),
('4505','Steam Propulsion Maintenance Supervisor'),
('4506','LHA Automated Propulsion Control System Operator'),
('4507','AO-177 Class Ship APS Operator'),
('4508','Electronic Automatic Boiler Controls Console Operator'),
('4509','Electronic Automatic Boiler Controls Maintenance Technician'),
('4510','IMA Boiler Shop Journeyman')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 18....';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('4511','Automatic Combustion Control (Bailey) Maintenanceman'),
('4512','Automatic Combustion Control (Hagen) Maintenanceman'),
('4513','Automatic Combustion Control (General Regulator) Maintenanceman'),
('4515','Pressure-Fired Boiler Operator'),
('4523','1200 PSI Steam-Generating Plant Operator'),
('4524','Steam Propulsion Advanced Maintenance Technician (Phase I)'),
('4531','Automatic Combustion Control Console Operators (Bailey)'),
('4532','Automatic Combustion Control Console Operator (Hagen)'),
('4533','Automatic Combustion Control Console Operator (General Regulator)'),
('4685','LSD-41/49 Class Advanced Engineering Control System (AECS-MCS) Maintenance Technician'),
('4701','Automated Propulsion Control System Maintenance Technician'),
('4702','LHA Automated Propulsion Control System Maintenance Technician'),
('4704','AO-177 Class Ship APS Maintenance Technician'),
('4706','LSD-41 Class Automated Propulsion Control System Maint. Tech.'),
('4707','Machinery Systems Console Maintenance Technician'),
('4709','Mission Briefing System AN/SXQ-8 Maintenance Technician'),
('4738','AN/USQ-82(V) Data Multiplex System Technician'),
('BR','Boilermaker'),
('BT','Boiler Technician'),
('FN','Fireman'),
('MM','Machinist''s Mate'),
('MM(NUC)','Machinist''s Mate (Nuclear)'),
('MM(SUB)','Machinist''s Mate (Submarine)'),
('MM(SURF)','Machinist''s Mate (Surface)'),
('61C','Watercraft Engineer'),
('61E','Amphibian Engineer'),
('88L','Watercraft Engineer'),
('165200','Auxiliaries'),
('2B000','Marine Manager'),
('2B032','Marine Engine'),
('2B052','Marine Engine'),
('2B072','Marine Engine'),
('2B090','Marine'),
('59100','Marine Manager'),
('59131','Marine Engine Specialist'),
('59151','Marine Engine Specialist'),
('59171','Marine Engine Specialist'),
('59191','Marine Superintendent'),
('59199','Marine Superintendent'),
('9846','Pumpman'),
('9853','Engine Utilityman'),
('9854','Evaporator-Utilityman'),
('9880','Utilityman'),
('9953','Deck Engineer Mechanic'),
('9955','Pumpman'),
('9956','Engineman'),
('9957','Engine Utilityman'),
('9958','Evaporator-Utilityman'),
('9985','Steward-Utilityman'),
('001519','Auxiliary Equipment Technician'),
('001524','Auxiliary Equipment Operator'),
('001532','Auxiliary Equipment Manager'),
('003003','Gas Turbine Mechanical Systems Technician'),
('003102','Diesel Engine/Auxiliary Systems Manager'),
('003179','Diesel Engine/Auxiliary Systems Technician'),
('003202','Gas Turbine Electrical Systems Maintainer'),
('003653','Diesel Engine/Auxiliary Systems Maintainer'),
('003654','Gas Turbine Electrical Systems Technician'),
('003698','Gas Turbine Mechanical Systems Maintainer'),
('1204','Submarine Launched Mobile Mine Technician'),
('4101','IMA Gas Turbine Shop Journeyman'),
('4104','GSM (Main Prop) Advance Maintenance Technician'),
('4105','Gas Turbine Maintenance Technician (Mechanical)'),
('4106','GSE Advance Maintenance Technician'),
('4107','GSM (LCAC) Advance Maintenance Technician'),
('4110','DD-963/DDG-993/CG-47 Class Gas Turbine Operator'),
('4111','DD-963/DDG-993/CG-47 Class Gas Turbine Mech Maintenance Technician'),
('4115','DD-963/DDG-993/CG-47 Class Gas Turbine Elec Maintenance Technician'),
('4120','FFG-7 Class Gas Turbine Operator'),
('4121','FFG-7 Class Gas Turbine Mech Maintenance Technician'),
('4122','FFG-7 Class Gas Turbine Elec Maintenance Technician'),
('4123','CG 47 Gas Turbine Electrical Maintenance Technician'),
('4124','CG 47 Gas Turbine Mechanical Maintenance Technician'),
('4125','DDG 51 Gas Turbine Electrical Maintenance Technician'),
('4126','DDG-51 Gas Turbine Mechanical Maintenance Technician'),
('4127','FFG-7 Class Engineering System Technician'),
('4128','FFG-7 Gas Turbine Mechanical Maintenance Technician'),
('4129','FFG-7 Gas Turbine Electrical Maintenance Technician'),
('4130','LCAC Deck Engineer'),
('4131','LCAC Craft Engineer/Assistant Operator'),
('4133','LCAC Mechanical Systems Maintenance Technician'),
('4135','LCAC Electrical Systems Maintenance Technician'),
('4136','Marine Gas Turbine Inspector'),
('4138','Marine Gas Turbine Inspector Electrical (MGTI (EE))'),
('4141','CG Smart Ship Engineering Control System Equipment (ECSE) Operator and Maintenance Technician'),
('4142','NAMTS Heat Exchanger Repair Technician'),
('4143','CG Smart Ship Engineering Control System Equipment (ECSE) Operator and Maintenance Technician'),
('4150','LPD-17 Class Engineering Control System (ECS) Operator'),
('4227','NAMTS Pump Repair'),
('4229','NAMTS Heat Exchanger Repair Technician'),
('4230','SSN/SSBN Auxiliary Equipment Operator'),
('4231','SSN/SSBN Auxiliary Equipment Technician'),
('4232','SSN/SSBN Weapons Equipment Operator'),
('4233','SSN/SSBN Weapons Equipment Technician'),
('4234','SSN 774 Class Advanced Auxiliary Equipment Technician'),
('4235','SSN 751-773 Submarine Vertical Launch System Tube Maintenance Technician'),
('4245','SSN/SSBN Basic Auxiliary Equipment Technician'),
('4246','SSN/SSBN Diesel Engine (Fairbanks-Morse) Maintenance Technician'),
('4247','SSN 719-725 and 750 Submarine Vertical Launch System Tube Maintenance Technician'),
('4252','Electrolytic Oxygen Generator (Model 6L16) Operator/Mechanical Maintainer'),
('4253','Low Pressure Electrolyzer (LPE) Operator'),
('4254','Oxygen Plant Operator/Maintenance Technician'),
('4262','Electrolytic Oxygen Generator (Model 7L16) Operator/Mechanical Technician'),
('4298','Auxiliary Equipment Technician (Surface Ship)'),
('4301','Auxiliary Gas Turbine Technician'),
('4302','PAXMAN Valenta Diesel Engine Operator'),
('4309','Causeway Section (SP/SLWT) Intermediate Level Maintenance Tech.'),
('4322','Patrol Gunboat (PG) Engineer'),
('4324','MCM Propulsion Technician'),
('4339','Surface Ship Diesel Propulsion Plant Supervisor'),
('4340','NAMTS Diesel Engine, Governor, and Injector Repair Technician, Generalist'),
('4342','NAMTS Diesel Engine, Governor and Injector Repair Technician, ALCO (251C) and General Motors EMD (645) Specialization'),
('4343','NAMTS Diesel Engine, Governor and Injector Repair Technician, MCM Propulsion (Isotta Franchini / SOLAR) Specialization'),
('4344','NAMTS Diesel Engine, Governor and Injector Repair Technician, Fairbanks Morse (38D 8-1/8) and Colt Pielstick (PC2.5V) Specialization'),
('4345','16V146TI Diesel Engine/Waste Heat System Technician'),
('4345','BFIMA Diesel Engine, Governor and Injector Repair Tech, LSD-41 Class Propulsion Specialization'),
('4346','NAMTS Diesel Engine, Governor and Injector Repair Technician, FFG-7 Class Auxiliaries Mechanical System Specialization'),
('4355','LAMPS MK III RAST Mechanical Maintenanceman'),
('4361','ARS-50 Class Propulsion Technician'),
('4362','LST 1182 Class Propulsion System Technician'),
('4366','LSD-41 Class Propulsion System Technician'),
('4370','Causeway Lighterage Engineer'),
('4381','FFG-7 Class Auxiliaries Mechanical Subsystem Technician'),
('4382','FFG-7 Class Auxiliaries Mechanical System Technician'),
('4398','Auxiliary Systems Technician'),
('4540','NAMTS Valve Repair Technician'),
('4541','NAMTS Hydraulics Repair Technician'),
('4542','NAMTS Outside Machinist'),
('EN','Engineman'),
('GS','Gas Turbine System Technician'),
('GSE','Gas Turbine System Technician (Electrical)'),
('GSM','Gas Turbine System Technician (Mechanical)'),
('166','Power Generating Equipment'),
('52H','Nuclear Power Plant Mechanic/Operator'),
('52J','Nuclear Power Plant Electrician/Operator'),
('52K','Nuclear Power Plant Instrumentman/Operator'),
('52L','Nuclear Power Plant Process Control Specialist/Operator'),
('52M','Nuclear Power Plant Chief'),
('166100','Nuclear Power'),
('54830','Nuclear Reactor Systems Specialist'),
('54850','Nuclear Reactor Systems Specialist'),
('54870','Nuclear Reactor Systems Specialist'),
('3315','Nuclear Reactor Instrument Systems Mechanic'),
('5481','Nuclear Reactor Operating'),
('003777','Submarine Propulsion Plant Electrical Operator'),
('003778','Surface Propulsion Plant Electrical Operator'),
('003781','Propulsion Plant Mechanical Operator'),
('003783','Surface Reactor Laboratory Operator'),
('003784','Submarine Reactor Laboratory Operator'),
('003785','Submarine Propulsion Plant Electrical Supervisor'),
('003786','Surface Propulsion Plant Electrical Supervisor'),
('003791','Surface Reactor Laboratory Supervisor'),
('003792','Submarine Reactor Laboratory Supervisor'),
('003793','Submarine Propulsion Plant Electrical Manager'),
('003794','Surface Propulsion Plant Electrical Manager'),
('003799','Surface Reactor Laboratory Manager'),
('003800','Submarine Reactor Laboratory Manager'),
('3301','Nuclear Qualified Reactor Department Master Chief (RDMC)'),
('3302','Nuclear Qualified Engineering Department Master Chief (EDMC)'),
('3351','Submarine Nuclear Propulsion Plant Emergency Welder'),
('3353','Submarine Nuclear Propulsion Plant Operator - Reactor Control'),
('3354','Submarine Nuclear Propulsion Plant Operator - Electrical'),
('3355','Submarine Nuclear Propulsion Plant Operator - Mechanical'),
('3356','Submarine Nuclear Propulsion Plant Operator - Engineering Laboratory Technician'),
('3359','Submarine Nuclear Propulsion Plant Operator - Special Category'),
('3361','Submarine Nuclear Propulsion Plant Supervisors-Welder'),
('3363','Submarine Nuclear Propulsion Plant Supervisor - Reactor Control'),
('3364','Submarine Nuclear Propulsion Plant Supervisor-Electrical'),
('3365','Submarine Nuclear Propulsion Plant Supervisor - Mechanical'),
('3366','Submarine Nuclear Propulsion Plant Supervisor - Engineering Laboratory Technician'),
('3371','CVN Propulsion Plant Local Area Network (PPLAN) Administrator'),
('3372','CVN Propulsion Plant Local Area Network (PPLAN) Manager'),
('3373','Nuclear Propulsion Plant Maintenance Supervisor-Electronics'),
('3376','Nuclear Propulsion Plant Maintenance Supervisor-Radiological Controls'),
('3377','Nuclear Propulsion Plant Planner'),
('3383','Surface Ship Nuclear Propulsion Plant Operator - Reactor Control'),
('3384','Surface Ship Nuclear Propulsion Plant Operator - Electrical'),
('3385','Surface Ship Nuclear Propulsion Plant Operator - Mechanical'),
('3386','Surface Ship Nuclear Propulsion Plant Operator - Engineering Laboratory Technician'),
('3389','Surface Ship Nuclear Propulsion Plant Operator - Special Category'),
('3391','Nuclear Power Plant Operator'),
('3393','Surface Ship Nuclear Propulsion Plant Supervisor - Reactor Control'),
('3394','Surface Ship Nuclear Propulsion Plant Supervisor - Electrical'),
('3395','Surface Ship Nuclear Propulsion Plant Supervisor - Mechanical'),
('3396','Surface Ship Nuclear Propulsion Plant Supervisor - Engineering Laboratory Technician'),
('3398','Nuclear Power Plant Operator (Special Category)'),
('9594','Intermediate Maintenance Activity (IMA) Nuclear Worker'),
('9901','Nuclear Propulsion Plant Operator Trainee'),
('12P','Prime Power Production Specialist'),
('21P','Prime Power Production Specialist'),
('52B','Power Generation Equipment Operator/Mechanic'),
('52D','Power-Generation Equipment Repairer'),
('52E','Prime Power Production Specialist'),
('52F','Turbine Engine Driven Generator Repairer'),
('65C','Diesel-Electric Locomotive Repairman'),
('65F','Locomotive Electrician (RC)'),
('88S','Locomotive Electrician (RC)'),
('91D','Power Generation Equipment Repairer'),
('270','Electrician''s Mate'),
('EM','Electrician''s Mate'),
('166200','Electric Power'),
('3E032','Electrical Power Production Apprentice'),
('3E052','Electrical Power Production Journeyman'),
('3E072','Electrical Power Production Craftsman'),
('54232','Electrical Power Production Specialist'),
('54252','Electrical Power Production Specialist'),
('54272','Electrical Power Production Specialist'),
('54330','Electrical Power Production Specialist'),
('54350','Electrical Power Production Specialist'),
('54370','Electrical Power Production Specialist'),
('3725','Battery Repairing'),
('5324','Powerhouse Equipment Repairing'),
('001577','Mobile Utilities Support Equipment Technician'),
('003302','Electrical Systems Technician'),
('003699','Electrical Systems Maintainer'),
('4112','DD-963 Class Electrical Equipment Technician'),
('4145','NAMTS Gas Turbine (Electrical) Repair Technician'),
('4602','Electricians Mate Surface Ship Electrical Advanced Maintenance'),
('4613','IMA Outside Electrical Journeyman'),
('4614','IMA Rubber and Plastics Shop Journeyman'),
('4615','Electrical Motor Rewinder'),
('4616','Noise & Vibration Analyst'),
('4621','IMA Electrical Shop Journeyman'),
('4626','DD-963/LHD-1 Electrical Component Maintenance Technician'),
('4631','FFG-7 Class Auxiliaries Electrical Subsystem Technician'),
('4632','FFG-7 Class Auxiliaries Electrical System Technician'),
('4641','SSN 774 Integrated Low Pressure Electolyzer Equipment Technician'),
('4650','NAMTS Inside Electrical Repair'),
('4651','NAMTS Outside Electrical Repair'),
('4652','NAMTS Inside Electrical Repair Technician'),
('4653','Low Pressure Electrolyzer (LPE) Maintainer'),
('4665','Minehunting Technician'),
('4666','Minesweeping Electrician'),
('4668','UNREP Electrical-Electronics Control Maintenance'),
('4669','UNREP Electrical Component Maintenanceman (United Control)'),
('4672','Steam Catapult Electrician'),
('4674','Oxygen Generating Plant Electrical/Electronic Maintenance Technician'),
('5804','Stationary Diesel Engine Mechanic'),
('EM','Electrician''s Mate'),
('EM(NUC)','Electrician''s Mate (Nuclear)'),
('EM(SUB)','Electrician''s Mate (Submarine)'),
('EM(SURF)','Electrician''s Mate (Surface)'),
('167','Precision Equipment'),
('41B','Topographic Instrument Repair Specialist'),
('41C','FC Instrument Repairer'),
('41J','Office Machine Repairer'),
('167000','Precision Equipment, General'),
('40130','Office Machine Repairman'),
('40131','Tabulating Equipment Repairman'),
('40150','Office Machine Repairman'),
('40151','Tabulating Equipment Repairman'),
('40170','Office Machine Repairman'),
('40171','Tabulating Equipment Repairman'),
('3301','Miscellaneous Instrument Work'),
('3306','Optical Instrument Repairing'),
('3309','Timekeeping Instrument Repairing'),
('3341','Scale Building, Installing and Repairing'),
('3359','Instrument Mechanic'),
('3364','Projection Equipment Repairing'),
('3817','Locksmithing'),
('4001','Miscellaneous Lens and Crystal Work'),
('4005','Optical Element Working'),
('4015','Quartz Crystal Working'),
('4802','Musical Instrument Repairing'),
('4804','Locksmithing'),
('4805','Medical Equipment Repairing'),
('4850','Bearing Reconditioning'),
('1182','Office Machine Repair Specialist'),
('1183','Repair Chief'),
('2171','Electro-Optical Ordnance Repairer'),
('2172','Electro-Optical Equipment Technician'),
('2175','Electro-Optical Ordnance Technician'),
('2182','Ordnance Electronics Equipment Chief'),
('3241','Office Machine Repair Specialist'),
('3242','Office Machine Repair Chief'),
('3253','Repair Chief'),
('1801','IMA Metrology and Mechanical Standards Calibration Shop Journeyman'),
('1808','Oxygen (O2) Cleaning and Calibration Specialist'),
('1809','Standards Maintenance and Repair Technician'),
('1812','Watch & Clock Instrumentman'),
('1820','Physical/Dimensional Calibration Specialist'),
('1821','Precision Measuring Specialist'),
('1903','Optical Repairman (Submarine Periscopes)'),
('1918','Type 18 Submarine Periscope Optical Repairman'),
('4675','Physical/Dimensional Calibration Specialist'),
('4720','Gyro Compass Maintenance'),
('4721','MK 19 Gyrocompass Systems Maintenance Technician'),
('4722','Gyrocompass Technicians'),
('4723','MK 23 Gyrocompass Systems Maintenance Technician'),
('4724','Gyrocompass Technicians'),
('4725','Gyrocompass Technicians'),
('4727','WSN-2 Stabilized Gyrocompass Technician'),
('4745','Optical Landing System Technician'),
('4749','Physical Security Equipment Maintenance Technician'),
('4779','Vertical Short Take-Off and Landing Optical Lens System (VSTOL OLS) Technician'),
('4780','Battle Force Intermediate Maintenance Activity (BFIMA) Gyro Inspection and Repair Technician'),
('4782','Standards Maintenance and Repair Technician'),
('4787','Improved Fresnel Lens Optical Landing System (IFLOLS) Maintenance Technician'),
('9583','Locksmith'),
('9597','Radiac Technician'),
('9617','Navigation Systems Maintenance Technician'),
('9618','Planning Series - AN/URN � 32 Navigational Set, Tactical Air Navigation (TACAN) System Technician'),
('IM','Instrumentman'),
('OM','Opticalman'),
('PI','Precision Instrumentman'),
('168','Aircraft Launch Equipment'),
('168000','Aircraft Launch Equipment, General'),
('169','Other Mechanical and Electrical Equipment'),
('41K','Reproduction Equipment Repair Specialist'),
('54D','Chemical Equipment Repairer'),
('63J','Quartermaster and Chemical Equipment Repairer'),
('63K','QM Heavy Equipment Repairman'),
('65B','Locomotive Repairer (RC)'),
('65D','Railway Car Repairer (RC)'),
('65E','Airbrake Repairer (RC)'),
('88P','Railway Equipment Repairer (RC)'),
('88Q','Railway Car Repairer (RC)'),
('88R','Airbrake Repairer (RC)'),
('91J','Quartermaster and Chemical Equipment Repairer'),
('169000','Other Mechanical and Electrical Equipment, General'),
('1670','Equipment Services'),
('1699','Equipment, Facilities, and Services Student Trainee'),
('4255','Fuel Distribution System Mechanic'),
('4701','Miscellaneous General Maintenance and Operations Work'),
('4716','Railroad Car Repairing'),
('4737','General Equipment Mechanic'),
('4745','Research Laboratory Mechanic'),
('4801','Miscellaneous General Equipment Maintenance'),
('4806','Office Appliance Repairing'),
('4807','Chemical Equipment Repairing'),
('4808','Custodial Equipment Servicing'),
('4812','Saw Reconditioning'),
('4814','Survey Equipment Servicing'),
('4818','Aircraft Survival Flight Equipment Repairing'),
('4819','Bowling Equipment Repairing'),
('4820','Vending Machine Repairing'),
('4839','Film Processing Equipment Repairing'),
('4840','Tool and Equipment Repairing'),
('4844','Bicycle Repairing'),
('4845','Orthopedic Appliance Repairing'),
('4848','Mechanical Parts Repairing'),
('4855','Domestic Appliance Repairing'),
('5301','Miscellaneous Industrial Equipment Maintenance'),
('5307','Shoe Machine Repairing'),
('5310','Kitchen/Bakery Equipment Repairing'),
('5312','Sewing Machine Repairing'),
('5313','Elevator Mechanic'),
('5317','Laundry and Dry Cleaning Equipment Repairing'),
('5318','Lock and Dam Repairing'),
('5320','Coffee Plant Equipment Repairing'),
('5326','Drawbridge Repairing'),
('5330','Printing Equipment Repairing'),
('5333','Sponging Equipment Repairing'),
('5334','Marine Machinery Mechanic'),
('5335','Wind Tunnel Mechanic'),
('5342','Mail Processing Equipment Repairing'),
('5345','Fish Facilities Repairing'),
('5350','Production Machinery Mechanic'),
('5352','Industrial Equipment Mechanic'),
('5364','Door Systems Mechanic'),
('5378','Powered Support Systems Mechanic'),
('8201','Miscellaneous Fluid Systems Maintenance'),
('8255','Pneudraulic Systems Mechanic'),
('8610','Small Engine Mechanic'),
('1670','Equipment Specialist'),
('1699','Equipment and Facilities Management Student Trainee'),
('1542','Reproduction Equipment Repairer'),
('4616','Reproduction Equipment Repairer Specialist'),
('6499','Mobile Facility Technician'),
('4202','EDLCPO Rating Enhancing Shore Duty'),
('4212','IMA Hydraulics Shop Journeyman'),
('4295','UNREP Equipment Mechanic'),
('4296','Shipboard Elevator Hydraulic/Mechanical System Mechanic'),
('4671','Shipboard Elevator Electronic/Electrical Systems Maintenance Tech'),
('4673','LAMPS MK III RAST/HRS Electrical Maintenanceman'),
('4752','Electrolytic Oxygen Generator (Model 6L16) Electrical Technician'),
('4754','Planning Series - Oxygen Generating Plant Electrical/Electronic Maintenance Technician'),
('4762','Electrolytic Oxygen Generator (Model 7L16) Elec. Supp. Technician'),
('4789','NAMTS Interior Communications Repair Technician'),
('9593','Submarine Repairman'),
('17','Craftsworkers'),
('9770','Craftsman'),
('170','Metalworking'),
('44A','Metalworking Apprentice'),
('170000','Metalworking, General'),
('2A600','Systems Manager'),
('2A731','Aircraft Metals Technology Apprentice'),
('2A751','Aircraft Metals Technology Journeyman'),
('2A771','Aircraft Metals Technology Craftsman'),
('2A790','Aircraft Fabrication Superintendent'),
('42700','Fabrication Manager'),
('42799','Fabrication Superintendent'),
('45830','Aircraft Metals Technology Specialist'),
('45850','Aircraft Metals Technology Specialist'),
('45870','Aircraft Metals Technology Specialist'),
('45899','Aircraft Fabrication Superintendent'),
('53195','Metalworking Superintendent'),
('3701','Miscellaneous Metal Processing'),
('3705','Nondestructive Testing'),
('3707','Metalizing'),
('3708','Metal Process Working'),
('3711','Electroplating'),
('3712','Heat Treating'),
('3722','Cold Working'),
('3723','Casting Machine Operating'),
('3727','Buffing and Polishing'),
('3735','Metal Phototransferring'),
('3740','Forgings Heating'),
('3741','Furnace Operating'),
('3744','Refining Equipment Operating'),
('3769','Shot Peening Machine Operating'),
('3801','Miscellaneous Metal Work'),
('3802','Metal Forging'),
('3804','Coppersmithing'),
('3807','Structural/Ornamental Iron Working'),
('3808','Boilermaking'),
('3812','Heavy-Duty Fabricating Machine Operating'),
('3815','Pneumatic Tool Operating'),
('3818','Springmaking'),
('3820','Shipfitting'),
('3830','Blacksmithing'),
('3832','Medal Making'),
('3858','Metal Tank and Radiator Repairing'),
('3869','Metal Forming Machine Operating'),
('3872','Metal Tube Making, Installing and Repairing'),
('4371','Plaster Pattern Casting'),
('4373','Molding'),
('4374','Core Making'),
('1316','Metal Worker'),
('4911','NAMTS Shipfitter'),
('4921','IMA Metal Worker Journeyman'),
('4931','VT, MT and PT Inspector'),
('4932','Radiographer'),
('4933','NDT Radiographic Inspector (Non-Nuclear)'),
('4934','Ultrasonic Inspector'),
('4935','NDT Radiographic Inspector (Nuclear)'),
('4936','NDT Examiner (VT, PT, MT)'),
('4937','NDT Ultrasonic Examiner'),
('4938','NDT Examiner (Nuclear)'),
('4939','NDT Radiographic Examiner'),
('4942','VT MT and PT NDT Inspector'),
('4943','VT MT PT and RT NDT Inspector'),
('4944','VT MT PT and UT Inspector'),
('4945','Journeyman NDT Inspector'),
('4946','Non-Nuclear NDT Examiner'),
('4947','Nuclear NDT Examiner'),
('44C','Welder'),
('170100','Welding'),
('42731','Corrosion Control Specialist'),
('42734','Metals Processing Specialist'),
('42751','Corrosion Control Specialist'),
('42754','Metals Processing Specialist'),
('42771','Corrosion Control Specialist'),
('42774','Metals Processing Specialist'),
('53131','Metals Processing Specialist'),
('53135','Apprentice Non-Destructive Inspection Specialist'),
('53151','Metals Processing Specialist'),
('53155','Non-Destructive Inspection Specialist'),
('53171','Metals Processing Specialist'),
('53175','Non-Destructive Inspection Technician'),
('3702','Flame/Arc Cutting'),
('3703','Welding'),
('3716','Leadburning'),
('3720','Brazing and Soldering'),
('6043','Aircraft Welder'),
('4906','Apprentice Visual Magnetic Particle & Liquid Penetrant Test Inspec'),
('4907','Apprentice Radiographer'),
('4908','Apprentice Radiographic Inspector'),
('4909','Apprentice Ultrasonic Inspector'),
('4954','General Maintenance Welder'),
('4955','Advanced Welder'),
('4956','Nuclear Power Plant Components Welder'),
('7222','Aeronautical Welder'),
('7223','Aircraft & Engine Component Welder'),
('44E','Machinist'),
('91E','Allied Trades Specialist'),
('200','Machinery Technician'),
('301','Machinery Repairman'),
('MK','Machinery Technician'),
('170200','Machinists'),
('42730','Machinist'),
('42750','Machinist'),
('42770','Machinist'),
('53130','Machinist'),
('53150','Machinist'),
('53170','Machinist'),
('3401','Miscellaneous Machine Tool Work'),
('3414','Machining'),
('3416','Toolmaking'),
('3417','Tool Grinding'),
('3422','Power Saw Operating'),
('3428','Die Sinking'),
('3431','Machine Tool Operating'),
('9838','Machinist'),
('9840','Plumber-Machinist'),
('9950','Plumber Machinist'),
('9959','Machinist'),
('2161','Machinist'),
('003156','Machinery Repair Maintainer'),
('003381','Machinery Repair Technician'),
('4401','IMA Inside Machine Shop Journeyman'),
('4402','Advanced Machinery Repairman'),
('4403','Heat Treatment of Metals Machinist'),
('4404','Computer Numerically Controlled Machinist'),
('4405','NAMTS Inside Machinist'),
('4406','NAMTS Inside Machinist'),
('MR','Machinery Repairman'),
('170300','Sheetmetal'),
('53132','Sheet Metal Specialist'),
('53152','Sheet Metal Specialist'),
('53172','Sheet Metal Specialist'),
('55232','Metal Fabricating Specialist'),
('55252','Metal Fabricating Specialist'),
('55272','Metal Fabricating Specialist'),
('3806','Sheet Metal Mechanic'),
('3831','Rolling and Cutting'),
('44B','Metal Worker'),
('61F','Marine Hull Repairer'),
('91W','Metal Worker'),
('170400','Metal Body Repair'),
('2T300','Vehicle Manager'),
('2T335','Vehicle Body Maintenance Apprentice'),
('2T355','Vehicle Body Maintenance Journeyman'),
('2T390','Vehicle Management Superintendent'),
('2T432','Vehicle Body Maintenance Apprentice'),
('2T452','Vehicle Body Maintenance Journeyman'),
('2T470','General Purpose Vehicle And Body Maintenance Craftsman'),
('47200','Vehicle Maintenance Manager'),
('47233','Vehicle Body Mechanic'),
('47253','Vehicle Body Mechanic'),
('47273','Vehicle Body Mechanic'),
('47275','General Purpose Vehicle & Body Maintenance Supervisor'),
('47293','Vehicle Maintenance Superintendent'),
('47299','Vehicle Maintenance Superintendent'),
('3809','Mobile Equipment Metal Mechanic'),
('3513','Body Repair Mechanic'),
('171','Construction'),
('12H','Construction Engineering Supervisor'),
('12X','General Engineering Supervisor'),
('21H','Construction Engineering Supervisor'),
('21X','General Engineering Supervisor'),
('51A','Construction & Utilities Worker'),
('51C','Structures Specialist'),
('51D','Mason'),
('51F','Pipeline Specialist'),
('51H','Construction Engineering Supervisor'),
('51Z','General Engineering Supervisor'),
('57D','Sawyer'),
('312','Shipfitter - Metalsmith'),
('313','Shipfitter - Pipefitter'),
('661','Builder'),
('662','Builder - Heavy'),
('663','Builder - Light'),
('664','Builder - Concrete'),
('711','Construction Mechanic'),
('712','Construction Mechanic - Automotive'),
('713','Construction Mechanic - Construction'),
('171000','Construction, General'),
('3E000','Civil Engineer Manager'),
('3E231','Pavements and Construction Equipment Apprentice'),
('3E251','Pavements and Construction Equipment Journeyman'),
('3E271','Pavements and Construction Equipment Craftsman'),
('3E290','Heavy Repair Superintendent'),
('3E291','Pavements and Construction Equipment Superintendent'),
('3E331','Structural Apprentice'),
('3E351','Structural Journeyman'),
('3E371','Structural Craftsman'),
('3E391','Structural Superintendent'),
('3E631','Operations Management Apprentice'),
('3E651','Operations Management Journeyman'),
('3E671','Operations Management Craftsman'),
('3E691','Operations Management Superintendent'),
('55100','Pavement & Construction Equipment Manager'),
('55130','Pavements Maintenance Specialist'),
('55131','Pavements and Construction Equipment Specialist'),
('55150','Pavements Maintenance Specialist'),
('55151','Pavements and Construction Equipment Specialist'),
('55170','Pavements Maintenance Specialist'),
('55171','Pavements and Construction Equipment Specialist'),
('55191','Pavements & Construction Equipment Superintendent'),
('55200','Structural Manager'),
('55230','Structural Specialist'),
('55231','Masonry Specialist'),
('55233','Masonry Specialist'),
('55234','Protective Coating Specialist'),
('55250','Structural Specialist'),
('55251','Masonry Specialist'),
('55253','Masonry Specialist'),
('55254','Protective Coating Specialist'),
('55270','Structural Specialist'),
('55271','Masonry Specialist'),
('55273','Structural Technician'),
('55274','Protective Coating Specialist'),
('55290','Structural Superintendent'),
('55299','Structural Superintendent'),
('55500','Force Management Manager'),
('55530','Force Management Specialist'),
('55550','Force Management Specialist'),
('55570','Force Management Specialist'),
('55590','Force Management Superintendent'),
('0809','Construction Control Technical'),
('3508','Pipeline Working'),
('3546','Railroad Repairing'),
('3601','Miscellaneous Structural and Finishing Work'),
('3602','Cement Finishing'),
('3603','Masonry'),
('3604','Tile Setting'),
('3605','Plastering'),
('3606','Roofing'),
('3609','Floor Covering Installing'),
('3610','Insulating'),
('3611','Glazing'),
('3653','Asphalt Working'),
('4101','Miscellaneous Painting and Paperhanging'),
('4102','Painting'),
('4103','Paperhanging'),
('5341','Industrial Furnace Building and Repairing'),
('5423','Sandblasting'),
('6510','Blasting'),
('0809','Construction Inspection Technician'),
('001160','Engineering Aide'),
('002594','Builder'),
('002688','Constructionman'),
('5501','Construction Inspector'),
('5502','Quality Controlman'),
('5515','Construction Planner & Estimator Specialist'),
('5708','Blaster'),
('5712','Elevated Causeway System (Modular) Specialist'),
('5901','Concrete Technician'),
('5902','Masonry Technician'),
('5906','Heavy Construction Technician'),
('5907','Advanced Builder'),
('5915','Construction Planner & Estimator Specialist'),
('5933','Basic Underwater Construction Technician Candidate'),
('5933','Master Underwater Construction Diver'),
('6001','Seabee Technical Security Specialist (STSS)'),
('9920','Construction Basic Veteran'),
('BU','Builder'),
('CN','Constructionman'),
('CU','Master Chief Constructionman'),
('EA','Engineering Aid'),
('691','Steelworker'),
('692','Steelworker - Erector'),
('693','Steelworker - Fabricator'),
('171100','Steelworking'),
('3840','Reinforcing Iron Working'),
('001770','Steel Worker'),
('4952','NAMTS Pipefitter'),
('6010','Advanced Steelworker'),
('6015','Welding Supervisor'),
('SW','Steelworker'),
('12W','Carpentry and Masonry Specialist'),
('21W','Carpentry and Masonry Specialist'),
('51B','Carpentry & Masonry Specialist'),
('171200','Woodworking'),
('4601','Miscellaneous Woodwork'),
('4602','Blocking and Bracing'),
('4604','Wood Working'),
('4605','Wood Crafting'),
('4607','Carpentry'),
('4616','Patternmaking'),
('4618','Woodworking Machine Operating'),
('4620','Shoe Last Repairing'),
('4639','Timber Working'),
('4654','Form Block Making'),
('9813','Carpenter'),
('9814','Carpenter (Freighter)'),
('9824','Carpenter''s Mate'),
('9921','Carpenter'),
('9922','Carpenter-Maintenance'),
('12G','Quarrying Specialist (RC)'),
('12N','Horizontal Construction Engineer'),
('12V','Concrete and Asphalt Equipment Operator'),
('21E','Construction Equipment Operator'),
('21F','Crane Operator'),
('21G','Quarrying Specialist (RC)'),
('21J','General Construction Equipment Operator'),
('21N','Construction Equipment Supervisor'),
('21V','Concrete and Asphalt Equipment Operator'),
('62D','Asphalt Equipment Operator'),
('62E','Heavy Construction Equipment Operator'),
('62F','Crane Operator'),
('62G','Quarrying Specialist (RC)'),
('62H','Concrete & Asphalt Equipment Operator'),
('62J','General Construction Equipment Operator'),
('62K','Grader Operator'),
('62L','Wheeled Tractor Operator'),
('62M','Rough Terrain Forklift & Loader Operator'),
('62N','Construction Equipment Supervisor'),
('681','Equipment Operator'),
('682','Equipment Operator - Hauling'),
('683','Equipment Operator - Construction'),
('171300','Construction Equipment Operation'),
('55199','Pavement & Construction Equipment Superintendent'),
('4741','General Equipment Operating'),
('5475','Preparation Plant Operating'),
('5477','Concrete/Mortar Mixer'),
('5478','Portable Equipment Operating'),
('5479','Dredging Equipment Operating'),
('5716','Engineering Equipment Operating'),
('5725','Crane Operating'),
('5729','Drill Rig Operating'),
('5731','Mining/Tunneling Machine Operating'),
('1122','Well Driller'),
('1172','Well Driller'),
('1345','Engineer Equipment Operator'),
('1346','Rock Quarry Operator'),
('001165','Equipment Operator'),
('5707','Water Well Drilling Technician'),
('5710','Advanced Equipment Operator'),
('5711','Crane Operator'),
('5713','Construction Crane Operator'),
('5908','Tool & Equipment Technician'),
('EO','Equipment Operator'),
('172','Utilities'),
('12K','Plumber'),
('21K','Plumber'),
('51J','Heating & Ventilating Specialist'),
('51K','Plumber'),
('51L','Heating & Cooling Specialist'),
('51L','Refrigeration Specialist'),
('51N','Water Treatment & Plumbing Systems Specialist'),
('51P','Utilities Engineering Supervisor'),
('52C','Utilities Equipment Repairer'),
('77W','Water Treatment Specialist'),
('91C','Utilities Equipment Repairer'),
('92W','Water Treatment Specialist'),
('701','Utilitiesman'),
('702','Utilitiesman - Air Conditioning'),
('703','Utilitiesman - Boilerman'),
('704','Utilitiesman - Plumber'),
('705','Utilitiesman - Water and Sanitation'),
('172000','Utilities, General'),
('3E131','Heating, Ventilation, Air Conditioning, and Refrigeration Apprentice'),
('3E151','Heating, Ventilation, Air Conditioning, and Refrigeration Journeyman'),
('3E171','Heating, Ventilation, Air Conditioning, and Refrigeration Craftsman'),
('3E191','Heating, Ventilation, Air Conditioning, and Refrigeration Superintendent'),
('3E431','Water and Fuel Systems Maintenance Apprentice'),
('3E432','Liquid Fuel Systems Maintenance Apprentice'),
('3E433','Pest Management Apprentice'),
('3E451','Water and Fuel Systems Maintenance Journeyman'),
('3E452','Liquid Fuel Systems Maintenance Journeyman'),
('3E453','Pest Management Journeyman'),
('3E471','Water and Fuel Systems Maintenance Craftsman'),
('3E472','Liquid Fuel Systems Maintenance Craftsman'),
('3E473','Pest Management Craftsman'),
('3E490','Infrastructure Systems Superintendent'),
('54500','Heating, Ventilation, Air Conditioning and Refrigeration Manager'),
('54530','Heating, Ventilation, Air Conditioning and Refrigeration Spec'),
('54531','Liquid Fuel Systems Maintenance Specialist'),
('54532','Heating Systems Specialist'),
('54550','Heating, Ventilation, Air Conditioning and Refrigeration Spec'),
('54551','Liquid Fuel Systems Maintenance Specialist'),
('54552','Heating Systems Specialist'),
('54570','Heating, Ventilation, Air Conditioning and Refrigeration Spec'),
('54571','Liquid Fuel Systems Maintenance Specialist'),
('54572','Heating Systems Specialist'),
('54590','Heating, Ventilation, Air Conditioning and Refrigeration Super.'),
('54599','Mechanical Superintendent'),
('54630','Liquid Fuel Systems Maintenance Specialist'),
('54650','Liquid Fuel Systems Maintenance Specialist'),
('54670','Liquid Fuel Systems Maintenance Specialist'),
('54700','Mechanical Manager'),
('54730','Heating Systems Specialist'),
('54750','Heating Systems Specialist'),
('54770','Heating Systems Specialist'),
('54790','Mechanical Superintendent'),
('55235','Plumbing Specialist'),
('55255','Plumbing Specialist'),
('55275','Plumbing Specialist'),
('56600','Utilities Systems Manager'),
('56630','Pest Management Specialist'),
('56631','Utilities Systems Specialist'),
('56632','Liquid Fuel Systems Maintenance Specialist'),
('56650','Pest Management Specialist'),
('56651','Utilities Systems Specialist'),
('56652','Liquid Fuel Systems Maintenance Specialist'),
('56670','Pest Management Specialist'),
('56671','Utilities Systems Specialist'),
('56672','Liquid Fuel Systems Maintenance Specialist'),
('56691','Sanitation Superintendent'),
('56699','Utilities Systems Superintendent'),
('4201','Miscellaneous Plumbing and Pipefitting'),
('4204','Pipefitting'),
('4206','Plumbing'),
('4742','Utility Systems Repairing-Operating'),
('4749','Maintenance Mechanic'),
('5306','Air Conditioning Equipment Mechanic'),
('5309','Heating and Boiler Plant Equipment Mechanic'),
('5401','Miscellaneous Industrial Equipment Operation'),
('5402','Boiler Plant Operating'),
('5403','Incinerator Operating'),
('5406','Utility Systems Operating'),
('5407','Electric Power Controlling'),
('5408','Wastewater Treatment Plant Operating'),
('5409','Water Treatment Plant Operating'),
('5415','Air Conditioning Equipment Operating'),
('5419','Stationary-Engine Operating'),
('5426','Lock and Dam Operating'),
('5427','Chemical Plant Operating'),
('5430','Drawbridge Operating'),
('9835','Refrigeration Engineer (Refrigerated Cargo)'),
('9836','Refrigeration Engineer (Passenger and Dry Cargo)'),
('9837','Refrigeration Engineer (Day)'),
('9839','Plumber'),
('9857','Refrigeration Oiler'),
('9945','Refrigeration Engineer'),
('9946','Second Refrigeration Engineer'),
('9947','Third Refrigeration Engineer'),
('9948','Plumber'),
('9949','Assistant Plumber'),
('9962','Refrigeration Oiler'),
('1121','Plumbing & Water Supply Specialist'),
('1161','Refrigeration and Air Conditioning Technician'),
('1169','Utilities Chief'),
('1171','Water Support Technician'),
('6078','Aircraft Maintenance Ground Support Equipment Refrigeration Mechanic'),
('001797','Utilitiesman'),
('4228','NAMTS Air Conditioning and Refrigeration Technician'),
('4291','Refrigeration and Air Conditioning Systems Technician'),
('4294','Refrigeration & Air Conditioning Mechanic'),
('4941','IMA Pipe Shop Journeyman'),
('6102','Shore-Based Boiler Controls Technician'),
('6104','Shore-Based Refrigeration & Air Conditioning Technician'),
('6105','Advanced Utilitiesman'),
('UC','Master Chief Utilitiesman'),
('UT','Utilitiesman'),
('12Q','Powerline Distribution Specialist (RC)'),
('12R','Interior Electrician'),
('21Q','Powerline Distribution Specialist (RC)'),
('21R','Interior Electrician'),
('51R','Interior Electrician'),
('52G','Transmission & Distribution Specialist (RC)'),
('172100','Electricians'),
('3E031','Electrical Systems Apprentice'),
('3E051','Electrical Systems Journeyman'),
('3E071','Electrical Systems Craftsman'),
('3E090','Facility Systems Superintendent'),
('54200','Electrical Manager'),
('54230','Electrical Systems Specialist'),
('54231','Electric Power Line Specialist'),
('54250','Electrical Systems Specialist'),
('54251','Electric Power Line Specialist'),
('54270','Electrical Systems Specialist'),
('54271','Electric Power Line Specialist'),
('54291','Electrical Superintendent'),
('54299','Electrical Superintendent'),
('54533','CE Control System Technician'),
('54553','CE Control System Technician'),
('54573','CE Control System Technician'),
('2619','Electronic-Mechanical Comm. Equipment Installing and Repairing'),
('2801','Miscellaneous Electrical Installation and Maintenance'),
('2805','Electrician'),
('2810','High Voltage Electrician'),
('2843','Electrical Instrument Repairing'),
('2854','Electrical Equipment Repairing'),
('9833','Chief Electrician (P-2 Turbo-Electric)'),
('9834','Chief Electrician'),
('9847','Assistant Electrician'),
('9848','Electrician (Watch)'),
('9849','Electrician'),
('9850','Electrician (Day)'),
('9851','Electrician-Maintenance'),
('9852','Electrician (Watch P-2 Turbo-Electric)'),
('9939','Chief Electrician'),
('9940','Electrician'),
('9941','Electrician-Maintenance'),
('9942','Second Electrician'),
('9943','Third Electrician'),
('1141','Electrician'),
('1142','Engineer Equipment Electrical Systems Technician'),
('002599','Construction Electrician'),
('5601','Uninterruptible Power Supply (UPS) Maintenance Technician'),
('5632','Shore-Based Powerplant Technician'),
('5633','Mobile Utilities Support Equipment (MUSE) Technician'),
('5635','Advanced Construction Electrician'),
('CE','Construction Electrician'),
('173','Construction Equipment Operation'),
('173000','Construction Equipment Operation, General'),
('174','Lithography'),
('21L','Lithographer'),
('81L','Lithographer'),
('83D','Process Photographer'),
('83E','Photo & Layout Specialist'),
('83F','Printing and Bindery Specialist'),
('83Z','Photolithography Chief'),
('174000','Lithography, General'),
('3R000','Reprographic Manager'),
('3R031','Printing Management Apprentice'),
('3R051','Printing Management Journeyman'),
('3R071','Printing Management Craftsman'),
('3R091','Printing Management Superintendent'),
('70300','Reprographic Manager'),
('70330','Reprographic Specialist'),
('70350','Reprographic Specialist'),
('70370','Reprographic Specialist'),
('70390','Reprographic Superintendent'),
('71130','Duplicating Specialist'),
('71150','Duplicating Specialist'),
('71170','Duplicating Specialist'),
('71330','Printing-Binding Specialist'),
('71331','Photolithography Specialist'),
('71332','Duplicating Specialist'),
('71350','Printing-Binding Specialist'),
('71351','Photolithography Specialist'),
('71352','Duplicating Specialist'),
('71370','Printing-Binding Specialist'),
('71371','Printing Technician'),
('71372','Duplicating Specialist'),
('71392','Printing Superintendent'),
('71399','Printing Superintendent'),
('2090','Printing and Publications'),
('4401','Miscellaneous Printing and Reproduction'),
('4402','Bindery Working'),
('4403','Hand Composing'),
('4405','Film Assembly-Stripping'),
('4406','Letterpress Operating'),
('4407','Linotype Machine Operating'),
('4410','Monotype Casting Machine Operating'),
('4413','Negative Engraving'),
('4414','Offset Photography'),
('4416','Offset Platemaking'),
('4417','Offset Press Operating'),
('4419','Silk Screen Making and Printing'),
('4422','Dot Etching'),
('4425','Photoengraving'),
('4431','Photo Composition Machine Operating'),
('4440','Stereotype Platemaking'),
('4441','Bookbinding'),
('4446','Bank Note Engraving'),
('4447','Sculptural Engraving'),
('4448','Siderographic Transferring'),
('4449','Electrolytic Intaglio Platemaking'),
('4450','Intaglio Die and Plate Finishing'),
('4454','Intaglio Press Operating'),
('1521','Lithographic'),
('1522','Offset Press Operator'),
('1531','Plate Layout Processor'),
('1532','Process Camera Operator'),
('1541','Reproduction Chief'),
('4612','Combat Camera Production Specialist'),
('4615','Combat Lithographer'),
('3601','Lithographic Equipment Repairman'),
('LI','Lithographer'),
('175','Industrial Gas and Fuel Production'),
('53B','Industrial Gas Production Specialist (RC)'),
('53C','Carbon Dioxide-Hydrogen Production Specialist'),
('175000','Industrial Gas and Fuel Production, General'),
('54430','Cryogenic Fluids Production Specialist'),
('54450','Cryogenic Fluids Production Specialist'),
('54470','Cryogenic Fluids Production Specialist'),
('5433','Gas Generating Plant Operating'),
('6074','Cryogenics Equipment Operator'),
('6075','Cryogenics Equipment Operator'),
('4201','Cryogenics Technician, Overseas Shore Based Equipment Operator/Maintainer'),
('4282','High Pressure Cryogenic Technician'),
('4283','High and Low Pressure Cryogenic Technician'),
('176','Fabric, Leather, and Rubber'),
('43J','Textile Repairman'),
('43K','Canvas Repairman'),
('43M','Fabric Repair Specialist'),
('176000','Fabric, Leather, and Rubber, General'),
('2A732','Nondestructive Inspection Apprentice'),
('2A734','Survival Equipment Apprentice'),
('2A752','Nondestructive Inspection Journeyman')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 19...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('2A754','Survival Equipment Journeyman'),
('2A772','Nondestructive Inspection Craftsman'),
('2A774','Survival Equipment Craftsman'),
('42732','Non-Destructive Inspection Specialist'),
('42733','Fabrication & Parachute Specialist'),
('42752','Non-Destructive Inspection Specialist'),
('42753','Fabrication & Parachute Specialist'),
('42772','Non-Destructive Inspection Specialist'),
('42773','Fabrication & Parachute Specialist'),
('45831','Nondestructive Inspection Specialist'),
('45833','Fabrication and Parachute Specialist'),
('45851','Nondestructive Inspection Specialist'),
('45853','Fabrication and Parachute Specialist'),
('45871','Nondestructive Inspection Specialist'),
('45873','Fabrication and Parachute Specialist'),
('58230','Fabric & Rubber Products Specialist'),
('58250','Fabric & Rubber Products Specialist'),
('58270','Fabric & Rubber Products Specialist'),
('58291','Fabric & Rubber Products Superintendent'),
('3101','Miscellaneous Fabric and Leather Work'),
('3103','Shoe Repairing'),
('3105','Fabric Working'),
('3106','Upholstering'),
('3111','Sewing Machine Operating'),
('3113','Marketing and Cutting'),
('3114','Mattress Making and Repairing'),
('3118','Embroidering'),
('3119','Broom and Brush Making'),
('4301','Miscellaneous Pliable Materials Work'),
('4351','Plastic Molding Equipment Operating'),
('4352','Plastic Fabricating'),
('4360','Rubber Products Molding'),
('4361','Rubber Equipment Repairing'),
('4816','Protective and Safety Equipment Fabricating and Repairing'),
('4841','Window Shade Assembling, Installing and Repairing'),
('5421','Rubber Compounding'),
('1181','Fabric Repair Specialist'),
('3211','Fabric Repair Specialist'),
('3212','Fabric Repair Chief'),
('9581','Rubber & Plastics Worker'),
('178','Firefighting and Damage Control'),
('178000','Firefighting and Damage Control, General'),
('179','Other Craftsworkers, N.E.C.'),
('51E','Camouflage Specialist'),
('311','Shipfitter'),
('179000','Other Craftsworkers, N.E.C., General'),
('53134','Corrosion Control Specialist'),
('53154','Corrosion Control Specialist'),
('53174','Corrosion Control Specialist'),
('0001','Trades, Crafts, and Labor'),
('3314','Instrument Making'),
('3736','Circuit Board Making'),
('3816','Engraving'),
('3833','Transfer Engraving'),
('3835','Electron Tube Making'),
('4010','Prescription Eyeglass Making'),
('4157','Instrument Dial Painting'),
('4370','Glassblowing'),
('4714','Model Making'),
('4715','Exhibits Making/Modeling'),
('4717','Boat Building and Repairing'),
('5221','Lofting'),
('5384','Gasdynamic Facility Installing and Repairing'),
('003002','Ship Survivability Systems Maintainer'),
('003004','Hull Systems Maintainer'),
('003021','Ship Survivability Systems Technician'),
('003556','Hull Systems Technician'),
('003763','Maintenance Technician'),
('4811','Senior Enlisted Damage Control Program Management and Training Specialist'),
('4812','NAMTS Watertight Closure Maintenance Technician'),
('4813','NAMTS Watertight Closure Maintenance Technician'),
('4912','NAMTS Sheetmetal Worker'),
('4913','Battle Force Intermediate Maintenance Activity (BFIMA) Flex Hose Fabricator'),
('5101','Patternmaker Journeyman'),
('5201','Molder Journeyman'),
('9523','Floating Drydock Dockmaster'),
('9524','Floating Drydock Ballast Controller'),
('DC','Damage Controlman'),
('HT','Hull Maintenance Technician'),
('ML','Molder'),
('PM','Patternmaker'),
('18','Service and Supply Handlers'),
('9780','Service and Supply Handlers'),
('180','Food Service'),
('00J','Club/Community Activities Manager'),
('92G','Food Service Specialist'),
('94A','Food Service Helper'),
('94B','Food Service Specialist'),
('94D','Baker'),
('94Z','Food Service Supervisor'),
('180000','Food Service, General'),
('3M000','Services Manager'),
('3M031','Services Apprentice'),
('3M051','Services Journeyman'),
('3M071','Services Craftsman'),
('3M091','Services Superintendent'),
('61131','Meatcutter'),
('61151','Meatcutter'),
('61171','Meatcutter'),
('61230','Meatcutter'),
('61250','Meatcutter'),
('61270','Meat Processing Supervisor'),
('61290','Supply Services Superintendent'),
('62130','Baker'),
('62150','Baker'),
('62170','Baker'),
('62200','Food Service Manager'),
('62230','Food Service Specialist'),
('62231','Diet Therapy Specialist'),
('62250','Food Service Specialist'),
('62251','Diet Therapy Specialist'),
('62270','Food Service Specialist'),
('62271','Diet Therapy Specialist'),
('62291','Food Service Superintendent'),
('62299','Food Service Superintendent'),
('62300','Services Manager'),
('62330','Services Specialist'),
('62350','Services Specialist'),
('62370','Services Specialist'),
('62390','Services Superintendent'),
('78100','Morale, Welfare, Recreation, and Services Manager'),
('78130','Morale, Welfare, Recreation, and Services Specialist'),
('78150','Morale, Welfare, Recreation, and Services Specialist'),
('78170','Morale, Welfare, Recreation, and Services Specialist'),
('78190','Morale, Welfare, Recreation, and Services Superintendent'),
('7401','Miscellaneous Food Preparation and Serving'),
('7402','Baking'),
('7404','Cooking'),
('7405','Bartending'),
('7407','Meatcutting'),
('7408','Food Service Working'),
('7411','Livestock Slaughtering'),
('9865','Steward-Cook (Freighter)'),
('9866','Chief Cook'),
('9867','Chief Cook (Freighter)'),
('9871','Baker'),
('9872','Butcher'),
('9873','Cook'),
('9874','Cook-Baker (Freighter)'),
('9875','Night Cook & Baker (Freighter)'),
('9877','Cook (Freighter)'),
('9878','Galleyman'),
('9885','Pantryman'),
('9886','Night Pantryman'),
('9971','Chief Cook'),
('9972','Steward Cook'),
('9973','Second Cook'),
('9974','Third Cook'),
('9975','Assistant Cook'),
('9976','Cook-Baker'),
('9977','Second Cook-Baker'),
('9978','Night Cook and Baker'),
('9979','Steward-Baker'),
('9980','Third Pantryman'),
('9981','Galleyman'),
('3311','Baker'),
('3371','Cook'),
('3381','Food Service Specialist'),
('4132','Club Manager/Treasurer'),
('8033','Quality Assurance Technician (Subsistence)'),
('8915','Food Service Attendant'),
('8922','Food and Hospitality Manager'),
('001007','Leading Culinary Specialist'),
('002609','Culinary Specialist'),
('3116','Commissary Operations Specialist'),
('3117','Commissary Management Specialist'),
('3525','Private Mess Operations, Techniques, and Management'),
('3527','Advanced Culinary Techniques and Management'),
('3529','Wardroom/Galley Supervisor'),
('3530','Public Quarters Enlisted Aide Specialist'),
('3533','Galley/Pantry Watch Captain'),
('3535','Commissary Store Meat & Produce Department Supervisor'),
('3537','Commissary Store Meat Cutter'),
('CS','Culinary Specialist'),
('MS','Mess Management Specialist'),
('00H','Enlisted Aide'),
('180100','Stewards and Enlisted Aides'),
('74200','Open Mess General Manager'),
('74230','Open Mess Management Specialist'),
('74250','Open Mess Management Specialist'),
('74270','Open Mess Management Specialist'),
('74290','Open Mess Management Superintendent'),
('8A200','Enlisted Aide'),
('99102','Airman Aide'),
('99121','Airman Aide'),
('9G000','Enlisted Aide'),
('7420','Waiter'),
('9860','Steward'),
('9861','Steward (Freighter)'),
('9862','Steward (Troop Mess)'),
('9863','Steward (Sanitation)'),
('9864','Stewardess'),
('9868','Yeoman (Steward)'),
('9869','Storekeeper (Steward)'),
('9870','Yeoman-Storekeeper (Steward)'),
('9876','Deck Steward'),
('9879','Messman'),
('9882','Waiter'),
('9883','Room Steward'),
('9884','Messman'),
('9968','Chief Steward'),
('9969','Third Steward'),
('9984','Messman'),
('3372','Marine Aide'),
('3522','Bachelor Quarters Operator'),
('3523','Bachelor Quarters Watch Captain (Journeyman)'),
('3524','Bachelor Quarters Manager'),
('3526','Private Mess Specialist (Journeyman)'),
('3528','Culinary Specialist (Journeyman)'),
('3531','Public Quarters Specialist (Journeyman)'),
('3538','Bachelor Quarters Specialist'),
('181','Motor Transport'),
('64C','Motor Transport Operator'),
('64Z','Transportation Senior Sergeant'),
('88M','Motor Transport Operator'),
('88Z','Transportation Senior Sergeant'),
('181100','Motor Vehicle Operators'),
('2T100','Vehicle Operations Manager'),
('2T131','Vehicle Operations Apprentice'),
('2T151','Vehicle Operations Journeyman'),
('2T171','Vehicle Operations Craftsman'),
('2T191','Vehicle Operations Superintendent'),
('60300','Vehicle Operations Manager'),
('60330','Vehicle Operator/Dispatcher'),
('60350','Vehicle Operator/Dispatcher'),
('60370','Vehicle Operations Supervisor'),
('60390','Vehicle Operations Superintendent'),
('2151','Dispatching'),
('5701','Miscellaneous Transportation/Mobile Equipment Operation'),
('5702','Amphibian Truck Operating'),
('5703','Motor Vehicle Operating'),
('5705','Tractor Operating'),
('5706','Road Sweeper Operating'),
('5767','Airfield Clearing Equipment Operating'),
('2151','Dispatching Technician'),
('3531','Motor Vehicle Operator'),
('3533','Logistics Vehicle System Operator'),
('3534','Semitrailer Refueler Operator'),
('3535','Light Vehicle Operator'),
('3536','Vehicle Recovery Operator'),
('3537','Motor Transport Operations Chief'),
('3538','Licensing Examiner'),
('65H','Locomotive Operator (RC)'),
('65J','Train Crewmember (RC)'),
('65Z','Railway Senior Sergeant (RC)'),
('88U','Railway Operations Crewmember (RC)'),
('88V','Train Crewmember (RC)'),
('88X','Railway Senior Sergeant (RC)'),
('181200','Railway Operators'),
('99704','Train Operator'),
('5736','Braking-Switching and Conducting'),
('5737','Locomotive Engineering'),
('5738','Railroad Maintenance Vehicle Operating'),
('182','Material Receipt, Storage and Issue'),
('76W','Petroleum Supply Specialist'),
('77F','Petroleum Supply Specialist'),
('92F','Petroleum Supply Specialist'),
('182100','Missile Fuel and Petroleum'),
('2F000','Fuels Manager'),
('2F031','Fuels Apprentice'),
('2F051','Fuels Journeyman'),
('2F071','Fuels Craftsman'),
('2F091','Fuels Superintendent'),
('63100','Fuel Manager'),
('63130','Fuels Specialist'),
('63150','Fuels Specialist'),
('63170','Fuels Specialist'),
('63190','Fuels Superintendent'),
('5413','Fuel Distribution System Operating'),
('6511','Missile/Toxic Materials Handling'),
('1391','Bulk Fuel Specialist'),
('7022','Aviation Fuels Maintenance Technician'),
('57H','Cargo Specialist'),
('88H','Cargo Specialist'),
('581','Parachute Rigger'),
('182200','Warehousing and Equipment Handling'),
('2S033','Materiel Storage and Distribution Apprentice'),
('2S053','Materiel Storage and Distribution Journeyman'),
('2S073','Materiel Storage and Distribution Craftsman'),
('60134','Packaging Specialist'),
('60154','Packaging Specialist'),
('60174','Packaging Specialist'),
('60232','Packaging Specialist'),
('60252','Packaging Specialist'),
('60272','Packaging Specialist'),
('64531','Materiel Storage and Distribution Specialist'),
('64551','Materiel Storage and Distribution Specialist'),
('64571','Materiel Storage and Distribution Specialist'),
('64730','Materiel Facilities Specialist'),
('64750','Materiel Facilities Specialist'),
('64770','Materiel Facilities Specialist'),
('1850','Agricultural Warehouse Inspection'),
('1895','Customs Warehouse Officer'),
('3543','Stevedoring'),
('3545','Pier Facilities Working'),
('5210','Rigging'),
('5440','Packaging Machine Operating'),
('5450','Conveyor Operating'),
('5704','Fork Lift Operating'),
('6901','Miscellaneous Warehousing and Stock Handling'),
('6902','Lumber Handling'),
('6903','Coal Handling'),
('6904','Tools and Parts Attending'),
('6907','Materials Handling'),
('6910','Materials Expediting'),
('6912','Materials Examining and Identifying'),
('6967','Personal Flight Equipment Handling'),
('7001','Miscellaneous Packing and Processing'),
('7002','Packing'),
('7004','Preservation Packaging'),
('7006','Preservation Servicing'),
('3051','Warehouse Clerk'),
('3052','Packaging Specialist'),
('3061','Subsistence Supply Clerk'),
('3092','Warehouse Supply Chief'),
('3111','Freight Operations Clerk'),
('3361','Subsistence Supply Clerk'),
('471','Ship''s Serviceman'),
('601','Aviation Storekeeper'),
('182300','Sales Store'),
('3K000','Subsistence Manager'),
('3K031','Subsistence Operations'),
('3K051','Subsistence Operations'),
('3K071','Subsistence Operations'),
('3K091','Subsistence Operations'),
('61100','Services Manager'),
('61130','Services Specialist'),
('61150','Services Specialist'),
('61170','Services Specialist'),
('61199','Services Superintendent'),
('61200','Subsistence Manager'),
('61231','Subsistence Operations Specialist'),
('61251','Subsistence Operations Specialist'),
('61271','Subsistence Operations Specialist'),
('61272','Subsistence Operations Technician'),
('61291','Subsistence Operations Superintendent'),
('61299','Subsistence Operations Superintendent'),
('2091','Sales Store Clerical'),
('6914','Store Working'),
('2091','Sales Store Technician'),
('4131','Exchange Marine'),
('4133','Marine Corps Community Services Marine'),
('4191','Exchange Chief'),
('001727','Retail Operator'),
('001732','Laundry Operator'),
('3111','Automated Afloat Sales and Service Manager'),
('3112','Afloat Sales & Service Specialist'),
('3113','Resale Operations Specialist'),
('3114','Commissary Store Manager'),
('3115','Resale Management Specialist'),
('3131','Ship''s Store Afloat Resale Operations Management (ROM) II Manager'),
('SH','Ship''s Serviceman'),
('183','Law Enforcement'),
('31K','Working Dog Handler'),
('00C','Dog Trainer'),
('31B','Military Police'),
('95B','Military Police'),
('741','Port Security Specialist'),
('ME','Maritime Enforcement Specialist'),
('183000','Law Enforcement, General'),
('3P000','Security Forces Manager'),
('3P031','Security Forces Apprentice'),
('3P031A','Security Forces Apprentice, Military Working Dog Handler'),
('3P031B','Security Forces Apprentice, Combat Arms'),
('3P032','Law Enforcement Apprentice'),
('3P032A','Law Enforcement Apprentice, Military Working Dog Qualified'),
('3P051','Security Forces Journeyman'),
('3P051A','Security Forces Journeyman, Military Working Dog Handler'),
('3P051B','Security Forces Journeyman, Combat Arms'),
('3P052','Law Enforcement Journeyman'),
('3P052A','Law Enforcement Journeyman, Military Working Dog Qualified'),
('3P071','Security Forces Craftsman'),
('3P072','Law Enforcement Craftsman'),
('3P072A','Law Enforcement Craftsman, Military Working Dog Qualified'),
('3P090','Security Police Superintendent'),
('3P091','Security Forces Superintendent'),
('81100','Security Police Manager'),
('81132','Law Enforcement Specialist'),
('81152','Law Enforcement Specialist'),
('81172','Law Enforcement Specialist'),
('81192','Security Police Superintendent'),
('81199','Security Police Superintendent'),
('81230','Law Enforcement Specialist'),
('81250','Law Enforcement Specialist'),
('81270','Law Enforcement Specialist'),
('81271','Law Enforcement & Corrections Supervisor'),
('81291','Security Police Superintendent'),
('8G000','Honor Guard'),
('99129','United States Air Force Honor Guard'),
('99503','United States Air Force Honor Guard'),
('0082','United States Marshal'),
('0083','Police'),
('1812','Game Law Enforcement'),
('1855','Alcohol Tax Technician'),
('1884','Customs Patrol Officer'),
('1891','Customs Enforcement Officer'),
('1893','Customs Marine Officer'),
('1895','Customs and Border Protection'),
('1896','Border Patrol Enforcement'),
('9815','Master-At-Arms'),
('0083','Police Officer and Detective'),
('1812','Game Law Enforcement Specialist and Officer'),
('5811','Military Police'),
('5812','Military Working Dog Handler'),
('5813','Accident Investigator'),
('5814','Physical Security Specialist'),
('5815','Special Reaction Team (SRT) Member'),
('001492','Independent Duty Master-at-Arms'),
('001497','Investigator-Protective Service Specialist'),
('001504','Mobile Security Force Specialist'),
('001509','Security Force Specialist'),
('001514','Trainer-Planner'),
('2001','Chief Master-At-Arms (CMAA)'),
('2002','Military Investigator'),
('2003','Harbor Security Patrol Supervisor'),
('2004','Harbor Security Boat Training Supervisor (HSB TRASUP)'),
('2006','Kennel Master'),
('90IT','GWOT IA/ILO Detainee Operations Interrogator'),
('90IU','GWOT IA/ILO Detainee Operations Interrogator'),
('90MP','GWOT Support Assignment-Military Police (Law and Order Specialist'),
('MA','Master-At-Arms'),
('31E','Internment/Resettlement Specialist'),
('95C','Internment/Resettlement Specialist'),
('183100','Corrections'),
('81131','Apprentice Corrections Specialist'),
('81151','Corrections Specialist'),
('81231','Apprentice Corrections Specialist'),
('81251','Corrections Specialist'),
('8J000','Correctional Custody Supervisor'),
('99702','Correctional Custody Supervisor'),
('0007','Correctional Officer'),
('5831','Correctional Specialist'),
('5832','Correctional Counselor'),
('001487','Corrections Specialist'),
('001910','Correctional Counselor'),
('90DO','Expeditionary Force Detainee Operations GITMO'),
('90DP','GWOT IA/ILO Detainee Operations-Alternate'),
('90DS','Expeditionary Force Detainee/Confinement Operations - Deployed'),
('90DT','GWOT IA/ILOConfinement Operations-Non Deployed'),
('9516','Correctional Counselor'),
('9548','Corrections Specialist'),
('9575','Correctional Custody Specialist Ashore'),
('31D','CID Special Agent'),
('95D','CID Special Agent'),
('401','Investigator'),
('183200','Investigations'),
('7S000','Special Investigations Manager'),
('7S031','Special Investigations Journeyman'),
('7S071','Special Investigations Craftsman'),
('7S091','Special Investigations Superintendent'),
('82100','Special Investigations Manager'),
('82130','Special Investigations Technician'),
('82150','Special Investigations Technician'),
('82170','Special Investigations Technician'),
('82190','Special Investigations Superintendent'),
('1801','General Inspection, Investigation, Enforcement, and Compliance'),
('1802','Compliance Inspection and Support'),
('1805','Investigative Analysis'),
('1810','General Investigation'),
('1816','Immigration Inspection'),
('1831','Securities Compliance Examining'),
('1849','Wage and Hour Investigation'),
('1860','Equal Opportunity Investigation'),
('1890','Customs Inspection'),
('1899','Investigation Student Trainee'),
('1801','Inspection, Investigation, and Compliance'),
('1802','Inspection, Investigation, and Compliance Support'),
('1810','Investigator'),
('1890','Customs Inspector'),
('1899','Investigations Student Trainee'),
('5819','Military Police Law Enforcement Advisor (MPLEA)'),
('5821','Criminal Investigator CID Agent'),
('5822','Forensic Psycho-physiologist (Polygraph Examiner)'),
('003760','Inspector'),
('184','Personal Service'),
('57E','Laundry & Bath Specialist'),
('92S','Shower/Laundry and Clothing Repair Specialist'),
('184000','Laundry and Personal Service, General'),
('6920','Train-Baggage Handling'),
('7301','Miscellaneous Laundry, Dry Cleaning, and Pressing'),
('7304','Laundry Working'),
('7305','Laundry Machine Operating'),
('7306','Pressing'),
('7307','Dry Cleaning'),
('7601','Miscellaneous Personal Services'),
('7603','Barbering'),
('7608','Wardrobe Handling'),
('7640','Bus Attending'),
('7641','Beautician'),
('9881','Linenkeeper'),
('9887','Laundry Foreman'),
('9888','Laundryman'),
('9982','Laundryman'),
('9983','Assistant Laundryman'),
('1173','Hygiene Equipment Repair Specialist'),
('1179','Hygiene Equipment Chief'),
('001737','Barber'),
('3122','Barber'),
('3154','Dry Cleaning Specialist'),
('185','Auxiliary Labor'),
('57A','Duty Soldier'),
('57G','Duty Foreman'),
('65G','Railway Section Repairer (RC)'),
('88T','Railway Section Repairer (RC)'),
('185000','Auxiliary Labor, General'),
('8H000','Airman Dorm Leader'),
('9D000','Dormitory Manager'),
('3501','Miscellaneous General Services and Support Work'),
('3502','Laboring'),
('3506','Student Aid'),
('3511','Laboratory Working'),
('3512','Studio-Property Handling'),
('3513','Coin/Currency Checking'),
('3514','Choker Setting'),
('3566','Custodial Working'),
('4608','Saw Mill Operating'),
('4754','Cemetery Caretaking'),
('4851','Reclamation Working'),
('5201','Miscellaneous Occupations'),
('5220','Shipwright'),
('5323','Oiling and Greasing'),
('5412','Coal Unloader Operating'),
('5414','Baling Machine Operating'),
('5424','Weighing Machine Operating'),
('5435','Carton/Bag Making Machine Operating'),
('5438','Elevator Operating'),
('5444','Food/Feed Processing Equipment Operating'),
('5446','Textile Equipment Operating'),
('5454','Solvent Still Operating'),
('5455','Paper Pulping Machine Operating'),
('5473','Oil Reclamation Equipment Operating'),
('5484','Counting Machine Operating'),
('5485','Aircraft Weight and Balance Operating'),
('5486','Swimming Pool Operating'),
('6941','Bulk Money Handling'),
('6968','Aircraft Freight Loading'),
('7009','Equipment Cleaning'),
('186','Forward Area Equipment Support'),
('15A','Aviation Life Support Systems Repairer'),
('43E','Parachute Rigger'),
('92R','Parachute Rigger'),
('530','Aviation Survivalman'),
('535','Aviation Survival Technician'),
('AST','Aviation Survival Technician'),
('186000','Forward Area Equipment Support, General'),
('12200','Aircrew Life Support Manager'),
('12230','Aircrew Life Support Specialist'),
('12250','Aircrew Life Support Specialist'),
('12270','Aircrew Life Support Specialist'),
('12290','Life Support Superintendent'),
('1P000','Aircrew Flight Equipment Manager'),
('1P031','Aircrew Flight Equipment Apprentice'),
('1P031A','Aircrew Flight Equipment Apprentice, Aircrew Life Support'),
('1P031B','Aircrew Flight Equipment Apprentice, Survival Equipment'),
('1P051','Aircrew Flight Equipment Journeyman'),
('1P071','Aircrew Flight Equipment Craftsman'),
('1P091','Aircrew Flight Equipment Superintendent'),
('1T100','Aircrew Life Support Manager'),
('1T131','Aircrew Life Support Apprentice'),
('1T151','Aircrew Life Support Journeyman'),
('1T171','Aircrew Life Support Craftsman'),
('1T191','Aircrew Life Support Superintendent'),
('58231','Apprentice Parachute Rigger'),
('58251','Parachute Rigger'),
('58271','Parachute Rigger Technician'),
('92200','Aircrew Life Support Manager'),
('92230','Aircrew Life Support Specialist'),
('92250','Aircrew Life Support Specialist'),
('92270','Aircrew Life Support Specialist'),
('7010','Parachute Packing'),
('0451','Airborne and Air Delivery Specialist'),
('6048','Flight Equipment Technician'),
('6060','Flight Equipment Marine'),
('6064','Flight Equipment Marine'),
('7141','Air Delivery Man'),
('001687','Aviation Life Support Systems Training and Acquisition Manager'),
('001692','Aviation Life Support Systems Intermediate Level Technician'),
('001700','Aviation Life Support Systems Organizational Level Technician'),
('001705','Special Operations Parachute Rigger'),
('7353','Special Operations Parachute Rigger'),
('PR','Aircrew Survival Equipmentman'),
('187','Other Services, N.E.C.'),
('187000','Other Services, General'),
('8S000','Missile Facility Manager'),
('5001','Miscellaneous Plant and Animal Work'),
('5002','Farming'),
('5003','Gardening'),
('5026','Pest Controlling'),
('5031','Insects Production Working'),
('5034','Dairy Farming'),
('5035','Livestock Ranching/Wrangling'),
('5042','Tree Trimming and Removing'),
('5048','Animal Caretaking'),
('5230','Airplane Cargo Dropping'),
('5432','Fish Facility Operating'),
('9897','Seaman-Fisherman'),
('9927','Seaman-Fisherman'),
('8016','Special Technical Operations (STO) Chief'),
('8911','Barracks and Grounds Marine'),
('5306','Naval Special Warfare (Combat Service Support)'),
('5307','Naval Special Warfare (Combat Support)'),
('90JS','GWOT/IA Joint Special Operations Task Force Member-Deployed'),
('19','Non-Occupational'),
('190','Patients and Prisoners'),
('09G','National Guard (NG) on Active Duty Medical Hold'),
('09H','U.S. Army Reserve (USAR) on Active Duty Medical Hold'),
('190100','Patients'),
('99002','Patient'),
('99011','Patient'),
('9P000','Patient'),
('001867','Patient'),
('0093','Combat Zone Injury'),
('0096','Navy Wounded Warrior Service Member'),
('190200','Prisoners'),
('99008','Prisoner'),
('99016','Prisoner'),
('9J000','Prisoner'),
('001872','Prisoner'),
('191','Officer Candidates and Students'),
('09Q','Army Legal Immigrant Healthcare Professional Officer Candidate'),
('09S','Commissioned Officer Candidate'),
('09T','Reserve Forces Report Code'),
('09T','College Student Officer Program (CSOP) Army National Guard (RC)'),
('09W','Warrant Officer Candidate'),
('510','Officer Candidate'),
('630','Aviation Cadet'),
('191100','Cadets and Other Officer Candidates'),
('99001','Officer Trainee'),
('99010','Officer Trainee'),
('99018','Air Force Academy Cadet Authorization'),
('99019','Precadet Assignee'),
('99100','Air Force Academy Cadet Authorization'),
('99101','Precadet Assignee'),
('9T100','Officer Trainee'),
('9T200','Precadet Assignee'),
('001825','Officer Candidate, NAC'),
('001830','Officer Candidate, Aviation Officer'),
('001839','Officer Candidate, Civil Engineer'),
('001844','Officer Candidate, Nuclear Propulsion'),
('001849','Officer Candidate, School'),
('001854','Officer Candidate, Midshipman'),
('09B','Trainee, Unassigned'),
('09D','College Trainee'),
('09E','Trainee, Language, Fort Allen PR'),
('09J','GED Completion Program'),
('09M','March 2 Success'),
('09N','Nurse Corps Candidate'),
('09R','Simultaneous Membership Program Participant (RC)'),
('191200','Students'),
('99017','Student Airman Authorization'),
('9917','College Degree - Enlisted'),
('001820','Student'),
('192','Undesignated Occupations'),
('00D','Special Duty Assignment'),
('00F','MOS Immaterial National Guard Bureau (NGB)'),
('00G','MOS Immaterial U.S. Army Reserve (USAR)'),
('00S','Special Duty Assignment AFSC'),
('09C','Trainee, Language'),
('09C','Split Unit Trainee'),
('19A','Armor Recruit'),
('192000','Undesignated Occupations, General'),
('99004','Unclassified Airman'),
('99005','Airman Awaiting Discharge/Separation/Retirement'),
('99006','Airman Awaiting Retraining - Disq. for Reasons Within Control'),
('99007','Airman Ineligible for Local Utilization'),
('99009','Airman Awaiting Retraining-Disqualified for Reasons Beyond Control'),
('99014','Unallotted Airman Authorization'),
('99015','Unclassified Airman'),
('9A000','Enlisted Airman - Disqualified for Reasons Beyond Control'),
('9A100','Enlisted Airman - Disqualified for Reasons Within Control'),
('9A200','Enlisted Airman Awaiting Discharge, Separation, or Retirement for Reasons Within Their Control'),
('9A300','Airman Awaiting Discharge, Separation, or Retirement for Reasons Beyond Their Control'),
('9A400','Disqualified Airman, Return to Duty Program'),
('9A500','Enlisted Airman Temporarily Ineligible for Retraining � Disqualified for Reasons Beyond Control'),
('9F000','First Term Airmen Center (FTAC) NCOIC'),
('9U000','Enlisted Airman Ineligible For Local Utilization'),
('9W000','Wounded Warrior'),
('9W100','Reserved for Future Use'),
('9W200','Combat Wounded Warrior'),
('9W300','Reserved for Future Use'),
('9W400','Wounded Warrior � Limited Assignment Status'),
('9W500','Reserved for Future Use'),
('9W600','Reserved for Future Use'),
('9W700','Reserved for Future Use'),
('9W800','Reserved for Future Use'),
('9W900','Reserved for Future Use'),
('8013','Special Assignment-Enlisted'),
('8014','Billet Designator-Enlisted'),
('8015','College Degree-Enlisted'),
('8071','Special Operations Capability Specialist (SOCS)'),
('8114','Rigid Raiding Craft (RRC)/Rigid Hull Inflatable Boat (RHIB) Coxswain'),
('9900','General Service Marine'),
('9915','Special Assignment-Enlisted'),
('9916','Billet Designator-Enlisted'),
('9919','MAGTF Enlisted Planner'),
('001859','Transient'),
('003715','Foundational Leader'),
('0091','Fit for Continued Naval Service but Not Worldwide Assignable'),
('195','Not Occupationally Qualified'),
('09B','Basic Trainee'),
('09E','WAC Trainee'),
('09U','Unqualified in Authorized Army MOS'),
('11X','Infantry Training Accession Reporting Code'),
('13X','Field Artillery Computer Systems Specialist Training Accession Reporting Code'),
('16X','Air Defense (Reporting Code)'),
('18X','Special Forces Candidate Training Accession Reporting Code'),
('35W','EW/SIGINT Specialty (Linguist) Training Accession Reporting Code'),
('98X','EW/SIGINT Specialty (Linguist) (Reporting Code)'),
('150','Seaman'),
('610','Airman'),
('721','Constructionman'),
('751','Fire and Safety Technician'),
('195000','Not Occupationally Qualified, General'),
('1A011','In-Flight Refueling Helper'),
('1A111','Flight Engineer Helper'),
('1A111B','Flight Engineer Helper, Helicopter'),
('1A111C','Flight Engineer Helper, Performance Qualified'),
('1A211','Aircraft Loadmaster Helper'),
('1A311','Airborne Mission Systems Operator Helper'),
('1A411','Airborne Operations Helper'),
('1A511','Airborne Missions Systems Helper'),
('1A512','Airborne Command And Control Communications Equipment'),
('1A513','Airborne Radar Systems'),
('1A611','Flight Attendant Helper'),
('1A711','Aerial Gunner Helper'),
('1A811','Airborne Cryptologic Language Analyst Helper'),
('1A811A','Airborne Cryptologic Linguist Helper, Germanic'),
('1A811B','Airborne Cryptologic Linguist Helper, Romance'),
('1A811C','Airborne Cryptologic Linguist Helper, Slavic'),
('1A811D','Airborne Cryptologic Linguist Helper, Far East'),
('1A811E','Airborne Cryptologic Linguist Helper, Mid East'),
('1A811F','Airborne Cryptologic Language Analyst Helper, Arabic'),
('1A811G','Airborne Cryptologic Language Analyst Helper, Chinese'),
('1A811H','Airborne Cryptologic Language Analyst Helper, Korean'),
('1A811I','Airborne Cryptologic Language Analyst Helper, Russian'),
('1A811J','Airborne Cryptologic Language Analyst Helper, Spanish'),
('1A811K','Airborne Cryptologic Language Analyst Helper, Persian'),
('1A811L','Airborne Cryptologic Language Analyst Helper, Hebrew'),
('1A811M','Airborne Cryptologic Language Analyst Helper, Pashto'),
('1A811Z','Airborne Cryptologic Language Analyst Helper, Low-Flow'),
('1A812','Airborne Intelligence, Surveillance and Reconnaissance (ISR) Operator Helper'),
('1A911','Special Missions Aviation Helper'),
('1B011','Knowledge Operations Management Helper'),
('1B012','Cyber Systems Operations Helper'),
('1B013','Cyber Surety Helper'),
('1B014','Computer Systems Programming Helper'),
('1B111','Client Systems Helper'),
('1B112','Cyber Transport Systems Helper'),
('1B113','RF Transmission Systems Helper'),
('1B114','Spectrum Operations Helper'),
('1B115','Ground Radar Systems Helper'),
('1B116','Airfield Systems Helper'),
('1B117','Cable and Antenna Systems Helper'),
('1B311','Electronic Warfare Operator Helper'),
('1B411','Network Warfare Operator Helper'),
('1B411','Cyber Warfare Operations Helper'),
('1C011','Airfield Management Helper'),
('1C012','Aviation Resource Management Helper'),
('1C111','Air Traffic Control Helper'),
('1C211','Combat Control Helper'),
('1C311','Command Post Helper'),
('1C411','Tactical Air Control Party (TACP) Helper'),
('1C511','Command and Control Battle Management Operations Helper'),
('1C511A','Aerospace Control And Warning Systems Helper, Manual Systems'),
('1C511B','Aerospace Control And Warning Systems Helper, Sector Operations Control Center'),
('1C511C','Aerospace Control And Warning Systems Helper, Theater Air Control System'),
('1C611','Space Systems Operations Helper'),
('1C711','Airfield Management Helper'),
('1N011','Operations Intelligence Helper'),
('1N012','Target Intelligence'),
('1N111','Imagery Analysis Helper'),
('1N111A','Geospatial Intelligence Helper, Analyst'),
('1N111B','Geospatial Intelligence Helper, Targeteer'),
('1N211','Communication Signals Intelligence Helper'),
('1N211A','Signals Intelligence Analyst Helper, Electronic'),
('1N211C','Signals Intelligence Analyst Helper, Communications'),
('1N311','Cryptologic Language Analyst Helper'),
('1N311A','Germanic Cryptologic Linguist Helper, German'),
('1N311B','Germanic Cryptologic Linguist Helper, Dutch'),
('1N311C','Germanic Cryptologic Linguist Helper, Flemish'),
('1N311D','Germanic Cryptologic Linguist Helper, Swedish'),
('1N311E','Germanic Cryptologic Linguist Helper, Afrikaans'),
('1N311F','Cryptologic Language Analyst Helper, Arabic'),
('1N311G','Cryptologic Language Analyst Helper, Chinese'),
('1N311H','Cryptologic Language Analyst Helper, Korean'),
('1N311I','Cryptologic Language Analyst Helper, Russian'),
('1N311J','Cryptologic Language Analyst Helper, Spanish'),
('1N311K','Cryptologic Language Analyst Helper, Persian'),
('1N311L','Cryptologic Language Analyst Helper, Hebrew'),
('1N311M','Cryptologic Language Analyst Helper, Pashto'),
('1N311N','Cryptologic Language Analyst Helper, Urdu'),
('1N311Z','Cryptologic Language Analyst Helper, Low-Flow'),
('1N312A','Romance Cryptologic Linguist Helper, Spanish (Latin American)'),
('1N312B','Romance Cryptologic Linguist Helper, Portuguese (Latin American)'),
('1N312C','Romance Cryptologic Linguist Helper, French'),
('1N312D','Romance Cryptologic Linguist Helper, Italian'),
('1N312E','Romance Cryptologic Linguist Helper, Romanian'),
('1N312F','Romance Cryptologic Linguist Helper, Haitian-Creole'),
('1N312G','Romance Cryptologic Linguist Helper, Moldovan'),
('1N313A','Slavic Cryptologic Linguist Helper, Russian'),
('1N313B','Slavic Cryptologic Linguist Helper, Polish'),
('1N313C','Slavic Cryptologic Linguist Helper, Czech'),
('1N313D','Slavic Cryptologic Linguist Helper, Serbo-Croatian'),
('1N313E','Slavic Cryptologic Linguist Helper, Belarusian'),
('1N313F','Slavic Cryptologic Linguist Helper, Hungarian'),
('1N313G','Slavic Cryptologic Linguist Helper, Lithuanian'),
('1N313H','Slavic Cryptologic Linguist Helper, Slovenian'),
('1N313J','Slavic Cryptologic Linguist Helper, Bulgarian'),
('1N313K','Slavic Cryptologic Linguist Helper, Ukrainian'),
('1N313L','Slavic Cryptologic Linguist Helper, Macedonian'),
('1N313M','Slavic Cryptologic Linguist Helper, Albanian'),
('1N314A','Far East Cryptologic Linguist Helper, Chinese (Mandarin)'),
('1N314B','Far East Cryptologic Linguist Helper, Vietnamese'),
('1N314C','Far East Cryptologic Linguist Helper, Thai'),
('1N314D','Far East Cryptologic Linguist Helper, Cambodian'),
('1N314E','Far East Cryptologic Linguist Helper, Lao'),
('1N314F','Far East Cryptologic Linguist Helper, Japanese'),
('1N314G','Far East Cryptologic Linguist Helper, Korean'),
('1N314H','Far East Cryptologic Linguist Helper, Chinese (Cantonese)'),
('1N314J','Far East Cryptologic Linguist Helper, Tagalog'),
('1N315A','Mid East Cryptologic Linguist Helper, Arabic'),
('1N315B','Mid East Cryptologic Linguist Helper, Arabic (Syrian)'),
('1N315C','Mid East Cryptologic Linguist Helper, Hebrew'),
('1N315D','Mid East Cryptologic Linguist Helper, Persian (Farsi)'),
('1N315E','Mid East Cryptologic Linguist Helper, Turkish'),
('1N315F','Mid East Cryptologic Linguist Helper, Greek'),
('1N315G','Mid East Cryptologic Linguist Helper, Indonesian'),
('1N315H','Mid East Cryptologic Linguist Helper, Hindi'),
('1N315J','Mid East Cryptologic Linguist Helper, Armenian'),
('1N315K','Mid East Cryptologic Linguist Helper, Azeri'),
('1N315L','Mid East Cryptologic Linguist Helper, Pushtu'),
('1N315M','Mid East Cryptologic Linguist Helper, Georgian'),
('1N315N','Mid East Cryptologic Linguist Helper, Tadzhik'),
('1N315P','Mid East Cryptologic Linguist Helper, Kazakh'),
('1N315Q','Mid East Cryptologic Linguist Helper, Turkmen'),
('1N315R','Mid East Cryptologic Linguist Helper, Uzbek'),
('1N315S','Mid East Cryptologic Linguist Helper, Persian (Dari)'),
('1N315T','Mid East Cryptologic Linguist Helper, Punjabi'),
('1N315V','Mid East Cryptologic Linguist Helper, Sindhi'),
('1N315W','Mid East Cryptologic Linguist Helper, Urdu'),
('1N316A','African Cryptologic Linguist Helper, Swahili'),
('1N316B','African Cryptologic Linguist Helper, Zande'),
('1N316C','African Cryptologic Linguist Helper, Berber (Shawia)'),
('1N316D','African Cryptologic Linguist Helper, Bedawi (Beja)'),
('1N316E','African Cryptologic Linguist Helper, Sidamo'),
('1N316F','African Cryptologic Linguist Helper, Somali'),
('1N316G','African Cryptologic Linguist Helper, Nubian'),
('1N316H','African Cryptologic Linguist Helper, Bari'),
('1N316J','African Cryptologic Linguist Helper, Dinka'),
('1N316K','African Cryptologic Linguist Helper, Nuer'),
('1N316L','African Cryptologic Linguist Helper, Otuho'),
('1N316M','African Cryptologic Linguist Helper, Shilluk'),
('1N316N','African Cryptologic Linguist Helper, Fur'),
('1N316P','African Cryptologic Linguist Helper, Amharic'),
('1N316Q','African Cryptologic Linguist Helper, Aramaic'),
('1N316R','African Cryptologic Linguist Helper, Assyrian'),
('1N316S','African Cryptologic Linguist Helper, Tigre'),
('1N316T','African Cryptologic Linguist Helper, Tigrinya'),
('1N317A','Turkic Cryptologic Linguist Helper, Chechen'),
('1N317B','Turkic Cryptologic Linguist Helper, Circassian'),
('1N317C','Turkic Cryptologic Linguist Helper, Kirgiz'),
('1N317D','Turkic Cryptologic Linguist Helper, Tatar'),
('1N317E','Turkic Cryptologic Linguist Helper, Uighur'),
('1N318A','Polynesian Cryptologic Linguist Helper, Bikol'),
('1N318B','Polynesian Cryptologic Linguist Helper, Cebuano'),
('1N318C','Polynesian Cryptologic Linguist Helper, Ilocano'),
('1N318D','Polynesian Cryptologic Linguist Helper, Javanese'),
('1N318E','Polynesian Cryptologic Linguist Helper, Sudanese'),
('1N318F','Polynesian Cryptologic Linguist Helper, Tausug'),
('1N318G','Polynesian Cryptologic Linguist Helper, Brahui'),
('1N318H','Polynesian Cryptologic Linguist Helper, Telugu'),
('1N318J','Polynesian Cryptologic Linguist Helper, Kanarese'),
('1N318K','Polynesian Cryptologic Linguist Helper, Malayalam'),
('1N318L','Polynesian Cryptologic Linguist Helper, Tamil'),
('1N318M','Polynesian Cryptologic Linguist Helper, Malay'),
('1N319A','Indo-Iranian Cryptologic Linguist Helper, Assamese'),
('1N319B','Indo-Iranian Cryptologic Linguist Helper, Baluchi'),
('1N319C','Indo-Iranian Cryptologic Linguist Helper, Bengali'),
('1N319D','Indo-Iranian Cryptologic Linguist Helper, Bihari'),
('1N319E','Indo-Iranian Cryptologic Linguist Helper, Kurdish (Kurmanji)'),
('1N319F','Indo-Iranian Cryptologic Linguist Helper, Kurdish (Sorani)'),
('1N319G','Indo-Iranian Cryptologic Linguist Helper, Nepali'),
('1N319H','Indo-Iranian Cryptologic Linguist Helper, Sinhala (Singhalese)'),
('1N411','Network Intelligence Analyst Helper'),
('1N411A','Fusion Analyst Helper, Digital Network Analyst'),
('1N411B','Fusion Analyst Helper, Analysis and Production'),
('1N511','Electronic Signals Intelligence Exploitation Helper'),
('1N611','Electronic Systems Security Assessment Helper'),
('1P011','Aircrew Flight Equipment Helper'),
('1P011A','Aircrew Flight Equipment Helper, Aircrew Life Support'),
('1P011B','Aircrew Flight Equipment Helper, Survival Equipment'),
('1S011','Safety Helper'),
('1T011','Survival, Evasion, Resistance, and Escape (SERE) Helper'),
('1T111','Aircrew Life Support Helper'),
('1T211','Pararescue Helper'),
('1U011','Remotely Piloted Aircraft (RPA) Sensor Operator Helper'),
('1W011','Weather Helper'),
('1W011A','Weather Helper, Forecaster'),
('1W011B','Weather Helper, Battlefield Airman'),
('1W011C','Weather Helper, Advanced Battlefield Airman'),
('1W012','Special Operations Weather Helper'),
('2A011A','Avionics Test Station And Components Helper, Avionics Systems, F-15'),
('2A011B','Avionics Test Station And Components Helper, Avionics Systems, All Helicopters and Aircraft (Except F-15)'),
('2A011C','Avionics Test Station And Components Helper, Avionics Sensor Systems, All Helicopters and Aircraft'),
('2A011D','Avionics Test Station And Components Helper, Electronic Warfare Systems, All Helicopters and Aircraft'),
('2A011K','Avionics Test Station And Components Helper, A-10/B-2/C-17/CV-22/F-16/AFSOC Avionics Systems'),
('2A011M','Avionics Test Station And Components Helper, B-1/E-8/F-15 Avionics Systems'),
('2A011P','Avionics Test Station And Components Helper, Avionics Sensor Systems and ElectronicWarfare Systems'),
('2A011S','Avionics Test Station And Components Helper, Avionics Systems'),
('2A111','Avionic Sensors Maintenance Helper'),
('2A112','Avionics Guidance And Control Systems Helper'),
('2A113','Communication And Navigation Systems Helper'),
('2A114','Airborne Surveillance Radar Systems Helper'),
('2A115A','Avionics Support Equipment (SE) Helper, F-4'),
('2A115B','Avionics Support Equipment (SE) Helper, C-5'),
('2A116','Airborne Command Post Communications Equipment'),
('2A117','Electronic Warfare Systems Helper'),
('2A211','Bomb-navigation Systems'),
('2A211','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Helper'),
('2A211A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Communication/Navigation/Mission Systems Helper, CV-22'),
('2A212','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Instrument and Flight Control Systems Helper'),
('2A212','Electronic Warfare Systems Helper'),
('2A213','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Helper'),
('2A213A','Special Operations Forces/Personnel Recovery (SOF/PR) Integrated Electronic Warfare Systems Helper, CV-22'),
('2A311A','A-10, F-15, and U-2 Avionics Systems Helper, Attack Control'),
('2A311B','A-10, F-15, and U-2 Avionics Systems Helper, Instrument And Flight Control'),
('2A311C','A-10, F-15, and U-2 Avionics Systems Helper, Communication, Navigation, And Penetration Aids'),
('2A312','F-16, F-117, RQ-1, CV-22 Avionic Systems Helper'),
('2A312A','F-16 Avionic Systems Helper, Attack Control'),
('2A312A','Integrated Avionics Systems (Attack/Special) Helper, F-22, F-35'),
('2A312B','F-16 Avionic Systems Helper, Instrument And Flight Control'),
('2A312B','Integrated Avionics Systems (Attack/Special) Helper, CV-22, F-16, MQ-1, MQ-9, RQ-4'),
('2A312C','F-16 Avionic Systems Helper, Communication, Navigation, And Penetration Aids'),
('2A313A','Tactical Aircraft Maintenance Helper, F-15'),
('2A313B','Tactical Aircraft Maintenance Helper, F-16'),
('2A313C','Tactical Aircraft Maintenance Helper, F/EF-111'),
('2A313D','Tactical Aircraft Maintenance Helper, F-4'),
('2A313E','Tactical Aircraft Maintenance Helper, A-10/U-2'),
('2A313F','Tactical Aircraft Maintenance Helper, MQ-1, MQ-9, RQ-4'),
('2A313G','Tactical Aircraft Maintenance Helper, T-37/OA-37'),
('2A313H','Tactical Aircraft Maintenance Helper, U-2'),
('2A313J','Tactical Aircraft Maintenance Helper, F-35'),
('2A313K','Tactical Aircraft Maintenance Helper, F-22'),
('2A313L','Tactical Aircraft Maintenance Helper, F-15'),
('2A313M','Tactical Aircraft Maintenance Helper, F-16'),
('2A313Z','Tactical Aircraft Maintenance Helper, All Other'),
('2A314A','Fighter Aircraft Integrated Avionics Helper, A-10/U-2 Avionics'),
('2A314B','Fighter Aircraft Integrated Avionics Helper, F-15 Avionics'),
('2A314C','Fighter Aircraft Integrated Avionics Helper, F-16 Avionics'),
('2A315A','Advanced Fighter Aircraft Integrated Avionics Helper, F-22'),
('2A315B','Advanced Fighter Aircraft Integrated Avionics Helper, F-35'),
('2A315C','Advanced Fighter Aircraft Integrated Avionics Helper, MQ-1, MQ-9, RQ-4'),
('2A317A','Tactical Aircraft Maintenance (5th Generation) Helper, F-22'),
('2A317B','Tactical Aircraft Maintenance (5th Generation) Helper, F-35'),
('2A318A','Remotely Piloted Aircraft Maintenance Helper, MQ-1/MQ-9'),
('2A318B','Remotely Piloted Aircraft Maintenance Helper, RQ-4'),
('2A411','Aircraft Guidance And Control Systems Helper'),
('2A412','Aircraft Communication And Navigation Systems Helper'),
('2A413','Aircraft Command Control Communications and Navigation Systems Helper'),
('2A511A','Airlift/Special Mission Aircraft Maintenance Helper, C-20/C-21/C-22/C-37/C-40/E-4/VC-25'),
('2A511B','Airlift/Special Mission Aircraft Maintenance Helper, C-130/C-27J'),
('2A511C','Aerospace Maintenance Helper, C-5'),
('2A511D','Aerospace Maintenance Helper, C-17'),
('2A511E','Aerospace Maintenance Helper, B-1/B-2'),
('2A511F','Aerospace Maintenance Helper, B-52')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 20...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('2A511G','Aerospace Maintenance Helper, C-18/C-135/E-3/VC-25/VC-137'),
('2A511H','Aerospace Maintenance Helper, KC-10/E-4'),
('2A512','Helicopter Maintenance'),
('2A512A','Helicopter/Tiltrotor Maintenance Helper, MH-53'),
('2A512B','Helicopter/Tiltrotor Aircraft Maintenance Helper, H-60'),
('2A512C','Helicopter/Tiltrotor Maintenance Helper, H-1'),
('2A512D','Helicopter/Tiltrotor Aircraft Maintenance Helper, CV-22'),
('2A513','Mobility Air Forces Electronic Warfare Systems Helper'),
('2A513A','Integrated Avionics Systems (Heavy) Helper, Communication, Navigation, and Mission'),
('2A513B','Integrated Avionics Systems (Heavy) Helper, Instrument And Flight Controls'),
('2A513C','Integrated Avionics Systems (Heavy) Helper, Electronics Warfare'),
('2A513D','Integrated Avionics Systems (Heavy) Helper, Airborne Surveillance Radar Systems'),
('2A514A','Refuel/Bomber Aircraft Maintenance Helper, Any C-135/E-3/E-8'),
('2A514B','Refuel/Bomber Aircraft Maintenance Helper, KC-10'),
('2A514C','Refuel/Bomber Aircraft Maintenance Helper, KC-46'),
('2A514D','Refuel/Bomber Aircraft Maintenance Helper, B-52'),
('2A514E','Refuel/Bomber Aircraft Maintenance Helper, B-1'),
('2A514F','Refuel/Bomber Aircraft Maintenance Helper, B-2'),
('2A611A','Aerospace Propulsion, Jet Engines'),
('2A611B','Aerospace Propulsion Helper, Turboprop And Turboshaft Propulsion'),
('2A611C','Aerospace Propulsion Helper, TF33, CF6, F103, F108, F117, TFE-731, TF34, TF39, PW 2040, F138 Jet Engines'),
('2A611D','Aerospace Propulsion Helper, F100, F119, F135 Jet Engines'),
('2A611E','Aerospace Propulsion Helper, F101, F110, F118 Jet Engines'),
('2A611H','Aerospace Propulsion Helper, Turboprop And Turboshaft Propulsion'),
('2A612','Aerospace Ground Equipment Helper'),
('2A613','Aircrew Egress Systems Helper'),
('2A614','Aircraft Fuel Systems Helper'),
('2A615','Aircraft Hydraulic Systems Helper'),
('2A616','Aircraft Electrical And Environmental Systems Helper'),
('2A711','Aircraft Metals Technology Helper'),
('2A712','Nondestructive Inspection Helper'),
('2A713','Aircraft Structural Maintenance Helper'),
('2A714','Survival Equipment Helper'),
('2A715','Low Observable Aircraft Structural Maintenance Helper'),
('2A811A','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, C-5'),
('2A811B','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, C-17'),
('2A811C','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper,C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A811D','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, C-12/21/27/32/37/38/39/40'),
('2A811F','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, KC-10'),
('2A811G','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, KC-135'),
('2A811H','Mobility Air Forces Integrated Communication/Navigation/Mission Systems Helper, KC-46'),
('2A812A','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, C-5'),
('2A812B','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, C-17'),
('2A812C','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, C-130/ WC-130 (except SOF/PR & EC-130)'),
('2A812D','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, C-12/21/27/32/37/38/39/40'),
('2A812F','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, KC-10'),
('2A812G','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, KC-135'),
('2A812H','Mobility Air Forces Integrated Instrument and Flight Control Systems Helper, KC-46'),
('2A911A','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, E-3'),
('2A911B','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, E-4/VC-25'),
('2A911C','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, E-8'),
('2A911D','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, RC-135'),
('2A911E','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, B-1'),
('2A911F','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, B-2'),
('2A911G','Bomber/Special Integrated Communication/Navigation/Mission Systems Helper, B-52'),
('2A912A','Bomber/Special Integrated Instrument and Flight Control Systems Helper, E-3'),
('2A912B','Bomber/Special Integrated Instrument and Flight Control Systems Helper, E-4/VC-25'),
('2A912C','Bomber/Special Integrated Instrument and Flight Control Systems Helper, E-8'),
('2A912D','Bomber/Special Integrated Instrument and Flight Control Systems Helper, RC-135'),
('2A912E','Bomber/Special Integrated Instrument and Flight Control Systems Helper, B-1'),
('2A912F','Bomber/Special Integrated Instrument and Flight Control Systems Helper, B-2'),
('2A912G','Bomber/Special Integrated Instrument and Flight Control Systems Helper, B-52'),
('2A913A','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, E-3 Radar Surveillance'),
('2A913B','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, E-3 Computer/Electronic Warfare Systems'),
('2A913C','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, E-8'),
('2A913D','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, RC-135/AFISRA Systems/Carry-on EW'),
('2A913E','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, B-1'),
('2A913F','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, B-2'),
('2A913G','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, B-52'),
('2A913H','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, EC-130 Compass Call'),
('2A913J','Bomber/Special Electronic Warfare and Radar Surveillance Integrated Avionics Helper, VC-25'),
('2B011','Seaman'),
('2B012','Marine Engine'),
('2E011','Ground Radar Systems Helper'),
('2E011A','Air Traffic Control Radar, GPN-20/FPN-62'),
('2E011B','Air Traffic Control Radar, GPN-20/GPN-22'),
('2E011C','Air Traffic Control Radar, GPN-12/FPN-61'),
('2E011D','Air Traffic Control Radar, GPN-12/GPN-22'),
('2E011E','Air Traffic Control Radar, MPN-14K/GPN-20/GPN-22'),
('2E012','Aircraft Control And Warning Radar'),
('2E013','Automatic Tracking Radar'),
('2E111','Satellite, Wideband and Telemetry Systems Helper'),
('2E112','Airfield Systems Helper'),
('2E113','Ground Radio Communications Helper'),
('2E114','Visual Imagery and Intrusion Detection Systems Helper'),
('2E211','Network Infrastructure Systems Helper'),
('2E211A','Electronics Computer and Switching Systems Helper, AN/TYQ-23(V)2 Modular Control Equipment (MCE)'),
('2E211B','Electronic Computer and Switching Systems Helper, Airborne Computer Maintenance'),
('2E211C','Electronic Computer and Switching Systems Helper, Strategic Communications Systems'),
('2E211D','Electronic Computer and Switching Systems Helper, AN/FYQ-93 Joint Surveillance System (JSS)'),
('2E211E','Electronic Computer And Switching Systems, General Computer Systems'),
('2E211K','Electronic Computer And Switching Systems, HM-4118/407l'),
('2E211L','Electronic Computer And Switching Systems, SAC Digital Network'),
('2E211M','Electronic Computer And Switching Systems, AN/FYQ-93'),
('2E211P','Electronic Computer And Switching Systems, 490l O/S Autovon'),
('2E211Q','Electronic Computer And Switching Systems, AN/TTC-30 Electronic Switching System'),
('2E211R','Electronic Computer And Switching Systems, 427M Computer Maintenance'),
('2E211T','Electronic Computer And Switching Systems, Airborne Computer Maintenance'),
('2E311','Secure Communications Systems Helper'),
('2E411','Space Systems Helper'),
('2E511','Imagery Systems Maintenance Helper'),
('2E611','Communications Antenna Systems Helper'),
('2E612','Communications Cable and Antenna Systems Helper'),
('2E613','Voice Network Systems Helper'),
('2E711','Telephone Switching Systems'),
('2E712','Missile Control Communications Systems'),
('2E713','Telephone And Data Circuitry Equipment'),
('2E811','Instrumentation And Telemetry Systems Helper'),
('2F011','Fuels Helper'),
('2G011','Logistics Plans Helper'),
('2M011','Missile And Space Systems Electronic Maintenance Helper'),
('2M011A','Missile And Space Systems Electronic Maintenance Helper, ICBM'),
('2M011B','Missile And Space Systems Electronic Maintenance Helper, ALCM'),
('2M012','Missile And Space Systems Maintenance Helper'),
('2M012A','Missile And Space Systems Maintenance Helper, ICBM'),
('2M013','Missile And Space Facilities Helper'),
('2M013A','Missile And Space Facilities Helper, ICBM'),
('2P011','Precision Measurement Equipment Laboratory Helper'),
('2R011','Maintenance Management Analysis Helper'),
('2R111','Maintenance Management Production Helper'),
('2S011','Materiel Management Helper'),
('2S012','Supply Systems Analysis Helper'),
('2S013','Materiel Storage and Distribution Helper'),
('2T011','Traffic Management Helper'),
('2T111','Vehicle Operations Helper'),
('2T211','Air Transportation Helper'),
('2T311','Vehicle And Vehicular Equipment Maintenance Helper'),
('2T312A','Special Vehicle Maintenance Helper, Fire Fighting Vehicles'),
('2T312B','Special Vehicle Maintenance Helper, Refueling Vehicles'),
('2T312C','Special Vehicle Maintenance, Helper, 463L Material Handling Equipment (MHE)'),
('2T313','Vehicle Maintenance Control And Analysis Helper'),
('2T314','General Purpose Vehicle Maintenance Helper'),
('2T315','Vehicle Body Maintenance Helper'),
('2T317','Vehicle Management and Analysis Helper'),
('2T411','General Purpose Vehicle Mechanic Helper'),
('2T412','Vehicle Body Maintenance Helper'),
('2W011','Munitions Systems Helper'),
('2W011A','Munitions Systems Helper, Material'),
('2W011B','Munitions Systems Helper, Production'),
('2W111C','Aircraft Armament Systems Helper, A10'),
('2W111D','Aircraft Armament Systems Helper, F-4'),
('2W111E','Aircraft Armament Systems Helper, F-15'),
('2W111F','Aircraft Armament Systems Helper, F-16'),
('2W111H','Aircraft Armament Systems Helper, F-111'),
('2W111J','Aircraft Armament Systems Helper, F-35'),
('2W111K','Aircraft Armament Systems Helper, B-52/B-2'),
('2W111L','Aircraft Armament Systems Helper, B-1'),
('2W111N','Aircraft Armament Systems Helper, F/A-22'),
('2W111Q','Aircraft Armament Systems Helper, RPA (MQ-1/MQ-9)'),
('2W111Z','Aircraft Armament Systems Helper, All Other'),
('2W211','Nuclear Weapons Helper'),
('3A011','Knowledge Operations Management Helper'),
('3A111','Administration Helper'),
('3C011','Communications - Computer Systems Operations Helper'),
('3C012','Communications - Computer Systems Programming Helper'),
('3C111','Radio Communications Systems Helper'),
('3C112','Electromagnetic Spectrum Management Helper'),
('3C211','Network Integration Helper'),
('3C311','Communications - Computer Systems Planning And Implementation Helper'),
('3D011','Knowledge Management Helper'),
('3D012','Cyber Systems Operations Helper'),
('3D013','Cyber Surety Helper'),
('3D014','Computer Systems Programming Helper'),
('3D111','Client Systems Helper'),
('3D112','Cyber Transport Systems Helper'),
('3D113','RF Transmission Systems Helper'),
('3D114','Spectrum Operations Helper'),
('3D115','Ground Radar Systems Helper'),
('3D116','Airfield Systems Helper'),
('3D117','Cable and Antenna Systems Helper'),
('3E011','Electrical Systems Helper'),
('3E012','Electrical Power Production Helper'),
('3E111','Heating, Ventilation, Air Conditioning, and Refrigeration Helper'),
('3E211','Pavements and Construction Equipment Helper'),
('3E311','Structural Helper'),
('3E411','Water and Fuel Systems Maintenance Helper'),
('3E412','Liquid Fuel Systems Maintenance Helper'),
('3E413','Pest Management Helper'),
('3E511','Engineering Helper'),
('3E611','Operations Management Helper'),
('3E711','Fire Protection Helper'),
('3E811','Explosive Ordnance Disposal Helper'),
('3E911','Emergency Management Helper'),
('3H011','Historian Helper'),
('3K011','Subsistence Operations'),
('3M011','Services Helper'),
('3N011','Public Affairs Helper'),
('3N012','Broadcast Journalist Helper'),
('3N013','Graphic Arts Helper'),
('3N014','Still Photography Helper'),
('3N015','Photojournalist Helper'),
('3N015A','Photojournalist Helper, Journalist'),
('3N015B','Photojournalist Helper, Photographer'),
('3N111A','Regional Band Helper, Clarinet'),
('3N111B','Regional Band Helper, Saxophone'),
('3N111C','Regional Band Helper, Bassoon'),
('3N111D','Regional Band Helper, Oboe'),
('3N111E','Regional Band Helper, Flute or Piccolo'),
('3N111F','Regional Band Helper, French Horn'),
('3N111G','Regional Band Helper, Cornet or Trumpet'),
('3N111H','Regional Band Helper, Baritone or Euphonium'),
('3N111J','Regional Band Helper, Trombone'),
('3N111K','Regional Band Helper, Tuba'),
('3N111L','Regional Band Helper, Percussion'),
('3N111M','Regional Band Helper, Piano'),
('3N111N','Regional Band Helper, Guitar'),
('3N111P','Regional Band Helper, Music Arranger'),
('3N111Q','Regional Band Helper, Bagpipe'),
('3N111R','Regional Band Helper, Vocalist'),
('3N111S','Regional Band Helper, Electric Bass/String Bass'),
('3N111T','Regional Band Helper, Military Band Support (USAF Band)'),
('3N111U','Regional Band Helper, Steel Guitar'),
('3N111V','Regional Band Helper, Audio and Lighting Engineer'),
('3N111Z','Regional Band Helper, Instrumentalist, General (Air National Guard Bands)'),
('3N211','Premier Band Helper'),
('3P011','Security Forces Helper'),
('3P011A','Security Forces Helper, Military Working Dog Handler'),
('3P011B','Security Forces Helper, Combat Arms'),
('3P012','Law Enforcement Helper'),
('3P012A','Law Enforcement Helper, Military Working Dog Qualified'),
('3P111','Combat Arms Training And Maintenance Helper'),
('3P111A','Combat Arms Training And Maintenance Helper, Gunsmith'),
('3R011','Printing Management Helper'),
('3S011','Personnel Helper'),
('3S012','Personnel System Management (PSM) Helper'),
('3S111','Equal Opportunity Helper'),
('3S111A','Social Actions Helper, Equal Opportunity/human Relations'),
('3S111B','Social Actions Helper, Substance Abuse Control'),
('3S211','Education And Training Helper'),
('3S311','Manpower Helper'),
('3S313','Manpower Helper'),
('3U011','Manpower Helper'),
('3V011','Graphic Arts Helper'),
('3V012','Still Photography Helper'),
('3V013','Video Helper'),
('3V111','Imagery Production'),
('4A011','Health Services Management Helper'),
('4A111','Medical Materiel Helper'),
('4A211','Biomedical Equipment Helper'),
('4B011','Bioenvironmental Engineering Helper'),
('4C011','Mental Health Service Helper'),
('4D011','Diet Therapy Helper'),
('4E011','Public Health Helper'),
('4F011','Aeromedical Helper'),
('4H011','Cardiopulmonary Laboratory Helper'),
('4J011','Occupational Therapy Helper'),
('4J012','Physical Medicine Helper'),
('4J012A','Physical Medicine Helper, Orthotic'),
('4M011','Aerospace and Operational Physiology Helper'),
('4N011','Aerospace Medical Service Helper'),
('4N011A','Aerospace Medical Service Helper, Allergy/immunology'),
('4N011B','Aerospace Medical Service Helper, Neurodiagnostic Medical Technician'),
('4N111','Surgical Service Helper'),
('4N111B','Surgical Service Helper, Urology'),
('4N111C','Surgical Service Helper, Orthopedics'),
('4N111D','Surgical Service Helper, Otolaryngology'),
('4P011','Pharmacy Helper'),
('4R011','Diagnostic Imaging Helper'),
('4R011A','Diagnostic Imaging Helper, Nuclear Medicine'),
('4R011B','Diagnostic Imaging Helper, Ultrasound'),
('4R011C','Diagnostic Imaging Helper, Magnetic Resonance Imaging'),
('4R012','Nuclear Medicine'),
('4T011','Medical Laboratory Helper'),
('4T012','Histopathology Helper'),
('4T013','Cytotechnology Helper'),
('4U011','Orthotic Helper'),
('4V011','Optometry Helper'),
('4V011A','Optometry Helper, Ophthalmology'),
('4V011S','Optometry Helper, Ophthalmology'),
('4Y011','Dental Assistant Helper'),
('4Y012','Dental Laboratory Helper'),
('4Y111','Dental Laboratory'),
('5J011','Paralegal Helper'),
('5R011','Chaplain Assistant Helper'),
('6C011','Contracting Helper'),
('6F011','Financial Management and Comptroller Helper'),
('6F012','Financial Services Helper'),
('6F111','Financial Analysis Helper'),
('7S011','Special Investigations Helper'),
('99000','Basic Airman'),
('99003','Unallotted Airman Authorization'),
('9T000','Basic Enlisted Airman'),
('9U100','Unallotted Enlisted Authorization'),
('0100','Basic Personnel and Administration Marine'),
('0200','Basic Intelligence Marine'),
('0300','Basic Infantryman'),
('0400','Basic Logistics Marine'),
('0500','Basic Marine Air Ground Task Force (MAGTF) Plans Marine'),
('0600','Basic Command and Control Systems Marine'),
('0600','Basic Communications Marine'),
('0800','Basic Field Artillery Man'),
('1100','Basic Utilities Marine'),
('1300','Basic Engineer, Construction, and Equipment Marine'),
('1400','Basic Drafting, Surveying and Mapping Marine'),
('1800','Basic Tank and Assault Amphibious Vehicle Crewman'),
('2100','Basic Ground Ordnance Maintenance Marine'),
('2300','Basic Ammunition and Explosive Ordnance Disposal Marine'),
('2500','Basic Operational Communicator'),
('2600','Basic Signals Intelligence/Ground Electronic Warfare Operator'),
('2800','Basic Ground Electronics Maintenance Marine'),
('3000','Basic Supply Administration and Operations Marine'),
('3100','Basic Distribution Management Marine'),
('3200','Basic Supply Services Man'),
('3300','Basic Food Service Marine'),
('3400','Basic Financial Management Marine'),
('3500','Basic Motor Transport Marine'),
('4000','Basic Data Systems Marine'),
('4100','Basic Marine Corps Community Services Marine'),
('4300','Basic Combat Correspondent'),
('4400','Basic Legal Services Marine'),
('4600','Basic Combat Camera Marine'),
('5500','Basic Musician'),
('5700','Basic Chemical, Biological, Radiological, and Nuclear (CBRN) Defense Marine'),
('5800','Basic Military Police and Corrections Marine'),
('5900','Basic Electronics Maintenance Marine'),
('6000','Basic Aircraft Maintenance Marine'),
('6011','Aircraft Mechanic-Trainee'),
('6031','Aircraft Flight Engineer, KC-130-Trainee'),
('6051','Aircraft Airframe Mechanic-Trainee'),
('6071','Aircraft Maintenance Ground Support Equipment (GSE) Mechanic-Trainee'),
('6081','Aircraft Safety Equipment Mechanic-Trainee'),
('6091','Aircraft Intermediate Level Structures Mechanic-Trainee'),
('6111','Helicopter/Tiltrotor Mechanic-Trainee'),
('6151','Helicopter/Tiltrotor Airframe Mechanic-Trainee'),
('6211','Fixed-Wing Aircraft Mechanic-Trainee'),
('6251','Fixed-Wing Aircraft Airframe Mechanic-Trainee'),
('6281','Fixed-Wing Aircraft Safety Equipment Mechanic-Trainee'),
('6300','Basic Avionics Marine'),
('6311','Aircraft Communications/Navigation Electrical/Weapon Systems Technician-Trainee, OMA'),
('6331','Aircraft Electrical Systems Technician-Trainee'),
('6351','Advanced Avionics Technician-Trainee'),
('6371','Aerial Camera Systems Technician-Trainee'),
('6400','Basic Avionics Marine IMA'),
('6500','Basic Aviation Ordnance Marine'),
('6511','Aircraft Ordnance Technician-Trainee'),
('6600','Basic Aviation Supply Marine'),
('6611','A/C Communications/Navigation Systems Technician-Trainee, OMA/IMA'),
('6621','Aircraft Avionics Repair Technician-Trainee'),
('6631','Aircraft Electrical Systems Technician-Trainee'),
('6641','Aircraft Weapon Systems Specialist, Trainee'),
('6800','Basic Meteorology and Oceanography (METOC) Marine'),
('7000','Basic Airfield Services Marine'),
('7200','Basic Air Control/Air Support/Antiair Warfare/Air Traffic Control Marine'),
('7251','Air Traffic Controller-Trainee'),
('7300','Basic Enlisted Flight Crew Marine'),
('7371','Tactical Systems Operator-Trainee'),
('7381','Airborne Radio Operator / In-flight Refueling Observer / Loadmaster Trainee (ARO / IRO / LM)'),
('8000','General Service Marine'),
('8011','Basic Marine With Enlistment Guarantee'),
('9970','Basic Marine, Aviation Enlistment Options Program'),
('9971','Basic Marine With Enlistment Guarantee'),
('9977','Basic Marine, Prior Service Enlistment Incentive Program'),
('9978','Basic Marine, Prior Service Enlistment Incentive Prog. With Bonus'),
('9979','Basic Marine, Ground Enlistment Options Program'),
('0000','No NEC assigned'),
('001877','Holdee'),
('0090','Not Operationally Suitable'),
('00CA','Cryptologic Technician Administrative NEC'),
('00DK','Disbursing Clerk Tracking NEC'),
('00DM','Illustrator Draftsman Tracknig NEC'),
('00JO','Journalist Tracking NEC'),
('00LI','Lithographer Tracking NEC'),
('00PH','Photographer�s Mate Tracking NEC'),
('00SM','Signalman Tracking NEC'),
('00TM','Torpedoman NEC'),
('0199','Boatswain''s Mate Basic'),
('0299','Quartermaster Basic'),
('0399','Operations Specialist Basic'),
('04G9','Sonar Technician (Surface)'),
('04S9','Sonar Technician (Submarine)'),
('0799','Torpedoman''s Mate Basic'),
('08G9','Gunner''s Mate Basic'),
('0CTA','Cryptologic Technician Administrative NEC'),
('0CTO','Cryptologic Technician Communications (CTO) Tracking NEC'),
('1199','Fire Control Technician Basic'),
('11C9','Fire Controlman Basic'),
('1299','Mineman Basic'),
('1399','Missile Technician Basic'),
('1599','Electronics Technician Basic'),
('2099','Master-at-Arms Basic'),
('2199','Navy Counselor Basic'),
('2299','Information Systems Technician Submarines Conversion'),
('2299','Postal Clerk Basic'),
('2399','Information SystemsTechnician'),
('2499','Religious Program Specialist Basic'),
('2599','Yeoman Basic'),
('2699','Personnel Specialist Basic'),
('2899','Logistics Specialist Basic'),
('3199','Ship Serviceman Basic'),
('3299','Mass Communications'),
('3499','Legalman Basic'),
('3599','Culinary Specialist Basic'),
('3899','Musician Basic'),
('3999','Intelligence Specialist Basic'),
('4199','Gas Turbine Systems Technician Basic'),
('41E9','Gas Turbine Systems Technician (Electrical)'),
('41M9','Gas Turbine Systems Technician (Mechanical)'),
('4299','Machinist''s Mate Basic'),
('4399','Engineman Basic'),
('4499','Machinery Repairman Basic'),
('4699','Electrician''s Mate Basic'),
('4799','Interior Communications Electrician Basic'),
('4899','Damage Control Basic'),
('4999','Hull Maintenance Technician Basic'),
('53B9','Special Operations Boats'),
('53D9','Navy Diver'),
('53E9','Explosive Ordnance Diver'),
('53N9','Navy Diver'),
('53S9','Special Operations'),
('5599','Engineering Aid Basic'),
('5699','Construction Electrician Basic'),
('5799','Equipment Operator Basic'),
('5899','Construction Mechanic Basic'),
('5999','Builder Basic'),
('6099','Steelworker Basic'),
('6199','Utilitiesman Basic'),
('6399','Aviation Maintenance Administrationman Basic'),
('6499','Aviation Machinist''s Mate Basic'),
('6699','Aviation Electronics Technician Basic'),
('6899','Aviation Ordnanceman Basic'),
('6999','Air Traffic Controller Basic'),
('7099','Aviation Boatswain''s Mate Basic'),
('70E9','Aviation Boatswain''s Mate (Launching & Recovery Equipment)'),
('70F9','Aviation Boatswain''s Mate (Fuels)'),
('70H9','Aviation Boatswain''s Mate (Aircraft Handling)'),
('7199','Aviation Electrician''s Mate Basic'),
('7259','Aviation Structural Mechanic Structure'),
('7299','Aviation Structural Mechanic Basic'),
('72E9','Aviation Structural Mechanic (Safety Equipment)'),
('72H9','Aviation Structural Mechanic Hydraulics'),
('7399','Aircrew Survival Equipmentman Basic'),
('7499','Aerographer''s Mate Basic'),
('7699','Aviation Support Equipment Technician Basic'),
('7899','Aviation Antisubmarine Warfare Operator Basic'),
('78F9','Naval Aircrewman Mechanical'),
('78O9','Naval Aircrewman Operator'),
('78R9','Naval Aircrewman Tactical Helicopter'),
('78S9','Naval Aircrewman Helicopter'),
('78V9','Naval Aircrewman Avionics'),
('8499','Hospital Corpsman Basic'),
('91A9','Cryptologic Technician (Administrative)'),
('91I9','Cryptologic Technician (Interpretive)'),
('91M9','Cryptologic Technician (Maintenance)'),
('91N9','Cryptologic Technician (Network)'),
('91R9','Cryptologic Technician (Collection)'),
('91T9','Cryptologic Technician (Technical)'),
('9902','Nuclear Propulsion and Submarine Disqualification Tracker'),
('AA','Airman Apprentice'),
('AR','Airman Recruit'),
('CA','Constructionman Apprentice'),
('CR','Constructionman Recruit'),
('FA','Fireman Apprentice'),
('FR','Fireman Recruit'),
('SA','Seaman Apprentice'),
('SR','Seaman Recruit'),
('21','General Officers and Executives, N.E.C.'),
('0002','General Officer'),
('00B','General Officer'),
('210100','General and Flag'),
('0002','General Officer'),
('90G0','General Officer'),
('8003','General Officer'),
('9903','General Officer'),
('9018','Convoy Commodore'),
('9022','Fleet Commander'),
('9018','Convoy Commodore'),
('9022','Fleet Commander'),
('186','RL - Special Duty Officer - IDC Flag Officer'),
('270','SC - Active Duty Nurse Corps, Medical Service Corps, Medical Corps, and Dental Corps officer in rank of 07'),
('00F','Permanent Professor or Permanent Associate Professor'),
('2010','Chief of Staff'),
('2015','Congressional Liaison Officer'),
('2019','Post Commander'),
('2025','Major Departmental Unit Chief or Director'),
('210200','Executives, N.E.C.'),
('10C0','Operations Commander'),
('10C0M','Operations Commander, RPA'),
('10C0N','Operations Commander, ABM'),
('10C0P','Operations Commander, Fighter'),
('10C0Q','Operations Commander, Trainer'),
('10C0R','Operations Commander, Bomber'),
('10C0S','Operations Commander, Tanker'),
('10C0T','Operations Commander, Airlift'),
('10C0U','Operations Commander, Tactical Airlift'),
('10C0V','Operations Commander, Helicopter or EWO'),
('10C0W','Operations Commander, General'),
('10C0Y','Operations Commander, Special Operations'),
('10C0Z','Operations Commander, C2ISREW'),
('91C0','Commander'),
('91C0M','Commander, RPA'),
('91C0N','Commander, ABM'),
('91C0P','Commander, Fighter'),
('91C0Q','Commander, Trainer'),
('91C0R','Commander, Bomber'),
('91C0S','Commander, Tanker'),
('91C0T','Commander, Airlift'),
('91C0U','Commander, Tactical Airlift'),
('91C0V','Commander, Helicopter or EWO'),
('91C0W','Commander, General'),
('91C0Y','Commander, Special Operations'),
('91C0Z','Commander, C2ISREW'),
('91W0','Wing Commander'),
('8016','Special Technical Operations Officer'),
('8040','Colonel, Logistician'),
('8041','Colonel, Ground'),
('8042','Colonel, Naval Aviator/Naval Flight Officer'),
('9904','Colonel, Logistician'),
('9906','Colonel, Ground'),
('9907','Colonel, Naval Aviator/Naval Flight Officer'),
('9908','Colonel, Supply'),
('9914','Colonel, Judge Advocate'),
('9935','Special Technical Operations (Officer)'),
('8016','Special Technical Operations (Officer)'),
('9935','Special Technical Operations (Officer)'),
('0004','Directorate for Clinical Service (Medical or Surgical)'),
('0705','Commanding Officer, Fleet Marine Force Organization'),
('0710','Executive Officer, Fleet Marine Force Organization'),
('0720','Commanding Officer, Fleet Marine Force Organization'),
('0760','Executive Officer, Fleet Marine Force Organization'),
('2160','Designated Project Manager'),
('2161','Major Project Manager (Selected)'),
('2162','Deputy Designated Project Manager'),
('2163','Manager, Designated Project Functional Element'),
('2165','Designated Project Systems Integration Coordinator'),
('2166','Designated Project Engineering Coordinator'),
('2168','Designated Project Integrated Logistics Systems Coordinator'),
('2608','Command Management Director'),
('9005','Commander, Operating Forces Command'),
('9006','Commander, Operating Forces (Selected)'),
('9009','Area Commander'),
('9015','Chief of Staff'),
('9016','Chief Staff Officer'),
('9100','AOC Director'),
('9420','Officer in Charge, Naval Shore Activity'),
('9421','Commander/Commanding Officer, Shore Activity'),
('9422','Commanding Officer, Naval Shore Activity (Selected)'),
('9436','Executive Officer, Shore Activity'),
('9460','Marine Director, Panama Canal Company'),
('9470','Commanding Officer, Military Sealift Command Office'),
('9471','Executive Officer, Military Sealift Command Office'),
('9473','Military Sealift Command Representative'),
('9805','Tactical Information Warfare Officer (Surface)'),
('9810','Head of Naval Security Group Department'),
('9811','Tactical Information Warfare Officer (Subsurface)'),
('9816','Tactical Information Warfare Officer (Air)'),
('9820','Tactical Information Warfare Officer (Special Warfare/Irregular Warfare)'),
('9826','Information Warfare Officer (National)'),
('9831','Information Warfare Officer (Coordinator)'),
('9836','Information Warfare Officer (Planner)'),
('9841','Information Warfare Officer (Staff)'),
('9905','Atomic Energy Plans & Policies Officer'),
('9906','Atomic Energy Plans & Policies Officer (Atomic Tests)'),
('9907','Atomic Energy Plans & Policies Officer (Nuclear Weapons)'),
('9908','Atomic Energy Plans & Policies Officer (Nuclear Power)'),
('9940','Head of Naval Mission'),
('9950','Military Sealift Command Commander'),
('9970','Plans & Policies Chief'),
('9980','Plans & Policies Director'),
('9981','Naval Plans & Policies Director, Naval Command Systems'),
('9992','Deputy/Vice Commander'),
('0004','Directorate for Clinical Service (Medical or Surgical)'),
('0705','Commanding Officer, Fleet Marine Force Organization'),
('0710','Executive Officer, Fleet Marine Force Organization'),
('0720','Commanding Officer, Fleet Marine Force Organization'),
('0760','Executive Officer, Fleet Marine Force Organization'),
('2160','Designated Project Manager'),
('2161','Major Project Manager (Selected)'),
('2162','Deputy Designated Project Manager'),
('2163','Manager, Designated Project Functional Element'),
('2165','Designated Project Systems Integration Coordinator'),
('2166','Designated Project Engineering Coordinator'),
('2168','Designated Project Integrated Logistics Systems Coordinator'),
('2608','Command Management Director'),
('9005','Commander, Operating Forces Command'),
('9006','Commander, Operating Forces (Selected)'),
('9009','Area Commander'),
('9015','Chief of Staff'),
('9016','Chief Staff Officer'),
('9100','AOC Director'),
('9420','Officer in Charge, Naval Shore Activity'),
('9421','Commander/Commanding Officer, Shore Activity'),
('9422','Commanding Officer, Naval Shore Activity (Selected)'),
('9436','Executive Officer, Shore Activity'),
('9460','Marine Director, Panama Canal Company'),
('9470','Commanding Officer, Military Sealift Command Office'),
('9471','Executive Officer, Military Sealift Command Office'),
('9473','Military Sealift Command Representative'),
('9805','Tactical Information Warfare Officer (Surface)'),
('9810','Head of Naval Security Group Department'),
('9811','Tactical Information Warfare Officer (Subsurface)'),
('9816','Tactical Information Warfare Officer (Air)'),
('9820','Tactical Information Warfare Officer (Special Warfare/Irregular Warfare)'),
('9826','Information Warfare Officer (National)'),
('9831','Information Warfare Officer (Coordinator)'),
('9836','Information Warfare Officer (Planner)'),
('9841','Information Warfare Officer (Staff)'),
('9905','Atomic Energy Plans and Policies Officer'),
('9906','Atomic Energy Plans and Policies Officer (Atomic Tests)'),
('9907','Atomic Energy Plans and Policies Officer (Nuclear Weapons)'),
('9908','Atomic Energy Plans and Policies Officer (Nuclear Power)'),
('9940','Head of Naval Mission'),
('9950','Military Sealift Command Commander'),
('9970','Plans and Policies Chief'),
('9980','Plans and Policies Director'),
('9981','Naval Plans and Policies Director, Naval Command Systems'),
('9992','Deputy/Vice Commander'),
('22','Tactical Operations Officers'),
('220100','Fixed-Wing Fighter and Bomber Pilots'),
('0061','Air Commander'),
('0066','Air Commander'),
('1111','Pilot, Fighter'),
('1115','Pilot, Fighter'),
('1121','Pilot, Fighter Interceptor'),
('1125','Pilot, Fighter Interceptor'),
('1131','Pilot, Special Tactics Fighter'),
('1135','Pilot, Special Tactics Fighter'),
('11B1','Bomber Pilot'),
('11B1A','Bomber Pilot, B-1'),
('11B1B','Bomber Pilot, B-2'),
('11B1C','Bomber Pilot, B-52'),
('11B1M','Bomber Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11B1N','Bomber Pilot, T-38 ACE/CTP'),
('11B1P','Bomber Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11B1R','Bomber Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11B1S','Bomber Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11B1T','Bomber Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11B1U','Bomber Pilot, Air Liaison Officer (ALO)'),
('11B1Y','Bomber Pilot, General'),
('11B1Z','Bomber Pilot, Other'),
('11B2','Bomber Pilot'),
('11B2A','Bomber Pilot, B-1'),
('11B2B','Bomber Pilot, B-2'),
('11B2C','Bomber Pilot, B-52'),
('11B2M','Bomber Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11B2N','Bomber Pilot, T-38 ACE/CTP'),
('11B2P','Bomber Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11B2R','Bomber Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11B2S','Bomber Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11B2T','Bomber Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11B2U','Bomber Pilot, Air Liaison Officer (ALO)'),
('11B2Y','Bomber Pilot, General'),
('11B2Z','Bomber Pilot, Other'),
('11B3','Bomber Pilot'),
('11B3A','Bomber Pilot, B-1'),
('11B3B','Bomber Pilot, B-2'),
('11B3C','Bomber Pilot, B-52'),
('11B3M','Bomber Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11B3N','Bomber Pilot, T-38 ACE/CTP'),
('11B3P','Bomber Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11B3R','Bomber Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11B3S','Bomber Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11B3T','Bomber Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11B3U','Bomber Pilot, Air Liaison Officer (ALO)'),
('11B3Y','Bomber Pilot, General'),
('11B3Z','Bomber Pilot, Other'),
('11B4','Bomber Pilot'),
('11B4A','Bomber Pilot, B-1'),
('11B4B','Bomber Pilot, B-2'),
('11B4C','Bomber Pilot, B-52'),
('11B4M','Bomber Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11B4N','Bomber Pilot, T-38 ACE/CTP'),
('11B4P','Bomber Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11B4R','Bomber Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11B4S','Bomber Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11B4T','Bomber Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11B4U','Bomber Pilot, Air Liaison Officer (ALO)'),
('11B4Y','Bomber Pilot, General'),
('11B4Z','Bomber Pilot, Other'),
('11F1','Fighter Pilot'),
('11F1A','Fighter Pilot, A-7'),
('11F1B','Fighter Pilot, A-10'),
('11F1C','Fighter Pilot, F-4'),
('11F1D','Fighter Pilot, F-4G'),
('11F1E','Fighter Pilot, RF-4'),
('11F1F','Fighter Pilot, F-15'),
('11F1G','Fighter Pilot, F-15E'),
('11F1H','Fighter Pilot, F-16'),
('11F1J','Fighter Pilot, F-22'),
('11F1K','Fighter Pilot, F-111'),
('11F1L','Fighter Pilot, EF-111'),
('11F1M','Fighter Pilot, F-117'),
('11F1N','Fighter Pilot, OA-10'),
('11F1N','Fighter Pilot, F-35'),
('11F1P','Fighter Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11F1Q','Fighter Pilot, AT-38'),
('11F1Q','Fighter Pilot, IFF (AT-38/T-38C)'),
('11F1R','Fighter Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11F1S','Fighter Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11F1T','Fighter Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11F1U','Fighter Pilot, Air Liaison Officer (ALO)'),
('11F1V','Fighter Pilot, EA-6B'),
('11F1Y','Fighter Pilot, General'),
('11F1Z','Fighter Pilot, Other'),
('11F3','Fighter Pilot'),
('11F3A','Fighter Pilot, A-7'),
('11F3B','Fighter Pilot, A-10'),
('11F3C','Fighter Pilot, F-4'),
('11F3D','Fighter Pilot, F-4G'),
('11F3E','Fighter Pilot, RF-4'),
('11F3F','Fighter Pilot, F-15'),
('11F3G','Fighter Pilot, F-15E'),
('11F3H','Fighter Pilot, F-16'),
('11F3J','Fighter Pilot, F-22'),
('11F3K','Fighter Pilot, F-111'),
('11F3L','Fighter Pilot, EF-111'),
('11F3M','Fighter Pilot, F-117'),
('11F3N','Fighter Pilot, OA-10'),
('11F3N','Fighter Pilot, F-35'),
('11F3P','Fighter Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11F3Q','Fighter Pilot, AT-38'),
('11F3Q','Fighter Pilot, IFF (AT-38/T-38C)'),
('11F3R','Fighter Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11F3S','Fighter Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11F3T','Fighter Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11F3U','Fighter Pilot, Air Liaison Officer (ALO)'),
('11F3V','Fighter Pilot, EA-6B'),
('11F3Y','Fighter Pilot, General'),
('11F3Z','Fighter Pilot, Other'),
('11F4','Fighter Pilot'),
('11F4A','Fighter Pilot, A-7'),
('11F4B','Fighter Pilot, A-10'),
('11F4C','Fighter Pilot, F-4'),
('11F4D','Fighter Pilot, F-4G'),
('11F4E','Fighter Pilot, RF-4'),
('11F4F','Fighter Pilot, F-15'),
('11F4G','Fighter Pilot, F-15E'),
('11F4H','Fighter Pilot, F-16'),
('11F4J','Fighter Pilot, F-22'),
('11F4K','Fighter Pilot, F-111'),
('11F4L','Fighter Pilot, EF-111'),
('11F4M','Fighter Pilot, F-117'),
('11F4N','Fighter Pilot, OA-10'),
('11F4N','Fighter Pilot, F-35'),
('11F4P','Fighter Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11F4Q','Fighter Pilot, AT-38'),
('11F4Q','Fighter Pilot, IFF (AT-38/T-38C)'),
('11F4R','Fighter Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11F4S','Fighter Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11F4T','Fighter Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11F4U','Fighter Pilot, Air Liaison Officer (ALO)'),
('11F4V','Fighter Pilot, EA-6B'),
('11F4Y','Fighter Pilot, General'),
('11F4Z','Fighter Pilot, Other'),
('1221','Pilot, Tactical Bomber'),
('1223','Pilot, Tactical Bomber'),
('1225','Pilot, Tactical Bomber'),
('1231','Pilot, Strategic Bomber'),
('1233','Pilot, Strategic Bomber'),
('1235','Pilot, Strategic Bomber'),
('7500','Pilot VMA FRS Basic A-4M'),
('7501','Pilot VMA A-4 Qualified'),
('7507','Pilot VMA FRS Basic AV-8B'),
('7508','Pilot VMA AV-8A/C Qualified'),
('7509','Pilot VMA AV-8B Qualified'),
('7510','Pilot VMA (AW) FRS Basic A-6E'),
('7511','Pilot VMA (AW) A-6E Qualified'),
('7516','Pilot VMFA FRS Basic F-35B Pilot'),
('7518','Attack Training Officer'),
('7518','Pilot VMFA FRS F-35B Qualified'),
('7519','Attack Training Officer (AW)'),
('7520','FRS Basic F-4S Pilot'),
('7521','Pilot VMFA FRS Basic F/A-18 Pilot'),
('7522','Pilot VMFA F-4S Qualified'),
('7523','Pilot VMFA F/A-18 Qualified'),
('7524','Naval Flight Officer (NFO), FRS Basic F/A-18D Weapons Systems Officer (WSO)'),
('7527','Pilot VMFA F/A-18D Qualified'),
('7528','Fighter Training Officer'),
('7529','Fighter Training Officer (AW)'),
('7530','Basic Pilot VMF/VMF(AW)'),
('7531','Pilot VMF/VMF(AW)F-8A/B/C'),
('7532','Pilot VMF/VMF(AW)F-8D/E'),
('7540','FRS Basic RF-4B Pilot'),
('7541','Pilot VMAQ/VMFP FRS Basic EA-6B Pilot'),
('7542','Pilot VMAQ/VMFP EA-6A Qualified'),
('7543','Pilot VMAQ/VMFP EA-6B Qualified'),
('7544','Pilot VMCJ RF-8A'),
('7545','Pilot VMFP/VMFP RF-4B Qualified'),
('7577','Weapons and Tactics Instructor'),
('7592','Pilot VMAW'),
('7577','Weapons and Tactics Instructor'),
('7592','Pilot VMAW'),
('8515','Anti-Submarine Pilot'),
('8516','Light Attack Pilot'),
('8517','Heavy Attack Pilot'),
('8522','Copilot, Patrol Bomber, Land-Based'),
('8528','Fighter Pilot'),
('8560','All Weather Fighter Pilot'),
('8571','Patrol Plane Commander, Multiengine Land Plane'),
('8670','Squadron Commanding Officer'),
('8672','Squadron Executive Officer'),
('8695','Wing or Group Commander'),
('8515','Anti-Submarine Pilot'),
('8516','Light Attack Pilot'),
('8517','Heavy Attack Pilot'),
('8522','Copilot, Patrol Bomber, Land-Based'),
('8528','Fighter Pilot'),
('8560','All Weather Fighter Pilot'),
('8571','Patrol Plane Commander, Multiengine Land Plane'),
('8670','Squadron Commanding Officer'),
('8672','Squadron Executive Officer'),
('8695','Wing or Group Commander'),
('1980','Fixed Wing Aviation Unit Commander'),
('100P','Pilot, U-8'),
('100Q','Combat Service/Support Fixed Wing Pilot'),
('100R','Combat Surveillance Fixed Wing Pilot'),
('155A','Fixed Wing Aviator (Aircraft Nonspecific)'),
('155D','U-21 Pilot'),
('155E','C-12 Pilot'),
('155F','Jet Aircraft Pilot'),
('155G','0-5A/EO-5B/RC-7 Pilot'),
('156A','OB-1/RV-1 Pilot'),
('220200','Other Fixed-Wing Pilots'),
('1031','Pilot, Search-Rescue'),
('1033','Pilot, Search-Rescue'),
('1035','Pilot, Search-Rescue'),
('1041','Pilot, Transport'),
('1043','Pilot, Transport'),
('1045','Pilot, Transport'),
('1051','Pilot, Tactical Airlift'),
('1053','Pilot, Tactical Airlift'),
('1055','Pilot, Tactical Airlift'),
('1061','Pilot, Tanker'),
('1063','Pilot, Tanker'),
('1065','Pilot, Tanker'),
('1141','Pilot, Forward Air Controller (FAC)'),
('1145','Pilot, Forward Air Controller (FAC)'),
('1161','Pilot, Mission Support'),
('1165','Pilot, Mission Support'),
('11A1','Airlift Pilot'),
('11A1A','Airlift Pilot, C-5'),
('11A1B','Airlift Pilot, C-9'),
('11A1C','Airlift Pilot, C-12'),
('11A1D','Airlift Pilot, C-17'),
('11A1E','Airlift Pilot, C-20/C-37'),
('11A1F','Airlift Pilot, C-21'),
('11A1G','Airlift Pilot, VC-25'),
('11A1H','Airlift Pilot, C-26'),
('11A1J','Airlift Pilot, C-27'),
('11A1K','Airlift Pilot, C-130'),
('11A1L','Airlift Pilot, C-32/C-135/C-137'),
('11A1M','Airlift Pilot, C-141'),
('11A1N','Airlift Pilot, T-43'),
('11A1P','Airlift Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11A1R','Airlift Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11A1S','Airlift Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11A1T','Airlift Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11A1U','Airlift Pilot, Air Liaison Officer (ALO)'),
('11A1V','Airlift Pilot, Inter-Theater Airlift, General'),
('11A1W','Airlift Pilot, Intra-Theater Airlift, General'),
('11A1Y','Airlift Pilot, General'),
('11A1Z','Airlift Pilot, Other'),
('11A2','Airlift Pilot'),
('11A2A','Airlift Pilot, C-5'),
('11A2B','Airlift Pilot, C-9'),
('11A2C','Airlift Pilot, C-12'),
('11A2D','Airlift Pilot, C-17'),
('11A2E','Airlift Pilot, C-20/C-37'),
('11A2F','Airlift Pilot, C-21'),
('11A2G','Airlift Pilot, VC-25'),
('11A2H','Airlift Pilot, C-26'),
('11A2J','Airlift Pilot, C-27'),
('11A2K','Airlift Pilot, C-130'),
('11A2L','Airlift Pilot, C-32/C-135/C-137'),
('11A2M','Airlift Pilot, C-141'),
('11A2N','Airlift Pilot, T-43'),
('11A2P','Airlift Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11A2R','Airlift Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11A2S','Airlift Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11A2T','Airlift Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11A2U','Airlift Pilot, Air Liaison Officer (ALO)'),
('11A2V','Airlift Pilot, Inter-Theater Airlift, General'),
('11A2W','Airlift Pilot, Intra-Theater Airlift, General'),
('11A2Y','Airlift Pilot, General'),
('11A2Z','Airlift Pilot, Other'),
('11A3','Airlift Pilot'),
('11A3A','Airlift Pilot, C-5'),
('11A3B','Airlift Pilot, C-9'),
('11A3C','Airlift Pilot, C-12'),
('11A3D','Airlift Pilot, C-17'),
('11A3E','Airlift Pilot, C-20/C-37'),
('11A3F','Airlift Pilot, C-21'),
('11A3G','Airlift Pilot, VC-25'),
('11A3H','Airlift Pilot, C-26'),
('11A3J','Airlift Pilot, C-27'),
('11A3K','Airlift Pilot, C-130'),
('11A3L','Airlift Pilot, C-32/C-135/C-137'),
('11A3M','Airlift Pilot, C-141'),
('11A3N','Airlift Pilot, T-43'),
('11A3P','Airlift Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11A3R','Airlift Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11A3S','Airlift Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11A3T','Airlift Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11A3U','Airlift Pilot, Air Liaison Officer (ALO)'),
('11A3V','Airlift Pilot, Inter-Theater Airlift, General'),
('11A3W','Airlift Pilot, Intra-Theater Airlift, General'),
('11A3Y','Airlift Pilot, General'),
('11A3Z','Airlift Pilot, Other'),
('11A4','Airlift Pilot'),
('11A4A','Airlift Pilot, C-5'),
('11A4B','Airlift Pilot, C-9'),
('11A4C','Airlift Pilot, C-12'),
('11A4D','Airlift Pilot, C-17'),
('11A4E','Airlift Pilot, C-20/C-37'),
('11A4F','Airlift Pilot, C-21'),
('11A4G','Airlift Pilot, VC-25'),
('11A4H','Airlift Pilot, C-26'),
('11A4J','Airlift Pilot, C-27'),
('11A4K','Airlift Pilot, C-130'),
('11A4L','Airlift Pilot, C-32/C-135/C-137'),
('11A4M','Airlift Pilot, C-141'),
('11A4N','Airlift Pilot, T-43'),
('11A4P','Airlift Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11A4R','Airlift Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11A4S','Airlift Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11A4T','Airlift Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11A4U','Airlift Pilot, Air Liaison Officer (ALO)'),
('11A4V','Airlift Pilot, Inter-Theater Airlift, General'),
('11A4W','Airlift Pilot, Intra-Theater Airlift, General'),
('11A4Y','Airlift Pilot, General'),
('11A4Z','Airlift Pilot, Other'),
('11E1','Experimental Test Pilot'),
('11E1A','Experimental Test Pilot, Airlift/Tanker/Bomber'),
('11E1B','Experimental Test Pilot, Fighter'),
('11E1C','Experimental Test Pilot, Helicopter/VSTOL'),
('11E1D','Experimental Test Pilot, Airlift'),
('11E1E','Experimental Test Pilot, Tanker'),
('11E1F','Experimental Test Pilot, Bomber'),
('11E1G','Experimental Test Pilot, RPA'),
('11E1P','Experimental Test Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11E1Q','Experimental Test Pilot, Mission Support (T-38, etc)'),
('11E1R','Experimental Test Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11E1S','Experimental Test Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11E1T','Experimental Test Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11E1U','Experimental Test Pilot, Air Liaison Officer (ALO)'),
('11E1Y','Experimental Test Pilot, General'),
('11E1Z','Experimental Test Pilot, Other'),
('11E3','Experimental Test Pilot'),
('11E3A','Experimental Test Pilot, Airlift/Tanker/Bomber'),
('11E3B','Experimental Test Pilot, Fighter'),
('11E3C','Experimental Test Pilot, Helicopter/VSTOL'),
('11E3D','Experimental Test Pilot, Airlift'),
('11E3E','Experimental Test Pilot, Tanker'),
('11E3F','Experimental Test Pilot, Bomber'),
('11E3G','Experimental Test Pilot, RPA'),
('11E3P','Experimental Test Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11E3Q','Experimental Test Pilot, Mission Support (T-38, etc)'),
('11E3R','Experimental Test Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11E3S','Experimental Test Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11E3T','Experimental Test Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)'),
('11E3U','Experimental Test Pilot, Air Liaison Officer (ALO)'),
('11E3Y','Experimental Test Pilot, General'),
('11E3Z','Experimental Test Pilot, Other'),
('11E4','Experimental Test Pilot'),
('11E4A','Experimental Test Pilot, Airlift/Tanker/Bomber'),
('11E4B','Experimental Test Pilot, Fighter'),
('11E4C','Experimental Test Pilot, Helicopter/VSTOL'),
('11E4D','Experimental Test Pilot, Airlift'),
('11E4E','Experimental Test Pilot, Tanker'),
('11E4F','Experimental Test Pilot, Bomber'),
('11E4G','Experimental Test Pilot, RPA'),
('11E4P','Experimental Test Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11E4Q','Experimental Test Pilot, Mission Support (T-38, etc)'),
('11E4R','Experimental Test Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11E4S','Experimental Test Pilot, SUPT Phase II Instructor (T-34/T-37)'),
('11E4T','Experimental Test Pilot, SUPT Phase III Instructor (T-1/ T-38/T-44)')
               )
       AS MasterRecord(CODE, TITLE)
       )
       
    MERGE 
      INTO  AHOBPR.STD_SERVICE_OCCUPATION AS Tgt
      USING MasterData AS Src
      ON    Tgt.[SERVICE_OCCUPATION_CODE] = Src.CODE
     WHEN  NOT MATCHED
     THEN  INSERT    
           ([SERVICE_OCCUPATION_CODE]
           ,[SERVICE_TITLE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           (Src.CODE
           ,Src.TITLE
           ,'AHOBPR DBA'
           ,'AHOBPR DBA'
           ,@Today
           ,@Today);
GO


PRINT 'Merging data for AHOBPR.STD_SERVICE_OCCUPATION  Set 21...';
GO

DECLARE @Today DATETIME2(0) = GETDATE();

WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES   
('11E4U','Experimental Test Pilot, Air Liaison Officer (ALO)'),
('11E4Y','Experimental Test Pilot, General'),
('11E4Z','Experimental Test Pilot, Other'),
('11G3','Generalist Pilot'),
('11G4','Generalist Pilot'),
('11H1J','Rescue Pilot, HC-130J'),
('11H1P','Rescue Pilot, HC-130 P/N'),
('11H2J','Rescue Pilot, HC-130J'),
('11H2P','Rescue Pilot, HC-130 P/N'),
('11H3J','Rescue Pilot, HC-130J'),
('11H3P','Rescue Pilot, HC-130 P/N'),
('11H4J','Rescue Pilot, HC-130J'),
('11H4P','Rescue Pilot, HC-130 P/N'),
('11K1','Trainer Pilot'),
('11K1A','Trainer Pilot, T-1'),
('11K1B','Trainer Pilot, T-3/T-41'),
('11K1C','Trainer Pilot, T-37'),
('11K1D','Trainer Pilot, T-38'),
('11K1E','Trainer Pilot, AT-38'),
('11K1F','Trainer Pilot, T-6'),
('11K1G','Trainer Pilot, T-34'),
('11K1H','Trainer Pilot, T-44/TC-12'),
('11K1L','Trainer Pilot, C-12 Companion Trainer Program (CTP)'),
('11K1M','Trainer Pilot, T-37 CTP'),
('11K1N','Trainer Pilot, T-38 CTP'),
('11K1U','Trainer Pilot, Air Liaison Officer (ALO)'),
('11K1Y','Trainer Pilot, General'),
('11K1Z','Trainer Pilot, Other'),
('11K3','Trainer Pilot'),
('11K3A','Trainer Pilot, T-1'),
('11K3B','Trainer Pilot, T-3/T-41'),
('11K3C','Trainer Pilot, T-37'),
('11K3D','Trainer Pilot, T-38'),
('11K3E','Trainer Pilot, AT-38'),
('11K3F','Trainer Pilot, T-6'),
('11K3G','Trainer Pilot, T-34'),
('11K3H','Trainer Pilot, T-44/TC-12'),
('11K3L','Trainer Pilot, C-12 Companion Trainer Program (CTP)'),
('11K3M','Trainer Pilot, T-37 CTP'),
('11K3N','Trainer Pilot, T-38 CTP'),
('11K3U','Trainer Pilot, Air Liaison Officer (ALO)'),
('11K3Y','Trainer Pilot, General'),
('11K3Z','Trainer Pilot, Other'),
('11K4','Trainer Pilot'),
('11K4A','Trainer Pilot, T-1'),
('11K4B','Trainer Pilot, T-3/T-41'),
('11K4C','Trainer Pilot, T-37'),
('11K4D','Trainer Pilot, T-38'),
('11K4E','Trainer Pilot, AT-38'),
('11K4F','Trainer Pilot, T-6'),
('11K4G','Trainer Pilot, T-34'),
('11K4H','Trainer Pilot, T-44/TC-12'),
('11K4L','Trainer Pilot, C-12 Companion Trainer Program (CTP)'),
('11K4M','Trainer Pilot, T-37 CTP'),
('11K4N','Trainer Pilot, T-38 CTP'),
('11K4U','Trainer Pilot, Air Liaison Officer (ALO)'),
('11K4Y','Trainer Pilot, General'),
('11K4Z','Trainer Pilot, Other'),
('11M1A','Mobility Pilot, C-5'),
('11M1B','Mobility Pilot, C-130E/H'),
('11M1C','Mobility Pilot, C-130J'),
('11M1D','Mobility Pilot, C-141'),
('11M1D','Mobility Pilot, C-27J (JCA)'),
('11M1E','Mobility Pilot, VC-25'),
('11M1F','Mobility Pilot, KC-135'),
('11M1G','Mobility Pilot, KC-10'),
('11M1H','Mobility Pilot, C-9'),
('11M1J','Mobility Pilot, C-12'),
('11M1K','Mobility Pilot, C-17'),
('11M1L','Mobility Pilot, C-20/C-37'),
('11M1M','Mobility Pilot, C-21'),
('11M1N','Mobility Pilot, C-26'),
('11M1P','Mobility Pilot, C-32'),
('11M1Q','Mobility Pilot, C-40'),
('11M1R','Mobility Pilot, KC-46'),
('11M1S','Mobility Pilot, Airlift, General'),
('11M1T','Mobility Pilot, Tanker, General'),
('11M1U','Mobility Pilot, Air Mobility Liaison Officer (AMLO)'),
('11M1V','Mobility Pilot, Inter-Theater Airlift, General'),
('11M1W','Mobility Pilot, Intra-Theater Airlift, General'),
('11M1Y','Mobility Pilot, General'),
('11M1Z','Mobility Pilot, Other'),
('11M2A','Mobility Pilot, C-5'),
('11M2B','Mobility Pilot, C-130E/H'),
('11M2C','Mobility Pilot, C-130J'),
('11M2D','Mobility Pilot, C-141'),
('11M2D','Mobility Pilot, C-27J (JCA)'),
('11M2E','Mobility Pilot, VC-25'),
('11M2F','Mobility Pilot, KC-135'),
('11M2G','Mobility Pilot, KC-10'),
('11M2H','Mobility Pilot, C-9'),
('11M2J','Mobility Pilot, C-12'),
('11M2K','Mobility Pilot, C-17'),
('11M2L','Mobility Pilot, C-20/C-37'),
('11M2M','Mobility Pilot, C-21'),
('11M2N','Mobility Pilot, C-26'),
('11M2P','Mobility Pilot, C-32'),
('11M2Q','Mobility Pilot, C-40'),
('11M2R','Mobility Pilot, KC-46'),
('11M2S','Mobility Pilot, Airlift, General'),
('11M2T','Mobility Pilot, Tanker, General'),
('11M2U','Mobility Pilot, Air Mobility Liaison Officer (AMLO)'),
('11M2V','Mobility Pilot, Inter-Theater Airlift, General'),
('11M2W','Mobility Pilot, Intra-Theater Airlift, General'),
('11M2Y','Mobility Pilot, General'),
('11M2Z','Mobility Pilot, Other'),
('11M3A','Mobility Pilot, C-5'),
('11M3B','Mobility Pilot, C-130E/H'),
('11M3C','Mobility Pilot, C-130J'),
('11M3D','Mobility Pilot, C-27J (JCA)'),
('11M3D','Mobility Pilot, C-141'),
('11M3E','Mobility Pilot, VC-25'),
('11M3F','Mobility Pilot, KC-135'),
('11M3G','Mobility Pilot, KC-10'),
('11M3H','Mobility Pilot, C-9'),
('11M3J','Mobility Pilot, C-12'),
('11M3K','Mobility Pilot, C-17'),
('11M3L','Mobility Pilot, C-20/C-37'),
('11M3M','Mobility Pilot, C-21'),
('11M3N','Mobility Pilot, C-26'),
('11M3P','Mobility Pilot, C-32'),
('11M3Q','Mobility Pilot, C-40'),
('11M3R','Mobility Pilot, KC-46'),
('11M3S','Mobility Pilot, Airlift, General'),
('11M3T','Mobility Pilot, Tanker, General'),
('11M3U','Mobility Pilot, Air Mobility Liaison Officer (AMLO)'),
('11M3V','Mobility Pilot, Inter-Theater Airlift, General'),
('11M3W','Mobility Pilot, Intra-Theater Airlift, General'),
('11M3Y','Mobility Pilot, General'),
('11M3Z','Mobility Pilot, Other'),
('11M4A','Mobility Pilot, C-5'),
('11M4B','Mobility Pilot, C-130E/H'),
('11M4C','Mobility Pilot, C-130J'),
('11M4D','Mobility Pilot, C-27J (JCA)'),
('11M4D','Mobility Pilot, C-141'),
('11M4E','Mobility Pilot, VC-25'),
('11M4F','Mobility Pilot, KC-135'),
('11M4G','Mobility Pilot, KC-10'),
('11M4H','Mobility Pilot, C-9'),
('11M4J','Mobility Pilot, C-12'),
('11M4K','Mobility Pilot, C-17'),
('11M4L','Mobility Pilot, C-20/C-37'),
('11M4M','Mobility Pilot, C-21'),
('11M4N','Mobility Pilot, C-26'),
('11M4P','Mobility Pilot, C-32'),
('11M4Q','Mobility Pilot, C-40'),
('11M4R','Mobility Pilot, KC-46'),
('11M4S','Mobility Pilot, Airlift, General'),
('11M4T','Mobility Pilot, Tanker, General'),
('11M4U','Mobility Pilot, Air Mobility Liaison Officer (AMLO)'),
('11M4V','Mobility Pilot, Inter-Theater Airlift, General'),
('11M4W','Mobility Pilot, Intra-Theater Airlift, General'),
('11M4Y','Mobility Pilot, General'),
('11M4Z','Mobility Pilot, Other'),
('11R1','Reconnaissance/Surveillance/Electronic Warfare Pilot'),
('11R1A','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-3'),
('11R1B','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-4'),
('11R1C','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-130'),
('11R1D','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130'),
('11R1E','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC-130'),
('11R1F','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-135'),
('11R1G','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-135'),
('11R1H','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC/OC-135'),
('11R1J','Reconnaissance/Surveillance/Electronic Warfare Pilot, TR-1/U-2'),
('11R1L','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-8'),
('11R1M','Reconnaissance/Surveillance/Electronic Warfare Pilot, MC-12'),
('11R1N','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-26B'),
('11R1P','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130J'),
('11R1P','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11R1R','Reconnaissance/Surveillance/Electronic Warfare Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11R1S','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11R1T','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11R1U','Reconnaissance/Surveillance/Electronic Warfare Pilot, Air Liaison Officer (ALO)'),
('11R1Y','Reconnaissance/Surveillance/Electronic Warfare Pilot, General'),
('11R1Z','Reconnaissance/Surveillance/Electronic Warfare Pilot, Other'),
('11R2','Reconnaissance/Surveillance/Electronic Warfare Pilot'),
('11R2A','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-3'),
('11R2B','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-4'),
('11R2C','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-130'),
('11R2D','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130'),
('11R2E','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC-130'),
('11R2F','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-135'),
('11R2G','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-135'),
('11R2H','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC/OC-135'),
('11R2J','Reconnaissance/Surveillance/Electronic Warfare Pilot, TR-1/U-2'),
('11R2L','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-8'),
('11R2M','Reconnaissance/Surveillance/Electronic Warfare Pilot, MC-12'),
('11R2N','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-26B'),
('11R2P','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11R2P','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130J'),
('11R2R','Reconnaissance/Surveillance/Electronic Warfare Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11R2S','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11R2T','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11R2U','Reconnaissance/Surveillance/Electronic Warfare Pilot, Air Liaison Officer (ALO)'),
('11R2Y','Reconnaissance/Surveillance/Electronic Warfare Pilot, General'),
('11R2Z','Reconnaissance/Surveillance/Electronic Warfare Pilot, Other'),
('11R3','Reconnaissance/Surveillance/Electronic Warfare Pilot'),
('11R3A','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-3'),
('11R3B','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-4'),
('11R3C','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-130'),
('11R3D','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130'),
('11R3E','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC-130'),
('11R3F','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-135'),
('11R3G','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-135'),
('11R3H','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC/OC-135'),
('11R3J','Reconnaissance/Surveillance/Electronic Warfare Pilot, TR-1/U-2'),
('11R3L','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-8'),
('11R3M','Reconnaissance/Surveillance/Electronic Warfare Pilot, MC-12'),
('11R3N','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-26B'),
('11R3P','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130J'),
('11R3P','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11R3R','Reconnaissance/Surveillance/Electronic Warfare Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11R3S','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11R3T','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11R3U','Reconnaissance/Surveillance/Electronic Warfare Pilot, Air Liaison Officer (ALO)'),
('11R3Y','Reconnaissance/Surveillance/Electronic Warfare Pilot, General'),
('11R3Z','Reconnaissance/Surveillance/Electronic Warfare Pilot, Other'),
('11R4','Reconnaissance/Surveillance/Electronic Warfare Pilot'),
('11R4A','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-3'),
('11R4B','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-4'),
('11R4C','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-130'),
('11R4D','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130'),
('11R4E','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC-130'),
('11R4F','Reconnaissance/Surveillance/Electronic Warfare Pilot, EC-135'),
('11R4G','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-135'),
('11R4H','Reconnaissance/Surveillance/Electronic Warfare Pilot, WC/OC-135'),
('11R4J','Reconnaissance/Surveillance/Electronic Warfare Pilot, TR-1/U-2'),
('11R4L','Reconnaissance/Surveillance/Electronic Warfare Pilot, E-8'),
('11R4M','Reconnaissance/Surveillance/Electronic Warfare Pilot, MC-12'),
('11R4N','Reconnaissance/Surveillance/Electronic Warfare Pilot, RC-26B'),
('11R4P','Reconnaissance/Surveillance/Electronic Warfare Pilot, HC-130J'),
('11R4P','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11R4R','Reconnaissance/Surveillance/Electronic Warfare Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11R4S','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11R4T','Reconnaissance/Surveillance/Electronic Warfare Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11R4U','Reconnaissance/Surveillance/Electronic Warfare Pilot, Air Liaison Officer (ALO)'),
('11R4Y','Reconnaissance/Surveillance/Electronic Warfare Pilot, General'),
('11R4Z','Reconnaissance/Surveillance/Electronic Warfare Pilot, Other'),
('11S1','Special Operations Pilot'),
('11S1C','Special Operations Pilot, AC-130H'),
('11S1D','Special Operations Pilot, AC-130U'),
('11S1E','Special Operations Pilot, MC-130P'),
('11S1F','Special Operations Pilot, MC-130E'),
('11S1G','Special Operations Pilot, MC-130H'),
('11S1I','Special Operations Pilot, CAA (Fixed Wing)'),
('11S1J','Special Operations Pilot, CV-22'),
('11S1M','Special Operations Pilot, Air Commando (NSAv, DM)'),
('11S1N','Special Operations Pilot, AC-130W'),
('11S1P','Special Operations Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11S1P','Special Operations Pilot, MC-130J'),
('11S1Q','Special Operations Pilot, AC-130J'),
('11S1R','Special Operations Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11S1S','Special Operations Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11S1S','Special Operations Pilot, EC-130J'),
('11S1T','Special Operations Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11S1U','Special Operations Pilot, Air Liaison Officer (ALO)'),
('11S1W','Special Operations Pilot, SOF Fixed Wing, General'),
('11S1X','Special Operations Pilot, U-28'),
('11S1Y','Special Operations Pilot, General'),
('11S1Z','Special Operations Pilot, Other'),
('11S2','Special Operations Pilot'),
('11S2C','Special Operations Pilot, AC-130H'),
('11S2D','Special Operations Pilot, AC-130U'),
('11S2E','Special Operations Pilot, MC-130P'),
('11S2F','Special Operations Pilot, MC-130E'),
('11S2G','Special Operations Pilot, MC-130H'),
('11S2I','Special Operations Pilot, CAA (Fixed Wing)'),
('11S2J','Special Operations Pilot, CV-22'),
('11S2M','Special Operations Pilot, Air Commando (NSAv, DM)'),
('11S2N','Special Operations Pilot, AC-130W'),
('11S2P','Special Operations Pilot, MC-130J'),
('11S2P','Special Operations Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11S2Q','Special Operations Pilot, AC-130J'),
('11S2R','Special Operations Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11S2S','Special Operations Pilot, EC-130J'),
('11S2S','Special Operations Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11S2T','Special Operations Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11S2U','Special Operations Pilot, Air Liaison Officer (ALO)'),
('11S2W','Special Operations Pilot, SOF Fixed Wing, General'),
('11S2X','Special Operations Pilot, U-28'),
('11S2Y','Special Operations Pilot, General'),
('11S2Z','Special Operations Pilot, Other'),
('11S3','Special Operations Pilot'),
('11S3C','Special Operations Pilot, AC-130H'),
('11S3D','Special Operations Pilot, AC-130U'),
('11S3E','Special Operations Pilot, MC-130P'),
('11S3F','Special Operations Pilot, MC-130E'),
('11S3G','Special Operations Pilot, MC-130H'),
('11S3I','Special Operations Pilot, CAA (Fixed Wing)'),
('11S3J','Special Operations Pilot, CV-22'),
('11S3M','Special Operations Pilot, Air Commando (NSAv, DM)'),
('11S3N','Special Operations Pilot, AC-130W'),
('11S3P','Special Operations Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11S3P','Special Operations Pilot, MC-130J'),
('11S3Q','Special Operations Pilot, AC-130J'),
('11S3R','Special Operations Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11S3S','Special Operations Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11S3S','Special Operations Pilot, EC-130J'),
('11S3T','Special Operations Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11S3U','Special Operations Pilot, Air Liaison Officer (ALO)'),
('11S3W','Special Operations Pilot, SOF Fixed Wing, General'),
('11S3X','Special Operations Pilot, U-28'),
('11S3Y','Special Operations Pilot, General'),
('11S3Z','Special Operations Pilot, Other'),
('11S4','Special Operations Pilot'),
('11S4C','Special Operations Pilot, AC-130H'),
('11S4D','Special Operations Pilot, AC-130U'),
('11S4E','Special Operations Pilot, MC-130P'),
('11S4F','Special Operations Pilot, MC-130E'),
('11S4G','Special Operations Pilot, MC-130H'),
('11S4H','Special Operations Pilot, CAA (Rotary Wing)'),
('11S4I','Special Operations Pilot, CAA (Fixed Wing)'),
('11S4J','Special Operations Pilot, CV-22'),
('11S4M','Special Operations Pilot, Air Commando (NSAv, DM)'),
('11S4N','Special Operations Pilot, AC-130W'),
('11S4P','Special Operations Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11S4P','Special Operations Pilot, MC-130J'),
('11S4Q','Special Operations Pilot, AC-130J'),
('11S4R','Special Operations Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11S4S','Special Operations Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11S4S','Special Operations Pilot, EC-130J'),
('11S4T','Special Operations Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11S4U','Special Operations Pilot, Air Liaison Officer (ALO)'),
('11S4W','Special Operations Pilot, SOF Fixed Wing, General'),
('11S4X','Special Operations Pilot, U-28'),
('11S4Y','Special Operations Pilot, General'),
('11S4Z','Special Operations Pilot, Other'),
('11T1','Tanker Pilot'),
('11T1A','Tanker Pilot, KC-10'),
('11T1B','Tanker Pilot, KC-135'),
('11T1L','Tanker Pilot, C-12 Companion Trainer Program (CTP)'),
('11T1M','Tanker Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11T1N','Tanker Pilot, T-38 ACE/CTP'),
('11T1P','Tanker Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11T1R','Tanker Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11T1S','Tanker Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11T1T','Tanker Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11T1U','Tanker Pilot, Air Liaison Officer (ALO)'),
('11T1Y','Tanker Pilot, General'),
('11T1Z','Tanker Pilot, Other'),
('11T2','Tanker Pilot'),
('11T2A','Tanker Pilot, KC-10'),
('11T2B','Tanker Pilot, KC-135'),
('11T2L','Tanker Pilot, C-12 Companion Trainer Program (CTP)'),
('11T2M','Tanker Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11T2N','Tanker Pilot, T-38 ACE/CTP'),
('11T2P','Tanker Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11T2R','Tanker Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11T2S','Tanker Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11T2T','Tanker Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11T2U','Tanker Pilot, Air Liaison Officer (ALO)'),
('11T2Y','Tanker Pilot, General'),
('11T2Z','Tanker Pilot, Other'),
('11T3','Tanker Pilot'),
('11T3A','Tanker Pilot, KC-10'),
('11T3B','Tanker Pilot, KC-135'),
('11T3L','Tanker Pilot, C-12 Companion Trainer Program (CTP)'),
('11T3M','Tanker Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11T3N','Tanker Pilot, T-38 ACE/CTP'),
('11T3P','Tanker Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11T3R','Tanker Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11T3S','Tanker Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11T3T','Tanker Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11T3U','Tanker Pilot, Air Liaison Officer (ALO)'),
('11T3Y','Tanker Pilot, General'),
('11T3Z','Tanker Pilot, Other'),
('11T4','Tanker Pilot'),
('11T4A','Tanker Pilot, KC-10'),
('11T4B','Tanker Pilot, KC-135'),
('11T4L','Tanker Pilot, C-12 Companion Trainer Program (CTP)'),
('11T4M','Tanker Pilot, T-37 Accelerated Copilot Enrichment (ACE)/Companion Trainer Program (CTP)'),
('11T4N','Tanker Pilot, T-38 ACE/CTP'),
('11T4P','Tanker Pilot, SUNT (T-1/T-2/T-34/T-38)'),
('11T4R','Tanker Pilot, Flight Screening Program (FSP) Instructor (T-3/T-41)'),
('11T4S','Tanker Pilot, SUPT Phase II Instr (T-34/T-37)'),
('11T4T','Tanker Pilot, SUPT Phase III Instr (T-1/ T-38/T-44)'),
('11T4U','Tanker Pilot, Air Liaison Officer (ALO)'),
('11T4Y','Tanker Pilot, General'),
('11T4Z','Tanker Pilot, Other'),
('1311','Pilot, Special Operations'),
('1313','Pilot, Special Operations'),
('1315','Pilot, Special Operations'),
('1321','Pilot, Elect. Warfare/Airborne Command & Control/Special Reconn.'),
('1323','Pilot, Elect. Warfare/Airborne Command & Control/Special Reconn.'),
('1325','Pilot, Elect. Warfare/Airborne Command & Control/Special Reconn.'),
('1331','Pilot, Strategic Reconnaissance'),
('1333','Pilot, Strategic Reconnaissance'),
('1335','Pilot, Strategic Reconnaissance'),
('1341','Pilot, Tactical Reconnaissance'),
('1343','Pilot, Tactical Reconnaissance'),
('1345','Pilot, Tactical Reconnaissance'),
('1351','Pilot, Flight Training Instructor'),
('1353','Pilot, Flight Training Instructor'),
('1355','Pilot, Flight Training Instructor'),
('13A1A','Astronaut, Pilot'),
('13A1M','Astronaut, RPA'),
('13A1N','Astronaut, ABM'),
('13A1P','Astronaut, Fighter'),
('13A1Q','Astronaut, Trainer'),
('13A1R','Astronaut, Bomber'),
('13A1S','Astronaut, Tanker'),
('13A1T','Astronaut, Airlift'),
('13A1V','Astronaut, Helicopter or EWO'),
('13A1W','Astronaut, General'),
('13A1Y','Astronaut, Special Operations'),
('13A1Z','Astronaut, C2ISREW'),
('13A3A','Astronaut, Pilot'),
('13A3M','Astronaut, RPA'),
('13A3N','Astronaut, ABM'),
('13A3P','Astronaut, Fighter'),
('13A3Q','Astronaut, Trainer'),
('13A3R','Astronaut, Bomber'),
('13A3S','Astronaut, Tanker'),
('13A3T','Astronaut, Airlift'),
('13A3V','Astronaut, Helicopter or EWO'),
('13A3W','Astronaut, General'),
('13A3Y','Astronaut, Special Operations'),
('13A3Z','Astronaut, C2ISREW'),
('2861','Experimental Test Pilot'),
('2865','Experimental Test Pilot'),
('7512','Pilot Fixed-Wing Transport Aircraft, KC-130J'),
('7550','Pilot VMGR Maritime Advanced (NATC)'),
('7551','Pilot VMR C-9 Qualified'),
('7552','Pilot VMGR, TC-4C Qualified'),
('7553','Pilot VMGR C-117'),
('7553','Pilot VMR C-20/C-37 Qualified'),
('7554','Pilot VMGR C-118'),
('7554','Pilot VMR UC-35 Qualified'),
('7555','Pilot VMR UC-12B Qualified'),
('7556','Pilot VMGR, KC-130 Co-Pilot (T2P/T3P)'),
('7557','Pilot VMGR, KC-130 Aircraft Commander'),
('7559','Pilot VT CT-39 Qualified'),
('7575','FRS Basic OV-10 Pilot'),
('7576','Pilot VMO'),
('7595','Test Pilot/Flight Test Project Officer'),
('7598','Basic Fixed Wing Pilot'),
('9973','Fixed-Wing Transport Aircraft Specialist KC-130J (Officer)'),
('7512','Pilot Fixed-Wing Transport Aircraft, KC-130J'),
('7595','Test Pilot/Flight Test Project Officer'),
('9973','Fixed-Wing Transport Aircraft Specialist KC-130J (Officer)'),
('8501','Aviator'),
('8518','Reconnaissance Attack Pilot'),
('8543','Instrument Flight Instructor-Pilot'),
('8561','Airborne Early Warning Pilot'),
('8562','Electronic Countermeasures Pilot'),
('8581','Photographic Pilot'),
('8583','Special Project Pilot'),
('8588','Test Pilot'),
('8592','Flight Instructor, Training Planes'),
('8593','Flight Instructor-Pilot, Fleet Operational Aircraft'),
('8596','Transport Plane Commander'),
('8597','Carrier On-Board Delivery Pilot'),
('8598','Transport Plane Copilot'),
('8599','Utility Pilot'),
('8501','Aviator'),
('8518','Reconnaissance Attack Pilot'),
('8543','Instrument Flight Instructor-Pilot'),
('8561','Airborne Early Warning Pilot'),
('8562','Electronic Countermeasures Pilot'),
('8581','Photographic Pilot'),
('8583','Special Project Pilot'),
('8588','Test Pilot'),
('8592','Flight Instructor, Training Planes'),
('8593','Flight Instructor-Pilot, Fleet Operational Aircraft'),
('8596','Transport Plane Commander'),
('8597','Carrier On-Board Delivery Pilot'),
('8598','Transport Plane Copilot'),
('8599','Utility Pilot'),
('131','URL - Aviation Warfare Officer, Pilot'),
('154','RL - Aviation Duty Officer - Pilot'),
('0073','Aeronautical Engineering/Test Pilot School (TPS)'),
('5403','Test Pilot'),
('qq73','Flight Performance/Test Pilot'),
('15A','Aviation, General'),
('15B','Aviation Combined Arms Operations'),
('15C','Aviation All-Source Intelligence'),
('15D','Aviation Logistics'),
('15E','Aviation, Tactical Communications'),
('15M','Aviation, Combat Intelligence'),
('15S','Aviation, Air Traffic Control'),
('15T','Aviation Logistics'),
('1981','Rotary Wing Aviation Unit Commander'),
('1987','Composite Aviation Unit Commander'),
('100A','Multiengine Utility Helicopter Pilot'),
('100B','Utility/Observation Helicopter Pilot'),
('100C','Cargo Helicopter Pilot'),
('100D','Heavy Lift Helicopter Pilot'),
('100E','Attack Helicopter Pilot'),
('100F','Pilot, OH-6'),
('100G','Pilot, OH-58'),
('100K','Multiengine Attack Helicopter Pilot')